JHide = LibStub("AceAddon-3.0"):NewAddon("JHide", "AceConsole-3.0", "AceEvent-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("JHide")
local AceConfigDialog = LibStub("AceConfigDialog-3.0")
local db

--Tables for storing runtime functions, addon names and button frames
local dicShow = {}
local dicHide = {}
local tblFunctions = {}
local dicButtons = {} --buttonx (x=1 to 4). Frames for button backlighting

local AddonLibrary = nil --Declared to use for Scripts tree

--Frames
local fraJHideMainAnchor = nil
local btnJHideOrbBase = nil
local fraJHideOrbRing = nil
local fraJHideOrbFill1 = nil
local fraJHideOrbFill2 = nil
local fraJHideOrbFill3 = nil
local fraJHideTopFrame = nil
local fraJHideLeftPretty = nil
local fraJHideRightPretty = nil
local fraButton1 = nil
local fraButton1Hover = nil
local btnButton1 = nil
local fraButton2 = nil
local fraButton2Hover = nil
local btnButton2 = nil
local fraButton3 = nil
local fraButton3Hover = nil
local btnButton3 = nil
local fraButton4 = nil
local fraButton4Hover = nil
local btnButton4 = nil

--Variables for saving inputs for adding addons
local addonName = nil
local addonShowScript = nil
local addonHideScript = nil

--Textures location
local fdir = "Interface\\Addons\\JHide\\textures\\myTextures\\"

local function hasKey(tblInput, key) --Returns true if key exists as a Key in the table
	for k, v in pairs(tblInput) do
		if k == key then
			return true
		end
	end
	return false
end

local function hasItem(tblInput, item)--Returns true if item exists as a value in the table
	for k, v in pairs(tblInput) do
		if tblInput[k] == item then
			return true
		end
	end
	return false
end

local defaults = { --Defaults Table
	profile = {
		Frames = {
			Button1Used = true,
			Button2Used = true,
			Button3Used = true,
			Button4Used = true,
			Button1Function = "omen",
			Button2Function = "recount",
			Button3Function = "monkeyquest",
			Button4Function = "grid",
			Button1CurrentState = false,
			Button2CurrentState = false,
			Button3CurrentState = false,
			Button4CurrentState = false,
			MainWindowX = -1,
			MainWindowY = 15,
			MainWindowPoint = "TOP",
			MainWindowRelativePoint = "TOP",
			MainWindowScale = 1,
			MainWindowLocked = false,			
			MainColourRed = 0.3,
			MainColourGreen = 0.3,
			MainColourBlue = 1,
			MainColourAlpha = 0.5,
			ButtonColourRed = 0.3,
			ButtonColourGreen = 0.3,
			ButtonColourBlue = 1,
			ButtonColourAlpha = 0.5,
			PrettyColourRed = 0,
			PrettyColourGreen = 0,
			PrettyColourBlue = 0,
			PrettyColourAlpha = 1,			
			UseButtonColours = false,
			
			
			ShowFunctionsDictionary = {["omen"] = "Omen.Anchor:Show()", ["recount"] = "Recount_MainWindow:Show()", ["grid"] = "GridLayoutFrame:SetAlpha(1)", ["monkeyquest"] = "MonkeyQuest_Show()"},
			HideFunctionsDictionary = {["omen"] = "Omen.Anchor:Hide()", ["recount"] = "Recount_MainWindow:Hide()", ["grid"] = "GridLayoutFrame:SetAlpha(0)", ["monkeyquest"] = "MonkeyQuest_Hide()"},
		},
	},
}

local function getOptions() --Creates Options table. (Based on LUI)
	if not JHide.options then
		JHide.options = {
			type = "group",
			name = "JHide",
			handler = JHide,
			args = {
				General = {
					name = L["General Options"],
					type = "group",
					order = 1,
					args = {
						MainLock = {
							name = "Lock Frame",
							desc = "Unlocks/Locks the Main Frame",
							type = "toggle",
							get = function() return db.Frames.MainWindowLocked end,
							set = function()
										db.Frames.MainWindowLocked = not db.Frames.MainWindowLocked
										JHide:CheckFrames()
									end,
							order = 1,
						},
						Reset = {
							order = 3,
							type = "execute",
							name = "Reset Main Frame",
							func = function()
								db.Frames.MainWindowPoint = "TOP"
								db.Frames.MainWindowRelativePoint =  "TOP"
								db.Frames.MainWindowX = -1
								db.Frames.MainWindowY = 15
							
								JHideMainAnchor:StopMovingOrSizing()		
								JHideMainAnchor:ClearAllPoints()
								JHideMainAnchor:SetPoint(db.Frames.MainWindowPoint, UIParent, db.Frames.MainWindowRelativePoint, db.Frames.MainWindowX, db.Frames.MainWindowY)
							end,
						},
						Scale = {
							order = 4,
							name = "Scale",
							desc = "Controls the scaling of the main window.",
							type = "range",
							min = 0.50, max = 2.00, step = 0.01,
							isPercent = false,
							get = function() return db.Frames.MainWindowScale end,
							set = function(info, value)
								db.Frames.MainWindowScale = value
								JHide:doRescale()
							end,
						},	
					},
				},
				Buttons = {
					name = "Buttons",
					type = "group",
					order = 3,
					childGroups = "tab",
					args = {
						header3 = {
							name = "Buttons",
							type = "header",
							order = 1,
						},
						Button1Settings = {
							name = "Button1 Settings",
							type = "group",
							order = 2,
							args = {
								Button1Enabled = {
									name = "Enabled",
									desc = "Toggles Button 1 on or off",
									type = "toggle",
									get = function() return db.Frames.Button1Used end,
									set = function()
												db.Frames.Button1Used = not db.Frames.Button1Used
												JHide:CheckFrames()
											end,
									order = 0,
								},
								Button1Function = {
									name = "Button 1 Function",
									desc = "Choose Function the Button uses",
									type = "select",
									values = tblFunctions,
									get = function()
											for k, v in pairs(tblFunctions) do
												if db.Frames.Button1Function == v then
													return k
												end
											end
										end,
									set = function(self, tblFunctionsDropDown)
											db.Frames.Button1Function = tblFunctions[tblFunctionsDropDown]
											if not IsAddOnLoaded(tblFunctions[tblFunctionsDropDown]) then
												print ("Warning addon: " .. tblFunctions[tblFunctionsDropDown] .. " can not be found. Button disabled")
											end
											JHide:CheckFrames()
										end,
									order = 1,
								},
							},
						},
						Button2Settings = {
							name = "Button2 Settings",
							type = "group",
							order = 3,
							args = {
								Button2Enabled = {
									name = "Enabled",
									desc = "Toggles Button 2 on or off",
									type = "toggle",
									get = function() return db.Frames.Button2Used end,
									set = function()
												db.Frames.Button2Used = not db.Frames.Button2Used
												JHide:CheckFrames()
											end,
									order = 0,
								},
								Button2Function = {
									name = "Button 2 Function",
									desc = "Choose Function the Button uses",
									type = "select",
									values = tblFunctions,
									get = function()
											for k, v in pairs(tblFunctions) do
												if db.Frames.Button2Function == v then
													return k
												end
											end
										end,
									set = function(self, tblFunctionsDropDown)
											db.Frames.Button2Function = tblFunctions[tblFunctionsDropDown]
											if not IsAddOnLoaded(tblFunctions[tblFunctionsDropDown]) then
												print ("Warning addon: " .. tblFunctions[tblFunctionsDropDown] .. " can not be found. Button disabled")
											end
											JHide:CheckFrames()
										end,
									order = 1,
								},
							},
						},
						Button3Settings = {
							name = "Button3 Settings",
							type = "group",
							order = 4,
							args = {
								Button3Enabled = {
									name = "Enabled",
									desc = "Toggles Button 3 on or off",
									type = "toggle",
									get = function() return db.Frames.Button3Used end,
									set = function()
												db.Frames.Button3Used = not db.Frames.Button3Used
												JHide:CheckFrames()
											end,
									order = 0,
								},
								Button3Function = {
									name = "Button 3 Function",
									desc = "Choose Function the Button uses",
									type = "select",
									values = tblFunctions,
									get = function()
											for k, v in pairs(tblFunctions) do
												if db.Frames.Button3Function == v then
													return k
												end
											end
										end,
									set = function(self, tblFunctionsDropDown)
											db.Frames.Button3Function = tblFunctions[tblFunctionsDropDown]
											if not IsAddOnLoaded(tblFunctions[tblFunctionsDropDown]) then
												print ("Warning addon: " .. tblFunctions[tblFunctionsDropDown] .. " can not be found. Button disabled")
											end
											JHide:CheckFrames()
										end,
									order = 1,
								},
							},
						},
						Button4Settings = {
							name = "Button4 Settings",
							type = "group",
							order = 5,
							args = {
								Button4Enabled = {
									name = "Enabled",
									desc = "Toggles Button 4 on or off",
									type = "toggle",
									get = function() return db.Frames.Button4Used end,
									set = function()
												db.Frames.Button4Used = not db.Frames.Button4Used
												JHide:CheckFrames()
											end,
									order = 0,
								},
								Button4Function = {
									name = "Button 4 Function",
									desc = "Choose Function the Button uses",
									type = "select",
									values = tblFunctions,
									get = function()
											for k, v in pairs(tblFunctions) do
												if db.Frames.Button4Function == v then
													return k
												end
											end
										end,
									set = function(self, tblFunctionsDropDown)
											db.Frames.Button4Function = tblFunctions[tblFunctionsDropDown]
											if not IsAddOnLoaded(tblFunctions[tblFunctionsDropDown]) then
												print ("Warning addon: " .. tblFunctions[tblFunctionsDropDown] .. " can not be found. Button disabled")
											end
											JHide:CheckFrames()
										end,
									order = 1,
								},
							},
						},
					},
				},	
				ColourOptions = {
					name = L["Colour Options"],
					type = "group",
					order = 2,
					args = {		
						FillColor = {
							name = "JHide Main Colour",
							desc = "Sets the color for the UI",
							type = "color",
							width = "full",
							hasAlpha = true,
							get = function() return db.Frames.MainColourRed, db.Frames.MainColourGreen, db.Frames.MainColourBlue, db.Frames.MainColourAlpha end,
							set = function(_,r,g,b,a)
									db.Frames.MainColourRed = r
									db.Frames.MainColourGreen = g
									db.Frames.MainColourBlue = b
									db.Frames.MainColourAlpha = a
									JHide:doColourChange()
								end,
							order = 1,
						},
						empty1 = {
							name = "   ",
							width = "full",
							type = "description",
							order = 2,
						},
						ButtonColours = {
							name = "Enable Custom Button Colours",
							desc = "Toggles Custom Button Colours on or off",
							width = "full",
							type = "toggle",
							get = function() return db.Frames.UseButtonColours end,
							set = function()
										db.Frames.UseButtonColours = not db.Frames.UseButtonColours
										JHide:doColourChange()
									end,
							order = 3,
						},
						ButtonFillColour = {
							name = "Button Colours",
							desc = "Sets the color for the Buttons",
							type = "color",
							disabled = function() return not db.Frames.UseButtonColours end,
							width = "full",
							hasAlpha = true,
							get = function() return db.Frames.ButtonColourRed, db.Frames.ButtonColourGreen, db.Frames.ButtonColourBlue, db.Frames.ButtonColourAlpha end,
							set = function(_,r,g,b,a)
									db.Frames.ButtonColourRed = r
									db.Frames.ButtonColourGreen = g
									db.Frames.ButtonColourBlue = b
									db.Frames.ButtonColourAlpha = a
									JHide:doColourChange()
								end,
							order = 4,
						},
						PrettyColour = {
							name = "Side Graphic Border Colour",
							desc = "Sets the Border colour for the Side Graphics",
							type = "color",
							width = "full",
							hasAlpha = true,
							get = function() return db.Frames.PrettyColourRed, db.Frames.PrettyColourGreen, db.Frames.PrettyColourBlue, db.Frames.PrettyColourAlpha end,
							set = function(_,r,g,b,a)
									db.Frames.PrettyColourRed = r
									db.Frames.PrettyColourGreen = g
									db.Frames.PrettyColourBlue = b
									db.Frames.PrettyColourAlpha = a
									JHide:doColourChange()
								end,
							order = 5,
						},
						
					},
				},
				Scripts = {
					type = "group",
					name = "Addon Scripts",
					childGroups = "tree",
					order = 2,
					args = {
						createAsset = {
							type = "group",
							name = "Add New Addon",
							guiInline = true,
							order = 0,
							args = {
								assetName = {
									type = "input",
									name = "Addon Name",
									desc = "Addon Name as found by IsAddOnLoaded()",
									set = function(info,val) addonName = val end,
									get = function() return addonName end, 
									order = 0,
								},
								assetShow = {
									type = "input",
									name = "Show Function",
									desc = "Show function as full. ie Omen.Anchor:Show()",
									width = "full",
									set = function(info,val) addonShowScript = val end,
									get = function() return addonShowScript end,
									order = 2,
								},
								assetHide = {
									type = "input",
									name = "Hide Function",
									desc = "Hide function as full. ie Omen.Anchor:Hide()",
									width = "full",
									set = function(info,val) addonHideScript = val end,
									get = function() return addonHideScript end,
									order = 4,
								},
								create = {
									type = 'execute',
									name = "Add",
									desc = "Create a new Addon Script",
									order = 20,
									func = function() 
										JHide:AddAddon(addonName, addonShowScript, addonHideScript)
										addonName = nil
										addonShowScript = nil
										addonHideScript = nil 
									end,
									disabled = function() 
										return addonName == nil or addonShowScript == nil or addonHideScript == nil or strlen(addonName) < 1 or strlen(addonShowScript) < 1 or strlen(addonHideScript) < 1 
									end,
									confirm = function()
										if hasItem(tblFunctions, addonName) == true then
											return true
										end
										return false
									end,
									confirmText = "Addon already added. Overwrite?",
								},
							},
						},
					},
				},
			},
		}
		JHide.options.args.profiles = LibStub("AceDBOptions-3.0"):GetOptionsTable(JHide.db)
		JHide.options.args.profiles.order = 9
	end
	return JHide.options
	
end

local function doCreateDictionary() --Loads saved variables into runtime tables
	for k, v in pairs(db.Frames.ShowFunctionsDictionary) do
		dicShow[k] = loadstring(v)
		table.insert(tblFunctions,k)
	end
	for k, v in pairs(db.Frames.HideFunctionsDictionary) do
		dicHide[k] = loadstring(v)
	end	
end

local function doChangeButtonState(blnEnabled,keyButton) --Changes a buttons state and colour
	if blnEnabled == true then
		dicButtons[keyButton]:SetAlpha(0)
	else
		dicButtons[keyButton]:SetAlpha(1)
	end
	if keyButton == "button1" then
		db.Frames.Button1CurrentState = not blnEnabled
	elseif keyButton == "button2" then
		db.Frames.Button2CurrentState = not blnEnabled
	elseif keyButton == "button3" then
		db.Frames.Button3CurrentState = not blnEnabled
	elseif keyButton == "button4" then
		db.Frames.Button4CurrentState = not blnEnabled
	end
end

local function doAddonChange(blnVisible, strAddonTag) --Calls an addons show or hide function. With error catching. Some no longer needed
	if IsAddOnLoaded(strAddonTag) then
		if blnVisible == true then
			if hasKey(dicShow, strAddonTag) == true then 
				local retOK, ret1 = pcall(dicShow[strAddonTag])
				if not retOK then
					print ("Error: Addon - " .. strAddonTag .. " has a show script that failed to call correctly")
				end
			else
				print ("Error: Addon - " .. strAddonTag .. " not added correctly!")
			end
		else
			if hasKey(dicHide, strAddonTag) == true then 
				local retOK, ret1 = pcall(dicHide[strAddonTag])
				if not retOK then
					print ("Error: Addon - " .. strAddonTag .. " has a hide script that failed to call correctly")
				end
			else
				print ("Error: Addon - " .. strAddonTag .. " not added correctly!")
			end
		end
	else
		print ("Error: Addon - " .. strAddonTag .. " not loaded!")
	end
end

function JHide:OnInitialize() --Called when the addon is loaded
	self.db = LibStub("AceDB-3.0"):New("JHideDB", defaults, true)
	--db_ = self.db.profile
	db = self.db.profile
	
	self:SetupOptions()
end
	
function JHide:OnEnable() --Called when the addon is enabled
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	
	doCreateDictionary()	
	self:SetColours()
	self:SetupTopBar()
	self:doRescale()

	self:CreateAddonTree()
end

function JHide:PLAYER_ENTERING_WORLD(...)
	self:CheckFrames()
end

function JHide:SetupOptions() --Creates options and sets the AddonLibrary variable. Registers chat commands
	AddonLibrary = getOptions()
	LibStub("AceConfig-3.0"):RegisterOptionsTable("JHide", AddonLibrary)
	
	AceConfigDialog:SetDefaultSize("JHide", 680,525)
	self:RegisterChatCommand( "jh", "ChatCommand")
	self:RegisterChatCommand( "jhide", "ChatCommand")
end

function JHide:ChatCommand(input) --Handles chat commands
	if not input or input:trim() == "" then
		LibStub("AceConfigDialog-3.0"):Open("JHide")
	else
		LibStub("AceConfigCmd-3.0").HandleCommand(JHide, "JHide", "JHide", input)
	end
end

function JHide:doColourChange() --Changes the addons colours on the fly as changed
	fraJHideLeftPretty:SetBackdropColor(db.Frames.PrettyColourRed, db.Frames.PrettyColourGreen, db.Frames.PrettyColourBlue, db.Frames.PrettyColourAlpha)
	fraJHideRightPretty:SetBackdropColor(db.Frames.PrettyColourRed, db.Frames.PrettyColourGreen, db.Frames.PrettyColourBlue, db.Frames.PrettyColourAlpha)
		
	JHide:SetColours()
	
	if db.Frames.Button1CurrentState == true and db.Frames.Button2CurrentState == true and db.Frames.Button3CurrentState == true and db.Frames.Button4CurrentState == true then
		btnJHideOrbBase:SetBackdropColor(top_r, top_g, top_b, 1)
		fraJHideOrbFill1:SetBackdropColor(top_r,top_g,top_b,off_a)
		fraJHideOrbFill2:SetBackdropColor(top_r,top_g,top_b,off_a)
		fraJHideOrbFill3:SetBackdropColor(top_r,top_g,top_b,off_a)
	else
		btnJHideOrbBase:SetBackdropColor(off_r, off_g, off_b, 1)
		fraJHideOrbFill1:SetBackdropColor(off_r, off_g, off_b, off_a)
		fraJHideOrbFill2:SetBackdropColor(off_r, off_g, off_b, off_a)
		fraJHideOrbFill3:SetBackdropColor(off_r, off_g, off_b, off_a)
	end
		
	fraButton1:SetBackdropColor(button_r, button_g, button_b, button_a)
	fraButton1Hover:SetBackdropColor(button_r, button_g, button_b, button_a)
	fraButton2:SetBackdropColor(button_r, button_g, button_b, button_a)
	fraButton2Hover:SetBackdropColor(button_r, button_g, button_b, button_a)
	fraButton3:SetBackdropColor(button_r, button_g, button_b, button_a)
	fraButton3Hover:SetBackdropColor(button_r, button_g, button_b, button_a)
	fraButton4:SetBackdropColor(button_r, button_g, button_b, button_a)
	fraButton4Hover:SetBackdropColor(button_r, button_g, button_b, button_a)
	
		
end

function JHide:doRescale() --Rescales the frames
	fraJHideMainAnchor:SetScale(db.Frames.MainWindowScale)
	btnJHideOrbBase:SetScale(db.Frames.MainWindowScale)
end

function JHide:SetColours() --Sets up colours for the addon. (Based on LUI)
	color_r = db.Frames.MainColourRed
	color_g = db.Frames.MainColourGreen
	color_b = db.Frames.MainColourBlue
	color_a = db.Frames.MainColourAlpha

	top_r = color_r
	top_g = color_g
	top_b = color_b
	top_a = color_a
	
	off_r = 0.25
	off_g = 0.25
	off_b = 0.25
	off_a = 0.4
		
	if db.Frames.UseButtonColours == true then
		button_r = db.Frames.ButtonColourRed
		button_g = db.Frames.ButtonColourGreen
		button_b = db.Frames.ButtonColourBlue
		button_a = db.Frames.ButtonColourAlpha
	else
		button_r = color_r
		button_g = color_g
		button_b = color_b
		button_a = color_a
	end
end
	
function JHide:doCreateFrame(strType,strName,fraParent,intWidth,intHeight,intScale,strStrata,intLevel,strPoint,fraRelativeFrame,strRelativePoint,intOffsetX,intOffsetY,intAlpha,finherit) --Creates a Frame (Based on LUI)
	local f = CreateFrame(strType,strName,fraParent,finherit)
	
	f:SetWidth(intWidth)
	f:SetHeight(intHeight)
	f:SetFrameStrata(strStrata)
	f:SetFrameLevel(intLevel)
	f:SetPoint(strPoint,fraRelativeFrame,strRelativePoint,intOffsetX,intOffsetY)
	f:SetAlpha(intAlpha)
	return f  
end 

function JHide:doCreateOrb() --Creates Orb Frames and Butto/ Events etc(Was based on LUI)
	fraJHideMainAnchor = self:doCreateFrame("FRAME","JHideMainAnchor",UIParent,174,80,1,"BACKGROUND",1, db.Frames.MainWindowPoint, UIParent, db.Frames.MainWindowRelativePoint, db.Frames.MainWindowX, db.Frames.MainWindowY,1)
	fraJHideMainAnchor:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 16,	edgeFile = "Interface\\Tooltips\\UI-Tooltip-Border", edgeSize = 16,	insets = {left = 5, right = 3, top = 3, bottom = 5}})
	fraJHideMainAnchor:SetMovable(true)
	fraJHideMainAnchor:SetClampedToScreen(true)
	fraJHideMainAnchor:RegisterForDrag("LeftButton")
	fraJHideMainAnchor:SetScript("OnDragStart", fraJHideMainAnchor.StartMoving)
	fraJHideMainAnchor:SetScript("OnDragStop",  function(self)
		fraJHideMainAnchor:StopMovingOrSizing()
		strPoint, tempB, strRelativePoint, intPosX, intPosY = fraJHideMainAnchor:GetPoint()
		db.Frames.MainWindowPoint = strPoint
		db.Frames.MainWindowRelativePoint = strRelativePoint
		db.Frames.MainWindowX = intPosX
		db.Frames.MainWindowY = intPosY
	end)

	btnJHideOrbBase = self:doCreateFrame("BUTTON","JHideOrb",UIParent,64,64,1,"BACKGROUND",3,"CENTER",JHideMainAnchor,"CENTER",0,0,1)
	btnJHideOrbBase:SetBackdrop({bgFile=fdir.."orb_back.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=0, right=0, top=0, bottom=0}})
	btnJHideOrbBase:SetBackdropBorderColor(0,0,0,0)
	btnJHideOrbBase:SetBackdropColor(top_r,top_g,top_b,1)
	btnJHideOrbBase:Show()
	
	fraJHideOrbRing = self:doCreateFrame("FRAME","JHideOrbRing",JHideOrb,80,80,1,"BACKGROUND",1,"CENTER",JHideOrb,"CENTER",0,0,1)
	fraJHideOrbRing:SetBackdrop({bgFile="Interface\\SpellShadow\\Spell-Shadow-Acceptable.blp", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=0, right=0, top=0, bottom=0}})
	fraJHideOrbRing:SetBackdropBorderColor(0,0,0,0)
	fraJHideOrbRing:SetBackdropColor(0,0,0,1)
	fraJHideOrbRing:Show()
	
	fraJHideOrbFill1 = self:doCreateFrame("FRAME","JHideOrbFill1",JHideOrb,64,64,1,"BACKGROUND",4,"CENTER",JHideOrb,"CENTER",0,0,1)
	fraJHideOrbFill1:SetBackdrop({bgFile=fdir.."orb_fill.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=0, right=0, top=0, bottom=0}})
	fraJHideOrbFill1:SetBackdropBorderColor(0,0,0,0)
	fraJHideOrbFill1:SetBackdropColor(top_r,top_g,top_b,top_a)
	fraJHideOrbFill1:Show()
	
	fraJHideOrbFill2 = self:doCreateFrame("FRAME","JHideOrbFill2",JHideOrb,64,64,1,"BACKGROUND",4,"CENTER",JHideOrb,"CENTER",0,0,1)
	fraJHideOrbFill2:SetBackdrop({bgFile=fdir.."orb_fill.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=0, right=0, top=0, bottom=0}})
	fraJHideOrbFill2:SetBackdropBorderColor(0,0,0,0)
	fraJHideOrbFill2:SetBackdropColor(top_r,top_g,top_b,top_a)
	fraJHideOrbFill2:Show()
	
	fraJHideOrbFill3 = self:doCreateFrame("FRAME","JHideOrbFill3",JHideOrb,64,64,1,"BACKGROUND",4,"CENTER",JHideOrb,"CENTER",0,0,1)
	fraJHideOrbFill3:SetBackdrop({bgFile=fdir.."orb_fill.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=0, right=0, top=0, bottom=0}})
	fraJHideOrbFill3:SetBackdropBorderColor(0,0,0,0)
	fraJHideOrbFill3:SetBackdropColor(top_r,top_g,top_b,top_a)
	fraJHideOrbFill3:Show()
	
	local aniGOrb1 = fraJHideOrbFill1:CreateAnimationGroup()
	local aniGOrb2 = fraJHideOrbFill2:CreateAnimationGroup()
	local aniGOrb3 = fraJHideOrbFill3:CreateAnimationGroup()
	local aniGOrb4 = fraJHideOrbRing:CreateAnimationGroup()
		
	local aniOrb1 = aniGOrb1:CreateAnimation("Rotation")
	aniOrb1:SetDuration(11)
	aniOrb1:SetDegrees(-360)
	aniOrb1:SetSmoothing("IN_OUT")

	local aniOrb2 = aniGOrb2:CreateAnimation("Rotation")
	aniOrb2:SetDuration(13)
	aniOrb2:SetDegrees(-360)
	aniOrb2:SetSmoothing("IN_OUT")

	local aniOrb3 = aniGOrb3:CreateAnimation("Rotation")
	aniOrb3:SetDuration(19)
	aniOrb3:SetDegrees(360)
	aniOrb3:SetSmoothing("IN_OUT")
	
	local aniOrb4 = aniGOrb4:CreateAnimation("Rotation")
	aniOrb4:SetDuration(30)
	aniOrb4:SetDegrees(360)
	aniOrb4:SetSmoothing("IN_OUT")
	
	aniOrb1:Play()
	aniOrb2:Play()
	aniOrb3:Play()
	aniOrb4:Play()
	
	aniGOrb1:SetScript("OnFinished",function()	
		aniOrb1:Play()
	end)
	aniGOrb2:SetScript("OnFinished",function()	
		aniOrb2:Play()
	end)	
	aniGOrb3:SetScript("OnFinished",function()	
		aniOrb3:Play()
	end)	
	aniGOrb4:SetScript("OnFinished",function()	
		aniOrb4:Play()
	end)
end

function JHide:SetupTopBar() --Calls doCreateOrb. Then creates Top Frame and Buttons/Button Events etc(Was based on LUI)
	self:doCreateOrb()
	
	fraJHideTopFrame = self:doCreateFrame("FRAME","JHideTopFrame",JHideOrb,256,64,1,"BACKGROUND",2,"CENTER",JHideOrb,"CENTER",0,0,1)
	fraJHideTopFrame:SetBackdrop({bgFile=fdir.."topbar.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=0, right=0, top=0, bottom=0}})
	fraJHideTopFrame:SetBackdropBorderColor(0,0,0,0)
	fraJHideTopFrame:Show()
	
	fraJHideLeftPretty = self:doCreateFrame("FRAME","JHideLeftPretty",JHideOrb,90,90,1,"BACKGROUND",1,"CENTER",JHideOrb,"CENTER",-85,0,1)
	fraJHideLeftPretty:SetBackdrop({bgFile=fdir.."left_pretty.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=0, right=0, top=0, bottom=0}})
	fraJHideLeftPretty:SetBackdropBorderColor(0,0,0,0)
	fraJHideLeftPretty:SetBackdropColor(0,0,0,1)
	fraJHideLeftPretty:Show()

	fraJHideRightPretty = self:doCreateFrame("FRAME","JHideRightPretty",JHideOrb,90,90,1,"BACKGROUND",1,"CENTER",JHideOrb,"CENTER",85,0,1)
	fraJHideRightPretty:SetBackdrop({bgFile=fdir.."right_pretty.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=0, right=0, top=0, bottom=0}})
	fraJHideRightPretty:SetBackdropBorderColor(0,0,0,0)
	fraJHideRightPretty:SetBackdropColor(0,0,0,1)
	fraJHideRightPretty:Show()
	

	----------------------------------------------------------------------------------------------------------------------
	--													BUTTON 1
	----------------------------------------------------------------------------------------------------------------------
	fraButton1 = self:doCreateFrame("FRAME","Frame_Button1",JHideOrb,63,67,1,"LOW",1,"LEFT",JHideOrb,"LEFT",-63,34,0)
	fraButton1:SetBackdrop({bgFile=fdir.."btn_l1.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	fraButton1:SetBackdropColor(button_r,button_g,button_b,button_a)
	fraButton1:SetBackdropBorderColor(0,0,0,0)
	fraButton1:Show()
	
	dicButtons["button1"] = fraButton1
	
	fraButton1Hover = self:doCreateFrame("FRAME","Frame_Button1_Hover",JHideOrb,63,60,1,"LOW",1,"CENTER",Frame_Button1,"CENTER",-1,-2,0)
	fraButton1Hover:SetBackdrop({bgFile=fdir.."btn_l1_hover.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	fraButton1Hover:SetBackdropColor(button_r,button_g,button_b,button_a)
	fraButton1Hover:SetBackdropBorderColor(0,0,0,0)
	fraButton1Hover:Show()

	btnButton1 = self:doCreateFrame("BUTTON","Button_Button1",JHideOrb,63,20,1,"LOW",2,"CENTER",Frame_Button1,"CENTER",0,-18,0)
	btnButton1:SetBackdrop({bgFile=fdir.."btn_anchor.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	btnButton1:SetBackdropBorderColor(0,0,0,0)
	btnButton1:Show()
	
	btnButton1:RegisterForClicks("AnyUp")
	btnButton1:SetScript("OnClick", function(self)
		if db.Frames.Button1Used == true and IsAddOnLoaded(db.Frames.Button1Function) and hasItem(tblFunctions, db.Frames.Button1Function) then
			if db.Frames.Button1CurrentState == false then
				db.Frames.Button1CurrentState = true
				fraButton1:SetAlpha(1)
				doAddonChange(true, db.Frames.Button1Function)
			else
				db.Frames.Button1CurrentState = false
				fraButton1:SetAlpha(0)
				doAddonChange(false, db.Frames.Button1Function)
			end
		end
	end)

	btnButton1:SetScript("OnEnter", function(self)
		if db.Frames.Button1Used == true and IsAddOnLoaded(db.Frames.Button1Function) and hasItem(tblFunctions, db.Frames.Button1Function) then
			fraButton1Hover:SetAlpha(1)
		end
	end)

	btnButton1:SetScript("OnLeave", function(self)
		fraButton1Hover:SetAlpha(0)
	end)
	
	if db.Frames.Button1Used == true and IsAddOnLoaded(db.Frames.Button1Function) and hasItem(tblFunctions, db.Frames.Button1Function) then
		fraButton1:SetAlpha(0)
	else
		fraButton1:SetAlpha(1)
		fraButton1Hover:SetAlpha(0)
		db.Frames.Button1CurrentState = true
	end
	----------------------------------------------------------------------------------------------------------------------
	--													BUTTON 2
	----------------------------------------------------------------------------------------------------------------------
	fraButton2 = self:doCreateFrame("FRAME","Frame_Button2",JHideOrb,63,67,1,"LOW",1,"LEFT",JHideOrb,"LEFT",64,37,0)
	fraButton2:SetBackdrop({bgFile=fdir.."btn_r1.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	fraButton2:SetBackdropColor(button_r,button_g,button_b,button_a)
	fraButton2:SetBackdropBorderColor(0,0,0,0)
	fraButton2:Show()
	
	dicButtons["button2"] = fraButton2
	
	fraButton2Hover = self:doCreateFrame("FRAME","Frame_Button2_Hover",JHideOrb,63,60,1,"LOW",1,"CENTER",Frame_Button2,"CENTER",0,-2,0)
	fraButton2Hover:SetBackdrop({bgFile=fdir.."btn_r1_hover.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	fraButton2Hover:SetBackdropColor(button_r,button_g,button_b,button_a)
	fraButton2Hover:SetBackdropBorderColor(0,0,0,0)
	fraButton2Hover:Show()
	
	btnButton2 = self:doCreateFrame("BUTTON","Button_Button2",JHideOrb,63,20,1,"LOW",2,"CENTER",Frame_Button2,"CENTER",0,-21,0)
	btnButton2:SetBackdrop({bgFile=fdir.."btn_anchor.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	btnButton2:SetBackdropBorderColor(0,0,0,0)
	btnButton2:Show()
	
	btnButton2:RegisterForClicks("AnyUp")
	btnButton2:SetScript("OnClick", function(self)
		if db.Frames.Button2Used == true and IsAddOnLoaded(db.Frames.Button2Function) and hasItem(tblFunctions, db.Frames.Button2Function) then
			if db.Frames.Button2CurrentState == false then
				db.Frames.Button2CurrentState = true
				fraButton2:SetAlpha(1)
				doAddonChange(true, db.Frames.Button2Function)
			else
				db.Frames.Button2CurrentState = false
				fraButton2:SetAlpha(0)
				doAddonChange(false, db.Frames.Button2Function)
			end
		end
	end)
	
	btnButton2:SetScript("OnEnter", function(self)
		if db.Frames.Button2Used == true and IsAddOnLoaded(db.Frames.Button2Function) and hasItem(tblFunctions, db.Frames.Button2Function) then
			fraButton2Hover:SetAlpha(1)
		end
	end)
	
	btnButton2:SetScript("OnLeave", function(self)
		fraButton2Hover:SetAlpha(0)
	end)

	if db.Frames.Button2Used == true and IsAddOnLoaded(db.Frames.Button2Function) and hasItem(tblFunctions, db.Frames.Button2Function) then
		fraButton2:SetAlpha(0)
	else
		fraButton2:SetAlpha(1)
		fraButton2Hover:SetAlpha(0)
		db.Frames.Button2CurrentState = true
	end
	
	
	----------------------------------------------------------------------------------------------------------------------
	--													BUTTON 3
	----------------------------------------------------------------------------------------------------------------------
	fraButton3 = self:doCreateFrame("FRAME","Frame_Button3",JHideOrb,63,67,1,"LOW",1,"LEFT",JHideOrb,"LEFT",-63,-36,0)
	fraButton3:SetBackdrop({bgFile=fdir.."btn_l1a.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	fraButton3:SetBackdropColor(button_r,button_g,button_b,button_a)
	fraButton3:SetBackdropBorderColor(0,0,0,0)
	fraButton3:Show()
	
	dicButtons["button3"] = fraButton3

	fraButton3Hover = self:doCreateFrame("FRAME","Frame_Button3_Hover",JHideOrb,63,60,1,"LOW",1,"CENTER",Frame_Button3,"CENTER",0,2,0)
	fraButton3Hover:SetBackdrop({bgFile=fdir.."btn_l1a_hover.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	fraButton3Hover:SetBackdropColor(button_r,button_g,button_b,button_a)
	fraButton3Hover:SetBackdropBorderColor(0,0,0,0)
	fraButton3Hover:Show()
	
	btnButton3 = self:doCreateFrame("BUTTON","Button_Button3",JHideOrb,63,20,1,"LOW",2,"CENTER",Frame_Button3,"CENTER",0,18,0)
	btnButton3:SetBackdrop({bgFile=fdir.."btn_anchor.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	btnButton3:SetBackdropBorderColor(0,0,0,0)
	btnButton3:Show()


	btnButton3:RegisterForClicks("AnyUp")
	btnButton3:SetScript("OnClick", function(self)
		if db.Frames.Button3Used == true and IsAddOnLoaded(db.Frames.Button3Function) and hasItem(tblFunctions, db.Frames.Button3Function) then
			if db.Frames.Button3CurrentState == false then
				db.Frames.Button3CurrentState = true
				fraButton3:SetAlpha(1)
				doAddonChange(true, db.Frames.Button3Function)
			else
				db.Frames.Button3CurrentState = false
				fraButton3:SetAlpha(0)
				doAddonChange(false, db.Frames.Button3Function)
			end
		end
	end)
	
	btnButton3:SetScript("OnEnter", function(self)
		if db.Frames.Button3Used == true and IsAddOnLoaded(db.Frames.Button3Function) and hasItem(tblFunctions, db.Frames.Button3Function) then
			fraButton3Hover:SetAlpha(1)
		end
	end)
	
	btnButton3:SetScript("OnLeave", function(self)
		fraButton3Hover:SetAlpha(0)
	end)
	
	if db.Frames.Button3Used == true and IsAddOnLoaded(db.Frames.Button3Function) and hasItem(tblFunctions, db.Frames.Button3Function) then
		fraButton3:SetAlpha(0)
	else
		fraButton3:SetAlpha(1)
		fraButton3Hover:SetAlpha(0)
		db.Frames.Button3CurrentState = true
	end
	----------------------------------------------------------------------------------------------------------------------
	--													BUTTON 4
	----------------------------------------------------------------------------------------------------------------------
	fraButton4 = self:doCreateFrame("FRAME","Frame_Button4",JHideOrb,63,67,1,"LOW",1,"LEFT",JHideOrb,"LEFT",64,-39,0)
	fraButton4:SetBackdrop({bgFile=fdir.."btn_r1a.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	fraButton4:SetBackdropColor(button_r,button_g,button_b,button_a)
	fraButton4:SetBackdropBorderColor(0,0,0,0)
	fraButton4:Show()
	
	dicButtons["button4"] = fraButton4

	fraButton4Hover = self:doCreateFrame("FRAME","Frame_Button4_Hover",JHideOrb,63,60,1,"LOW",1,"CENTER",Frame_Button4,"CENTER",0,2,0)
	fraButton4Hover:SetBackdrop({bgFile=fdir.."btn_r1a_hover.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	fraButton4Hover:SetBackdropColor(button_r,button_g,button_b,button_a)
	fraButton4Hover:SetBackdropBorderColor(0,0,0,0)
	fraButton4Hover:Show()
	
	btnButton4 = self:doCreateFrame("BUTTON","Button_Button4",JHideOrb,63,20,1,"LOW",2,"CENTER",Frame_Button4,"CENTER",0,21,0)
	btnButton4:SetBackdrop({bgFile=fdir.."btn_anchor.tga", edgeFile="Interface\\Tooltips\\UI-Tooltip-Border", tile=0, tileSize=0, edgeSize=1, insets={left=-0, right=0, top=0, bottom=0}})
	btnButton4:SetBackdropBorderColor(0,0,0,0)
	btnButton4:Show()

	btnButton4:RegisterForClicks("AnyUp")
	btnButton4:SetScript("OnClick", function(self)
		if db.Frames.Button4Used == true and IsAddOnLoaded(db.Frames.Button4Function) and hasItem(tblFunctions, db.Frames.Button4Function) then
			if db.Frames.Button4CurrentState == false then
				db.Frames.Button4CurrentState = true
				fraButton4:SetAlpha(1)
				doAddonChange(true, db.Frames.Button4Function)
			else
				db.Frames.Button4CurrentState = false
				fraButton4:SetAlpha(0)
				doAddonChange(false, db.Frames.Button4Function)
			end
		end
	end)
	
	btnButton4:SetScript("OnEnter", function(self)
		if db.Frames.Button4Used == true and IsAddOnLoaded(db.Frames.Button4Function) and hasItem(tblFunctions, db.Frames.Button4Function) then
			fraButton4Hover:SetAlpha(1)
		end
	end)
	
	btnButton4:SetScript("OnLeave", function(self)
		fraButton4Hover:SetAlpha(0)
	end)
	
	if db.Frames.Button4Used == true and IsAddOnLoaded(db.Frames.Button4Function) and hasItem(tblFunctions, db.Frames.Button4Function) then
		fraButton4:SetAlpha(0)
	else
		fraButton4:SetAlpha(1)
		fraButton4Hover:SetAlpha(0)
		db.Frames.Button4CurrentState = true
	end
	
	
	----------------------------------------------------------------------------------------------
	JHideOrb:RegisterForClicks("AnyUp")
	JHideOrb:SetScript("OnClick", function(self)
		local intShownState = 1  --1 = All Shown, 2 = Mixed/Hidden
		
		if db.Frames.Button1CurrentState == true and db.Frames.Button2CurrentState == true and db.Frames.Button3CurrentState == true and db.Frames.Button4CurrentState == true then
			intShownState = 1
			fraJHideOrbFill1:SetBackdropColor(off_r, off_g, off_b, off_a)
			fraJHideOrbFill2:SetBackdropColor(off_r, off_g, off_b, off_a)
			fraJHideOrbFill3:SetBackdropColor(off_r, off_g, off_b, off_a)
		else
			intShownState = 2
			fraJHideOrbFill1:SetBackdropColor(top_r,top_g,top_b,off_a)
			fraJHideOrbFill2:SetBackdropColor(top_r,top_g,top_b,off_a)
			fraJHideOrbFill3:SetBackdropColor(top_r,top_g,top_b,off_a)
		end

		if db.Frames.Button1Used == true and IsAddOnLoaded(db.Frames.Button1Function) and hasItem(tblFunctions, db.Frames.Button1Function) then
			if intShownState == 1 then
				db.Frames.Button1CurrentState = false
				fraButton1:SetAlpha(0)
				doAddonChange(false, db.Frames.Button1Function)
			else
				if db.Frames.Button1CurrentState == false then
					db.Frames.Button1CurrentState = true
					fraButton1:SetAlpha(1)
					doAddonChange(true, db.Frames.Button1Function)
				end
			end
		end
		
		if db.Frames.Button2Used == true and IsAddOnLoaded(db.Frames.Button2Function) and hasItem(tblFunctions, db.Frames.Button2Function)  then
			if intShownState == 1 then
				db.Frames.Button2CurrentState = false
				fraButton2:SetAlpha(0)
				doAddonChange(false, db.Frames.Button2Function)
			else
				if db.Frames.Button2CurrentState == false then
					db.Frames.Button2CurrentState = true
					fraButton2:SetAlpha(1)
					doAddonChange(true, db.Frames.Button2Function)
				end
			end
		end
		
		if db.Frames.Button3Used == true and IsAddOnLoaded(db.Frames.Button3Function) and hasItem(tblFunctions, db.Frames.Button3Function)  then
			if intShownState == 1 then
				db.Frames.Button3CurrentState = false
				fraButton3:SetAlpha(0)
				doAddonChange(false, db.Frames.Button3Function)
			else
				if db.Frames.Button3CurrentState == false then
					db.Frames.Button3CurrentState = true
					fraButton3:SetAlpha(1)
				doAddonChange(true, db.Frames.Button3Function)
				end
			end
		end
		
		if db.Frames.Button4Used == true and IsAddOnLoaded(db.Frames.Button4Function) and hasItem(tblFunctions, db.Frames.Button4Function)  then
			if intShownState == 1 then
				db.Frames.Button4CurrentState = false
				fraButton4:SetAlpha(0)
				doAddonChange(false, db.Frames.Button4Function)
			else
				if db.Frames.Button4CurrentState == false then
					db.Frames.Button4CurrentState = true
					fraButton4:SetAlpha(1)
					doAddonChange(true, db.Frames.Button4Function)
				end
			end
		end
		
	end)

end

function JHide:CheckFrames() --Checks all buttons/addons are in the correct state
	
	if db.Frames.Button1CurrentState == true and db.Frames.Button2CurrentState == true and db.Frames.Button3CurrentState == true and db.Frames.Button4CurrentState == true then
		btnJHideOrbBase:SetBackdropColor(top_r, top_g, top_b, 1)
		fraJHideOrbFill1:SetBackdropColor(top_r,top_g,top_b,off_a)
		fraJHideOrbFill2:SetBackdropColor(top_r,top_g,top_b,off_a)
		fraJHideOrbFill3:SetBackdropColor(top_r,top_g,top_b,off_a)
	else
		btnJHideOrbBase:SetBackdropColor(off_r, off_g, off_b, 1)
		fraJHideOrbFill1:SetBackdropColor(off_r, off_g, off_b, off_a)
		fraJHideOrbFill2:SetBackdropColor(off_r, off_g, off_b, off_a)
		fraJHideOrbFill3:SetBackdropColor(off_r, off_g, off_b, off_a)
	end
	
	if db.Frames.Button1Used == true and IsAddOnLoaded(db.Frames.Button1Function) and hasItem(tblFunctions, db.Frames.Button1Function) then
		if db.Frames.Button1CurrentState == false then
			fraButton1:SetAlpha(0)
			doAddonChange(false, db.Frames.Button1Function)
		else
			fraButton1:SetAlpha(1)
			doAddonChange(true, db.Frames.Button1Function)
		end
	else
		doChangeButtonState(false,"button1")
	end
	
	if db.Frames.Button2Used == true and IsAddOnLoaded(db.Frames.Button2Function) and hasItem(tblFunctions, db.Frames.Button2Function) then
		if db.Frames.Button2CurrentState == false then
			fraButton2:SetAlpha(0)
			doAddonChange(false, db.Frames.Button2Function)
		else
			fraButton2:SetAlpha(1)
			doAddonChange(true, db.Frames.Button2Function)
		end
	else
		doChangeButtonState(false,"button2")
	end

	if db.Frames.Button3Used == true and IsAddOnLoaded(db.Frames.Button3Function) and hasItem(tblFunctions, db.Frames.Button3Function) then
		if db.Frames.Button3CurrentState == false then
			fraButton3:SetAlpha(0)
			doAddonChange(false, db.Frames.Button3Function)
		else
			fraButton3:SetAlpha(1)
			doAddonChange(true, db.Frames.Button3Function)
		end
	else
		doChangeButtonState(false,"button3")
	end
	
	if db.Frames.Button4Used == true and IsAddOnLoaded(db.Frames.Button4Function) and hasItem(tblFunctions, db.Frames.Button4Function) then
		if db.Frames.Button4CurrentState == false then
			fraButton4:SetAlpha(0)
			doAddonChange(false, db.Frames.Button4Function)
		else
			fraButton4:SetAlpha(1)
			doAddonChange(true, db.Frames.Button4Function)
		end
	else
		doChangeButtonState(false,"button4")
	end

	if db.Frames.MainWindowLocked == false then
		JHideMainAnchor:SetBackdropColor(0, 1, 0, 0.5)
		JHideMainAnchor:SetBackdropBorderColor(0.5, 0.5, 0, 0)
		JHideMainAnchor:EnableMouse(true)
	else
		JHideMainAnchor:SetBackdropColor(0, 1, 0, 0)
		JHideMainAnchor:SetBackdropBorderColor(0.5, 0.5, 0, 0)
		JHideMainAnchor:EnableMouse(false)
	end
end

function JHide:AddAddon(strName, strScriptShow, strScriptHide) --Adds a new addon to the db tables and runtime tables
	funcShow = loadstring(strScriptShow)
	funcHide = loadstring(strScriptHide)

	dicShow[strName] = funcShow
	dicHide[strName] = funcHide
	db.Frames.ShowFunctionsDictionary[strName] = strScriptShow
	db.Frames.HideFunctionsDictionary[strName] = strScriptHide
	table.insert(tblFunctions,strName)
	for k,v in pairs(tblFunctions) do
		if v == strName then
			self:CreateAddonMenu(k,v)
		end
	end
end

function JHide:APIHaveAddon(strName) --API call. Returns true if addon exists already
	if hasItem(tblFunctions, strName) == true then
		return true
	else
		return false
	end
end

function JHide:APIAddAddon(strName, strScriptShow, strScriptHide) --Safe API to add addon from another addon. Returns True if addon is added. False if it exists
	if hasItem(tblFunctions, strName) == true then
		return false
	else
		JHide:AddAddon(strName, strScriptShow, strScriptHide)
		return true
	end
end

function JHide:CreateAddonTree() --Loops for each currently added addon to call CreateAddonMenu
	for k,v in pairs(tblFunctions) do
		self:CreateAddonMenu(k,v)
	end
end

function JHide:CreateAddonMenu(intKey, strName) --Creates the tree menu for the given addon (Based on kgPanels Config)
	local safeName = string.gsub(strName, '(%s+)', function(x) return '_' end)
	
	local strName2 = ""
	if IsAddOnLoaded(strName) then
		strName2 = strName
	else
		strName2 = strName .. " - Not Found"
	end
	
	local tempAddonMenu = { 
		type = "group", 
		name = strName2, 
		desc = "Addon Script",
		args = {
			extras = {
				type = "group",
				name = "",
				inline = true,
				args = {
					showScript = { 
						type = "input",
						name = "Addon Show Script",
						get = function() return db.Frames.ShowFunctionsDictionary[strName] end,
						set = function(info,k) 
							db.Frames.ShowFunctionsDictionary[strName] = k
							dicShow[strName] = loadstring(k)
							JHide:CheckFrames()
						end,
						order = 3,
						width = "full",
					},
					hideScript = {
						type = "input",
						name = "Addon Hide Script",
						get = function() return db.Frames.HideFunctionsDictionary[strName] end,
						set = function(info,k) 
							db.Frames.HideFunctionsDictionary[strName] = k
							dicHide[strName] = loadstring(k)
							JHide:CheckFrames()
						end,
						order = 3,
						width = "full",
					},
					del = {
						type = "execute", 
						name = "Delete", 
						desc = "Delete from Scripts", 
						confirm = true, 
						confirmText = "Are you sure?", 
						func = function()
							tblFunctions[intKey] = nil
							dicShow[strName] = nil
							dicHide[strName] = nil						
							db.Frames.ShowFunctionsDictionary[strName] = nil
							db.Frames.HideFunctionsDictionary[strName] = nil
							AddonLibrary.args.Scripts.args[safeName] = nil
							JHide:CheckFrames()
						end,
						order = 100,
					},
				}
			}
		}
	}
	AddonLibrary.args.Scripts.args[safeName] = tempAddonMenu
end
