local addon = select(2, ...);
local mod = addon:NewModule("Queue", "AceEvent-3.0", "AceTimer-3.0");

function mod:OnEnable()
	-- Register our own slash commands
	addon:RegisterSlash(function()
		self:QueueAll();
	end, "q", "que", "queue");
	
	self:RegisterMessage("IM_QUEUE_ALL");
	self:RegisterMessage("IM_QUEUE_GROUP");
end

function mod:IM_QUEUE_ALL()
	self:QueueAll();
end

function mod:IM_QUEUE_GROUP(event, groupName)
	self:QueueGroup(groupName);
end

function mod:QueueAll()
	local playerName = UnitName("player");
	
	-- Go through all groups
	for groupName, values in pairs(addon.db.global.groups) do
		local trackAt = (values.trackAtCharacters or (values.trackAtCharacters == nil and addon.db.global.defaults.trackAtCharacters));
		
		if trackAt[playerName] then
			self:QueueGroup(groupName);
		end
	end
end

function mod:QueueGroup(groupName)
	if not addon.db.global.groups[groupName] then
		print(("Tried to queue items from a group named \"%s\", but no such group exists."):format(groupName));
		return;
	end
	
	local temp = {};
	
	-- Go through all trade skills for the profession
	for i = 1, GetNumTradeSkills() do
		-- Process every single tradeskill
		self:ProcessTradeSkill(i, groupName, temp);
	end
		
	for itemId, _ in pairs(addon.db.global.groups[groupName].items) do
		if not temp[itemId] then
			local itemLink = select(2, GetItemInfo(itemId));
			print("Couldn't queue " .. itemLink .. " (not part of this profession)");
		end
	end
end

function mod:ProcessTradeSkill(i, groupName, temp)
	-- Try to retrieve the itemlink, this will be nil if current item is a group instead
	local itemLink = GetTradeSkillItemLink(i);
	
	if itemLink then
		local itemId = addon:GetItemId(itemLink);
		if not itemId then
			-- If this isn't an item, it can only be an enchant instead
			itemId = tonumber(itemLink:match("|Henchant:([-0-9]+)|h"));
			
			itemId = addon.scrollIds[itemId]; -- change enchantIds into scrollIds
		end
		
		if addon.db.global.groups[groupName].items[itemId] then
			-- This item is in this group, queue it!
			
			if temp then
				-- Remember which items have been processed
				temp[itemId] = true;
			end
			
			local currentStock = addon:GetItemCount(itemId);
			if currentStock >= 0 then
				-- Current stock will be -1 when no itemcount addon was found
				local restockTarget = addon:GetOptionByKey(groupName, "restockTarget");
				local bonusQueue = addon:GetOptionByKey(groupName, "bonusQueue");
				local minCraftingQueue = floor( addon:GetOptionByKey(groupName, "minCraftingQueue") * restockTarget );
				
				local amount = ( restockTarget - currentStock );
				
				if currentStock == 0 and bonusQueue > 0 then
					amount = floor( ( amount * ( bonusQueue + 1 ) ) + .5 ); -- round
				end
				
				if amount > 0 and amount >= minCraftingQueue then
					self:Queue(i, amount);
					
					print("Queued " .. amount .. " of " .. itemLink);
				end
			else
				print("No usable itemcount addon found.");
			end
		end
	end
end

function mod:Queue(tradeSkillIndex, amount)
	tradeSkillIndex = tonumber(tradeSkillIndex);
	amount = tonumber(amount);
	
	if not tradeSkillIndex or not amount then return; end
	
	if addon.supportedAddons.crafting[addon.db.global.defaults.craftingAddon] then
		-- Try to use the default auction pricing addon
		
		return addon.supportedAddons.crafting[addon.db.global.defaults.craftingAddon].Queue(tradeSkillIndex, amount);
	else
		-- Default not available, get the first one then
		
		for name, value in pairs(addon.supportedAddons.crafting) do
			if value.IsEnabled() then
				return value.Queue(tradeSkillIndex, amount);
			end
		end
	end
	
	return -2;
end
