local addon = select(2, ...);

-- The source for the data of most of the items in the groups below is from Wowhead.com
--[[ The following parser was used within Firebug:
	var items = "";
	for(var itemId in _)
	{
	    if(!isNaN(itemId))
	        items += '[' + itemId + '] = 1, -- ' + _[itemId].name_enus + '\n';
	}
	alert(items);
]]
-- Do not forget to increment the version number of the group when updating a group
-- and ensure the value of each items matches that version number (this is used to update groups when they are changed - 
-- without this, manually removed items would be re-imported again, which we do not want)

addon.defaultGroups = {
	-- Glyphs
	-- Source: http://www.wowhead.com/items=16.6?filter=cr=87;crs=12;crv=0
	["Glyphs (Death Knight)"] = {
		version = 1,
		items = {
			[43533] = 1, -- Glyph of Anti-Magic Shell
			[43534] = 1, -- Glyph of Heart Strike
			[43535] = 1, -- Glyph of Blood Tap
			[43536] = 1, -- Glyph of Bone Shield
			[43537] = 1, -- Glyph of Chains of Ice
			[43539] = 1, -- Glyph of Death's Embrace
			[43541] = 1, -- Glyph of Death Grip
			[43542] = 1, -- Glyph of Death and Decay
			[43543] = 1, -- Glyph of Frost Strike
			[43544] = 1, -- Glyph of Horn of Winter
			[43546] = 1, -- Glyph of Icy Touch
			[43547] = 1, -- Glyph of Obliterate
			[43548] = 1, -- Glyph of Pestilence
			[43549] = 1, -- Glyph of Raise Dead
			[43550] = 1, -- Glyph of Rune Strike
			[43551] = 1, -- Glyph of Scourge Strike
			[43552] = 1, -- Glyph of Strangulate
			[43553] = 1, -- Glyph of Pillar of Frost
			[43554] = 1, -- Glyph of Vampiric Blood
			[43671] = 1, -- Glyph of Path of Frost
			[43672] = 1, -- Glyph of Resilient Grip
			[43673] = 1, -- Glyph of Raise Ally
			[43825] = 1, -- Glyph of Rune Tap
			[43826] = 1, -- Glyph of Blood Boil
			[43827] = 1, -- Glyph of Death Strike
			[45799] = 1, -- Glyph of Dancing Rune Weapon
			[45800] = 1, -- Glyph of Hungering Cold
			[45804] = 1, -- Glyph of Death Coil
			[45806] = 1, -- Glyph of Howling Blast
		},
	},
	["Glyphs (Druid)"] = {
		version = 1,
		items = {
			[45604] = 1, -- Glyph of Savage Roar
			[40921] = 1, -- Glyph of Starfall
			[44928] = 1, -- Glyph of Focus
			[45601] = 1, -- Glyph of Berserk
			[67484] = 1, -- Glyph of Lacerate
			[40915] = 1, -- Glyph of Lifebloom
			[45623] = 1, -- Glyph of Barkskin
			[40902] = 1, -- Glyph of Rip
			[40896] = 1, -- Glyph of Frenzied Regeneration
			[45602] = 1, -- Glyph of Wild Growth
			[40901] = 1, -- Glyph of Shred
			[40920] = 1, -- Glyph of Hurricane
			[40899] = 1, -- Glyph of Solar Beam
			[44922] = 1, -- Glyph of Typhoon
			[43335] = 1, -- Glyph of the Wild
			[45622] = 1, -- Glyph of Monsoon
			[67486] = 1, -- Glyph of Feral Charge
			[40908] = 1, -- Glyph of Innervate
			[43334] = 1, -- Glyph of Challenging Roar
			[43674] = 1, -- Glyph of Dash
			[40897] = 1, -- Glyph of Maul
			[40900] = 1, -- Glyph of Mangle
			[40903] = 1, -- Glyph of Rake
			[40906] = 1, -- Glyph of Swiftmend
			[40909] = 1, -- Glyph of Rebirth
			[40912] = 1, -- Glyph of Regrowth
			[40913] = 1, -- Glyph of Rejuvenation
			[40914] = 1, -- Glyph of Healing Touch
			[40916] = 1, -- Glyph of Starfire
			[40919] = 1, -- Glyph of Insect Swarm
			[40922] = 1, -- Glyph of Wrath
			[40923] = 1, -- Glyph of Moonfire
			[40924] = 1, -- Glyph of Entangling Roots
			[43316] = 1, -- Glyph of Aquatic Form
			[43331] = 1, -- Glyph of Unburdened Rebirth
			[43332] = 1, -- Glyph of Thorns
			[45603] = 1, -- Glyph of Starsurge
			[48720] = 1, -- Glyph of Ferocious Bite
			[67485] = 1, -- Glyph of Faerie Fire
			[67487] = 1, -- Glyph of Tiger's Fury
		},
	},
	["Glyphs (Hunter)"] = {
		version = 1,
		items = {
			[42904] = 1, -- Glyph of Disengage
			[42907] = 1, -- Glyph of Misdirection
			[45733] = 1, -- Glyph of Master's Call
			[45625] = 1, -- Glyph of Chimera Shot
			[42913] = 1, -- Glyph of Snake Trap
			[43355] = 1, -- Glyph of Aspect of the Pack
			[42911] = 1, -- Glyph of Rapid Fire
			[42902] = 1, -- Glyph of Bestial Wrath
			[42917] = 1, -- Glyph of Wyvern Sting
			[42899] = 1, -- Glyph of Trap Launcher
			[42906] = 1, -- Glyph of Ice Trap
			[42903] = 1, -- Glyph of Deterrence
			[45732] = 1, -- Glyph of Kill Shot
			[43351] = 1, -- Glyph of Feign Death
			[42910] = 1, -- Glyph of Silencing Shot
			[45734] = 1, -- Glyph of Scatter Shot
			[42905] = 1, -- Glyph of Freezing Trap
			[42897] = 1, -- Glyph of Aimed Shot
			[42898] = 1, -- Glyph of Arcane Shot
			[42900] = 1, -- Glyph of Mending
			[42901] = 1, -- Glyph of Concussive Shot
			[42908] = 1, -- Glyph of Immolation Trap
			[42909] = 1, -- Glyph of the Dazzled Prey
			[42912] = 1, -- Glyph of Serpent Sting
			[42914] = 1, -- Glyph of Steady Shot
			[42915] = 1, -- Glyph of Kill Command
			[43338] = 1, -- Glyph of Revive Pet
			[43350] = 1, -- Glyph of Mend Pet
			[43356] = 1, -- Glyph of Scare Beast
			[45731] = 1, -- Glyph of Explosive Shot
			[45735] = 1, -- Glyph of Raptor Strike
		},
	},
	["Glyphs (Mage)"] = {
		version = 1,
		items = {
			[45739] = 1, -- Glyph of Mirror Image
			[42748] = 1, -- Glyph of Invisibility
			[42736] = 1, -- Glyph of Arcane Power
			[45736] = 1, -- Glyph of Deep Freeze
			[63539] = 1, -- Glyph of Living Bomb
			[42749] = 1, -- Glyph of Mage Armor
			[43339] = 1, -- Glyph of Arcane Brilliance
			[44684] = 1, -- Glyph of Frostfire
			[42754] = 1, -- Glyph of Dragon's Breath
			[45737] = 1, -- Glyph of Slow
			[45740] = 1, -- Glyph of Ice Barrier
			[50045] = 1, -- Glyph of Mana Shield
			[43359] = 1, -- Glyph of Conjuring
			[42751] = 1, -- Glyph of Molten Armor
			[63416] = 1, -- Glyph of Armors
			[43364] = 1, -- Glyph of Slow Fall
			[42744] = 1, -- Glyph of Ice Block
			[44920] = 1, -- Glyph of Blast Wave
			[42745] = 1, -- Glyph of Ice Lance
			[42735] = 1, -- Glyph of Arcane Missiles
			[42737] = 1, -- Glyph of Blink
			[42738] = 1, -- Glyph of Evocation
			[42739] = 1, -- Glyph of Fireball
			[42741] = 1, -- Glyph of Frost Nova
			[42742] = 1, -- Glyph of Frostbolt
			[42743] = 1, -- Glyph of Pyroblast
			[42746] = 1, -- Glyph of Icy Veins
			[42752] = 1, -- Glyph of Polymorph
			[42753] = 1, -- Glyph of Cone of Cold
			[43360] = 1, -- Glyph of the Monkey
			[43361] = 1, -- Glyph of the Penguin
			[45738] = 1, -- Glyph of Arcane Barrage
			[44955] = 1, -- Glyph of Arcane Blast
		},
	},
	["Glyphs (Paladin)"] = {
		version = 1,
		items = {
			[41102] = 1, -- Glyph of Turn Evil
			[41107] = 1, -- Glyph of the Ascetic Crusader
			[41109] = 1, -- Glyph of Light of Dawn
			[45747] = 1, -- Glyph of Salvation
			[43369] = 1, -- Glyph of Justice
			[43340] = 1, -- Glyph of Blessing of Might
			[41097] = 1, -- Glyph of Hammer of Wrath
			[43368] = 1, -- Glyph of Truth
			[43869] = 1, -- Glyph of Seal of Truth
			[45745] = 1, -- Glyph of Divine Plea
			[41094] = 1, -- Glyph of Rebuke
			[45741] = 1, -- Glyph of Beacon of Light
			[45744] = 1, -- Glyph of Shield of the Righteous
			[41104] = 1, -- Glyph of Cleansing
			[41096] = 1, -- Glyph of Divine Protection
			[41110] = 1, -- Glyph of Seal of Insight
			[43366] = 1, -- Glyph of Insight
			[41106] = 1, -- Glyph of Divine Favor
			[45742] = 1, -- Glyph of Hammer of the Righteous
			[43867] = 1, -- Glyph of Holy Wrath
			[41092] = 1, -- Glyph of Judgement
			[41095] = 1, -- Glyph of Hammer of Justice
			[41098] = 1, -- Glyph of Crusader Strike
			[41099] = 1, -- Glyph of Consecration
			[41100] = 1, -- Glyph of Righteousness
			[41101] = 1, -- Glyph of Focused Shield
			[41103] = 1, -- Glyph of Exorcism
			[41105] = 1, -- Glyph of Word of Glory
			[41108] = 1, -- Glyph of Divinity
			[43365] = 1, -- Glyph of Blessing of Kings
			[43367] = 1, -- Glyph of Lay on Hands
			[43868] = 1, -- Glyph of Dazing Shield
			[45743] = 1, -- Glyph of Templar's Verdict
			[45746] = 1, -- Glyph of Holy Shock
			[66918] = 1, -- Glyph of the Long Word
		},
	},
	["Glyphs (Priest)"] = {
		version = 1,
		items = {
			[42404] = 1, -- Glyph of Mass Dispel
			[42407] = 1, -- Glyph of Power Word: Barrier
			[45753] = 1, -- Glyph of Dispersion
			[45755] = 1, -- Glyph of Guardian Spirit
			[43374] = 1, -- Glyph of Shadowfiend
			[42401] = 1, -- Glyph of Holy Nova
			[42396] = 1, -- Glyph of Circle of Healing
			[42405] = 1, -- Glyph of Psychic Horror
			[43372] = 1, -- Glyph of Shadow Protection
			[42399] = 1, -- Glyph of Fear Ward
			[45760] = 1, -- Glyph of Pain Suppression
			[42409] = 1, -- Glyph of Prayer of Healing
			[42417] = 1, -- Glyph of Spirit of Redemption
			[43370] = 1, -- Glyph of Levitate
			[42412] = 1, -- Glyph of Scourge Imprisonment
			[42414] = 1, -- Glyph of Shadow Word: Death
			[43373] = 1, -- Glyph of Shackle Undead
			[45757] = 1, -- Glyph of Spirit Tap
			[42403] = 1, -- Glyph of Lightwell
			[42397] = 1, -- Glyph of Dispel Magic
			[42398] = 1, -- Glyph of Fade
			[42400] = 1, -- Glyph of Flash Heal
			[42402] = 1, -- Glyph of Inner Fire
			[42406] = 1, -- Glyph of Shadow Word: Pain
			[42408] = 1, -- Glyph of Power Word: Shield
			[42410] = 1, -- Glyph of Psychic Scream
			[42411] = 1, -- Glyph of Renew
			[42415] = 1, -- Glyph of Mind Flay
			[42416] = 1, -- Glyph of Smite
			[43342] = 1, -- Glyph of Fading
			[43371] = 1, -- Glyph of Fortitude
			[45756] = 1, -- Glyph of Penance
			[45758] = 1, -- Glyph of Divine Accuracy
		},
	},
	["Glyphs (Rogue)"] = {
		version = 1,
		items = {
			[45766] = 1, -- Glyph of Fan of Knives
			[45767] = 1, -- Glyph of Tricks of the Trade
			[45761] = 1, -- Glyph of Vendetta
			[45762] = 1, -- Glyph of Killing Spree
			[45764] = 1, -- Glyph of Shadow Dance
			[45769] = 1, -- Glyph of Cloak of Shadows
			[42971] = 1, -- Glyph of Kick
			[42959] = 1, -- Glyph of Deadly Throw
			[42954] = 1, -- Glyph of Adrenaline Rush
			[42968] = 1, -- Glyph of Preparation
			[43378] = 1, -- Glyph of Safe Fall
			[42969] = 1, -- Glyph of Rupture
			[42963] = 1, -- Glyph of Feint
			[42964] = 1, -- Glyph of Garrote
			[42962] = 1, -- Glyph of Expose Armor
			[64493] = 1, -- Glyph of Blind
			[42965] = 1, -- Glyph of Revealing Strike
			[42967] = 1, -- Glyph of Hemorrhage
			[43376] = 1, -- Glyph of Distract
			[42955] = 1, -- Glyph of Ambush
			[42956] = 1, -- Glyph of Backstab
			[42957] = 1, -- Glyph of Blade Flurry
			[42958] = 1, -- Glyph of Crippling Poison
			[42960] = 1, -- Glyph of Evasion
			[42961] = 1, -- Glyph of Eviscerate
			[42966] = 1, -- Glyph of Gouge
			[42970] = 1, -- Glyph of Sap
			[42972] = 1, -- Glyph of Sinister Strike
			[42973] = 1, -- Glyph of Slice and Dice
			[42974] = 1, -- Glyph of Sprint
			[43343] = 1, -- Glyph of Pick Pocket
			[43377] = 1, -- Glyph of Pick Lock
			[43379] = 1, -- Glyph of Blurred Speed
			[43380] = 1, -- Glyph of Poisons
			[45768] = 1, -- Glyph of Mutilate
			[63420] = 1, -- Glyph of Vanish
		},
	},
	["Glyphs (Shaman)"] = {
		version = 1,
		items = {
			[45777] = 1, -- Glyph of Hex
			[45771] = 1, -- Glyph of Feral Spirit
			[45772] = 1, -- Glyph of Riptide
			[41529] = 1, -- Glyph of Fire Elemental Totem
			[44923] = 1, -- Glyph of Thunderstorm
			[45778] = 1, -- Glyph of Stoneclaw Totem
			[41527] = 1, -- Glyph of Earthliving Weapon
			[41552] = 1, -- Glyph of Elemental Mastery
			[45776] = 1, -- Glyph of Shamanistic Rage
			[43344] = 1, -- Glyph of Water Breathing
			[41517] = 1, -- Glyph of Chain Heal
			[41538] = 1, -- Glyph of Grounding Totem
			[41524] = 1, -- Glyph of Lava Burst
			[41542] = 1, -- Glyph of Windfury Weapon
			[41535] = 1, -- Glyph of Totemic Recall
			[43381] = 1, -- Glyph of Astral Recall
			[43385] = 1, -- Glyph of Renewed Life
			[41539] = 1, -- Glyph of Stormstrike
			[41518] = 1, -- Glyph of Chain Lightning
			[41530] = 1, -- Glyph of Fire Nova
			[43388] = 1, -- Glyph of Water Walking
			[41526] = 1, -- Glyph of Shocking
			[41531] = 1, -- Glyph of Flame Shock
			[41532] = 1, -- Glyph of Flametongue Weapon
			[41533] = 1, -- Glyph of Healing Stream Totem
			[41534] = 1, -- Glyph of Healing Wave
			[41536] = 1, -- Glyph of Lightning Bolt
			[41537] = 1, -- Glyph of Lightning Shield
			[41540] = 1, -- Glyph of Lava Lash
			[41541] = 1, -- Glyph of Water Shield
			[41547] = 1, -- Glyph of Frost Shock
			[43386] = 1, -- Glyph of the Arctic Wolf
			[43725] = 1, -- Glyph of Ghost Wolf
			[45770] = 1, -- Glyph of Thunder
			[45775] = 1, -- Glyph of Earth Shield
		},
	},
	["Glyphs (Warlock)"] = {
		version = 1,
		items = {
			[45782] = 1, -- Glyph of Demonic Circle
			[45783] = 1, -- Glyph of Shadowflame
			[45779] = 1, -- Glyph of Haunt
			[45780] = 1, -- Glyph of Metamorphosis
			[45781] = 1, -- Glyph of Chaos Bolt
			[43394] = 1, -- Glyph of Souls
			[42453] = 1, -- Glyph of Incinerate
			[42457] = 1, -- Glyph of Death Coil
			[42463] = 1, -- Glyph of Howl of Terror
			[42466] = 1, -- Glyph of Soul Swap
			[42460] = 1, -- Glyph of Felhunter
			[43393] = 1, -- Glyph of Enslave Demon
			[42468] = 1, -- Glyph of Shadowburn
			[43392] = 1, -- Glyph of Curse of Exhaustion
			[42454] = 1, -- Glyph of Conflagrate
			[42455] = 1, -- Glyph of Corruption
			[42456] = 1, -- Glyph of Bane of Agony
			[42458] = 1, -- Glyph of Fear
			[42459] = 1, -- Glyph of Felguard
			[42461] = 1, -- Glyph of Health Funnel
			[42462] = 1, -- Glyph of Healthstone
			[42464] = 1, -- Glyph of Immolate
			[42465] = 1, -- Glyph of Imp
			[42467] = 1, -- Glyph of Shadow Bolt
			[42470] = 1, -- Glyph of Soulstone
			[42471] = 1, -- Glyph of Seduction
			[42472] = 1, -- Glyph of Unstable Affliction
			[42473] = 1, -- Glyph of Voidwalker
			[43389] = 1, -- Glyph of Unending Breath
			[43390] = 1, -- Glyph of Drain Soul
			[43391] = 1, -- Glyph of Kilrogg
			[45785] = 1, -- Glyph of Life Tap
			[45789] = 1, -- Glyph of Soul Link
			[50077] = 1, -- Glyph of Lash of Pain
		},
	},
	["Glyphs (Warrior)"] = {
		version = 1,
		items = {
			[63481] = 1, -- Glyph of Colossus Smash
			[43418] = 1, -- Glyph of Heroic Throw
			[43419] = 1, -- Glyph of Intervene
			[45790] = 1, -- Glyph of Bladestorm
			[45792] = 1, -- Glyph of Shockwave
			[49084] = 1, -- Glyph of Command
			[45795] = 1, -- Glyph of Spell Reflection
			[43396] = 1, -- Glyph of Berserker Rage
			[43398] = 1, -- Glyph of Demoralizing Shout
			[67482] = 1, -- Glyph of Intercept
			[45797] = 1, -- Glyph of Shield Wall
			[43423] = 1, -- Glyph of Slam
			[45794] = 1, -- Glyph of Intimidating Shout
			[43424] = 1, -- Glyph of Revenge
			[43415] = 1, -- Glyph of Devastate
			[43432] = 1, -- Glyph of Raging Blow
			[67483] = 1, -- Glyph of Death Wish
			[43428] = 1, -- Glyph of Sweeping Strikes
			[43395] = 1, -- Glyph of Battle
			[43397] = 1, -- Glyph of Long Charge
			[43399] = 1, -- Glyph of Thunder Clap
			[43400] = 1, -- Glyph of Enduring Victory
			[43412] = 1, -- Glyph of Bloody Healing
			[43413] = 1, -- Glyph of Rapid Charge
			[43414] = 1, -- Glyph of Cleaving
			[43416] = 1, -- Glyph of Bloodthirst
			[43417] = 1, -- Glyph of Piercing Howl
			[43421] = 1, -- Glyph of Mortal Strike
			[43422] = 1, -- Glyph of Overpower
			[43425] = 1, -- Glyph of Shield Slam
			[43427] = 1, -- Glyph of Sunder Armor
			[43430] = 1, -- Glyph of Resonating Power
			[43431] = 1, -- Glyph of Victory Rush
			[45793] = 1, -- Glyph of Furious Sundering
		},
	},
	-- Epic gems (WotLK)
	-- Source: http://www.wowhead.com/items=3?filter=na=Ametrine;cr=87;crs=12;crv=0
	["Epic Gems (Ametrine)"] = {
		version = 1,
		items = {
			[40142] = 1, -- Inscribed Ametrine
			[40144] = 1, -- Champion's Ametrine
			[40145] = 1, -- Resplendent Ametrine
			[40146] = 1, -- Fierce Ametrine
			[40147] = 1, -- Deadly Ametrine
			[40149] = 1, -- Lucent Ametrine
			[40150] = 1, -- Deft Ametrine
			[40152] = 1, -- Potent Ametrine
			[40154] = 1, -- Willful Ametrine
			[40155] = 1, -- Reckless Ametrine
			[40156] = 1, -- Deadly Ametrine
			[40158] = 1, -- Lucent Ametrine
			[40159] = 1, -- Deft Ametrine
			[40160] = 1, -- Stalwart Ametrine
			[40161] = 1, -- Stalwart Ametrine
			[40163] = 1, -- Resolute Ametrine
		},
	},
	["Epic Gems (Cardinal Ruby)"] = {
		version = 1,
		items = {
			[40111] = 1, -- Bold Cardinal Ruby
			[40112] = 1, -- Delicate Cardinal Ruby
			[40113] = 1, -- Brilliant Cardinal Ruby
			[40114] = 1, -- Delicate Cardinal Ruby
			[40116] = 1, -- Flashing Cardinal Ruby
			[40118] = 1, -- Precise Cardinal Ruby
			[40123] = 1, -- Brilliant Cardinal Ruby
		},
	},
	["Epic Gems (Dreadstone)"] = {
		version = 1,
		items = {
			[40129] = 1, -- Sovereign Dreadstone
			[40130] = 1, -- Shifting Dreadstone
			[40131] = 1, -- Glinting Dreadstone
			[40132] = 1, -- Timeless Dreadstone
			[40133] = 1, -- Purified Dreadstone
			[40134] = 1, -- Purified Dreadstone
			[40135] = 1, -- Mysterious Dreadstone
			[40136] = 1, -- Shifting Dreadstone
			[40137] = 1, -- Glinting Dreadstone
			[40139] = 1, -- Defender's Dreadstone
			[40141] = 1, -- Guardian's Dreadstone
			[40143] = 1, -- Etched Dreadstone
			[40148] = 1, -- Glinting Dreadstone
			[40151] = 1, -- Purified Dreadstone
			[40153] = 1, -- Veiled Dreadstone
			[40157] = 1, -- Glinting Dreadstone
			[40162] = 1, -- Accurate Dreadstone
			[40164] = 1, -- Timeless Dreadstone
			[40170] = 1, -- Purified Dreadstone
			[40175] = 1, -- Purified Dreadstone
		},
	},
	["Epic Gems (Eye of Zul)"] = {
		version = 1,
		items = {
			[40138] = 1, -- Regal Eye of Zul
			[40140] = 1, -- Jagged Eye of Zul
			[40165] = 1, -- Jagged Eye of Zul
			[40166] = 1, -- Nimble Eye of Zul
			[40167] = 1, -- Regal Eye of Zul
			[40168] = 1, -- Steady Eye of Zul
			[40169] = 1, -- Forceful Eye of Zul
			[40171] = 1, -- Misty Eye of Zul
			[40172] = 1, -- Lightning Eye of Zul
			[40173] = 1, -- Turbid Eye of Zul
			[40174] = 1, -- Energized Eye of Zul
			[40176] = 1, -- Misty Eye of Zul
			[40177] = 1, -- Lightning Eye of Zul
			[40178] = 1, -- Turbid Eye of Zul
			[40179] = 1, -- Energized Eye of Zul
			[40180] = 1, -- Radiant Eye of Zul
			[40181] = 1, -- Radiant Eye of Zul
			[40182] = 1, -- Shattered Eye of Zul
		},
	},
	["Epic Gems (King's Amber)"] = {
		version = 1,
		items = {
			[40115] = 1, -- Subtle King's Amber
			[40117] = 1, -- Smooth King's Amber
			[40124] = 1, -- Smooth King's Amber
			[40126] = 1, -- Subtle King's Amber
			[40127] = 1, -- Mystic King's Amber
			[40128] = 1, -- Quick King's Amber
		},
	},
	["Epic Gems (Majestic Zircon)"] = {
		version = 1,
		items = {
			[40119] = 1, -- Solid Majestic Zircon
			[40120] = 1, -- Sparkling Majestic Zircon
			[40121] = 1, -- Sparkling Majestic Zircon
			[40122] = 1, -- Stormy Majestic Zircon
			[40125] = 1, -- Rigid Majestic Zircon
		},
	},
	-- Rare gems (WotLK)
	-- Enchants (WotLK)
	-- Enchants (Heirlooms)
	-- Source: manual retrieved from Wowhead
	["Enchants (Heirlooms)"] = {
		version = 1,
		items = {
			[38873] = 1, -- Enchant Weapon - Crusader
			[38838] = 1, -- Enchant Weapon - Fiery Weapon
			[38896] = 1, -- Enchant Weapon - 2H Weapon - Agility
			[38880] = 1, -- Enchant Weapon - Agility
			[38877] = 1, -- Enchant Weapon - Spellpower
			[38878] = 1, -- Enchant Weapon - Healing Power
			[38884] = 1, -- Enchant Weapon - Mighty Intellect
			[38879] = 1, -- Enchant Weapon - Strength
			[38868] = 1, -- Enchant Weapon - Icy Chill
			[38871] = 1, -- Enchant Weapon - Lifestealing
			[38883] = 1, -- Enchant Weapon - Mighty Spirit
			[38879] = 1, -- Enchant Weapon - Strength
			[38865] = 1, -- Enchant Chest - Greater Stats
			[38866] = 1, -- Enchant Chest - Major Health
			[38847] = 1, -- Enchant Chest - Stats
			[38867] = 1, -- Enchant Chest - Major Mana
		},
	},
	--Enchant Chest  Major Resilience 
	--Enchant Weapon  Mongoose 
	--Enchant Weapon  Blade Ward 
	--Enchant Weapon  Blood Draining 
};