local IGAM_LOADED = false;				-- variable to check if mod is loaded for the first time
local NEW_VERSION = false;				-- check if newer version exist
local IGAM_DEBUGCOUNT=0;
local IGAM_TITANBAG=0;
--local IgamOriginal_BuffFrame_UpdateDuration;
local IgamOriginal_SetPortraitTexture;
local IGAM_pt = { };
local IgamCastInProgress = false;
local igamplayermaxlvl = false; 			-- sets to 1 if you reached max lvl
local _, IgamClass = UnitClass("player");		-- eg. WARLOCK/DRUID/WARRIOR etc...
local IgamFrames = { };	-- handles pointers to frames
--local IgamShards=0;
IgamLootMoney=0;
IgamLootSum=0;
IGAM_OPTBUTTON = 0;

local igam_Events = { };
igam_Events["IGAM_CORE"] = {
 "VARIABLES_LOADED",  -- check variables (1line)
 "FRIENDLIST_UPDATE", -- check variables (1line)
 "ADDON_LOADED",      -- MyAddOns (1line)
 "MERCHANT_SHOW",     -- autorepair (2lines)
 "MERCHANT_CLOSED",
 "RESURRECT_REQUEST", -- autoresurrect + resurrect emotes (3lines)
 "PLAYER_ALIVE",
 "PLAYER_UNGHOST",
 "CHAT_MSG_ADDON",		--check version with other players
 "CHAT_MSG_WHISPER",	--monitor whispers (autoinvite)
 "CURSOR_UPDATE",     -- bankbags (1line)
 "CVAR_UPDATE",       -- ???dunno....don't remember (2lines)
 "PLAYER_ENTERING_WORLD", -- to get GUID
 "PLAYER_LEVEL_UP",		--event when lvl, arg1=new lvl
 "PLAYER_LOGIN",      -- 3d Portraits
 "LeftButton",
 "ZONE_CHANGED_NEW_AREA",--IgamCoords (1line)
-- "UNIT_HEALTH",     -- mobhealth (3lines)
-- "UNIT_COMBAT",
 "UPDATE_FACTION",      -- reputation update(2lines)
 "CHAT_MSG_COMBAT_FACTION_CHANGE",
 "BAG_UPDATE",          -- bagstatus(2lines)
 "UNIT_SPELLCAST_SENT", --monitor spells
 "PLAYER_FLAGS_CHANGED",--AFK in raids
 "GROUP_ROSTER_CHANGED",
 "READY_CHECK",
 "PLAYER_TARGET_CHANGED",
}
igam_Events["IGAM_BAG"] = {
  "BAG_UPDATE",        -- bagstatus(2lines)
  "PLAYER_ENTERING_WORLD",
  "BANKFRAME_OPENED",  -- bankbags (3lines)
  "BANKFRAME_CLOSED",
  "PLAYERBANKSLOTS_CHANGED"
}
igam_Events["IgamWellFed"] = {
  "PLAYER_TARGET_CHANGED",	-- look if/when boss is targeted
}
igam_Events["IgamFlask"] = {
  "PLAYER_TARGET_CHANGED",	-- look if/when boss is targeted
  "ACTIVE_TALENT_GROUP_CHANGED", -- check if change spec.
}
local igam_UnitEvents = { };
igam_UnitEvents["IgamWellFed"] = {
  ["UNIT_AURA"] = "player",	-- check when buffs is changed on self
}
igam_UnitEvents["IgamFlask"] = {
  ["UNIT_AURA"] = "player",	-- check when buffs is changed on self
}
igam_Events["DEATHKNIGHT"] = { }
igam_Events["DRUID"] = { }
igam_Events["HUNTER"] = { }
igam_Events["MAGE"] = { }
igam_Events["MONK"] = { }
igam_Events["PALADIN"] = { }
igam_Events["PRIEST"] = { }
igam_Events["ROGUE"] = { }
igam_Events["SHAMAN"] = { }
igam_Events["WARLOCK"] = {
  "UNIT_PET",     --check name for summoned demons
}
igam_Events["WARRIOR"] = { }

IgamToggleCommand= {
-- layout: ["command"] = { "variable", "function", "toggle-text", "help-text" },
  ["igam_autoinvite"] = { "igam_AutoInvite", "", "AutoInvite-RAID" , "enable/disable AutoInvite to raid by whisper" },
  ["autoinvite"] =      { "igam_AutoInvite", "", "AutoInvite-RAID" , "enable/disable AutoInvite to raid by whisper" },
  ["igam_bagenable"]  = { "igam_BagEnable", function() IGAM_ToggleSubButtons() end, "Bag status meters", "show/hide BagOverlay" },
  ["igam_bagbar"]     = { "igam_BagBar", function() IGAM_UpdateBags(12) end, "bag bars", "show/hide bars over bags" },
  ["igam_baglabel"]   = { "igam_BagLabel", function() IGAM_UpdateBags(12) end, "bag labels","-show/hide text over bags" },
  ["igam_bagcolor"]   = { "igam_BagColor", function() IGAM_UpdateBags(12) end, "Coloured baglabels/bars", "show color on bars/text" },
  ["igam_bagtotal"]   = { "igam_BagTotal", function() IGAM_UpdateBags(12) end, "Show total bagspace", "show/hide total slots in bag" },
  ["igam_bagfree"]    = { "igam_BagFree", function() IGAM_UpdateBags(12) end, "Show free space in bag", "show amount of free/used slots in bag" },
  ["igam_bagnotify"]  = { "igam_BagNotify", function() IGAM_UpdateBags(12) end, "Popup when bag is full", "show/hide BagFull-notify" },
  ["igam_bagsingle"]  = { "igam_BagSingle", function() IGAM_MainMenuBar() end, "single bag", "show/hide BagFull-notify" },
  ["onebag"]          = { "igam_BagSingle", function() IGAM_MainMenuBar() end, "single bag", "show/hide BagFull-notify" },
  ["igam_bagsell"]    = { "igam_BagSell", function() IgamJunkButton:Show(); end, "Autosell common(gray) items", "toggle autosell 'gray' items" },
  ["autosell"]        = { "igam_BagSell", function() IgamJunkButton:Show(); end, "Autosell common(gray) items", "toggle autosell 'gray' items" },
  ["igam_bagsellq"]   = { "igam_BagSellQ", "", "Mute sales-report" , "show/hide autosell-notify" },
  ["autosell2quiet"]  = { "igam_BagSellQ", "", "Mute sales-report" , "show/hide autosell-notify" },
  ["igam_buffcaster"] = { "igam_buffCaster", "", "BuffCaster" , "show/hide caster on buffs" },
  ["igam_casttime"]   = { "igam_CastTime", function() IGAM_ToggleSubButtons() end, "Visual Spellcast-Time", "show/hide CastTime-notify" },
  ["casttime"]        = { "igam_CastTime", function() IGAM_ToggleSubButtons() end, "Visual Spellcast-Time", "show/hide CastTime-notify" },
  ["ct"]              = { "igam_CastTime", function() IGAM_ToggleSubButtons() end, "Visual Spellcast-Time", "show/hide CastTime-notify" },
  ["igam_casttimeinv"]= { "igam_CastTimeInv", "", "Inverted Visual Spellcast-Time", "Invert CastTime-notify" },
  ["casttimeinv"]     = { "igam_CastTimeInv", "", "Inverted Visual Spellcast-Time", "Invert CastTime-notify" },
  ["cti"]             = { "igam_CastTimeInv", "", "Inverted Visual Spellcast-Time", "Invert CastTime-notify" },
  ["igam_debug"]      = { "igam_debug", function() IGAM_Debug() end, "DebugWindow", "show the debug-window" },
  ["debug"]           = { "igam_debug", function() IGAM_Debug() end, "DebugWindow", "show the debug-window" },
  ["igam_griffin"]    = { "igam_Griffin", function() IGAM_griffin() end, "Griffins", "show/hide the griffins in the mainbar" },
  ["griffin"]         = { "igam_Griffin", function() IGAM_griffin() end, "Griffins", "show/hide the griffins in the mainbar" },
  ["igam_latency"]    = { "igam_Latency", function() IGAM_Latency() end, "Latencytext", "show/hide the latency-bar in top-left" },
  ["latency"]         = { "igam_Latency", function() IGAM_Latency() end, "Latencytext", "show/hide the latency-bar in top-left" },
--  ["igam_party"]      = { "igam_Party", function() IGAM_partymanahealth() end, "Visible Mana/HP on party", "enable/disable IgamPartyCore" },
--  ["party"]           = { "igam_Party", function() IGAM_partymanahealth() end, "Visible Mana/HP on party", "enable/disable IgamPartyCore" },
  ["igam_repair"]     = { "igam_Repair", function() IGAM_ToggleSubButtons() end, "Autorepair", "enable/disable autorepair" },
  ["autorepair"]      = { "igam_Repair", function() IGAM_ToggleSubButtons() end, "Autorepair", "enable/disable autorepair" },
  ["igam_repairinv"]  = { "igam_RepairInv", "", "Autorepair Inventory", "enable/disable autorepair inventory aswell" },
  ["autorepairinv"]   = { "igam_RepairInv", "", "Autorepair Inventory", "enable/disable autorepair inventory aswell" },
  ["igam_askrepair"]  = { "igam_AskRepair", "", "Autorepair-ask before", "ask if repair or not" },
  ["autorepairask"]   = { "igam_AskRepair", "", "Autorepair-ask before", "ask if repair or not" },
  ["igam_repairguild"]= { "igam_RepairGuild", "", "Autorepair-guildgold", "enable/disable autorepair to use guild-money" },
  ["autorepairguild"] = { "igam_RepairGuild", "", "Autorepair-guildgold", "enable/disable autorepair to use guild-money" },
  ["igam_resurrect"]  = { "igam_resurrect", "", "Autoresurrect", "Automatically resurrects when resurrected by another player" },
  ["autoresurrect"]   = { "igam_resurrect", "", "Autoresurrect", "Automatically resurrects when resurrected by another player" },
  ["igam_mainmenubar"]= { "igam_MainMenuBar", function() IGAM_MainMenuBar() end, "New MainMenu", "toggle new/old style mainbar" },
  ["menu"]            = { "igam_MainMenuBar", function() IGAM_MainMenuBar() end, "New MainMenu", "toggle new/old style mainbar" },
  ["m"]               = { "igam_MainMenuBar", function() IGAM_MainMenuBar() end, "New MainMenu", "toggle new/old style mainbar" },
  ["igam_mainmenux"]  = { "igam_MainMenuX", function() IGAM_MainMenuBar() end, "Move New XP-bar right", "move new mainbar right" },
  ["mainmenux"]       = { "igam_MainMenuX", function() IGAM_MainMenuBar() end, "Move New XP-bar right", "move new mainbar right" },
  ["igam_microbutton"]= { "igam_MicroButton", function() IGAM_MicroButton() end, "MicroButtons", "show/hide microbuttons in the mainbar" },
  ["micro"]           = { "igam_MicroButton", function() IGAM_MicroButton() end, "MicroButtons", "show/hide microbuttons in the mainbar" },
  ["igam_tnl"]        = { "igam_TNL", function() IGAM_TNL() end, "TNL-meter", "show/hide TNL-meter" },
  ["tnl"]             = { "igam_TNL", function() IGAM_TNL() end, "TNL-meter", "show/hide TNL-meter" },
  ["igam_xp"]         = { "igam_XP", function() IGAM_XPBUpdate() end, "New XP-bar", "show/hide new XP-bar" },
  ["xp"]              = { "igam_XP", function() IGAM_XPBUpdate() end, "New XP-bar", "show/hide new XP-bar" },
  ["igam_3d"]         = { "igam_3d", function() IGAM_3Drefresh(); ReloadUI() end, "3D Portraits", "toggle 3d portraits" },
  ["3d"]              = { "igam_3d", function() IGAM_3Drefresh(); ReloadUI() end, "3D Portraits", "toggle 3d portraits" },
  ["igam_3dback"]     = { "igam_3dback", function() IGAM_3Drefresh() end, "3D Portraits Background", "toggle 3d portraits" },
  ["3dbg"]            = { "igam_3dback", function() IGAM_3Drefresh() end, "3D Portraits Background", "toggle 3d portraits" },
  ["igam_3dsquare"]   = { "igam_3dsquare", function() IGAM_3Drefresh() end, "3D Portraits Squareshape", "toggle 3d portraits cirle or square form"},
  ["3dshape"]         = { "igam_3dsquare", function() IGAM_3Drefresh() end, "3D Portraits Squareshape", "toggle 3d portraits cirle or square form"},
  ["igam_questlvl"]   = { "igam_questLvl", "", "Show questlvl in questwindow", "show/hide questlvl in questlog" },
  ["questlvl"]        = { "igam_questLvl", "", "Show questlvl in questwindow", "show/hide questlvl in questlog" },
  ["igam_mapcoords"]  = { "igam_mapCoords", function() IGAM_Coords() end, "Coordinates at minimap", "Show coordinates at minimap" },
  ["minimapcoords"]   = { "igam_mapCoords", function() IGAM_Coords() end, "Coordinates at minimap", "Show coordinates at minimap" },
  ["igam_mapframe"]   = { "igam_mapFrame", function() IGAM_ShowHide("igam_mapFrame", "MinimapBorder") end, "Hide minimapBorder", "Hide border of minimap" },
  ["minimapframe"]    = { "igam_mapFrame", function() IGAM_ShowHide("igam_mapFrame", "MinimapBorder") end, "Hide minimapBorder", "Hide border of minimap" },
  ["igam_mapmove"]    = { "igam_mapMove", "", "Movable minimap", "frame of minimap movable" },
  ["minimapmove"]     = { "igam_mapMove", "", "Movable minimap", "frame of minimap movable" },
  ["igam_maptime"]    = { "igam_mapTime", function() IGAM_ShowHide("igam_mapTime", "GameTimeFrame"); end, "Hide Day/Night-indicator", "Hide Timebutton of minimap" },
  ["minimaptime"]     = { "igam_mapTime", function() IGAM_ShowHide("igam_mapTime", "GameTimeFrame"); end, "Hide Day/Night-indicator", "Hide Timebutton of minimap" },
  ["igam_mapclock"]   = { "igam_mapClock", function() IGAM_ShowHide("igam_mapClock", "IgamClock", 1) end, "Clock", "Show clock" },
  ["minimapclock"]    = { "igam_mapClock", function() IGAM_ShowHide("igam_mapClock", "IgamClock", 1) end, "Clock", "Show clock" },
  ["clock"]           = { "igam_mapClock", function() IGAM_ShowHide("igam_mapClock", "IgamClock", 1) end, "Clock", "Show clock" },
  ["igam_maptop"]     = { "igam_mapTop", function() IGAM_minimap() end, "hide Minimap top border", "Hide top border of minimap" },
  ["minimaptop"]      = { "igam_mapTop", function() IGAM_minimap() end, "hide Minimap top border", "Hide top border of minimap" },
  ["igam_mapsquare"]  = { "igam_mapSquare", function() IGAM_mapSquare() end, "Minimap square-shaped", "Toggle minimap between square-circle-shaped" },
  ["minimapsquare"]   = { "igam_mapSquare", function() IGAM_mapSquare() end, "Minimap square-shaped", "Toggle minimap between square-circle-shaped" },
  ["igam_mapzoom"]    = { "igam_mapZoom", function() IGAM_minimap() end, "Hide MinimapZoom-buttons", "Hide zoombuttons of minimap" },
  ["minimapzoom"]     = { "igam_mapZoom", function() IGAM_minimap() end, "Hide MinimapZoom-buttons", "Hide zoombuttons of minimap" },
  ["igam_wmbutton"]   = { "igam_WMButton", function() IGAM_ShowHide("igam_WMButton", "MiniMapWorldMapButton") end, "Hide MiniMapWorldMapButton", "Hide WorldMapButton on minimap" },
  ["minimapbutton"]   = { "igam_WMButton", function() IGAM_ShowHide("igam_WMButton", "MiniMapWorldMapButton") end, "Hide MiniMapWorldMapButton", "Hide WorldMapButton on minimap" },
  ["igam_fps"]        = { "igam_FPS", function() IGAM_FPS() end, "FPS-meter", "Show framerate in topleft" },
  ["fps"]             = { "igam_FPS", function() IGAM_FPS() end, "FPS-meter", "Show framerate in topleft" },
  ["igam_speedmeter"] = { "igam_SpeedMeter", function() IGAM_speed() end, "SpeedMeter", "show/hide speedmeter" },
  ["speed"]           = { "igam_SpeedMeter", function() IGAM_speed() end, "SpeedMeter", "show/hide speedmeter" },
  ["igam_qtt"]        = { "igam_QTT", function() IGAM_QTT() end, "QuickTagTarget", "show/hide QuickTagTarget" },
  ["qtt"]             = { "igam_QTT", function() IGAM_QTT() end, "QuickTagTarget", "show/hide QuickTagTarget" },
  ["qttv"]            = { "igam_QTTv", function() IGAM_QTT() end, "QuickTagTargetVertical", "vertical/horizontal QuickTagTarget" },
  ["pet"]             = { "", function() SummonRandomCritter() end, "", "Summon random pet (non-combat)" },
  ["reloadui"]        = { "", function() ReloadUI() end, "", "reloads the user interface" },
  ["help"]            = { "", function() IGAM_helptui() end, "", "Shows this help message" },
  ["options"]         = { "", function() InterfaceOptionsFrame_OpenToCategory(IGAM_Options); InterfaceOptionsFrame_OpenToCategory(IGAM_Options) end, "", "open options-window" },
  ["igam_hearth"]     = { "igam_hearth", "", "Hearthstone emotes", "enable/disable emotes on hearthstone-use" },
  ["hsemote"]         = { "igam_hearth", "", "Hearthstone emotes", "enable/disable emotes on hearthstone-use" },
  ["igam_hearthrnd"]  = { "igam_hearthRnd", "", "Random Hearthstone emotes", "random/fixed emotes on hearthstone-use" },
  ["hsemoterandom"]   = { "igam_hearthRnd", "", "Random Hearthstone emotes", "random/fixed emotes on hearthstone-use" },
  ["igam_ress"]       = { "igam_ress", "", "Resurrection emotes", "enable/disable emotes when resurrected" },
  ["ressemote"]       = { "igam_ress", "", "Resurrection emotes", "enable/disable emotes when resurrected" },
  ["igam_ressrnd"]    = { "igam_ressRnd", "", "Random Resurrection emotes", "random/fixed emotes when resurrected" },
  ["ressemoterandom"] = { "igam_ressRnd", "", "Random Resurrection emotes", "random/fixed emotes when resurrected" },
  ["igam_fchange"]    = { "igam_fChange", "", "faction-focus on rep-change", "focus faction when reputation changed" },
  ["factionchange"]   = { "igam_fChange", "", "faction-focus on rep-change", "focus faction when reputation changed" },
  ["igam_thp"]        = { "igam_THP", "", "TargetHealthPercent", "show/hide TargetHealthPercent" },
  ["thp"]             = { "igam_THP", "", "TargetHealthPercent", "show/hide TargetHealthPercent" },
  ["checkinv"]        = { "", function() IGAM_CheckInv() end, "", "Check your inventory" },
  ["ci"]              = { "", function() IGAM_CheckInv() end, "", "Check your inventory" },
  ["checkweekly"]     = { "", function() IGAM_CheckWeekly() end, "", "Check if done weekly stuff" },
  ["cw"]              = { "", function() IGAM_CheckWeekly() end, "", "Check if done weekly stuff" },
  ["igam_cflask"]     = { "igam_cFlask", function() IGAM_CheckWarnings() end, "flask-warning >lvl75", "warning if forgot flask" },
  ["cflask"]          = { "igam_cFlask", function() IGAM_CheckWarnings() end, "flask-warning >lvl75", "warning if forgot flask" },
  ["igam_cwellfed"]   = { "igam_cWellFed", function() IGAM_CheckWarnings() end, "foodbuff-warning >lvl75", "warning if not well-fed" },
  ["cfood"]           = { "igam_cWellFed", function() IGAM_CheckWarnings() end, "foodbuff-warning >lvl75", "warning if not well-fed" },
  ["igam_movewarn"]   = { "igam_moveWarn", function() IGAM_CheckWarnings() end, "frames movable", "move stuff around" },
  ["move"]            = { "igam_moveWarn", function() IGAM_CheckWarnings() end, "frames movable", "move stuff around" },
  ["drop"]            = { "", function() IGAM_DropJunk() end, "drop grey items", "Drops all grey items, no questions asked!" },
};

--- Function to check number of records in a given table ---
function IGAM_tcount(tab)
  local n = #tab
  if (n == 0) then
    for _ in pairs(tab) do
      n = n + 1;
    end
  end
  return n;
end

function IGAM_startup2() -- This part will be loaded when all variables are loaded
  -- Register the addon to watch for addon messages
    RegisterAddonMessagePrefix(IGAM_MSG_PREFIX);
  -- who am i :)
   IGAM_MYGUID = UnitGUID("player");
  -- create extra class-buttons --
   IGAM_ClassButtonsCreate();
  -- move frames to their apropriate places
   _G["IGAM_BagOverlay0"]:SetPoint("BOTTOMRIGHT", "MainMenuBarBackpackButton", "BOTTOMRIGHT", 0, 4);
   _G["IGAM_BagOverlay0"]:SetPoint("BOTTOMLEFT", "MainMenuBarBackpackButton", "BOTTOMLEFT", 0, 4);
--   _G["IGAM_BagOverlay"]:SetFrameLevel(_G["MainMenuBarBackpackButtonItemAnim"]:GetFrameLevel() + 4);
   for x = 1, 4, 1 do
      _G["IGAM_BagOverlay"..x]:SetPoint("BOTTOMRIGHT", "CharacterBag"..(x-1).."Slot", "BOTTOMRIGHT", 0, 3);
      _G["IGAM_BagOverlay"..x]:SetPoint("BOTTOMLEFT", "CharacterBag"..(x-1).."Slot", "BOTTOMLEFT", 0, 3);
   end

-- remove all errors about forbidden actions(1row). not right, I know, but it was irritating!
--  UIParent:HookScript("OnEvent", function(s, e, a1, a2) if e:find("ACTION_FORBIDDEN") and ((a1 or "")..(a2 or "")):find("IsDisabledByParentalControls") then StaticPopup_Hide(e) end; end)


 -- change the size of GameMenuFrame (1row)
  GameMenuFrame:HookScript("OnShow", function(self) self:SetHeight(GameMenuFrame:GetHeight() + 34) end);
 -- add my own function after UpdateMicroButtons() to hide buttons (1row)
  hooksecurefunc("UpdateMicroButtons", IGAM_MicroButton);
 -- add AFK-text to raidFrames when needed. (2rows)
  hooksecurefunc("CompactUnitFrame_UpdateStatusText", IGAM_CompactUnitFrame_UpdateStatusText);
  hooksecurefunc("CompactUnitFrame_OnUpdate", CompactUnitFrame_UpdateStatusText);
 -- add more exact duration on buffs (1row)
  hooksecurefunc("AuraButton_UpdateDuration", IGAM_AuraButton_UpdateDuration);
 -- add caster to buffs (2rows)
  hooksecurefunc("AuraButton_Update", IGAM_AuraButton_Update);
  hooksecurefunc("AuraButton_OnUpdate", IGAM_AuraButton_OnUpdate);
 -- castbar-text (2rows)
  hooksecurefunc("CastingBarFrame_OnUpdate", IGAM_CastingBarFrame_OnUpdate);
  CastingBarFrame:HookScript("OnHide", function() _G["CastTimeText"]:SetText(" ") end);
end
function IGAM_DisableConcurrentPlugins()
  local dis = false;
  if IsAddOnLoaded("Telo's BuffTimers") then DisableAddOn("Telo's BuffTimers") dis=true end
  if IsAddOnLoaded("Bag Status Meters") then DisableAddOn("Bag Status Meters") dis=true end
  if dis then ReloadUI() end
end

--- GetQuestTitle STARTS ---
--local frame = CreateFrame("GameTooltip", "igam_QuestInfoTooltipFrame", UIParent, "GameTooltipTemplate")
--frame:SetScript("OnTooltipSetQuest", function(self)
--	if not self.message then return end
--	local title = igam_QuestInfoTooltipFrameTextLeft1:GetText()
--	self:Hide()
--	DEFAULT_CHAT_FRAME:AddMessage(format(self.message, self.linkID, title))
--	self.message, self.linkID = nil, nil
--end )
--
--function tooltip:GetQuestTitle()
--  local title = igam_QuestInfoTooltipFrameTextLeft1:GetText()
--  DEFAULT_CHAT_FRAME:AddMessage(self["message"]:format(title))
--  self:SetScript("OnTooltipSetQuest", nil)
--end
--
--function IGAM_GetQuestTitle(msg, editBox)
--	local linkType, linkID = strsplit(" ", msg)
--	if linkType == "quest" then
--		if IsQuestFlaggedCompleted(linkID) then
--			frame.message = "Quest |cffffff00|Hquest:%d|h[%%s]|h|r flagged as completed."
--		else
--			frame.message = "Quest |cffffff00|Hquest:%d|h[%%s]|h|r is not completed or not available to character."
--		end
--		frame.linkID = linkID
--		DEFAULT_CHAT_FRAME:AddMessage("Retrieving quest information...")
--		frame:SetOwner(UIParent, "ANCHOR_NONE")
--		frame:SetHyperlink("quest:" .. linkID)
--	else
--		frame.message, frame.linkID = nil, nil
--	end
--end
--- GetQuestTitle STOPS ---

function IGAM_loadVariables()
 -- check version of plugin
  if IGAM_Save then
    if IGAM_Save[IGAM_NAME_REALM] then
      if IGAM_Save[IGAM_NAME_REALM].version ~= IGAM_VERSION then
        IGAM_Save_Old = { };
        IGAM_Save_Old_s = { };
        IGAM_Save_Old_d = { };
        IGAM_Save_Old_version = IGAM_Save[IGAM_NAME_REALM].version;
        if (IGAM_Save[IGAM_NAME_REALM].checkbutton ~=nil) then
          for i, v in pairs(IGAM_Save[IGAM_NAME_REALM].checkbutton) do
            IGAM_Save_Old[i] = v;
          end
        end
        if (IGAM_Save[IGAM_NAME_REALM].dropdown ~=nil) then
          for i, v in pairs(IGAM_Save[IGAM_NAME_REALM].dropdown) do
            IGAM_Save_Old_d[i] = v;
          end
        end
        if (IGAM_Save[IGAM_NAME_REALM].slider ~=nil) then
          for i, v in pairs(IGAM_Save[IGAM_NAME_REALM].slider) do
            IGAM_Save_Old_s[i] = v;
          end
        end
        IGAM_Save[IGAM_NAME_REALM] = nil;
        IGAM_LOADED = false;
      end
    end
  end
 -- Initialize the saved vairiables if they don't exist and hide/show appropriate things
  if( not IGAM_Save_FriendInfo ) then IGAM_Save_FriendInfo = { } end
  if( not IGAM_Save_FriendInfo[IGAM_NAME_REALM] ) then
    IGAM_Save_FriendInfo[IGAM_NAME_REALM] = { };
  end

  if( not IGAM_Save_sellDB ) then IGAM_Save_sellDB = { } end
  if( not IGAM_Save_sellDB[IGAM_NAME_REALM] ) then
    IGAM_Save_sellDB[IGAM_NAME_REALM] = { };
  end

  if not IGAM_Save then IGAM_Save = { } end
  if not IGAM_Save[IGAM_NAME_REALM] then
    IGAM_Save[IGAM_NAME_REALM] = {
      ["version"] = IGAM_VERSION,
      ["checkbutton"] = {
        ["igam_AutoInvite"]  = false, --enable/disable autoInvite
        ["igam_BagEnable"]   = true,  --show/hide BagOverlay
        ["igam_BagBar"]      = false, --show/hide bars over bags
        ["igam_BagLabel"]    = true,  --show/hide text over bags
        ["igam_BagColor"]    = true,  --show color on bars/text
        ["igam_BagTotal"]    = true,  --show/hide total slots in bag
        ["igam_BagFree"]     = true,  --show amount of free/used slots in bag
        ["igam_BagNotify"]   = true,  --show/hide BagFull-notify
        ["igam_BagSingle"]   = false, --show/hide BagFull-notify
        ["igam_BagSell"]     = false, --toggle autosell "gray" items
        ["igam_BagSellQ"]    = false, --show/hide autosell-notify
        ["igam_buffCaster"]  = true,  --show/hide BuffCaster
        ["igam_CastTime"]    = true,  --show/hide CastTime-notify
        ["igam_CastTimeInv"] = true,  --Invert CastTime-notify
        ["igam_debug"]       = false, --show the debug-window
        ["igam_fChange"]     = true,  --change faction-focus when gaining reputation
        ["igam_Griffin"]     = false, --show/hide the griffins in the mainbar
        ["igam_Latency"]     = true,  --show/hide the latency-bar in top-left
        ["igam_Party"]       = true,  --enable/disable IgamPartyCore
        ["igam_Repair"]      = true,  --enable/disable autorepair
        ["igam_RepairInv"]   = true,  --enable/disable autorepair inventory aswell
        ["igam_RepairGuild"] = false, --enable/disable autorepair from guildbank if allowed
        ["igam_AskRepair"]   = false, --ask if repair or not
        ["igam_resurrect"]   = false, --Automatically resurrects when resurrected by another player
        ["igam_ress"]        = true,  --be polite to your resurrecter, thank him :)
        ["igam_ressRnd"]     = false, --be polite to your resurrecter, thank him with random phrase
        ["igam_MainMenuBar"] = false, --toggle new/old style mainbar
        ["igam_MainMenuX"]   = false, --toggle new/old style mainbar
        ["igam_MicroButton"] = true,  --show/hide microbuttons in the mainbar
        ["igam_TNL"]         = true,  --show/hide TNL-meter
        ["igam_XP"]          = true,  --show/hide new XP-bar
        ["igam_3d"]          = true,  --toggle 3d portraits
        ["igam_3dback"]      = true,  --toggle 3d portraits
        ["igam_3dsquare"]    = false, --toggle 3d portraits cirle or square form
        ["igam_questLvl"]    = true,  --show/hide questlvl in questlog
        ["igam_mapCoords"]   = false, --show coordinates
        ["igam_mapFrame"]    = false, --Hide frame of minimap
        ["igam_mapMove"]     = true,  --frame of minimap movable
        ["igam_mapTime"]     = false, --Hide Timebutton of minimap
        ["igam_mapClock"]    = false, --Show clock
        ["igam_mapTop"]      = false, --Hide top border of minimap
        ["igam_mapSquare"]   = false, --Toggle minimap between square-circle-shaped
        ["igam_mapZoom"]     = false, --Hide zoombuttons of minimap
        ["igam_WMButton"]    = false, --Hide WorldMapButton on minimap
        ["igam_FPS"]         = true,  --Show framerate in topleft
        ["igam_SpeedMeter"]  = true,  --show/hide speedmeter
        ["igam_QTT"]         = true,  --show/hide QuickTagTarget
        ["igam_QTTv"]        = false, --vertical/horizontal QuickTagTarget
        ["igam_hearth"]      = true,  --enable/disable HearthEmotes
        ["igam_hearthRnd"]   = false, --random/fixed HearthEmotes
        ["igam_classextra"]  = true,  --show/hide extra classbuttons
        ["igam_THP"]         = true,  --show/hide TargetHealthPercent
        ["igam_cFlask"]      = true,  --show/hide warning for forgetting flask in boss-fight
        ["igam_cWellFed"]    = true,  --show/hide warning for forgetting being well-fed in boss-fight 
        ["igam_moveWarn"]    = false, --enable/disable movable warning-icons
      },
      ["dropdown"] = {
        ["igam_hearth1"]   = 1, -- emote (hearthstone), morning (06-12)
        ["igam_hearth2"]   = 2, -- emote (hearthstone), Afternoon (12-18)
        ["igam_hearth3"]   = 3, -- emote (hearthstone), Evening (18-24)
        ["igam_hearth4"]   = 4, -- emote (hearthstone), Night (00-06)
        ["igam_ress1"]     = 1, -- emote (resurrected), party
        ["igam_ress2"]     = 1, -- emote (resurrected), raid
        ["igam_ress3"]     = 1, -- emote (resurrected), alone
      },
      ["slider"] = {
        ["igam_hearthFrq"] = 50,  -- chance (%) to trigger emote when using hearthstone
        ["igam_ressFrq"]   = 100, -- chance (%) to trigger emote when resurrected
      },
    };
  end

  if IGAM_Save_Old~=nil then
    for i, v in pairs(IGAM_Save_Old) do
      IGAM_Save[IGAM_NAME_REALM].checkbutton[i] = v;
    end
    if IGAM_Save_Old_d~=nil then
      for i, v in pairs(IGAM_Save_Old_d) do
        IGAM_Save[IGAM_NAME_REALM].dropdown[i] = v;
      end
    end
    if IGAM_Save_Old_s~=nil then
      for i, v in pairs(IGAM_Save_Old_s) do
        IGAM_Save[IGAM_NAME_REALM].slider[i] = v;
      end
    end
    if( DEFAULT_CHAT_FRAME ) then
      DEFAULT_CHAT_FRAME:AddMessage("Igam's Custom AddOn: Settings transferred from version"..IGAM_Save_Old_version);
    end
    IGAM_Save_Old   = nil;
    IGAM_Save_Old_d = nil;
    IGAM_Save_Old_s = nil;
    IGAM_Save_Old_version=nil;
  end

  -- make sure frames arent movable
  IGAM_Save[IGAM_NAME_REALM].checkbutton["igam_moveWarn"] = false;

  IGAM_LOADED=true;
  IGAM_UpdateBags(0);
  IGAM_griffin();
  IGAM_Debug();
  IGAM_MainMenuBar();
  IGAM_minimap();
  IGAM_ToggleSubButtons();

  if( DEFAULT_CHAT_FRAME ) then
    DEFAULT_CHAT_FRAME:AddMessage("Igam's Custom AddOn "..IGAM_VERSION.."."..IGAM_REV.." loaded");
  end
  UIErrorsFrame:AddMessage("Igam's Custom AddOn loaded", 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME);

 --set different exalted-color for factions..
  FACTION_BAR_COLORS[8] = { r=0.3, g=0.6, b=0.8 };
end

function IGAM_toggleButton(button, msg)
  if not button or button == "" then return end
  IGAM_Save[IGAM_NAME_REALM].checkbutton[button] = not IGAM_Save[IGAM_NAME_REALM].checkbutton[button];
  if msg and IGAM_OPTBUTTON == 0 then
    DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG..msg..IGAM_STATUS[(IGAM_Save[IGAM_NAME_REALM].checkbutton[button])]);
  end
end

--IGAM_command([/igam-command])
local function IGAM_command(msg)
  msg = string.lower(msg);
  IGAM_OPTBUTTON = 0;
  if not msg or msg == "" then --  -> shows the Options-frame when not specified
    msg="options";
  end
  IGAM_OnClick(msg)
end

--IGAM_testcommand(/igamtest-command)
local function IGAM_testcommand(msg)
  msg = string.lower(msg);
  IGAM_OPTBUTTON = 0;
 -- add testcode here
end

-- IGAM_helptui() - print out the help-text in default chat
function IGAM_helptui()
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG.."help: the following commands are avaiable");
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG.."      and are presented in following syntax:");
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG.."      [command] - [helptext] - [status if saved]");
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG.."================================================");
  for index, valuegrid in pairs(IgamToggleCommand) do
    if not strfind(index,"^igam_") then
      local istrue=valuegrid[1];
      local onoff=" ";
      if valuegrid[4]=="" then valuegrid[4]=valuegrid[3] end
      if not (istrue=="") then
        if not (IGAM_Save[IGAM_NAME_REALM].checkbutton[istrue]==nil) then
           onoff=" - "..IGAM_STATUS[(IGAM_Save[IGAM_NAME_REALM].checkbutton[istrue])]
        else
          onoff=" - "..IGAM_STATUS["nil"];
        end
      end
      DEFAULT_CHAT_FRAME:AddMessage(IGAM_CMD..index.." - "..valuegrid[4]..onoff);
    end
  end
end

-- IGAM_OnClick([option-button] or [/igam-command])
function IGAM_OnClick(button)
  button = string.lower(button);
  local GotHit=false;
  for index, valuegrid in pairs(IgamToggleCommand) do
    if button==index then
      GotHit=true;
      if not (valuegrid[1]=="") then
        IGAM_toggleButton(valuegrid[1], valuegrid[3]);
      end
      if not (valuegrid[2]=="") then
        valuegrid[2]();
      end
    end
  end
  if not GotHit then
    IGAM_UpdateBags(12);
    if ( Igam_BankBagOpen ) then
      IGAM_updateBankBags();
    end
  end
  if button=="ping" then IGAM_SendAddonMsg("sendPing") end
end

function IGAM_ShowHide(opt, frm, inv)
  if not opt or not frm then return end
  local val = IGAM_Save[IGAM_NAME_REALM].checkbutton[opt];
  if inv then val = not val end
  if (val) then
    _G[frm]:Hide();
  else
    _G[frm]:Show();
  end
end

-- togglebuttons for sub-buttons in config-page

function IGAM_ToggleSubButtons(button)
  if not button then button='all' end
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagEnable then
    _G["igam_BagBar"]:Enable();
    _G["igam_BagLabel"]:Enable();
    _G["igam_BagColor"]:Enable();
    _G["igam_BagTotal"]:Enable();
    _G["igam_BagFree"]:Enable();
    _G["igam_BagNotify"]:Enable();
    _G["igam_BagSingle"]:Enable();
    _G["IGAM_BagOverlay"]:Show();
    IGAM_UpdateBags(12);
  else
    _G["igam_BagBar"]:Disable();
    _G["igam_BagLabel"]:Disable();
    _G["igam_BagColor"]:Disable();
    _G["igam_BagTotal"]:Disable();
    _G["igam_BagFree"]:Disable();
    _G["igam_BagNotify"]:Disable();
    _G["igam_BagSingle"]:Disable();
    _G["IGAM_BagOverlay"]:Hide();
  end
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_CastTime then
    _G["igam_CastTimeInv"]:Enable();
  else
    _G["igam_CastTimeInv"]:Disable();
  end
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_Repair then
    _G["igam_AskRepair"]:Enable();
    _G["igam_RepairInv"]:Enable();
    _G["igam_RepairGuild"]:Enable();
  else
    _G["igam_AskRepair"]:Disable();
    _G["igam_RepairInv"]:Disable();
    _G["igam_RepairGuild"]:Disable();
  end
end

--- message-handling to/from other users of this addon ---

function IGAM_SendAddonMsg(msgtype, arg1, arg2)
  GuildRoster();
  local GuildMember, _ = GetNumGuildMembers();
  if ( GuildMember > 0 ) then GuildMember=true; else GuildMember=false; end
  local SendOK, Q, SendMsg, SendMsgOld= false, "y", "", "";
  if ( msgtype=="DING!" ) then
    SendOK = true;
	SendMsgOld = msgtype..arg1;
	SendMsg = msgtype.."¤"..arg1;
--    if GuildMember then SendAddonMessage(IGAM_MSG_PREFIX, "DING!"..UnitLevel("player"), "GUILD") end
--    SendAddonMessage(IGAM_MSG_PREFIX, "DING!"..UnitLevel("player"), "RAID");
  elseif ( (msgtype=="VERSION:") or (msgtype=="sendPing") or (msgtype=="sendPong") ) then
    SendOK = true;
    SendMsgOld = msgtype..strlen(IGAM_REV)..IGAM_REV..strlen(IGAM_VERSION)..IGAM_VERSION..IGAM_RELDATE; --obsolete in next release
	SendMsg= msgtype.."¤"..IGAM_REV.."¤"..IGAM_VERSION.."¤"..IGAM_RELDATE
	if (msgtype=="sendPing") then print(IGAM_MSG.."sending ping to other") end
	if (msgtype=="sendPong") then Q="n" end
  end
  if SendOK then
    if (Q ~= "y") then
      SendAddonMessage(IGAM_MSG_PREFIX, SendMsg, "WHISPER", arg1);
    else
	  --next 3 rows are obsolete in next release
      if GuildMember then SendAddonMessage(IGAM_MSG_PREFIX, SendMsgOld, "GUILD") end
      SendAddonMessage(IGAM_MSG_PREFIX, SendMsgOld, "RAID"); --obsolete in next release
      if not (UnitInBattleground("player") ==nil) then SendAddonMessage(IGAM_MSG_PREFIX, SendMsgOld, "BATTLEGROUND") end --obsolete in next release

      if GuildMember then SendAddonMessage(IGAM_MSG_PREFIX, SendMsg, "GUILD") end
      SendAddonMessage(IGAM_MSG_PREFIX, SendMsg, "RAID");
      if not (UnitInBattleground("player") ==nil) then SendAddonMessage(IGAM_MSG_PREFIX, SendMsg, "BATTLEGROUND") end
    end
  end
end
function IGAM_GetAddonMsg(prefix, message, channel, sender)
  if not ( IGAM_core.PongTimer ) then IGAM_core.PongTimer = GetTime() end
--print(IGAM_MSG.." [Debug] "..prefix.." | "..message.." | "..channel.." | "..sender);
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_debug then print(IGAM_MSG.." [Debug] "..prefix.." | "..message.." | "..channel.." | "..sender) end
  if (prefix == IGAM_MSG_PREFIX) and ((sender ~= IGAM_NAME_REALM_) or IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_debug ) then
--  if (prefix == IGAM_MSG_PREFIX) then  -- for debug-uses
    local count=0;
    for match in string.gmatch(message, "¤") do count = count + 1 end
    local mtype, iarg1, iarg2, iarg3, iarg4, iarg5, iarg6, iarg7, iarg8, iarg9 = string.match(message, "¤");
	if count==0 then
      if ((strsub(message, 1, 8) == "VERSION:") or (strsub(message, 1, 8) == "sendPong")) then
        local RevLen = strsub(message, 9, 9);										-- length of revision number
        local CheckRev = strsub(message, 10, (9+RevLen));							-- revision number
        local VerLen = strsub(message, (10+RevLen), (10+RevLen));					-- length of version number
        local CheckVer = strsub(message, (11+RevLen), (10+RevLen+VerLen));		-- version number
        local CheckDate = strsub(message, (11+RevLen+VerLen), strlen(message));	-- date of release
        if (CheckRev > IGAM_REV) then
          if (not NEW_VERSION) then
            NEW_VERSION = true
            print(IGAM_MSG..CheckVer.."-"..CheckRev.."("..CheckDate..") is available, please update.")
          end
        end
        if (strsub(message, 1, 8) == "sendPong") then -- I got answer on ping?
          Q="a";
          print(IGAM_MSG..sender.." : "..CheckVer.."-"..CheckRev.."("..CheckDate..")");
        end
      elseif (strsub(message, 1, 5) == "DING!") then -- someone did lvlup?
        local tolvl = tonumber(strsub(message, 6, strlen(message) ) ) and tonumber(strsub(message, 6, strlen(message) ) ) or 0
        print(IGAM_MSG..IGAM_COLOR["CYAN"]..sender.." just gained level "..tolvl..".");
      elseif (strsub(message, 1, 8) == "sendPing") then -- someone pinged me?
        local CurTime = GetTime();
        if ( IGAM_core.PongTimer < CurTime ) then -- to prevent more than 1 answer at each question, 5sec delay
          IGAM_SendAddonMsg("sendPong", sender);
          IGAM_core.PongTimer = CurTime+5; -- add 5sec to timer
        end
      end
    else
      if ((mtype == "VERSION:") or (mtype == "sendPong")) then
        local CheckRev = iarg1;	-- revision number
        local CheckVer = iarg2;	-- version number
        local CheckDate = iarg3;	-- date of release
        if (CheckRev > IGAM_REV) then
          if (not NEW_VERSION) then
            NEW_VERSION = true
            print(IGAM_MSG..CheckVer.."-"..CheckRev.."("..CheckDate..") is available, please update.")
          end
        end
        if (mtype == "sendPong") then -- I got answer on ping?
          print(IGAM_MSG..sender.." : "..CheckVer.."-"..CheckRev.."("..CheckDate..")");
        end
      elseif (mtype == "DING!") then -- someone did lvlup?
        local tolvl = iarg1 and iarg1 or 0
        print(IGAM_MSG..IGAM_COLOR["CYAN"]..sender.." just reached level "..tolvl..".");
      elseif (mtype == "sendPing") then -- someone pinged me?
        local CurTime = GetTime();
        if ( IGAM_core.PongTimer < CurTime ) then -- to prevent more than 1 answer at each question, 5sec delay
          IGAM_SendAddonMsg("sendPong", sender);
          IGAM_core.PongTimer = CurTime+5; -- add 5sec to timer
        end
      end
    end
  end
end

--- other functions


function IGAM_IsInMyGuild(player) --checks if a certain player is in my own guild. returns true/false
  local user, realm = strsplit("-", player);
  if not realm then realm=IGAM_REALM end
  local userRealm = user.."-"..realm;
  if not realm == IGAM_REALM then return false end
  GuildRoster();
  local GuildMember, _ = GetNumGuildMembers();
  if ( GuildMember > 0 ) then
    for i=1,GuildMember do
      local name, rank, rankIndex, level, class, zone, note, officernote, online, status = GetGuildRosterInfo(i);
      if (string.lower(name) == string.lower(userRealm)) then
        return true;
      end
    end
  end
  return false;
end

--- IGAM_MainMenuBar STARTS ---

function IGAM_MainMenuBar()
  if not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_MainMenuBar then
    _G["MainMenuBar"]:SetHeight(53);
    _G["MainMenuExpBar"]:SetHeight(13);
    _G["MainMenuBarMaxLevelBar"]:SetHeight(13);
    _G["MainMenuBarArtFrame"]:SetHeight(53);
    _G["ReputationWatchBar"]:SetHeight(13);
    _G["ReputationWatchStatusBar"]:SetHeight(13);

    _G["ExhaustionLevelFillBar"]:Show();
--      _G["MainMenuXPBarTexture0"]:Show();
--      _G["MainMenuXPBarTexture1"]:Show();
--      _G["MainMenuXPBarTexture2"]:Show();
--      _G["MainMenuXPBarTexture3"]:Show();
    _G["MainMenuBarTexture0"]:Show();
    _G["MainMenuBarTexture1"]:Show();
    _G["MainMenuBarTexture2"]:Show();
    _G["MainMenuBarTexture3"]:Show();
    _G["MainMenuBarOverlayFrame"]:Show();
    _G["SlidingActionBarTexture0"]:Show();
    _G["SlidingActionBarTexture1"]:Show();
    _G["MainMenuExpBar"]:SetPoint("TOP", "MainMenuBar", "TOP", 0, 0);
    _G["MainMenuBarMaxLevelBar"]:SetPoint("TOP", "MainMenuBar", "TOP", 0, -11);
    _G["ReputationWatchStatusBar"]:SetPoint("TOP", "ReputationWatchBar", "TOP", 0, 0);
    _G["MainMenuBarBackpackButton"]:SetPoint("BOTTOMRIGHT", "MainMenuBarArtFrame", "BOTTOMRIGHT", -6, 3);
    _G["CharacterMicroButton"]:SetPoint("BOTTOMLEFT", "MainMenuBarArtFrame", "BOTTOMLEFT", 546, 2);
    _G["ActionButton1"]:SetPoint("BOTTOMLEFT", "MainMenuBarArtFrame", "BOTTOMLEFT", 8, 4);
    _G["ActionBarUpButton"]:SetPoint("CENTER", "MainMenuBarArtFrame", "TOPLEFT", 522, -22);
    _G["ActionBarDownButton"]:SetPoint("CENTER", "MainMenuBarArtFrame", "TOPLEFT", 522, -42);
    _G["MainMenuBarPageNumber"]:ClearAllPoints();
    _G["MainMenuBarPageNumber"]:SetPoint("CENTER", "MainMenuBarArtFrame", "CENTER", 30, -5);
    for ij=2, 12 do
      _G["ActionButton"..ij]:SetPoint("LEFT", _G["ActionButton"..(ij-1)]:GetName(), "RIGHT", 6, 0);
    end
  else
    _G["MainMenuBar"]:SetHeight(43);
    _G["MainMenuExpBar"]:SetHeight(1);
    _G["MainMenuBarMaxLevelBar"]:SetHeight(1);
    _G["MainMenuBarArtFrame"]:SetHeight(43);
    _G["ReputationWatchBar"]:SetHeight(1);
    _G["ReputationWatchStatusBar"]:SetHeight(1);

    _G["ExhaustionLevelFillBar"]:Hide();
--      _G["MainMenuXPBarTexture0"]:Hide();
--      _G["MainMenuXPBarTexture1"]:Hide();
--      _G["MainMenuXPBarTexture2"]:Hide();
--      _G["MainMenuXPBarTexture3"]:Hide();
    _G["MainMenuBarTexture0"]:Hide();
    _G["MainMenuBarTexture1"]:Hide();
    _G["MainMenuBarTexture2"]:Hide();
    _G["MainMenuBarTexture3"]:Hide();
    _G["MainMenuBarOverlayFrame"]:Hide();
    _G["SlidingActionBarTexture0"]:Hide();
    _G["SlidingActionBarTexture1"]:Hide();
    _G["MainMenuExpBar"]:SetPoint("TOP", "MainMenuBar", "TOP", -117, -250);
    _G["MainMenuBarMaxLevelBar"]:SetPoint("TOP", "MainMenuBar", "TOP", -117, -250);
    _G["ReputationWatchStatusBar"]:SetPoint("TOP", "ReputationWatchBar", "TOP", -117, -250);
    _G["CharacterMicroButton"]:SetPoint("BOTTOMLEFT", "MainMenuBarBackpackButton", "BOTTOMRIGHT", 2, -4);
    _G["ActionBarUpButton"]:SetPoint("TOPLEFT", "ActionButton12", "TOPRIGHT", 0, 10);
    _G["ActionBarDownButton"]:SetPoint("BOTTOMLEFT", "ActionButton12", "BOTTOMRIGHT", 0, -10);
    _G["MainMenuBarPageNumber"]:ClearAllPoints();
    _G["MainMenuBarPageNumber"]:SetPoint("LEFT", "ActionButton12", "RIGHT", 0, 0);
    if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_MainMenuX then
      _G["ActionButton1"]:SetPoint("BOTTOMLEFT", "MainMenuBarArtFrame", "BOTTOMLEFT", 39, 2);
      _G["MainMenuBarBackpackButton"]:SetPoint("BOTTOMRIGHT", "MainMenuBarArtFrame", "BOTTOMRIGHT", -297, 2);
    else
      _G["ActionButton1"]:SetPoint("BOTTOMLEFT", "MainMenuBarArtFrame", "BOTTOMLEFT", 8, 2);
      _G["MainMenuBarBackpackButton"]:SetPoint("BOTTOMRIGHT", "MainMenuBarArtFrame", "BOTTOMRIGHT", -328, 2);
    end
    for ij=2, 12 do
      _G["ActionButton"..ij]:SetPoint("LEFT", _G["ActionButton"..(ij-1)]:GetName(), "RIGHT", 0, 0);
    end
  end
  IGAM_MicroButton();
  IGAM_ShowPetActionBar();
  IGAM_griffin();
  IGAM_SingleBag();
end
function IGAM_ShowPetActionBar()
  if not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_MainMenuBar then
    SlidingActionBarTexture0:SetAlpha(1);
    SlidingActionBarTexture1:SetAlpha(1);
--      BonusActionBarTexture0:SetAlpha(1);
--      BonusActionBarTexture1:SetAlpha(1);
--*      ShapeshiftBarLeft:SetAlpha(1);
--*      ShapeshiftBarMiddle:SetAlpha(1);
--*      ShapeshiftBarRight:SetAlpha(1);
  else
    SlidingActionBarTexture0:SetAlpha(0);
    SlidingActionBarTexture1:SetAlpha(0);
--      BonusActionBarTexture0:SetAlpha(0);
--      BonusActionBarTexture1:SetAlpha(0);
--*      ShapeshiftBarLeft:SetAlpha(0);
--*      ShapeshiftBarMiddle:SetAlpha(0);
--*      ShapeshiftBarRight:SetAlpha(0);
  end
end

--- show/hide MicroButtons ---
function IGAM_MicroButton()
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_MicroButton or not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_MainMenuBar then
    CharacterMicroButton:SetPoint("BOTTOMLEFT",548, 2);
  else
    CharacterMicroButton:SetPoint("BOTTOMLEFT",548, -38);
  end
end

function IGAM_SingleBag()
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagSingle and IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_MainMenuBar then
    CharacterBag0Slot:Hide();
    CharacterBag1Slot:Hide();
    CharacterBag2Slot:Hide();
    CharacterBag3Slot:Hide();
    _G["IGAM_BagOverlay1"]:Hide();
    _G["IGAM_BagOverlay2"]:Hide();
    _G["IGAM_BagOverlay3"]:Hide();
    _G["IGAM_BagOverlay4"]:Hide();
    if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_MainMenuX then
      _G["MainMenuBarBackpackButton"]:SetPoint("BOTTOMRIGHT", "MainMenuBarArtFrame", "BOTTOMRIGHT", -465, 2);
    else
      _G["MainMenuBarBackpackButton"]:SetPoint("BOTTOMRIGHT", "MainMenuBarArtFrame", "BOTTOMRIGHT", -496, 2);
    end
  else
    CharacterBag0Slot:Show();
    CharacterBag1Slot:Show();
    CharacterBag2Slot:Show();
    CharacterBag3Slot:Show();
  end
  IGAM_UpdateBags(12);
end

--- IGAM_MainMenuBar STOPS ---
--- IGAM_GRIFFIN STARTS ---

function IGAM_griffin()
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_Griffin and not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_MainMenuBar then
    MainMenuBarLeftEndCap:Show();
    MainMenuBarRightEndCap:Show();
  else
    MainMenuBarLeftEndCap:Hide();
    MainMenuBarRightEndCap:Hide();
  end
end

--- IGAM_GRIFFIN STOPS ---
--- IGAM_QUESTLEVEL STARTS ----

function IGAM_GetQuestLogTitle(questLogID)
  questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily, questID = securecall("IGAM_Org_GetQuestLogTitle", questLogID);
  if ( isHeader or not questLogTitleText ) then
  elseif IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_questLvl then
    local leveltag = level;
    if (questTag and questTag == "Elite") then
      leveltag = leveltag .. "+";
    end
    questLogTitleText = "["..leveltag.."] "..questLogTitleText;
  end
  return questLogTitleText, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily, questID;
end
IGAM_Org_GetQuestLogTitle = GetQuestLogTitle;
GetQuestLogTitle = IGAM_GetQuestLogTitle;

--- IGAM_QUESTLEVEL STOPS ---
------ IGAM_RAIDFRAME

function IGAM_CheckAFK()
  for i=1,MAX_RAID_MEMBERS do
    local name, _ = GetRaidRosterInfo(i);
    if (not name == nil ) then
--    if UnitIsAFK(frame.name:GetText()) then
      local asd = _G["CompactRaidFrame"..i];
      IGAM_CompactUnitFrame_UpdateStatusText(asd);
    end
  end
end

--- Check if raidmember is AFK and set text for it ---
function IGAM_CompactUnitFrame_UpdateStatusText(frame)
  if not frame then return end
  if not frame.statusText then return end
  if not frame.unit then return end
  local visible = frame.statusText:IsShown();
  if UnitIsAFK(frame.unit) then
--  if UnitIsAFK(frame.displayedUnit) then
    frame.statusText:SetText("AFK")
    frame.statusText:Show();
  elseif not visible then
    frame.statusText:Hide();
  end
end

------
--- IGAM_DEBUG STARTS ----

function IGAM_Debug(text, chat)
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_debug then
    IGAM_DebugFrame:Show();
    IGAM_DebugText:SetText(text);
    if chat and DEFAULT_CHAT_FRAME then
      ChatFrame2:AddMessage(text);
    end
  else
    IGAM_DebugFrame:Hide();
  end
end
function IGAM_catchEvent(frame, event, ...)
  local arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9 = ...;
  if not IGAM_Save then return end
  if not IGAM_Save[IGAM_NAME_REALM] then return end
  if not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_debug then return end
  IGAM_DEBUGCOUNT=IGAM_DEBUGCOUNT+1;
  
DEFAULT_CHAT_FRAME:AddMessage("Igam: "..event.." | koll ");

  local a1, a2, a3, a4, a5, a6, a7, a8, a9;
  if  (event == CURSOR_UPDATE) then arg1 = "-"; end
  if  (arg1 == nil) then a1 = "-"; else a1 = arg1 end
  if  (arg2 == nil) then a2 = "-"; else a2 = arg2 end
  if  (arg3 == nil) then a3 = "-"; else a3 = arg3 end
  if  (arg4 == nil) then a4 = "-"; else a4 = arg4 end
  if  (arg5 == nil) then a5 = "-"; else a5 = arg5 end
  if  (arg6 == nil) then a6 = "-"; else a6 = arg6 end
  if  (arg7 == nil) then a7 = "-"; else a7 = arg7 end
  if  (arg8 == nil) then a8 = "-"; else a8 = arg8 end
  if  (arg9 == nil) then a9 = "-"; else a9 = arg9 end
  DEFAULT_CHAT_FRAME:AddMessage("Igam: "..IGAM_DEBUGCOUNT.." "..frame.." "..event.." | "..a1.." | "..a2.." | "..a3.." | "..a4.." | "..a5.." | "..a6.." | "..a7.." | "..a8.." | "..a9);
end

function IGAM_PPET() --check warlock pet names stored in DB
  for i, v in pairs(IGAM_WARLOCK_PET) do
    DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG.."| "..i.."| "..v);
  end
end
function AAA(iid) --check spellinfo for spell with id="iid"
  local te=GetSpellInfo(iid);
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG.." | "..iid.." = "..te);
end

--- IGAM_DEBUG STOPS ---
--- BAGSTATUS STARTS ---

local Igam_BankBagOpen;
local Igam_BagStart;
IGAM_NumSlots = {0, 0, 0, 0, 0};                    --Igam_NumSlots: global variable that holds the total number of slots per bag
IGAM_UsedSlots = {0, 0, 0, 0, 0};                   --IGAM_UsedSlots: global variable that holds the number of used slots per bag
IGAM_BagFull = {false, false, false, false, false}; --IGAM_BagFull: global variable used for displaying notifications only once


--IGAM_UpdateBags:
--    Purpose - Update the IGAM_NumSlots and IGAM_UsedSlots to accurately reflect the inventory
--              Also updates all meters that need to be updated
function IGAM_UpdateBags(bag, event)
  _G["IGAM_BagOverlay"]:SetFrameLevel(2);
  if not bag then bag = 11 end
  if event == "PLAYER_ENTERING_WORLD" then
    Igam_BagStart = true;
    IGAM_BagStatus(0);
  elseif not Igam_BagStart then
    return
  elseif event == "BANKFRAME_OPENED" or bag == 11 and Igam_BankBagOpen then
    Igam_BankBagOpen=1;
    for x = (NUM_BAG_SLOTS+1), (NUM_BAG_SLOTS+NUM_BANKBAGSLOTS), 1 do
      IGAM_updateBankBags(x);
    end
  elseif event == "BANKFRAME_CLOSED" then
    Igam_BankBagOpen=nil;
  elseif  bag >= 0 and bag <= 4 then
    IGAM_BagStatus(bag);
  elseif  bag >= (NUM_BAG_SLOTS+1) and bag <= (NUM_BAG_SLOTS+NUM_BANKBAGSLOTS) and Igam_BankBagOpen then
    IGAM_updateBankBags(bag);
  elseif bag == 12 and IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagEnable then
    for x = 0, 4, 1 do
      IGAM_BagStatus(x);
    end
  end
  if (IGAM_TITANBAG) then IGAM_TitanBag_OnEvent() end
end

function IGAM_BagStatus(bag)
  _G["IGAM_BagOverlay"]:Hide();
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagEnable then
    _G["IGAM_BagOverlay"]:Show();
    if  bag < 0 or bag > NUM_BAG_SLOTS or not IGAM_LOADED then return end
   --set currentbag to the current bar and get the number of slots in the current bag
    local currentbag = _G["IGAM_BagOverlay"..bag];             --currentbag: the current bag (and bar) being updated
    local currentbagtxt = _G["IGAM_BagOverlay"..bag.."Label"]; --currentbagtxt: the current text being updated
    local currentbagname = GetBagName(bag);--current bagname
    local num = GetContainerNumSlots(bag); --num: number of slots in the current bag
    local used = 0;                        --used: number of used slots in the current bag
    local slotsText=" ";                   --slotsText: the text that is to be displayed on the meter labels
   --Check if the current bag is an ammo bag or can't get the bag name
    if not currentbagname or num==0 then
      currentbag:Hide();
      IGAM_BagFull[bag+1] = false;
      return
    elseif bag ~=0 then
      local link = GetInventoryItemLink("player", ContainerIDToInventoryID(bag))
      if link ~= nil then
        local _,_,_,_,_,_,t = GetItemInfo(link)
        if (t == "Soul Bag" or t == "Ammo Pouch" or t == "Quiver" or t == "Enchanting Bag" or t == "Herb Bag" or t == "Engineering Bag") then
          currentbag:Hide();
          IGAM_BagFull[bag+1] = false;
          return
        end
      end
    end
    --If there is no bag in the current bag slot or it is an ammo bag, hide all of its meters
    --Reset the used slots global variable and
    --loop through every slot in the current bag and
    --increment the variable if an item exists
    used = 0;
    for slot = 1, num do
      if (GetContainerItemInfo(bag, slot)) then
        used = used + 1;
      end
    end
   --Save to the global variables
    IGAM_NumSlots[bag+1] = num;
    IGAM_UsedSlots[bag+1] = used;
   --below is for checking if bag is full or not
    fullnum = num;
    fullused = used;

    if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagSingle then
      currentbag = _G["IGAM_BagOverlay0"];
      currentbagtxt = _G["IGAM_BagOverlay0Label"];
      _G["IGAM_BagOverlay1"]:Hide();
      _G["IGAM_BagOverlay2"]:Hide();
      _G["IGAM_BagOverlay3"]:Hide();
      _G["IGAM_BagOverlay4"]:Hide();
      num = IGAM_NumSlots[1] + IGAM_NumSlots[2] + IGAM_NumSlots[3] + IGAM_NumSlots[4] + IGAM_NumSlots[5];
      used=IGAM_UsedSlots[1] +IGAM_UsedSlots[2] +IGAM_UsedSlots[3] +IGAM_UsedSlots[4] +IGAM_UsedSlots[5];
    end
    if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagBar then -- bars
     --Set the meter's min, max, and current values accordingly
      currentbag:SetMinMaxValues(0, num);
      currentbag:SetValue(used);
      if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagColor then -- check if colored bars. if not, make it gray
        currentbag:SetStatusBarColor(used/num*2, 2-used/num*2, 0, 0.6);
      else
        currentbag:SetStatusBarColor(0.5, 0.5, 0.5, 0.6);
      end
    else
      currentbag:SetMinMaxValues(0, 1);
      currentbag:SetValue(0);
    end
    if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagLabel then -- text
      if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagFree then
        slotsText = num - used;
      else
        slotsText = used;
      end
     --If the totals are shown in the individual labels, concatenate it onto the end of the text
      if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagTotal then
        slotsText = slotsText.."/"..num;
      end
     --If color is enabled and the bag is more than half full, color the label according to the 
     --ratio of used slots to total slots.
      if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagColor and not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagBar and (used/num>=0.5) then
        currentbagtxt:SetTextColor(used/num*2, 2-used/num*2, 0, 1.0);
      else
        --if not above, set Textcolor to white.
        currentbagtxt:SetTextColor(1.0, 1.0, 1.0, 1.0);
      end
    end
    currentbagtxt:SetText(slotsText);
    currentbag:Show();
    --If the current bag is full and notifications are enabled, check if a notification should be given
    if fullused == fullnum and IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagNotify then
      --If the bag was not full last check, give a notification and
      --set the full bag variable to true
      --Otherwise keep the full bag variable false
      if not IGAM_BagFull[bag+1] then
        local IGAM_BAG_MESG = IGAM_BACKPACK..IGAM_FULL;
        if bag > 0 then
          IGAM_BAG_MESG = IGAM_BAG..bag..IGAM_FULL;
        end
        UIErrorsFrame:AddMessage(IGAM_BAG_MESG, 1.0, 0.1, 1.0, 1.0, UIERRORS_HOLD_TIME);
        DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG..IGAM_COLOR.PURPLE..IGAM_BAG_MESG.."|r");
        IGAM_BagFull[bag+1] = true;
      end
    else
      IGAM_BagFull[bag+1] = false;
    end
  end
end

--IGAM_updateBankBags:
--    Purpose - Update the bank bar on bankbag when the bank frame is open
--    Parameters - the bag that will be changed (value: 5-11)
--    Returns - Nothing
function IGAM_updateBankBags(bag)
  if not Igam_BankBagOpen then return end
  local num = GetContainerNumSlots(bag); -- Total slots in the current bag
  local used = 0;  -- Used slots in the current bag
  local text; -- The text that is to be displayed on the bag
  local CurrentBagText = _G["BankFrameBag"..(bag-4).."Count"];--the current text being updated
  --if there is no bag in the current bank bag slot, then hide the bar
  if num == 0 then
    CurrentBagText:Hide();
  else
    --loop through every slot in the current bank bag and
    --increment the variable if an item exists
    for slot = 1, num do
      if GetContainerItemInfo(bag, slot) then
        used = used + 1;
      end
    end
    if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagFree then
      text = num - used;
    else
      text = used;
    end
    if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagTotal then
      text = text.."/"..num;
    end
    if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagColor and used / num >= 0.5 then
      CurrentBagText:SetTextColor(used/num*2, 2-used/num*2, 0, 1.0);
    else
      CurrentBagText:SetTextColor(1.0, 1.0, 1.0, 1.0);
    end
    CurrentBagText:SetText(text);
    CurrentBagText:Show();
  end
end

function IGAM_TitanBag_OnEvent()
  if (TitanPanelBagButtonText~=nil) then
    local num  = IGAM_NumSlots[1] + IGAM_NumSlots[2] + IGAM_NumSlots[3] + IGAM_NumSlots[4] + IGAM_NumSlots[5];
    local used = IGAM_UsedSlots[1] + IGAM_UsedSlots[2] + IGAM_UsedSlots[3] + IGAM_UsedSlots[4] + IGAM_UsedSlots[5];
    local r, g
    if used/num < .5 then r=0; g=1 else r=((used-(num/2))/(num/2))*2; g=2-r end
    TitanPanelBagButtonText:SetText(IGAM_COLOR.ORANGE..TUTORIAL_TITLE10..":|r "..used.."/"..num);
    TitanPanelBagButtonText:SetTextColor(r, g, 0, 1.0);
  end
end

---- BAGSTATUS STOPS ----
-- AUTOREPAIR STARTS -----

function IGAM_GetMoneyString(amount)
  if not amount then local amount=0 end
  local g = math.floor((amount) / COPPER_PER_GOLD);
  local s = math.floor((amount - (g * COPPER_PER_GOLD)) / COPPER_PER_SILVER);
  local c = math.fmod(amount, COPPER_PER_SILVER);
  if g>0 then
    return IGAM_COLOR.GOLD..g.."g "..IGAM_COLOR.SILVER..s.."s "..IGAM_COLOR.COPPER..c.."c|r";
  elseif s>0 then
    return IGAM_COLOR.SILVER..s.."s "..IGAM_COLOR.COPPER..c.."c|r";
  else
    return IGAM_COLOR.COPPER..c.."c|r";
  end
end
function IGAM_GetInvRepairCost()
  local invcost = 0;
  for bag = 0,4 do
    for slot = 1, GetContainerNumSlots(bag) do
      local hasCooldown, repairCost = GameTooltip:SetBagItem(bag,slot);
      if (repairCost) then invcost = invcost + repairCost; end
    end
  end
  return invcost;
end
function IGAM_RepairAllInventoryItems(repairinvcost)
  if not repairinvcost then local repairinvcost = IGAM_GetInvRepairCost() end
  if (not repairinvcost or repairinvcost == 0) then
    DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG..IGAM_REPAIR_INV_WHOLE.."|r", 100.0, 1.0, 1.0);
    return;
  end
  ShowRepairCursor();
  for bag = 0,4 do
    for slot = 1, GetContainerNumSlots(bag) , 1 do
      local hasCooldown, repairCost = GameTooltip:SetBagItem(bag,slot);
      if (repairCost and repairCost > 0) then
        UseContainerItem(bag,slot);
      end
    end
  end
  HideRepairCursor();
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG..IGAM_REPAIR_INV..IGAM_GetMoneyString(repairinvcost).."!|r", 100.0, 1.0, 1.0);
end
function IGAM_RepairAllItems()
  local igam_rg = IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_RepairGuild;
  local repaircost = GetRepairAllCost();
  local repairinvcost = IGAM_GetInvRepairCost();
  local repairfromguild = false;
  if (IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_Repair and CanMerchantRepair()) and (repaircost>0 or repairinvcost>0) then
    local playermoney = GetMoney();
	if ( IsInGuild() and CanGuildBankRepair() and igam_rg ) then repairfromguild = true end
    if (repaircost > playermoney and not repairfromguild) then
      DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG..IGAM_REPAIR_EQ_NO, 100.0, 1.0, 1.0);
      return
    elseif IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_AskRepair then
      StaticPopup_Show("REPAIR_EQ_CONFIRMATION");
    else
      RepairAllItems(repairfromguild);
      local repairmsg = IGAM_REPAIR_EQ;
	  local repairmsg2 = "";
      if (repairfromguild) then repairmsg = IGAM_REPAIR_EQ_GUILD end
      if (not repairfromguild and igam_rg) then repairmsg2 = " (GuildRepair disabled)" end
      DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG..repairmsg..IGAM_GetMoneyString(repaircost).."!"..repairmsg2.."|r", 100.0, 1.0, 1.0);
      if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_RepairInv then
        playermoney = GetMoney();
        if (repairinvcost > playermoney) then
          DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG..IGAM_REPAIR_INV_NO, 100.0, 1.0, 1.0);
        else
          IGAM_RepairAllInventoryItems(repairinvcost);
        end
      end
    end
  end
end

StaticPopupDialogs["REPAIR_INV_CONFIRMATION"] = {
  text = TEXT(IGAM_text["igam_repaircinv"]),
  button1 = TEXT(YES),
  button2 = TEXT(NO),
  OnAccept = function(self)
    IGAM_RepairAllInventoryItems();
  end,
  OnShow = function(self)
    MoneyFrame_Update(self:GetName().."MoneyFrame", IGAM_GetInvRepairCost());
  end,
  hasMoneyFrame = 1,
  timeout = 0,
};

StaticPopupDialogs["REPAIR_EQ_CONFIRMATION"] = {
  text = TEXT(IGAM_text["igam_repairconf"]),
  button1 = TEXT(YES),
  button2 = TEXT(NO),
  OnAccept = function(self)
    local repaircost = GetRepairAllCost();
    local repairfromguild = IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_RepairGuild;
    if not ((IsInGuild()) and ( CanGuildBankRepair() )) then repairfromguild=0 end
    RepairAllItems(repairfromguild);
    DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG..IGAM_REPAIR_EQ..IGAM_GetMoneyString(repaircost).."!|r", 100.0, 1.0, 1.0);
    if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_RepairInv then
      StaticPopup_Show("REPAIR_INV_CONFIRMATION");
    end
  end,
  OnShow = function(self)
    local repaircost = GetRepairAllCost();
    MoneyFrame_Update(self:GetName().."MoneyFrame", repaircost);
  end,
  hasMoneyFrame = 1,
  timeout = 0,
};

-- AUTOREPAIR STOPS ------
-- AUTORESURRECT+EMOTE STARTS -----

function IGAM_Event_resurrect(frame, event, arg1)
  if event == "RESURRECT_REQUEST" then
    IgamResser=arg1;
   --  don't autoresurrect while (group) is in combat or autoress not enabled;
    if ((not UnitAffectingCombat(arg1)) and (IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_autoresurrect)) then
      AcceptResurrect();
    end
  elseif (not (IgamResser == nil) and (IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_ress)) then
    if (IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_ressRnd) then
      DoEmote(IGAM_DROPDOWN.igam_ress[random(1,IGAM_tcount(IGAM_DROPDOWN.igam_ress))][2],IgamResser);
    else
      local ress1 = IGAM_Save[IGAM_NAME_REALM].dropdown.igam_ress1;
      local ress2 = IGAM_Save[IGAM_NAME_REALM].dropdown.igam_ress2;
      local ress3 = IGAM_Save[IGAM_NAME_REALM].dropdown.igam_ress3;
      if IsInRaid() then --raid
        DoEmote(IGAM_DROPDOWN.igam_ress[ress2][2],IgamResser);
      elseif GetNumGroupMembers() > 0 then --party
        DoEmote(IGAM_DROPDOWN.igam_ress[ress1][2],IgamResser);
      else --solo
        DoEmote(IGAM_DROPDOWN.igam_ress[ress3][2],IgamResser);
      end
    end
    IgamResser = nil;
  end
end

-- AUTORESURRECT+EMOTE STOPS --
---- AUTOSELL STARTS ----

function IGAM_AutoSell()
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagSell then
    IGAM_SellJunk(1);
    if (IgamLootSum > 0) then
      IGAM_SellJunk();
    end
  end
end
function IGAM_SellJunk(Calc)
  IgamLootSum=0;
  local IgamLootSum2=0;
  local bag, slot;
  for bag = 0, NUM_BAG_SLOTS do
    local BagSlots = GetContainerNumSlots(bag);
    if BagSlots > 0 then
      for slot = 1, BagSlots do
        local texture, itemCount, locked, quality = GetContainerItemInfo(bag, slot);
        local igamItemLink=GetContainerItemLink(bag, slot);
        if (IGAM_CheckJunk(igamItemLink) == 1) then
          igam_Tooltip:SetBagItem(bag, slot);
          IgamLootMoney = (select(11,GetItemInfo(igamItemLink)))*itemCount;
          IgamLootSum2=IgamLootSum2+IgamLootMoney;
          if Calc then
            GameTooltip:AddLine(itemCount.."x "..igamItemLink.." "..IGAM_GetMoneyString(IgamLootMoney), 1.0, 1.0, 1.0, 1);
          else
            if not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagSellQ then
              DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG .. " Sold "..IGAM_COLOR.WHITE .. itemCount.."x "..igamItemLink.." "..IGAM_GetMoneyString(IgamLootMoney), 0.0, .8, 1);
            end
            IgamLootSum=0;
            UseContainerItem(bag, slot);
          end
        end
      end
    end
  end
  IgamLootSum=IgamLootSum2;
  return IgamLootSum2;
end
function IGAM_CheckJunk(link)
  if not link then return 0 end
  if not IGAM_Save_sellDB then return end
  if not IGAM_Save_sellDB[IGAM_NAME_REALM] then return end
  local sellID = string.match(link, "item:(%d+)");
  local color = strmatch(link,"|c(%x+)|");
  if ("|c"..color == IGAM_COLOR.GRAY) then
    return 1; -- delete if gray
  elseif IGAM_Save_sellDB[IGAM_NAME_REALM][sellID] then
    return 1; -- delete if in exception list
  end
  return 0; -- do not delete
end
function IGAM_AddRemSell(exceptions)
  local itemID
  DEFAULT_CHAT_FRAME:AddMessage("exceptions: " .. exceptions);
  if (exceptions == "status" or exceptions == "list") then
    DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG .. "The following items is added:");
    for i in pairs(IGAM_Save_sellDB[IGAM_NAME_REALM]) do
      local _, nylink=GetItemInfo(i);
      if nylink ~=nil then
        DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG .. i .. " : " .. nylink);
      end
    end
  end
  for link in string.gmatch(exceptions,"|c%x+|Hitem:[%-?%d:]*|h%[.-%]|h|r") do
    itemID = string.match(link,"item:(%d+)");
    if itemID then
      if IGAM_Save_sellDB[IGAM_NAME_REALM][itemID] then
        IGAM_Save_sellDB[IGAM_NAME_REALM][itemID] = nil
        DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG .. "Removed " .. link .. " from delete-list.");
      else
        IGAM_Save_sellDB[IGAM_NAME_REALM][itemID] = true
        DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG .. "Added " .. link .. " to delete-list.");
      end
    else
      DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG .. "Invalid item link provided.");
    end
  end
end

---- AUTOSELL STOPS -----
--- BUFFCASTER STARTS ---

function IGAM_AuraButton_Update(buttonName, index, filter)
  local name, _, _, _, _, _, _, caster, _, _, _ = UnitAura(PlayerFrame.unit, index, filter);
  if ( name and caster ) then
    local buff = _G[buttonName..index];
    local _, class = UnitClassBase(caster);
    buff.caster = caster;
    buff.casterName = GetUnitName(caster);
	if class then
      buff.casterNameColor = "|c"..RAID_CLASS_COLORS[class]["colorStr"]..buff.casterName.."|r";
	end
  end
end

function IGAM_AuraButton_OnUpdate(self)
  if not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_buffCaster then return end
  if ( GameTooltip:IsOwned(self) ) then
    local modify=false;
    if ( self.casterNameColor ) then
      modify=self.casterNameColor;
    elseif ( self.casterName ) then
      modify=self.casterName;
    end
    if modify then
      GameTooltip:SetUnitAura(PlayerFrame.unit, self:GetID(), self.filter);
      GameTooltip:AddDoubleLine(" ", modify, 1, 1, 1, 1, 1, 1);
      GameTooltip:Show();
    end
  end
end

--- BUFFCASTER STOPS ---
--- BUFFTIMERS STARTS ---

local function IgamSetTimeText(button, time)
  local d, h, m, s = ChatFrame_TimeBreakDown(time);
  local text = "";
  if ( time > 0 ) and (time < 3600) then
    text = format(IGAM_FORMAT_TIME, m, s);
  elseif (time > 0) and (time < 86400) then
    button:SetTextColor(0.1,1.0,0.1,1.0);
    text = format(IGAM_FORMAT_TIME, h, m);
  elseif (time > 86400) then
    text = d.."days";
  end
  button:SetText(text);
end

function IGAM_AuraButton_UpdateDuration(buffButton, timeLeft)
  if not buffButton.duration or not timeLeft then return end
  IgamSetTimeText(buffButton.duration, timeLeft);
end

--- BUFFTIMERS STOPS ---
---- CHECK WEEKLY STARTS ----
IGAM_DB_CHECKS = {
  ["Galleon (World Boss)"] = 32098,
  ["Sha of Anger (World Boss)"] = 32099,
  ["Nalak (World Boss)"] = 32518,
  ["Oondasta (World Boss)"] = 32519,
  ["Isle of Thunder chest"] = 32609,
  ["The Four Celestials (Timeless Isle)"] = 33117,
  ["Ordos (World Boss)"] = 33118,
  ["GotWarforgedSeals"] = 33134,
  }
function IGAM_CheckWeekly()
  for i, v in pairs(IGAM_DB_CHECKS) do 
--    local asd, _, _, _, _, _, _, _, _ = GetQuestLogTitle(v);
    print(i..":"..IGAM_DONE[IsQuestFlaggedCompleted(v) and true or false]);
--    print(asd..":"..IGAM_DONE[IsQuestFlaggedCompleted(v) and true or false]);
  end
end
---- CHECK WEEKLY STOPS ----
---- DROPJUNK STARTS ----

function IGAM_DropJunk()
  for bag = 0, 4 do
    local BagSlots = GetContainerNumSlots(bag);
    if BagSlots > 0 then
      for slot = 1, BagSlots do
        local texture, itemCount, locked, quality = GetContainerItemInfo(bag, slot);
        if (GetContainerItemLink(bag, slot) ~= nil) then
          if quality==0 then
            PickupContainerItem(bag, slot);
            if CursorHasItem() then
              DeleteCursorItem();
              DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG ..IGAM_COLOR.WHITE .. itemCount.."x "..GetContainerItemLink(bag, slot).." Destroyed!", 0.0, .8, 1);
            end
          end
        end
      end
    end
  end
end

---- DROPJUNK STOPS -----
--- SpellcastBarText STARTS ----

function IGAM_CastingBarFrame_OnUpdate (self, elapsed)
  local text = " ";
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_CastTime and ( CastingBarFrame.casting or CastingBarFrame.channeling) then
    if CastingBarFrame.channeling then
      local value=self.value
      if value <=0 then value=0 end
      text = format(IGAM_FORMAT_10,(value));
    elseif IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_CastTimeInv then
      text = format(IGAM_FORMAT_10,(self.maxValue - self.value));
    else
      text = format(IGAM_FORMAT_10,(self.value));
    end
  end
  _G["CastTimeText"]:SetText(text);
end

--- SpellcastBarText STOPS -----
--- IGAM_XP_BARS STARTS ---

-- update the size of the xp bar texture
function IGAM_VBarUpdate(iBar, iCurrent, iMax)
  if not iBar or not iCurrent then return end
  if iCurrent == 0 or not iMax or iMax <= 0 then
    _G[iBar]:Hide();
    return;
  end
  if iCurrent > iMax then
    iCurrent = iMax;
  end
  _G[iBar]:SetHeight(_G["IgamXPBarBack"]:GetHeight() * iCurrent / iMax);
  _G[iBar]:Show();
end

-- update xp-bar
function IGAM_XPBUpdate(event)
  if not IGAM_Save then return end
  if not IGAM_Save[IGAM_NAME_REALM] then return end
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_XP then
    local playerxp = _G["IgamXPBar"];
    local petxp = _G[playerxp:GetName().."Pet"];
    local viewrep = _G[playerxp:GetName().."Rep"];
    local name, standingID, barMin, barMax, barValue = GetWatchedFactionInfo();
    if UnitLevel("player") == MAX_PLAYER_LEVEL then
      igamplayermaxlvl = true;
      IGAM_VBarUpdate(playerxp:GetName().."Fill", 0);
      IGAM_VBarUpdate(playerxp:GetName().."Extra", 0);
    end
    if name then
      local color=FACTION_BAR_COLORS[standingID]
      if igamplayermaxlvl then
        _G[playerxp:GetName().."Fill"]:SetVertexColor(color.r, color.g, color.b);
        IGAM_VBarUpdate(playerxp:GetName().."Fill", (barValue-barMin), (barMax-barMin));
      end
      _G[playerxp:GetName().."Rep"]:SetVertexColor(color.r, color.g, color.b);
      IGAM_VBarUpdate(playerxp:GetName().."Rep", (barValue-barMin), (barMax-barMin));
    else
      IGAM_VBarUpdate(playerxp:GetName().."Rep", 0);
    end
    if (arg1 == "player" or not arg1 ) and not igamplayermaxlvl then
      local iCurrent = UnitXP("player");
      local iMax = UnitXPMax("player");
      local iExhaust;
      IGAM_VBarUpdate(playerxp:GetName().."Fill", iCurrent, iMax);
      if (GetXPExhaustion()) then
        iExhaust = GetXPExhaustion();
        _G[playerxp:GetName().."Fill"]:SetVertexColor(0.0, 0.39, 0.88, 1.0);
        IGAM_VBarUpdate(playerxp:GetName().."Extra", (iCurrent + iExhaust), iMax);
      else
        _G[playerxp:GetName().."Fill"]:SetVertexColor(0.58, 0.0, 0.55, 1.0);
        IGAM_VBarUpdate(playerxp:GetName().."Extra", 0);
      end
    end
    if arg1 == "pet" or not arg1 or event == "UNIT_PET" and arg1 == "player" then
--         if GetPetHappiness() then
      if GetPetFoodTypes() then
        petxp:Show();
        IGAM_VBarUpdate(petxp:GetName().."Fill", GetPetExperience());
        IGAM_VBarUpdate(petxp:GetName().."Extra", 0);
        _G[petxp:GetName().."Fill"]:SetVertexColor(1.0, 1.0, 0.0);
      else
        petxp:Hide();
      end
    end
    playerxp:Show();
  else
    IgamXPBar:Hide();
    _G["IgamXPBarPet"]:Hide();
  end
  IGAM_TNL();
end

-- show the xp tooltip
function IgamXPBar_ShowTooltip()
  local CurXP = UnitXP("player");
  local MaxXP = UnitXPMax("player");
  local CurExhaust = GetXPExhaustion();
  local MaxIlvl, CurIlvl = GetAverageItemLevel();
  local name, standingID, barMin, barMax, barValue = GetWatchedFactionInfo();
  -- anchor and set XP % text
  GameTooltip:SetOwner(_G["IgamXPBar"], "ANCHOR_RIGHT");
  GameTooltip:SetText(IGAM_NAME.."     ("..LEVEL.." "..UnitLevel("player")..")");
--  GameTooltip:SetText(format("%s     (%s %s)",IGAM_NAME,LEVEL,UnitLevel("player")));
  GameTooltip:AddLine(format("%s: %.1f / %.1f",STAT_AVERAGE_ITEM_LEVEL,CurIlvl,MaxIlvl));
  if UnitLevel("player") ~= MAX_PLAYER_LEVEL then	-- check if still gaining xp
    GameTooltip:AddLine(" ");
    GameTooltip:AddLine(IGAM_XP_GAINED);
    if (CurExhaust) then	-- add rest state line if rested
      GameTooltip:AddLine(format(IGAM_FORMAT_XP, CurXP, MaxXP, 100 * CurXP / MaxXP), 0.0, 0.39, 0.88);
      GameTooltip:AddLine(IGAM_XP_RESTED..CurExhaust, 0.5, 0.8, 1.0);
    else
      GameTooltip:AddLine(format(IGAM_FORMAT_XP, CurXP, MaxXP, 100 * CurXP / MaxXP), 0.58, 0.0, 0.55);
    end
  end
  if name then
    GameTooltip:AddLine(" ");
    GameTooltip:AddLine(REPUTATION..":");
    local color=FACTION_BAR_COLORS[standingID]
    GameTooltip:AddLine(name..": ".._G["FACTION_STANDING_LABEL"..standingID].." "..(barValue-barMin).."/"..(barMax-barMin),color.r, color.g, color.b);
  end
  -- show it!
  GameTooltip:Show();
  IGAM_XPBUpdate("player")
end
function IgamXPBarPet_ShowTooltip()
  local CurXP, MaxXP = GetPetExperience();
  local petname = UnitName("pet");
  if not petname then petname= " " end
  -- anchor and set XP % text
  GameTooltip:SetOwner(_G["IgamXPBarPet"], "ANCHOR_RIGHT");
  GameTooltip:SetText(petname.."     ("..LEVEL..":"..UnitLevel("pet")..")");
  GameTooltip:AddLine(IGAM_XP_GAINED);
  GameTooltip:AddLine(format(IGAM_FORMAT_XP, CurXP, MaxXP, 100 * CurXP / MaxXP), 0.8, 1.0, 0.0);
  -- show it!
  GameTooltip:Show();
  IGAM_XPBUpdate("pet")
end

--- IGAM_XP_BARS STOPS ---
--- autoInvite STARTS ---
function IGAM_autoInvite(msg, sender)
  if not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_AutoInvite then return end
  if not UnitInRaid("player") then return end
  local _, CanInvite = GetRaidRosterInfo(UnitInRaid("player"));
  if CanInvite then -- can invite
    if strfind(msg,"^invite") or (msg == "inv") or strfind(msg,"^inv pl") then -- wants an invite
      if (GetNumGroupMembers()<40) then --not full raid?
        InviteUnit(sender); --invite
      else
       SendChatMessage("Autoreply: The raid is currently full", "WHISPER", nil, sender)
      end
    end
  end
end
--- autoInvite STOPS ---
----- Latencytimer -----

function IGAM_Latency()
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_Latency then
    IgamLatency:Show();
    local bandwidthIn, bandwidthOut, latency = GetNetStats();
    if latency == platency then return end
    platency = latency
    local R, G, B = 0;
    if (latency > 300) then R=1; end
    if (latency < 600) then G=1; end
    IgamLatency:SetTextColor(R, G, B, 0.8);
    IgamLatency:SetText("Latency: "..latency.." ms");
  else
    IgamLatency:Hide();
  end
end

function IGAM_Mem_OnMouseOver()
  local i;
  for i = 1, GetNumAddOns() do
    memUsageSinceGC[GetAddOnInfo(i)] = GetAddOnMemoryUsage(i)
  end
end

function IGAM_Mem_OnMouseOut()

end

function IGAM_TNL()
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_TNL and not igamplayermaxlvl then
    _G["IgamTNL"]:Show();
    _G["IgamTNL"]:SetText("XP TNL:\n"..(UnitXPMax("player") - UnitXP("player")));
  else
    _G["IgamTNL"]:Hide();
  end
end

----- FramesMeter -----

function IGAM_FPS()
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_FPS then
    local FPS = GetFramerate();
    local FPStext = format(IGAM_FORMAT_10, FPS);
    _G["IgamFPS"]:Show();
    if FPStext == pFPStext then return end
    pFPStext = FPStext
    local R, G, B = 0;
    if (FPS < 29) then R=1; end
    if (FPS > 10) then G=1; end
    IgamFPS:SetTextColor(R, G, B, 0.8);
    _G["IgamFPS"]:SetText("FPS: "..FPStext);
  else
    _G["IgamFPS"]:Hide();
  end
end

----- QuickTagTarget -----

local igamqttvertical=false
function IGAM_QTT(vertical)
  if (IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_QTT and ( UnitIsGroupLeader("player") or UnitIsGroupAssistant("player"))) or IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_moveWarn then
    if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_QTTv and not igamqttvertical then
      _G["IGAM_QuickTagTargetButton1"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButtonReady", "BOTTOMLEFT", 0, 0);
      _G["IGAM_QuickTagTargetButton2"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton1", "BOTTOMLEFT", 0, 0);
      _G["IGAM_QuickTagTargetButton3"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton2", "BOTTOMLEFT", 0, 0);
      _G["IGAM_QuickTagTargetButton4"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton3", "BOTTOMLEFT", 0, 0);
      _G["IGAM_QuickTagTargetButton5"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton4", "BOTTOMLEFT", 0, 0);
      _G["IGAM_QuickTagTargetButton6"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton5", "BOTTOMLEFT", 0, 0);
      _G["IGAM_QuickTagTargetButton7"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton6", "BOTTOMLEFT", 0, 0);
      _G["IGAM_QuickTagTargetButton8"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton7", "BOTTOMLEFT", 0, 0);
      _G["IGAM_QuickTagTargetButton9"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton8", "BOTTOMLEFT", 0, 0);
      _G["IGAM_QuickTagTarget"]:SetWidth(32);
      _G["IGAM_QuickTagTarget"]:SetHeight(210);
      igamqttvertical=true;
    elseif not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_QTTv and igamqttvertical then
      _G["IGAM_QuickTagTarget"]:SetWidth(210);
      _G["IGAM_QuickTagTarget"]:SetHeight(32);
      _G["IGAM_QuickTagTargetButton1"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButtonReady", "TOPRIGHT", 0, 0);
      _G["IGAM_QuickTagTargetButton2"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton1", "TOPRIGHT", 0, 0);
      _G["IGAM_QuickTagTargetButton3"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton2", "TOPRIGHT", 0, 0);
      _G["IGAM_QuickTagTargetButton4"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton3", "TOPRIGHT", 0, 0);
      _G["IGAM_QuickTagTargetButton5"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton4", "TOPRIGHT", 0, 0);
      _G["IGAM_QuickTagTargetButton6"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton5", "TOPRIGHT", 0, 0);
      _G["IGAM_QuickTagTargetButton7"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton6", "TOPRIGHT", 0, 0);
      _G["IGAM_QuickTagTargetButton8"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton7", "TOPRIGHT", 0, 0);
      _G["IGAM_QuickTagTargetButton9"]:SetPoint("TOPLEFT", "IGAM_QuickTagTargetButton8", "TOPRIGHT", 0, 0);
      igamqttvertical=false;
    end
    _G["IGAM_QuickTagTarget"]:Show();
  else
    _G["IGAM_QuickTagTarget"]:Hide();
  end
end

----- SpeedMeter -----

function IGAM_speed()
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_SpeedMeter then
    _G["IgamSpeed"]:Show();
    local speed = GetUnitSpeed("player")
    local pitch = ( IsFlying() and format(" %d\194\186|r", floor((GetUnitPitch("player") * 180 / PI) + 0.5)) )  or ""
    if speed == pspeed and pitch == ppitch then return end
    pspeed, ppitch = speed, pitch
    _G["IgamSpeed"]:SetText(format("|cffffffffSpeed: %d%%%s|r", floor((speed / 7 * 100) + 0.5), pitch));
  else
    _G["IgamSpeed"]:Hide();
  end
end

--- NotWellFed-warning ---
IGAM_MoveMe=false;

function IGAM_gotFoodBuff(instance)
 --instance = [true|false] -- also check if you are in an instance, always return true if not.
  if not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_cWellFed then return true end
  if instance then if not select(1, IsInInstance()) then return true end end
  if UnitBuff(PLAYER, IGAM_SPELL_WELLFED_NAME, nil, PLAYER) then return true end
  return false;
end

function IGAM_isInInstance()
  if select(1, IsInInstance()) then return true end
  return false;
end

function IGAM_haveFlask()
  if not IgamFrames["IgamFlask"] then return end
  if not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_cFlask then return true end
  local cSpec = GetSpecialization() or 0;
  if UnitLevel("player")<75 or not cSpec then return true end
  local flaskType, _ = select(6, GetSpecializationInfo(cSpec)) or "DAMAGER" --DAMAGER/TANK/HEALER
  if IGAM_CLASS=="WARLOCK" then 	--int
  elseif IGAM_CLASS=="DEATHKNIGHT" then	--dps=str, tank=sta
    if flaskType == "DAMAGER" then flaskType="DAMAGERSTR" end
  elseif IGAM_CLASS=="DRUID" then	--dps=int(1, balance)/agi(2,feral), tank=sta(3,guardian), heal=int+spi(4,resto)
    if cSpec == 2 then flaskType = "DAMAGERAGI" end
  elseif IGAM_CLASS=="HUNTER" then flaskType="DAMAGERAGI"; --agility
  elseif IGAM_CLASS=="MAGE" then	--int
  elseif IGAM_CLASS=="MONK" then	--dps=agi, tank=sta, heal=int+spi
    if flaskType == "DAMAGER" then flaskType="DAMAGERAGI" end
  elseif IGAM_CLASS=="PALADIN" then	--dps=str, tank=sta, heal=int+spi
    if flaskType == "DAMAGER" then flaskType="DAMAGERSTR" end
  elseif IGAM_CLASS=="PRIEST" then	--dps=int, heal=int+spi
  elseif IGAM_CLASS=="ROGUE" then flaskType="DAMAGERAGI"; --agility
  elseif IGAM_CLASS=="SHAMAN" then	--dps=int(ranged)/agi(2,enhancement), heal=heal
    if cSpec == 2 then flaskType = "DAMAGERAGI" end
  elseif IGAM_CLASS=="WARRIOR" then	--dps=str, tank=sta
    if flaskType == "DAMAGER" then flaskType="DAMAGERSTR" end
  end
  IgamFrames["IgamFlask"]:SetBackdrop( { bgFile = IGAM_FLASKS_ICON[flaskType] } )
  for i, v in pairs(IGAM_FLASKS[flaskType]) do
   if UnitBuff(PLAYER, select(1, GetSpellInfo(v)), nil, PLAYER) then return true end
  end
  for i, v in pairs(IGAM_FLASKS["GENERAL"]) do
   if UnitBuff(PLAYER, select(1, GetSpellInfo(v)), nil, PLAYER) then return true end
  end
  return false;
end

function IGAM_checkBuff(frame, func)
  if not frame and func then return end
  local f=frame
  if IGAM_Save[IGAM_NAME_REALM].checkbutton["igam_moveWarn"] then f:Show(); f:EnableMouse(true); return end
--  if not IGAM_Save[IGAM_NAME_REALM].checkbutton[f] then f:Hide(); return end
    
  local uhmT = tonumber(UnitHealthMax("target"));
  local uhmP = tonumber(UnitHealthMax("player"));
  if UnitLevel("target") < 0 and UnitHealth("target") * 100 / uhmT > 98 and (uhmT > uhmP * 2) and not func and UnitCanAttack("player", "target") then
    f:EnableMouse(false);
    f:Show()
  else
    f:Hide()
  end
end

function IGAM_CheckWarnings()
  IGAM_checkBuff(IgamFrames["IgamWellFed"], IGAM_gotFoodBuff())
  IGAM_checkBuff(IgamFrames["IgamFlask"], IGAM_haveFlask())
  for i=1, 9 do
   _G["IGAM_QuickTagTargetButton"..i]:EnableMouse(not IGAM_Save[IGAM_NAME_REALM].checkbutton["igam_moveWarn"])
  end
  IGAM_QTT()
end

function IGAM_CreateBuffWarningFrame(fName, point, px, py, parent, icon, onEvent)
 if not (fName and point and px and py and parent and icon and onEvent) then return end
 local f = CreateFrame("Frame", fName, IGAM_core)
  f:SetToplevel(1)
  f:SetPoint(point,px,py, parent)
  f:SetWidth(50) 
  f:SetHeight(50)
  f:SetScript("OnEvent", onEvent)
  f:RegisterForDrag("RightButton");
  f:SetScript("OnDragStart", function(self) if self:IsMovable() then self:StartMoving() end end);
  f:SetScript("OnDragStop", function(self) self:StopMovingOrSizing() end);
  f:SetMovable(true);
  f:EnableMouse(false)
  f:Hide()
  f:SetBackdrop( { bgFile = icon } )
  for i, v in pairs(igam_Events[fName]) do
    f:RegisterEvent(v);
  end
  for i, v in pairs(igam_UnitEvents[fName]) do
    f:RegisterUnitEvent(i, v);
  end
 IgamFrames[fName] = f;
end
IGAM_CreateBuffWarningFrame("IgamWellFed", "CENTER", -25, 200, "UIParent", select(3, GetSpellInfo(IGAM_SPELL_WELLFED)), function(self) IGAM_checkBuff(self, IGAM_gotFoodBuff()) end)
IGAM_CreateBuffWarningFrame("IgamFlask", "CENTER", 25, 200, "UIParent", IGAM_FLASKS_ICON["DAMAGER"], function(self) IGAM_checkBuff(self, IGAM_haveFlask()) end)

--- classbuttons ---

function IGAM_ClassButtonsCreate()
  local icf = CreateFrame("Frame", "IGAM_ClassFrame", UIParent);
  icf:SetScript("OnEvent", IGAM_ClassEvent);
  if IGAM_CLASS == "WARLOCK" then
  end
  for i, v in pairs(igam_Events[IGAM_CLASS]) do
    IGAM_ClassFrame:RegisterEvent(v);
  end
end

function IGAM_ClassCheck() -- checks once each second
  local ctime = GetTime();
  if IGAM_CLASS == "WARLOCK" then
  end
end


function IGAM_ClassEvent(frame,event,arg1,arg2,arg3,arg4,arg5, ...) -- only runs on events in IGAM_ClassFrame
  local ctime = GetTime();
  if IGAM_CLASS == "WARLOCK" then
    if event == "UNIT_PET" then
      if IGAM_Save[IGAM_NAME_REALM].Petnames == nil then IGAM_Save[IGAM_NAME_REALM].Petnames = { } end
      if arg1 == "player" and (UnitName("pet")) ~= "Unknown" then
        for i, v in pairs(IGAM_WARLOCK_PET) do
          if UnitCreatureFamily("pet") == i and UnitName("pet") ~= IGAM_Save[IGAM_NAME_REALM].Petnames[i] then
            IGAM_Save[IGAM_NAME_REALM].Petnames[i] = UnitName("pet");
            DEFAULT_CHAT_FRAME:AddMessage(IGAM_MSG.."|cffB0A0ff"..i.."'s name saved as |cffff0000<"..IGAM_Save[IGAM_NAME_REALM].Petnames[i]..">")
          end
        end
      end
    end
	IGAM_CURRENT_FLASK="INTELLECT";
  end
  event = nil;
end

function IGAM_buffcheck(unit, check, ct)
 -- ct = [name|texture] (checkType)
  if (ct ~= "name" or ct ~= "texture") then return false end
--  print("!!! True !!!");
--  return { true };
  for i=1, 40 do
    local name, _, icon, _, _, _, expire, source, _ = UnitBuff(unit, i);
    if icon~=nil then
	  if ct=="texture" then
        if (string.find(icon, texture)) then
          return { true, expire, source };
        end
	  end
    end
  end
  return { false };
end

--- 3D Portrait ---

function IGAM_SetPortraitTexture(texture,unit)
  local swapped =nil;
  local tname;
  local xpos;
  local ypos;
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_3d then
    PlayerPortrait:Hide();
    if texture and texture.GetLeft then
      tName = texture:GetName()
      xpos = texture:GetLeft()
      ypos = texture:GetTop()
      if tName and xpos and ypos and UnitExists(unit) then
        if(UnitIsVisible(unit)) then
          local width=texture:GetRight()-xpos
          local height=ypos-texture:GetBottom()
          if width>24 and height>24 then
            if not IGAM_pt[tName] then
              IGAM_CreateModel(texture);
            end
            local m = IGAM_pt[tName].modelLayer -- m = CharacterModelFrame
            m:SetUnit(unit)
            m:SetCamera(0)

            _,IGAM_pt[tName].class = UnitClass(unit)
            IGAM_ColorBackground(tName,IGAM_pt[tName].class)
            texture:Hide()
            m:Show()
            swapped = 1
          end
        else
          if (tName and IGAM_pt[tName]) then
            IGAM_pt[tName].modelLayer:Hide()
          end
        end
      end
    end
    if not swapped then
      IgamOriginal_SetPortraitTexture(texture,unit);
      texture:Show()
      if tName and IGAM_pt[tName] then
        IGAM_pt[tName]:Hide()
      end
    end
  else
    IgamOriginal_SetPortraitTexture(texture,unit);
  end
end

function IGAM_CreateModel(t)
  local tName = t:GetName()
  local width = t:GetWidth()
  local height = t:GetHeight()
  if t.GetParent and t:GetParent().GetFrameStrata and t:GetParent():GetFrameStrata()=="BACKGROUND" then
    t:GetParent():SetFrameStrata("LOW")
  end
  local modelName = tName.."Model"
  IGAM_pt[tName] = CreateFrame("Button",modelName,t:GetParent())
  local frame = IGAM_pt[tName]
  frame:EnableMouse(0)
  frame:SetWidth(width)
  frame:SetHeight(height)
  frame.width = width
  frame.height = height
  frame:SetPoint("CENTER",t,"CENTER",0,0)
  local strata
  if t.GetParent then
    strata = IGAM_SBI[(IGAM_SBN[t:GetParent():GetFrameStrata() or ""] or 1)-1]
  end
  frame:SetFrameStrata(strata or "BACKGROUND")
  frame.backLayer = frame:CreateTexture(modelName.."Back","BACKGROUND")
  frame.backLayer:SetTexture("Interface\\AddOns\\Igam\\bg")
  frame.backLayer:SetWidth(width)
  frame.backLayer:SetHeight(height)
  frame.backLayer:SetPoint("CENTER",frame,"CENTER",0,0)
  if not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_3dback then
    frame.backLayer:Hide()
  end
  frame.modelLayer = CreateFrame("PlayerModel",modelName.."Model",t:GetParent())
  frame.modelLayer:SetPoint("CENTER",frame,"CENTER",0,0)
  frame.modelLayer:SetFrameLevel(1)
  frame.modelLayer:SetScript("OnShow",function() frame.modelLayer:SetCamera(0) end)
  IGAM_3Dshape(tName);
  frame.modelLayer.timer = 0
end

function IGAM_ColorBackground(tName,class)
  local back = IGAM_pt[tName].backLayer
  local color = RAID_CLASS_COLORS[class or ""]
  if color then
    back:SetVertexColor(color.r/1.5,color.g/1.5,color.b/1.5,1)
  else
    back:SetVertexColor(.5,.5,.5,1)
  end
    if not IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_3dback then
    back:Hide()
  end
end

function IGAM_3Drefresh()
  for i in pairs(IGAM_pt) do
    if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_3dback then
      IGAM_pt[i].backLayer:Show()
    else
      IGAM_pt[i].backLayer:Hide()
    end
    IGAM_3Dshape(i)
  end
end

function IGAM_3Dshape(i)
  if not i or type(i)~="string" or not IGAM_pt[i] then
    return;
  end

  local back = IGAM_pt[i].backLayer
  local model = IGAM_pt[i].modelLayer
  local texture = _G[i]
  if texture then
    width = texture:GetWidth()
    height = texture:GetHeight()
  else
    width = IGAM_pt[i].width
    height = IGAM_pt[i].height
  end
  if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_3dsquare then
    back:SetTexCoord(.2,.8,.2,.8)
    back:ClearAllPoints()
    back:SetPoint("TOPLEFT",i,"TOPLEFT")
    back:SetPoint("BOTTOMRIGHT",i,"BOTTOMRIGHT",IGAM_X,IGAM_Y)
    model:ClearAllPoints()
    model:SetPoint("TOPLEFT",i,"TOPLEFT")
    model:SetPoint("BOTTOMRIGHT",i,"BOTTOMRIGHT",IGAM_X,IGAM_Y)
  else
    back:SetTexCoord(0,1,0,1)
    back:ClearAllPoints()
    back:SetPoint("CENTER",i,"CENTER",IGAM_X,IGAM_Y)
    back:SetWidth(width)
    back:SetHeight(height)
    model:ClearAllPoints()
    model:SetPoint("CENTER",i,"CENTER",IGAM_X,IGAM_Y)
    model:SetWidth(width*.75)
    model:SetHeight(height*.75)
  end
end
--- Minimap ---

MinimapCluster:SetMovable(true);
Minimap:RegisterForDrag("RightButton");
Minimap:SetScript("OnDragStart", function() IGAM_mapDrag(true) end);
Minimap:SetScript("OnDragStop", function() IGAM_mapDrag(false) end);
MinimapZoneTextButton:RegisterForDrag("RightButton");
MinimapZoneTextButton:SetScript("OnDragStart", function() IGAM_mapDrag(true) end);
MinimapZoneTextButton:SetScript("OnDragStop", function() IGAM_mapDrag(false) end);

function IGAM_minimap()
  IGAM_ShowHide("igam_mapFrame", "MinimapBorder");
  IGAM_ShowHide("igam_WMButton", "MiniMapWorldMapButton");
  IGAM_ShowHide("igam_mapZoom", "MinimapZoomIn");
  IGAM_ShowHide("igam_mapZoom", "MinimapZoomOut");
  IGAM_ShowHide("igam_mapTime", "GameTimeFrame");
  IGAM_ShowHide("igam_mapTop", "MinimapBorderTop");
  IGAM_ShowHide("igam_mapClock", "IgamClock", 1);
--  IGAM_ShowHide("igam_mapCoords", "IgamCoords", 1);
  IGAM_Coords()
  IGAM_mapSquare();
end

function IGAM_mapDrag(x)
  if(x and IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_mapMove) then
    MinimapCluster.isMoving = true;
    MinimapCluster:StartMoving();
  elseif(MinimapCluster.isMoving) then
    MinimapCluster.isMoving = false;
    MinimapCluster:StopMovingOrSizing();
  end
end

function IgamMinimapMousewheel(self, x)
  local zoom=Minimap:GetZoom();
  if(x == 1) then if(zoom<(Minimap:GetZoomLevels()-1)) then Minimap_ZoomInClick(); end elseif (zoom>0) then Minimap_ZoomOutClick() end
end

function IGAM_mapSquare()
  if(IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_mapSquare) then
    MinimapBorder:SetTexture(IGAM_SQ_texture)
    Minimap:SetMaskTexture(IGAM_SQ_mask)
  else
    MinimapBorder:SetTexture("Interface\\Minimap\\UI-Minimap-Border")
    Minimap:SetMaskTexture("textures\\MinimapMask")
  end
end

--- Clock ---
function IGAM_Clock()
  local h, m = GetGameTime();
  if(IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_mapClock12) then
    if (h >= 12) then
      IgamClock:SetText(format(TEXT(TIME_TWELVEHOURPM), (h-12), m));
    else
      if (h == 0) then h = 12 end
      IgamClock:SetText(format(TEXT(TIME_TWELVEHOURAM), h, m));
    end
  else
    IgamClock:SetText(format(TEXT(IGAM_FORMAT_TIME), h, m));
  end
end

--- Coordinates ---

function IGAM_Coords()
  if not (TimeManagerClockButton ~= nil) then IgamCoords:Hide(); return end
  if (IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_mapCoords) then
    if not IgamCoords:IsVisible() then
     IgamCoords:Show();
     TimeManagerClockButton:SetSize(60,56);
--     TimeManagerAlarmFiredTexture:SetTexCoord(left,right,top,bottom);
    end
    local x, y = GetPlayerMapPosition("player");
    IgamCoords:SetText(math.floor(x * 100)..", "..math.floor(y * 100));
  elseif (IgamCoords:IsVisible()) then
    IgamCoords:Hide();
    TimeManagerClockButton:SetSize(60,28);
--      TimeManagerAlarmFiredTexture:SetTexCoord(0.015625,0.8125,0.51625,0.890625);
  end
end

--- CheckInventory ---

function IGAM_CheckInv()
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_HEAD));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_NECK));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_SHOULDER));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_CHEST));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_WAIST));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_LEGS));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_FEET));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_WRIST));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_HAND));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_FINGER1));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_FINGER2));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_TRINKET1));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_TRINKET2));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_BACK));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_MAINHAND));
  DEFAULT_CHAT_FRAME:AddMessage(IGAM_CheckInvSpec(INVSLOT_OFFHAND));
end
igam_slots={ HEADSLOT, NECKSLOT, SHOULDERSLOT, " ", CHESTSLOT, WAISTSLOT, LEGSSLOT, FEETSLOT, WRISTSLOT, HANDSSLOT, FINGER0SLOT_UNIQUE, FINGER1SLOT_UNIQUE, TRINKET0SLOT_UNIQUE, TRINKET1SLOT_UNIQUE, BACKSLOT, MAINHANDSLOT, SECONDARYHANDSLOT };
igam_slots_checkenchant={ false, false, true, false, true, true, true, true, true, true, false, false, false, false, true, true, true };
function IGAM_CheckInvSpec(slot)
  if (GetInventoryItemTexture("player", slot) ==nil ) then return igam_slots[slot]..": no item" end;
  local _, link, quality, iLevel = GetItemInfo(GetInventoryItemID("player", slot));
--  if not link then return igam_slots[slot]..": no item" end;
  local _, itemId, enchantId, jewelId1, jewelId2, jewelId3, jewelId4, suffixId, uniqueId, linkLevel, reforgeId = strsplit(":", GetInventoryItemLink("player", slot));
  local enchant=IGAM_COLOR["RED"].."no enchant|r";
  if not (igam_slots_checkenchant[slot]) then enchant=" " end;
  if (tonumber(enchantId) > 0 ) then enchant=IGAM_COLOR["GREEN"].."enchanted|r" end
  local g1, g2, g3 = GetInventoryItemGems(slot);
  local g0=", gems: "
  if (g1 ~= nil) then _, g1=GetItemInfo(g1) else g1 = "" end;
  if (g2 ~= nil) then _, g2=GetItemInfo(g2) else g2 = "" end;
  if (g3 ~= nil) then _, g3=GetItemInfo(g3) else g3 = "" end;
 if (g1..g2..g3=="") then g0="" end;
  return igam_slots[slot]..": iLvl="..iLevel.." "..link..", "..enchant..g0..g1.." "..g2.." "..g3;
end

--- CORE ---

function IGAM_OnLoad()
 -- add text on UI --
  -- CastTime + Latency + TNL --
  IGAM_core:CreateFontString("CastTimeText" ,"ARTWORK" ,"TextStatusBarText");
  IGAM_core:CreateFontString("IgamLatency" ,"ARTWORK" ,"IGAM_Font1");
  IGAM_core:CreateFontString("IgamFPS" ,"ARTWORK" ,"IGAM_Font1");
  IGAM_core:CreateFontString("IgamSpeed" ,"ARTWORK" ,"IGAM_Font1");
  IGAM_core:CreateFontString("IgamTNL" ,"ARTWORK" ,"IGAM_Font1");
  IGAM_core:CreateFontString("IgamClock" ,"ARTWORK" ,"GameFontNormalSmall");
  IGAM_core:CreateFontString("IgamCoords" ,"ARTWORK" ,"GameFontNormalSmall");
  IGAM_core:CreateFontString("IgamTargetHealthPercent" ,"ARTWORK" ,"GameFontNormalSmall");
  IGAM_core:CreateFontString("IgamFocusHealthPercent" ,"ARTWORK" ,"GameFontNormalSmall");
  CastTimeText:SetPoint("BOTTOMLEFT", "CastingBarFrame", "TOP", 0, 0);
  IgamLatency:SetPoint("TOPRIGHT", "PlayerFrame", "TOP", 0, 1);
  IgamFPS:SetPoint("TOPLEFT", "PlayerFrame", "TOP", 10, 1);
  IgamSpeed:SetPoint("TOPLEFT", "IgamFPS", "BOTTOMLEFT", 38, 0);
  IgamTNL:SetPoint("TOPLEFT", "IgamXPBar", "BOTTOM", 0, 0);
  IgamClock:SetPoint("TOPRIGHT", "Minimap", "TOPRIGHT", 0, 0);
  IgamCoords:SetPoint("BOTTOM", "Minimap", "BOTTOM", 0, 0);
  IgamTargetHealthPercent:SetPoint("RIGHT", "TargetFrameHealthBar", "LEFT", 10, 0);
  TargetFrameHealthBar:SetScript("OnHide", function() IgamTargetHealthPercent:SetText(" ") end);
  TargetFrameTextureFrame:SetScript("OnUpdate", function() local UHM=UnitHealthMax("target"); if (UHM > 0 and IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_THP) then IgamTargetHealthPercent:SetText((floor(100*((UnitHealth("target")+.5)/UnitHealthMax("target")))).."%") else IgamTargetHealthPercent:SetText(" ") end end);
  IgamFocusHealthPercent:SetPoint("RIGHT", "FocusFrameHealthBar", "LEFT", 3, 0);
  FocusFrameHealthBar:SetScript("OnHide", function() IgamFocusHealthPercent:SetText(" ") end);
  FocusFrameTextureFrame:SetScript("OnUpdate", function() local UHM=UnitHealthMax("focus"); if (UHM > 0 and IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_THP) then IgamFocusHealthPercent:SetText((floor(100*((UnitHealth("focus")+.5)/UnitHealthMax("focus")))).."%") else IgamFocusHealthPercent:SetText(" ") end end);
  IgamCoords:Hide();

 -- register events --
  for i, v in pairs(igam_Events["IGAM_CORE"]) do
    IGAM_core:RegisterEvent(v);
  end
 -- BagStatus
  for i, v in pairs(igam_Events["IGAM_BAG"]) do
    IGAM_BagOverlay:RegisterEvent(v);
  end

  IgamOriginal_SetPortraitTexture = SetPortraitTexture;
  SetPortraitTexture = IGAM_SetPortraitTexture;

 -- register OnEvent (1line)
  IGAM_BagOverlay:SetScript("OnEvent", function(event)IGAM_catchEvent("IGAM_BagOverlay",event) IGAM_UpdateBags(tonumber(bagID), event) end);
  MainMenuBarBackpackButton:SetScript("OnClick", function()if ( IsShiftKeyDown() or IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagSingle) then ToggleAllBags() else ToggleBackpack() end end);
 -- sets the scripts for the DebugFrame
--  IGAM_DebugFrame:RegisterForClicks("RightButtonDown","RightButtonUp");
  IGAM_DebugFrame:SetScript("OnMouseUp", function(self, button) IGAM_DebugFrame:StopMovingOrSizing() end);
  IGAM_DebugFrame:SetScript("OnMouseDown", function(self, button) if (button == "RightButton") then IGAM_DebugFrame:StartMoving() end end);

 -- Register the "/igam" slash command
  SlashCmdList["IGAMCOMMAND"] = IGAM_command;
  SLASH_IGAMCOMMAND1 = "/igam";
  SlashCmdList["IGAMTESTCOMMAND"] = IGAM_testcommand;
  SLASH_IGAMTESTCOMMAND1 = "/igamtest";
  SlashCmdList["IGAMCOMMANDSELL"] = IGAM_AddRemSell;
  SLASH_IGAMCOMMANDSELL1 = "/igamsell";
  SlashCmdList["IGAMCOMMANDDROP"] = IGAM_DropJunk;
  SLASH_IGAMCOMMANDDROP1 = "/igamdrop";

 --options-menu starts here--
  local iop = CreateFrame("Frame", "IGAM_Options", UIParent);
  iop:SetBackdrop({ bgFile="Interface/Glues/MODELS/UI_MAINMENU/DarkPortal_stone_01", nil, tile=false, tileSize=32, edgeSize=32, insets={ left=5, right=6, top=5, bottom=6 }});
  IGAM_Options:SetScript("OnShow", function() IGAM_MemUsage:SetText("AddonMemUsage: "..format(IGAM_FORMAT_10,(math.floor(gcinfo()*1000/1024)/1000)).."Mb") end);

 -- bind addon to interface-menu --
  IGAM_Options.name=BINDING_HEADER_IGAM
  InterfaceOptions_AddCategory(IGAM_Options);
 -- memusage-text --
  IGAM_Options:CreateFontString("IGAM_MemUsage" ,"ARTWORK" ,"GameFontHighlight");
  IGAM_MemUsage:SetPoint("BOTTOMRIGHT", "IGAM_Options", "BOTTOMRIGHT", -9, 12);
 -- version-text --
  IGAM_Options:CreateFontString("IGAM_VersionShow" ,"ARTWORK" ,"GameFontHighlight"); 
  IGAM_VersionShow:SetPoint("TOPRIGHT", "IGAM_Options", "TOPRIGHT", -40, -13);
  IGAM_VersionShow:SetText(IGAM_VERSION.."-"..IGAM_REV);

 -- buttons in top row --
  -- X in corner --
   local button = CreateFrame("Button", "igam_b_Close", IGAM_Options, "UIPanelCloseButton");
   button:SetPoint("TOPRIGHT", "IGAM_Options", "TOPRIGHT", -5, -5);
  -- load defaults-button --
   local button = CreateFrame("Button", "IGAM_Options_Default", IGAM_Options, "GameMenuButtonTemplate");
   button:SetPoint("TOPLEFT", "IGAM_Options", "TOPLEFT", 12, -12);
   _G[button:GetName().."Text"]:SetText(IGAM_OPTIONS_DEFAULT);
   button:SetScript("OnClick", function() IGAM_Save[IGAM_NAME_REALM] = nil; IGAM_loadVariables() end);
   button:SetWidth(55);
   button:SetHeight(21);
  -- reloadui-button --
   local button = CreateFrame("Button", "IGAM_Options_ReloadUI", IGAM_Options, "GameMenuButtonTemplate");
   button:SetPoint("LEFT", "IGAM_Options_Default", "RIGHT", 5, 0);
   _G[button:GetName().."Text"]:SetText(IGAM_OPTIONS_RELOADUI);
   button:SetScript("OnClick", function() ReloadUI() end);
   button:SetWidth(65);
   button:SetHeight(21);
  -- debugbutton --
   local button = CreateFrame("Button", "IGAM_Options_Debug", IGAM_Options, "GameMenuButtonTemplate");
   button:SetPoint("TOPRIGHT", "IGAM_Options", "TOPRIGHT", -20, -65);
   _G[button:GetName().."Text"]:SetText(IGAM_OPTIONS_DEBUG);
   button:SetScript("OnClick", function() IGAM_toggleButton("igam_debug", false); IGAM_Debug() end);
   button:SetWidth(55);
   button:SetHeight(21);
  -- divider --
   local div = CreateFrame("Frame", "igam_divLine", IGAM_Options, "IGAM_Line");
  -- Menubuttons --
   local button = CreateFrame("Button", "igam_MenuButton1", IGAM_Options, "IGAM_ButtonTemplate");
   button:SetPoint("TOPLEFT", "IGAM_Options", "TOPLEFT", 20, -65);
--   local button = CreateFrame("Button", "igam_MenuButton2", IGAM_Options, "IGAM_ButtonTemplate");
--   button:SetPoint("TOPLEFT", "igam_MenuButton1", "BOTTOMLEFT", 0, 0);
   local button = CreateFrame("Button", "igam_MenuButton3", IGAM_Options, "IGAM_ButtonTemplate");
   button:SetPoint("TOPLEFT", "igam_MenuButton1", "BOTTOMLEFT", 0, 0);
   local button = CreateFrame("Button", "igam_MenuButton4", IGAM_Options, "IGAM_ButtonTemplate");
   button:SetPoint("TOPLEFT", "igam_MenuButton3", "BOTTOMLEFT", 0, 0);
   local button = CreateFrame("Button", "igam_MenuButton5", IGAM_Options, "IGAM_ButtonTemplate");
   button:SetPoint("TOPLEFT", "igam_MenuButton4", "BOTTOMLEFT", 0, 0);
   local button = CreateFrame("Button", "igam_MenuButton6", IGAM_Options, "IGAM_ButtonTemplate");
   button:SetPoint("TOPLEFT", "igam_MenuButton5", "BOTTOMLEFT", 0, 0);
   local button = CreateFrame("Button", "igam_MenuButton7", IGAM_Options, "IGAM_ButtonTemplate");
   button:SetPoint("TOPLEFT", "igam_MenuButton6", "BOTTOMLEFT", 0, 0);

  -- Bag-menyn --
   local imb1m = CreateFrame("Frame", "igam_MenuButton1Menu", nil, "SmallMenuTemplate");
   imb1m:SetBackdrop({ bgFile="Interface/Glues/MODELS/UI_MAINMENU/DarkPortal_stone_01", nil, tile=false, tileSize=32, edgeSize=32, insets={ left=5, right=6, top=5, bottom=6 }});
--      getglobal(imb1m:GetName().."HeaderText"):SetText(IGAM_text[igam_MenuButton1]);
   imb1m.name=IGAM_text.igam_MenuButton1;
   imb1m.parent=BINDING_HEADER_IGAM;
   igam_MenuButton1MenuHeaderText:SetText(imb1m.name);
   local button = CreateFrame("CheckButton", "igam_BagEnable", igam_MenuButton1Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_MenuButton1Menu", "TOPLEFT", 20, -25);
   local button = CreateFrame("CheckButton", "igam_BagBar", igam_MenuButton1Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_BagEnable", "BOTTOMRIGHT", -10, 5);
   local button = CreateFrame("CheckButton", "igam_BagLabel", igam_MenuButton1Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_BagBar", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_BagColor", igam_MenuButton1Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_BagLabel", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_BagTotal", igam_MenuButton1Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_BagColor", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_BagFree", igam_MenuButton1Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_BagTotal", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_BagSingle", igam_MenuButton1Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_BagFree", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_BagNotify", igam_MenuButton1Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_BagSingle", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_BagSell", igam_MenuButton1Menu, "IGAM_CheckButton");
   button:SetPoint("TOPRIGHT", "igam_BagNotify", "BOTTOMLEFT", 10, -5);
   local button = CreateFrame("CheckButton", "igam_BagSellQ", igam_MenuButton1Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_BagSell", "BOTTOMRIGHT", -10, 5);
   InterfaceOptions_AddCategory(imb1m);

  -- Unit Frames --
--   local imb2m = CreateFrame("Frame", "igam_MenuButton2Menu", nil, "SmallMenuTemplate");
--   imb2m:SetBackdrop({ bgFile="Interface/Glues/MODELS/UI_MAINMENU/DarkPortal_stone_01", nil, tile=false, tileSize=32, edgeSize=32, insets={ left=5, right=6, top=5, bottom=6 }});
--   local button = CreateFrame("CheckButton", "igam_Party", igam_MenuButton2Menu, "IGAM_CheckButton");
--   button:SetPoint("TOPLEFT", "igam_MenuButton2Menu", "TOPLEFT", 20, -25);
--   local button = CreateFrame("CheckButton", "igam_THP", igam_MenuButton2Menu, "IGAM_CheckButton");
--   button:SetPoint("TOPLEFT", "igam_Party", "BOTTOMLEFT", 0, 5);
--   imb2m.name=IGAM_text.igam_MenuButton2;
--   imb2m.parent=BINDING_HEADER_IGAM;
--   igam_MenuButton2MenuHeaderText:SetText(imb2m.name);
--   InterfaceOptions_AddCategory(imb2m);

  -- User Interface --
   local imb3m = CreateFrame("Frame", "igam_MenuButton3Menu", nil, "SmallMenuTemplate");
   imb3m:SetBackdrop({ bgFile="Interface/Glues/MODELS/UI_MAINMENU/DarkPortal_stone_01", nil, tile=false, tileSize=32, edgeSize=32, insets={ left=5, right=6, top=5, bottom=6 }});
   imb3m.name=IGAM_text.igam_MenuButton3;
   imb3m.parent=BINDING_HEADER_IGAM;
   igam_MenuButton3MenuHeaderText:SetText(imb3m.name);
   local button = CreateFrame("CheckButton", "igam_MainMenuBar", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_MenuButton3Menu", "TOPLEFT", 20, -25);
   local button = CreateFrame("CheckButton", "igam_MainMenuX", igam_MenuButton3Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_MainMenuBar", "BOTTOMRIGHT", -10, 5);
   local button = CreateFrame("CheckButton", "igam_MicroButton", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPRIGHT", "igam_MainMenuX", "BOTTOMLEFT", 10, 5);
   local button = CreateFrame("CheckButton", "igam_Griffin", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_MicroButton", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_XP", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_Griffin", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_TNL", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_XP", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_Latency", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_TNL", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_FPS", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_Latency", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_SpeedMeter", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_FPS", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_THP", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_SpeedMeter", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_cFlask", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_THP", "BOTTOMLEFT", 0, -5);
   local button = CreateFrame("CheckButton", "igam_cWellFed", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_cFlask", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_moveWarn", igam_MenuButton3Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_cWellFed", "BOTTOMLEFT", 0, 5);
   InterfaceOptions_AddCategory(imb3m);

  -- Minimap --
   local imb4m = CreateFrame("Frame", "igam_MenuButton4Menu", nil, "SmallMenuTemplate");
   imb4m:SetBackdrop({ bgFile="Interface/Glues/MODELS/UI_MAINMENU/DarkPortal_stone_01", nil, tile=false, tileSize=32, edgeSize=32, insets={ left=5, right=6, top=5, bottom=6 }});
   imb4m.name=IGAM_text.igam_MenuButton4;
   imb4m.parent=BINDING_HEADER_IGAM;
   igam_MenuButton4MenuHeaderText:SetText(imb4m.name);
   local button = CreateFrame("CheckButton", "igam_mapMove", igam_MenuButton4Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_MenuButton4Menu", "TOPLEFT", 20, -25);
   local button = CreateFrame("CheckButton", "igam_mapFrame", igam_MenuButton4Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_mapMove", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_mapZoom", igam_MenuButton4Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_mapFrame", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_WMButton", igam_MenuButton4Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_mapZoom", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_mapTime", igam_MenuButton4Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_WMButton", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_mapTop", igam_MenuButton4Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_mapTime", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_mapCoords", igam_MenuButton4Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_mapTop", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_mapClock", igam_MenuButton4Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_mapCoords", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_mapSquare", igam_MenuButton4Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_mapClock", "BOTTOMLEFT", 0, 5);
   InterfaceOptions_AddCategory(imb4m);

  -- Misc. --
   local imb5m = CreateFrame("Frame", "igam_MenuButton5Menu", nil, "SmallMenuTemplate");
   imb5m:SetBackdrop({ bgFile="Interface/Glues/MODELS/UI_MAINMENU/DarkPortal_stone_01", nil, tile=false, tileSize=32, edgeSize=32, insets={ left=5, right=6, top=5, bottom=6 }});
   imb5m.name=IGAM_text.igam_MenuButton5;
   imb5m.parent=BINDING_HEADER_IGAM;
   igam_MenuButton5MenuHeaderText:SetText(imb5m.name);
   local button = CreateFrame("CheckButton", "igam_Repair", igam_MenuButton5Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_MenuButton5Menu", "TOPLEFT", 20, -25);
   local button = CreateFrame("CheckButton", "igam_RepairInv", igam_MenuButton5Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_Repair", "BOTTOMRIGHT", -10, 5);
   local button = CreateFrame("CheckButton", "igam_AskRepair", igam_MenuButton5Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_RepairInv", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_RepairGuild", igam_MenuButton5Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_AskRepair", "BOTTOMLEFT", 0, 5);
   local button = CreateFrame("CheckButton", "igam_CastTime", igam_MenuButton5Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_RepairGuild", "BOTTOMLEFT", 0, -15);
   local button = CreateFrame("CheckButton", "igam_CastTimeInv", igam_MenuButton5Menu, "IGAM_CheckButtonSub1");
   button:SetPoint("TOPLEFT", "igam_CastTime", "BOTTOMRIGHT", -10, 5);
   local button = CreateFrame("CheckButton", "igam_questLvl", igam_MenuButton5Menu, "IGAM_CheckButton");
   button:SetPoint("TOPRIGHT", "igam_CastTimeInv", "BOTTOMLEFT", 10, -15);
   local button = CreateFrame("CheckButton", "igam_QTT", igam_MenuButton5Menu, "IGAM_CheckButton");
   button:SetPoint("TOPRIGHT", "igam_questLvl", "BOTTOMRIGHT", 0, -15);
   local button = CreateFrame("CheckButton", "igam_fChange", igam_MenuButton5Menu, "IGAM_CheckButton");
   button:SetPoint("TOPRIGHT", "igam_QTT", "BOTTOMRIGHT", 0, -15);
   local button = CreateFrame("CheckButton", "igam_AutoInvite", igam_MenuButton5Menu, "IGAM_CheckButton");
   button:SetPoint("TOPRIGHT", "igam_fChange", "BOTTOMRIGHT", 0, -15);
   local button = CreateFrame("CheckButton", "igam_buffCaster", igam_MenuButton5Menu, "IGAM_CheckButton");
   button:SetPoint("TOPRIGHT", "igam_AutoInvite", "BOTTOMRIGHT", 0, -15);
   InterfaceOptions_AddCategory(imb5m);

  -- Hearthstone --
   local imb6m = CreateFrame("Frame", "igam_MenuButton6Menu", nil, "SmallMenuTemplate");
   imb6m:SetBackdrop({ bgFile="Interface/Glues/MODELS/UI_MAINMENU/DarkPortal_stone_01", nil, tile=false, tileSize=32, edgeSize=32, insets={ left=5, right=6, top=5, bottom=6 }});
   imb6m.name=IGAM_text.igam_MenuButton6;
   imb6m.parent=BINDING_HEADER_IGAM;
   igam_MenuButton6MenuHeaderText:SetText(imb6m.name);
   local button = CreateFrame("CheckButton", "igam_hearth", igam_MenuButton6Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_MenuButton6Menu", "TOPLEFT", 20, -25);
   local button = CreateFrame("CheckButton", "igam_hearthRnd", igam_MenuButton6Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_hearth", "TOPLEFT", 0, -25);
   local slider = CreateFrame("Slider", "igam_hearthFrq", igam_MenuButton6Menu, "IGAM_OptionSliderTemplate");
   slider:SetPoint("TOPLEFT", "igam_hearthRnd", "TOPLEFT", 20, -50);
   local button = CreateFrame("CheckButton", "igam_hearth1", igam_MenuButton6Menu, "IGAM_UIDropDownMenuTemplate");
   button:SetPoint("TOPLEFT", "igam_hearthFrq", "TOPLEFT", 0, -55);
   local button = CreateFrame("CheckButton", "igam_hearth2", igam_MenuButton6Menu, "IGAM_UIDropDownMenuTemplate");
   button:SetPoint("TOPLEFT", "igam_hearth1", "TOPLEFT", 0, -55);
   local button = CreateFrame("CheckButton", "igam_hearth3", igam_MenuButton6Menu, "IGAM_UIDropDownMenuTemplate");
   button:SetPoint("TOPLEFT", "igam_hearth2", "TOPLEFT", 0, -55);
   local button = CreateFrame("CheckButton", "igam_hearth4", igam_MenuButton6Menu, "IGAM_UIDropDownMenuTemplate");
   button:SetPoint("TOPLEFT", "igam_hearth3", "TOPLEFT", 0, -55);
   InterfaceOptions_AddCategory(imb6m);

  -- Resurrection --
   local imb7m = CreateFrame("Frame", "igam_MenuButton7Menu", nil, "SmallMenuTemplate");
   imb7m:SetBackdrop({ bgFile="Interface/Glues/MODELS/UI_MAINMENU/DarkPortal_stone_01", nil, tile=false, tileSize=32, edgeSize=32, insets={ left=5, right=6, top=5, bottom=6 }});
   imb7m.name=IGAM_text.igam_MenuButton7;
   imb7m.parent=BINDING_HEADER_IGAM;
   igam_MenuButton7MenuHeaderText:SetText(imb7m.name);
   local button = CreateFrame("CheckButton", "igam_resurrect", igam_MenuButton7Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_MenuButton7Menu", "TOPLEFT", 20, -25);
   local button = CreateFrame("CheckButton", "igam_ress", igam_MenuButton7Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_resurrect", "TOPLEFT", 0, -25);
   local button = CreateFrame("CheckButton", "igam_ressRnd", igam_MenuButton7Menu, "IGAM_CheckButton");
   button:SetPoint("TOPLEFT", "igam_ress", "TOPLEFT", 0, -25);
   local slider = CreateFrame("Slider", "igam_ressFrq", igam_MenuButton7Menu, "IGAM_OptionSliderTemplate");
   slider:SetPoint("TOPLEFT", "igam_ressRnd", "TOPLEFT", 20, -50);
   local button = CreateFrame("CheckButton", "igam_ress1", igam_MenuButton7Menu, "IGAM_UIDropDownMenuTemplate");
   button:SetPoint("TOPLEFT", "igam_ressFrq", "TOPLEFT", 0, -55);
   local button = CreateFrame("CheckButton", "igam_ress2", igam_MenuButton7Menu, "IGAM_UIDropDownMenuTemplate");
   button:SetPoint("TOPLEFT", "igam_ress1", "TOPLEFT", 0, -55);
   local button = CreateFrame("CheckButton", "igam_ress3", igam_MenuButton7Menu, "IGAM_UIDropDownMenuTemplate");
   button:SetPoint("TOPLEFT", "igam_ress2", "TOPLEFT", 0, -55);
   InterfaceOptions_AddCategory(imb7m);
end

local IGAM_DropDown_IsInitialized = { };
function IGAM_DropDown_OnShow(frame)
  if IGAM_DropDown_IsInitialized[frame] then return end
  IGAM_DropDown_IsInitialized[frame] = true;
  UIDropDownMenu_SetWidth(frame, 250);
  UIDropDownMenu_Initialize(frame, IGAM_DropDown_Initialize);
end

function IGAM_DropDown_Initialize(frame)
  local info = UIDropDownMenu_CreateInfo();
  for i, v in pairs(IGAM_DROPDOWN[frame:GetName()]) do
    info.text, info.arg1 = v[1], i;
    info.checked = IGAM_Save[IGAM_NAME_REALM].dropdown[frame:GetName()]==i;
    info.func = function() IGAM_Save[IGAM_NAME_REALM].dropdown[frame:GetName()]=i; UIDropDownMenu_SetText(frame, v[1]) end
    UIDropDownMenu_AddButton(info);
    if (IGAM_Save[IGAM_NAME_REALM].dropdown[frame:GetName()]==i) then UIDropDownMenu_SetText(frame, v[1]) end
--    DEFAULT_CHAT_FRAME:AddMessage("Igam: Init! "..i.." | "..v);
  end
end

----function to check if "spell" is a Hearthstone-spell or not
function IGAM_check_if_HS(spell)
  if not spell then return false end
  for i, v in pairs(IGAM_SPELL_HS) do
    if spell == v then return true end
  end
  return false
end

---- Check spells cast for interesting spells
function IGAM_Event_UNIT_SPELLCAST_SENT(arg1, arg2, arg3, arg4)
--  DEFAULT_CHAT_FRAME:AddMessage("Igam: CheckSpells: "..arg1.." | "..arg2.." | "..arg3.." | "..arg4);
 --- Emotes when using hearthstone
  if (IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_hearth and arg1=="player" and IGAM_check_if_HS(arg2) and random(1,100) <= (IGAM_Save[IGAM_NAME_REALM].slider.igam_hearthFrq)) then
    if (IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_hearthRnd) then
      DoEmote(IGAM_DROPDOWN.igam_hearth[random(1,IGAM_tcount(IGAM_DROPDOWN.igam_hearth))][2],"none");
    else
      local hour,minute = GetGameTime()
      local second = (hour * 3600) + (minute * 60)
      local hearth1 = IGAM_Save[IGAM_NAME_REALM].dropdown.igam_hearth1;
      local hearth2 = IGAM_Save[IGAM_NAME_REALM].dropdown.igam_hearth2;
      local hearth3 = IGAM_Save[IGAM_NAME_REALM].dropdown.igam_hearth3;
      local hearth4 = IGAM_Save[IGAM_NAME_REALM].dropdown.igam_hearth4;
      if (second >= 64800) then
        DoEmote(IGAM_DROPDOWN.igam_hearth[hearth3][2],"none");
      elseif (second >= 43200) then
        DoEmote(IGAM_DROPDOWN.igam_hearth[hearth2][2],"none");
      elseif (second >= 21600) then
        DoEmote(IGAM_DROPDOWN.igam_hearth[hearth1][2],"none");
      else
        DoEmote(IGAM_DROPDOWN.igam_hearth[hearth4][2],"none");
      end
    end
  end
 ---
end

----------------------

function IGAM_OnEvent(frame, event, ...)
  local arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12 = ...;
  IGAM_catchEvent("IGAM_core",event)

  if (event == "CHAT_MSG_WHISPER") then -- argX== message(1), sender(2), language(3), channelString(4), target(5), flags(6), ..., guid(11)
    if not IGAM_Save then return end
    if not IGAM_Save[IGAM_NAME_REALM] then return end
    IGAM_autoInvite(arg1, arg2);
  elseif (event == "CHAT_MSG_ADDON") then -- arg1=prefix, arg2=message, arg3=channel, arg4=sender
    IGAM_GetAddonMsg(arg1, arg2, arg3, arg4);
  elseif (event == "PLAYER_TARGET_CHANGED") then
--    IGAM_checkWellFed();
  elseif (event == "PLAYER_LEVEL_UP") then --argX == newlvl(1), hp(2), mana(3), talentpoints(4), str(5), agi(6), sta(7), int(8), spi(9)
	local extra, str, agi, sta, int, spi, manatext = "","","","","","","";
	if arg5>0 then str=arg5..STR; extra=", " end -- SPELL_STAT1_NAME
	if arg6>0 then agi=extra..arg6..AGI; extra=", " end -- SPELL_STAT2_NAME
	if arg7>0 then sta=extra..arg7..STA; extra=", " end -- SPELL_STAT3_NAME
	if arg8>0 then int=extra..arg8..INT; extra=", " end -- SPELL_STAT4_NAME
	if arg9>0 then spi=extra..arg9..SPI; extra=", " end -- SPELL_STAT5_NAME
	if arg3>0 then manatext=" and "..arg3.."mana" end
	print(IGAM_MSG..IGAM_COLOR["CYAN"]..format(IGAM_LEVEL_UP,arg1,arg1)..IGAM_COLOR["CYAN"].."! You got "..arg2.."HP"..manatext..".");
	print(IGAM_MSG..IGAM_COLOR["CYAN"].."extra stats: "..str..agi..sta..int..spi..".");
    IGAM_SendAddonMsg("DING!", arg1)
  elseif (event == "MERCHANT_SHOW") then
    IGAM_RepairAllItems();
    IGAM_AutoSell();
  elseif (event == "MERCHANT_CLOSED") then
    StaticPopup_Hide("REPAIR_EQ_CONFIRMATION");
    StaticPopup_Hide("REPAIR_INV_CONFIRMATION");
  elseif (event == "RESURRECT_REQUEST" or event == "PLAYER_ALIVE" or event == "PLAYER_UNGHOST") then
    IGAM_Event_resurrect(frame, event, arg1);
  elseif event == "PLAYER_ENTERING_WORLD" then
    IGAM_MYGUID = UnitGUID("player");	-- who am i :)
    IGAM_SendAddonMsg("VERSION:");		--send version-info to other with same addon
  elseif (event == "VARIABLES_LOADED") then
    IGAM_core:UnregisterEvent("VARIABLES_LOADED");
    IGAM_DisableConcurrentPlugins();
    IGAM_loadVariables();
    IGAM_startup2();
  elseif (event == "ZONE_CHANGED_NEW_AREA") then
    SetMapToCurrentZone();
  elseif (event == "FRIENDLIST_UPDATE") then
    IGAM_core:UnregisterEvent("FRIENDLIST_UPDATE");
    local numFriends = GetNumFriends();
    local IGAM_FriendTemp = IGAM_Save_FriendInfo[IGAM_NAME_REALM];
    IGAM_Save_FriendInfo[IGAM_NAME_REALM] = { };
    for i=1, numFriends, 1 do
      local name = GetFriendInfo(i);
      if IGAM_FriendTemp[name] then IGAM_Save_FriendInfo[IGAM_NAME_REALM][name] = IGAM_FriendTemp[name] end
    end
    IGAM_FriendTemp = nil;
  elseif (event == "ADDON_LOADED") then
    -- Register the addon in myAddOns
    if(myAddOnsFrame_Register) then
      myAddOnsFrame_Register(IgamMiscDetails);
    end
  elseif (event == "UPDATE_FACTION") then
    IGAM_XPBUpdate(event);
  elseif (event == "CHAT_MSG_COMBAT_FACTION_CHANGE") then
    if not (IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_fChange) then return end
    local faction = select(3, string.find(arg1, "Reputation with (.+) increased by .+")) or 0;
    if not faction then return end
    if faction == GUILD then return end
    local current = GetWatchedFactionInfo();
	if faction == current then return end
    for i=1,GetNumFactions() do
      local name = GetFactionInfo(i);
      if name == faction then
        SetWatchedFactionIndex(i);
        return;
      end
    end
  elseif (event == "UNIT_SPELLCAST_SENT") then
    IGAM_Event_UNIT_SPELLCAST_SENT(arg1, arg2, arg3, arg4);
  elseif (event == "READY_CHECK") then
    for i=1,40 do
      local name, _ = GetRaidRosterInfo(i);
      if (not name == nil ) then
        local asd = _G["CompactRaidFrame"..i];
        IGAM_CompactUnitFrame_UpdateStatusText(asd);
      end
    end
  elseif (event == "PLAYER_FLAGS_CHANGED" or event == "GROUP_ROSTER_CHANGED") then
    local raidId = tonumber(select(3, string.find(arg1, "raid(.*)")) or 0);
--    DEFAULT_CHAT_FRAME:AddMessage("Igam: PLAYER_FLAGS_CHANGED: "..arg1.." - "..raidId);
    if ( raidId > 0 )then
      local asd = _G["CompactRaidFrame"..raidId];
      IGAM_CompactUnitFrame_UpdateStatusText(asd);
    end
  end
end

function IGAM_OnUpdate(timer)
  local CurTime = GetTime();
--  DEFAULT_CHAT_FRAME:AddMessage("Igam: Ping! "..CurTime);
  if ( IGAM_core.OneSecTimer ) then
    if ( IGAM_core.OneSecTimer < CurTime ) then
      IGAM_Coords();
      IGAM_ClassCheck();
      IGAM_FPS();
      IGAM_Latency();
      IGAM_speed();
      IGAM_core.OneSecTimer = CurTime+1;
    end
  else
    IGAM_core.OneSecTimer = CurTime;
  end
  if ( IGAM_core.FiveSecTimer ) then
    if ( IGAM_core.FiveSecTimer < CurTime ) then
      if not IGAM_Save then return end
      if not IGAM_Save[IGAM_NAME_REALM] then return end
      if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_debug then
        IGAM_DEBUGCOUNT=IGAM_DEBUGCOUNT+1;
        DEFAULT_CHAT_FRAME:AddMessage("Igam: "..IGAM_DEBUGCOUNT.." "..IGAM_core:GetName().." Ping! 5sec.");
      end
      IGAM_core.FiveSecTimer = CurTime+5;
      IGAM_Clock();
      IGAM_QTT();
      if IGAM_Save[IGAM_NAME_REALM].checkbutton.igam_BagEnable then
        _G["IGAM_BagOverlay"]:Hide();
        _G["IGAM_BagOverlay"]:Show();
      end
    end
  else
    IGAM_core.FiveSecTimer = CurTime;
  end
 -- continious
  --  nothing here atm...
end