-- 
-- Based on an addon written by Sorata.
--

Mark = LibStub("AceAddon-3.0"):NewAddon("HuntersMark", "AceEvent-3.0", "AceConsole-3.0", "AceHook-3.0", "LibSink-2.0")
local Mark = Mark
local L = LibStub("AceLocale-3.0"):GetLocale("HuntersMark", false)

local spellname = nil

local ranks = {
	[1] = { 20, 2 },
	[2] = { 45, 4.5 },
	[3] = { 75, 7.5 },
	[4] = { 110, 11 },
}

local arcane
local multi
local steady
local aimed

local marks = {}

function Mark:OnInitialize()
	-- Find out the local name for Hunter's Mark, used later
	local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(14325)
	spellname = name
	
	-- Multi-Shot
	local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(27021)
	multi = name
	
	-- Arcane Shot
	local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(27019)
	arcane = name
	
	-- Steady
	local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(34120)
	steady = name
	
	-- Aimed
	local name, rank, icon, cost, isFunnel, powerType, castTime, minRange, maxRange = GetSpellInfo(27065)
	aimed = name
	
end

function Mark:OnEnable()
	marks = {}
	
	self:RawHook("UnitDebuff", true)
--	self:RawHook(GameTooltip, "SetUnit", true)
	self:RawHook(GameTooltip, "SetUnitDebuff", true)
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
end

function Mark:OnDisable()

end

function Mark:COMBAT_LOG_EVENT_UNFILTERED(event, timestamp, eventtype, srcGUID, srcName, srcFlags, dstGUID, dstName, dstFlags, ...)
	if eventtype == 'SPELL_DAMAGE' then
		local obj = select(2, ...)
		
		-- Aimed, Steady, Arcane, Multi
		if obj == multi or obj == arcane or obj == aimed or obj == steady then
			self:AddToStrength(dstGUID, dstName)
		end
	end

	if eventtype == 'RANGE_DAMAGE' then
		local obj = select(1, ...)
		
		-- Auto-shot
		if obj == 75 then
			self:AddToStrength(dstGUID, dstName)
		end
	end

	if (eventtype == 'SPELL_CAST_SUCCESS' or eventtype == 'SPELL_AURA_REMOVED') and (select(2, ...) == spellname) then
		
		--self:Print("eventtype: "..eventtype..", obj: "..obj..", dstGUID: "..dstGUID..", srcGUID: "..srcGUID)
		
		if eventtype == 'SPELL_AURA_REMOVED' then
			--self:Print("Hunter's Mark removed expired from "..dstName)
			marks[dstGUID] = nil
		end
		if eventtype == 'SPELL_CAST_SUCCESS' then
			--self:Print("Hunter's Mark applied to "..dstName)
			if marks[dstGUID] == nil then
				marks[dstGUID] = 0
			end
		
		end
		
	end
	
end

function Mark:AddToStrength(unitGUID, unitname)
	-- If we know of a mark on this target
	if marks[unitGUID] ~= nil then
	
		-- Add to strength if less than 30 hits
		if marks[unitGUID] < 29 then
			marks[unitGUID] = marks[unitGUID] + 1
		elseif marks[unitGUID] == 29 then
			marks[unitGUID] = marks[unitGUID] + 1
			
--			local name, realm = UnitName(unitname)

			self:Pour(string.format(L["FULLSTRENGTH_MESSAGE"],unitname), 1.0, 0.5, 0.5)
			--CombatText_AddMessage(string.format(L["FULLSTRENGTH_MESSAGE"],unitname), CombatText_StandardScroll, 1.0, 0.5, 0.5, nil, false)
		end

	end

end

function Mark:UnitDebuff(unitId, debuffIndex, removable)
	local name, rank, iconTexture, count, debuffType, duration, timeLeft = self.hooks.UnitDebuff(unitId, debuffIndex, removable)

	local unitGUID = UnitGUID(unitId)

	if name ~= nil and name == spellname then
		--self:Print("UnitDebuff, "..name.. ", unitId "..unitId)
		if marks[unitGUID] ~= nil then
			--self:Print("count is "..marks[unitGUID])
			count = marks[unitGUID]
		end
	end

	return 	name, rank, iconTexture, count, debuffType, duration, timeLeft
end

function Mark:SetUnit(object, unitId)
	self:Print("mousing over")
	self.hooks[object].SetUnit(object, unitId)

	local unitGUID = UnitGUID(unitId)
	if marks[unitGUID] then
		self:Print("mousing over a mark!")
		
		GameTooltip:AddLine("Meow",1,1,1)
		GameTooltip:Show()
	end
	
end

function Mark:SetUnitDebuff(object, unitId, debuffIndex, removable)
	--self:Print("SetUnitDebuff "..unitId..", debuffIndex "..debuffIndex)
	self.hooks[object].SetUnitDebuff(object, unitId, debuffIndex, removable)
	
	local name, rank, _, count = self:UnitDebuff(unitId, debuffIndex, removable)
	if name ~= nil and name == spellname then
		-- Get the default tooltip info
		local markstring = getglobal(object:GetName().."TextLeft2"):GetText()
		
		-- Find out the rank of the Mark
		local start,stop,rankstring = string.find(rank, "(%d+)")
		if rankstring then
			local rank_number = tonumber(rankstring)
			local rank_info = ranks[rank_number]
			
			-- Get the default tooltip info's number and replace it with our modified one
			local start,stop,current = string.find(markstring, "(%d+)")
			local replacement = string.gsub(markstring, current, (rank_info[1] + rank_info[2] * count))
			
			getglobal(object:GetName().."TextLeft2"):SetText(replacement)
		else
			self:Print(markstring)
		end
	end
end

