﻿-- Author      : Linty
-- Create Date : 11/2/2009 8:41:23 PM
HWM_Global={
			Version=0,
			Debug=0
			}; --Global Storage Var

hwm_frame = CreateFrame("Frame");
hwm={lang={}, utils={}, event={},vars={}, browser={}};

hwm.vars.updatetime=30;--Time Blocks recorded
hwm.vars.showsession=false;
hwm.vars.sessiondata=nil;

hwm_frame:SetScript("OnEvent", function(self, event, ...)
 hwm.event[event](self, ...); -- call oevent handler
end);

 hwm_frame:RegisterEvent("VARIABLES_LOADED");
 hwm_frame:RegisterEvent("ADDON_LOADED");
 hwm_frame:RegisterEvent("PARTY_MEMBERS_CHANGED");
 hwm_frame:RegisterEvent("RAID_ROSTER_UPDATE");




------------------------Send Mesage to chat---------------------


function hwm.utils:Chat(chatmsg)

	if (chatmsg==nil) then 
		chatmsg="";
	end
	
	DEFAULT_CHAT_FRAME:AddMessage("|cFFFFF000Have We Met? : |r"..chatmsg);
end

------------------------Send Debug to chat---------------------
function hwm.utils:Debug(level, debugStr) --- level == 0-Critical, 1- Important, 2-Information, 3-trace only
		
		if (debugStr==nil or level == nil) then 
			return;
		end
		if (HWM_Global.Debug+1<level or level==0 ) then 
				return;
		end
		
		DEFAULT_CHAT_FRAME:AddMessage("|cFFFFF000Have We Met? : |cffff0000[Debug] |r"..debugStr);
end

------------------------Set Debug Level---------------------
function hwm.utils:SetDebug(level)
	HWM_Global.Debug=level;
end


------------------------Upgrade Settings---------------------
function hwm.utils:InitSettings()
	if (HWM_Global==nil or HWM_Global.Version==nil) then -- New Install or settings wiped
	
		HWM_Global ={
			Version=0.2, 
			Debug=0,
			Players={}
			};

	end
	
	
	--- Upgrade Settings 
	if (HWM_Global.Version<0.5) then
		HWM_Global.Version=0.5;
		HWM_Global.HideDetail=true;
		
		local scnt=0;
		local pcnt=0;
		
		hwm.utils:Chat("Upgrading saved data...");
		if (HWM_Global.Players~=nil) then
			for i,server in pairs(HWM_Global.Players) do
				scnt=scnt+1;
				for ii,player in pairs(server) do
					pcnt=pcnt+1;
					player.Note="";
					player.Rating=3;
					player.KilledByToon=0;
					player.KilledToon=0;
				end	
			end
	
		end
		hwm.utils:Chat("Upgraded " .. scnt .." Servers and "..pcnt.." Players Data.");

	end
	
	
end

---------------------------------Helper Funcitons---------------------------------
function hwm.utils:SafeNil(StringVar)
		if (StringVar== nil) then
			return "";
		end

		return StringVar;
end 

function hwm.utils:TimeString(secs)

	if (secs==nil) then
		return "-";
	end
	
	if (secs<60) then
		return secs..hwm.lang.Seconds;
	end
		
	
	
	local mins=math.floor(secs/60);
	local hours=0;
	local days=0;

	hours,mins=math.modf(mins/60);
	mins=math.floor(mins*60);

	days,hours=math.modf(hours/24);

	hours=math.floor(hours*24);

	sret=""
	if (days>0) then
		sret=days..hwm.lang.Days.." ";
	end

	if (hours>0 or days>0) then
		sret=sret..hours..hwm.lang.Hours.." ";
	end

	sret=sret..mins..hwm.lang.Minutes;

return sret;




end

------------------------Update Session Data---------------------
function hwm.utils:UpdateSession()
local tmpHTML = "<html><body>";

if (hwm.vars.sessionddata==nil) then
	tmpHTML=tmpHTML.."|cffff0000"..hwm.lang.NoSession.."|r";
else
	table.sort(hwm.vars.sessionddata, function(ta, tb) return ta.LastSeen>tb.LastSeen end); -- Sort descending;
	for key,data in pairs(hwm.vars.sessionddata) do
		tmpHTML=tmpHTML.."<H1><A href=\""..key.."\">|cff"..data.Color.code..key.." - " .. data.Race.." "..data.Class.."|r ("..hwm.utils:TimeString(time()-data.LastSeen)..")</A></H1>";
	
	end
	
	---tmpHTML=tmpHTML..hwm.vars.sessiondhtml;
end


tmpHTML=tmpHTML.."</body></html>";

HWM_Session_Frame_html:SetText(tmpHTML);


end

function hwm.utils:UpdateSessionData(lrealm, lunit, lparty, lclass, lclasscol, lrace)
	if (lrealm==nil and lunit==UnitName("PLAYER")) then
			return;
	end
	
	if (lunit==nil or lunit=="Unknown") then -- Filter out unknow/unclassified players
			return;
	end
	
	if (lrealm=="" or lrealm==nil) then
		lrealm=GetRealmName();
	end
	
	if (hwm.vars.sessionddata==nil) then
		hwm.vars.sessionddata={};
	end
	
	local key =lunit.."-"..lrealm;
	
	if (lclass==nil) then
		lclass={r=1,g=1,b=1,code="ffffff"};
	end
	
	if (lrace==nil) then
		return;
	end
	
	
	-----Add/Update Session Entry
	
	
	local prating, pdata=hwm:PlayerInfo(lrealm, lunit);
	if (prating>0) then
	
		 
		-------Announce known player if required
		if (hwm.vars.sessionddata[key]==nil and pdata~=nil) then -- Have record but not seen in this session
			local msg = "Known player: |cff"..lclasscol.code..lunit.." ("..lrealm..")|r - ";
			
				msg =msg.."|cff"..hwm.lang.RateColors[pdata.Rating]..hwm.lang.RateLabels[pdata.Rating] .."|r - ";
				msg =msg.."|cff"..hwm.lang.tt_ratingcol[prating]..hwm.lang.tt_rating[prating].."  ";
				msg = msg .. ". |cfffff000"..hwm.lang.tt_lastgrouped..": |cff00ffff"..hwm.utils:TimeString(time()-pdata.LastGroup);
						
			hwm.utils:Chat(msg)
			UIErrorsFrame:AddMessage(msg);
			PlaySound("TellMessage");
			
			
		end
	end
	
	hwm.vars.sessionddata[key]={Name=lunit, Server = lrealm, Party = lparty, Class=lclass, Color=lclasscol, LastSeen=time(), Race=lrace};
	

end


--------------------------Command Line---------------------------------
function HWM_SlashHandler(msg)
	msg = strupper(msg);
	
	if(msg==hwm.lang.cmdShowSession) then
		hwm.utils:SessionToggle();
		
	elseif(msg==hwm.lang.cmdShowBrowse) then
		hwm.utils:BrowseToggle();
	elseif(strsub(msg,1,strlen(hwm.lang.cmdShowAdd)+1)==hwm.lang.cmdShowAdd.." ") then
		pname=strtrim(strsub(msg,4));
		if (strlen(pname)<4) then return end;
		
		pname1=strupper(strsub(pname,1,1))..strlower(strsub(pname,2)) -- proper case name
		
		hwm:ManualAdd(pname1)
		
	else
		 hwm.utils:Chat(hwm.lang.command1);
		 hwm.utils:Chat(hwm.lang.command2);
		 hwm.utils:Chat(hwm.lang.command3);
		 hwm.utils:Chat(hwm.lang.command4);
	end
	
	
end

function hwm.utils:SessionToggle()
	if (hwm.vars.showsession) then
		HWM_Session_Frame:Hide();
	else
		HWM_Session_Frame:Show();
	end
	hwm.vars.showsession= not hwm.vars.showsession;

end

function hwm.utils:BrowseToggle()
	if (HWM_Browse_Frame:IsVisible()) then
		HWM_Browse_Frame:Hide();
	else
		HWM_Browse_Frame:Show();
	end

end
--------------------------Events---------------------------------
function hwm.event:PARTY_MEMBERS_CHANGED(self, ...)
	if (not UnitInParty("PLAYER")) then
		return;
	end
	
	hwm.utils:Debug(3, "Party Changed!");
	hwm:PartyUpdate();
end

function hwm.event:RAID_ROSTER_UPDATE(self, ...)
	if (not UnitInRaid("PLAYER")) then
		return;
	end
	hwm.utils:Debug(3, "Raid Changed!");
	hwm:RaidUpdate();
end

--------------------Init Code-------------------------------------

function hwm.event:VARIABLES_LOADED(self, ...)
	hwm.utils:Debug(3, "Vars Loaded!");	
	hwm.lang:Init();
	hwm.utils:InitSettings();
	hwm.utils:Chat(hwm.lang.welcome);
	SLASH_HWM1 = hwm.lang.cmd1;
	SLASH_HWM2 = hwm.lang.cmd2;
	SlashCmdList["HWM"] = HWM_SlashHandler;
	
	  --Init Timers
   --Chronos.scheduleRepeating("LFGVRefresh", 2, LFGVoyeur_tmrUpdate); -- Refresh loop
--	Chronos.scheduleRepeating("LFGVSaved", 120, LFGVoyeur_SavedUpdate); --Slow refresh Save instance refresh and other 2 minute refreshes
	GameTooltip:HookScript("OnTooltipSetUnit", hwm.UnitTooltip);
	
	 hwm.utils:InitSettings();
	 Chronos.scheduleRepeating("HWM_Update", hwm.vars.updatetime,hwm.TimerUpdate );
	 
	 HWM_Session_Frame_scroll:SetScrollChild(HWM_Session_Frame_html);
	 hwm.utils:UpdateSession();
	 
	 ----Load List for browser
	 hwm.browser:Query();
	 hwm.browser:CreateFriendButt();
	 
end

function hwm.event:ADDON_LOADED(self, ...)
	hwm.utils:Debug(3, "Addons Loaded!");	
end

--------------------------Timer Update---------------------------------
function hwm:TimerUpdate()
	hwm.utils:Debug(3, "Timer Update Called!")
	hwm:PartyUpdate();
	hwm:RaidUpdate();
	
end
--------------------------Unit Tool Tip---------------------------------
function hwm:UnitTooltip(arg1, arg2)
	local pname, punitid=GameTooltip:GetUnit();
	if (punitid==nil or pname==nil) then
		return;
	end
	
	hwm.utils:Debug(4,"Name:"..pname.." / Unit:"..punitid);
	
	
	local x,prealm=UnitName(punitid);
	 hwm:AppendTooltip(prealm, pname);
end

	
function hwm:AppendTooltip(prealm, pname)	
	if (prealm=="" or prealm==nil) then
		prealm=GetRealmName();
	end
	
	local prating, pdata=hwm:PlayerInfo(prealm, pname);
	if (prating==0) then
		return;
	 end
	
	hwm.utils:Debug(4,"Realm:"..prealm.." / Rating:"..prating);
	
	if (HWM_Global.Debug<4 and ((UnitName("Player")==pname and prealm=="")) or prating==0) then --- Self
		return;
	end
	
	
		GameTooltip:AddLine("|cffffffff----------");
		GameTooltip:AddLine("|cffffffff"..hwm.lang.title.. " " ..
						"|cff"..hwm.lang.tt_ratingcol[prating]..hwm.lang.tt_rating[prating]);
		GameTooltip:AddLine(hwm.lang.RateTTLabel.." |cff"..hwm.lang.RateColors[pdata.Rating]..
					hwm.lang.RateLabels[pdata.Rating]);
					
		if (hwm.lang.RateTTNote~="" and hwm.lang.RateTTNote~=nil) then
			GameTooltip:AddLine(hwm.lang.RateTTNote.." |cff006000"..pdata.Note,1,1,1,true);
		end
					
					
		if (prating>1) then
		
			if (UnitInParty(pname)==nil and UnitInRaid(pname)==nil) then
				GameTooltip:AddLine("|cfffff000"..hwm.lang.tt_lastgrouped..": |cff00ffff"..hwm.utils:TimeString(time()-pdata.LastGroup));
			end
			
				--Recent Dungeons
			
			if (pdata.Instances[1]~="" or HWM_Global.Debug==3) then
				GameTooltip:AddLine("|cffffffff"..hwm.lang.tt_recentinst);
				for n=1,5,1 do
					if (pdata.Instances[n]~="" or HWM_Global.Debug==3) then
						GameTooltip:AddLine("|cffffffff- |cffBF60BF"..pdata.Instances[n]);
					end
				end
				
			end
			if (IsShiftKeyDown() or ( not HWM_Global.HideDetail)) then
				if (pdata.PartyScore + pdata.RaidScore<1) then
					return;
				end
				
				-- Has bene in party
				if (pdata.PartyScore>0 or HWM_Global.Debug==3) then
					GameTooltip:AddLine("|cfffff000"..hwm.lang.tt_grouped.."|cff00ffff"..hwm.utils:TimeString(pdata.PartyScore*hwm.vars.updatetime));
				end
				
				-- Has Been in Raid
				if (pdata.RaidScore>0 or HWM_Global.Debug==3) then	
					GameTooltip:AddLine("|cfffff000"..hwm.lang.tt_raided.."|cff00ffff"..hwm.utils:TimeString(pdata.RaidScore*hwm.vars.updatetime));
				end
				
				-- Reg Dungeon Stats
				if (pdata.Activity.Reg[1]+pdata.Activity.Reg[2]+pdata.Activity.Reg[3]+pdata.Activity.Reg[4]>0 or HWM_Global.Debug==3) then	
					GameTooltip:AddLine("|cffffffff"..hwm.lang.tt_dunact);
					
					for n=1,4,1 do
						if (pdata.Activity.Reg[n]>0 or HWM_Global.Debug==3) then
							GameTooltip:AddLine("|cffffffff- |cffBF60BF"..hwm.lang.DunTypes[n]..": "
									..hwm.utils:TimeString(pdata.Activity.Reg[n]*hwm.vars.updatetime));
						end
					end
					
				end
				--Raid Stats
				if (pdata.Activity.Raid[1]+pdata.Activity.Raid[2]+pdata.Activity.Raid[3]+pdata.Activity.Raid[4]>0 or HWM_Global.Debug==3) then	
					GameTooltip:AddLine("|cffffffff"..hwm.lang.tt_raidact);
					
					for n=1,4,1 do
						if (pdata.Activity.Raid[n]>0 or HWM_Global.Debug==3) then
							GameTooltip:AddLine("|cffffffff- |cffBF60BF"..hwm.lang.RaidTypes[n]..": "
									..hwm.utils:TimeString(pdata.Activity.Raid[n]*hwm.vars.updatetime));
						end
					end
					
				end
				
				--PVP Stats
				if (pdata.Activity.PVP[1]+pdata.Activity.PVP[2]+pdata.Activity.PVP[3]+pdata.Activity.PVP[4]>0 or HWM_Global.Debug==3) then	
					GameTooltip:AddLine("|cffffffff"..hwm.lang.tt_pvpact);
					
					for n=1,4,1 do
						if (pdata.Activity.PVP[n]>0 or HWM_Global.Debug==3) then
							GameTooltip:AddLine("|cffffffff- |cffBF60BF"..hwm.lang.DunTypes[n]..": "
									..hwm.utils:TimeString(pdata.Activity.PVP[n]*hwm.vars.updatetime));
						end
					end
					
				end
			end
			
		
		end


	
	
end
function hwm:ManualAdd(pname)

	prealm=GetRealmName();
	
	if (HWM_Global.Players[prealm][pname]==nil) then --Create

			HWM_Global.Players[pindex][pname]={PartyScore=0,RaidScore = 0, LastGroup=0,LastSeen=0,
								Activity={Raid={0,0,0,0}, Reg={0,0,0,0}, PVP={0,0,0,0}},
								Instances ={"","","","",""},
								Note="", Rating=3, KilledByToon=0,KilledToon=0};
	
	end
	
	HWM_Rate_Show(prealm, pname);
	
	
end

function hwm:LogPlayer(prealm, pname, pgroup, isparty)

	hwm.utils:Debug(3, "updating/Logging: "..pname);
	if (prealm=="" or prealm==nil) then
		prealm=GetRealmName();
	end
	pindex=prealm;
	
	if (HWM_Global.Players[pindex]==nil) then -- init storage for server
			HWM_Global.Players[pindex]={};
	end
	

	
	if (HWM_Global.Players[pindex][pname]==nil) then --Create

			HWM_Global.Players[pindex][pname]={PartyScore=0,RaidScore = 0, LastGroup=0,LastSeen=0,
								Activity={Raid={0,0,0,0}, Reg={0,0,0,0}, PVP={0,0,0,0}},
								Instances ={"","","","",""},
								Note="", Rating=3, KilledByToon=0,KilledToon=0};
	
	end
	
	
	--Update Credits
	if (pgroup and HWM_Global.Players[pindex][pname].LastGroup<(time()-hwm.vars.updatetime+1)
					 and HWM_Global.Players[pindex][pname].LastGroup>time()-(hwm.vars.updatetime*2) ) 
								then -- only add to credit if grouped for the required time).
		
		--Update Times
		HWM_Global.Players[pindex][pname].LastGroup=time();
		HWM_Global.Players[pindex][pname].LastSeen=time();
		--Basic recording of group
		if (isparty) then
			HWM_Global.Players[pindex][pname].PartyScore=HWM_Global.Players[pindex][pname].PartyScore+1;
		else
			HWM_Global.Players[pindex][pname].RaidScore=HWM_Global.Players[pindex][pname].RaidScore+1;
		end
		--Credit Activty Counters (pvp, raid, inst, etc)
		local iname, itype, idiff = GetInstanceInfo()
		
		
		if (itype~="none") then --In instance
			--Update Instance List
			
			local iText=iname.." ("..itype.."/";
		
			if (itype=="raid") then
				iText=iText..hwm.lang.RaidTypes[idiff]..")";
				
			else
				iText=iText..hwm.lang.DunTypes[idiff]..")";
				
			end
			iText = iText .. " - "..UnitName("Player");
			
			if (HWM_Global.Players[pindex][pname].Instances[1]~=iText) then --Update List and scroll entries
				HWM_Global.Players[pindex][pname].Instances[5]=HWM_Global.Players[pindex][pname].Instances[4];
				HWM_Global.Players[pindex][pname].Instances[4]=HWM_Global.Players[pindex][pname].Instances[3];
				HWM_Global.Players[pindex][pname].Instances[3]=HWM_Global.Players[pindex][pname].Instances[2];
				HWM_Global.Players[pindex][pname].Instances[2]=HWM_Global.Players[pindex][pname].Instances[1];
				HWM_Global.Players[pindex][pname].Instances[1]=iText;
			end
				
			if (not isparty) then
				HWM_Global.Players[pindex][pname].Activity.Raid[idiff]=HWM_Global.Players[pindex][pname].Activity.Raid[idiff]+1;
			elseif (itype=="pvp") then
				HWM_Global.Players[pindex][pname].Activity.PVP[idiff]=HWM_Global.Players[pindex][pname].Activity.PVP[idiff]+1;
			else
				HWM_Global.Players[pindex][pname].Activity.Reg[idiff]=HWM_Global.Players[pindex][pname].Activity.Reg[idiff]+1;
			end
			
		end
		
		
	else -- start grouping/raiding
		HWM_Global.Players[pindex][pname].LastGroup=time();
		HWM_Global.Players[pindex][pname].LastSeen=time();
	end
		

end


function hwm:PartyUpdate()
	if ( GetNumRaidMembers()>0) then
		hwm:RaidUpdate();
		return;
	end
	
	
	for n=1, GetNumPartyMembers() do
		if (GetPartyMember(n) ~=nil) then
			local pname, prealm  = UnitName("Party"..n);
			local prace= UnitRace("Party"..n);
			local plevel = UnitLevel("Party"..n);
			local pclass, pclasseng = UnitClass("Party"..n);
			local classcol = hwm.utils:RaidColor(pclasseng);
			--prealm=GetRealmName();
			
			hwm.utils:UpdateSessionData(prealm, pname, true, pclass, classcol,prace );
			hwm:LogPlayer(prealm, pname, true, true);
			
			
		end
	end
	
	hwm.utils:UpdateSession();

end

function hwm:RaidUpdate()
	for n=1, GetNumRaidMembers() do
		if (GetRaidRosterInfo(n)~=nil) then
			local pname, prealm  = UnitName("Raid"..n);
			local prace = UnitRace("Raid"..n);
			local plevel = UnitLevel("Raid"..n);
			local pclass, pclasseng = UnitClass("Raid"..n);
			local classcol = hwm.utils:RaidColor(pclasseng);
			--prealm=GetRealmName();
			hwm.utils:UpdateSessionData(prealm, pname, false, pclass, classcol,prace );
			
			hwm:LogPlayer(prealm,pname, true, false);
			 
		end
	end
	
	hwm.utils:UpdateSession();

end
function hwm.utils:RaidColor(lclass)
	local col=RAID_CLASS_COLORS[lclass]
	if (col==nil) then
		return  {r=1,g=1,b=1,code="ffffff"};
	end
	
	col.code=("%02x%02x%02x"):format(col.r*255, col.g*255, col.b*255);
	return col
	
end

function hwm:PlayerSummaryText(prealm, pname)


		local prating, pdata=hwm:PlayerInfo(prealm, pname);
		if (prating==0) then
			return nil;
		 end
		
		
		
		local txtHWM="|cff"..hwm.lang.tt_ratingcol[prating]..hwm.lang.tt_rating[prating];
		txtHWM=txtHWM.."\n"..hwm.lang.RateTTLabel.." |cff"..hwm.lang.RateColors[pdata.Rating]..
						hwm.lang.RateLabels[pdata.Rating];
						
		if (hwm.lang.RateTTNote~="" and hwm.lang.RateTTNote~=nil) then
			txtHWM=txtHWM.."\n"..hwm.lang.RateTTNote.." |cff006000"..pdata.Note;
		end
						
						
		if (prating>1) then
		
		
			txtHWM=txtHWM.."\n".."|cfffff000"..hwm.lang.tt_lastgrouped..": |cff00ffff"..hwm.utils:TimeString(time()-pdata.LastGroup);
		
			
			--Recent Dungeons
			
			if (pdata.Instances[1]~="") then
				GtxtHWM=txtHWM.."\n".."|cffffffff"..hwm.lang.tt_recentinst;
				for n=1,5,1 do
					if (pdata.Instances[n]~="" or HWM_Global.Debug==3) then
						txtHWM=txtHWM.."\n".."|cffffffff- |cffBF60BF"..pdata.Instances[n];
					end
				end
				
			end
			
			
		
		end
		
		return txtHWM


end

function hwm:PlayerInfo(prealm, pname)
 --- Returns  group credit, party credit, rating , last grouped
	if ((prealm=="" and HWM_Global.Players[""]==nil)  or prealm==nil) then
		prealm=GetRealmName();
	end
	
	pindex=prealm;
	if (HWM_Global.Players==nil) then
		HWM_Global.Players={}
		return 0, nil;
	end
	
	if (HWM_Global.Players[pindex]==nil) then 
			return 0, nil;
	end
	
	if (HWM_Global.Players[pindex][pname]==nil) then
			return 0, nil;
	end
	
	
	local divisor = (5*60*60)/hwm.vars.updatetime; --5 HOURS (INTO BLOCKS)
	
	local score = floor((HWM_Global.Players[pindex][pname].PartyScore +HWM_Global.Players[pindex][pname].RaidScore)/divisor)+2;
		
	--- Validate data for player
	
	if (HWM_Global.Players[pindex][pname].PartyScore+ HWM_Global.Players[pindex][pname].RaidScore==0) then
		score=1;
	end
	
	if(score<1) then score=1 end;
	if(score>6) then score=6 end;
	
	if (HWM_Global.Players[pindex][pname].Rating<1 or HWM_Global.Players[pindex][pname].Rating>5) then
		HWM_Global.Players[pindex][pname].Rating=1;
	end
			
	return score, HWM_Global.Players[pindex][pname];
	

end

