﻿--Author      : LintyDruid
--Localisation Control


function hwm.lang.Set(language)
	 hwm.lang:Init(language);
end

function hwm.lang:Init(language)
	if (language== nil) then
		language = GetLocale();
	end
	
	HWM_Locale_English(); --- Init English as default
	
	--Apply local overlay
	if (language=="deDE") then
		HWM_Locale_German();
		hwm.utils:Chat("Language set to German ("..language..")");
	elseif (language=="esES") then
		HWM_Locale_Spanish();
		hwm.utils:Chat("Language set to Spanish ("..language..")");
	elseif (language=="frFR") then
		HWM_Locale_French();
		hwm.utils:Chat("Language set to French ("..language..")");
	elseif (language=="koKR") then
		HWM_Locale_Korea();
		hwm.utils:Chat("Language set to Korean ("..language..")");
	elseif (language=="zhCN") then
		HWM_Locale_China();
		hwm.utils:Chat("Language set to Chinese ("..language..")");
	elseif (language=="zhTW") then
		HWM_Locale_Taiwan();
		hwm.utils:Chat("Language set to Taiwanese("..language..")");
	else
		hwm.utils:Chat("Language set to English ("..language..")");
	end
	
	--Refresh screens, etc
	hwm.lang:Refresh();
	
	
end

function hwm.lang.Refresh()

	---Set Options Window Text
	HWM_OptionsFrame_AboutHeaderLabel:SetText(hwm.lang.title);
	HWM_OptionsFrame_hidedetaillabel:SetText(hwm.lang.OptHideDetails);
	
	HWM_Browse_Frame_searchcaption:SetText(hwm.lang.BrowNameSearch);
	HWM_Browse_Frame_column1:SetText(hwm.lang.BrowCol1);
	HWM_Browse_Frame_column2:SetText(hwm.lang.BrowCol2);
	HWM_Browse_Frame_column3:SetText(hwm.lang.BrowCol3);
	HWM_Browse_Frame_column4:SetText(hwm.lang.BrowCol4);
	HWM_Browse_Frame_Status:SetText(""); --- Set in update
	HWM_Browse_Frame_FilterCaption:SetText(hwm.lang.BrowFilter);
	HWM_Browse_Frame_FilterSessCap:SetText(hwm.lang.BrowFiltSess);
	HWM_Browse_Frame_FilterServOnlyCap:SetText(hwm.lang.BrowFiltServ);
	HWM_Browse_Frame_FilterPopOnlyCap:SetText(hwm.lang.BrowFiltPop);
	HWM_Browse_Frame_Find:SetText(hwm.lang.BrowCmdFind);
	HWM_Browse_Frame_Edit:SetText(hwm.lang.BrowCmdEdit);
	HWM_Browse_Frame_PST:SetText(hwm.lang.BrowCmdPst);
	HWM_Browse_Frame_Who:SetText(hwm.lang.BrowCmdWho);
	


	
end
