﻿if not HCoold then return false end
local L = HCoold:GetLocale()
local spells = {} -- spells that we can track by system
local spec_spells = {} -- spells that are uniq for each spec of class

do -- generate spells list
	do -- generate spells
		local type1 = {------ type == 1  аура на -дамаг +хил
			{ -- мастер аура
				spellID = 31821,
				class = "PALADIN", 
				succ = "SPELL_CAST_SUCCESS", --"SPELL_AURA_APPLIED",
				specs = { 0 },
				CD = 120,
				cast_time = 6,
				quality = 1,
			},
			{ -- купол
				spellID = 62618,
				class = "PRIEST", 
				succ = "SPELL_CAST_SUCCESS", --"SPELL_AURA_APPLIED",
				specs = { 1 },
				CD = 120,
				cast_time = 10,
				quality = 1,
			},
			{ -- тотем шаман  !aproved!!aproved!!aproved!!aproved!!aproved!
				spellID = 98008,
				class = "SHAMAN", 
				succ = "SPELL_CAST_SUCCESS",
				specs = { 3 },
				CD = 180,
				cast_time = 6,
				quality = 3,
			},
			{ -- Ободряющий клич
				spellID = 97462,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 180,
				class = "WARRIOR",
				cast_time = 10,
				quality = 1,
			},
		}
		local type2 = {------ type == 2 аое хил
			{ -- божественный гимн holy
				spellID = 64843,
				succ = "SPELL_CAST_SUCCESS",
				CD = 180,
				specs = { 2 },
				class = "PRIEST",
				quality = 3,
				cast_time = 8,
			},
			{ -- колодец света
				spellID = 724,
				succ = "SPELL_SUMMON",
				CD = 180,
				specs = { 2 },
				class = "PRIEST",
				quality = 3,
			},
			{ -- спокойствие дру feral
				spellID = 740,
				succ = "SPELL_CAST_SUCCESS",
				CD = 480,
				specs = { 2 },
				class = "DRUID",
				quality = 1,
				cast_time = 8,
			},
			{ -- спокойствие дру balance
				spellID = 740,
				succ = "SPELL_CAST_SUCCESS",
				CD = 480,
				specs = { 1 },
				class = "DRUID",
				quality = 2,
				cast_time = 8,
			},
			{ -- спокойствие дру restor
				spellID = 740,
				succ = "SPELL_CAST_SUCCESS",
				CD = 180,
				specs = { 3 },
				class = "DRUID",
				quality = 3,
				cast_time = 8,
			},
		}
		local type3 = {------ type == 3 на ману
			{ -- гимн надежды
				spellID = 64901, -- 64904 - проки на ману
				succ = "SPELL_CAST_SUCCESS",
				CD = 360,
				specs = { 0 },
				class = "PRIEST",
				quality = 3, 
				cast_time = 8,
			},
			{ -- озарение
				spellID = 29166,
				succ = "SPELL_CAST_SUCCESS",
				CD = 180,
				specs = { 1, 3 },
				class = "DRUID",
				quality = 2, 
				cast_time = 10,
			},
			{ -- озарение feral
				spellID = 29166,
				succ = "SPELL_CAST_SUCCESS",
				CD = 180,
				specs = { 2 },
				class = "DRUID",
				quality = 1, 
				cast_time = 10,
			},
			{ -- мана тайд !aproved!!aproved!!aproved!!aproved!!aproved!
				spellID = 16190,
				succ = "SPELL_CAST_SUCCESS",
				CD = 180,
				specs = { 3 },
				class = "SHAMAN",
				quality = 3, 
				cast_time = 16,
			},
		}
		local type4 = {------ type == 4  личный кд
			{ -- Ярость шамана (энх)
				spellID = 30823,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 2 },
				CD = 60,
				class = "SHAMAN",
				quality = 1,
				cast_time = 15,
			},
			{ -- бабл прист
				spellID = 47585,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 3 },
				CD = 120,
				class = "PRIEST",
				cast_time = 6,
				quality = 1,
			},
			{ -- Ни шагу назад
				spellID = 12975,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 3 },
				CD = 180,
				class = "WARRIOR",
				cast_time = 20,
				quality = 1,
			},
			{ -- Бой на смерть (парирование 100%) вар
				spellID = 118038,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 1, 2 },
				CD = 120,
				cast_time = 8,
				class = "WARRIOR",
				quality = 1,
			},
			{ -- Глухая оборона
				spellID = 871,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 300,
				class = "WARRIOR",
				cast_time = 12,
				quality = 1,
			},
			{ -- плащ теней
				spellID = 31224,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 120,
				class = "ROGUE",
				cast_time = 5,
				quality = 1,
			},
			{ -- ускользание
				spellID = 5277,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 180,
				class = "ROGUE",
				cast_time = 15,
				quality = 1,
			},
		}
		local type5 = {------ type == 5  точечный кд --------------- !aproved!!aproved!!aproved!!aproved!!aproved!
			{ -- крылья 
				spellID = 47788,
				class = "PRIEST",
				specs = { 2 },
				succ = "SPELL_CAST_SUCCESS",
				CD = 180,
				quality = 3,
				cast_time = 10,
			},
			{ -- пска 
				spellID = 33206,
				class = "PRIEST",
				specs = { 1 },
				succ = "SPELL_CAST_SUCCESS",
				CD = 180,
				quality = 3,
				cast_time = 8,
			},
			{ -- сакрифайс от не прота 
				spellID = 6940,
				class = "PALADIN",
				specs = { 1, 3 },
				succ = "SPELL_CAST_SUCCESS",
				CD = 120,
				cast_time = 12,
			},
			{ -- сакрифайс от прота 
				spellID = 6940,
				class = "PALADIN",
				specs = { 2 },
				succ = "SPELL_CAST_SUCCESS",
				CD = 120,
				quality = 2,
				cast_time = 12,
			},
		}
		local type6 = {------ type == 6  кд на +дамаг 
			{ -- Тотем элема огня !aproved!!aproved!!aproved!!aproved!!aproved!
				spellID = 2894,
				class = "SHAMAN",
				specs = { 0 },
				succ = "SPELL_CAST_SUCCESS",
				CD = 300,
				quality = 1,
				cast_time = 60,
			},
			{ -- Тотем элементаля земли !aproved!!aproved!!aproved!!aproved!!aproved!
				spellID = 2062,
				class = "SHAMAN",
				specs = { 0 },
				succ = "SPELL_CAST_SUCCESS",
				CD = 300,
				quality = 1,
				cast_time = 60,
			},
			{ -- Тотем порыва бури !aproved!!aproved!!aproved!!aproved!!aproved!
				spellID = 120668,
				class = "SHAMAN",
				specs = { 0 },
				succ = "SPELL_CAST_SUCCESS",
				CD = 300,
				quality = 1,
				cast_time = 10,
			},
			{ -- войско мертвых дк
				spellID = 42650,
				class = "DEATHKNIGHT",
				specs = { 0 },
				succ = "SPELL_CAST_SUCCESS",
				CD = 600,
				cast_time = 44,
			},
			{ -- Сокрушительный бросок	
				spellID = 64382,
				CD = 300,
				specs = { 0 },
				succ = {"SPELL_CAST_SUCCESS", "SPELL_DAMAGE", "SPELL_MISSED" },
				class = "WARRIOR",
				quality = 2,
				cast_time = 10,
			},
			{ -- шаман бл  !aproved!!aproved!!aproved!!aproved!!aproved!
				spellID = 2825,  -- за аликов 32182
				CD = 300,
				specs = { 0 },
				succ = "SPELL_CAST_SUCCESS",
				class = "SHAMAN",
				quality = 3,
				cast_time = 40,
				trigger = { 32182, },
			},
			{ -- маг бл
				spellID = 80353,
				CD = 300,
				specs = { 0 },
				succ = "SPELL_CAST_SUCCESS",
				class = "MAGE",
				quality = 3,
				cast_time = 40,
			},
--[[
			{ -- хантер бл ??????????????????????
				spellID = 90355,
				CD = 360,
				specs = { 0 },
				succ = "SPELL_CAST_SUCCESS",
				class = "HUNTER",
				quality = 3,
				cast_time = 40,
			},
--]]
		}
		local type7 = {------ type == 7  возрождения
			{ -- возрождение Дру 
				spellID = 20484,
				succ = "SPELL_CAST_START", -- SPELL_RESURRECT
				specs = { 0 },
				CD = 600,
				class = "DRUID",
				quality = 3,
			},
			{ -- возрождение ДК 
				spellID = 61999,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 600,
				class = "DEATHKNIGHT",
				quality = 2,
			},
			--[[ -- unable to track without oRA
			{ -- перерождение шам ???????????????????
				spellID = 20608,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 1800,
				class = "SHAMAN",
				quality = 1,
			},
			--]]
			{ -- воскрешение камнем души
				spellID = 20707,
				succ = "SPELL_CAST_START", 
				specs = { 0 },
				CD = 900,
				class = "WARLOCK",
				quality = 1,
			},
		}
		local type8 = {------ type == 8  прочее
			----------------- Шаманы
			{ -- благосклонность предков (касты на ходу у шамана)
				spellID = 79206,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 120,
				class = "SHAMAN",
				cast_time = 15,
				quality = 1,
			},
			{ -- очищение духа (не рестор шаман)
				spellID = 51886,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 1, 2 },
				CD = 8,
				class = "SHAMAN",
				quality = 1,
			},
			{ -- очищение духа (рестор шаман)
				spellID = 77130,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 3 },
				CD = 8,
				class = "SHAMAN",
				quality = 1,
			},
			{ -- пронизывающий ветер (сбитие каста шаман)
				spellID = 57994,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 12,
				class = "SHAMAN",
				quality = 1,
			},
			{ -- сглаз (лягушка шаман)
				spellID = 51514,
				succ = {"SPELL_AURA_REFRESH", "SPELL_AURA_APPLIED", },
				specs = { 0 },
				CD = 45,
				class = "SHAMAN",
				quality = 1,
			},
			{ -- тотем трепета шаман
				spellID = 8143,
				succ =  "SPELL_CAST_SUCCESS",
				specs = { 0 },
				CD = 60,
				class = "SHAMAN",
				cast_time = 6,
				quality = 1,
			},
			{ -- Тотем заземления !aproved!!aproved!!aproved!!aproved!!aproved!
				spellID = 8177,
				class = "SHAMAN",
				specs = { 0 },
				succ = "SPELL_CAST_SUCCESS",
				CD = 25,
				quality = 1,
				cast_time = 15,
			},
			{ -- гром и молния элем
				spellID = 51490,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 1 },
				CD = 45,
				class = "SHAMAN",
				quality = 1,
			},
			
			----------------- Присты
			{ -- духовое рвение (тянулка прист)
				spellID = 73325,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 90,
				class = "PRIEST",
				quality = 1,
			},
			{ -- защита от страха
				spellID = 6346,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 180,
				class = "PRIEST",
				quality = 1,
			},
			{ -- исчадие тьмы
				spellID = 34433,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 180,
				class = "PRIEST",
				quality = 1,
				cast_time = 12,
			},
			{ -- масс диспел
				spellID = 32375,
				succ = "SPELL_CAST_START", 
				specs = { 0 },
				CD = 15,
				class = "PRIEST",
				quality = 1,
			},
			{ -- диспел
				spellID = 527,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 1, 2 },
				CD = 8,
				class = "PRIEST",
				quality = 1,
			},
			{ -- уход в тень
				spellID = 586,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 30,
				class = "PRIEST",
				cast_time = 10,
				quality = 1,
			},
			{ -- архангел диск
				spellID = 81700,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 1 },
				CD = 30,
				class = "PRIEST",
				cast_time = 18,
				quality = 1,
			},
			{ -- внутреннее сосредоточение
				spellID = 89485,
				succ = "SPELL_AURA_REMOVED", 
				specs = { 1 },
				CD = 45,
				class = "PRIEST",
				quality = 1,
			},
			{ -- щит души диск
				spellID = 109964,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 1 },
				CD = 60,
				class = "PRIEST",
				cast_time = 15,
				quality = 1,
			},
			{ -- объятие вампира
				spellID = 15286,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 3 },
				CD = 180,
				class = "PRIEST",
				cast_time = 15,
				quality = 1,
			},
			
			----------------- Вары
			{ -- Героический прыжок
				spellID = 52174,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 45,
				class = "WARRIOR",
				quality = 1,
			},
			{ -- Зуботычина
				spellID = 6552,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 15,
				class = "WARRIOR",
				quality = 1,
			},
			{ -- Обезоруживание
				spellID = 676,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 60,
				class = "WARRIOR",
				quality = 1,
			},
			{ -- Отражение заклинаний
				spellID = 23920,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 25,
				class = "WARRIOR",
				cast_time = 5,
				quality = 1,
			},
			{ -- Рывок
				spellID = 100,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 20,
				class = "WARRIOR",
				quality = 1,
			},
			{ -- Смертельное спокойствие
				spellID = 85730,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 60,
				class = "WARRIOR",
				quality = 1,
			},
			{ -- Деморализующий крик
				spellID = 1160,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 3 },
				CD = 60,
				class = "WARRIOR",
				cast_time = 10,
				quality = 1,
			},
			
			----------------- Роги
			{ -- долой оружие
				spellID = 51722,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 60,
				class = "ROGUE",
				cast_time = 10,
				quality = 1,
			},
			{ -- исчезновение
				spellID = 1856,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 180,
				class = "ROGUE",
				quality = 1,
			},
			{ -- маленькие хитрости 
				spellID = 57934,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 30,
				class = "ROGUE",
				cast_time = 6,
				quality = 1,
			},
			{ -- пинок
				spellID = 1766,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 15,
				class = "ROGUE",
				quality = 1,
			},
			{ -- спринт
				spellID = 2983,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 60,
				class = "ROGUE",
				cast_time = 8,
				quality = 1,
			},
		
		}
		local type9 = {--  type == 9  пвп кулдауны на контроль
			{ -- ментальный крик прист фир
				spellID = 8122,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 30,
				class = "PRIEST",
				quality = 1,
			},
			{ -- стан прист
				spellID = 64044,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 3 },
				CD = 45,
				class = "PRIEST",
				quality = 1,
			},
			{ -- сало прист
				spellID = 15487,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 3 },
				CD = 45,
				class = "PRIEST",
				quality = 1,
				cast_time = 5,
			},
			{ -- Устрашающий крик (фир вара)
				spellID = 5246,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 60,
				class = "WARRIOR",
				quality = 1,
			},
			{ -- дымовая шашка
				spellID = 76577,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 180,
				class = "ROGUE",
				cast_time = 5,
				quality = 1,
			},
			{ -- ослепление
				spellID = 2094,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 180,
				class = "ROGUE",
				quality = 1,
			},
		}
		local type10 = {-- type == 10 кулдауны личные на +дамаг
			{ -- Дух дикого волка энх
				spellID = 51533,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 2 },
				CD = 120,
				cast_time = 15,
				class = "SHAMAN",
				quality = 1,
			},
			{ -- Ярость берсерка
				spellID = 18499,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 30,
				class = "WARRIOR",
				cast_time = 6,
				quality = 1,
			},
			{ -- Безрассудство
				spellID = 1719,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 0 },
				CD = 300,
				class = "WARRIOR",
				cast_time = 12,
				quality = 1,
			},
			{ -- Вендетта
				spellID = 79140,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 1 },
				CD = 120,
				class = "ROGUE",
				cast_time = 20,
				quality = 1,
			},
			{ -- Выброс адреналина
				spellID = 13750,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 2 },
				CD = 180,
				class = "ROGUE",
				cast_time = 15,
				quality = 1,
			},
			{ -- Череда убийств
				spellID = 51690,
				succ = "SPELL_CAST_SUCCESS", 
				specs = { 2 },
				CD = 120,
				class = "ROGUE",
				quality = 1,
			},
			
		}
		local type11 = { -- type == 11 просто рандомный бред
		}
		local shok = { -- для отладки Шок небес
			spellID = 25914, -- ID спелла
			class = "PALADIN", -- класс, которому принадлежит спелл
			CD = 6, -- кулдаун в секундах у спела
			specs = { 1 },
			succ = "SPELL_HEAL", -- тип ивента, который означает удачное применение 1287
			type = 1,  --[[ тип спелла: 
					1 - аура на -дамаг (купол, мастер аур и тд) 
					2 - аое хил (гимн пристов, транквил) 
					3 - на ману (иннеры, гимн на ману, мана тайд) 
					4 - личный кд (айс блок, шв, бабл, отражение) 
					5 - точечный кд (пс, крылья, придание сил)
					6 - кд на +дамаг (варовский -армор, бл)
					7 - возрождения (друид, шаман, дк, лок)
					8 - прочие кд
				]]
			trigger = { 19750, }, -- дополнительные ид с которых триггерится ивент
			cast_time = 5, -- время действия спелла
			quality = 3, -- качество спелла при сортировке 1/nil - плохое 2 - хорошее 3 - лучшее
		}

		for _, i in next, type1 do i.type = 1; table.insert(spells,i) end
		for _, i in next, type2 do i.type = 2; table.insert(spells,i) end
		for _, i in next, type3 do i.type = 3; table.insert(spells,i) end
		for _, i in next, type4 do i.type = 4; table.insert(spells,i) end
		for _, i in next, type5 do i.type = 5; table.insert(spells,i) end
		for _, i in next, type6 do i.type = 6; table.insert(spells,i) end
		for _, i in next, type7 do i.type = 7; table.insert(spells,i) end
		for _, i in next, type8 do i.type = 8; table.insert(spells,i) end
		for _, i in next, type9 do i.type = 9; table.insert(spells,i) end
		for _, i in next, type10 do i.type = 10; table.insert(spells,i) end
		if HCoold.debug then table.insert(spells,shok) end
	end

	do -- generate spec_spells
		table.insert(spec_spells, { -- паладин 1 holy 2 prot 3 retri
			class = "PALADIN",
			specs = {
				[1] = { -- holy
					{ id = 53563, }, -- частица
					{ id = 25914, }, -- шок небес
					{ id = 85222, }, -- свет зари
					{ id = 31821, }, -- мастер аур
					{ id = 31842, }, -- божественное одобрение
					{ id = 86273, }, -- озаряющее исцеление
					{ id = 53576, }, -- прилив света
				},
				[2] = { -- prot
					{ id = 31935, }, -- щит мстителя
					{ id = 31930, }, -- мудрое правосудие?
					{ id = 53595, }, -- молот праведника
					{ id = 53600, }, -- щит праведника
					{ id = 20925, }, -- щит небес
					{ id = 70940, }, -- божественный защитник
					{ id = 31850, }, -- ревностный защитник
				},
				[3] = { -- retri
					{ id = 90174, }, -- божественный замысел
					{ id = 85256, }, -- вердикт храмовника
					{ id = 89906, }, -- могущественное правосудие
					{ id = 53385, }, -- божественная буря
					{ id = 85696, }, -- фанатизм
					{ id = 59578, }, -- искусство войны
					{ id = 84963, }, -- дознание
				},
			},
		})
		table.insert(spec_spells, { -- прист 1 disc 2 holy 3 shadow
			class = "PRIEST",
			specs = {
				[1] = { -- disc
					{ id = 47537, }, -- вознесение??????
					{ id = 62618, }, -- слово силы: барьер
					{ id = 33206, }, -- подавление боли
					{ id = 59889, }, -- лишнее время
					{ id = 47753, }, -- божественное покровительство
					{ id = 47750, }, -- исповедь
					{ id = 47666, }, -- исповедь
					{ id = 89485, }, -- внутреннее сосредоточение
					{ id = 81661, }, -- приверженность
					{ id = 81751, }, -- искупление вины
					{ id = 94472, }, -- искупление вины
					{ id = 77613, }, -- милость
					{ id = 81700, }, -- архангел
					{ id = 109964, }, -- щит души
				},
				[2] = { -- holy 
					{ id = 47788, }, -- оберегающий дух
					{ id = 34861, }, -- круг исцеления
					{ id = 88625, }, -- слово света воздояние
					{ id = 63735, }, -- прозорливость
					{ id = 724, }, -- колодец света
					{ id = 81209, }, -- чакра: воздаяние
					{ id = 81208, }, -- чакра: безмятежность
					{ id = 81206, }, -- чакра: святилище
					{ id = 77489, }, -- отблеск света
					{ id = 88685, }, -- слово света святилище
					{ id = 88686, }, -- святилище тики
					{ id = 88684, }, -- слово света: безмятежность
					{ id = 63544, }, -- мгновенное обновление
				},
				[3] = { -- shadow
					{ id = 15473, }, -- облик тьмы
					{ id = 15407, }, -- пытка разума
					{ id = 15487, }, -- безмолвие
					{ id = 80902, }, -- взрыв разума
					{ id = 73510, }, -- пронзание разума
					{ id = 34914, }, -- прикосновение вампира
					{ id = 34919, }, -- прикосновение вампира
					{ id = 124465, }, -- прикосновение вампира
					{ id = 47585, }, -- слияние с тьмой
					{ id = 2944, }, -- всепожирающая чума
					{ id = 127626, }, -- всепожирающая чума
					{ id = 124467, }, -- всепожирающая чума
					{ id = 64044, }, -- глубинный ужас
					{ id = 15286, }, -- объятья вампира
					{ id = 15290, }, -- объятья вампира
					{ id = 87426, }, -- сумеречный призрак
				},
			},
		})
		table.insert(spec_spells, { -- варлок  1 афли 2 демон 3 дестро -- не полностью демонолог
			class = "WARLOCK",
			specs = {
				[1] = {
					{id = 30108,}, -- нестабильное колдоство
					{id = 64371,}, -- Изничтожение
					{id = 86211,}, -- Обмен душ
					{id = 32389,}, -- Объятия тьмы
					{id = 17941,}, -- Теневой транс
					{id = 48181,}, -- Блуждающий дух
				},
				[2] = {
					{id = 0,}, -- Призыв стража скверны
					{id = 0,}, -- Оплетение
					{id = 71521,}, -- Рука Гул'дана
					{id = 71165,}, -- Огненные недра
					{id = 53646,}, -- Демонический союз
					{id = 47241,}, -- Метаморфоза
				},
				[3] = {
					{id = 17962,}, -- Поджигание
					{id = 54277,}, -- Обратный поток
					{id = 85383,}, -- Глубокий ожог души
					{id = 17877,}, -- Ожог тьмы
					{id = 85421,}, -- Раскалленые угли
					{id = 30294,}, -- Поглощение души
					{id = 34936,}, -- Ответный удар
					{id = 91711,}, -- Заслон пустоты
					{id = 30283,}, -- Неистоство тьмы
					{id = 80240,}, -- Бич сокрушения
					{id = 50796,}, -- Стрела хаоса
					{id = 47283,}, -- Могущественный бес
				},
			},
		})
		table.insert(spec_spells, { -- хантер 1 повелитель зверей 2 стрельба 3 выживание
			class = "HUNTER",
			specs = {
				[1] = {
					{id = 19577,}, -- Устрашение
					{id = 82728,}, -- Рвение
					{id = 83468,}, -- Сконцентрированный огонь
					{id = 94007,}, -- зверь-убийца
					{id = 19574,}, -- Звериный гнев?
					{id = 34471,}, -- Зверь внутри?
				},
				[2] = {
					{id = 19434,}, -- прицельный выстрел
					{id = 76663,}, -- мятежная стрела (искусность)
					{id = 34490,}, -- Глушаший выстрел
					{id = 63468,}, -- Пронзающие выстрелы
					{id = 19506,}, -- Аура меткого выстрела
					{id = 23989,}, -- Готовность
					{id = 64420,}, -- Снайпер
					{id = 83559,}, -- Быстрая реакция??
					{id = 88691,}, -- Метка смерти
					{id = 53209,}, -- Выстрел химеры
				},
				[3] = {
					{id = 53301,}, -- разрывной выстрел
					{id = 19306,}, -- Контратака ????????
					{id = 56453,}, -- На изготовку!
					{id = 53290,}, -- Групповая охота
					{id = 19386,}, -- Укус виверны
					{id = 3674,}, -- Черная стрела
				},
			},
		})
		table.insert(spec_spells, { -- шаман 1 elem 2 ench 3 restor 
			class = "SHAMAN",
			specs = {
				[1] = {
					{id = 51490,}, -- гром и молния
					{id = 61882,}, -- землетрясение
					{id = 77762,}, -- волна лавы???
					{id = 88765,}, -- громовые раскаты
					{id = 51470,}, -- клятва стихий
					-- {id = ,}, -- сверкание?
					{id = 16246,}, -- ясность мысли   
					{id = 77451,}, -- прок искусности 
					{id = 45297,}, -- прок искусности
					{id = 45284,}, -- прок искусности
				},
				[2] = {
					{id = 60103,}, -- вскипание лавы
					{id = 53817,}, -- оружие водоворота
					{id = 63375,}, -- изначальная мудрость
					{id = 51533,}, -- дух дикого волка
					{id = 1535,}, -- кольцо огня
					{id = 58875,}, -- поступь духа
					{id = 30823,}, -- ярость шамана
					{id = 30808,}, -- высвобожденная ярость
					{id = 77661,}, -- жгучее пламя
					{id = 26364,}, -- статический шок???
					{id = 16278,}, -- шквал       
					{id = 17364,}, -- удар бури
					{id = 32175,}, -- удар бури
					{id = 32176,}, -- удар бури
				},
				[3] = {
					{id = 61295,}, -- быстрина
					{id = 105284,}, -- стойкость предков
					{id = 77472,}, -- великая волна исцеления
					{id = 331,}, -- волна исцеления
					{id = 77130,}, -- Очищение духа???
					{id = 974,}, -- щит земли
					{id = 53390,}, -- приливные волны
					{id = 52752,}, -- пробуждение предков
					{id = 101033,}, -- упоение
					{id = 16190,}, -- тотем прилива маны
					{id = 98008,}, -- тотем духовой связи  --]]
				},
			},
		})
		table.insert(spec_spells, { -- друид 1 balance 2 feral 3 resto
			class = "DRUID",
			specs = {
				[1] = {
					{id = 78674,}, -- звездный поток
					{id = 24858,}, -- облик лунного совуха
					{id = 33831,}, -- сила природы
					{id = 81283,}, -- микоз
					{id = 48505,}, -- звездопад
					{id = 61391,}, -- тайфун
					{id = 93400,}, -- падающие звезды
				},
				[2] = {
					{id = 33876,}, -- увечье
					{id = 50334,}, -- берсерк
					{id = 61336,}, -- инстинкт выживания
					{id = 24932,}, -- вожак стаи
					{id = 80313,}, -- смять
				},
				[3] = {
					{id = 33891,}, -- древо жизни
					{id = 48438,}, -- буйный рост
					{id = 17116,}, -- природная стремительность
					{id = 81262,}, -- период цветения
					{id = 18562,}, -- быстрое восстановление
				},
			},
		})
		table.insert(spec_spells, { -- маг 1 arcan 2 fire 3 frost
			class = "MAGE",
			specs = {
				[1] = {
					{id = 44425,}, -- чародейский обстрел
					{id = 12043,}, -- величие разума
					{id = 82930,}, -- чародейская тактика
					{id = 31589,}, -- замедление
					{id = 31585,}, -- улучшенный самоцвет маны
					{id = 12042,}, -- мощь тайной магии
					{id = 54646,}, -- магическая концентрация
					{id = 44395,}, -- колдовское поглощение
				},
				[2] = {
					{id = 92315,}, -- огненая глыба
					{id = 11113,}, -- взрывная волна
					{id = 87023,}, -- прижигание
					{id = 48108,}, -- путь огня
					{id = 11129,}, -- возгорание
					{id = 31661,}, -- дыхание дракона
					{id = 44457,}, -- живая бомба
					{id = 22959,}, -- критическая масса
					{id = 83582,}, -- пироман
				},
				[3] = {
					{id = 57669,}, -- восполнение
					{id = 44544,}, -- ледяные пальцы
					{id = 57761,}, -- заморозка мозгов
					{id = 92283,}, -- сфера ледяного огня
					{id = 31687,}, -- пет
					{id = 12472,}, -- стылая кровь
					{id = 11958,}, -- холодная хватка
					{id = 11426,}, -- ледяная преграда
					{id = 44572,}, -- Глубокая заморозка
				},
			},
		})
		table.insert(spec_spells, { -- рога  1 мути 2 комбат 3 субт
			class = "ROGUE",
			specs = {
				[1] = {
					{id = 93068,}, -- Мастер ядоварения
					{id = 79140,}, -- Вендетта
					{id = 32645,}, -- отравление
					{id = 27576,}, -- Расправа
					{id = 1329,}, -- Расправа
					{id = 5374,}, -- Расправа
					{id = 111240,}, -- Устранение
					{id = 121153,}, -- Слепая зона
				},
				[2] = {
					{id = 57841,}, -- Череда убийств
					{id = 57842,}, -- Череда убийств
					{id = 51690,}, -- Череда убийств
					{id = 84745,}, -- Поверхностное понимание
					{id = 84746,}, -- Умеренное понимание
					{id = 84747,}, -- Глубокое понимание
					{id = 13877,}, -- Шквал клинков
					{id = 86392,}, -- Искусность Правой, левой
					{id = 84617,}, -- Пробивающий удар
					{id = 35546,}, -- Боевой потенциал
					{id = 13750,}, -- Выброс адреналина
				},
				[3] = {
					{id = 91021,}, -- Поиск слабости?
					{id = 51713,}, -- Танец теней
					{id = 14183,}, -- Умысел
					{id = 16511,}, -- Кровоизлияние
					{id = 89775,}, -- Кровоизлияние
					{id = 53,}, -- Удар в спину
				},
			},
		})
		table.insert(spec_spells, { -- дк 1 blood 2 frost 3 unholy
			class = "DEATHKNIGHT",
			specs = {
				[1] = {
					{id = 55050,}, -- удар в сердце
					{id = 77535,}, -- щит крови
					{id = 49222,}, -- костяной щит
					{id = 53138,}, -- сила поганища ?????????????????
					{id = 50463,}, -- Удар закаленным в крови клинком
					{id = 50452,}, -- кровавый паразит
					{id = 48792,}, -- незыблемость льда?
					{id = 48982,}, -- захват рун?
					{id = 55233,}, -- кровь вампира
					{id = 96171,}, -- воля мертвых
					{id = 81162,}, -- воля мертвых
					{id = 81256,}, -- танцующее руническое оружие
					{id = 49028,}, -- танцующее руническое оружие
				},
				[2] = {
					{id = 49184,}, -- воющий ветер
					{id = 49143,}, -- ледяной удар
					{id = 51271,}, -- ледяной столп
					{id = 49203,}, -- ненасытная стужа
					{id = 51124,}, -- машина для убийств
					{id = 59052,}, -- морозная дымка
					{id = 55610,}, -- цепкие ледяный когти
					{id = 81326,}, -- ослабление костей
					{id = 66196,}, -- угроза тассариана?????
					{id = 66198,}, -- угроза тассариана?????
					{id = 66216,}, -- угроза тассариана?????
				},
				[3] = {
					{id = 49206,}, -- призыв горгули +
					{id = 49016,}, -- нечистивое бешенство+
					{id = 63560,}, -- темное превращение+
					{id = 51052,}, -- зона антимагии+ 2м 10 сек
					{id = 55090,}, -- удар плети
					{id = 91342,}, -- вливание тьмы 
					{id = 50536,}, -- нечистивая порча??
					{id = 81340,}, -- неумолимый рок
					{id = 0,}, -- разносчик черной чумы?
				},
			},
		})
		table.insert(spec_spells, { -- воин 1 arms, 2 fury 3 prot
			class = "WARRIOR",
			specs = {
				[1] = {
					{id = 125831,}, -- Вкус крови
					{id = 12328,}, -- Размащистые удары
					{id = 12294,}, -- Смертельный удар
					{id = 52437,}, -- Внезапная смерть
					{id = 1464,}, -- Мощный удар
					{id = 7384,}, -- Превосходство
					{id = 76858,}, -- Дополнительный выпад
				},
				[2] = {
					{id = 85739,}, -- Кровавый фарш
					{id = 46916,}, -- Прилив крови
					{id = 23881,}, -- кровожадность
					{id = 12968,}, -- Шквал
					{id = 100130,}, -- зверский удар
					{id = 117313,}, -- кровожадное исцеление
					{id = 96103,}, -- Яростный выпад
					{id = 131116,}, -- Яростный выпад
					{id = 85384,}, -- Яростный выпад
					{id = 85288,}, -- Яростный выпад
				},
				[3] = {
					{id = 23922,}, -- Мощный удар щитом
					{id = 2565,}, -- блок щитом
					{id = 132404,}, -- блок щитом
					{id = 1160,}, -- деморализующий крик
					{id = 122510,}, -- ультиматум
					{id = 112048,}, -- непроницаемый щит
					{id = 12975,}, -- ни шагу назад
					{id = 20243,}, -- Сокрушение
					{id = 50227,}, -- Щит и меч
				},
			},
		})
	end
end

function HCoold:MakeSpellList() -- in future - making self.spells that contains spells, that will be tracking by system by user configuration
	self.spells = {}
	for _,i in next, spells do
		local out = tostring(i.spellID)
		for _,j in next, i.specs do
			out = string.format("%s.%d",out,j)
		end
		if self.db.profile.trackSpells[out] == nil then self.db.profile.trackSpells[out] = true end
		if self.db.profile.trackSpells[out] then 
			table.insert(self.spells,i) 
		end
	end
end

function HCoold:GetSpecBySpell(spellID) -- return spec of class if it used this spell (check if spell is spec uniq)
	for _,i in next, spec_spells do
		for spec,j in next, i.specs do
			for _,p in next, j do
				if p.id == spellID then return spec end
			end
		end
	end
	return 0
end

function HCoold:GenerateSpellList()
	local out = {}
	local order = 1
	local t_ = {}
	local out2 = {}
	for _, i in next, spells do
		local t = tostring(i.type)
		if not out[t] then -- create group if it's not exists
			out[t] = {
				type = "group",
				cmdHidden = true,
				name = L["type"..t],
				desc = L["desc type"..t],
				order = i.type+30,
				args = {},
			}
			out2[t] = {}
			t_[t] = true
		end
		do -- spell add
			local spname = select(1, GetSpellInfo(i.spellID)) or L["No spell found"]
			local splink = select(1, GetSpellLink(i.spellID))
			local specs = ""
			local tmp = ""
			for _, j in next, i.specs do 
				specs = string.format("%s%s%s",specs,tmp,j)
				tmp = ", "
			end
			local desc = function(self)
				GameTooltip:ClearLines()
				if splink then
					GameTooltip:SetHyperlink(splink)
				end
				GameTooltip:AppendText("\n")
				GameTooltip:AppendText(string.format(L["class %s specs %s"],L[i.class],L[i.class .. specs]))
				GameTooltip:AppendText("\n")
				return nil
			end
			local tt = tostring(i.spellID)
			for _,j in next, i.specs do
				tt = string.format("%s.%d",tt,j)
			end
			local s = {
				type = "toggle",
				name = spname,
				desc = desc,
				descStyle = "Toggle",
				set = function(tmp,key)
					self.db.profile.trackSpells[tt] = key
				end,
				get = function() 
					return self.db.profile.trackSpells[tt]
				end,
				--order = order,
			}
			--out[t].args[tostring(order)] = s
			--order = order+1
			if not out2[t][i.class] then out2[t][i.class] = {} end
			table.insert(out2[t][i.class],s)
		end
	end
	for t, ss in next, out2 do
		out[t].args.turnoff = {
			type = "execute",
			name = L["turn all off"],
			desc = L["desc turn all off"],
			func = function() for _, i in next, out[t].args do if i.type == "toggle" then i.set(nil,false) end end end,
			order = 1,
		}
		out[t].args.turnon = {
			type = "execute",
			name = L["turn all on"],
			desc = L["desc turn all on"],
			func = function() for _, i in next, out[t].args do if i.type == "toggle" then i.set(nil,true) end end end,
			order = 2,
		}
		local count = 5
		for class, tt in next, ss do
			out[t].args[tostring(count)] = {
				type = "header",
				name = L[class],
				order = count,
			}
			count = count + 1
			for _,i in next, tt do
				i.order = count
				out[t].args[tostring(count)] = i
				count = count + 1
			end
		end
	end
	
	local sm = {}
	for i,j in next, self.sort_methods do sm[i] = j.desc end
	for i in next, t_ do
		local k_ = (tonumber(i) or 1)
		local k = k_ + 5
		-- self:Printf("%s",k)
		--self:Printf("%s %s %s","width" .. i,k,self.db.profile.types[k].w)
		out["header" .. i] = {
			type = "header",
			cmdHidden = true,
			name = L["header" .. i],
			order = k * 10 + 1
		}
		out["width" .. i] = {
			type = "input",
			cmdHidden = true,
			name = L["type width"..i],
			desc = L["desc type width"..i],
			order = k * 10 + 2,
			width = "half",
			set = function(a1,val)
				val = tonumber(val) or 100
				self.db.profile.types[k_].w = val
				if self.types[k_] then self.types[k_]:SetWidth(val) end
			end,
			get = function()
				return tostring(self.db.profile.types[k_].w)
			end,
		}
		
		out["sort" .. i] = {
			type = "select",
			-- width = "half",
			name = L["sort method" .. i],
			desc = L["desc sort method" .. i],
			order = k * 10 + 3,
			cmdHidden = true,
			values = sm,
			get = function() 
				return self.db.profile.types[k_].sm 
			end,
			set = function(tmp, val) 
				self.db.profile.types[k_].sm = val
				if self.types[k_] then self.types[k_]:SetSortMethod(val) end
			end,
		}

		out["enable" .. i] = {
			type = "toggle",
			name = L["enable" .. i],
			desc = L["desc enable" .. i],
			order = k*10 + 4,
			cmdHidden = true,
			set = function(t, val)
				self.db.profile.types[k_].enable = val
				if self.types[k_] then self.types[k_]:Enable(val) end
			end,
			get = function() return self.db.profile.types[k_].enable end,
		}
	end
	
	return out
end

do -- expert configuration of spells
	function HCoold:RunPersonalSpellConfig()
		local AceGUI = LibStub("AceGUI-3.0")
		local pspells = self.db.faction.PlayersSpells
		
		local f = AceGUI:Create("Frame")
		local s = AceGUI:Create("ScrollFrame")
		local AddLine = nil
		local ann_res = false
		do -- frame creation
			f:SetLayout("Fill")
			f.state = true
			f:SetCallback("OnClose",function(widget) 
				f.state = false
				AceGUI:Release(widget) 
		
				if ann_res then
					StaticPopupDialogs["HCooldRedoLayout"]= {
						text = string.format(L["Don't forget to redraw layout to aply settings."]), 
						button1 = ACCEPT,
						timeout = 30, 
						whileDead = 0, 
						hideOnEscape = 1, 
					}
					StaticPopup_Show("HCooldRedoLayout")
				end
				
				HCoold:RunConfig()
			end)
			f:SetTitle(L["Manual spell settings"])

			s:SetLayout("List") -- probably?
			f:AddChild(s)
		end
		
		do -- create tools to create spell info
			local types = {}
			for _, i in next, spells do
				if not types[i.type] then
					types[i.type] = L["type" .. i.type]
				end
			end
			--table.sort(types)
		
			local sg1 = AceGUI:Create("InlineGroup")
			do -- sg1
				sg1:SetTitle(L["Add new spell options for current player."])
				sg1:SetFullWidth(true)
				sg1:SetLayout("Flow")
				sg1:SetAutoAdjustHeight(true)
				s:AddChild(sg1)
			end
			
			local dd1 = AceGUI:Create("Dropdown") -- type of spell
			local dd2 = AceGUI:Create("Dropdown") -- spell list in this category
			local inp1 = AceGUI:Create("EditBox") -- player name
			local inp2 = AceGUI:Create("EditBox") -- CD in sec
			local inp3 = AceGUI:Create("EditBox") -- id of spell
			local inp4 = AceGUI:Create("EditBox") -- casting time
			local inp5 = AceGUI:Create("EditBox") -- trigger event
			local dd3 = AceGUI:Create("Dropdown") -- quality of spell
			local dd4 = AceGUI:Create("Dropdown") -- spec of player to track spell
			local doit = AceGUI:Create("Button") -- button to add spell
			local values = {}
			local splist = {}
			local function onValueChanged()
				inp2:SetText()
				inp4:SetText()
				inp5:SetText()
				inp5:Fire("OnEnterPressed")
			end
			do --dd1
				sg1:AddChild(dd1)
				dd1:SetList(types)
				dd1:SetWidth(HCoold.config.dropdownwidth)
				dd1:SetCallback("OnValueChanged",function(_,_,key)
					splist = {}
					values = {}
					key = key or 8
					dd2:SetValue()
					inp3:SetText()
					for _, i in next, spells do
						if i.type == key then
							values[i.spellID] = select(1,GetSpellInfo(i.spellID))
							splist[i.spellID] = i
						end
					end
					dd2:SetList(values)
					onValueChanged()
				end)
				dd1:SetValue(8)
				dd1:Fire("OnValueChanged")
			end
			do --inp3
				inp3:SetWidth(HCoold.config.editboxwidth)
				sg1:AddChild(inp3)
				inp3:SetCallback("OnEnter",function() 
					GameTooltip:ClearLines()
					GameTooltip:SetOwner(inp3.frame, "ANCHOR_TOP", 0, 0)
					GameTooltip:AddLine(L["Enter id of spell"])
					GameTooltip:Show()
				end)
				inp3:SetCallback("OnLeave",function() GameTooltip:Hide() end)
				inp3:SetCallback("OnEnterPressed",onValueChanged)
			end
			do --dd2 --------- дописать изъятие кд и прочих вещей из БД
				dd2:SetWidth(HCoold.config.dropdownwidth)
				sg1:AddChild(dd2)
				dd2:SetCallback("OnValueChanged",function(_,_,key)
					onValueChanged()
					inp3:SetText(key)
					inp4:SetText(splist[key].cast_time or 0)
					inp2:SetText(splist[key].CD or 0)
					inp5:SetText(splist[key].succ or "SPELL_CAST_SUCCESS")
				end)
			end
			do --inp1
				inp1:SetWidth(HCoold.config.editboxwidth)
				sg1:AddChild(inp1)
				inp1:SetCallback("OnEnter",function() 
					GameTooltip:ClearLines()
					GameTooltip:SetOwner(inp1.frame, "ANCHOR_TOP", 0, 0)
					GameTooltip:AddLine(L["Enter player name"])
					GameTooltip:Show()
				end)
				inp1:SetCallback("OnLeave",function() GameTooltip:Hide() end)
			end
			do --inp2
				inp2:SetWidth(HCoold.config.editboxwidth)
				sg1:AddChild(inp2)
				inp2:SetCallback("OnEnter",function() 
					GameTooltip:ClearLines()
					GameTooltip:SetOwner(inp2.frame, "ANCHOR_TOP", 0, 0)
					GameTooltip:AddLine(L["Enter CD of spell in sec"])
					GameTooltip:Show()
				end)
				inp2:SetCallback("OnLeave",function() GameTooltip:Hide() end)
				inp2:SetCallback("OnEnterPressed",function() inp2:SetText(math.max(0,math.ceil(tonumber(inp2:GetText()) or 0))) end)
			end
			do --inp4
				inp4:SetWidth(HCoold.config.editboxwidth)
				sg1:AddChild(inp4)
				inp4:SetCallback("OnEnter",function() 
					GameTooltip:ClearLines()
					GameTooltip:SetOwner(inp4.frame, "ANCHOR_TOP", 0, 0)
					GameTooltip:AddLine(L["Enter casting time of spell"])
					GameTooltip:Show()
				end)
				inp4:SetCallback("OnLeave",function() GameTooltip:Hide() end)
				inp4:SetCallback("OnEnterPressed",function()
					local v = inp4:GetText()
					v = math.max(0,tonumber(v) or 0)
					inp4:SetText(v)
				end)
			end
			do --dd3
				sg1:AddChild(dd3)
				dd3:SetWidth(HCoold.config.dropdownwidth)
				dd3:SetList({1, 2, 3})
				dd3:SetValue(1)
				dd3:SetCallback("OnEnter",function() 
					GameTooltip:ClearLines()
					GameTooltip:SetOwner(dd3.frame, "ANCHOR_TOP", 0, 0)
					GameTooltip:AddLine(L["Enter quality of spell"])
					GameTooltip:Show()
				end)
				dd3:SetCallback("OnLeave",function() GameTooltip:Hide() end)
			end
			local spec_list = {"0","1","2","3","1,2","1,3","2,3"}
			do --dd4
				sg1:AddChild(dd4)
				dd4:SetList(spec_list)
				dd4:SetWidth(HCoold.config.dropdownwidth)
				dd4:SetCallback("OnValueChanged",function(_,_,key)
				end)
				dd4:SetCallback("OnEnter",function(self)
					GameTooltip:SetOwner(self.frame, "ANCHOR_TOPLEFT", 0, 0)
					GameTooltip:AddLine(L["Spec list by class"])
					GameTooltip:Show()
				end)
				dd4:SetCallback("OnLeave",function() GameTooltip:Hide() end)
			end
			do --inp5
				inp5:SetWidth(HCoold.config.editboxwidth)
				sg1:AddChild(inp5)
				inp5:SetCallback("OnEnter",function() 
					GameTooltip:ClearLines()
					GameTooltip:SetOwner(inp5.frame, "ANCHOR_TOP", 0, 0)
					GameTooltip:AddLine(L["Enter trigger event from combat log"])
					GameTooltip:Show()
				end)
				inp5:SetCallback("OnLeave",function() GameTooltip:Hide() end)
				inp5:SetCallback("OnEnterPressed",function() if inp5:GetText() == "" then inp5:SetText("SPELL_CAST_SUCCESS") end end)
				inp5:Fire("OnEnterPressed")
			end
			do --doit 
				doit:SetWidth(HCoold.config.addbuttonwidth)
				doit:SetText(L["Add spell"])
				sg1:AddChild(doit)
				doit:SetCallback("OnEnter",function(self)
					local splink = GetSpellLink(tonumber(inp3:GetText()) or 0)
					if not splink then return end
					GameTooltip:SetOwner(self.frame, "ANCHOR_TOPLEFT", 0, 0)
					GameTooltip:SetHyperlink(splink)
					GameTooltip:Show()
				end)
				doit:SetCallback("OnLeave",function() GameTooltip:Hide() end)
			end
			doit:SetCallback("OnClick",function()
				inp2:Fire("OnEnterPressed")
				inp1:Fire("OnEnterPressed")
				inp4:Fire("OnEnterPressed")
				inp5:Fire("OnEnterPressed")
				local spid, name, cd, casttime, sptype, trigger, quality = tonumber(inp3:GetText()), inp1:GetText(), tonumber(inp2:GetText()), tonumber(inp4:GetText()), dd1:GetValue(),inp5:GetText(),dd3:GetValue()
				if cd > 0 and string.len(name) > 0 and spid > 0 and GetSpellInfo(spid) ~= nil then
					local spec_spec = {
						["0"] = { 0 },
						["1"] = { 1 },
						["2"] = { 2 },
						["3"] = { 3 },
						["1,2"] = { 1, 2 },
						["1,3"] = { 1, 3 },
						["2,3"] = { 2, 3 },
					}
					local i = {
						spellID = spid,
						succ = trigger,
						player = name,
						CD = cd,
						type = sptype,
						cast_time = casttime,
						specs = spec_spec[spec_list[dd4:GetValue() or 1]],
						quality = quality,
					}
					table.insert(pspells,i)
					ann_res = true
					AddLine(i)
					f:SetStatusText(L["Cooldown successfully added!"])
				else
					f:SetStatusText(L["You should enter spell id, player name and cooldown of spell."])
				end
			end)
		end
		
		do -- add List of spells
			function DeleteFromMemory(i)
				for k, j in next, pspells do
					if j == i then 
						table.remove(pspells,k)
						f:SetStatusText(L["Cooldown successfulle deleted!"])
					end
				end
			end
			
			AddLine = function(i)
				local sg2 = AceGUI:Create("InlineGroup")
				sg2:SetLayout("Flow")
				sg2:SetFullWidth(true)
				s:AddChild(sg2)
				
				local spname,_, spicon = GetSpellInfo(i.spellID)
				local splink = GetSpellLink(i.spellID)
				
				local label = AceGUI:Create("InteractiveLabel")
				label:SetImageSize(21,21)
				label:SetFullWidth(true)
				label:SetImage(spicon)
				local specs = ""
				local first = nil
				if i.specs then for _, k in next, i.specs do 
					if not first then first = ""
					else first = ", " end
					specs = string.format("%s%s%d",specs,first,k)
				end end
				label:SetText(string.format(L["Spell %s(id=%d, type=%s, quality=%d, specs=%s) for player %s has CD %d sec cast time %.1f and trigger from %s."],splink,i.spellID,L["type" .. i.type],i.quality,specs,i.player,i.CD,i.cast_time,i.succ))
				label:SetCallback("OnEnter",function(self)
					GameTooltip:SetOwner(self.frame, "ANCHOR_TOPLEFT", 0, 0)
					GameTooltip:SetHyperlink(splink)
					GameTooltip:Show()
				end)
				label:SetCallback("OnLeave",function() GameTooltip:Hide() end)
				sg2:AddChild(label)
				
				local cb = AceGUI:Create("CheckBox")
				sg2:AddChild(cb)
				cb:SetValue(self.db.profile.trackManualSpells[self:ManualSpellIndex(i)])
				cb:SetWidth(HCoold.config.checkboxwidth)
				cb:SetLabel(L["Track spell"])
				cb:SetCallback("OnValueChanged",function() 
					self.db.profile.trackManualSpells[self:ManualSpellIndex(i)] = cb:GetValue() 
					ann_res = true
				end)
				
				sg2:SetTitle(string.format(L["Configuration for %s spell"],spname))
				local k = AceGUI:Create("Button")
				k:SetWidth(HCoold.config.deletebuttonwidth)
				k:SetText(L["Delete"])
				sg2:AddChild(k)
				k:SetCallback("OnClick",function()
					StaticPopupDialogs["HCooldAcceptDeleteSpell"]= {
						text = string.format(L["You realy want to delete spell %s?"],spname), 
						button1 = ACCEPT,
						button2 = CANCEL,
						timeout = 30, 
						whileDead = 0, 
						hideOnEscape = 1, 
						OnAccept = function() 
							k:SetDisabled(true)
							k:SetText(L["Deleted"])
							DeleteFromMemory(i)
							ann_res = true
						end,
					}
					StaticPopup_Show("HCooldAcceptDeleteSpell")
				end)
			end
			
			for _, i in next, pspells do AddLine(i) end
		end
		
		return f
	end
end






















