﻿if not HCoold then return false end
local L = HCoold:GetLocale()

function HCoold:GetRaidList() --+ get list of raid members with it's cd's
	local out = {}
	for i = 1, self:NumRaidMembers() do
		local name = GetRaidRosterInfo(i) -- , _, subgroup, _, _, class, _, online, isDead
		if self:IsInRaid(name) then table.insert(out,{
			name = name,
			CDs = self:GetCDs(self:GetSpec(i))
		}) end
	end

	return out
end

function HCoold:GetSpec(inc) --+ get player's spec
	local out = {}
	if not tonumber(inc) then 
		for i = 1, self:NumRaidMembers() do
			if select(1,GetRaidRosterInfo(i)) == inc then
				inc = i
			end
		end
	end
	if not tonumber(inc) then return out end
	
	out.name, out.class = select(1,GetRaidRosterInfo(inc)), select(6,GetRaidRosterInfo(inc))
	out.spec = self.db.faction.players[out.name] or 0
	return out
end

function HCoold:GetCDs(inp) --+ get cd's for current class+spec
	local out, check = {}, {}
	for _,i in next, self.db.faction.PlayersSpells do 
		local dd = false
		if i.player == inp.name and i.track then dd = true end
		-- check specs first
		if dd then for _,k in next, i.specs do if not (k == inp.spec or k == 0) then dd = false end end end
		if dd then
			table.insert(out,i)
			table.insert(check,i)
		end
	end
	
	for _,v in next, self.spells do
		if v.class == inp.class then
			local succ = false
			for _,k in next, v.specs do if k == inp.spec or k == 0 then succ = true end end
			for _,k in next, check do if k.spellID == v.spellID then succ = false end end
			if succ then table.insert(out,v) end
		end
	end
	wipe(check)
	
	return out
end

function HCoold:GetSpellBySpec(id,spec) -- return link to spell by spec and id
	for _,i in next, self.spells do
		local do_ = false
		if i.spellID == id then do_ = true end
		if i.trigger then for _, k in next, i.trigger do if k == id then do_ = true end end end
		if do_ then for _,j in next, i.specs do if j == spec or j == 0 then return i end end end
	end
	return nil
end

function HCoold:DeleteSpells() --+ delete spells if player change spec etc...
	local raid = self:GetRaidList()
	
	for _, i in next, self.types do
		-- for each type of spells
		for k = # i.spells, 1, -1 do
			local j = i.spells[k]
			-- for each spell check, if it's in CDs of raid
			local find = false
			for _,p in next, raid do
				if p.name == j.player then
					for _,s in next, p.CDs do
						if s.spellID == j.id then find = true end
					end
				end
			end
			if not find then
				j:Hide()
				table.remove(i.spells,k)
			end
		end
		i:SortSpells()
	end
end

do --+ frame renew actions
	function HCoold:RenewStatus() --+ renew status of frames
		-- for each raid cd's type run own Update() function
		for _, i in next, self.types do i:Update() end
	end

	function HCoold:StartCD(...) --+ start cd for player's spell
		--[[
			... = 
				player
				spell
		]]
		local player, spell = ...
		
		local curr = self:GetSpell(player, spell.spellID)
		if curr == nil then return end
		curr:StartCD()
		self:AnnounceCDStart(curr)
		self:SaveSessionCDs(curr)
	end
	
	function HCoold:AnnounceCDStart(spell)
		local spName, _, icon = GetSpellInfo(spell.id)
		local spLink = GetSpellLink(spell.id)
		if spLink ~= nil then spName = spLink end

		local out = string.format(L["%s casted %s."],spell.player,spName)
		if self.db.profile.ann.s_self then self:Chat(out) end
	end

	function HCoold:AnnounceCDEnd(spell) -- announce end CD of spell
		local conf = self.db.profile.ann
		
		local spName, _, icon = GetSpellInfo(spell.id)
		local spLink = GetSpellLink(spell.id)
		if spLink ~= nil then spName = spLink end
		if spName == nil then self:Printf("Empty return of GetSpellInfo() and GetSpellLink() HCoold:AnnounceCDEnd(spell)"); return end
		local player = spell.player
		
		local out = string.format(L["Spell %s of %s is ready!"],spName,player)
		
		local has_ass = false
		local our_name = UnitName("player")
		for i = 1, self:NumRaidMembers() do
			local name, rank = GetRaidRosterInfo(i)
			if name == our_name then has_ass = true end
		end
		
		self:AnnounceCDEndAddons(out,icon)
		
		if conf.self then self:Chat(out) end
		
		if conf.only_rl and (not has_ass) then return end -- if don't have accistance
		
		if conf.rw then SendChatMessage(out,"RAID_WARNING") end
		if conf.raid then SendChatMessage(out,"RAID") end
		if conf.party then SendChatMessage(out,"PARTY") end
		if conf.say then SendChatMessage(out,"SAY") end
		if conf.yell then SendChatMessage(out,"YELL") end
	end

	function HCoold:AnnounceCDEndAddons(out,icon) -- announce end CD of spell
		self:RegisterBossMods()
		local conf = self.db.profile.ann.addons
		if self.bw and conf.bw then
			self.bw:SendMessage("BigWigs_Message", nil, nil, out, "Positive", true, "BigWigs: Info", nil, icon)
		end
		if self.dxe and conf.dxe then
			self.dxe:Simple(out,5,"ALERT10","GREEN", nil, icon)
		end
		if self.dbm and conf.dbm then
			local na = self.dbm:NewAnnounce("%s", 1, icon)
			na:Show(out)
		end
	end
end

do --+ actions with time
	local max_diff = -1
	local count = 0
	local max_count = 100
	local function hundr()
		if count < max_count then
			local tmp = time() - GetTime()
			if max_diff == -1 then max_diff = tmp end
			max_diff = math.max(max_diff,tmp)
			count = count+1
		end
	end
	
	function HCoold:GetEndTime(delay) -- return timestamp+delay
		hundr()
		return GetTime() + max_diff + delay
	end

	function HCoold:GetDiff(end_time) -- return time - end_time
		hundr()
		return end_time - (GetTime() + max_diff)
	end

	function HCoold:GetTextDiff(end_time) -- return time - end_time in "mm:ss" format
		local tt = self:GetDiff(end_time)
		local diff = math.floor(tt)
		local hundr = tt - diff
		if diff < self.db.profile.timer_min_diff then return string.format("%.1f",tt) end
		if diff < 60 and diff >= self.db.profile.timer_min_diff then return string.format("%d",diff) end
		if diff >= 60 then
			local min_ = math.floor(diff / 60)
			local sec = diff - min_*60
			if sec < 0 then 
				min_ = min_ - 1
				sec = sec + min_ * 60
			end
			if sec < 10 then sec = "0" .. sec end
			return string.format("%d:%s",min_,sec)
		end
	end

	function HCoold:GetColor(...) -- return color, quality of spell
		--[[
			1 - supergood
			2 - good
			3 - bad
			4 - dead
			5 - offline
			6 - casting
			7 - cooldown
		]]
		local spellID, player = ...
		local quality = nil
		for i = 1, self:NumRaidMembers() do if select(1,GetRaidRosterInfo(i)) == player then
			local isDead = select(9,GetRaidRosterInfo(i))
			local online = select(8,GetRaidRosterInfo(i))
			if not online then quality = 5 end
			if isDead then quality = 4 end
		end end
		
		local spec = HCoold:GetSpec(player)
		local spell = HCoold:GetSpellBySpec(spellID,spec.spec)
		spell = self:GetManualSpell(spellID, player) or spell
		if spell then 
			quality = quality or spell.quality 
		end
		
		quality = quality or 1
		local color = HCoold:GetColorByQuality(quality)
		
		return color, quality
	end

	function HCoold:GetColorByQuality(q) -- return color by quality of color
		local color = ""
		if q == 1 then color = self.db.profile.color.bad
		elseif q == 2 then color = self.db.profile.color.good
		elseif q == 3 then color = self.db.profile.color.supergood
		elseif q == 4 then color = self.db.profile.color.dead
		elseif q == 5 then color = self.db.profile.color.offline
		elseif q == 6 then color = self.db.profile.color.active
		elseif q == 7 then color = self.db.profile.color.cd
		end
		return color
	end
end

function HCoold:GetSpell(...) --+ get frame of spell by id and player name
	local player, spellID = ...
	for _,v in next, self.types do -- for each type of cd 
		for _,i in next, v.spells do -- for each spell run spell:IsSpell
			if i:IsSpell(spellID,player) then
				return i
			end
		end
	end
	
	return nil
end

do -- lock/unlock frames
	function HCoold:UnlockFrames()
		for _,i in next, self.types do i.cont:Show() end
		if self.activeSpells then self.activeSpells.anchor:Show() end
	end
	
	function HCoold:LockFrames()
		for _,i in next, self.types do i.cont:Hide() end
		if self.activeSpells then self.activeSpells.anchor:Hide() end
	end

	function HCoold:WIPE()
		if not self.types then return end
		for _,i in next, self.types do
			i:Hide()
		end
		if self.activeSpells then self.activeSpells.anchor:Hide() end
	end
	
	function HCoold:DrawNew()
		self:MakeSpellList() -- making spells for tracking from setup
		self:MakeSpellGroups() -- making frames for align spells
		self:CheckPlayersCDs()
		self:ClearSessionCD()
	end
end

function HCoold:GetManualSpell(id, player)
	for _,i in next, self.db.faction.PlayersSpells do 
	if i.spellID == id and i.player == player and self.db.profile.trackManualSpells[self:ManualSpellIndex(i)] then 
		-- check spec first
		local spec = self:GetSpec(player)
		for _, j in next, i.specs do
			if spec.spec == j or j == 0 then
				return i 
			end
		end
	end end
	return nil
end

function HCoold:ManualSpellIndex(i)
	local specs = ""
	local first = nil
	if i.specs then for _, k in next, i.specs do 
		if not first then first = ""
		else first = "," end
		specs = string.format("%s%s%d",specs,first,k)
	end end
	local index = string.format("%d.%s.%d.%s.%s.%d.%.1f.%s",i.spellID,i.type,i.quality,specs,i.player,i.CD,i.cast_time,i.succ)
	return index
end
