GBL_AUDIT_DELAY = 20
GBVendor_Listen = false

if GBL_Vendor == nil then
   --create event handler frame
   GBL_Vendor = CreateFrame("Frame","GuildVendorFrame",UIParent);
   GBL_Vendor:SetScript("OnEvent", function() gvend_OnEvent() end);
   GBL_Vendor:RegisterEvent("GUILDBANK_UPDATE_MONEY");
   GBL_Vendor:RegisterEvent("GUILDBANKLOG_UPDATE");
   GBL_Vendor:RegisterEvent("CHAT_MSG_ADDON");
   GBL_Vendor:RegisterEvent("GUILD_ROSTER_UPDATE");
   if GBL_Largess == nil then
      GBL_Largess = 0
   end      
end

--event handler
function gvend_OnEvent()
   local transt,name,amount,n,i,gbcut
   --GBL_LargessMessage(event)
   if (event == "GUILDBANK_UPDATE_MONEY") then
      QueryGuildBankLog(MAX_GUILDBANK_TABS+1 )   
      GBVendor_Listen = true  
      
   elseif (event == "GUILDBANKLOG_UPDATE") then
      --GBL_msg("GUILDBANKLOG_UPDATE")
      --GBL_LargessMessage(GBVendor_Listen)
      if (GBVendor_Listen) then          
         transt,name,amount = GetGuildBankMoneyTransaction(GetNumGuildBankMoneyTransactions())                 
         GBVendor_Listen = false
         if transt == "deposit" then
            gbcut = GBL_GetGBCut()
            GBL_AddLargess(amount-floor(gbcut*amount));          
         elseif transt == "withdraw" then
            GBL_SubLargess(amount);
         end
      end  
      GBL_BANKLOG_UPDATED = true
      if GBL_DO_AUDIT and GBL_ROSTER_UPDATED then        
         if GBL_GuildInfoText == "" then         
            GBL_DelayScript("GBL_DoAudit()",GBL_AUDIT_DELAY+10)            
         else
            GBL_DelayScript("GBL_DoAudit()",GBL_AUDIT_DELAY)           
         end      
          GBL_LargessMessage("Starting audit...")
      end
      
   elseif (event == "GUILD_ROSTER_UPDATE") then
      --GBL_LargessMessage("GUILD_ROSTER_UPDATE")
      local gnum = GetNumGuildMembers(true)
      local i,name, rank, rankIndex, level, class, zone, note, officernote, online, status, classFileName
      GBL_GuildMates = {}      
      for i = 1,gnum do
         name,rank,rankIndex,level,class,zone,note,officernote,online,status,classFileName = GetGuildRosterInfo(i) 
         table.insert(GBL_GuildMates,{name=name,note=officernote})
      end  
      GBL_GuildInfoText = GetGuildInfoText()      
      GBL_ROSTER_UPDATED = true      
      GBL_AuditInit()
      GBL_AuditLoad()
      --[[if GBL_DO_AUDIT and GBL_BANKLOG_UPDATED then        
         if GBL_GuildInfoText == "" then
            GBL_DelayScript("GBL_DoAudit()",GBL_AUDIT_DELAY+10) 
         else
            GBL_DelayScript("GBL_DoAudit()",GBL_AUDIT_DELAY)       
         end
      end]]
   end  
end

function GBL_AddLargess(amount)     
   GBL_Largess = GBL_Largess + amount;
   local msg = "Your guild Largess has increased to "..GBL_CopperToGold(GBL_Largess);
   if GBL_Largess > 0 then
      GBL_LargessMessage(msg);
   else
      GBL_LargessMessage(msg, "red")
   end
   if GBH_LargessAmountFrame then
      MoneyFrame_Update(GBH_LargessAmountFrame, GBL_Largess);
   end
end

function GBL_SubLargess(amount)     
   GBL_Largess = GBL_Largess - amount;
   local msg = "Your guild Largess has decreased to "..GBL_CopperToGold(GBL_Largess);
   GBL_LargessMessage(msg,"red");
   if GBH_LargessAmountFrame then
      MoneyFrame_Update(GBH_LargessAmountFrame, GBL_Largess);
   end
end

function GBL_LargessMessage(msg,color)   
   if (color == nil) or (color == "GREEN") or (color == "green") then 
      --default color is green
      DEFAULT_CHAT_FRAME:AddMessage(msg, 0, 1, 0);
   elseif (color == "RED") or (color == "red") then
      --here's red
      DEFAULT_CHAT_FRAME:AddMessage(msg, 1, 0, 0);
   elseif (color == "sys") then
      --yellow?
      DEFAULT_CHAT_FRAME:AddMessage(msg, 1, 1, 0);
   end   
end

function GBL_CopperToGold(copper)
   local gp,sp,cp,gsp;    
   gp = floor(copper/10000);
   sp = abs(floor(mod(copper,10000)/100));   
   cp = abs(mod(mod(copper,10000),100));    
   gsp = tostring(gp).."g "..tostring(sp).."s "..tostring(cp).."c";
   return gsp;
end

function GBL_GetGBCut()
   local text = GBL_GuildInfoText
   local s,e,cut = string.find(text,"::GBL:C(.?%d*):")
   if cut then
      return cut   
   else
      return 0
   end
end

function GBL_SetGBCut(cut)
   if not CanEditGuildInfo() then
      GBL_LargessMessage("You need permission to edit guild info.")
      return
   end
   local ginfo = GBL_GuildInfoText
   if ginfo == nil then
      ginfo = ""
   end
   local gbc,n = string.gsub(ginfo,"::GBL:C.?%d*:","::GBL:C"..cut..":")  
   if n == 1 then       
      SetGuildInfoText(gbc)
   else  
      SetGuildInfoText(ginfo.."::GBL:C"..cut..":")
   end
end

function GBL_SetLargess(name, amount)
   if not CanEditOfficerNote() then 
      GBL_LargessMessage("You do not have permission to edit officer notes.")
      return
   end
   
   local i,gnum
   
   GBL_AuditInit()
   GBL_AuditLoad()  
   
   if name == "all" then
      gnum = #GBL_GuildMates
      for i = 1,gnum do
         GBL_AuditData[GBL_GuildMates[i].name].largess = tonumber(amount)
      end
   else
      GBL_AuditData[name].largess = tonumber(amount)
   end
   
   GBL_AuditSave()
end

function GBL_ModLargess(name, amount)
   if not CanEditOfficerNote() then 
      GBL_LargessMessage("You do not have permission to edit officer notes.")
      return
   end
   
   local i,gnum
   
   GBL_AuditInit()
   GBL_AuditLoad()  
   
   if name == "all" then
      gnum = #GBL_GuildMates
      for i = 1,gnum do         
         GBL_AuditData[GBL_GuildMates[i].name].largess = GBL_AuditData[GBL_GuildMates[i].name].largess + tonumber(amount)         
      end
   else
      GBL_AuditData[name].largess = GBL_AuditData[name].largess + tonumber(amount)      
   end
   
   GBL_AuditSave()
end   

function GBL_GuildLargessReport()
   if not CanViewOfficerNote() then
      GBL_LargessMessage("You do not have permission to view officer notes.")
      return
   end  
   local i,name,largess
   GBL_AuditInit()
   GBL_AuditLoad()
   GBL_LargessMessage("-------------------------------")
   GBL_LargessMessage("Guild Largess Report")
   GBL_LargessMessage("-------------------------------")
   
   for i = 1,#GBL_GuildMates do
      name = GBL_GuildMates[i].name
      largess = GBL_AuditData[name].largess
      if largess < 0 then
         GBL_LargessMessage(name..": "..largess,"red")
      else
         GBL_LargessMessage(name..": "..largess,"green")
      end
   end
end

function GBL_AuditPrep()
   if GBL_GetAdminLevel() < GBL_SUPER_ADMIN then
      GBL_LargessMessage("You do not have permission to perform audits.")
      return
   end
   GBL_LargessMessage("Audit pending...")
   if not GBL_BANKLOG_UPDATED then
      GBL_LargessMessage("Guild Bank Money Log update required.")
   end
   if not GBL_ROSTER_UPDATED then
      GBL_LargessMessage("Guild Roster update required.")
   end 
      GBL_DO_AUDIT = true
      QueryGuildBankLog(7)
      GuildRoster()
end
