GBL_SEC_PER_HR = 3600
GBL_SEC_PER_DAY = 24*GBL_SEC_PER_HR
GBL_SEC_PER_MO = 30.41*GBL_SEC_PER_DAY
GBL_SEC_PER_YR = 12*GBL_SEC_PER_MO
GBL_DO_AUDIT = false
GBL_ROSTER_UPDATED = false
GBL_BANKLOG_UPDATED = false
GBL_AuditData = {}
GBL_GuildMates = {}
GBL_SUPER_ADMIN = 2
GBL_ADMIN = 1
GBL_USER = 0
GBL_PURGE_AGE_CLAIMED = GBL_SEC_PER_MO --prune the hit list age
GBL_PURGE_AGE_DEL = GBL_SEC_PER_DAY*7 --prune the hit list age

function GBL_DoAudit()   
   GBL_AuditInit() 
   GBL_AuditLoad()   
   GBL_AuditBank()
   GBL_AuditSave()   
   GBL_DO_AUDIT = false
   GBL_ROSTER_UPDATED = false
   GBL_BANKLOG_UPDATED = false
   GBL_LargessMessage("Audit complete.")
end	

function GBL_AuditInit()    
   GBL_AuditData = {}
   GBL_AuditData["last"] = {}
   GBL_AuditData["last"].t0 = ""
   GBL_AuditData["last"].n0 = ""
   GBL_AuditData["last"].a0 = 0
   GBL_AuditData["last"].y0 = 0
   GBL_AuditData["last"].m0 = 0
   GBL_AuditData["last"].d0 = 0
   GBL_AuditData["last"].h0 = 0
   GBL_AuditData["last"].c0 = 0
   GBL_AuditData["last"].ts0 = 0     
   
   if GBL_GuildMates == nil then
      return
   end
   
   local i,name
   local gnum = #GBL_GuildMates
   
   for i = 1,gnum do
      name = GBL_GuildMates[i].name     
      GBL_AuditData[name] = {}      
      GBL_AuditData[name].largess = 0   
      GBL_msg("AuditInit: "..name.." "..GBL_AuditData[name].largess)
   end   
end

function GBL_AuditBank()
   if not CanEditGuildInfo() then
      GBL_LargessMessage("You do not have permission to audit the guild bank.")
      return
   end
   
   local typ, name, amount, y, m, d, h
	local num = GetNumGuildBankMoneyTransactions()
	local i,ts,allnew,lasttrans
   local nonew = true
   
   GBL_LoadLastAudit()   
   if GBL_AuditData["last"].t0 == "" then 
      GBL_msg("t0: "..GBL_AuditData["last"].t0,"red")
      -- if we don't have a last audit, they're all new
      allnew = true
   else
      -- we've got audit data, let's use it
      allnew = false
   end   
	for i = 1,num do    
      lasttrans = GBL_IsTransactionNew(i)
		if allnew or lasttrans==true then		         
         typ, name, amount, y, m, d, h = GetGuildBankMoneyTransaction(i)  
         if not (name == nil) then  --ignore nil transactions
            nonew = false
            GBL_msg("New:"..i..":"..typ..":"..name..":"..amount)     
            if typ == "deposit" then
               GBL_LargessMessage("New Transaction: "..name..":"..typ..":"..amount..":"..d..":"..h)
               local gbcut = GBL_GetGBCut()
               if GBL_AuditData[name] then
                  GBL_AuditData[name].largess = GBL_AuditData[name].largess + amount-floor(gbcut*amount)
               end
            elseif typ == "withdraw" or typ == "repair" then
               GBL_LargessMessage("New Transaction: "..name..":"..typ..":"..amount..":"..d..":"..h, "red")
               if GBL_AuditData[name] then
                  GBL_AuditData[name].largess = GBL_AuditData[name].largess - tonumber(amount)
               end
            end     
            GBL_UpdateLastTransaction(i)  
         end
		else 
         if lasttrans == 2 then
            allnew = true
         end         
         GBL_msg("Old:"..i)
      end
	end  
   if nonew then
      GBL_LargessMessage("No new guild bank transactions.")
   end      
   GBL_SaveLastAudit()
   GBL_DO_AUDIT = false
   GBL_ROSTER_UPDATED = false
   GBL_BANKLOG_UPDATED = false
end

function GBL_GetTransactionTimeStamp(y,m,d,h)
   local t = time()
   t = t-y*GBL_SEC_PER_YR-m*GBL_SEC_PER_MO-d*GBL_SEC_PER_DAY-h*GBL_SEC_PER_HR
   return t
end

function GBL_AuditLoad()
   local gnum = #GBL_GuildMates
   local name,note
   local i,name,s,e,sign,largess
   
   for i = 1,gnum do      
      name = GBL_GuildMates[i].name
      note = GBL_GuildMates[i].note
      s,e,largess = string.find(note,"::GBL:L(.?%d*)::")
      
      if largess == nil then
         --deprecated
         s,e,largess = string.find(note,"::GBH:L(.?%d*)::")  
         GBL_AuditData[name].largess = tonumber(largess)           
      end  
      
      --
      -- insert more backwards compatibility here as needed
      -- 
      
      if largess == nil then
         largess = 0
      end  
      
      GBL_AuditData[name].largess = tonumber(largess)  
      GBL_GuildMates[i].note = "::GBL:L"..largess.."::"
   end
   
   GBL_msg("Largess loaded from officer notes.")
end

function GBL_AuditSave()
   local gnum = #GBL_GuildMates
   local name,note
   local i,s,e,largess
   local gl,n
   
   GBL_msg("AuditSave gnum: "..gnum)
   
   for i = 1,gnum do         
      name = GBL_GuildMates[i].name
      note = GBL_GuildMates[i].note
      GBL_msg("AuditSave: "..name.." Note: "..note)
      largess = GBL_AuditData[name].largess            
      if note == nil then
         note = "::GBL:L"..largess.."::"
      else
         gl,n = string.gsub(note,"::GBL:L.?%d*::","::GBL:L"..largess.."::")  
         if n == 1 then
            GuildRosterSetOfficerNote(i,gl)
         else
            GuildRosterSetOfficerNote(i,note.."::GBL:L"..largess.."::")
         end
      end      
   end
   GBL_msg("Largess saved to officer notes.")
end

function GBL_AuditClear()   
   local gnum = #GBL_GuildMates
   local name,note
   local i,s,e,largess
   local gl,n  
   
   for i = 1,gnum do          
      GuildRosterSetOfficerNote(i,"")          
   end
   --gbl_msg("Largess saved to officer notes.")
end

function GBL_AuditPrint()
   local gnum = #GBL_GuildMates
   local i,name

   for i = 1,gnum do
      name = GBL_GuildMates[i].name      
      if GBL_AuditData[name].largess < 0 then
         GBL_LargessMessage(name..":"..GBL_AuditData[name].largess,"red")
      else 
         GBL_LargessMessage(name..":"..GBL_AuditData[name].largess)
      end     
   end
end

--this works fine, but could be simpler
--need to guarante guild info text is latest
function GBL_IsTransactionNew(i)
   --should change this function name to 
   --GBL_IsTranscationLastAudit
	local t0 = GBL_AuditData["last"].t0
	local n0 = GBL_AuditData["last"].n0
	local a0 = GBL_AuditData["last"].a0
	local y0 = GBL_AuditData["last"].y0
	local m0 = GBL_AuditData["last"].m0
	local d0 = GBL_AuditData["last"].d0
	local h0 = GBL_AuditData["last"].h0	
	local c0 = GBL_AuditData["last"].c0
	local ts0 = GBL_AuditData["last"].ts0
	local ti,ni,ai,yi,mi,di,hi = GetGuildBankMoneyTransaction(i)
   if ni == nil then
      return true
   end
   --local ts0 = GBL_GetTransactionTimeStamp(y0,m0,d0,h0)
   local tsi = GBL_GetTransactionTimeStamp(yi,mi,di,hi)
   local ci   
   
   --GBL_msg("IsNew?:"..i..":"..tsi..":"..ts0..":"..ni..":"..ai..":"..ti)
   if t0 == "" then return true end
   --upper bounds of temporal certaintly (definately new)
   if tsi > (ts0 + 3600) then
      GBL_msg("state1")
      return true
   end
   --lower bounds of temporal certainty (definately old)
   if tsi < (ts0 -3600) then
       GBL_msg("state 2")
      return false
   end
   
   --we couldn't tell by our timestamp alone
   --check other transaction parameters
	if not (ni == n0) then
      GBL_msg("state3")
      return false
   end
	if not (ti == t0) then 
      GBL_msg("state4:"..ti.."~="..t0)
      return false
   end
	if not (ai == a0) then 
     GBL_msg("state5:"..ai..":"..a0)
      return false 
   end
   
   -- transactioni == transaction0 at this point
   -- could we have reached the last saved transaction?
   -- how many have we had within the zone of temporal uncertainty?
   ci = GBL_CntSimTrans(i)     
   
   if ci == c0 then
      --this is the last audit transaction
      return 2
   end
   
   if ci > c0 then 
      --looks like we've got a new one, this means the rest must be new too      
		GBL_AuditData["last"].c0 = c0 + 1
      GBL_msg("state6:ci: "..ci.." c0: "..c0)
		return true
	else 
      GBL_msg("state7")
		return false 
	end 
end

function GBL_UpdateLastTransaction(i)
	local ti,ni,ai,yi,mi,di,hi = GetGuildBankMoneyTransaction(i)
   if ni == nil then
      return
   end
	local tsi = GBL_GetTransactionTimeStamp(yi,mi,di,hi)
	
	GBL_AuditData["last"].t0 = ti
	GBL_AuditData["last"].n0 = ni
	GBL_AuditData["last"].a0 = ai
	GBL_AuditData["last"].y0 = yi
	GBL_AuditData["last"].m0 = mi
	GBL_AuditData["last"].d0 = di
	GBL_AuditData["last"].h0 = hi
   GBL_AuditData["last"].c0 = GBL_CntSimTrans(i)
   GBL_AuditData["last"].ts0 = tsi
   
end

function GBL_CntSimTrans(i)
	local j
	local c = 0
	local ti,ni,ai,yi,mi,di,hi = GetGuildBankMoneyTransaction(i)
   if ni == nil then
      return 0
   end
	local tj,nj,aj,yj,mj,dj,hj
   local si,sj 
   
	for j = 1,i-1 do      
		tj,nj,aj,yj,mj,dj,hj = GetGuildBankMoneyTransaction(j)
      if not (nj == nil) then
         si = ti..ni..ai..yi..mi..di..hi 
         sj = tj..nj..aj..yj..mj..dj..hj
         if ( si == sj ) then
            c = c + 1
         end
      end
	end	
   GBL_msg("GBL_CntSimTrans: "..c)
	return c
end

function GBL_LoadLastAudit()     
   if GBL_GuildInfoText == "" then
      GBL_msg("GInfo empty")
      --condense this logic plz
      GBL_AuditData["last"] = {}
      GBL_AuditData["last"].t0 = ""
      GBL_AuditData["last"].n0 = ""
      GBL_AuditData["last"].a0 = 0
      GBL_AuditData["last"].y0 = 0
      GBL_AuditData["last"].m0 = 0
      GBL_AuditData["last"].d0 = 0
      GBL_AuditData["last"].h0 = 0
      GBL_AuditData["last"].c0 = 0
      GBL_AuditData["last"].ts0 = 0       
      return
   end
      
   local s,e,t0,n0,a0,y0,m0,d0,h0,c0,ts0 = string.find(GBL_GuildInfoText,"::GBL:C.+:t0(.+):n0(.+):a0(.+):y0(.+):m0(.+):d0(.+):h0(.+):c0(.+):ts0(.+)::")
   
   if not (s == nil) then
      GBL_msg("Loading last audit "..string.sub(GBL_GuildInfoText,s,e))
   end
   
   if t0 then  
      GBL_msg("t0 exists")
      --GBL_AuditData = {}
      GBL_AuditData["last"] = {}
      GBL_AuditData["last"].t0 = t0
      GBL_AuditData["last"].n0 = n0
      GBL_AuditData["last"].a0 = tonumber(a0)
      GBL_AuditData["last"].y0 = tonumber(y0)
      GBL_AuditData["last"].m0 = tonumber(m0)
      GBL_AuditData["last"].d0 = tonumber(d0)
      GBL_AuditData["last"].h0 = tonumber(h0)
      GBL_AuditData["last"].c0 = tonumber(c0)
      GBL_AuditData["last"].ts0 = tonumber(ts0)      
   else
      GBL_msg("t0 is nil")
      --GBL_AuditData = {}
      --with this redundant logic
      GBL_AuditData["last"] = {}
      GBL_AuditData["last"].t0 = ""
      GBL_AuditData["last"].n0 = ""
      GBL_AuditData["last"].a0 = 0
      GBL_AuditData["last"].y0 = 0
      GBL_AuditData["last"].m0 = 0
      GBL_AuditData["last"].d0 = 0
      GBL_AuditData["last"].h0 = 0
      GBL_AuditData["last"].c0 = 0
      GBL_AuditData["last"].ts0 = 0       
   end
   GBL_msg("LoadLastAudit:t0:"..GBL_AuditData["last"].t0..":n0"..GBL_AuditData["last"].n0..":a0"..GBL_AuditData["last"].a0)
end

function GBL_SaveLastAudit()
   if not CanEditGuildInfo() then
      GBL_LargessMessage("You need permission to edit guild info.")
      return
   end
   local s,e,t0,n0,a0,y0,m0,d0,h0,c0,ts0,cut,ginfo
   t0 = GBL_AuditData["last"].t0
   n0 = GBL_AuditData["last"].n0
   a0 = GBL_AuditData["last"].a0
   y0 = GBL_AuditData["last"].y0
   m0 = GBL_AuditData["last"].m0
   d0 = GBL_AuditData["last"].d0
   h0 = GBL_AuditData["last"].h0
   c0 = GBL_AuditData["last"].c0
   ts0 = GBL_AuditData["last"].ts0     
   cut = GBL_GetGBCut()
   
   local ginfo,n = string.gsub(GBL_GuildInfoText,"::GBL:C.?%d*:t0%a*:n0%a*:a0%d*:y0%d*:m0%d*:d0%d*:h0%d*:c0%d*:ts0%d*::","::GBL:C"..cut..":t0"..t0..":n0"..n0..":a0"..a0..":y0"..y0..":m0"..m0..":d0"..d0..":h0"..h0..":c0"..c0..":ts0"..ts0.."::")  
   if n == 1 then  
      --found audit string in guild info
      GBL_GuildInfoText = ginfo          
   else    
      --did not find audit string, so add it
      GBL_GuildInfoText = ginfo.."::GBL:C"..cut..":t0"..t0..":n0"..n0..":a0"..a0..":y0"..y0..":m0"..m0..":d0"..d0..":h0"..h0..":c0"..c0..":ts0"..ts0.."::"      
   end    
   SetGuildInfoText(GBL_GuildInfoText)
   GuildRoster()
   GBL_msg("SaveLastAudit: " ..GBL_GuildInfoText)
end
