--Kill Event Listener Frame
if GBH_KillFrame == nil then
   CreateFrame("Frame", "GBH_KillFrame",UIParent);
   GBH_KillFrame:SetScript("OnEvent", function() kill1_OnEvent(event) end);    
   GBH_KillFrame:RegisterEvent("COMBAT_LOG_EVENT");
   GBH_KillFrame:RegisterEvent("CHAT_MSG_SYSTEM");    
end

function kill1_OnEvent(event)     
   --check for duel victory
   if (event == "CHAT_MSG_SYSTEM") then
      local s,e,winner,loser,f,i,audit    
      s,e,winner,loser = string.find(arg1,"(.+) has defeated (.+) in a duel")     
      if winner == nil then return end    
      
      local f, i = IsBountyOpen(loser)      
      if (winner == UnitName("player")) and (f == true) then   
         local claimer = UnitName("player");
         local amount = GBH_HitList[i].amount      
         GBH_Msg("[GBH] Bounty claimed on "..loser.." {cross} "..GBL_CopperToGold(amount).." {circle}");         
         GBL_AddLargess(amount);
         GBH_HitList[i].state = "GBH_CLAIMED"
         GBH_HitList[i].claimer = winner; 
         if GBH_HitList[i].audit == nil then
            audit = 0
         else
            audit = GBH_HitList[i].audit
         end
         local id  = GBH_HitList[i].id
         local timestamp = time()
         local name = GBH_HitList[i].name
         local issuer = GBH_HitList[i].issuer         
         local msg = id..","..timestamp..","..name..","..issuer..","..amount..","..winner..","..GBH_HitList[i].state..","..audit;       
         GBH_HitListUpdate()
         ChatThrottleLib:SendAddonMessage("NORMAL","GBH_HL_UPDATE", msg, "GUILD");         
      end
   end
   
   --check for killing blow      
   if (event == "COMBAT_LOG_EVENT") and (arg2 == "PARTY_KILL" or arg2 == "UNIT_DIED") and (arg7 ~= UnitName("player")) then             
      local n1,n2,destName,destRealm = string.find(arg7,"(.+)-(.+)")
      if destName == nil then
         destName = arg7
         destRealm = GetRealmName()
      end     
      
      --GBH_LargessMessage(arg4.." has slain "..destName)    
 
      local audit
      local f, i = IsBountyOpen(destName)  
      
      --GBL_LargessMessage(arg2..": "..destName..":"..i..":"..GBH_HitList[i].state..":"..GBH_HitList[i].class)       
           
      if (i>0) and (GBH_HitList[i].state == "GBH_OPEN") then 
         if GBH_HitList[i].class == nil then
            if GBH_UnitType(arg6) == 4 then
               --just killed pet
               if GBH_HitList[i].class ~= destName then
                  return
               end
            end
         end 
     
         local claimer = UnitName("player");
         local amount = GBH_HitList[i].amount      
         GBH_Msg("[GBH] Bounty claimed on "..destName.." {cross} "..GBL_CopperToGold(amount).." {circle}");         
         GBL_AddLargess(amount);
         GBH_HitList[i].state = "GBH_CLAIMED"
         GBH_HitList[i].claimer = claimer; 
         local id  = GBH_HitList[i].id
         local timestamp = time()
         local name = GBH_HitList[i].name
         local issuer = GBH_HitList[i].issuer    
         if GBH_HitList[i].audit == nil then
            audit = 0
         else
            audit = GBH_HitList[i].audit
         end
         local msg = id..","..timestamp..","..name..","..issuer..","..amount..","..claimer..","..GBH_HitList[i].state..","..audit;       
         GBH_HitListUpdate()
         SendAddonMessage("GBH_HL_UPDATE", msg, "GUILD");         
      end
   end  
end

function GBH_UnitType(guid)  
   local B = tonumber(guid:sub(5,5), 16);
   local maskedB = B % 8; -- x % 8 has the same effect as x & 0x7 on numbers <= 0xf
   --local knownTypes = {[0]="player", [3]="NPC", [4]="pet", [5]="vehicle"};
   
   return maskedB
end

