if GBH_IntelFrame == nil then
   CreateFrame("Frame", "GBH_IntelFrame",UIParent);
   GBH_IntelFrame:SetScript("OnEvent", function() GBH_IntelOnEvent(event) end);    
   GBH_IntelFrame:RegisterEvent("WHO_LIST_UPDATE");   
end

function GBH_IntelOnEvent(event)
   if event == "WHO_LIST_UPDATE" then        
      local i,j
      local n = GetNumWhoResults()      
      local pname,prealm = UnitName("player")
      local name, guild, level, race, class, zone
      GBH_BountySpyCounter = GBH_BountySpyCounter + 1
      if n == 0 then
         GBL_LargessMessage(GBH_BountySpyNames[GBH_BountySpyCounter].name.." could not be found.")
      end
      for i = 1,n do
         name,guild,level,race,class,zone = GetWhoInfo(i)         
         GBL_LargessMessage("Found: "..name.." <"..guild.."> "..tostring(level).." "..race.." "..class.." "..zone)
         for j = 1, #GBH_IntelList do
            if GBH_IntelList[j].name == name then
               GBH_IntelList[j].level = tostring(level)
               GBH_IntelList[j].race = race
               GBH_IntelList[j].class = class
               GBH_IntelList[j].zone = zone
               GBH_IntelList[j].realm = prealm
               GBH_IntelList[j].intelage = time()
            end
         end
      end
      if GBH_BountySpyCounter >= GBH_BountySpyCnt then
         GBL_LargessMessage("All guild agents have reported in.")
         FriendsFrame:RegisterEvent("WHO_LIST_UPDATE")
      end
   end
end

function GBH_IntelPost()
   local i
   GBH_IntelList = {}
   for i = 1,#GBH_HitList do
      GBH_IntelList[i] = {}
      GBH_IntelList[i].id = GBH_HitList[i].id
      GBH_IntelList[i].faction = GBH_HitList[i].faction
      GBH_IntelList[i].realm = GBH_HitList[i].realm
      GBH_IntelList[i].name = GBH_HitList[i].name
      GBH_IntelList[i].state = GBH_HitList[i].state
      if GBH_HitList[i].intelage == nil or GBH_HitList[i].intelage == "" then
         GBH_HitList[i].intelage = 0
      end
      GBH_IntelList[i].intelage = GBH_HitList[i].intelage
   end
   GBL_LargessMessage("Requests for bounty intelligence have been posted.")
end

function GBH_IntelSpy()
   local i     
   GBH_BountySpyCnt = 0  
   GBH_BountySpyNames = {}
   GBH_BountySpyCounter = 0   
   for i = 1,#GBH_IntelList do
      if GBH_IntelList[i].faction == UnitFactionGroup("player") then           
         GBH_ActionQueueAdd([[GBH_SendWhoQuery(GBH_IntelList[]]..i..[[].name)]] , 5*(i-1))         
         GBH_BountySpyCnt = GBH_BountySpyCnt + 1
         table.insert(GBH_BountySpyNames,{name=GBH_IntelList[i].name})
      end
   end   
   GBL_LargessMessage("Searching for "..GBH_BountySpyCnt.." bounty targets...")  
end

function GBH_SendWhoQuery(name)
   SetWhoToUI(1)
   FriendsFrame:UnregisterEvent("WHO_LIST_UPDATE")
   SendWho(name)
end

function GBH_IntelReport()
   local i, j, msg
   for i = 1,#GBH_IntelList do
      if GBH_IntelList[i].intelage == nil or GBH_IntelList[i].intelage == "" then
         GBH_IntelList[i].intelage = 0
      end
      for j = 1,#GBH_HitList do         
         if GBH_HitList[j].intelage == nil or GBH_HitList[j].intelage == "" then
            GBH_HitList[j].intelage = 0
         end
         if (GBH_IntelList[i].name == GBH_HitList[j].name) --[[ and 
           (GBH_IntelList[i].intelage > GBH_HitList[j].intelage) ]] then
            GBH_HitList[j].zone = GBH_IntelList[i].zone
            GBH_HitList[j].level = GBH_IntelList[i].level
            GBH_HitList[j].race = GBH_IntelList[i].race
            GBH_HitList[j].class = GBH_IntelList[i].class  
            GBH_HitList[j].realm = GBH_IntelList[i].realm
            GBH_HitList[j].intelage = GBH_IntelList[i].intelage
            msg = GBH_BountyToString(j)
            ChatThrottleLib:SendAddonMessage("NORMAL","GBH_HL_UPDATE",msg,"GUILD");
         end       
      end
   end
   GBL_LargessMessage("Guild agents have reported back intelligence data.")
   GBH_FilterHitList()
   GBH_HitListUpdate()
end