function GBH_Init()
   --set version string
   GBH_VERSION = GetAddOnMetadata("GBH", "version")
   if GBH_HitList == nil then
      GBH_HitList = {}
   end
   if GBL_Largess == nil then
      GBL_Largess = 0
   end  
   if GBH_Config == nil then
      GBH_Config = {}
      GBH_Config["channel"] = "GUILD"
   end 
   
   GBH_CreateGUI()
   GBH_CreateFriendsTab()
   GuildRoster()
   GBH_ActionQueueInit()
   
   --get player faction and enemy faction
   GBH_PlayerFaction = UnitFactionGroup("player")
   if GBH_PlayerFaction == "Alliance" then
      GBH_EnemyFaction = "Horde"
   else
      GBH_EnemyFaction = "Alliance"
   end
   
   SLASH_GBH1 = "/gbh"
   SlashCmdList["GBH"] = GBH_Commands;
      
      StaticPopupDialogs["ADD_BOUNTY"] = {
      text = "Enter the bounty amount and target name:",
      button1 = "Place Bounty",
      button2 = "Cancel",     
      OnAccept = function (self, data, data2)
         local name = self.editBox:GetText()
         local money = MoneyInputFrame_GetCopper(self.moneyInputFrame)
         
         if GBL_Largess >= money then
            GBH_AddBounty(name, money)
         else
            GBL_LargessMessage("You do not have enough largess.","red")
            GBL_LargessMessage("Please deposit gold into the guild bank.","red")               
         end
         
      end,
      OnShow = function (self, data, data2)
         local name = UnitName("target")    
         local money = MoneyInputFrame_GetCopper(self.moneyInputFrame)       
         if name then self.editBox:SetText(name) end
         if name ~= "" and money > 0 then
            self.button1:Enable()
         else
            self.button1:Disable()
         end      
      end,   
      OnHide = function (self)
         --MoneyInputFrame_ResetMoney(self.moneyInputFrame)
      end,  
      EditBoxOnTextChanged = function (self)
         local parent = self:GetParent()
         local name = parent.editBox:GetText()      
         local money = MoneyInputFrame_GetCopper(parent.moneyInputFrame)    
         if name ~= "" and money > 0 then
            parent.button1:Enable()
         else
            parent.button1:Disable()
         end 
      end,  
      OnUpdate = function(self, elapsed)
         local name = self.editBox:GetText()    
         local money = MoneyInputFrame_GetCopper(self.moneyInputFrame)       
         
         if name ~= "" and money > 0 then
            self.button1:Enable()
         else
            self.button1:Disable()
         end      
      end,
      
      hasMoneyInputFrame = true,
      hasEditBox = true,     
      timeout = 0,
      whileDead = true,
      hideOnEscape = true   
   }
   
   --SendAddonMessage("GBH_HL_SYNC_REQ",nil,"GUILD");

end  
