GBH_NUM_HITLIST_ENTRIES = 14
GBH_SelectedBounty = -1

function GBH_EntryOnClick(self)   
   local i = self.index
   local issuer = GBH_HitListFiltered[i].issuer
   local claimer = GBH_HitListFiltered[i].claimer
   local realm = GBH_HitListFiltered[i].realm
   local level = GBH_HitListFiltered[i].level
   local class = GBH_HitListFiltered[i].class
   local race = GBH_HitListFiltered[i].race
   local zone = GBH_HitListFiltered[i].zone
   local xcoord = GBH_HitListFiltered[i].xcoord
   local ycoord = GBH_HitListFiltered[i].ycoord
   local intelage = GBH_HitListFiltered[i].intelage
   local age
   
   if faction == nil then
      faction = "UKNOWN"
   end
   if realm == nil then
      realm = GetRealmName()
   end
   if zone == nil then
      zone = ""
   end   
   if xcoord == nil then
      xcoord = 0
   end
   if ycoord == nil then
      ycoord = 0
   end
   if intelage == nil then
      intelage = 0
   end
   if class == nil then
      class = ""
   end
   if race == nil then
      race = ""
   end
   if level == nil then
      level = ""
   end   
   
   --GBH_LargessMessage("Clicked Bounty ID:"..GBH_HitListFiltered[i].id)
   GBH_BountyDetails_issuer:SetText(issuer)
   GBH_BountyDetails_claimer:SetText(claimer)
   GBH_BountyDetails_realm:SetText(realm)
   GBH_BountyDetails_class:SetText(level.." "..race.." "..class)
   if zone == nil or zone == "" then
      GBH_BountyDetails_zone:SetText("")
   else
      --GBH_BountyDetails_zone:SetText(zone.." ("..xcoord..","..ycoord..")")
      GBH_BountyDetails_zone:SetText(zone)
   end   
   if intelage > 0 then
      age = SecondsToTime(time()-intelage)
      GBH_BountyDetails_intelage:SetText(age.." ago")
   else
      GBH_BountyDetails_intelage:SetText("")
   end
   
   GBH_SelectedBounty = i
   GBH_SelectedBountyId = GBH_HitListFiltered[i].id
   GBH_HitListUpdate()
end   

function GBH_CreateGUI()
   local i,frame,textString,moneyFrame   
   
   --GBH_UIFrame:SetScript("OnShow",GBH_UIShow)   
   GBH_ListFrame:EnableMouse()
   GBH_ListFrame:EnableMouseWheel(1)   
   GBH_ListFrame:SetScript("OnShow",GBH_HitListUpdate) 
   GBH_ListFrame:Show()   
   MoneyFrame_Update(GBH_LargessAmountFrame, GBL_Largess); 
   
   --List Entry Frames (faux scroll frames)
   for i = 0,GBH_NUM_HITLIST_ENTRIES-1 do       
      frame = CreateFrame("Button","GBH_ListEntry"..i,GBH_ListFrame,"GBH_EntryTemplate")
      frame:SetPoint("TOPLEFT",0,-i*17)
      frame:Show() 
   end 
   GBH_ListEntryNormalTexture = frame:GetNormalTexture()
end

function GBH_HitListUpdate()
   local i,dataOffset,offset,n,m
   local moneyFrame,textString,entryFrame,statusFrameTexture,factionTexture  
   
   GBH_FilterHitList()
   n = #GBH_HitListFiltered     
   FauxScrollFrame_Update(GBH_ListFrame,n,GBH_NUM_HITLIST_ENTRIES,17,nil,nil,nil,nil,nil,nil,true);
   offset = FauxScrollFrame_GetOffset(GBH_ListFrame);
   
   for i = 0,GBH_NUM_HITLIST_ENTRIES-1 do
      dataOffset = offset + i + 1      
      textString = getglobal("GBH_ListEntry"..i.."_TargetName")
      moneyFrame = getglobal("GBH_ListEntry"..i.."_BountyAmount")
      statusFrameTexture = getglobal("GBH_ListEntry"..i.."_BountyStatusTexture")
      factionTexture = getglobal("GBH_ListEntry"..i.."_TargetFactionTexture")
      entryFrame = getglobal("GBH_ListEntry"..i)      
      if dataOffset <= n then         
         --set faction image
         if (GBH_HitListFiltered[dataOffset].faction) == "UNKNOWN" then
            --factionTexture:SetTexture("interface\\gossipframe\\activequesticon")
            factionTexture:Hide()
            --factionTexture:Show()
         elseif (GBH_HitListFiltered[dataOffset].faction) == "Horde" then
            factionTexture:SetTexture("interface\\targetingframe\\ui-pvp-horde.blp")
            factionTexture:Show()
         elseif (GBH_HitListFiltered[dataOffset].faction) == "Alliance" then
            factionTexture:SetTexture("interface\\targetingframe\\ui-pvp-alliance.blp")
            factionTexture:Show()
         else
            factionTexture:Hide()
         end
         --set status image
         if (GBH_HitListFiltered[dataOffset].state == "GBH_OPEN") then
            statusFrameTexture:SetTexture("interface\\targetingframe\\ui-targetingframe-skull.blp")
         elseif (GBH_HitListFiltered[dataOffset].state == "GBH_CLAIMED") then
            statusFrameTexture:SetTexture("interface\\common\\voicechat-muted.blp")
         end
         --set bounty money
         MoneyFrame_Update(moneyFrame, GBH_HitListFiltered[dataOffset].amount);
         --set target name
         textString:SetText(GBH_HitListFiltered[dataOffset].name)
         entryFrame.index = dataOffset
         if GBH_SelectedBounty == dataOffset then
            --set selected texture            
            entryFrame:LockHighlight()
         else
             --reset normal texture
            entryFrame:UnlockHighlight()
         end        
         entryFrame:Show()         
      else
         entryFrame:Hide()                
      end        
   end    
end

function GBH_CreateFriendsTab()   
   FriendsFrameTab6 = CreateFrame("Button", "FriendsFrameTab" ..6, FriendsFrame, "FriendsFrameTabTemplate");
   FriendsFrameTab6:SetPoint("LEFT", "FriendsFrameTab" .. 5, "RIGHT", -14, 0);
   FriendsFrameTab6:SetID(6);
   PanelTemplates_SetNumTabs(FriendsFrame, 6);
   PanelTemplates_UpdateTabs(FriendsFrame);
   FriendsFrameTab6:SetPoint("LEFT", "FriendsFrameTab" .. 5, "RIGHT", -14, 0);
   FriendsFrameTab6:SetText("GBH")
   TabID = 6

   -- add ourself to the subframe list....
   tinsert(FRIENDSFRAME_SUBFRAMES, "GBH_UIFrame");

   hooksecurefunc("FriendsFrame_Update", GBH_FriendsFrame_Update);
end

function GBH_FriendsFrame_Update()
   if(FriendsFrame.selectedTab == 6) then
      FriendsFrameTitleText:SetText("Guild Bounty Hunter");
      if(GBH_UIFrame:IsVisible()) then
         return;
      end
      FriendsFrameTopLeft:SetTexture("Interface\\ClassTrainerFrame\\UI-ClassTrainer-TopLeft");
      FriendsFrameTopRight:SetTexture("Interface\\ClassTrainerFrame\\UI-ClassTrainer-TopRight");
      FriendsFrameBottomLeft:SetTexture("Interface\\FriendsFrame\\GuildFrame-BotLeft");      
      FriendsFrameBottomRight:SetTexture("Interface\\FriendsFrame\\GuildFrame-BotRight");
      
      --GBH_UIFrame:ScrollFrameUpdate();
      GBH_UIFrame:SetParent("FriendsFrame");
      GBH_UIFrame:SetAllPoints();
      GBH_UIFrame:Show();
      
      FriendsFrame_ShowSubFrame("NonExistingFrame"); -- so all friendframe tabs get hidden  
      FriendsFrame_ShowSubFrame("GBH_UIFrame")
   end
end

function GBH_DelayScript(script,delay,id)   
   if id == nil then
      id = "GBH_TimerFrame"
   else
      id = "GBH_TimerFrame"..id
   end
   local f = CreateFrame("Frame",id,UIParent)
   local stop = time() + delay
   f:SetScript("OnUpdate",function() GBH_TimerUpdate(stop,f,script) end)   
end

function GBH_TimerUpdate(stop,self,script)   
   local t = time()    
   if t >= stop then       
      self:SetScript("OnUpdate",nil)
      RunScript(script)
   end   
end

function GBH_SortByName(a,b)    
   if GBH_NAME_SORT then      
      return a.name > b.name
   else      
      return a.name < b.name
   end
end
   
function GBH_SortByAmount(a,b)   
   if GBH_AMOUNT_SORT then
      return tonumber(a.amount) > tonumber(b.amount)   
   else
      return tonumber(a.amount) < tonumber(b.amount) 
   end
end

function GBH_SortByFaction(a,b)
   if a.faction == nil or a.faction == "NPC" then
      return false
   elseif b.faction == nil or b.faction == "NPC" then
      return true
   elseif GBH_FACTION_SORT then
      return a.faction > b.faction
   else
      return a.faction < b.faction
   end
end

function GBH_SortByState(a,b)
   if GBH_STATE_SORT then
      return a.state > b.state
   else
      return a.state < b.state
   end
end

function GBH_FilterHitList()
   local i,name,amount,id,issuer,timestamp,state,claimer,audit,faction,realm,zone,xcoord,ycoord,intelage,class,race,level
   local n = #GBH_HitList
   GBH_HitListFiltered = {}
   
   for i = 1,n do
      name = GBH_HitList[i].name
      amount = GBH_HitList[i].amount   
      id = GBH_HitList[i].id      
      issuer = GBH_HitList[i].issuer
      timestamp = GBH_HitList[i].timestamp
      state = GBH_HitList[i].state
      claimer = GBH_HitList[i].claimer  
      audit = GBH_HitList[i].audit
      faction = GBH_HitList[i].faction
      realm = GBH_HitList[i].realm
      zone = GBH_HitList[i].zone
      xcoord = GBH_HitList[i].xcoord
      ycoord = GBH_HitList[i].ycoord
      intelage = GBH_HitList[i].intelage
      class = GBH_HitList[i].class
      race = GBH_HitList[i].race
      level = GBH_HitList[i].level
      
      if (not GBH_FilterFormCheckShowHorde:GetChecked() and faction == "Horde") or
         (not GBH_FilterFormCheckShowAlliance:GetChecked() and faction == "Alliance") or
         (not GBH_FilterFormCheckShowOpen:GetChecked() and state == "GBH_OPEN") or 
         (not GBH_FilterFormCheckShowClaimed:GetChecked() and state == "GBH_CLAIMED") or
         (state == "GBH_DEL") then   
         --do nothing, could this logic be better? seriously
      else
         table.insert(GBH_HitListFiltered,{id=id,name=name,amount=amount,issuer=issuer,timestamp=timestamp,state=state,claimer=claimer,audit=audit,faction=faction,realm=realm,zone=zone,xcoord=xcoord,ycoord=ycoord,intelage=intelage,class=class,race=race,level=level});
      end 
   end
end

   