function GBH_Commands(args)  
   local s,e,cmd,arg1,arg2,arg3 = string.find(args,"(%a*)%s?([.?%a%d]*)%s?([.?%a%d]*)%s?([.?%a%d-?]*)")    
   
   --debug
   if cmd == "debug" then
      if arg1 == "on" then
         GBH_Config["debug"] = true
      elseif arg1 == "off" then
         GBH_Config["debug"] = false
      end
      
   --set default channel
   elseif cmd == "channel" then 
      if arg1 == "guild" then
         GBH_Config["channel"] = "GUILD"
      elseif arg1 == "party" then
         GBH_Config["channel"] = "PARTY"
      elseif arg1 == "officer" then
         GBH_Config["channel"] = "OFFICER"
      elseif arg1 == "private" then
         GBH_Config["channel"] = "PRIVATE"
      end
      
   --list hit list
   elseif cmd == "list" then
      GBH_DisplayList() 
      
   --set guild bank largess cut
   elseif cmd == "cut" then
      GBL_SetGBCut(arg1)
   --place a bounty
   
   elseif cmd == "bounty" then
      if arg1 == nil then
         GBH_BuyBounty() 
      elseif arg1 == "bg" then
         GBH_AddBGBounties(tonumber(arg2))
      else    
         GBH_AddBounty(UnitName("target"),arg1)
      end
      
   --resync hit list
   elseif cmd == "sync" then
      SendAddonMessage("GBH_HL_SYNC_REQ", nil, "GUILD");   
      
   --clear hit list
   elseif cmd == "clear" then
      if arg1 == "all" then  
         if GBH_GetAdminLevel() >= 2 then
            SendAddonMessage("GBH_HL_CLEAR", nil, "GUILD");
         else
            GBL_LargessMessage("You don't have permission to clear the list.")
         end 
      elseif arg1 == "" then
         GBH_HitList = {}
      end   
      
   --largess commands
   elseif cmd == "largess" then
      if arg1 == "" then
         GBL_LargessMessage("Your current guild Largess is "..GBH_CopperToGold(GBL_Largess))
      elseif arg1 == "report" then
         GBL_GuildLargessReport()
      elseif arg1 == "set" then
         GBL_SetLargess(arg2,arg3)
      elseif arg1 == "mod" then
         GBL_ModLargess(arg2,arg3)
      end   
      
   --audit commands
   elseif cmd == "audit" then
      if arg1 == "reset" then
         --GBH_AuditData = nil
      elseif arg1 == "print" then
         --GBH_AuditPrint()
      elseif arg1 == "" then 
         GBL_AuditPrep()         
      --GBH_DoAudit()
      elseif arg1 == "init" then
         --GBH_AuditInit()
      elseif arg1 == "load" then
         --GBH_AuditLoad()
      elseif arg1 == "save" then
         --GBH_AuditSave()
      elseif arg1 == "bounties" then
         GBL_AuditInit()
         GBL_AuditLoad()
         GBH_AuditBounties()
         GBL_AuditSave()
      end      
   
   --intel commands
   elseif cmd == "intel" then
      if arg1 == "post" then
         GBH_IntelPost()
      elseif arg1 == "spy" then
         GBH_IntelSpy()
      elseif arg1 == "report" then
         GBH_IntelReport()     
      end   
   
   --version
   elseif cmd == "version" then
      GBL_LargessMessage("Guild Bounty Hunter v"..GBH_VERSION);
         
   --help
   elseif cmd == "help" then
      GBH_Help(arg1)    
   else 
      GBH_Help()
   end
end

function GBH_GetAdminLevel()
   if CanEditOfficerNote() and CanEditGuildInfo() then
      return GBH_SUPER_ADMIN
   elseif CanEditOfficerNote() then
      return GBH_ADMIN
   else
      return GBH_USER
   end   
end

function GBH_BuyBounty()
   local dialog = StaticPopup_Show("ADD_BOUNTY")    
   if (dialog) then
      dialog.data  = varName     
      dialog.data2 = varName2
   end  
   local text = getglobal(dialog:GetName().."Text");
   local editBox = getglobal(dialog:GetName().."EditBox");
   local button1 = getglobal(dialog:GetName().."Button1");  
   local moneyInputFrame = getglobal(dialog:GetName().."MoneyInputFrame");
   dialog:SetHeight(16 + text:GetHeight() + 8 + editBox:GetHeight() + 8 + button1:GetHeight() + 8 + moneyInputFrame:GetHeight() + 8);   
end

function GBH_Purge()
   local i,n
   i = 1
   n = #GBH_HitList
   while (i <= n) do      
      if GBH_HitList[i].audit == 2 and (((GBH_HitList[i].state == "GBH_CLAIMED") and (time() - GBH_HitList[i].timestamp) > GBH_PURGE_AGE_CLAIMED)) or
         (GBH_HitList[i].state == "GBH_DEL" and (time() - GBH_HitList[i].timestamp) > GBH_PURGE_AGE_DEL) then
         table.remove(GBH_HitList,i)
         n = n - 1
         i = i - 1
      end
      i = i + 1
   end
   GBH_HitListUpdate()
end
