GBH_SEC_PER_HR = 3600
GBH_SEC_PER_DAY = 24*GBH_SEC_PER_HR
GBH_SEC_PER_MO = 30.41*GBH_SEC_PER_DAY
GBH_SEC_PER_YR = 12*GBH_SEC_PER_MO
GBH_DO_AUDIT = false
GBH_ROSTER_UPDATED = false
GBH_BANKLOG_UPDATED = false
GBH_AuditData = {}
GBH_GuildMates = {}
GBH_SUPER_ADMIN = 2
GBH_ADMIN = 1
GBH_USER = 0
GBH_PURGE_AGE_CLAIMED = GBH_SEC_PER_MO --prune the hit list age
GBH_PURGE_AGE_DEL = GBH_SEC_PER_DAY*7 --prune the hit list age

function GBH_DoAudit()   
   GBH_AuditInit() 
   GBH_AuditLoad()   
   GBH_AuditBank()
   GBH_AuditBounties()
   GBH_AuditSave()   
   GBH_DO_AUDIT = false
   GBH_ROSTER_UPDATED = false
   GBH_BANKLOG_UPDATED = false
   GBH_LargessMessage("Audit complete.")
end	

function GBH_AuditInit()    
   GBH_AuditData = {}
   GBH_AuditData["last"] = {}
   GBH_AuditData["last"].t0 = ""
   GBH_AuditData["last"].n0 = ""
   GBH_AuditData["last"].a0 = 0
   GBH_AuditData["last"].y0 = 0
   GBH_AuditData["last"].m0 = 0
   GBH_AuditData["last"].d0 = 0
   GBH_AuditData["last"].h0 = 0
   GBH_AuditData["last"].c0 = 0
   GBH_AuditData["last"].ts0 = 0     
   
   local i,name
   local gnum = #GBH_GuildMates
   
   for i = 1,gnum do
      name = GBH_GuildMates[i].name     
      GBH_AuditData[name] = {}      
      GBH_AuditData[name].largess = 0   
      gbh_msg("AuditInit: "..name.." "..GBH_AuditData[name].largess)
   end   
end

function GBH_AuditBank()
   if not CanEditGuildInfo() then
      GBH_LargessMessage("You do not have permission to audit the guild bank.")
      return
   end
   
   local typ, name, amount, y, m, d, h
	local num = GetNumGuildBankMoneyTransactions()
	local i,ts,allnew,lasttrans
   local nonew = true
   
   GBH_LoadLastAudit()   
   if GBH_AuditData["last"].t0 == "" then 
      gbh_msg("t0: "..GBH_AuditData["last"].t0,"red")
      -- if we don't have a last audit, they're all new
      allnew = true
   else
      -- we've got audit data, let's use it
      allnew = false
   end   
	for i = 1,num do    
      lasttrans = GBH_IsTransactionNew(i)
		if allnew or lasttrans==true then		         
         typ, name, amount, y, m, d, h = GetGuildBankMoneyTransaction(i)  
         if not (name == nil) then  --ignore nil transactions
            nonew = false
            gbh_msg("New:"..i..":"..typ..":"..name..":"..amount)     
            if typ == "deposit" then
               GBH_LargessMessage("New Transaction: "..name..":"..typ..":"..amount..":"..d..":"..h)
               local gbcut = GBH_GetGBCut()
               GBH_AuditData[name].largess = GBH_AuditData[name].largess + amount-floor(gbcut*amount)
            elseif typ == "withdraw" or typ == "repair" then
               GBH_LargessMessage("New Transaction: "..name..":"..typ..":"..amount..":"..d..":"..h, "red")
               GBH_AuditData[name].largess = GBH_AuditData[name].largess - tonumber(amount)
            end     
            GBH_UpdateLastTransaction(i)  
         end
		else 
         if lasttrans == 2 then
            allnew = true
         end         
         gbh_msg("Old:"..i)
      end
	end  
   if nonew then
      GBH_LargessMessage("No new guild bank transactions.")
   end      
   GBH_SaveLastAudit()
   GBH_DO_AUDIT = false
   GBH_ROSTER_UPDATED = false
   GBH_BANKLOG_UPDATED = false
end

function GBH_AuditBounties()
   if not CanEditOfficerNote() then
      GBL_LargessMessage("You do not have permission to audit bounties.")
      return
   end
   
   GBL_AuditInit() 
   GBL_AuditLoad()   
      
   local n = #GBH_HitList
   local i,issuer,claimer,state,amount
   local nonew = true
   
   for i = 1,n do
      amount = GBH_HitList[i].amount
      issuer = GBH_HitList[i].issuer
      claimer = GBH_HitList[i].claimer
      state = GBH_HitList[i].state
      if GetGuildInfo(issuer) ~= GetGuildInfo("player") then
         GBH_HitList[i].state = "GBH_DEL"
         GBH_HitList[i].audit = 2         
      end
      if GBH_HitList[i].audit == nil then
         GBH_HitList[i].audit = 0
      end
      if tonumber(GBH_HitList[i].audit) == 0 then         
         GBL_AuditData[issuer].largess = GBL_AuditData[issuer].largess - amount
         GBL_LargessMessage(issuer.." placed a bounty for "..amount,"red")
         GBH_HitList[i].audit = 1
         nonew = false
         if state == "GBH_CLAIMED" then
            GBL_AuditData[claimer].largess = GBL_AuditData[claimer].largess + amount
            GBL_LargessMessage(claimer.." has claimed a bounty for "..amount)
            GBH_HitList[i].audit = 2
            nonew = false
         end      
      elseif tonumber(GBH_HitList[i].audit) == 1 and state == "GBH_CLAIMED" then
         GBL_AuditData[claimer].largess = GBL_AuditData[claimer].largess + amount
         GBL_LargessMessage(claimer.." has claimed a bounty for "..amount)
         GBH_HitList[i].audit = 2
         nonew = false
      end   
   end
   if nonew then
      GBL_LargessMessage("No new bounties.")
   end
   
   GBL_AuditSave()
   
end

function GBH_GetTransactionTimeStamp(y,m,d,h)
   local t = time()
   t = t-y*GBH_SEC_PER_YR-m*GBH_SEC_PER_MO-d*GBH_SEC_PER_DAY-h*GBH_SEC_PER_HR
   return t
end

function GBH_AuditLoad()
   local gnum = #GBH_GuildMates
   local name,note
   local i,name,s,e,sign,largess
   
   for i = 1,gnum do      
      name = GBH_GuildMates[i].name
      note = GBH_GuildMates[i].note
      s,e,largess = string.find(note,"::GBH:L(.?%d*)::")
      
      if largess == nil then
         largess = 0
      end      
      GBH_AuditData[name].largess = tonumber(largess)           
   end
   gbh_msg("Largess loaded from officer notes.")
end

function GBH_AuditSave()
   local gnum = #GBH_GuildMates
   local name,note
   local i,s,e,largess
   local gl,n
   
   gbh_msg("AuditSave gnum: "..gnum)
   
   for i = 1,gnum do         
      name = GBH_GuildMates[i].name
      note = GBH_GuildMates[i].note
      gbh_msg("AuditSave: "..name.." Note: "..note)
      largess = GBH_AuditData[name].largess            
      if note == nil then
         note = "::GBH:L"..largess.."::"
      else
         gl,n = string.gsub(note,"::GBH:L.?%d*::","::GBH:L"..largess.."::")  
         if n == 1 then
            GuildRosterSetOfficerNote(i,gl)
         else
            GuildRosterSetOfficerNote(i,note.."::GBH:L"..largess.."::")
         end
      end      
   end
   gbh_msg("Largess saved to officer notes.")
end

function GBH_AuditPrint()
   local gnum = #GBH_GuildMates
   local i,name

   for i = 1,gnum do
      name = GBH_GuildMates[i].name      
      if GBH_AuditData[name].largess < 0 then
         GBH_LargessMessage(name..":"..GBH_AuditData[name].largess,"red")
      else 
         GBH_LargessMessage(name..":"..GBH_AuditData[name].largess)
      end     
   end
end

--this works fine, but could be simpler
--need to guarante guild info text is latest
function GBH_IsTransactionNew(i)
   --should change this function name to 
   --GBH_IsTranscationLastAudit
	local t0 = GBH_AuditData["last"].t0
	local n0 = GBH_AuditData["last"].n0
	local a0 = GBH_AuditData["last"].a0
	local y0 = GBH_AuditData["last"].y0
	local m0 = GBH_AuditData["last"].m0
	local d0 = GBH_AuditData["last"].d0
	local h0 = GBH_AuditData["last"].h0	
	local c0 = GBH_AuditData["last"].c0
	local ts0 = GBH_AuditData["last"].ts0
	local ti,ni,ai,yi,mi,di,hi = GetGuildBankMoneyTransaction(i)
   if ni == nil then
      return true
   end
   --local ts0 = GBH_GetTransactionTimeStamp(y0,m0,d0,h0)
   local tsi = GBH_GetTransactionTimeStamp(yi,mi,di,hi)
   local ci   
   
   gbh_msg("IsNew?:"..i..":"..tsi..":"..ts0..":"..ni..":"..ai..":"..ti)
   if t0 == "" then return true end
   --upper bounds of temporal certaintly (definately new)
   if tsi > (ts0 + 3600) then
      gbh_msg("state1")
      return true
   end
   --lower bounds of temporal certainty (definately old)
   if tsi < (ts0 -3600) then
       gbh_msg("state 2")
      return false
   end
   
   --we couldn't tell by our timestamp alone
   --check other transaction parameters
	if not (ni == n0) then
      gbh_msg("state3")
      return false
   end
	if not (ti == t0) then 
      gbh_msg("state4:"..ti.."~="..t0)
      return false
   end
	if not (ai == a0) then 
     gbh_msg("state5:"..ai..":"..a0)
      return false 
   end
   
   -- transactioni == transaction0 at this point
   -- could we have reached the last saved transaction?
   -- how many have we had within the zone of temporal uncertainty?
   ci = GBH_CntSimTrans(i)     
   
   if ci == c0 then
      --this is the last audit transaction
      return 2
   end
   
   if ci > c0 then 
      --looks like we've got a new one, this means the rest must be new too      
		GBH_AuditData["last"].c0 = c0 + 1
      gbh_msg("state6:ci: "..ci.." c0: "..c0)
		return true
	else 
      gbh_msg("state7")
		return false 
	end 
end

function GBH_UpdateLastTransaction(i)
	local ti,ni,ai,yi,mi,di,hi = GetGuildBankMoneyTransaction(i)
   if ni == nil then
      return
   end
	local tsi = GBH_GetTransactionTimeStamp(yi,mi,di,hi)
	
	GBH_AuditData["last"].t0 = ti
	GBH_AuditData["last"].n0 = ni
	GBH_AuditData["last"].a0 = ai
	GBH_AuditData["last"].y0 = yi
	GBH_AuditData["last"].m0 = mi
	GBH_AuditData["last"].d0 = di
	GBH_AuditData["last"].h0 = hi
   GBH_AuditData["last"].c0 = GBH_CntSimTrans(i)
   GBH_AuditData["last"].ts0 = tsi
   
end

function GBH_CntSimTrans(i)
	local j
	local c = 0
	local ti,ni,ai,yi,mi,di,hi = GetGuildBankMoneyTransaction(i)
   if ni == nil then
      return 0
   end
	local tj,nj,aj,yj,mj,dj,hj
   local si,sj 
   
	for j = 1,i-1 do      
		tj,nj,aj,yj,mj,dj,hj = GetGuildBankMoneyTransaction(j)
      if not (nj == nil) then
         si = ti..ni..ai..yi..mi..di..hi 
         sj = tj..nj..aj..yj..mj..dj..hj
         if ( si == sj ) then
            c = c + 1
         end
      end
	end	
   gbh_msg("GBH_CntSimTrans: "..c)
	return c
end

function GBH_LoadLastAudit()     
   if GBH_GuildInfoText == "" then
      gbh_msg("GInfo empty")
      --condense this logic plz
      GBH_AuditData["last"] = {}
      GBH_AuditData["last"].t0 = ""
      GBH_AuditData["last"].n0 = ""
      GBH_AuditData["last"].a0 = 0
      GBH_AuditData["last"].y0 = 0
      GBH_AuditData["last"].m0 = 0
      GBH_AuditData["last"].d0 = 0
      GBH_AuditData["last"].h0 = 0
      GBH_AuditData["last"].c0 = 0
      GBH_AuditData["last"].ts0 = 0       
      return
   end
      
   local s,e,t0,n0,a0,y0,m0,d0,h0,c0,ts0 = string.find(GBH_GuildInfoText,"::GBH:C.+:t0(.+):n0(.+):a0(.+):y0(.+):m0(.+):d0(.+):h0(.+):c0(.+):ts0(.+)::")
   
   if not (s == nil) then
      gbh_msg("Loading last audit "..string.sub(GBH_GuildInfoText,s,e))
   end
   
   if t0 then  
      gbh_msg("t0 exists")
      --GBH_AuditData = {}
      GBH_AuditData["last"] = {}
      GBH_AuditData["last"].t0 = t0
      GBH_AuditData["last"].n0 = n0
      GBH_AuditData["last"].a0 = tonumber(a0)
      GBH_AuditData["last"].y0 = tonumber(y0)
      GBH_AuditData["last"].m0 = tonumber(m0)
      GBH_AuditData["last"].d0 = tonumber(d0)
      GBH_AuditData["last"].h0 = tonumber(h0)
      GBH_AuditData["last"].c0 = tonumber(c0)
      GBH_AuditData["last"].ts0 = tonumber(ts0)      
   else
      gbh_msg("t0 is nil")
      --GBH_AuditData = {}
      --with this redundant logic
      GBH_AuditData["last"] = {}
      GBH_AuditData["last"].t0 = ""
      GBH_AuditData["last"].n0 = ""
      GBH_AuditData["last"].a0 = 0
      GBH_AuditData["last"].y0 = 0
      GBH_AuditData["last"].m0 = 0
      GBH_AuditData["last"].d0 = 0
      GBH_AuditData["last"].h0 = 0
      GBH_AuditData["last"].c0 = 0
      GBH_AuditData["last"].ts0 = 0       
   end
   gbh_msg("LoadLastAudit:t0:"..GBH_AuditData["last"].t0..":n0"..GBH_AuditData["last"].n0..":a0"..GBH_AuditData["last"].a0)
end

function GBH_SaveLastAudit()
   if not CanEditGuildInfo() then
      GBH_LargessMessage("You need permission to edit guild info.")
      return
   end
   local s,e,t0,n0,a0,y0,m0,d0,h0,c0,ts0,cut,ginfo
   t0 = GBH_AuditData["last"].t0
   n0 = GBH_AuditData["last"].n0
   a0 = GBH_AuditData["last"].a0
   y0 = GBH_AuditData["last"].y0
   m0 = GBH_AuditData["last"].m0
   d0 = GBH_AuditData["last"].d0
   h0 = GBH_AuditData["last"].h0
   c0 = GBH_AuditData["last"].c0
   ts0 = GBH_AuditData["last"].ts0     
   cut = GBH_GetGBCut()
   
   local ginfo,n = string.gsub(GBH_GuildInfoText,"::GBH:C.?%d*:t0%a*:n0%a*:a0%d*:y0%d*:m0%d*:d0%d*:h0%d*:c0%d*:ts0%d*::","::GBH:C"..cut..":t0"..t0..":n0"..n0..":a0"..a0..":y0"..y0..":m0"..m0..":d0"..d0..":h0"..h0..":c0"..c0..":ts0"..ts0.."::")  
   if n == 1 then  
      --found audit string in guild info
      GBH_GuildInfoText = ginfo          
   else    
      --did not find audit string, so add it
      GBH_GuildInfoText = ginfo.."::GBH:C"..cut..":t0"..t0..":n0"..n0..":a0"..a0..":y0"..y0..":m0"..m0..":d0"..d0..":h0"..h0..":c0"..c0..":ts0"..ts0.."::"      
   end    
   SetGuildInfoText(GBH_GuildInfoText)
   GuildRoster()
   gbh_msg("SaveLastAudit: " ..GBH_GuildInfoText)
end
