 function GBH_AddBounty(name,amount,faction,realm,zone,class)   
   
   if GBH_HitList == nil then 
      GBH_HitList={};
   end
   
   if name == nil then
      return
   end    
      
   local player = UnitName("player")
   local timestamp = time()
   local timeID = timestamp - 1200000000
   local id = player.."_"..timeID
   local state = "GBH_OPEN"
   local claimer = ""
   local issuer = player
   local xcoord,ycoord,intelage
   local audit = 0
   local gsc;
   
   --handle cross realm names
   local n1,n2,destName,destRealm = string.find(name,"(.+)-(.+)")
   if destName == nil then
      destName = name
      destRealm = GetRealmName()
   end 
   
   if UnitName("target") == destName then
      faction = UnitFactionGroup("target")
      name,realm = UnitName("target")
      level = UnitLevel("target")
      race = UnitRace("target")
      class = UnitClass("target")    
      zone = GetRealZoneText("player")
      xcoord,ycoord = GetPlayerMapPosition("player");
      xcoord = floor(xcoord*100)
      ycoord = floor(ycoord*100)
      intelage = time()
   else
      if faction == nil then
         faction = UnitFactionGroup(name)      
      end
   end   
   if faction == nil then
      faction = "UNKNOWN"
   end
   if realm == nil then
      realm = GetRealmName()
   end
   if zone == nil then
      zone = ""
   end   
   if xcoord == nil then
      xcoord = 0
   end
   if ycoord == nil then
      ycoord = 0
   end
   if intelage == nil then
      intelage = 0
   end
   if class == nil then
      class = ""
   end
   if race == nil then
      race = ""
   end
   if level == nil then
      level = ""
   end
   gsc = GBL_CopperToGold(amount);   
   GBH_Msg("[GBH] Bounty placed on "..name.." {skull} "..GBL_CopperToGold(amount).." {circle}")   
   GBL_SubLargess(amount)
   local msg = id..","..timestamp..","..name..","..issuer..","..amount..","..claimer..","..state..","..audit..","..faction..","..realm..","..zone..","..xcoord..","..ycoord..","..intelage..","..class..","..race..","..level
   table.insert(GBH_HitList,{id=id,name=name,amount=amount,issuer=player,timestamp=timestamp,state="GBH_OPEN",claimer="",audit=audit,faction=faction,realm=realm,zone=zone,xcoord=xcoord,ycoord=ycoord,intelage=intelage,class=class,race=race,level=level});   
   --local msg = id..","..timestamp..","..name..","..issuer..","..amount..","..claimer..","..state..","..audit..","..faction..","..realm..","..zone..","..xcoord..","..ycoord..","..intelage
   GBH_HitListUpdate()
   SendAddonMessage("GBH_HL_UPDATE", msg, "GUILD");   
end

function GBH_DeleteBounty()
   local id = GBH_SelectedBountyId
   local i
   
   if GBH_GetAdminLevel() < GBH_ADMIN then 
      GBH_LargessMessage("You do not have permission to delete this bounty.")
      return 
   end
   
   for i = 1,#GBH_HitList do
      if GBH_HitList[i].id == id then
         GBH_HitList[i].state = "GBH_DEL"
         GBH_HitList[i].timestamp = time()
         GBH_HitListUpdate()
         local msg = GBH_BountyToString(i)
         SendAddonMessage("GBH_HL_UPDATE", msg, "GUILD");   
         return  --assumes unique ids
      end
   end  
 end
 
function GBH_AddBGBounties(amount)
   local n = GetNumBattlefieldScores()
   local i,name, killingBlows, honorableKills, deaths, honorGained, faction, rank, race, classToken, damageDone, healingDone 

   for i = 1,n do
      name,killingBlows,honorableKills,deaths,honorGained,faction, rank, race, classToken, damageDone, healingDone = GetBattlefieldScore(i)
      if (faction == 0 and GBH_PlayerFaction == "Alliance") or (faction == 1 and GBH_PlayerFaction == "Horde") then
         --handle cross realm names
         local n1,n2,destName,destRealm = string.find(name,"(.+)-(.+)")
         if destName == nil then
            destName = name
            destRealm = GetRealmName()
         end 
         
         GBH_AddBounty(destName,amount,GBH_EnemyFaction,destRealm,GetRealZoneText("player"),classToken)      
      end
   end
end