
--[[ 	RC catagories:
Expression
Random expression
Script
Letter / Book
Buff
Sound
Equip item
Bag
GHR
Requirement


todo:
Create other item
key
remove buff

]]


GHI_RCIcons = {};
GHI_RCIcons["script"] = "Interface\\Icons\\Trade_Engineering";
GHI_RCIcons["expression"] = "Interface\\Icons\\Spell_Shadow_SoothingKiss";
GHI_RCIcons["random_expression"] = "Interface\\Icons\\Ability_Warrior_RallyingCry";
GHI_RCIcons["book"] = "Interface\\Icons\\INV_Misc_Book_09";
GHI_RCIcons["buff"] = "Interface\\Icons\\Spell_Holy_WordFortitude";
GHI_RCIcons["sound"] = "Interface\\Icons\\INV_Misc_Drum_01";
GHI_RCIcons["equip_item"] = "Interface\\Icons\\INV_Helmet_03";
GHI_RCIcons["bag"] = "Interface\\Icons\\INV_Misc_Bag_09_Blue";
GHI_RCIcons["requirement"] = "Interface\\Icons\\INV_Misc_QuestionMark";
GHI_RCIcons["ghr"] = "Interface\\Icons\\Spell-ChargePositive";

GHI_RCRequirements = {"Name","Level","Zone","SubZone","Guild","Class","Race","Gender","Normal Item","Base Stats","Skill","Reputation","Honor Kills","Normal Buff","GHI Buff"};

local obj = {};

GHI_RC_Menu = {};

if 1==1 then --	Expression			ok
local c = "expression"
GHI_RC_Menu[c] = {};
GHI_RC_Menu[c].title = "Expression";
GHI_RC_Menu[c].name = "GHI_NewRC_"..c;
GHI_RC_Menu[c].theme = "SpellBookTheme";
GHI_RC_Menu[c].icon = GHI_RCIcons[c];
GHI_RC_Menu[c].height = 340;
GHI_RC_Menu[c].OnOk = function()
	local main = this:GetParent();
	local text = main.GetLabel("text");
	local Type = main.GetLabel("type");
	local delay = main.GetLabel("delay");
	local menu = main.madeBy.main; 
	if menu then 
		local list = menu.GetLabelFrame("RCList");
		if list then 
			local t = {};
			t["Type"] = "expression";
			t["type_name"] = "Expression";
			t["details"] = Type..": "..strsub(text,0,100);
			t["req"] = 1;
			t["icon"] = GHI_RCIcons["expression"];
			
			t["text"] = text;
			t["expression_type"] = Type;
			t["delay"] = delay;
			
			if type(main.edit) == "number" then
				local t1 = list.GetTuble(main.edit);
				if type(t1)=="table" then
					if t1["req"] then
						t["req"] = t1["req"] 
					end
					if t1["marked"] then
						t["marked"] = t1["marked"];
					end
				end
				list.SetTuble(main.edit,t);
			else
				list.InsertTuble(t);
			end

		end
	end
end;

GHI_RC_Menu[c][1] = {};

GHI_RC_Menu[c][1][1] = {};
GHI_RC_Menu[c][1][2] = {};
GHI_RC_Menu[c][1][3] = {};
GHI_RC_Menu[c][1][4] = {};

obj = {};
obj.type = "Editbox";
obj.text = "Text:";
obj.align = "c";
obj.label = "text";
table.insert(GHI_RC_Menu[c][1][1],obj);

obj = {};
obj.type = "CustomDD";
obj.text = "Type:";
obj.align = "l";
obj.label = "type";
obj.returnIndex = false;
obj.data = {};
obj.data[1] = "Say";
obj.data[2] = "Emote";
table.insert(GHI_RC_Menu[c][1][2],obj);

obj = {};
obj.type = "Editbox";
obj.text = "Delay:";
obj.align = "r";
obj.label = "delay";
obj.width = 50;
obj.numbersOnly = true;
table.insert(GHI_RC_Menu[c][1][2],obj);

obj = {};
obj.type = "Dummy";
obj.height = 10;
obj.width = 10;
obj.align = "c";
table.insert(GHI_RC_Menu[c][1][3],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.text = "Please enter the expression type, its text and eventual delay (in sec). \nWrite %l to insert a link of the item.";
obj.align = "l";
table.insert(GHI_RC_Menu[c][1][4],obj);


end
if 1==1 then --	Random Expression	ok
local c = "random_expression"
GHI_RC_Menu[c] = {};
GHI_RC_Menu[c].title = "Random Expression";
GHI_RC_Menu[c].name = "GHI_NewRC_"..c;
GHI_RC_Menu[c].theme = "SpellBookTheme";
GHI_RC_Menu[c].icon = GHI_RCIcons[c];
GHI_RC_Menu[c].height = 580;
GHI_RC_Menu[c].OnOk = function()
	local main = this:GetParent();
	local menu = main.madeBy.main; 
	if menu then 
		local list = menu.GetLabelFrame("RCList");
		if list then 
			local t = {};
			t["Type"] = "random_expression";	
			t["type_name"] = "Random Expression";
			t["req"] = 1;
			t["icon"] = GHI_RCIcons["random_expression"];
			
			local c = 0;
			t["text"] = {};
			t["expression_type"] = {};
			for i = 1,6 do
				table.insert(t["text"],i,main.GetLabel("text"..i));
				table.insert(t["expression_type"],i,main.GetLabel("type"..i));
				if (t["text"][i]) and not(t["text"][i] == "") then
					c = c+1;
				end
			end
			t["allow_same"] = main.GetLabel("allow_same")
			
			t["details"] = c.." expressions.";
			if type(main.edit) == "number" then
				local t1 = list.GetTuble(main.edit);
				if type(t1)=="table" then
					if t1["req"] then
						t["req"] = t1["req"] 
					end
					if t1["marked"] then
						t["marked"] = t1["marked"];
					end
				end
				list.SetTuble(main.edit,t);
			else
				list.InsertTuble(t);
			end
		end
	end
end;

GHI_RC_Menu[c][1] = {};
for i = 1,10 do
GHI_RC_Menu[c][1][i] = {};
end

for i = 1,6 do
obj = {};
obj.type = "Editbox";
obj.text = "Text:";
obj.align = "l";
obj.label = "text"..i;
obj.width = 200;
table.insert(GHI_RC_Menu[c][1][i],obj);

obj = {};
obj.type = "CustomDD";
obj.text = "Type:";
obj.align = "r";
obj.label = "type"..i;
obj.width = 90;
obj.returnIndex = false;
obj.data = {};
obj.data[1] = "Say";
obj.data[2] = "Emote";
table.insert(GHI_RC_Menu[c][1][i],obj);

end


obj = {};
obj.type = "Dummy";
obj.height = 10;
obj.width = 10;
obj.align = "c";
table.insert(GHI_RC_Menu[c][1][7],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.text = "Please choose the expression types and enter their text. Each will be randomly chosen and run. Empty fields will be ignored.";
obj.align = "l";
table.insert(GHI_RC_Menu[c][1][8],obj);

obj = {};
obj.type = "Dummy";
obj.height = 10;
obj.width = 10;
obj.align = "c";
table.insert(GHI_RC_Menu[c][1][9],obj);

obj = {};
obj.type = "CheckBox";
obj.text = "Allow the same outcome twice in a row.";
obj.align = "l";
obj.label = "allow_same";
table.insert(GHI_RC_Menu[c][1][10],obj);

end
if 1==1 then --	Script			ok
local c = "script"
GHI_RC_Menu[c] = {};
GHI_RC_Menu[c].title = "Script";
GHI_RC_Menu[c].name = "GHI_NewRC_"..c;
GHI_RC_Menu[c].theme = "SpellBookTheme";
GHI_RC_Menu[c].icon = GHI_RCIcons[c];
GHI_RC_Menu[c].height = 560;
GHI_RC_Menu[c].OnOk = function()
	local main = this:GetParent();
	local code = main.GetLabel("code");
	local menu = main.madeBy.main; 
	if menu then 
		local list = menu.GetLabelFrame("RCList");
		if list then 
			local t = {};
			t["Type"] = "script";
			t["type_name"] = "Script";
			t["details"] = strsub(code,0,100);
			t["req"] = 1;
			t["icon"] = GHI_RCIcons["script"];
			
			t["code"] = {};
			while not(code == nil) and not(code == "") do
				table.insert(t["code"],string.sub(code,0,127));
				code = string.sub(code,128);
			end
			t["delay"] = main.GetLabel("delay");
			
			if type(main.edit) == "number" then
				local t1 = list.GetTuble(main.edit);
				if type(t1)=="table" then
					if t1["req"] then
						t["req"] = t1["req"] 
					end
					if t1["marked"] then
						t["marked"] = t1["marked"];
					end
				end
				list.SetTuble(main.edit,t);
			else
				list.InsertTuble(t);
			end
		end
	end
end;
GHI_RC_Menu[c][1] = {};

GHI_RC_Menu[c][1][1] = {};
GHI_RC_Menu[c][1][2] = {};
GHI_RC_Menu[c][1][3] = {};
GHI_RC_Menu[c][1][4] = {};

obj = {};
obj.type = "EditField";
obj.align = "c";
obj.height = 260;
obj.width = 260;
obj.label = "code";
table.insert(GHI_RC_Menu[c][1][1],obj);

obj = {};
obj.type = "Editbox";
obj.text = "Delay:";
obj.align = "c";
obj.label = "delay";
obj.width = 50;
obj.numbersOnly = true;
table.insert(GHI_RC_Menu[c][1][2],obj);

obj = {};
obj.type = "Dummy";
obj.height = 10;
obj.width = 10;
obj.align = "c";
table.insert(GHI_RC_Menu[c][1][3],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.text = "Scripts may consist of any lua code, except restricted functions. / commands is not allowed.";
obj.align = "l";
table.insert(GHI_RC_Menu[c][1][4],obj);


end
if 1==1 then --	book				ok
local c = "book"
GHI_RC_Menu[c] = {};
GHI_RC_Menu[c].title = "Book";
GHI_RC_Menu[c].name = "GHI_NewRC_"..c;
GHI_RC_Menu[c].theme = "SpellBookTheme";
GHI_RC_Menu[c].icon = GHI_RCIcons[c];
GHI_RC_Menu[c].height = 340;
GHI_RC_Menu[c].OnOk = function()
	local main = this:GetParent();
	local menu = main.madeBy.main; 
	if menu then 
		local list = menu.GetLabelFrame("RCList");
		if list then 
			local t = {};
			local title = main.GetLabel("title")
			
			t["title"] = title;
			
			t["details"] = title;
			t["Type"] = "book";	
			t["type_name"] = "Book";
			t["req"] = 1;
			t["icon"] = GHI_RCIcons["book"];
					
			t["pages"] = main.GetLabel("pages");
			if not(type(t["pages"]) == "number") then
				t["pages"] = 1;
			end

			for i = 1,t["pages"] do
				t[i] = main.GetLabel(i);
			end
			
			if t[1] == nil then
				t[1] = "";
			end
			
			t["h1"] = main.GetLabel("h1");
			t["h2"] = main.GetLabel("h2");
			t["font"] = main.GetLabel("font");
			t["material"] = main.GetLabel("material");
			
			
			if type(main.edit) == "number" then
				local t1 = list.GetTuble(main.edit);
				if type(t1)=="table" then
					if t1["req"] then
						t["req"] = t1["req"] 
					end
					if t1["marked"] then
						t["marked"] = t1["marked"];
					end
				end
				list.SetTuble(main.edit,t);
			else
				list.InsertTuble(t);
			end
		end
	end
end;

GHI_RC_Menu[c][1] = {};
for i = 1,4 do
GHI_RC_Menu[c][1][i] = {};
end

obj = {};
obj.type = "Dummy";
obj.height = 20;
obj.width = 10;
obj.align = "c";
table.insert(GHI_RC_Menu[c][1][1],obj);

obj = {};
obj.type = "Editbox";
obj.text = "Title:";
obj.align = "c";
obj.label = "title";
obj.width = 200;
table.insert(GHI_RC_Menu[c][1][2],obj);

obj = {};
obj.type = "Dummy";
obj.height = 20;
obj.width = 10;
obj.align = "c";
table.insert(GHI_RC_Menu[c][1][3],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.text = "Please enter enter a title above. Title and many more book related information can be changed later in the book edit menu.";
obj.align = "l";
table.insert(GHI_RC_Menu[c][1][4],obj);


end
if 1==1 then --	buff				ok
local c = "buff"
GHI_RC_Menu[c] = {};
GHI_RC_Menu[c].title = "Buff";
GHI_RC_Menu[c].name = "GHI_NewRC_"..c;
GHI_RC_Menu[c].theme = "SpellBookTheme";
GHI_RC_Menu[c].icon = GHI_RCIcons[c];
GHI_RC_Menu[c].height = 420;
GHI_RC_Menu[c].OnOk = function()
	local main = this:GetParent();
	local menu = main.madeBy.main; 
	if menu then 
		local list = menu.GetLabelFrame("RCList");
		if list then 
			local t = {};
			
			
			t["buffName"] = main.GetLabel("buff_name");
			t["buffDetails"] = main.GetLabel("buff_details");
			t["untillCanceled"] = main.GetLabel("untill_canceled");
			t["filter"] = main.GetLabel("filter");
			t["buffType"] = main.GetLabel("buff_type");
			t["buffIcon"] = main.GetLabel("buff_icon");
			t["buffDuration"] = main.GetLabel("buff_duration");
			t["castOnSelf"] = main.GetLabel("castOnSelf");
			
			
			
			t["type_name"] = "Buff";
			t["Type"] = "buff";
			t["details"] = strsub(main.GetLabel("buff_name"),0,100);
			t["req"] = 1;
			t["icon"] = GHI_RCIcons["buff"];			
			if type(main.edit) == "number" then
				local t1 = list.GetTuble(main.edit);
				if type(t1)=="table" then
					if t1["req"] then
						t["req"] = t1["req"] 
					end
					if t1["marked"] then
						t["marked"] = t1["marked"];
					end
				end
				list.SetTuble(main.edit,t);
			else
				list.InsertTuble(t);
			end
		end
	end
end;

GHI_RC_Menu[c][1] = {};
for i = 1,9 do
GHI_RC_Menu[c][1][i] = {};
end


obj = {};
obj.type = "Editbox";
obj.text = "Buff name:";
obj.align = "c";
obj.label = "buff_name";
table.insert(GHI_RC_Menu[c][1][1],obj);

obj = {};
obj.type = "Editbox";
obj.text = "Buff details:";
obj.align = "c";
obj.label = "buff_details";
table.insert(GHI_RC_Menu[c][1][2],obj);

obj = {};
obj.type = "TimeSlider";
obj.text = "Buff duration:";
obj.align = "r";
obj.label = "buff_duration";
table.insert(GHI_RC_Menu[c][1][3],obj);

obj = {};
obj.type = "CheckBox";
obj.text = "Last untill canceled";
obj.align = "l";
obj.label = "untill_canceled";
table.insert(GHI_RC_Menu[c][1][3],obj);

obj = {};
obj.type = "CheckBox";
obj.text = "Always cast on self";
obj.align = "l";
obj.label = "castOnSelf";
table.insert(GHI_RC_Menu[c][1][4],obj);

obj = {};
obj.type = "CustomDD";
obj.text = "Buff / Debuff:";
obj.align = "l";
obj.label = "filter";
obj.returnIndex = false;
obj.width = 110;
obj.data = {};
obj.data[1] = "Helpful";
obj.data[2] = "Harmful";
table.insert(GHI_RC_Menu[c][1][5],obj);

obj = {};
obj.type = "CustomDD";
obj.text = "Buff Type:";
obj.align = "r";
obj.label = "buff_type";
obj.returnIndex = false;
obj.width = 110;
obj.data = {};
obj.data[1] = "Magic";
obj.data[2] = "Curse";
obj.data[3] = "Disease";
obj.data[4] = "Poison";
table.insert(GHI_RC_Menu[c][1][5],obj);

obj = {};
obj.type = "Icon";
obj.text = "Icon:";
obj.align = "c";
obj.label = "buff_icon";
obj.framealign = "r";
obj.CloseOnChoosen = true;
table.insert(GHI_RC_Menu[c][1][5],obj);

end
if 1==1 then --	sound				ok
local c = "sound"
GHI_RC_Menu[c] = {};
GHI_RC_Menu[c].title = "Sound";
GHI_RC_Menu[c].name = "GHI_NewRC_"..c;
GHI_RC_Menu[c].theme = "SpellBookTheme";
GHI_RC_Menu[c].icon = GHI_RCIcons[c];
GHI_RC_Menu[c].height = 340;
GHI_RC_Menu[c].OnOk = function()
	local main = this:GetParent();
	local menu = main.madeBy.main; 
	if menu then 
		local list = menu.GetLabelFrame("RCList");
		if list then 
			local t = {};
			
			
			t["sound_path"] = main.GetLabel("sound_path");
			t["delay"] = main.GetLabel("delay");

	
			t["type_name"] = "Sound";
			t["Type"] = "sound";
			t["details"] = "..."..strsub(t["sound_path"],strlen(t["sound_path"])-25);
			t["req"] = 1;
			t["icon"] = GHI_RCIcons["sound"];			
			if type(main.edit) == "number" then
				local t1 = list.GetTuble(main.edit);
				if type(t1)=="table" then
					if t1["req"] then
						t["req"] = t1["req"] 
					end
					if t1["marked"] then
						t["marked"] = t1["marked"];
					end
				end
				list.SetTuble(main.edit,t);
			else
				list.InsertTuble(t);
			end
		end
	end
end;

GHI_RC_Menu[c][1] = {};
for i = 1,3 do
GHI_RC_Menu[c][1][i] = {};
end


obj = {};
obj.type = "Editbox";
obj.text = "Soundfile path:";
obj.align = "c";
obj.label = "sound_path";
table.insert(GHI_RC_Menu[c][1][1],obj);

obj = {};
obj.type = "Editbox";
obj.text = "Delay:";
obj.align = "c";
obj.label = "delay";
obj.width = 50;
obj.numbersOnly = true;
table.insert(GHI_RC_Menu[c][1][2],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.color = "white";
obj.text = "Enter a sound filepath and a delay. \nE.g.   Sound\\Creature\\Murloc\\mMurlocAggroOld.wav ";
obj.align = "l";
table.insert(GHI_RC_Menu[c][1][3],obj);

end
if 1==1 then --	equip_item			ok
local c = "equip_item"
GHI_RC_Menu[c] = {};
GHI_RC_Menu[c].title = "Equip Item";
GHI_RC_Menu[c].name = "GHI_NewRC_"..c;
GHI_RC_Menu[c].theme = "SpellBookTheme";
GHI_RC_Menu[c].icon = GHI_RCIcons[c];
GHI_RC_Menu[c].height = 340;
GHI_RC_Menu[c].OnOk = function()
	local main = this:GetParent();
	local menu = main.madeBy.main; 
	if menu then 
		local list = menu.GetLabelFrame("RCList");
		if list then 
			local t = {};
			
			
			t["item_name"] = main.GetLabel("item_name");
			t["delay"] = main.GetLabel("delay");

	
			t["type_name"] = "Equip Item";
			t["Type"] = "equip_item";
			t["details"] = strsub(main.GetLabel("item_name"),0,100);
			t["req"] = 1;
			t["icon"] = GHI_RCIcons["equip_item"];			
			if type(main.edit) == "number" then
				local t1 = list.GetTuble(main.edit);
				if type(t1)=="table" then
					if t1["req"] then
						t["req"] = t1["req"] 
					end
					if t1["marked"] then
						t["marked"] = t1["marked"];
					end
				end
				list.SetTuble(main.edit,t);
			else
				list.InsertTuble(t);
			end
		end
	end
end;

GHI_RC_Menu[c][1] = {};
for i = 1,3 do
GHI_RC_Menu[c][1][i] = {};
end


obj = {};
obj.type = "Editbox";
obj.text = "Item Name:";
obj.align = "c";
obj.label = "item_name";
table.insert(GHI_RC_Menu[c][1][1],obj);

obj = {};
obj.type = "Editbox";
obj.text = "Delay:";
obj.align = "c";
obj.label = "delay";
obj.width = 50;
obj.numbersOnly = true;
table.insert(GHI_RC_Menu[c][1][2],obj);

end
if 1==1 then --	bag				ok
local c = "bag"
GHI_RC_Menu[c] = {};
GHI_RC_Menu[c].title = "Bag";
GHI_RC_Menu[c].name = "GHI_NewRC_"..c;
GHI_RC_Menu[c].theme = "SpellBookTheme";
GHI_RC_Menu[c].icon = GHI_RCIcons[c];
GHI_RC_Menu[c].height = 340;
GHI_RC_Menu[c].OnOk = function()
	local main = this:GetParent();
	local menu = main.madeBy.main; 
	if menu then 
		local list = menu.GetLabelFrame("RCList");
		if list then 
			local t = {};
			
			
			t["size"] = main.GetLabel("slots");
			t["texture"] = "-"..main.GetLabel("texture");
			
			t["type_name"] = "Bag";
			t["Type"] = "bag";
			if t["size"] then		t["details"] = t["size"].." slots";  end
			t["req"] = 1;
			t["icon"] = GHI_RCIcons["bag"];			
			if type(main.edit) == "number" then
				local t1 = list.GetTuble(main.edit);
				if type(t1)=="table" then
					if t1["req"] then
						t["req"] = t1["req"] 
					end
					if t1["marked"] then
						t["marked"] = t1["marked"];
					end
				end
				list.SetTuble(main.edit,t);
			else
				list.InsertTuble(t);
			end
		end
	end
end;

GHI_RC_Menu[c][1] = {};
for i = 1,4 do
GHI_RC_Menu[c][1][i] = {};
end


obj = {};
obj.type = "SlotSlider";
obj.text = "Slots:";
obj.align = "c";
obj.width = 150;
obj.label = "slots";
table.insert(GHI_RC_Menu[c][1][2],obj);

obj = {};
obj.type = "CustomDD";
obj.text = "Texture:";
obj.align = "c";
obj.label = "texture";
obj.returnIndex = false;
obj.width = 110;
obj.data = {};
obj.data[1] = "Normal";
obj.data[2] = "Bank";
obj.data[3] = "Keyring";
table.insert(GHI_RC_Menu[c][1][4],obj);

end
if 1==1 then --	GHR				ok
local c = "ghr"
GHI_RC_Menu[c] = {};
GHI_RC_Menu[c].title = "GHR Reputation";
GHI_RC_Menu[c].name = "GHI_NewRC_"..c;
GHI_RC_Menu[c].theme = "SpellBookTheme";
GHI_RC_Menu[c].icon = GHI_RCIcons[c];
GHI_RC_Menu[c].height = 340;
GHI_RC_Menu[c].OnOk = function()
	local main = this:GetParent();
	local menu = main.madeBy.main; 
	if menu then 
		local list = menu.GetLabelFrame("RCList");
		if list then 
			local t = {};
			
			local fac = main.GetLabel("faction")+1;
			if not(fac) or not(type(GHR_FactionData) == "table") then return end;
			t["amount"] = main.GetLabel("amount");
			
			t["faction"] = GHR_FactionData[fac].ID;
			
			t["type_name"] = "GHR rep.";
			t["Type"] = "ghr";
			if GHR_FactionData[fac] then
				t["details"] = t["amount"].." rep. with "..GHR_FactionData[fac].name..".";
			end
			t["req"] = 1;
			t["icon"] = GHI_RCIcons["ghr"];			
			if type(main.edit) == "number" then
				local t1 = list.GetTuble(main.edit);
				if type(t1)=="table" then
					if t1["req"] then
						t["req"] = t1["req"] 
					end
					if t1["marked"] then
						t["marked"] = t1["marked"];
					end
				end
				list.SetTuble(main.edit,t);
			else
				list.InsertTuble(t);
			end
		end
	end
end;

GHI_RC_Menu[c][1] = {};
for i = 1,4 do
GHI_RC_Menu[c][1][i] = {};
end


obj = {};
obj.type = "Editbox";
obj.text = "Amount:";
obj.align = "c";
obj.label = "amount";
obj.width = 50;
obj.numbersOnly = true;
table.insert(GHI_RC_Menu[c][1][1],obj);

obj = {};
obj.type = "CustomDD";
obj.text = "Faction:";
obj.align = "c";
obj.label = "faction";
obj.returnIndex = true;
obj.width = 200;
obj.data = {};
obj.data[1] = "None";
table.insert(GHI_RC_Menu[c][1][3],obj);

function GHI_SetUpGHR()
	local temp = {};
	if type(GHR_FactionData) == "table" then
		for i=2,#(GHR_FactionData) do
			table.insert(temp,GHR_FactionData[i].name);
		end
	end
	return temp;
end
local script = "GHI_RC_Menu[\""..c.."\"][1][3][1].data = GHI_SetUpGHR();";
GHI_DoScript(script,30);
end
if 1==1 then --	requirement		ok
local c = "requirement"
GHI_RC_Menu[c] = {};
GHI_RC_Menu[c].title = "Requirement";
GHI_RC_Menu[c].name = "GHI_NewRC_"..c;
GHI_RC_Menu[c].theme = "SpellBookTheme";
GHI_RC_Menu[c].icon = GHI_RCIcons[c];
GHI_RC_Menu[c].height = 490;
GHI_RC_Menu[c].OnOk = function()
	local main = this:GetParent();
	local menu = main.madeBy.main; 
	if menu then 
		local list = menu.GetLabelFrame("RCList");
		if list then 
			local t = {};
			
			
			t["req_type"] = main.GetLabel("type");
			t["req_detail"] = main.GetLabel("text");
			
			t["type_name"] = "Requirement";
			t["Type"] = "requirement";
			t["details"] =  strsub(t["req_type"]..": "..t["req_detail"],0,100);
			t["req"] = nil;
			t["icon"] = GHI_RCIcons["requirement"];			
			if type(main.edit) == "number" then
				local t1 = list.GetTuble(main.edit);
				if type(t1)=="table" then
					if t1["req"] then
						t["req"] = t1["req"] 
					end
					if t1["marked"] then
						t["marked"] = t1["marked"];
					end
				end
				list.SetTuble(main.edit,t);
			else
				list.InsertTuble(t);
			end
		end
	end
end;

GHI_RC_Menu[c][1] = {};
for i = 1,10 do
GHI_RC_Menu[c][1][i] = {};
end




obj = {};
obj.type = "CustomDD";
obj.text = "Requirement Type:";
obj.align = "l";
obj.label = "type";
obj.returnIndex = false;
obj.data = GHI_RCRequirements;
table.insert(GHI_RC_Menu[c][1][1],obj);

obj = {};
obj.type = "Editbox";
obj.text = "Requirement filter:";
obj.align = "c";
obj.label = "text";
table.insert(GHI_RC_Menu[c][1][2],obj);

obj = {};
obj.type = "Dummy";
obj.height = 15;
obj.width = 10;
obj.align = "c";
table.insert(GHI_RC_Menu[c][1][3],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.text = "In the Requirement filter you can enter either a single value/name, or multible values/names seperated by a comma. \nYou can also write intervals of numbers with a \"-\" and use \"+\" as an open interval.";
obj.align = "l";
table.insert(GHI_RC_Menu[c][1][4],obj);

obj = {};
obj.type = "Dummy";
obj.height = 25;
obj.width = 10;
obj.align = "c";
table.insert(GHI_RC_Menu[c][1][5],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.text = "Example: Having \"Level\" as type and \"10-20,25,40-42,68+\" makes the requirement be forfilled if the players level is between 10 and 20, is 25, is between 40 and 42 or is above 68.";
obj.align = "l";
obj.color = "white";
table.insert(GHI_RC_Menu[c][1][6],obj);

obj = {};
obj.type = "Dummy";
obj.height = 25;
obj.width = 10;
obj.align = "c";
table.insert(GHI_RC_Menu[c][1][7],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.text = "Some types of requirement need to have multible things as information, those are seperated with a space.";
obj.align = "l";
table.insert(GHI_RC_Menu[c][1][8],obj);

obj = {};
obj.type = "Dummy";
obj.height = 25;
obj.width = 10;
obj.align = "c";
table.insert(GHI_RC_Menu[c][1][9],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.text = "Example: Having \"Skill\" as type and \"Blacksmithing 120+\" will let the itep require above 120 in blackssmithing.";
obj.align = "l";
obj.color = "white";
table.insert(GHI_RC_Menu[c][1][10],obj);

end



if 1==1 then --	Create Item

GHI_CreateItem_Menu = {}


GHI_CreateItem_Menu = {};
GHI_CreateItem_Menu.name = "GHI_NewItem";
GHI_CreateItem_Menu.title = "Create new GHI item";
GHI_CreateItem_Menu.theme = "WizardTheme";
GHI_CreateItem_Menu.height = 512;
GHI_CreateItem_Menu.autohide = false;
GHI_CreateItem_Menu.OnOk = function() 
	local main = this:GetParent();
	local item = {};
	
	--	page 1 values
	local name = main.GetLabel("name");
	local quality = main.GetLabel("quality");
	local icon = main.GetLabel("icon");
	local white1 = main.GetLabel("white1");
	local white2 = main.GetLabel("white2");
	local comment = main.GetLabel("quote");
	local amount = main.GetLabel("amount");
	local stackSize = main.GetLabel("stackSize");
	local copyable = main.GetLabel("copyable");
	local duration = main.GetLabel("duration");
	local durationWhenTrade = main.GetLabel("durationWhenTrade");
	local durationRealTime = main.GetLabel("durationRealTime");
	
	--	page 2 values
	local rightClick = main.GetLabel("RCList");
	local rightClicktext = main.GetLabel("use");
	local CD = main.GetLabel("CD");
	local consumed = main.GetLabel("consumed");
		
	--	control of input
	if not(name) or name == "" then
		GHI_Message("Please enter a item name.");
		return;
	end
	
	
	--	converting of RC data
	if type(rightClick) == "table" and #(rightClick) > 0 then
		rightClick.CD = CD;
		rightClick.consumed = consumed;
		rightClick.Type = "multible"
		rightClick.requireTarget = false;
		
		--	inserting index for unique type actions
		for i = 1,#(rightClick) do
			if type(rightClick[i]) == "table" then
				if strlower(rightClick[i].Type) == "bag" then
					rightClick.bag_index = i;
				elseif strlower(rightClick[i].Type) == "book" then
					rightClick.book_index = i;
				elseif strlower(rightClick[i].Type) == "buff" then
					rightClick.requireTarget = true;
				end
			end
		end
	else
		rightClicktext = nil;
	end
	
	
	local editID = main.edit;
	
	
	GHI_CreateItem(name,icon,quality,white1,white2,comment,amount,stackSize,copyable,rightClick,rightClicktext,editID,duration,durationWhenTrade,durationRealTime)
	
	main:Hide();
end

GHI_CreateItem_Menu[1] = {};
GHI_CreateItem_Menu[1].name = "Generel";
for i = 1,10 do 
GHI_CreateItem_Menu[1][i] = {};
end


GHI_CreateItem_Menu[2] = {};
GHI_CreateItem_Menu[2].name = "Right Click";
for i = 1,10 do 
GHI_CreateItem_Menu[2][i] = {};
end

if 2==2 then --	Page 1

obj = {};
obj.type = "Text";
obj.fontSize = 16;
obj.text = "General Item Info";
obj.align = "c";
table.insert(GHI_CreateItem_Menu[1][1],obj);

obj = {};
obj.type = "Editbox";
obj.text = "Name:";
obj.align = "c";
obj.label = "name";
table.insert(GHI_CreateItem_Menu[1][2],obj);

obj = {};
obj.type = "QualityDD";
obj.text = "Quality:";
obj.align = "c";
obj.label = "quality";
table.insert(GHI_CreateItem_Menu[1][3],obj);

obj = {};
obj.type = "Icon";
obj.text = "Icon:";
obj.align = "r";
obj.label = "icon";
obj.framealign = "r";
obj.CloseOnChoosen = true;
table.insert(GHI_CreateItem_Menu[1][3],obj);

obj = {};
obj.type = "Editbox";
obj.text = "White text 1:";
obj.align = "c";
obj.label = "white1";
table.insert(GHI_CreateItem_Menu[1][4],obj);

obj = {};
obj.type = "Editbox";
obj.text = "White text 2:";
obj.align = "c";
obj.label = "white2";
table.insert(GHI_CreateItem_Menu[1][5],obj);

obj = {};
obj.type = "Editbox";
obj.text = "Yellow quoted text:";
obj.align = "c";
obj.label = "quote";
table.insert(GHI_CreateItem_Menu[1][6],obj);

obj = {};
obj.type = "Editbox";
obj.text = "Amount:";
obj.align = "r";
obj.label = "amount";
obj.width = 50;
obj.numbersOnly = true;
table.insert(GHI_CreateItem_Menu[1][7],obj);

obj = {};
obj.type = "StackSlider";
obj.text = "Stack Size:";
obj.align = "c";
obj.label = "stackSize";
table.insert(GHI_CreateItem_Menu[1][7],obj);

obj = {};
obj.type = "CheckBox";
obj.text = "Copyable by others";
obj.align = "l";
obj.label = "copyable";
table.insert(GHI_CreateItem_Menu[1][7],obj);

obj = {};
obj.type = "TimeSlider";
obj.text = "Item duration:";
obj.align = "c";
obj.label = "duration";
obj.values = {0,1,5,10,15,30,60,90,120,60*5,60*10,60*15,60*30,60*60,60*90,60*60*2,60*60*5,60*60*10,60*60*20,60*60*24,60*60*24*2,60*60*24*7,60*60*24*14,60*60*24*30,60*60*24*30*2,60*60*24*30*3,60*60*24*30*6,60*60*24*365}
table.insert(GHI_CreateItem_Menu[1][8],obj);

obj = {};
obj.type = "CheckBox";
obj.text = "Start duration when traded";
obj.align = "l";
obj.label = "durationWhenTrade";
table.insert(GHI_CreateItem_Menu[1][9],obj);

obj = {};
obj.type = "CheckBox";
obj.text = "Use real time, instead of played time for duration.";
obj.align = "c";
obj.label = "durationRealTime";
table.insert(GHI_CreateItem_Menu[1][9],obj);

end
if 2==2 then --	Page 2

obj = {};
obj.type = "Text";
obj.fontSize = 16;
obj.text = "Rightclick Actions";
obj.align = "c";
table.insert(GHI_CreateItem_Menu[2][1],obj);

obj = {};
obj.type = "Dummy";
obj.width = 10;
obj.height = 20;
obj.alignt = "c";
table.insert(GHI_CreateItem_Menu[2][2],obj);

local obj2 = {};
obj = {};
obj.type = "List";
obj.lines = 7;
obj.align = "c";
obj.label = "RCList";
obj2 = {};
obj2[1] = {}
obj2[1].type = "Icon";
obj2[1].catagory = "";
obj2[1].width = 20;
obj2[1].label = "icon";
obj2[2] = {}
obj2[2].type = "Text";
obj2[2].catagory = "Type";
obj2[2].width = 120;
obj2[2].label = "type_name";
obj2[3] = {}
obj2[3].type = "Text";
obj2[3].catagory = "Details";
obj2[3].width = 200;
obj2[3].label = "details";
obj2[4] = {}
obj2[4].type = "CycleButton";
obj2[4].cycles = {"Run Always","is forfilled","is not forfilled"};
obj2[4].catagory = "Run When Req.";
obj2[4].width = 100;
obj2[4].label = "req";
obj.column = obj2;
table.insert(GHI_CreateItem_Menu[2][3],obj);

obj = {};
obj.type = "CustomDD";
obj.text = "New rightclick action:";
obj.align = "l";
obj.label = "rc_type";
obj.returnIndex = false;
obj.data = {};
for index,value in pairs(GHI_RC_Menu) do
	if type(value) == "table" then
		table.insert(obj.data,value.title);
	end
end
table.insert(GHI_CreateItem_Menu[2][4],obj);

obj = {};
obj.type = "Button";
obj.text = "Add New";
obj.align = "l";
obj.label = "new_rc_button";
obj.compact = true;
obj.onclick = function() 
	local f = this.main;
	local Type = f.GetLabel("rc_type");
	local list = f.GetLabel("RCList");
	
	if (Type == "Bag" or Type == "Book") and type(list) == "table" then
		for i = 1,#(list) do
			if type(list[i]) == "table" and list[i].type == Type then
				GHI_Message("Each item can only have one of the right click action: "..Type);
				return;
			end
		end
	end
	if Type == "GHR Reputation" and (not(GHR_OwnRank) or GHR_OwnRank > 3) then
		GHI_Message("You must have GHR and be a faction officer or higher rank to make an item that rewards reputation.");
		return;
	end
	for index,value in pairs(GHI_RC_Menu) do
		if type(value) == "table" then
			if value.title == Type then
				local g = GHM_NewFrame(value);
				if g then
					g:Show();
					g.ClearAll();
					g.edit = nil;
				end
				break;
			end
		end
	end
end
table.insert(GHI_CreateItem_Menu[2][4],obj);

obj = {};
obj.type = "Dummy";
obj.height = 10;
obj.width = 15;
obj.align = "r";
table.insert(GHI_CreateItem_Menu[2][4],obj);

obj = {};
obj.type = "Button";
obj.text = "Delete";
obj.align = "r";
obj.label = "delete_rc_button";
obj.compact = true;
obj.onclick = function() 
	local f = this.main;
	local list = f.GetLabelFrame("RCList");
	local j = list.GetMarked(); 
	if type(j) == "number" then	
		list.DeleteTuble(j);
	end
end
table.insert(GHI_CreateItem_Menu[2][4],obj);

obj = {};
obj.type = "Dummy";
obj.height = 10;
obj.width = 10;
obj.align = "r";
table.insert(GHI_CreateItem_Menu[2][4],obj);

obj = {};
obj.type = "Button";
obj.text = "Edit";
obj.align = "r";
obj.label = "edit_rc_button";
obj.compact = true;
obj.onclick = function() 
	local f = this.main;
	local list = f.GetLabelFrame("RCList");
	local j = list.GetMarked(); 
	if type(j) == "number" then	
		local d = list.GetTuble(j);
		if d.Type then	
			local Type = d.Type;

			local g = GHM_NewFrame(GHI_RC_Menu[Type]);
			if g then					
				g:Show();
				g.ClearAll();
				g.edit = j;
				
				-- Static setup
				if Type == "script" then
					local code = "";
					for i = 1,#(d["code"]) do
						code = code..d["code"][i];
					end
					g.ForceLabel("code",code);
					g.ForceLabel("delay",d["delay"]);
				elseif Type == "expression" then
					g.ForceLabel("text",d["text"]);
					g.ForceLabel("type",d["expression_type"]);
					g.ForceLabel("delay",d["delay"]);
				elseif Type == "random_expression" then
					if type(d["text"]) == "table" and type(d["expression_type"]) == "table" then
						for i = 1,6 do
							g.ForceLabel("text"..i,d["text"][i]);
							g.ForceLabel("type"..i,d["expression_type"][i]);
						end
					end
					g.ForceLabel("allow_same",d["allow_same"]); 
				elseif Type == "book" then
					g.ForceLabel("title",d["title"]);
					g.ForceLabel("pages",d["pages"]);
					if d["pages"] then
						for i = 1,d["pages"] do
							g.ForceLabel(i,d[i]);
						end
					end
					g.ForceLabel("h1",d["h1"]);
					g.ForceLabel("h2",d["h2"]);
					g.ForceLabel("font",d["font"]);
					g.ForceLabel("material",d["material"]);
					g.ForceLabel("pages",d["pages"]);
				elseif Type == "buff" then
					g.ForceLabel("buff_name",d["buffName"]);
					g.ForceLabel("buff_details",d["buffDetails"]);
					g.ForceLabel("untill_canceled",d["untillCanceled"]);
					g.ForceLabel("buff_duration",d["buffDuration"]);
					g.ForceLabel("castOnSelf",d["castOnSelf"]);
					g.ForceLabel("filter",d["filter"]);
					g.ForceLabel("buff_type",d["buffType"]);
					g.ForceLabel("buff_icon",d["buffIcon"]);
				elseif Type == "sound" then
					g.ForceLabel("sound_path",d["sound_path"]);
					g.ForceLabel("delay",d["delay"]);
				elseif Type == "equip_item" then
					g.ForceLabel("item_name",d["item_name"]);
					g.ForceLabel("delay",d["delay"]);
				elseif Type == "bag" then
					g.ForceLabel("slots",d["size"]);
					
					g.ForceLabel("texture",gsub(d["texture"],"-",""));
				elseif Type == "requirement" then
					g.ForceLabel("req_type",d["type"]);
					g.ForceLabel("req_detail",d["text"]);
				elseif Type == "ghr" then
					g.ForceLabel("amount",d["amount"]);
					if type(GHR_FactionData) == "table" then
						for i=2,#(GHR_FactionData) do
							if GHR_FactionData[i].ID == d["faction"] then
								g.ForceLabel("faction",i-1);
							end
						end
					end
				end
			end
		end
	end
end
table.insert(GHI_CreateItem_Menu[2][4],obj);

obj = {};
obj.type = "Dummy";
obj.height = 20;
obj.width = 20;
obj.align = "r";
table.insert(GHI_CreateItem_Menu[2][5],obj);


obj = {};
obj.type = "Dummy";
obj.height = 15;
obj.width = 15;
obj.align = "l";
table.insert(GHI_CreateItem_Menu[2][6],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.width = 450
obj.text = "Choose the desired type of rigth click action and press add new, to add a new right click action. \nUse the \"run when requirement\" buttons to run an action when the requirement is forfilled, is not forfilled or to run it always.";
obj.align = "l";
table.insert(GHI_CreateItem_Menu[2][6],obj);

obj = {};
obj.type = "Dummy";
obj.height = 20;
obj.width = 20;
obj.align = "r";
table.insert(GHI_CreateItem_Menu[2][7],obj);

obj = {};
obj.type = "Dummy";
obj.height = 15;
obj.width = 15;
obj.align = "l";
table.insert(GHI_CreateItem_Menu[2][8],obj);

obj = {};
obj.type = "Editbox";
obj.text = "Use:";
obj.align = "l";
obj.label = "use";
table.insert(GHI_CreateItem_Menu[2][8],obj);

obj = {};
obj.type = "Dummy";
obj.height = 20;
obj.width = 15;
obj.align = "r";
table.insert(GHI_CreateItem_Menu[2][8],obj);

obj = {};
obj.type = "TimeSlider";
obj.text = "Item cooldown:";
obj.align = "r";
obj.label = "CD";
table.insert(GHI_CreateItem_Menu[2][8],obj);

obj = {};
obj.type = "CheckBox";
obj.text = "Consumed";
obj.align = "l";
obj.label = "consumed";
table.insert(GHI_CreateItem_Menu[2][9],obj);

end
end



if 1==1 then --	Help menu
GHI_Help_Menu = {};
GHI_Help_Menu.title = "GHI Help, Info and Options";
GHI_Help_Menu.name = "GHI_Help_Menu_Frame";
GHI_Help_Menu.theme = "StdTheme";
GHI_Help_Menu.height = 250;
GHI_Help_Menu.width = 350;
GHI_Help_Menu.OnOk = function()
	local main = this:GetParent();
	

	local scale =  main.GetLabel("icon_scale");

	if type(scale) == "number" then
		GHI_MiscData["BackpackScale"] = scale;
		GHI_BPIconMove(GHI_MiscData["BackpackPos"]);
	end

	
end;

GHI_Help_Menu[1] = {};
for i = 1,7 do
GHI_Help_Menu[1][i] = {};
end

obj = {};
obj.type = "Text";
obj.fontSize = 14;
local v = GetAddOnMetadata("GHI","Version")
if v then
obj.text = "Gryphonheart Items v."..v;
else
obj.text = "Gryphonheart Items";
end
obj.align = "c";
table.insert(GHI_Help_Menu[1][1],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.text = "By Pilus. Scarshield Legion - EU. \nhttp://www.pilus.info";
obj.align = "c";
table.insert(GHI_Help_Menu[1][2],obj);

obj = {};
obj.type = "Dummy";
obj.height = 12;
obj.width = 10;
obj.align = "c";
table.insert(GHI_Help_Menu[1][3],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.color = "white";
obj.text = "Information, tips, updates, ideas and feedback \ncan be found and given on the forum: \nhttp://www.pilus.info/forum";
obj.align = "l";
table.insert(GHI_Help_Menu[1][4],obj);

obj = {};
obj.type = "Dummy";
obj.height = 20;
obj.width =10;
obj.align = "c";
table.insert(GHI_Help_Menu[1][5],obj);

obj = {};
obj.type = "Text";
obj.fontSize = 11;
obj.text = "GHI Backpack Icon";
obj.align = "l";
table.insert(GHI_Help_Menu[1][6],obj);

obj = {};
obj.type = "CustomSlider";
obj.text = "Scale:";
obj.align = "l";
obj.label = "icon_scale";
obj.values = {0.25,0.5,0.75,1.00,1.25,1.50,1.75,2.00}
table.insert(GHI_Help_Menu[1][7],obj);

obj = {};
obj.type = "Button";
obj.text = "Center Icon";
obj.align = "r";
obj.label = "center_icon";
obj.compact = true;
obj.onclick = function() 
	local f = this.main;
	GHI_MiscData["BackpackPos"] = { UIParent:GetWidth()/2, UIParent:GetHeight()/2}
	GHI_BPIconMove(GHI_MiscData["BackpackPos"]);
	
end
table.insert(GHI_Help_Menu[1][7],obj);

end
