

--  Pre difined information related to type.
local GHI_CursorPreDetails = {};
local temp;

temp = {};
temp.texture = "ITEM_CURSOR";
temp.includeOverlay = true;
temp.includeIcon = true;
temp.onCursorChange = function() 
	--GHI_Message(" if slot is locked then unlock");
	local Type,details = GHI_GetCursor();
	if details.ItemOrigFrame and details.ItemOrigFrame.number and details.ItemOrigBag then
		if type(GHI_ContainerData[details.ItemOrigBag][details.ItemOrigFrame.number]) == "table" then
			--GHR_Message("unlocking "..details.ItemOrigFrame.number)
			GHI_ContainerData[details.ItemOrigBag][details.ItemOrigFrame.number].locked = nil;
			GHI_UpdateContainers()
		end
	end
	GHI_HideUnusedActionbars();
end;
GHI_CursorPreDetails["item"] = temp;

temp = {};
temp.texture = "ITEM_CURSOR";
temp.includeOverlay = true;
temp.includeIcon = true;
temp.onCursorChange = function() 
	
end;
GHI_CursorPreDetails["copied_item"] = temp;


temp = {};
temp.texture = "ITEM_CURSOR";
temp.includeOverlay = true;
temp.includeIcon = true;
temp.onCursorChange = function() 
	--GHI_Message(" if slot is locked then unlock");
	
	GHI_HideUnusedActionbars();
end;
GHI_CursorPreDetails["item/ability"] = temp;


temp = {};
temp.texture = "CAST_CURSOR";
temp.includeOverlay = true;
temp.includeIcon = false;
temp.onCursorChange = function() GHI_EditItemButton:SetNormalTexture("Interface\\Buttons\\UI-Panel-Button-Up");  end;
GHI_CursorPreDetails["edit"] = temp;

temp = {};
temp.texture = "CAST_CURSOR";
temp.includeOverlay = true;
temp.includeIcon = false;
temp.onCursorChange = function() GHI_CopyItemButton:SetNormalTexture("Interface\\Buttons\\UI-Panel-Button-Up"); end;
GHI_CursorPreDetails["copy"] = temp;

local GHI_CursorDetails = {};

--[[ GHI_SetCursor 
arg:
	Type - string. type of cursor contenst. "none","item", "edit" "copy" etc
	details -  Array. Details of the cursor contenst
returns:
	true if completed
	
Reserved keyword not useable in details:
	r-type :  The type name of cursor
	
]]
function GHI_SetCursor(Type,details)
	if not Type then return false; end
	Type = string.lower(Type);
	
	-- handle change from old
	local oldType = GHI_GetCursor();
	local oldPreDetails = GHI_CursorPreDetails[oldType];
	if not(oldType == "none") then
		local func = oldPreDetails.onCursorChange;
		if type(func) == "function" then
			func();
		end
	end
	
	
	
	GHI_CursorDetails = details;
	--GHI_Message("type: "..Type.." details: "..type(details));
	if not( type(GHI_CursorDetails) == "table") then
		GHI_CursorDetails = {};
		--GHI_Message("no details");
	end
	
	GHI_CursorDetails.r_type = Type;
	GHI_CursorDetails = GHI_CursorDetails;
	
	local preDetails = GHI_CursorPreDetails[Type];
	if not(type(preDetails) == "table") then
		preDetails = {};
	end
	
	--	cursor
	ClearCursor();
	if preDetails.texture then
		SetCursor(preDetails.texture);
	else 
		SetCursor(nil);
	end
	
	--	overlay
	if preDetails.includeOverlay then
		GHIClickOverlayer:Show();
	else
		GHIClickOverlayer:Hide();
	end
	
	--	icon
	if preDetails.includeIcon then
		GHI_CursorIcon:SetScale(0.8);
		if details then
			if details.iconTexture then
				GHI_CursorIconTexture:SetTexture(details.iconTexture);
			else
				GHI_CursorIconTexture:SetTexture("Interface\\Icons\\INV_Misc_QuestionMark");
			end
		end
		GHI_CursorIcon:Show();
	else
		GHI_CursorIcon:Hide();	
	end
	
	--	Specific actions for some types
	if Type == "item" then
		GHI_ShowAllActionbars();
	
	end
	
	
	
	return true;
end

--[[	GHI_ResetCursor
arg:
	nil
returns:
	true
]]
function GHI_ResetCursor()
	local Type = GHI_GetCursor();
	if not(Type == "none") then
		GHI_SetCursor("none");
	end
	return true;
end

function GHI_GetCursor()
	if not(type(GHI_CursorDetails) == "table") then
		return "none",{};
	end
	local Type = GHI_CursorDetails.r_type;
	if not(Type) then
		return "none",{};
	end
	return Type, GHI_CursorDetails;
end


function GHI_GetCursorPreDetails(Type)
	return GHI_CursorDetails[Type];
end

function GHI_AddExternalPreDetails(Type,details)
	if not( type(details) == "table" and type(Type) == "string") then
		return false;
	end
	
	GHI_CursorPreDetails[Type] = details;
	return true;
end
