

GHI = AceLibrary("AceAddon-2.0"):new("AceComm-2.0", ...);

function GHI_CommunicationHookings()
	this:RegisterEvent("CHAT_MSG_ADDON");
	
	--- Set Up Ace
	GHI:SetCommPrefix("GHI")
	GHI:RegisterComm(GHI.commPrefix, "WHISPER", "ReceiveMessage")
	GHI:RegisterMemoizations {"rightClick","rightClicktext","Interface\\Icons\\","stackSize","consumed","version","white2","white1","quality","comment","creater","<HTML><BODY><P>","</P></BODY></HTML>"}
end

--[[	
Heave Comm in GHI:
	Item data
	Buff data

]]



--	====================================  Ace
GHI_ShowComm = false;
function GHI:ReceiveMessage(prefix, sender, distribution, oldRecieve, meta, arg1,arg2,arg3,arg4,arg5,arg6,arg7,arg8)
	--[
	if GHI_ShowComm == true then
		if type(meta) == "string" then
			GHI_Message(prefix.." : ".. sender.." : ".. distribution.." :  ".. meta.." : "..type(arg1).." : "..type(arg2))
		else
			GHI_Message(prefix.." : ".. sender.." : ".. distribution.." :  ".. type(meta).." : "..type(arg1).." : "..type(arg2))
		end 
	end
	
	if oldRecieve == true then
		GHI_RecieveData(meta,arg1,sender)
	elseif oldRecieve == false then
		if meta == "BuffInfo" then
			GHI_RevieveBuff(sender,arg1);
		elseif meta == "DebuffInfo" then
			GHI_RevieveDebuff(sender,arg1);
		elseif meta == "ItemVersion" then
			GHI_RecieveItemVersion(arg1,arg2,sender);
		elseif meta == "ItemDataRequest" then
			GHI_RecieveItemDataRequest(arg1,sender);
		elseif meta == "ItemData" then
			GHI_RecieveItemData(arg1,arg2,sender);
		elseif meta == "SuspectedLinkName" then
			GHI_SendLink(arg1,sender);
		elseif meta == "ItemDataVersions" then
			GHI_ItemDataVersions(arg1,arg2,arg3,sender) 
		elseif meta == "ItemRCData" then
			GHI_RecieveItemRCData(arg1,arg2);
		elseif meta == "ExpectRCData" then
			GHI_RecieveExpectRCData(arg1);
		elseif meta == "EndRCData" then
			GHI_RecieveEndRCData(arg1);
		elseif meta == "TradeDuration" then
			GHI_RecieveTradeDuration(arg1,arg2,arg3,arg4);
		elseif meta == "ApplyBuff" then		
			ApplyGHIBuff(arg1,arg2,arg3,arg4,arg5,arg6,arg7)
		end
	
	end
end

--	GHI:SendCommMessage("WHISPER",player, false, meta, data1,data2)


--	==================================== Communication	====================================

GHI_In = 0;
GHI_Out = 0;
GHI_InThisSec = 0;
GHI_OutThisSec = 0;
GHI_OutThisSec = 0;

GHI_COMMUNICATION_LIMIT = 20;

GHI_OutBuffer = {};
GHI_OutPointer = 0;

function GHI_SendDataToBuffer(metaData,data,reciever)
	--- should no longer be used
	
	
	--GHR_Message("GHI. In: "..GHI_In.." Out: "..GHI_Out);
	--GHI_Message("=== Sending Data to "..reciever.." ===");
	if reciever == "" or reciever == nil then return end;
	
	local a = strsub(reciever,0,1);
	local b = strsub(reciever,2);
	local new = "";
	
	if a then
		local va = tonumber(strbyte(a));
		if (va >= 65 and va <= 90) or (va >= 97 and va <= 122) then
			new = strupper(a)..strlower(b);
		else 
			new = reciever;
		end
	end
	
	if new == nil or new == "" or new == " " then return end;
	
	
	
	--GHR_Message("Sending to "..new);
	--GHI_Message(metaData);
	--SWM_Message(data);

	
	
	GHI_OutThisSec = GHI_OutThisSec + 1;
	
	if GHI_OutThisSec > GHI_COMMUNICATION_LIMIT or GHI_OutPointer > 0 then    --- 	or  buffer size > 0
		local list = {};
		list.metaData = metaData;
		list.data = data;
		list.reciever = new;
		
		GHI_OutPointer = GHI_OutPointer + 1;
		GHI_OutBuffer[GHI_OutPointer] = list;
		--GHI_DebugMsg("Placing data in buffer: "..GHI_OutPointer);
	else
		GHI_Out = GHI_Out + 1;
		SendAddonMessage("GHI_"..metaData,data,"WHISPER",new);
	end
end

function GHI_SendBufferData()
	if GHI_OutPointer == 0 then return end
	
	-- 	Move data in buffer
	local firstNil = 0;
	if GHI_OutPointer > 500 then
		for i = 1,GHI_OutPointer do
			if GHI_OutBuffer[i] == nil then
				firstNil = i;
				break;
			end
		end
	end
	if not(firstNil == 0) then
		local addr = 0;
		for i = firstNil,GHI_OutPointer do
			addr = addr + 1;
			GHI_OutBuffer[addr] = GHI_OutBuffer[i];
		end
		GHI_OutPointer = addr;
	end
	
	
	local c1 = 0;
	local c2 = 0;
	local c3 = GHI_OutPointer;
	local send = GHI_OutThisSec;
	if GHD_OutThisSec == nil then
		GHD_OutThisSec = 0;
	end
	for i = 1,GHI_OutPointer do
		if send + GHD_OutThisSec > GHI_COMMUNICATION_LIMIT then
			break;
		end
		
		if type(GHI_OutBuffer[i]) == "table" then
			local metaData = GHI_OutBuffer[i].metaData;
			local data = GHI_OutBuffer[i].data;
			local reciever = GHI_OutBuffer[i].reciever;
			if not(metaData == nil) and not(reciever == nil) then
				GHI_Out = GHI_Out + 1;
				SendAddonMessage("GHI_"..metaData,data,"WHISPER",reciever);
				send = send + 1;

				
				GHI_OutBuffer[i] = nil;
				
				if c1 == 0 then
					c1 = i;
				end
			end
		end
		if i == GHI_OutPointer then
			GHI_OutPointer = 0;
			break;
		end
		c2 = i;
	end
	
	--GHI_Message("Sending GHI buffer. Address: "..c1.." - "..c2.." Total: "..c2 - c1.." Max: "..c3);
	
end







function GHI_SendData(dataType,data,reciever)
	if reciever == "" or reciever == nil then return end;
	
	local a = strsub(reciever,0,1);
	local b = strsub(reciever,2);
	local new = "";
	
	if a then
		local va = tonumber(strbyte(a));
		if (va >= 65 and va <= 90) or (va >= 97 and va <= 122) then
			new = strupper(a)..strlower(b);
		else 
			new = reciever;
		end
	end
	
	if new == nil or new == "" or new == " " then return end;

	GHI:SendCommMessage("WHISPER",new, true, dataType, data)
	--SendAddonMessage("GHI_"..dataType,data,"WHISPER",new);
end

function GHI_RecieveData(b,data,sender)
		
	data = GHI_ConvertToNum(data);
	--GHI_Message("Recieved "..b);
	if b == "ReqLink" then
		GHI_SendLink(data,sender)
	elseif string.sub(b,0,10) == "ItemReply<" then
		GHI_RecieveLink(string.sub(b,10),data,sender);
	elseif string.sub(b,0,12) == "ItemReplyEnd" then
		GHI_RecieveLinkEnd(data,sender);
	elseif string.sub(b,0,6) == "Trade<" then	
		GHI_RecieveTradeItem(string.sub(b,7),data,sender);
	elseif b == "TradeAccepted" then
		if sender == GHI_TradePlayer then
			GHI_AcceptTrade();
		end
	elseif b == "RequestBuffs" then	
		GHI_SendBuffInfo(sender,data)
		GHI_SendDebuffInfo(sender,data)
	elseif string.sub(b,0,5) == "Buff_" then	
		--GHI_RecieveBuff(string.sub(b,6),data,sender);
	elseif b == "RequestDebuffs" then	
		GHI_SendDebuffInfo(sender)
	elseif string.sub(b,0,7) == "Debuff_" then	
		GHI_RecieveDebuff(string.sub(b,8),data,sender);
	elseif string.sub(b,0,15) == "ItemDataVersion" then
		GHI_RecieveItemDataVersion(data,sender);
	elseif b == "AddonVersionReq" then
		local ver = GetAddOnMetadata("GHI", "Version");
		GHI_SendData("AddonVersionAnswer",ver,sender);
		--GHI_SendData("AddonBetaAnswer",GHI_BetaKey,sender);
	elseif b == "AddonVersionAnswer" then
		if sender == GHI_TradePlayer then
			GHI_RecipientHasGHI = true;
		end
		if sender == GHI_PingedPlayer then
			GHI_RecievePing(sender,data);
		end
		--GHI_Message(sender.." got version "..data);
	elseif b == "AddonBetaAnswer" then
		if sender == GHI_PingedPlayer then
			GHI_Message(data);
			GHI_PingedPlayer = nil;
		end
	elseif b == "DisableGHI" then
		GHI_MiscData["disabled"] = true;
	elseif b == "EnableGHI" then
		GHI_MiscData["disabled"] = false;
	end
end



--	vvvvvvvvv	Item data transfer

function GHI_SendLink(name,player) 
	--	Should be run backwards?
	local found = false;
	if not(type(GHI_ItemData) == "table") then return; end
	
	--GHI_Message("Request: "..name.." to "..player);
	
	for index1,value1 in pairs(GHI_SendItemsID) do 
		if GHI_IsOfficialItem(value1) then
			value1 = tonumber(value1);
			if type(GHI_OfficialItemData[value1]) == "table" then 
				if GHI_OfficialItemData[value1].name == name then
					local version = GHI_GetVersions(value1);
					GHI:SendPrioritizedCommMessage("ALERT","WHISPER",player,false,"ItemVersion",value1,0)
					found = true;
					break;
				end
			end
		else
			if type(GHI_ItemData[value1]) == "table" then
				if GHI_ItemData[value1].name == name then
					local version = GHI_GetVersions(value1);
					GHI:SendPrioritizedCommMessage("ALERT","WHISPER",player,false,"ItemVersion",value1,version)
					found = true;
					break;
				end
			end
		end
	end
	
	if found == false then
		for i = 1,#(GHI_SendNotItems) do
			if GHI_SendNotItems[i] == name then
				GHI:SendPrioritizedCommMessage("ALERT","WHISPER",player,false,"ItemVersion","0_"..name,0)
				found = true;
				--GHI_Message("Send none link");
				break;
			end
		end
	end
	
end

function GHI_RecieveItemVersion(ID,version,sender)
	if ID and string.sub(ID,0,2) == "0_" then
		--GHI_Message("Recieve none link");
		GHI_RecieveLinkEnd(ID,sender);
	end
	if GHI_IsOfficialItem(ID) then
		GHI_RecieveLinkEnd(ID,sender)
	end
	local ownVersion = GHI_GetVersions(ID);
	--GHI_Message("sender-> "..version.." > "..ownVersion.." <- own")
	if version > ownVersion then
		GHI:SendCommMessage("WHISPER",sender,false,"ItemDataRequest",ID)
	else
		GHI_RecieveLinkEnd(ID,sender)
	end

end

function GHI_RecieveItemDataRequest(ID,sender)
	if not(type(GHI_ItemData) == "table") or not(type(GHI_ItemData[ID])=="table") then return end
	
	local data = {};
	for index1,value1 in pairs(GHI_ItemData[ID]) do
		if not(index1 == "rightClick") then
			data[index1] = value1;
		
		end	
	end
	
	
	GHI:SendCommMessage("WHISPER",sender,false,"ItemData",ID,data)
end

function GHI_RecieveItemData(ID,data,sender)
	local origRC = GHI_GetRightClickInfo(ID);
	
	GHI_ItemData[ID] = data;
	GHI_SetRightClickInfo(ID,origRC);
	GHI_RecieveLinkEnd(ID,sender)
end


function GHI_RecieveLink(prefix,data,sender)  -- no longer in use
	--GHI_Message(prefix.." : "..data);
	
	local arrayName = "GHI_ItemData";
	local array;
	array = getglobal(arrayName);
	if not(type(array) == "table") then  return end;
	
	
	addrPart = prefix;
	
	
	if data == tostring(tonumber(data)) then data = tonumber(data); end
	
	c = string.find(addrPart,"<");
	d = string.find(addrPart,">");
	
	if c and d then
		addr1 = string.sub(addrPart,c+1,d-1);
		
		if addr1 then 
			if addr1 == tostring(tonumber(addr1)) then addr1 = tonumber(addr1); end
			c = string.find(addrPart,"<",d);
			d = string.find(addrPart,">",d+1);
			if c and d then
				addr2 = string.sub(addrPart,c+1,d-1);
				
				if addr2 then 
					if addr2 == tostring(tonumber(addr2)) then addr2 = tonumber(addr2); end
					c = string.find(addrPart,"<",d);
					d = string.find(addrPart,">",d+1);
					if c and d then
						addr3 = string.sub(addrPart,c+1,d-1);
						if addr3 then 
							if addr3 == tostring(tonumber(addr3)) then addr3 = tonumber(addr3); end
							c = string.find(addrPart,"<",d);
							d = string.find(addrPart,">",d+1);
							if c and d then
								addr4 = string.sub(addrPart,c+1,d-1);
								if addr4 then
									if addr4 == tostring(tonumber(addr4)) then addr4 = tonumber(addr4); end
									if not(type(array[addr1]) == "table") then
										array[addr1] = {}
									end
									if not(type(array[addr1][addr2]) == "table") then
										array[addr1][addr2] = {}
									end
									if not(type(array[addr1][addr2][addr3]) == "table") then
										array[addr1][addr2][addr3] = {}
									end
									array[addr1][addr2][addr3][addr4] = data;
									setglobal(arrayName,array);
								end
							else
								if not(type(array[addr1]) == "table") then
									array[addr1] = {}
								end
								if not(type(array[addr1][addr2]) == "table") then
									array[addr1][addr2] = {}
								end
								array[addr1][addr2][addr3] = data;
								setglobal(arrayName,array);
							end
						end
					else
						if not(type(array[addr1]) == "table") then
							array[addr1] = {}
						end
						array[addr1][addr2] = data;
						setglobal(arrayName,array);
						
					end
				end
			else
				array[addr1] = data;
				setglobal(arrayName,array);
			end		
		end
	end	
	
end



function GHI_RecieveLinkEnd(data,sender)
	--message("C "..data);
	local info;
	if data and string.sub(data,0,2) == "0_" then
		info = {};
		info.notLink = true;
		info.name = string.sub(data,3);
	elseif GHI_IsOfficialItem(data) then
		data = tonumber(data);
		info = GHI_OfficialItemData[data];
		
	else
		info = GHI_ItemData[data];
	end
	if not( type(info) == "table") then return end;
	
	
	
	for index1,value1 in pairs(GHI_IncMsgWaiting) do 
		if type(value1) == "table" then
			
			if value1.sender == sender  then
				local text = value1.text;
				a = 0;
				done = true;
				for i=1,5 do
					--GHI_Message("link "..i.." string is now '"..text.."' Size: "..strlen(text));
					a = GHI_SearchStringForChar(text,91,a+1);
					b = strfind(text,"]",a);
					if a and b then
						
						local linkText,link;
						linkText = strsub(text,a+1,b-1);
						
						--GHI_Message(linkText.." == "..info.name..". a found as: "..a);
						if info.notLink == true and info.name == linkText then
							--GHI_Message("Found as "..a..": "..info.name);
							text = strsub(text,0,a-1).."|nolink["..linkText.."]"..strsub(text,b+1);
							a = a + 16;
						elseif linkText == info.name then
							link = GHI_GenerateLink(data);
							local cc = strlen(text);
							text = strsub(text,0,a-1)..link..strsub(text,b+1);
							--GHR_Message("Expanded with "..strlen(text)-cc);
							--GHR_Message("Insert "..link);
							a = a + 60;
						else
							-- is it an already inserted link?
							
							c = string.sub(text,a-7,a-1);
							
							--GHI_Message("'"..c.."' lenght: "..strlen(c).."   link text: "..linkText);
							if not(c == "0:0:0|h" or c == "|nolink") then   -- not already inserted
								---GHR_Message("not already inserted");
								done = false;
							end
							a = a + 2;
						end
						
						--c,d = strfind(text,linkText);
						
						--GHI_SendDataToBuffer("ReqLink",strsub(text,a+1,b-1),arg2);
						
						--
						
					else 	
						break;
					end
				end
				
				a = 0;
				for i = 1,5 do 
					a = GHI_SearchStringForChar(text,91,a+1);
					b = strfind(text,"]",a);
					if a and b then
						c = string.sub(text,a-7,a-1);
						--GHI_Message(c.." == 0:0:0|h");
						if not(c == "0:0:0|h" or c == "|nolink") then
							done = false;
							--GHI_Message("not done: "..text);
						end
						
					else
						break;
					end
				end
				
				
				
				if done == true then
					--GHI_Message("text: "..text);
					text = gsub(text,"|nolink","");
					local old_arg1 = arg1;  table.insert(GHI_DebugLog,"Old global "..arg1);
					local event = value1.event;
					setglobal("arg1", text);  --GHI_Message("arg1: "..(text or "nil"));
					setglobal("arg2", value1.sender); --GHI_Message("arg2: "..(value1.sender or "nil"));
					setglobal("arg3", value1.arg3); --GHI_Message("arg3: "..(value1.arg3 or "nil"));
					setglobal("arg4", value1.arg4); --GHI_Message("arg4: "..(value1.arg4 or "nil"));
					setglobal("arg5", value1.arg5); --GHI_Message("arg5: "..(value1.arg5 or "nil"));
					setglobal("arg6", value1.arg6); --GHI_Message("arg6: "..(value1.arg6 or "nil"));
					setglobal("arg7", value1.arg7); --GHI_Message("arg7: "..(value1.arg7 or "nil"));
					setglobal("arg8", value1.arg8); --GHI_Message("arg8: "..(value1.arg8 or "nil"));
					setglobal("arg9", value1.arg9); --GHI_Message("arg9: "..(value1.arg9 or "nil"));
					setglobal("arg10", value1.arg10); --GHI_Message("arg10: "..(value1.arg10 or "nil"));
					setglobal("arg11", value1.arg11); --GHI_Message("arg11: "..(value1.arg11 or "nil"));
					setglobal("this", value1.this); --GHI_Message("this: "..(value1.this:GetName() or "nil"));
					setglobal("event", value1.event); --GHI_Message("event: "..(value1.event or "nil"));
					GHI_TestTrigger = true;
					table.insert(GHI_DebugLog,"Writing message "..arg1);
					----------------  start test
					--[[
					GHI_Message("Recieved link end. Variable list: ");
					for i=1,11 do
						local V = getglobal("arg"..i);
						if type(V) == "string" or type(V) == "number" then
							GHI_Message("arg"..i..": "..type(V).." = "..V);
						else
							GHI_Message("arg"..i..": "..type(V));
						end
					end
					local V = getglobal("this");
					if type(V) == "string" or type(V) == "number" then
						GHI_Message("this: "..type(V).." = "..V);
					else
						GHI_Message("this: "..type(V));
					end
					local V = getglobal("event");
					if type(V) == "string" or type(V) == "number" then
						GHI_Message("event: "..type(V).." = "..V);
					else
						GHI_Message("event: "..type(V));
					end]]
					--------------   end test
					
					
					if GHI_CompAddons["Prat"] == true and not(value1.FCCC == true) then 
						if event == "CHAT_MSG_CHANNEL" then
							for i = 1,7 do
								setglobal("this", getglobal("ChatFrame"..i));
								--Prat:ChatFrame_MessageEventHandler(event)
								if i == 1 then
									Prat:ChatFrame_MessageEventHandler(event);
								else
									GHI_origChatFrame_MessageEventHandler(event);
								end
							end	
						else
							-- todo: run for other chat windows
							Prat:ChatFrame_MessageEventHandler(event)
						end
						
					elseif GHI_CompAddons["ForgottenChatCC"] == true and value1.FCCC == true then
						if value1.self == true then
							GHI_OrigFCCC_OutgoingMessage(value1.to, text, value1.lan)
						else
							GHI_OrigFCCC_IncomingMessage(value1.sender, text, value1.afk)
						end
					else
						if event == "CHAT_MSG_CHANNEL" then
							for i = 1,7 do
								setglobal("this", getglobal("ChatFrame"..i));
								GHI_origChatFrame_MessageEventHandler(event);
							end		
						else
							-- todo: run for other chat windows
							GHI_origChatFrame_MessageEventHandler(event);
						end
					end
					
					GHI_IncMsgWaiting[index1] = nil;
					setglobal("arg1", old_arg1);
					GHI_IsForcingEvent = false;
					table.insert(GHI_DebugLog,"Seeting Old global to "..old_arg1);
				else
					GHI_IncMsgWaiting[index1].text = text; --GHI_Message("Msg still stored: "..text);
				end			
			end
		end
	end
	
	--	Check if the item is in the trade window
	for i = 1,6 do
		if type(GHI_TradeItemsRecipient[i]) == "table" then
			if GHI_TradeItemsRecipient[i].ID == data then
				GHI_SetRecipientButton(i,GHI_TradeItemsRecipient[i].ID,GHI_TradeItemsRecipient[i].amount)
			end
		end
	end
end


function GHI_ItemDataVersions(ID,v1,v2,sender) --- after trade
	local own_v1,own_v2 = GHI_GetVersions(ID);
	if own_v1 > v1 then
		GHI_RecieveItemDataRequest(ID,sender)
	end
	if own_v2 > v2 then
		if not(type(GHI_ItemData) == "table") or not(type(GHI_ItemData[ID])=="table") then return end
	
		local data = {};
		for index1,value1 in pairs(GHI_ItemData[ID]) do
			if (index1 == "rightClick") then
				data = value1;
			
			end	
		end
		
		-- todo:  Send an alert with expectation of the information
		GHI:SendPrioritizedCommMessage("ALERT","WHISPER",sender,false,"ExpectRCData",ID)
		
		GHI:SendCommMessage("WHISPER",sender,false,"ItemRCData",ID,data)
		GHI:SendCommMessage("WHISPER",sender,false,"EndRCData",ID)
	end
	
	
end

GHI_AwaitingRCData = {};

function GHI_RecieveExpectRCData(ID)
	GHI_AwaitingRCData[ID] = true;
end

function GHI_RecieveItemRCData(ID,data)
	if not(type(GHI_ItemData) == "table") or not(type(GHI_ItemData[ID])=="table") then return end
	GHI_ItemData[ID].rightClick = data;

end

function GHI_RecieveEndRCData(ID)
	GHI_AwaitingRCData[ID] = nil;
end


--	^^^^^^^^^^^^




function GHI_CheckTimeoutedMsg()
		
	
	for index1,value1 in pairs(GHI_IncMsgWaiting) do 
		if type(value1) == "table" then
			if value1.time < time() - 2 then
				local text = gsub(value1.text,"|nolink","");
				
				local event = value1.event;
				setglobal("arg1", text);
				setglobal("arg2", value1.sender);
				setglobal("arg3", value1.arg3);
				setglobal("arg4", value1.arg4);
				setglobal("arg5", value1.arg5);
				setglobal("arg6", value1.arg6);
				setglobal("arg7", value1.arg7);
				setglobal("arg8", value1.arg8);
				setglobal("arg9", value1.arg9);
				setglobal("arg10", value1.arg10);
				setglobal("arg11", value1.arg11);
				setglobal("this", value1.this);
				
				
				if GHI_CompAddons["Prat"] == true and value1.FCCC == false then 
					
					if event == "CHAT_MSG_CHANNEL" then
						for i = 1,7 do
							setglobal("this", getglobal("ChatFrame"..i));
							Prat:ChatFrame_MessageEventHandler(event)
						end		
					else
						-- todo: run for other chat windows
						Prat:ChatFrame_MessageEventHandler(event)
					end
				elseif GHI_CompAddons["ForgottenChatCC"] == true and value1.FCCC == true then
					if value1.self == true then
						GHI_OrigFCCC_OutgoingMessage(value1.to, value1.text, value1.lan)
					else
						GHI_OrigFCCC_IncomingMessage(value1.sender, value1.text, value1.afk)
					end
				else
					if event == "CHAT_MSG_CHANNEL" then
						for i = 1,7 do
							setglobal("this", getglobal("ChatFrame"..i));
							GHI_origChatFrame_MessageEventHandler(event);
						end		
					else
						-- todo: run for other chat windows
						GHI_origChatFrame_MessageEventHandler(event);
					end
				end
				GHI_IncMsgWaiting[index1] = nil;
						
			end
		end
	end
	
	
	
end

--	======================== Sending item data
--	sending link = no right click info
--	Sending item data = inc right click info

function GHI_SendItemData(ID,player)
	if not(type(GHI_ItemData) == "table") then return; end
	
	--GHI_Message("Sending all data for "..ID.." to "..player);
	
	
	if type(GHI_ItemData[ID]) == "table" then
		
	local index1 = ID;
	
		for index2,value2 in pairs(GHI_ItemData[ID]) do 
			if type(value2) == "table" then
				for index3,value3 in pairs(value2) do 
					if type(value3) == "table" then
						for index4,value4 in pairs(value3) do 
							if type(value4) == "table" then
								-- More than 4 arrays
							else
								GHI_SendDataToBuffer("ItemReply<"..index1.."><"..index2.."><"..index3.."><"..index4..">",value4,player);
							end
						end
					else
						GHI_SendDataToBuffer("ItemReply<"..index1.."><"..index2.."><"..index3..">",value3,player);
					end
				end
			else 
				GHI_SendDataToBuffer("ItemReply<"..index1.."><"..index2..">",value2,player);
			end
		end
		
		GHI_SendDataToBuffer("ItemReplyEnd",index1,player);				
		
		
	else
		
	end
	
end

function GHI_RecieveItemDataVersion(data,sender)  -- GHR_Message("As: Recieved data version");
	local ID,version = strsplit(":",data);
	if not(ID) or not(version) then return end
	if not(type(GHI_ItemData[ID]) == "table") then return end
	
	local ownVersion = GHI_ItemData[ID].version;
	if not(ownVersion) then
		ownVersion = 0;
	end
	version = tonumber(version);
	ownVersion = tonumber(ownVersion);
	if not(version) or not(ownVersion) then
		return;
	end
	
	if ownVersion > version then
		GHI_SendItemData(ID,sender)  --GHR_Message("A1: Sending data.");
	end
	--GHI_Message(ownVersion.." == "..version);
	--GHR_Message("Ae: End recieved data version");
end


function GHI_SendPing(player)
	GHI_SendData("AddonVersionReq",nil,player);
	GHI_PingedPlayer = player;
end

function GHI_RecievePing(player,data)
	
	GHI_Message("Ping reply from "..player);
	GHI_Message("Version "..data);
end
