

--[[	Handler for buffs

	Public functions:
	- Add buff
		@ arg
		buff/debuff
		name
		texture
		text
		duration
		effect
		
		
	- Cancel buff
		name

--]]

function GHI_BuffHookings()
	
	--TradePlayerItem1ItemButton:SetScript("OnEnter", function() Old_Script_ItemButton(); GHI_TradeItemButtonOnEnter(this:GetParent():GetID()); end);
	GHI_Orig_BuffButton_OnUpdate = BuffButton_OnUpdate;
	BuffButton_OnUpdate = GHI_BuffButton_OnUpdate
	
	this:RegisterEvent("PLAYER_AURAS_CHANGED");
	this:RegisterEvent("PLAYER_TARGET_CHANGED");
	
	GHI_BuffFrame_Update();
	
	GHI_Orig_UnitBuff = UnitBuff;
	UnitBuff = GHI_UnitBuff;
	
	GHI_Orig_UnitDebuff = UnitDebuff;
	UnitDebuff = GHI_UnitDebuff;
	
	GHI_Orig_BuffButton_OnClick = BuffButton_OnClick;
	BuffButton_OnClick = GHI_ClickBuff;
end

function GHI_BuffFrame_Update()
	-- Handle Buffs
	
	for i=BUFF_ACTUAL_DISPLAY+1, BUFF_MAX_DISPLAY do 
		if ( GHI_BuffButton_Update("BuffButton", i, "HELPFUL") ) then 
			---BUFF_ACTUAL_DISPLAY = BUFF_ACTUAL_DISPLAY + 1;
			--GHI_Message(i);
		end
	end

	-- Handle debuffs
	for i=DEBUFF_ACTUAL_DISPLAY+1, DEBUFF_MAX_DISPLAY do
		if ( GHI_BuffButton_Update("DebuffButton", i, "HARMFUL") ) then
			--DEBUFF_ACTUAL_DISPLAY = DEBUFF_ACTUAL_DISPLAY + 1;
		end
	end
end

function GHI_BuffButton_Update(buttonName, index, filter)
	-- Valid tokens for "filter" include: HELPFUL, HARMFUL, CANCELABLE, NOT_CANCELABLE
	local icon, color, debuffType, debuffSlot, buffCount;
	
	local a = BUFF_ACTUAL_DISPLAY;
	if filter == "HARMFUL" then
		a = DEBUFF_ACTUAL_DISPLAY;
	end
	
	
	local buffIndex, untilCancelled, texture, count,debuffType = GetGHIBuff(index - a, filter);
	local buffName = buttonName..index;
	local buff = getglobal(buffName);
	local buffDuration = getglobal(buffName.."Duration");
	
	
	
	if ( buffIndex == 0 ) then
		-- No buff so hide it if it exists
		if ( buff ) then
			buff:Hide();
			buffDuration:Hide();
			--GHI_Message("hiding: "..buff:GetName());
		end
		
		return nil;
	else  
		buffIndex = buffIndex + a;
		--GHI_Message("bi: "..buffIndex);
		-- If buff button doesn't exist make it
		if ( not buff ) then 
			if ( filter == "HELPFUL" ) then
				buff = CreateFrame("Button", buffName, BuffFrame, "BuffButtonTemplate");
			else
				buff = CreateFrame("Button", buffName, BuffFrame, "BuffButtonHarmful");
			end
			
			buffDuration = getglobal(buffName.."Duration");
		end
		
		buff.GHIBuffIndex = buffIndex - a;
		buff.filter = filter;
		
		
		-- Anchor Buff
		BuffButton_UpdateAnchors(buttonName, index, filter);
		-- Setup Buff
		
		buff.buffIndex = buffIndex;
		buff.untilCancelled = untilCancelled; 
		buff:SetID(100);
		buff:SetAlpha(1.0);
		buff:Show();
		if ( SHOW_BUFF_DURATIONS == "1" ) then
			buffDuration:Show();
		else
			buffDuration:Hide();
		end
		
		-- Set Texture
		icon = getglobal(buffName.."Icon");
		if texture then
			icon:SetTexture(texture);
		else
		
			icon:SetTexture("Interface\\Icons\\INV_Misc_QuestionMark");
		end

		-- Set the number of applications of an aura if its a debuff
		buffCount = getglobal(buffName.."Count");			
--		count = GetPlayerBuffApplications(buffIndex);
		
		if ( count > 1 ) then
			buffCount:SetText(count);
			buffCount:Show();
		else
			buffCount:Hide();
		end

		-- Set color of debuff border based on dispel class.
		if ( filter == "HARMFUL" ) then
			--debuffType = "none"--GetPlayerBuffDispelType(buffIndex);
			debuffSlot = getglobal(buffName.."Border");
			if ( debuffType ) then
				color = DebuffTypeColor[debuffType];
			else
				color = DebuffTypeColor["none"];
			end

			if ( debuffSlot ) then
				debuffSlot:SetVertexColor(color.r, color.g, color.b);
			end
			
			if ( not debuffType ) then
				debuffType = "none";
			end
		end
		
		-- Refresh tooltip
		if ( GameTooltip:IsOwned(buff) ) then
			GHI_SetBuffTooltip(this);
		end
	end
	return 1;

end

function GHI_BuffButton_OnUpdate()
	local buffIndex = this.buffIndex;
	local filter = this.filter;
	
	--GHIBuffIndex
	
	
	--GHI_Message(buffIndex.." > "..BUFF_ACTUAL_DISPLAY);
	--GHI_Message("updating "..this:GetName());
	--GHI_Message(this.buffIndex);
	if not(buffIndex) then
		GHI_Orig_BuffButton_OnUpdate();
	elseif ((filter == "HELPFUL") and not(buffIndex > BUFF_ACTUAL_DISPLAY)) or ((filter == "HARMFUL") and not(buffIndex > DEBUFF_ACTUAL_DISPLAY)) then
	
		GHI_Orig_BuffButton_OnUpdate();
		--GHI_BuffFrame_Update();
		--GHI_Message("A");
	else
		--GHI_Message(buffIndex);
		--GHI_Message("B");
	
		local buffDuration = getglobal(this:GetName().."Duration");
		
		
		if ( this.untilCancelled == 1 ) then
			buffDuration:Hide();
			if ( GameTooltip:IsOwned(this) ) then
				GHI_SetBuffTooltip(this)
			end
			return;
		end

		
		
		--if buffIndex > BUFF_ACTUAL_DISPLAY then
		--local timeLeft = 20;
		
		--else
		
		local timeLeft = GetGHIBuffTimeLeft(this.GHIBuffIndex,filter);
		
		--
		--GHR_Message("t: "..timeLeft);
		
		if timeLeft <= 0 then
			RemoveGHIBuff(this.GHIBuffIndex,filter);
			GHI_BuffFrame_Update();
			return;
		end
		--GHR_Message(buffIndex);
		
		if ( timeLeft < BUFF_WARNING_TIME ) then
			this:SetAlpha(BuffFrame.BuffAlphaValue);
		else
			this:SetAlpha(1.0);
		end

		-- Update duration
		--GHI_Message(this:GetName().." : "..timeLeft);
		BuffFrame_UpdateDuration(this, timeLeft);

		if ( BuffFrame.BuffFrameUpdateTime > 0 ) then
			return;
		end
		if ( GameTooltip:IsOwned(this) ) then
			GHI_SetBuffTooltip(this)
		end
	end
end

function GHI_ClickBuff()
	local buffIndex = this.GHIBuffIndex; 
	local a = BUFF_ACTUAL_DISPLAY;
	
	if this.filter == "HARMFUL" then
		a = DEBUFF_ACTUAL_DISPLAY;
	end
	
	
	
	
	local _,b = string.find(this:GetName(),"Button");
	if b then
		local index = tonumber(string.sub(this:GetName(),b+1));
		if index then
			if (index > a) then 
				if (this.filter == "HELPFUL") then
					if (GHI_BuffList[buffIndex]) then
						--GHI_Message("clicked "..index.." name: "..GHI_BuffList[index].name);
						--if (GHI_BuffList[buffIndex].untilCancelled == 1) then
						RemoveGHIBuff(buffIndex,"HELPFUL")
						--end
					end
				end
			end
		end
	end
	GHI_Orig_BuffButton_OnClick();
end


--	============================  Target buffs  =====================
GHI_TargetBuffAmount = 0;

function GHI_UnitBuff(unit,index,raidFilter)
	
	local name = GHI_Orig_UnitBuff(unit,index,raidFilter);
	if name then	
		if unit == "target" then
			GHI_TargetBuffAmount = index;
		end
		
		local frame = getglobal("TargetFrameBuff"..index);
		if frame then
			frame:SetScript("OnEnter", function() GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT", 15, -25); GameTooltip:SetUnitBuff("target", this.id); end);
			
		end
		
		
		return GHI_Orig_UnitBuff(unit,index,raidFilter);
	else
		if index <= GHI_TargetBuffAmount then
			GHI_TargetBuffAmount = 0;
		end
		local buffIndex = index - GHI_TargetBuffAmount;
		
		--GHI_Message("Looking for index: "..buffIndex..". Found: "..type(GHI_TargetBuffs[buffIndex]));
		--GHD_PrintArray(GHI_TargetBuffs)
		
		if not(GHI_TargetBuffs[buffIndex]) then 
			return;
		else 
			
			local frame = getglobal("TargetFrameBuff"..index);
			if frame then
				frame:SetScript("OnEnter", function() GHI_TargetBuffTooltip(buffIndex) end);
			end
			--GHI_Message("inserted "..index.." : "..type(frame));
			--GHI_Message("Returneds: "..GHI_TargetBuffs[buffIndex].name..", , "..GHI_TargetBuffs[buffIndex].texture);
			return GHI_TargetBuffs[buffIndex].name, "", GHI_TargetBuffs[buffIndex].texture, 1, nil,nil;
		end
	end	
end



GHI_TargetDebuffAmount = 0;

function GHI_UnitDebuff(unit,index,raidFilter)
	
	local name = GHI_Orig_UnitDebuff(unit,index,raidFilter);
	if name then	
		if unit == "target" then
			GHI_TargetDebuffAmount = index;
		end
		
		local frame = getglobal("TargetFrameDebuff"..index);
		if frame then
			frame:SetScript("OnEnter", function() GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT", 15, -25); GameTooltip:SetUnitDebuff("target", this.id); end);
		end
		
		
		return GHI_Orig_UnitDebuff(unit,index,raidFilter);
	else
		if index <= GHI_TargetDebuffAmount then
			GHI_TargetDebuffAmount = 0;
		end
		local DebuffIndex = index - GHI_TargetDebuffAmount;
		--GHD_PrintArray(GHI_TargetDebuffs);
		--GHI_Message("Looking for index: "..DebuffIndex..". Found: "..type(GHI_TargetDebuffs[DebuffIndex]));
		if not(GHI_TargetDebuffs[DebuffIndex]) then 
			return;
		else 
			local frame = getglobal("TargetFrameDebuff"..index);
			if frame then
				frame:SetScript("OnEnter", function() GHI_TargetDebuffTooltip(DebuffIndex) end);
			end
			--GHI_Message("Returneds: "..GHI_TargetDebuffs[DebuffIndex].name..", , "..GHI_TargetDebuffs[DebuffIndex].texture..", "..GHI_TargetDebuffs[DebuffIndex].debuffType);
			return GHI_TargetDebuffs[DebuffIndex].name, "", GHI_TargetDebuffs[DebuffIndex].texture, 1,GHI_TargetDebuffs[DebuffIndex].debuffType, nil,nil;
			
		end
	end	
end

GHI_TargetBuffs = {};
GHI_TargetDebuffs = {};

function GHI_TargetBuffTooltip(index)
	GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT", 15, -25);
	GameTooltip:ClearLines(); 
	GameTooltip:AddLine(GHI_TargetBuffs[index].name,1,0.8196079,0);  
	GameTooltip:AddLine(GHI_TargetBuffs[index].text,1,1,1);  
	GameTooltip:Show();
end

function GHI_CheckTarget()
	local name, realm = UnitName("target")
	if UnitIsPlayer("target") and UnitFactionGroup("target") == UnitFactionGroup("player") and realm == nil then
		
		GHI_SendData("RequestBuffs",GHI_TargetBuffs.lastUpdated,name);
		--GHI_SendData("RequestDebuffs",1,name);			
		if not(GHI_TargetBuffs.name == name) then
			GHI_TargetBuffs = {};
			TargetDebuffButton_Update();
		end
		if not(GHI_TargetDebuffs.name == name) then
			GHI_TargetDebuffs = {};
			TargetDebuffButton_Update();
		end
	else
		GHI_TargetBuffs = {};
		GHI_TargetDebuffs = {};
		TargetDebuffButton_Update();
	end
end

function GHI_SendBuffInfo(sender,lastUpdated)
	if not(type(lastUpdated) == "number") then
		lastUpdated = 0;
	end
	
	local ownTime = 0;
	if type(GHI_BuffList) == "table" then
		if type(GHI_BuffList.lastUpdated) == "number" then
			ownTime = GHI_BuffList.lastUpdated
		end
	end
	
	if lastUpdated < ownTime or lastUpdated == 0 or ownTime == 0 then
		GHI:SendCommMessage("WHISPER",sender,false,"BuffInfo",GHI_BuffList)
	end
	
	--[[
	for index1,value1 in pairs(GHI_BuffList) do 
		
		GHI_SendDataToBuffer("Buff_Name-"..index1,value1.name,sender);	
		GHI_SendDataToBuffer("Buff_Text-"..index1,value1.text,sender);	
		GHI_SendDataToBuffer("Buff_Icon-"..index1,value1.texture,sender);	
				
	end
	GHI_SendDataToBuffer("Buff_Amount",table.getn(GHI_BuffList),sender);]]
end


function GHI_SendDebuffInfo(sender,lastUpdated)
	if not(type(lastUpdated) == "number") then
		lastUpdated = 0;
	end
	
	local ownTime = 0;
	if type(GHI_DebuffList) == "table" then
		if type(GHI_DebuffList.lastUpdated) == "number" then
			ownTime = GHI_DebuffList.lastUpdated
		end
	end
	
	if lastUpdated < ownTime or lastUpdated == 0 or ownTime == 0 then
		GHI:SendCommMessage("WHISPER",sender,false,"DebuffInfo",GHI_DebuffList)
	end
	--[[
	for index1,value1 in pairs(GHI_DebuffList) do 
		
		GHI_SendDataToBuffer("Debuff_Name-"..index1,value1.name,sender);	
		GHI_SendDataToBuffer("Debuff_Text-"..index1,value1.text,sender);	
		GHI_SendDataToBuffer("Debuff_Icon-"..index1,value1.texture,sender);	
		GHI_SendDataToBuffer("Debuff_Type-"..index1,value1.debuffType,sender);			
	end
	GHI_SendDataToBuffer("Debuff_Amount",table.getn(GHI_DebuffList),sender);]]
end


function GHI_RecieveBuffOld(prefix,data,sender)   -- no longer in use
	if sender == UnitName("target") then
		local a = string.sub(prefix,0,5);
		local b = tonumber(string.sub(prefix,6));
		--GHI_Message(a.."    "..b);
		if a and b then
			if not(GHI_TargetBuffs.name == UnitName("target")) then
				GHI_TargetBuffs = {};
				GHI_TargetBuffs.name = UnitName("target");
			
			end
			if not(type(GHI_TargetBuffs[b]) == "table") then
				GHI_TargetBuffs[b] = {};
			end
		
			local changed = false;
			if a == "Name-" then
				if not(GHI_TargetBuffs[b].name == data) then changed = true; end
				GHI_TargetBuffs[b].name = data;
			elseif a == "Text-" then
				if not(GHI_TargetBuffs[b].text == data) then changed = true; end
				GHI_TargetBuffs[b].text = data;
			elseif a == "Icon-" then
				if not(GHI_TargetBuffs[b].icon == data) then changed = true; end
				GHI_TargetBuffs[b].icon = data;
			end
			
			if changed == true then
				--TargetDebuffButton_Update();
			end
		end
		
		if prefix == "Amount" then 
			local amount = tonumber(data);
			if amount then 
				local len = table.getn(GHI_TargetBuffs);
				if amount < len then 
					local array = {};
					array.name = GHI_TargetBuffs.name;
					
					for i=1,amount do 
						array[i] = GHI_TargetBuffs[i];
					end
					GHI_TargetBuffs = array;
					
					
				end
			end
			TargetDebuffButton_Update();
		end
	end
end

function GHI_RevieveBuff(sender,buffInfo)
	if not(sender == UnitName("target")) then return end
	if not(type(buffInfo) == "table") then 	return	end
	
	GHI_TargetBuffs = buffInfo;
	GHI_TargetBuffs.lastUpdated = time();
	GHI_TargetBuffs.name = sender;
	--GHD_PrintArray(GHI_TargetBuffs);
	TargetDebuffButton_Update();
	
end

function GHI_RecieveDebuffOld(prefix,data,sender)
	if sender == UnitName("target") then
		local a = string.sub(prefix,0,5);
		local b = tonumber(string.sub(prefix,6));
		--GHI_Message(a.."    "..b);
		if a and b then
			if not(GHI_TargetDebuffs.name == UnitName("target")) then
				GHI_TargetDebuffs = {};
				GHI_TargetDebuffs.name = UnitName("target");
			
			end
			if not(type(GHI_TargetDebuffs[b]) == "table") then
				GHI_TargetDebuffs[b] = {};
			end
		
			local changed = false;
			if a == "Name-" then
				if not(GHI_TargetDebuffs[b].name == data) then changed = true; end
				GHI_TargetDebuffs[b].name = data;
			elseif a == "Text-" then
				if not(GHI_TargetDebuffs[b].text == data) then changed = true; end
				GHI_TargetDebuffs[b].text = data;
			elseif a == "Icon-" then
				if not(GHI_TargetDebuffs[b].icon == data) then changed = true; end
				GHI_TargetDebuffs[b].icon = data;
			elseif a == "Type-" then
				if not(GHI_TargetDebuffs[b].debuffType == data) then changed = true; end
				GHI_TargetDebuffs[b].debuffType = data;
			end
			if changed == true then
				--TargetDeDebuffButton_Update();
			end
		end
		
		if prefix == "Amount" then 
			local amount = tonumber(data);
			if amount then 
				local len = table.getn(GHI_TargetDebuffs);
				if amount < len then 
					local array = {};
					array.name = GHI_TargetDebuffs.name;
					
					for i=1,amount do 
						array[i] = GHI_TargetDebuffs[i];
					end
					GHI_TargetDebuffs = array;
					
					
				end
			end
			TargetDebuffButton_Update();
		end
	end
end

function GHI_RevieveDebuff(sender,debuffInfo)
	if not(sender == UnitName("target")) then return end
	if not(type(debuffInfo) == "table") then 	return	end
	
	GHI_TargetDebuffs = debuffInfo;
	GHI_TargetBuffs.lastUpdated = time();
	GHI_TargetDebuffs.name = sender;
	--GHI_Message("====   Recieve Debuffs:");
	--GHD_PrintArray(GHI_TargetDebuffs);
	TargetDebuffButton_Update();
	
end

function GHI_TargetDebuffTooltip(index)
	GameTooltip:SetOwner(this, "ANCHOR_BOTTOMRIGHT", 15, -25);
	GameTooltip:ClearLines(); 
	GameTooltip:AddLine(GHI_TargetDebuffs[index].name,1,0.8196079,0);  
	GameTooltip:AddLine(GHI_TargetDebuffs[index].text,1,1,1);  
	GameTooltip:Show();
end



--- 	Intern API
function GHI_SetBuffTooltip(frame)
	local index = frame.GHIBuffIndex;
	local filter = frame.filter;
	
	--GHI_Message("tooltip "..index);
	
	if filter == "HELPFUL" then
		if not(GHI_BuffList[index]) then 
			return;
		else
			GameTooltip:ClearLines(); 
			GameTooltip:AddLine(GHI_BuffList[index].name,1,0.8196079,0);
			GameTooltip:AddLine(GHI_BuffList[index].text,1,1,1);
			
			if not(frame.untilCancelled == 1) then
				if (GHI_BuffList[index].timeCasted) and (GHI_BuffList[index].duration) then
					local t = GHI_BuffList[index].timeCasted + GHI_BuffList[index].duration - time();
					local t2 = GHI_TimeToTooltipText(t);
					
					GameTooltip:AddLine(t2.." remaining",1,0.8196079,0);
				end
			end
			
			GameTooltip:Show();
		end
	elseif filter == "HARMFUL" then
		if not(GHI_DebuffList[index]) then 
			return;
		else
			GameTooltip:ClearLines(); 
			GameTooltip:AddLine(GHI_DebuffList[index].name,1,0.8196079,0);
			GameTooltip:AddLine(GHI_DebuffList[index].text,1,1,1);
			
			if not(frame.untilCancelled == 1) then
				if (GHI_DebuffList[index].timeCasted) and (GHI_DebuffList[index].duration) then
					local t = GHI_DebuffList[index].timeCasted + GHI_DebuffList[index].duration - time();
					local t2 = GHI_TimeToTooltipText(t);
					
					GameTooltip:AddLine(t2.." remaining",1,0.8196079,0);
				end
			end
			GameTooltip:Show()
		end 
	else
		return;
	end
	
	
	
end

function GHI_TimeToTooltipText(Time)
	local CD_Sec = floor(Time);
	if CD_Sec == 1 then
		return CD_Sec.." seconds";
	elseif CD_Sec < 60 then
		return CD_Sec.." seconds";
	else
		local CD_Min = floor(CD_Sec/60)+1;
		if CD_Min == 1 then
			return CD_Min.." minute";
		elseif CD_Min < 60 then
			return CD_Min.." minutes";
		else
			local CD_Hour = floor(CD_Min/60)+1;
			if CD_Hour == 1 then
				return CD_Hour.." hour";
			elseif CD_Hour < 24 then
				return CD_Hour.." hours";
			else 
				local CD_Days = floor(CD_Hour/24)+1;
				if CD_Days == 1 then
					return CD_Days.." day";
				else
					return CD_Days.." days";
				end						
			end
		end				
	end

end


----	API

function GetGHIBuff(index, filter)
	if filter == "HELPFUL" then
		if not(GHI_BuffList[index]) then
			return 0;
		else
			local untilCancelled, buffDuration, Texture, count, debuffType;
			buffDuration = GHI_BuffList[index].buffDuration;
			Texture = GHI_BuffList[index].texture;
			count = GHI_BuffList[index].amount;
			debuffType = GHI_BuffList[index].debuffType;
			untilCancelled = GHI_BuffList[index].untilCancelled;
			if count == nil then count = 1; end
			return index, untilCancelled, Texture, count, debuffType;
		end
	elseif filter == "HARMFUL" then
		if not(GHI_DebuffList[index]) then
			return 0;
		else
			local untilCancelled, buffDuration, Texture, count, debuffType;
			buffDuration = GHI_DebuffList[index].buffDuration;
			Texture = GHI_DebuffList[index].texture;
			count = GHI_DebuffList[index].amount;
			debuffType = GHI_DebuffList[index].debuffType;
			untilCancelled = GHI_DebuffList[index].untilCancelled;
			if count == nil then count = 1; end
			return index, untilCancelled, Texture, count, debuffType;
		end
	
	else
		return 0;
	end
end

function GetGHIBuffTimeLeft(index,filter)
	if filter == "HELPFUL" then
		if not(type(GHI_BuffList[index]) == "table") or not(GHI_BuffList[index].timeCasted) or not(GHI_BuffList[index].duration) then
			
			return -1;
		else
			if GHI_BuffList[index].untilCancelled == 1 then
				return 1;
			end
			
			local t = GHI_BuffList[index].timeCasted + GHI_BuffList[index].duration - time();
			if t then
				return t;
			else
				return -1;
				
			end
			
		end
	elseif filter == "HARMFUL" then
		if not(type(GHI_DebuffList[index]) == "table") or not(GHI_DebuffList[index].timeCasted) or not(GHI_DebuffList[index].duration) then
			
			return -1;
		else
			if GHI_DebuffList[index].untilCancelled == 1 then
				return 1;
			end
			
			local t = GHI_DebuffList[index].timeCasted + GHI_DebuffList[index].duration - time();
			if t then
				return t;
			else
				return -1;
				
			end
			
		end
	else
		return -1;
	end
end

function ApplyGHIBuff(name,text,texture,untilCancelled,filter,debuffType,duration,cancelable)
	filter = strupper(filter);
	
	local B = {}
	if filter == "HELPFUL" then
		--table.insert(GHI_BuffList,list);
		B = GHI_BuffList;
	elseif filter == "HARMFUL" then
		--table.insert(GHI_DebuffList,list);
		B = GHI_DebuffList;
	end
	
	
	for i=1,#(B) do
		if type(B[i]) == "table" then
			if B[i].name == name and B[i].text == text and B[i].texture == texture then
				if filter == "HELPFUL" then
					GHI_BuffList[i].amount = GHI_BuffList[i].amount +1;
					GHI_BuffList[i].timeCasted = time();
					GHI_BuffList.lastUpdated = time();
				elseif filter == "HARMFUL" then
					GHI_DebuffList[i].amount = GHI_DebuffList[i].amount +1;
					GHI_DebuffList[i].timeCasted = time();
					GHI_DebuffList.lastUpdated = time();
				end
				
				GHI_BuffFrame_Update();
				return;
			end
		end
	end
	
	
	local list = {};
	list.amount = 1;
	list.name = name;
	list.text = text;
	list.texture = texture;
	
	list.untilCancelled = untilCancelled;
	
	if DebuffTypeColor[debuffType] == nil then
		debuffType = "none"; 
	end
	
	list.debuffType = debuffType;
	list.duration = duration;
	list.cancelable = cancelable;
	list.timeCasted = time();
	
	if filter == "HELPFUL" then
		table.insert(GHI_BuffList,list);
		GHI_BuffList.lastUpdated = time();
	elseif filter == "HARMFUL" then
		table.insert(GHI_DebuffList,list);
		GHI_DebuffList.lastUpdated = time();
	end
	
	GHI_BuffFrame_Update();
end

function RemoveGHIBuff(index,filter)
	if filter == "HELPFUL" then
		table.remove(GHI_BuffList,index);
		GHI_BuffList.lastUpdated = time();
		GHI_BuffFrame_Update();
	elseif filter == "HARMFUL" then
		table.remove(GHI_DebuffList,index);
		GHI_DebuffList.lastUpdated = time();
		GHI_BuffFrame_Update();
	end
end

GHI_BuffList = {};
GHI_DebuffList = {};
GHI_BuffList.lastUpdated = time();
GHI_DebuffList.lastUpdated = time();

