GHI_Version = GetAddOnMetadata("GHI", "Version");


-- Binding Variables
BINDING_HEADER_GHI = "GHI";
BINDING_NAME_GHI_TOGGLE = "Toggle GHI bag";


if GHI_ContainerData == nil then
	GHI_ContainerData = {{}};
end
GHI_ItemData = {};
GHI_CooldownData = {};
GHI_PName = UnitName("player");
GHI_MiscData = {};

function GHI_OnLoad()
	this:RegisterEvent("ADDON_LOADED");
	this:RegisterEvent("VARIABLES_LOADED");
	this:RegisterEvent("PLAYER_ENTERING_WORLD");
	this:RegisterEvent("TIME_PLAYED_MSG");
	this:RegisterEvent("SPELLS_CHANGED");
	
	SlashCmdList["GHI"] = GHI_ChatCommand;
	SLASH_GHI1 = "/GHI";
	
	local Old_Script = WorldFrame:GetScript("OnUpdate");
	WorldFrame:SetScript("OnUpdate", function() Old_Script(); GHI_OnWF(); end);
	
	tinsert(UISpecialFrames,"GHIContainerFrame1");
	tinsert(UISpecialFrames,"GHIContainerFrame2");
	tinsert(UISpecialFrames,"GHIContainerFrame3");
	
	GHI_ContainerHookings();
	GHI_ItemLinkHookings();
	GHI_CommunicationHookings();
	GHI_TradeHookings();
	GHI_BuffHookings();
	GHI_ActionbarHookings();
	
end

GHI_GivenDisabledMessage = false;
GHI_GivenEnabledMessage = false;
GHI_StartedPlayedTime = nil;
GHI_Reload = true;
function GHI_OnEvent()
	
	
	--[[if GHI_MiscData["disabled"] == true then
		if GHI_GivenDisabledMessage == false then
			GHI_GivenDisabledMessage = true;
			GHI_GivenEnabledMessage = false;
			GHI_Message("GHI is disabed by admin.");
		end
		if not(event=="CHAT_MSG_ADDON" and arg1 == "GHI_EnableGHI") then
			return
		end
	else
		if GHI_GivenEnabledMessage == false then
			GHI_GivenDisabledMessage = false;
			GHI_GivenEnabledMessage = true;
			GHI_Message("GHI is enabled by admin.");
		end
	end--]]
	
	
	
	if(event=="ADDON_LOADED" and arg1=="GHI") then
		GHI_ClearLocked();
		GHI_EffectHookings();
		GHI_Message("Gryphonheart Items loaded.");
	elseif(event=="CHAT_MSG_ADDON" and  arg3=="WHISPER") then
	
		--GHI_RecieveData(arg1,arg2,arg4);
	elseif(event=="PLAYER_AURAS_CHANGED") then
		GHI_BuffFrame_Update();
	elseif(event=="PLAYER_TARGET_CHANGED") then
		GHI_CheckTarget();
	elseif(event=="SPELLS_CHANGED") then
		GHI_Reload = false;
	elseif(event=="PLAYER_ENTERING_WORLD") then
		GHI_HideUnusedActionbars();
		
		if GHI_StartedPlayedTime == nil then 
			RequestTimePlayed();
		end
	elseif(event=="TIME_PLAYED_MSG") then 
		if GHI_StartedPlayedTime == nil then
			GHI_StartedPlayedTime = GetTime() - arg1;	
		end
	elseif(event=="VARIABLES_LOADED") then
		
		GHI_BPIconMove(GHI_MiscData["BackpackPos"]);
		GHI_CheckOfficialData();
		GHI_CompOnAddonsLoaded();
		GHI_ClearItemCatche();
	end
	
	OnTradeEvent()

end

function GHI_ChatCommand(msg)
	--if msg == "toggle" then
	GHI_ToggleBackpack();
	--end
end

function GHI_Message(msg)
	local info = ChatTypeInfo["LOOT"];
	DEFAULT_CHAT_FRAME:AddMessage(msg, info.r, info.g, info.b, info.id);
end


-- ============================ Timers ============================
GHI_LastWF = 0;
GHI_Count = 0;
GHI_Count2 = 0;

function GHI_OnWF()
	local diff = time() - GHI_LastWF;
	GHI_Count = GHI_Count+1;
	GHI_LastWF = time();
	if diff > 0 then
		-- GHI_Message(GHI_Count);
		GHI_Count = 0;
		GHI_EachSec();
		GHI_Count2 = GHI_Count2 + 1;
		if mod(GHI_Count2,10) == 0 then
			GHI_EachTenSec()
		end
		if GHI_Count2 >= 60 then
			GHI_EachMin();
			GHI_Count2 = 0;
		end
	end
	GHI_EachFrame();
end

local OldAA = 0;
function GHI_EachFrame()
	local x, y = GetCursorPosition();
	
	local s = GHI_CursorIcon:GetEffectiveScale();
	x, y = x/s, y/s;
	
	GHI_CursorIcon:SetPoint("TOPLEFT","UIParent","BOTTOMLEFT", (x ), (y ));  --   * 1.25 ?
	
	
	a = GHI_ItemTextFrameScrollFrame:GetVerticalScrollRange();
	if not(a == OldAA) then
		if GHI_IconsInPage.state then
			--GHI_Message(GHI_IconsInPage.state);
			if(GHI_IconsInPage.state > 0) then
				if GHI_IconsInPage.buffer then
					GHI_RecieveLineCalculationBuffer(GHI_IconsInPage.state);
				else
					GHI_RecieveLineCalculation(GHI_IconsInPage.state);
				end
			end
		end
		
		
	end
	OldAA = a;
end


function GHI_EachSec()
	GHI_CheckTimeoutedMsg()
	GHI_CheckTarget()
	
	GHI_SendBufferData();
	GHI_InThisSec = 0;
	GHI_OutThisSec = 0;
	
	GHI_RunActionsInQueue()
	GHI_LastInc = {}
	
	
	GHI_MessageErrorsExpected_B = GHI_MessageErrorsExpected_A;
	GHI_MessageErrorsExpected_A = {};
	
	GHI_DeleteDurationWatchlistItems()
end

function GHI_EachTenSec()
	
end

function GHI_EachMin()
	GHI_UpdateDurationWatchlist();
end


function GHI_ConvertToNum(str)
	local num = tonumber(str)
	if num then
		if tostring(num) == str then
			return num;
		end
	end
	return str;
end

function GHI_CheckOfficialData()
	if not(type(GHI_OfficialItemData) == "table") then
		GHI_OfficialItemData = GHI_RawOfficialItemData;
	elseif not(GHI_OfficialItemData["version"]) then
		GHI_OfficialItemData = GHI_RawOfficialItemData;
	elseif not(tonumber(GHI_OfficialItemData["version"])) then
		GHI_OfficialItemData = GHI_RawOfficialItemData;
	elseif GHI_RawOfficialItemData["version"] > GHI_OfficialItemData["version"] then
		GHI_OfficialItemData = GHI_RawOfficialItemData;
	else
	
	end
	if not(GHD_AddSharedArray == nil) then
		GHD_AddSharedArray("GHI_OfficialItemData");
	end
	
	if not(GHI_MiscData["BetaManualCreated"] == true) and GHI_CountItem(1) == 0 then
		local bag,slot = GHI_GetFreeSpace();
		--GHI_Message("Found "..bag..", "..slot);
		--GHI_PlaceCopiedItem(bag,slot,1,1)
		local info = {};
		info.ID = 1;
		info.amount = 1;
		--GHI_SetContainerInfo(bag,slot,info)
		GHI_MiscData["BetaManualCreated"] = true;
		GHI_Message("GHI Manual created.");
	end
end





