

GHU_Mail = {}
GHU_Mail.__index = GHU_Mail;
GHU_Mail.hooked ={};

-- 	standard
function GHU_Mail:Create(varName,name)
		
	setglobal(varName,GHU_Mail); 
	
	local obj = {}             -- our new object
	setmetatable(obj, getglobal(varName))  -- make GHU_Mail handle lookup
	obj.headerName = name;      -- initialize our object

	obj.SelectedSkill = 0;
	
	setglobal(varName,obj);
	
	obj:InitHooks(varName);  
end
	
function GHU_Mail:Hook(funcName,varName)
	
	if not(type(self.orig)=="table") then self.orig ={}; end
	assert(type(self[funcName])=="function","No function found for "..funcName);
	self.orig[funcName] = getglobal(funcName);
		
	RunScript("local t = getglobal(\""..varName.."\"); t[\"hooked\"][\""..funcName.."\"] = function(...) gself = getglobal(\""..varName.."\"); local f = getglobal(\""..varName.."\"); return f:"..funcName.."(...); end setglobal(\""..varName.."\",t); ");
	setglobal(funcName,getglobal(varName)["hooked"][funcName]);
end

function GHU_Mail:InitHooks(varName)
	if not(self.isHooked) then
		local obj = getglobal(varName);
		
		self:Hook("GetInboxItem",varName)
		self:Hook("GetInboxHeaderInfo",varName)
		self:Hook("GetInboxNumItems",varName)
		self:Hook("GetLatestThreeSenders",varName)
		self:Hook("GetInboxText",varName)
		
		--self:Hook("PlaySound",varName)
		
		self.isHooked = true;
	end
end

-- Hooking
function GHU_Mail:GetInboxItem(index, itemIndex)
	self = gself; -- give self info for hooked functions
	if index == 2 and itemIndex == 1 then
		return "Document","Interface\\Icons\\INV_Letter_05",0,3,1;
	end
	return self.orig.GetInboxItem(index, itemIndex);
end

function GHU_Mail:GetInboxHeaderInfo(index)
	self = gself; -- give self info for hooked functions
	if index == 2 then
		local packageIcon, stationeryIcon, sender, subject, money, CODAmount, daysLeft, hasItem, wasRead, wasReturned, textCreated, canReply, isGM;
		packageIcon =nil;
		stationeryIcon = "Interface\\Icons\\INV_Letter_05";
		sender="Stormwind Council";
		subject="The Gryphonheart Project";
		money=0;
		CODAmount=0;
		daysLeft=10;
		wasRead=true;
		isGM=true;
		return packageIcon, stationeryIcon, sender, subject, money, CODAmount, daysLeft, hasItem, wasRead, wasReturned, textCreated, canReply, isGM;	
	end
	return self.orig.GetInboxHeaderInfo(index);
end

function GHU_Mail:GetInboxNumItems()
	self = gself; -- give self info for hooked functions
	return self.orig.GetInboxNumItems() + 1;
end

function GHU_Mail:GetInboxText(index)
	self = gself; -- give self info for hooked functions
	if index == 2 then
		return "Greetings Pioneer "..UnitName("player").."\n\nTo improve the trade situation the Stormwind Council have issued some new initiatives. The initiatives involves more organised professions and is know as Gryphonheart Project.\n\nRegards\nThe Councilor of Trade and Resources.","STATIONERYTEST";
	end
	return self.orig.GetInboxText(index);
end

function GHU_Mail:GetLatestThreeSenders()
	self = gself; -- give self info for hooked functions
	return "Ian Drake","Stormwind Council";
end
--[[ 	
	/script GHU_New("Mail","GHP_Mail");
	
--]]--

function GHU_Mail:NewMail()

end


