﻿-- test

local timersSetup;
local timers = {};

function GHU_New(Type,name,arg1)
	local varName;
	local c = 1000;
	while (varName == nil) do
		if (getglobal("GHU_"..c) == nil) then
			varName = "GHU_"..c;
		end
		c = c+1;
	end
	Type = strlower(Type);
	
	if Type=="skill" then
		GHU_Skill:Create(varName,name);
	elseif Type=="npc" then
		GHU_NPC:Create(varName);
	elseif Type=="mail" then
		GHU_Mail:Create(varName);
	elseif Type=="achievement" then
		GHU_Achievement:Create(varName,name);
	elseif Type=="profession" then
		error("Profession GHU dosent exsist. Use craft");
	elseif Type=="cast" then
		GHU_Cast:Create(varName);
	elseif Type=="loot" then
		GHU_Loot:Create(varName);
	elseif Type=="book" then
		GHU_Book:Create(varName);
	elseif Type=="questlog" then
		GHU_QL:Create(varName);
	elseif Type=="talent" then
		GHU_Talent:Create(varName,name,arg1); -- arg1 being icon 
	elseif Type=="craft" then
		GHU_Craft:Create(varName);
	elseif Type=="buff" then
		GHU_Buff:Create(varName);
	elseif Type=="target" then
		GHU_Target:Create(varName);
	end
	
	if not(timersSetup) then
		local Old_Script = WorldFrame:GetScript("OnUpdate");
		WorldFrame:SetScript("OnUpdate", function(self, elapsed) Old_Script(self, elapsed); GHU_OnWF(); end);
	
	end
	
	return getglobal(varName);
end

function GHU_RegTimer(s,func)
	table.insert(timers,{s = s, func = func});
end

function GHU_OnWF()
	for _,t in pairs(timers) do
		--print(type(t.s));
		t.func(t.s);
	end

end



