GHI_ActionBarData = {};

--[[
Action bar ID's:
	Main action bar page 1
	buttom left = 6
	buttom right = 5
	right = 3
	left = 4;	

]]

function GHI_GetActionBarData(bar,slot)
	if not(bar) then return nil; end
	bar = tonumber(bar);
	if not(bar) then return nil; end
	
	if not(slot) then return nil; end
	slot = tonumber(slot);
	if not(slot) then return nil; end
	
	if bar > 11 or bar < 1 or slot > 12 or slot < 1 then
		return;
	end
	
	if not(type(GHI_ActionBarData)=="table") then
		GHI_ActionBarData = {};	
	end
	
	if not(type(GHI_ActionBarData[bar])=="table") then
		GHI_ActionBarData[bar] = {};	
	end
	
	return GHI_ActionBarData[bar][slot];
end

function GHI_SetActionBarData(bar,slot,id)
	if not(bar) then return nil; end
	bar = tonumber(bar);
	if not(bar) then return nil; end
	
	if not(slot) then return nil; end
	slot = tonumber(slot);
	if not(slot) then return nil; end
	
		
	if bar > 11 or bar < 1 or slot > 12 or slot < 1 then
		return;
	end
	
	if not(type(GHI_ActionBarData)=="table") then
		GHI_ActionBarData = {};	
	end
	
	if not(type(GHI_ActionBarData[bar])=="table") then
		GHI_ActionBarData[bar] = {};	
	end
	
	GHI_ActionBarData[bar][slot] = id;
	
end

function GHI_ActionbarHookings()
	
	

	
end


GHI_Barnames = {};
GHI_Barnames[6] = "GHIMultiBarBottomLeft";
GHI_Barnames[5] = "GHIMultiBarBottomRight";
GHI_Barnames[3] = "GHIMultiBarRight";
GHI_Barnames[4] = "GHIMultiBarLeft";

function GHI_ShowAllActionbars()
	for i=3,6 do
		local barName = GHI_Barnames[i];
		local bar = getglobal(barName);
		if not(bar) then
			break
		end
		local relatedBar = getglobal(gsub(barName,"GHI",""));
		
		if relatedBar:IsShown() then
			bar:Show(); 
			for j=1,12 do
				local id = GHI_GetActionBarData(i,j);
				local button = getglobal(barName.."Button"..j);
				if button then
					button:Show();
				end
			end
			bar:SetFrameLevel(relatedBar:GetFrameLevel()+1);
		else
			bar:Hide();
		end
	end
end

function GHI_HideUnusedActionbars()
		
	for i=3,6 do
		local barName = GHI_Barnames[i];
		local bar = getglobal(barName);
		if not(bar) then
			break
		end
		local relatedBar = getglobal(gsub(barName,"GHI",""));
		
		bar:Hide();
		if relatedBar:IsShown() then
			bar:Show(); 
		end
		
		
		for j=1,12 do
			local id = GHI_GetActionBarData(i,j);
			local button = getglobal(barName.."Button"..j);
			if button then
				if id then
					button.itemID = id;					
					button:Show();
				
				else
					button:Hide();
				
				end	
			end
		end
		bar:SetFrameLevel(relatedBar:GetFrameLevel()+1);
		--GHI_Message("Set level: "..relatedBar:GetFrameLevel());
	end
end



function GHI_ActionSlotButton_OnLoad()
	
	
	this:RegisterForDrag("LeftButton", "RightButton");
	this:RegisterForClicks("AnyUp");

end

function GHI_ActionSlotButton_OnUpdate()
	
	local id = this.itemID;
	local icon = getglobal(this:GetName().."Icon");
	local normalTexture = getglobal(this:GetName().."NormalTexture");
	local name,texture = GHI_GetItemInfo(id);
	local barName = this:GetParent():GetName();
	local bar = getglobal(barName);
	local relatedBar = getglobal(gsub(barName,"GHI",""));
	local buttonCooldown = getglobal(this:GetName().."Cooldown");
	local count = getglobal(this:GetName().."Count");
	
	if not(InCombatLockdown()) then
		bar:SetFrameLevel(relatedBar:GetFrameLevel()+1);
	end
	
	if name then
		if ( texture ) then
			icon:SetTexture(texture);
			icon:Show();
			this.rangeTimer = -1;
			this:SetNormalTexture("Interface\\Buttons\\UI-Quickslot2");
			
			
			local amount = GHI_CountItem(id);
			if GHP then
				amount = GHP:CountItem(id,true);
			end
			
			if amount == 1 then
				count:SetText("");
			else 
				count:SetText(amount);
			end
			
			if ( amount == 0 ) then
				icon:SetVertexColor(0.4, 0.4, 0.4);
				--normalTexture:SetVertexColor(1.0, 1.0, 1.0);
			else
				icon:SetVertexColor(1.0, 1.0, 1.0);
				--normalTexture:SetVertexColor(1.0, 1.0, 1.0);
			end
			
			GHI_ActionSlotButton_UpdateCooldown(id, this)
			
		else
			icon:Hide();
			buttonCooldown:Hide();
			this.rangeTimer = nil;
			this:SetNormalTexture("Interface\\Buttons\\UI-Quickslot");
			
			
			count:SetText("");
		end
	elseif id then -- remove the item from action bar if id is illigal
		local barNum = nil;
		for index,value in pairs(GHI_Barnames) do 
			if barName == value then
				barNum = index;
			end
		end
		GHI_SetActionBarData(barNum,this:GetID(),nil);
		this.itemID = nil;
		this:Hide();
	else
		icon:Hide();
		buttonCooldown:Hide();
		count:SetText("");

	end
	
	if ( this.updateTooltipTime ) then
		--this.updateTooltip = this.updateTooltip - elapsed;
		if ( time() - this.updateTooltipTime < 1 ) then
			--GHI_Message("C");
			return;
		end
	end
	this.UpdateTooltip = nil;
	
	--GHI_Message("A");
	if ( GameTooltip:IsOwned(this) ) then --GHI_Message("B");
		GHI_ActionSlotButton_OnEnter(this);
		this.updateTooltipTime = time();
	end
end

function GHI_ActionSlotButton_OnEnter()
	if this.itemID then
		if ( GetCVar("UberTooltips") == "1" ) then
			GameTooltip_SetDefaultAnchor(GameTooltip, this);
		else
			if ( this:GetParent() == GHIMultiBarBottomRight or this:GetParent() == GHIMultiBarRight or this:GetParent() == GHIMultiBarLeft ) then
				GameTooltip:SetOwner(this, "ANCHOR_LEFT");
			else
				GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
			end
		end
		GHI_ItemTooltip(this,this.itemID);
		this.UpdateTooltip = nil;
	else
		local n = this:GetName();
		n=gsub(n,"GHI","");
		ActionButton_SetTooltip(getglobal(n));
	end





end



function GHI_ActionSlotButton_OnClick(drag)
	this:SetChecked(nil);
	local id = this.itemID;
	
	local cursor = GHI_GetCursor();
	
	
	
	local relatedSlot = getglobal(gsub(this:GetName(),"GHI",""));
	local barNum = relatedSlot:GetParent():GetAttribute("actionpage");
	local slotNum = (barNum-1)*12 + relatedSlot:GetID();
	
	
	
	if arg1 == "right" and (( cursor == "item" or cursor == "item/ability" ) or GetCursorInfo() ) then
		if ( cursor == "item" or cursor == "item/ability" ) then 
			GHI_ResetCursor();
		end
	else
	
		 
		if not( cursor == "item" or cursor == "item/ability" ) and not(GetCursorInfo() ) and id then -- cursor is empty and slot got GHI
			if drag then
				-- pickup GHI
				local temp = {};
					
				local name,icon = GHI_GetItemInfo(id);
				
				temp.iconTexture = icon;
				temp.id = id;
				GHI_SetCursor("item/ability",temp);
				GHI_SetActionBarData(barNum,relatedSlot:GetID(),nil);
				this.itemID = nil;
				GHI_HideUnusedActionbars()
								
				
				GHI_ShowAllActionbars();
			else
				-- use item
				--GHI_Message("Use item");
				local bag,slot = GHI_FindItem(id)
				if GHP then
					bag,slot = GHP:FindItem(id,false,true);
				end
				if bag and slot then
					GHI_UseItem(bag,slot)
				end
			end
		elseif (GetCursorInfo() ) and id then --- curser has spell and slot got GHI
			-- place spell, pickup GHI   (give error if in combat)
			if InCombatLockdown()  then
				GHI_Message(GHI_IN_COMBAT_ERROR);
			else
				-- place the action
				PlaceAction(slotNum);
				-- pick up GHI
				local temp = {};
					
				local name,icon = GHI_GetItemInfo(id);
				
				temp.iconTexture = icon;
				temp.id = id;
				GHI_SetCursor("item/ability",temp);
				GHI_SetActionBarData(barNum,relatedSlot:GetID(),nil);
				this.itemID = nil;
				GHI_HideUnusedActionbars()
				
				GHI_ShowAllActionbars();
				
				
			end
		elseif ( cursor == "item" or cursor == "item/ability" ) and id then --- curser has GHI and slot got GHI
			-- place GHI pickup old GHI
			
			
			local _,details = GHI_GetCursor();
			local itemID = details.id;
			GHI_SetActionBarData(barNum,relatedSlot:GetID(),itemID);
			this.itemID = itemID;
			
			local temp = {};
				
			local name,icon = GHI_GetItemInfo(id);
			
			temp.iconTexture = icon;
			temp.id = id;
			GHI_SetCursor("item/ability",temp);
			
			GHI_HideUnusedActionbars();
			GHI_ShowAllActionbars();
		elseif ( cursor == "item" or cursor == "item/ability" ) and HasAction(slotNum) then --- curser has GHI and slot got Spell
			-- place GHI, pickup spell  (give error if in combat)
			if InCombatLockdown()  then
				GHI_Message(GHI_IN_COMBAT_ERROR);
			else
				-- place GHI
				local _,details = GHI_GetCursor();
				local itemID = details.id;
				GHI_SetActionBarData(barNum,relatedSlot:GetID(),itemID);
				this.itemID = itemID;
				
				GHI_HideUnusedActionbars();
				GHI_ResetCursor();
				
				PickupAction(slotNum);
			end
			
		elseif ( cursor == "item" or cursor == "item/ability" ) and not(id) and not(HasAction(slotNum)) then --- curser has GHI and slot is empty
			-- place GHI
			local _,details = GHI_GetCursor();
			local itemID = details.id;
			GHI_SetActionBarData(barNum,relatedSlot:GetID(),itemID);
			this.itemID = itemID;
			
			GHI_HideUnusedActionbars();
			GHI_ResetCursor();
		end
		
	
		
	
	end
	
	

end


function GHI_ActionSlotButton_UpdateCooldown(ID, button)
	
	local cooldown = getglobal(button:GetName().."Cooldown");
	if not(button) then 
		return
	end
	
	
	local rightClick = GHI_GetRightClickInfo(ID)
	local start, duration, enable;
	start = GHI_CooldownData[ID];
	
	if start == nil then start = 0; end
	if start > GetTime() then start = 0 end
	
	if not(type(rightClick)=="table") or not(rightClick.CD) then
		duration = 0;
		enable = 0;
	else
		duration = rightClick.CD;
		enable = 1;
	end
	
	if start + duration < GetTime() then start = 0; end
	
	
	CooldownFrame_SetTimer(cooldown, start, duration, enable);
	
	if ( duration > 0 and enable == 0 ) then
		SetItemButtonTextureVertexColor(button, 0.4, 0.4, 0.4);
	end
end

--]]