GrindLoot_MetalStone = {  [17771]=60, [18562]=60, [17203]=60, [12360]=55, [23447]=70, [23427]=70, [23448]=60, [3577]=30, [2776]=25, [12809]=60, [35128]=70, [23449]=70, [23426]=70, [2842]=10, [2775]=10, [6037]=50, [7911]=40, [23446]=65, [23425]=65, [2841]=20, [3857]=30, [3478]=20, [2836]=15, [2840]=10, [2770]=10, [11371]=50, [11370]=50, [12644]=45, [12365]=45, [18567]=60, [12655]=55, [23445]=60, [23424]=60, [23573]=65, [22202]=1, [7966]=35, [7912]=35, [3859]=35, [12359]=50, [10620]=40, [3576]=20, [2771]=20 };
GrindLoot_Cloth = { [21845]=70, [24272]=70, [24271]=70, [21842]=66, [2996]=10, [4339]=45, [21840]=60, [14048]=55, [4305]=35, [21844]=70, [2997]=25, [2320]=5, [14256]=50, [2321]=20, [8343]=40, [14227]=50, [2589]=5, [4338]=40, [14342]=55, [21877]=60, [21881]=60, [14341]=50, [14047]=50, [10285]=40, [4306]=30, [4291]=30, [3182]=20, [4337]=35, [2592]=15 };
GrindLoot_Elementals = { [23571]=65, [7082]=55, [7076]=55, [7078]=55, [12808]=55, [7080]=55, [12803]=55, [22451]=65, [22452]=65, [21884]=65, [21886]=65, [22457]=65, [22456]=65, [21885]=65, [7081]=45, [7075]=45, [7069]=25, [7067]=25, [7068]=25, [7070]=25, [7079]=45, [7077]=45, [10286]=45, [7972]=45, [22572]=65, [22573]=65, [22574]=65, [22575]=65, [22576]=65, [22577]=65, [22578]=65 };
GrindLoot_Enchanting = { [20725]=60, [22450]=70, [14344]=55, [11084]=25, [11139]=35, [22449]=70, [11178]=45, [22463]=61, [14343]=50, [10978]=20, [11138]=30, [22448]=65, [11177]=40, [11082]=25, [16203]=55, [10939]=15, [11135]=35, [11175]=45, [22446]=65, [10998]=20, [16202]=50, [10938]=10, [11134]=30, [11174]=40, [22447]=60, [22462]=61, [25844]=70, [22445]=60, [16206]=55, [6217]=5, [11176]=45, [25845]=75, [25843]=60, [11128]=30, [16204]=55, [16207]=58, [6218]=5, [22461]=61, [11130]=30, [6339]=20, [11145]=40 };
GrindLoot_Herbs = { [19727]=60, [13468]=60, [19726]=60, [22790]=68, [8836]=44, [8839]=47, [22710]=5, [2450]=15, [2453]=20, [13463]=54, [22786]=60, [2449]=5, [3818]=32, [22794]=75, [22785]=60, [4625]=41, [22788]=67, [8845]=47, [13464]=52, [3821]=34, [3369]=24, [8846]=50, [13467]=58, [3358]=37, [3356]=24, [3357]=30, [785]=10, [22793]=75, [13465]=56, [22791]=70, [22797]=73, [22792]=73, [2447]=5, [13466]=57, [8831]=42, [22787]=65, [765]=5, [3820]=20, [8838]=46, [2452]=15, [22789]=60, [3355]=22, [8153]=40 };
GrindLoot_Leather = { [17967]=60, [15410]=60, [20381]=63, [15416]=55, [7286]=1, [15415]=50, [15423]=50, [29539]=60, [17012]=60, [25699]=60, [4236]=30, [4231]=10, [4233]=20, [15407]=50, [8172]=40, [8150]=40, [6470]=1, [15417]=50, [12810]=55, [25707]=70, [25700]=60, [15422]=50, [15412]=50, [7392]=1, [4235]=30, [23793]=65, [4234]=30, [15408]=55, [20501]=55, [15420]=50, [8168]=45, [21887]=60, [25649]=60, [783]=10, [2318]=10, [20500]=55, [5116]=1, [4232]=20, [2319]=20, [29548]=60, [20498]=30, [20498]=55, [5784]=15, [25708]=60, [8169]=40, [4304]=40, [5785]=35, [8368]=40, [5082]=10, [8167]=35, [15419]=50, [29547]=60, [8165]=45 };
GrindLoot_Meat = { [27422]=60, [27669]=5, [35562]=50, [3173]=11, [3730]=21, [33823]=65, [3172]=10, [2677]=14, [27671]=60, [3404]=35, [21024]=60, [27677]=60, [769]=5, [5503]=14, [27678]=60, [2673]=10, [2886]=5, [2675]=13, [2674]=13, [33824]=65, [1081]=15, [2924]=14, [22644]=15, [13888]=55, [27435]=60, [27439]=60, [4655]=35, [12207]=45, [35285]=70, [27438]=60, [2251]=25, [723]=12, [731]=12, [2296]=16, [12204]=35, [27437]=60, [24477]=65, [5467]=10, [1015]=19, [3731]=23, [27668]=5, [12223]=5, [23676]=1, [730]=11, [1468]=16, [12037]=30, [3685]=22, [12184]=30, [31670]=60, [27674]=60, [21071]=35, [21071]=20, [6303]=5, [8959]=55, [4603]=45, [13756]=45, [13760]=45, [13889]=55, [12203]=30, [20424]=55, [5466]=8, [31671]=60, [6889]=5, [5465]=5, [5468]=15, [3174]=10, [27425]=60, [5471]=23, [2665]=1, [27676]=60, [5469]=10, [729]=10, [2672]=5, [27682]=60, [5504]=23, [12206]=40, [3667]=23, [12208]=40, [5470]=22, [12202]=30, [1080]=15, [3712]=30, [27681]=60, [12205]=40, [27429]=60, [7974]=45, [37588]=35 };
GrindLoot_Potions ={ [32947]=65, [32948]=68, [32902]=68, [32905]=65, [5632]=25, [33934]=60, [33935]=62, [22839]=70, [4596]=15, [12190]=45, [31677]=72, [31676]=69, [6049]=33, [5634]=30, [6050]=38, [5633]=35, [13461]=58, [20002]=60, [13457]=58, [13456]=58, [1710]=31, [13460]=58, [6149]=41, [13458]=58, [13459]=58, [22849]=73, [22849]=73, [2633]=32, [858]=13, [3823]=33, [3385]=24, [4623]=43, [3387]=50, [20008]=57, [34440]=75, [9036]=42, [22845]=72, [32840]=72, [22836]=70, [22841]=72, [32846]=72, [22842]=72, [32847]=72, [17348]=55, [13446]=55, [22847]=72, [17351]=55, [13444]=59, [22844]=72, [32844]=72, [18253]=60, [22846]=72, [2455]=22, [2455]=15, [2456]=15, [3087]=15, [6052]=38, [13462]=57, [5631]=14, [9030]=42, [32762]=68, [32763]=65, [6048]=27, [22871]=67, [22826]=63, [3388]=25, [22829]=65, [22832]=68, [22850]=75, [17349]=45, [3928]=45, [17352]=45, [13443]=51, [2459]=15, [6372]=20, [25548]=50, [28101]=62 };
GrindLoot_Scrolls = { [3012]=20, [1477]=35, [4425]=50, [10309]=65, [27498]=70, [955]=15, [2290]=30, [4419]=45, [10308]=60, [27499]=70, [3013]=10, [1478]=25, [4421]=40, [10305]=55, [27500]=70, [1181]=10, [1712]=25, [4424]=40, [10306]=55, [27501]=70, [1180]=15, [1711]=30, [4422]=45, [10307]=60, [27502]=70, [954]=20, [2289]=35, [4426]=50, [10310]=65, [27503]=70 };
GrindLoot_Pickpocket = { [16882]=1, [16883]=70, [16884]=175, [16885]=250, [29569]=300, [4632]=1, [4633]=25, [4634]=70, [4636]=125, [4637]=175, [4638]=225, [5758]=225, [5759]=225, [5760]=225, [31952]=325 }
GrindLoot_RarityLevels = { [1]="|cff9d9d9d Disabled|r", [2]="|cff1eff00 Uncommon|r", [3]="|cff0070dd Rare|r", [4]="|cffa335ee Epic|r", [5]="|cffff8000 Legendary|r", [6]="Only |cffe5cc80 Artifacts|r" };
GrindLoot_LevelNames = { [0]="|cff9d9d9d Disabled|r", [1]="All", [2]=">=10", [3]=">=20", [4]=">=30", [5]=">=40", [6]=">=50", [7]=">=60", [8]=">=70" };
GrindLoot_LevelLevels = { [0]=255, [1]=1, [2]=10, [3]=20, [4]=30, [5]=40, [6]=50, [7]=60, [8]=70 };

function GrindLootConfigFrame_OnShow()
    GrindLootLevel_MetalStone:SetValue(GLootLevels["GrindLootLevel_MetalStone"]);
    GrindLootLevel_Cloth:SetValue(GLootLevels["GrindLootLevel_Cloth"]);
    GrindLootLevel_Elementals:SetValue(GLootLevels["GrindLootLevel_Elementals"]);
    GrindLootLevel_Enchanting:SetValue(GLootLevels["GrindLootLevel_Enchanting"]);
    GrindLootLevel_Potions:SetValue(GLootLevels["GrindLootLevel_Potions"]);
    GrindLootLevel_Pickpocket:SetValue(GLootLevels["GrindLootLevel_Pickpocket"]);
    GrindLootLevel_Leather:SetValue(GLootLevels["GrindLootLevel_Leather"]);
    GrindLootLevel_Meat:SetValue(GLootLevels["GrindLootLevel_Meat"]);
    GrindLootLevel_Herbs:SetValue(GLootLevels["GrindLootLevel_Herbs"]);
    GrindLootLevel_Scrolls:SetValue(GLootLevels["GrindLootLevel_Scrolls"]);	
	GrindLootGrayWeapon:SetChecked(GLootLevels["GrindLootGrayWeapon"]);

	if(GLootEnabled==1) then
		ButtonENDISText:SetText("Disable GrindLoot");
	else
		ButtonENDISText:SetText("Enable GrindLoot");
	end
end

function GrindLootConfigFrame_OnLoad()
	SlashCmdList["GLOOT"] = GrindLootConfigFrame_OnOff;
	SLASH_GLOOT1 = "/grindloot";
	SLASH_GLOOT2 = "/gloot"; -- A shortcut or alias
	GrindLootLevel_MetalStoneText:SetText("Metal&Stone Level");
	GrindLootLevel_ClothText:SetText("Cloth Level");
	GrindLootLevel_ElementalsText:SetText("Elemental Reagents Level");
	GrindLootLevel_EnchantingText:SetText("Enchanting Reagents Level");
	GrindLootLevel_HerbsText:SetText("Herbalism Reagents Level");
	GrindLootLevel_LeatherText:SetText("Leather Level");
	GrindLootLevel_MeatText:SetText("Meats Level");
	GrindLootLevel_PotionsText:SetText("Potions Level");
	GrindLootLevel_ScrollsText:SetText("Scrolls Level");
	GrindLootLevel_PickpocketText:SetText("Pickable Level");
	GrindLootLevel_RarityText:SetText("Item Rarity Level");
end

function GrindLootConfigFrame_OnOff()
	if (GrindLootConfigFrame:IsVisible()) then
		GrindLootConfigFrame:Hide();
	else
		GrindLootConfigFrame:Show();
	end
end

function GrindLootBoxFrame_OnShow()
	if(GLootEnabled==1) then
		GLEnableDisableText:SetText("Disable");
	else
		GLEnableDisableText:SetText("Enable");
	end
end

function GrindLootBoxFrame_OnLoad()
	GrindLoot_ResetConfig();
	this:RegisterEvent("LOOT_OPENED");
	this:RegisterEvent("LOOT_CLOSED");
	this:RegisterEvent("VARIABLES_LOADED");
end

function GrindLoot_OnEvent(event)
	if ( event == "LOOT_OPENED" ) then
		GrindLootBoxFrame:ClearAllPoints();
		GrindLootBoxFrame:SetPoint("TOPLEFT","LootFrame","BOTTOMLEFT",0,-20);
		GrindLootBoxFrame:Show();
		LootIt();
	end
	if ( event == "LOOT_CLOSED" ) then
		GrindLootBoxFrame:Hide();
	end	
	if ( event == "VARIABLES_LOADED" ) then
		if(not GLootLevels["GrindLootLevel_Cloth"])then GLootLevels["GrindLootLevel_Cloth"]=1; end;
		if(not GLootLevels["GrindLootLevel_Enchanting"])then GLootLevels["GrindLootLevel_Enchanting"]=1; end;
		if(not GLootLevels["GrindLootLevel_Leather"])then GLootLevels["GrindLootLevel_Leather"]=1; end;
		if(not GLootLevels["GrindLootLevel_Rarity"])then GLootLevels["GrindLootLevel_Rarity"]=2; end;
		if(not GLootLevels["GrindLootLevel_Meat"])then GLootLevels["GrindLootLevel_Meat"]=1; end;
		if(not GLootLevels["GrindLootLevel_Pickpocket"])then GLootLevels["GrindLootLevel_Pickpocket"]=1; end;
		if(not GLootLevels["GrindLootLevel_Scrolls"])then GLootLevels["GrindLootLevel_Scrolls"]=1; end;
		if(not GLootLevels["GrindLootLevel_Elementals"])then GLootLevels["GrindLootLevel_Elementals"]=1; end;
		if(not GLootLevels["GrindLootLevel_Herbs"])then GLootLevels["GrindLootLevel_Herbs"]=1; end;
		if(not GLootLevels["GrindLootLevel_Potions"])then GLootLevels["GrindLootLevel_Potions"]=1; end;
		if(not GLootLevels["GrindLootLevel_MetalStone"])then GLootLevels["GrindLootLevel_MetalStone"]=1; end;
		if(not GLootLevels["GrindLootGrayWeapon"])then GLootLevels["GrindLootGrayWeapon"]=1; end;
	end	
end

function GrindLoot_ResetConfig()
	GLootEnabled=1;
	GLootCustom={};
	GLootTypes={};
	GLootLevels={};
	GrindItemsDB={};
	GLootLevels = {
		["GrindLootLevel_Cloth"] = 1,
		["GrindLootLevel_Enchanting"] = 1,
		["GrindLootLevel_Leather"] = 1,
		["GrindLootLevel_Rarity"] = 2,
		["GrindLootLevel_Meat"] = 1,
		["GrindLootLevel_Pickpocket"] = 1,
		["GrindLootLevel_Scrolls"] = 1,
		["GrindLootLevel_Elementals"] = 1,
		["GrindLootLevel_Herbs"] = 1,
		["GrindLootLevel_Potions"] = 1,
		["GrindLootLevel_MetalStone"] = 1,
		["GrindLootGrayWeapon"] = 1,
	}
end

function GrindLoot_ConfigToDefault()
	GrindLoot_ResetConfig();
	GrindLootConfigFrame:Hide();
	GrindLootConfigFrame:Show();
end

function GrindLootConfigFrame_OnClick()
	if ( this:GetName() == "GrindLootGrayWeapon" ) then 
		GLootLevels["GrindLootGrayWeapon"]=this:GetChecked(); 
		if(this:GetChecked()) then Gchattext("AutoLooting of high level gray weapons set to ON!"); else Gchattext("AutoLooting of high level gray weapons set to OFF!"); end
	end
end

function GrindLoot_Disable()
	if(GLootEnabled==1) then
		GLootEnabled=0;
	else 
		GLootEnabled=1;
	end
	if(GLootEnabled==1) then
		GLEnableDisableText:SetText("Disable");
		ButtonENDISText:SetText("Disable GrindLoot");
		Gchattext("AutoLooting set to ON!");
	else
		GLEnableDisableText:SetText("Enable");
		ButtonENDISText:SetText("Enable GrindLoot");
		Gchattext("AutoLooting set to OFF!");
	end
end


local function GetLootId( slot )
	local itemId = 0
	local link = GetLootSlotLink( slot )

	if link then
		local _, _, idCode = string.find(link, "|Hitem:(%d+):(%d+):(%d+):")
		itemId = tonumber( idCode or 0 )
	end

	return itemId
end

local function GetLinkId( link )
	local itemId = 0
	if link then
		local _, _, idCode = string.find(link, "|Hitem:(%d+):(%d+):(%d+):")
		itemId = tonumber( idCode or 0 )
	end

	return itemId
end

function Gchattext(txt)
	if( DEFAULT_CHAT_FRAME ) then
		DEFAULT_CHAT_FRAME:AddMessage( "|cff00e0ff"..txt )
	end
end

function Gchattext2(txt)
	if( DEFAULT_CHAT_FRAME ) then
		DEFAULT_CHAT_FRAME:AddMessage( txt )
	end
end

function LootIt()
	if(GLootEnabled~=1) then return; end
	
	local inbag={};
	
	for b = 0,4 do
		if(GetBagName(b))then
			local ns=GetContainerNumSlots(b);
			for s = 0,ns do
				local blink = GetContainerItemLink(b,s);
				if(blink)then
					local lid = GetLinkId(blink);
					inbag[lid]=1;
				end
			end
		end
	end

	local cnt = GetNumLootItems();
	if cnt == 0 then
		Gchattext( "Empty loot" )
		CloseLoot()
		return;
	end
	
	for slotnum = 1, cnt do
		local canloot = false;
		local texture, itemName, quantity, quality = GetLootSlotInfo(slotnum)
	    	local itemID = GetLootId( slotnum )
	    local itemName2, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc = GetItemInfo(itemID)
	
		local txt = itemName2;
		if itemRarity ~=nil then txt = txt.." -> itemRarity="..itemRarity end
		if itemType ~=nil then txt = txt..", itemType="..itemType end
		if itemSubType ~=nil then txt = txt..", itemSubType="..itemSubType end
	
		if(LootSlotIsCoin(slotnum))then
			local itemNamex="";
		else
			GrindItemsDB[itemID]=txt;
		end
		     
		if(inbag[itemID])then
			canloot = true;
		end;
	        
		if(itemType=="Quest")then
			canloot = true;
		end
	
		if(itemType=="Key") then
			canloot = true;
		end

	    if(GrindLoot_MetalStone[itemID])and(GrindLoot_MetalStone[itemID]>=GrindLoot_LevelLevels[GLootLevels["GrindLootLevel_MetalStone"]])then canloot = true; end;
	    if(GrindLoot_Cloth[itemID])and(GrindLoot_Cloth[itemID]>=GrindLoot_LevelLevels[GLootLevels["GrindLootLevel_Cloth"]])then canloot = true; end;
	    if(GrindLoot_Elementals[itemID])and(GrindLoot_Elementals[itemID]>=GrindLoot_LevelLevels[GLootLevels["GrindLootLevel_Elementals"]])then canloot = true; end;
	    if(GrindLoot_Enchanting[itemID])and(GrindLoot_Enchanting[itemID]>=GrindLoot_LevelLevels[GLootLevels["GrindLootLevel_Enchanting"]])then canloot = true; end;
	    if(GrindLoot_Potions[itemID])and(GrindLoot_Potions[itemID]>=GrindLoot_LevelLevels[GLootLevels["GrindLootLevel_Potions"]])then canloot = true; end;
	    if(GrindLoot_Pickpocket[itemID])and(GrindLoot_Pickpocket[itemID]>=GrindLoot_LevelLevels[GLootLevels["GrindLootLevel_Pickpocket"]])then canloot = true; end;
	    if(GrindLoot_Leather[itemID])and(GrindLoot_Leather[itemID]>=GrindLoot_LevelLevels[GLootLevels["GrindLootLevel_Leather"]])then canloot = true; end;
	    if(GrindLoot_Meat[itemID])and(GrindLoot_Meat[itemID]>=GrindLoot_LevelLevels[GLootLevels["GrindLootLevel_Meat"]])then canloot = true; end;
	    if(GrindLoot_Herbs[itemID])and(GrindLoot_Herbs[itemID]>=GrindLoot_LevelLevels[GLootLevels["GrindLootLevel_Herbs"]])then canloot = true; end;
	    if(GrindLoot_Scrolls[itemID])and(GrindLoot_Scrolls[itemID]>=GrindLoot_LevelLevels[GLootLevels["GrindLootLevel_Scrolls"]])then canloot = true; end;
	    if(quality>=GrindLoot_LevelLevels[GLootLevels["GrindLootLevel_Rarity"]])then canloot = true; end;

		if LootSlotIsCoin(slotnum) then
			canloot = true;
		end
		
		if(itemType=="Weapon")and(itemLevel>45)and(GLootLevels["GrindLootGrayWeapon"])then
			canloot = true;
		end
		
		if(canloot)then 
			LootSlot(slotnum); 
		end
	end
	
	inbag={};
	
end
