-- -------------------------------------------------------------------------- --
-- GridIndicatorCornerPlus by kunda                                           --
-- -------------------------------------------------------------------------- --

local GridFrame = Grid:GetModule("GridFrame")
local L = GridIndicatorCornerPlus_Locales
local AceOO = AceLibrary("AceOO-2.0")
local configMode = false

local GridIndicatorCornerPlus = Grid:GetModule("GridStatus"):NewModule("GridIndicatorCornerPlus")

GridIndicatorCornerPlus.defaultDB = {
	CornerPlusSpace = 1,
	CornerPlusSize = 5,
	CornerPlusOriginalSize = true,
}

local indicators = GridFrame.frameClass.prototype.indicators
table.insert(indicators, { type = "cornerPlusTLtopright",    order = 8.61,  name = L["Top Left Corner (top right)"] })
table.insert(indicators, { type = "cornerPlusTLbottomleft",  order = 8.62,  name = L["Top Left Corner (bottom left)"] })
table.insert(indicators, { type = "cornerPlusTLbottomright", order = 8.63,  name = L["Top Left Corner (bottom right)"] })
table.insert(indicators, { type = "cornerPlusTRtopleft",     order = 9.61,  name = L["Top Right Corner (top left)"] })
table.insert(indicators, { type = "cornerPlusTRbottomleft",  order = 9.62,  name = L["Top Right Corner (bottom left)"] })
table.insert(indicators, { type = "cornerPlusTRbottomright", order = 9.63,  name = L["Top Right Corner (bottom right)"] })
table.insert(indicators, { type = "cornerPlusBLtopleft",     order = 10.61, name = L["Bottom Left Corner (top left)"] })
table.insert(indicators, { type = "cornerPlusBLtopright",    order = 10.62, name = L["Bottom Left Corner (top right)"] })
table.insert(indicators, { type = "cornerPlusBLbottomright", order = 10.63, name = L["Bottom Left Corner (bottom right)"] })
table.insert(indicators, { type = "cornerPlusBRtopleft",     order = 11.61, name = L["Bottom Right Corner (top left)"] })
table.insert(indicators, { type = "cornerPlusBRtopright",    order = 11.62, name = L["Bottom Right Corner (top right)"] })
table.insert(indicators, { type = "cornerPlusBRbottomleft",  order = 11.63, name = L["Bottom Right Corner (bottom left)"] })

local statusmap = GridFrame.db.profile.statusmap
if not statusmap["cornerPlusTLtopright"] then
	statusmap["cornerPlusTLtopright"] = {}
	statusmap["cornerPlusTLbottomleft"] = {}
	statusmap["cornerPlusTLbottomright"] = {}
	statusmap["cornerPlusTRtopleft"] = {}
	statusmap["cornerPlusTRbottomleft"] = {}
	statusmap["cornerPlusTRbottomright"] = {}
	statusmap["cornerPlusBLtopleft"] = {}
	statusmap["cornerPlusBLtopright"] = {}
	statusmap["cornerPlusBLbottomright"] = {}
	statusmap["cornerPlusBRtopleft"] = {}
	statusmap["cornerPlusBRtopright"] = {}
	statusmap["cornerPlusBRbottomleft"] = {}
end

local GridIndicatorCornerPlusFrameClass = AceOO.Class(GridFrame.frameClass)

local _frameClass = nil
if not _frameClass then
	_frameClass = GridFrame.frameClass
	GridFrame.frameClass = GridIndicatorCornerPlusFrameClass
end

function GridIndicatorCornerPlus:OnEnable()
	self:CleanOptionsMenu() -- hack for better indicator menu

	GridFrame.options.args.advanced.args["cornerplus"] = {
		type = "group",
		icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-TRTLBLBR",
		name = L["Corner Plus"],
		desc = L["Options for Corner Plus."],
		order = 108,
		args = {
			["configuration"] = {
				type = "toggle",
				name = L["Configuration Mode"],
				desc = L["Shows all Corner Plus indicators."],
				order = 10,
				get = function()
					return configMode
				end,
				set = function(v) 
					configMode = v
					GridFrame:WithAllFrames(function(f) f:GridIndicatorCornerPlusConfig() end)
				end
			},
			["header1"] = {
				type = "header",
				order = 15,
				name = " ",
			},
			["cornerplusspace"] = {
				type = "range",
				name = L["Corner Plus Space"],
				desc = L["Adjust the space between the Corner Plus indicators."],
				order = 20,
				min = 0,
				max = 10,
				step = 1,
				get = function()
					return GridIndicatorCornerPlus.db.profile.CornerPlusSpace
				end,
				set = function(v)
					GridIndicatorCornerPlus.db.profile.CornerPlusSpace = v
					GridFrame:WithAllFrames(function(f) f:SetCornerSize(GridFrame.db.profile.cornerSize) end)
				end,
			},
			["cornerplusoriginalsize"] = {
				type = "toggle",
				name = L["Same size as Grid standard"],
				desc = L["If enabled, the size of the Corner Plus indicator is adjustable with the standard Grid corner option. If deactivated, you can set an individual size for the Corner Plus indicators."],
				order = 30,
				get = function()
					return GridIndicatorCornerPlus.db.profile.CornerPlusOriginalSize
				end,
				set = function(v)
					GridIndicatorCornerPlus.db.profile.CornerPlusOriginalSize = v
					GridFrame.options.args.advanced.args["cornerplus"].args["cornerplussize"].disabled = v
					GridFrame:WithAllFrames(function(f) f:SetCornerSize(GridFrame.db.profile.cornerSize) end)
				end,
			},
			["cornerplussize"] = {
				type = "range",
				name = L["Corner Plus Size"],
				desc = L["Adjust the size of the Corner Plus indicators."],
				order = 40,
				disabled = GridIndicatorCornerPlus.db.profile.CornerPlusOriginalSize,
				min = 5,
				max = 20,
				step = 1,
				get = function()
					return GridIndicatorCornerPlus.db.profile.CornerPlusSize
				end,
				set = function(v)
					GridIndicatorCornerPlus.db.profile.CornerPlusSize = v
					GridFrame:WithAllFrames(function(f) f:SetCornerSize(GridFrame.db.profile.cornerSize) end)
				end,
			}
		}
	}
	hooksecurefunc(GridFrame, "UpdateOptionsMenu", GridIndicatorCornerPlus.CleanOptionsMenu) -- hack for better indicator menu
	self:RegisterEvent("Grid_Enabled")
	self:RegisterEvent("Grid_Disabled")
end

function GridIndicatorCornerPlus:Grid_Enabled()
	configMode = false
end

function GridIndicatorCornerPlus:Grid_Disabled()
	configMode = false
end

function GridIndicatorCornerPlus:CleanOptionsMenu()
	if not GridFrame.options.args.cornerPlusTLtopright then return end
	if not Grid:GetModule("GridStatus"):IsModuleActive("GridIndicatorCornerPlus") then return end

	GridFrame.options.args["cornerplusTL"] = {
		type = "group",
		icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-TL",
		name = L["Top Left Corner Plus"],
		desc = L["Options for Top Left Corner Plus indicators."],
		order = 58.61,
		args = {
			["cornerPlusTLtopright"]    = GridFrame.options.args.cornerPlusTLtopright,
			["cornerPlusTLbottomleft"]  = GridFrame.options.args.cornerPlusTLbottomleft,
			["cornerPlusTLbottomright"] = GridFrame.options.args.cornerPlusTLbottomright
		}
	}
	GridFrame.options.args["cornerplusTL"].args["cornerPlusTLtopright"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-TL-TR"
	GridFrame.options.args["cornerplusTL"].args["cornerPlusTLbottomleft"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-TL-BL"
	GridFrame.options.args["cornerplusTL"].args["cornerPlusTLbottomright"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-TL-BR"
	GridFrame.options.args.cornerPlusTLtopright = nil
	GridFrame.options.args.cornerPlusTLbottomleft = nil
	GridFrame.options.args.cornerPlusTLbottomright = nil

	GridFrame.options.args["cornerplusTR"] = {
		type = "group",
		icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-TR",
		name = L["Top Right Corner Plus"],
		desc = L["Options for Top Right Corner Plus indicators."],
		order = 59.61,
		args = {
			["cornerPlusTRtopleft"]     = GridFrame.options.args.cornerPlusTRtopleft,
			["cornerPlusTRbottomleft"]  = GridFrame.options.args.cornerPlusTRbottomleft,
			["cornerPlusTRbottomright"] = GridFrame.options.args.cornerPlusTRbottomright
		}
	}
	GridFrame.options.args["cornerplusTR"].args["cornerPlusTRtopleft"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-TR-TL"
	GridFrame.options.args["cornerplusTR"].args["cornerPlusTRbottomleft"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-TR-BL"
	GridFrame.options.args["cornerplusTR"].args["cornerPlusTRbottomright"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-TR-BR"
	GridFrame.options.args.cornerPlusTRtopleft = nil
	GridFrame.options.args.cornerPlusTRbottomleft = nil
	GridFrame.options.args.cornerPlusTRbottomright = nil

	GridFrame.options.args["cornerplusBL"] = {
		type = "group",
		icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-BL",
		name = L["Bottom Left Corner Plus"],
		desc = L["Options for Bottom Left Corner Plus indicators."],
		order = 60.61,
		args = {
			["cornerPlusBLtopleft"]     = GridFrame.options.args.cornerPlusBLtopleft,
			["cornerPlusBLtopright"]    = GridFrame.options.args.cornerPlusBLtopright,
			["cornerPlusBLbottomright"] = GridFrame.options.args.cornerPlusBLbottomright
		}
	}
	GridFrame.options.args["cornerplusBL"].args["cornerPlusBLtopleft"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-BL-TL"
	GridFrame.options.args["cornerplusBL"].args["cornerPlusBLtopright"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-BL-TR"
	GridFrame.options.args["cornerplusBL"].args["cornerPlusBLbottomright"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-BL-BR"
	GridFrame.options.args.cornerPlusBLtopleft = nil
	GridFrame.options.args.cornerPlusBLtopright = nil
	GridFrame.options.args.cornerPlusBLbottomright = nil

	GridFrame.options.args["cornerplusBR"] = {
		type = "group",
		icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-BR",
		name = L["Bottom Right Corner Plus"],
		desc = L["Options for Bottom Right Corner Plus indicators."],
		order = 61.61,
		args = {
			["cornerPlusBRtopleft"]    = GridFrame.options.args.cornerPlusBRtopleft,
			["cornerPlusBRtopright"]   = GridFrame.options.args.cornerPlusBRtopright,
			["cornerPlusBRbottomleft"] = GridFrame.options.args.cornerPlusBRbottomleft
		}
	}
	GridFrame.options.args["cornerplusBR"].args["cornerPlusBRtopleft"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-BR-TL"
	GridFrame.options.args["cornerplusBR"].args["cornerPlusBRtopright"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-BR-TR"
	GridFrame.options.args["cornerplusBR"].args["cornerPlusBRbottomleft"].icon = "Interface\\AddOns\\GridIndicatorCornerPlus\\GridIndicatorCornerPlus-icon-BR-BL"
	GridFrame.options.args.cornerPlusBRtopleft = nil
	GridFrame.options.args.cornerPlusBRtopright = nil
	GridFrame.options.args.cornerPlusBRbottomleft = nil
end

function GridIndicatorCornerPlusFrameClass.prototype:GridIndicatorCornerPlusConfig()
	if configMode then
		local curTime = GetTime()
		self:SetIndicator("cornerPlusTLtopright",    {r=0.22, g=0.85, b=0.81, a=1})
		self:SetIndicator("cornerPlusTLbottomleft",  {r=0.87, g=0.62, b=0.06, a=1})
		self:SetIndicator("cornerPlusTLbottomright", {r=0.29, g=0.34, b=0.67, a=1})
		self:SetIndicator("cornerPlusTRtopleft",     {r=0.12, g=0.46, b=0.97, a=1})
		self:SetIndicator("cornerPlusTRbottomleft",  {r=0.42, g=0.07, b=0.24, a=1})
		self:SetIndicator("cornerPlusTRbottomright", {r=0.17, g=0.65, b=0.33, a=1})
		self:SetIndicator("cornerPlusBLtopleft",     {r=0.21, g=0.74, b=0.81, a=1})
		self:SetIndicator("cornerPlusBLtopright",    {r=0.87, g=0.71, b=0.06, a=1})
		self:SetIndicator("cornerPlusBLbottomright", {r=0.29, g=0.21, b=0.36, a=1})
		self:SetIndicator("cornerPlusBRtopleft",     {r=0.31, g=0.46, b=0.97, a=1})
		self:SetIndicator("cornerPlusBRtopright",    {r=0.42, g=0.77, b=0.85, a=1})
		self:SetIndicator("cornerPlusBRbottomleft",  {r=0.65, g=0.65, b=0.89, a=1})
	else
		self:ClearIndicator("cornerPlusTLtopright")
		self:ClearIndicator("cornerPlusTLbottomleft")
		self:ClearIndicator("cornerPlusTLbottomright")
		self:ClearIndicator("cornerPlusTRtopleft")
		self:ClearIndicator("cornerPlusTRbottomleft")
		self:ClearIndicator("cornerPlusTRbottomright")
		self:ClearIndicator("cornerPlusBLtopleft")
		self:ClearIndicator("cornerPlusBLtopright")
		self:ClearIndicator("cornerPlusBLbottomright")
		self:ClearIndicator("cornerPlusBRtopleft")
		self:ClearIndicator("cornerPlusBRtopright")
		self:ClearIndicator("cornerPlusBRbottomleft")
		GridFrame:UpdateAllFrames()
	end
end

function GridIndicatorCornerPlusFrameClass.prototype:CreateIndicator(indicator)
	GridIndicatorCornerPlusFrameClass.super.prototype.CreateIndicator(self, indicator)
	local f = self.frame
	local wh
	local space = GridIndicatorCornerPlus.db.profile.CornerPlusSpace
	local nwh = GridIndicatorCornerPlus.db.profile.CornerPlusSize
	local owh = GridFrame.db.profile.cornerSize
	local spacePositiv = owh+space
	local spaceNegativ = (owh+space)*-1
	if GridIndicatorCornerPlus.db.profile.CornerPlusOriginalSize then
		wh = owh
	else
		wh = nwh
	end
	if indicator == "cornerPlusTLtopright" then
		f.cornerPlusTLtopright:SetPoint("TOPLEFT", f, "TOPLEFT", spacePositiv, -1)
		f.cornerPlusTLtopright:SetWidth(wh)
		f.cornerPlusTLtopright:SetHeight(wh)
	elseif indicator == "cornerPlusTLbottomleft" then
		f.cornerPlusTLbottomleft:SetPoint("TOPLEFT", f, "TOPLEFT", 1, spaceNegativ)
		f.cornerPlusTLbottomleft:SetWidth(wh)
		f.cornerPlusTLbottomleft:SetHeight(wh)
	elseif indicator == "cornerPlusTLbottomright" then
		f.cornerPlusTLbottomright:SetPoint("TOPLEFT", f, "TOPLEFT", spacePositiv, spaceNegativ)
		f.cornerPlusTLbottomright:SetWidth(wh)
		f.cornerPlusTLbottomright:SetHeight(wh)
	elseif indicator == "cornerPlusTRtopleft" then
		f.cornerPlusTRtopleft:SetPoint("TOPRIGHT", f, "TOPRIGHT", spaceNegativ, -1)
		f.cornerPlusTRtopleft:SetWidth(wh)
		f.cornerPlusTRtopleft:SetHeight(wh)
	elseif indicator == "cornerPlusTRbottomleft" then
		f.cornerPlusTRbottomleft:SetPoint("TOPRIGHT", f, "TOPRIGHT", spaceNegativ, spaceNegativ)
		f.cornerPlusTRbottomleft:SetWidth(wh)
		f.cornerPlusTRbottomleft:SetHeight(wh)
	elseif indicator == "cornerPlusTRbottomright" then
		f.cornerPlusTRbottomright:SetPoint("TOPRIGHT", f, "TOPRIGHT", -1, spaceNegativ)
		f.cornerPlusTRbottomright:SetWidth(wh)
		f.cornerPlusTRbottomright:SetHeight(wh)
	elseif indicator == "cornerPlusBLtopleft" then
		f.cornerPlusBLtopleft:SetPoint("BOTTOMLEFT", f, "BOTTOMLEFT", 1, spacePositiv)
		f.cornerPlusBLtopleft:SetWidth(wh)
		f.cornerPlusBLtopleft:SetHeight(wh)
	elseif indicator == "cornerPlusBLtopright" then
		f.cornerPlusBLtopright:SetPoint("BOTTOMLEFT", f, "BOTTOMLEFT", spacePositiv, spacePositiv)
		f.cornerPlusBLtopright:SetWidth(wh)
		f.cornerPlusBLtopright:SetHeight(wh)
	elseif indicator == "cornerPlusBLbottomright" then
		f.cornerPlusBLbottomright:SetPoint("BOTTOMLEFT", f, "BOTTOMLEFT", spacePositiv, 1)
		f.cornerPlusBLbottomright:SetWidth(wh)
		f.cornerPlusBLbottomright:SetHeight(wh)
	elseif indicator == "cornerPlusBRtopleft" then
		f.cornerPlusBRtopleft:SetPoint("BOTTOMRIGHT", f, "BOTTOMRIGHT", spaceNegativ, spacePositiv)
		f.cornerPlusBRtopleft:SetWidth(wh)
		f.cornerPlusBRtopleft:SetHeight(wh)
	elseif indicator == "cornerPlusBRtopright" then
		f.cornerPlusBRtopright:SetPoint("BOTTOMRIGHT", f, "BOTTOMRIGHT", -1, spacePositiv)
		f.cornerPlusBRtopright:SetWidth(wh)
		f.cornerPlusBRtopright:SetHeight(wh)
	elseif indicator == "cornerPlusBRbottomleft" then
		f.cornerPlusBRbottomleft:SetPoint("BOTTOMRIGHT", f, "BOTTOMRIGHT", spaceNegativ, 1)
		f.cornerPlusBRbottomleft:SetWidth(wh)
		f.cornerPlusBRbottomleft:SetHeight(wh)
	end
end

function GridIndicatorCornerPlusFrameClass.prototype:SetIndicator(indicator, color, text, value, maxValue, texture, start, duration, stack)
	GridIndicatorCornerPlusFrameClass.super.prototype.SetIndicator(self, indicator, color, text, value, maxValue, texture, start, duration, stack)
	if indicator == "cornerPlusTLtopright"
	or indicator == "cornerPlusTLbottomleft"
	or indicator == "cornerPlusTLbottomright"
	or indicator == "cornerPlusTRtopleft"
	or indicator == "cornerPlusTRbottomleft"
	or indicator == "cornerPlusTRbottomright"
	or indicator == "cornerPlusBLtopleft"
	or indicator == "cornerPlusBLtopright"
	or indicator == "cornerPlusBLbottomright"
	or indicator == "cornerPlusBRtopleft"
	or indicator == "cornerPlusBRtopright"
	or indicator == "cornerPlusBRbottomleft"
	then
		if not self.frame[indicator] then
			self:CreateIndicator(indicator)
		end
		if not color then color = { r = 1, g = 1, b = 1, a = 1 } end
		self.frame[indicator]:SetBackdropColor(color.r, color.g, color.b, color.a)
		self.frame[indicator]:Show()
	end
end

function GridIndicatorCornerPlusFrameClass.prototype:ClearIndicator(indicator)
	GridIndicatorCornerPlusFrameClass.super.prototype.ClearIndicator(self, indicator)
	if indicator == "cornerPlusTLtopright"
	or indicator == "cornerPlusTLbottomleft"
	or indicator == "cornerPlusTLbottomright"
	or indicator == "cornerPlusTRtopleft"
	or indicator == "cornerPlusTRbottomleft"
	or indicator == "cornerPlusTRbottomright"
	or indicator == "cornerPlusBLtopleft"
	or indicator == "cornerPlusBLtopright"
	or indicator == "cornerPlusBLbottomright"
	or indicator == "cornerPlusBRtopleft"
	or indicator == "cornerPlusBRtopright"
	or indicator == "cornerPlusBRbottomleft"
	then
		if self.frame[indicator] then
			self.frame[indicator]:SetBackdropColor(1, 1, 1, 1)
			self.frame[indicator]:Hide()
		end
	end
end

function GridIndicatorCornerPlusFrameClass.prototype:SetCornerSize(size)
	GridIndicatorCornerPlusFrameClass.super.prototype.SetCornerSize(self, GridFrame.db.profile.cornerSize)
	local f = self.frame
	local wh
	local space = GridIndicatorCornerPlus.db.profile.CornerPlusSpace
	local nwh = GridIndicatorCornerPlus.db.profile.CornerPlusSize
	local owh = GridFrame.db.profile.cornerSize
	local spacePositiv = owh+space
	local spaceNegativ = (owh+space)*-1
	if GridIndicatorCornerPlus.db.profile.CornerPlusOriginalSize then
		wh = owh
	else
		wh = nwh
	end
	if f.cornerPlusTLtopright then
		f.cornerPlusTLtopright:SetPoint("TOPLEFT", f, "TOPLEFT", spacePositiv, -1)
		f.cornerPlusTLtopright:SetWidth(wh)
		f.cornerPlusTLtopright:SetHeight(wh)
	end
	if f.cornerPlusTLbottomleft then
		f.cornerPlusTLbottomleft:SetPoint("TOPLEFT", f, "TOPLEFT", 1, spaceNegativ)
		f.cornerPlusTLbottomleft:SetWidth(wh)
		f.cornerPlusTLbottomleft:SetHeight(wh)
	end
	if f.cornerPlusTLbottomright then
		f.cornerPlusTLbottomright:SetPoint("TOPLEFT", f, "TOPLEFT", spacePositiv, spaceNegativ)
		f.cornerPlusTLbottomright:SetWidth(wh)
		f.cornerPlusTLbottomright:SetHeight(wh)
	end
	if f.cornerPlusTRtopleft then
		f.cornerPlusTRtopleft:SetPoint("TOPRIGHT", f, "TOPRIGHT", spaceNegativ, -1)
		f.cornerPlusTRtopleft:SetWidth(wh)
		f.cornerPlusTRtopleft:SetHeight(wh)
	end
	if f.cornerPlusTRbottomleft then
		f.cornerPlusTRbottomleft:SetPoint("TOPRIGHT", f, "TOPRIGHT", spaceNegativ, spaceNegativ)
		f.cornerPlusTRbottomleft:SetWidth(wh)
		f.cornerPlusTRbottomleft:SetHeight(wh)
	end
	if f.cornerPlusTRbottomright then
		f.cornerPlusTRbottomright:SetPoint("TOPRIGHT", f, "TOPRIGHT", -1, spaceNegativ)
		f.cornerPlusTRbottomright:SetWidth(wh)
		f.cornerPlusTRbottomright:SetHeight(wh)
	end
	if f.cornerPlusBLtopleft then
		f.cornerPlusBLtopleft:SetPoint("BOTTOMLEFT", f, "BOTTOMLEFT", 1, spacePositiv)
		f.cornerPlusBLtopleft:SetWidth(wh)
		f.cornerPlusBLtopleft:SetHeight(wh)
	end
	if f.cornerPlusBLtopright then
		f.cornerPlusBLtopright:SetPoint("BOTTOMLEFT", f, "BOTTOMLEFT", spacePositiv, spacePositiv)
		f.cornerPlusBLtopright:SetWidth(wh)
		f.cornerPlusBLtopright:SetHeight(wh)
	end
	if f.cornerPlusBLbottomright then
		f.cornerPlusBLbottomright:SetPoint("BOTTOMLEFT", f, "BOTTOMLEFT", spacePositiv, 1)
		f.cornerPlusBLbottomright:SetWidth(wh)
		f.cornerPlusBLbottomright:SetHeight(wh)
	end
	if f.cornerPlusBRtopleft then
		f.cornerPlusBRtopleft:SetPoint("BOTTOMRIGHT", f, "BOTTOMRIGHT", spaceNegativ, spacePositiv)
		f.cornerPlusBRtopleft:SetWidth(wh)
		f.cornerPlusBRtopleft:SetHeight(wh)
	end
	if f.cornerPlusBRtopright then
		f.cornerPlusBRtopright:SetPoint("BOTTOMRIGHT", f, "BOTTOMRIGHT", -1, spacePositiv)
		f.cornerPlusBRtopright:SetWidth(wh)
		f.cornerPlusBRtopright:SetHeight(wh)
	end
	if f.cornerPlusBRbottomleft then
		f.cornerPlusBRbottomleft:SetPoint("BOTTOMRIGHT", f, "BOTTOMRIGHT", spaceNegativ, 1)
		f.cornerPlusBRbottomleft:SetWidth(wh)
		f.cornerPlusBRbottomleft:SetHeight(wh)
	end
end