-- GoH_DK Event Registrations
	GoH_DK = {}
	GoH_DK.events = {}

	GoH_DK.eventFrame = CreateFrame("Frame");
	GoH_DK.eventFrame:SetScript("OnEvent", function(self, event, ...) GoH_DK.events[event](...) end);

	-- EVERY EVENT YOU REGISTER MUST HAVE A FUNCTION
	GoH_DK.eventFrame:RegisterEvent("ADDON_LOADED");
   	GoH_DK.eventFrame:RegisterEvent("PLAYER_REGEN_DISABLED");
   	GoH_DK.eventFrame:RegisterEvent("PLAYER_REGEN_ENABLED");
   	GoH_DK.eventFrame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");



-- #######################################
-- #######################################
-- LOAD ADDON FUNCTION
-- #######################################
-- #######################################
function GoH_DK.events.ADDON_LOADED(addon)

	if addon ~= "GoH_DK" then
		return;
	end

end


-- #######################################
-- #######################################
-- PLAYER ENTER COMBAT SOUNDS
-- #######################################
-- #######################################
function GoH_DK.events.PLAYER_REGEN_DISABLED()

	-- START YOUR MUSIC
	PlayMusic("Interface\\AddOns\\GoH_DK\\Sounds\\Mortal_Kombat_Theme.mp3");

end



-- #######################################
-- #######################################
-- PLAYER LEAVE COMBAT SOUNDS
-- #######################################
-- #######################################
function GoH_DK.events.PLAYER_REGEN_ENABLED()

	-- STOP YOUR MUSIC
	StopMusic();

end



-- #######################################
-- #######################################
-- COMBAT LOG UNFILTERED
-- #######################################
-- #######################################
function GoH_DK.events.COMBAT_LOG_EVENT_UNFILTERED(timestamp, event, hideCaster, sourceGUID, sourceName, sourceFlags, sourceFlags2, destGUID, destName, destFlags, destFlags2, ...)

  local GoH_DK_spellID, GoH_DK_spellName, GoH_DK_all_spellSchool, GoH_DK_amount, GoH_DK_overkill, GoH_DK_school, GoH_DK_resisted, GoH_DK_blocked, GoH_DK_absorbed, GoH_DK_critical = ...

  -- Your Character's name
  GoH_DK_CharName = UnitName("player");

	-- DEATH KNIGHT: DEATH GRIP
	if (GoH_DK_spellID == 49576) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Get_Over_here_male.mp3","Master");
	end

        -- DEATH KNIGHT: HORN OF WINTER
	if (GoH_DK_spellID == 57330) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\HornOfWinter_Begins_Male.mp3","Master");
	end

        -- DEATH KNIGHT: DEATH AND DECAY
	if (GoH_DK_spellID == 43265) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\StealthDetected_Sonar.mp3","Master");
	end

        -- DEATH KNIGHT: PESTILENCE
	if (GoH_DK_spellID == 50842) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\All_Too_Easy_Male.mp3","Master");
	end

        -- DEATH KNIGHT: OUTBREAK
	if (GoH_DK_spellID == 77575) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Fight_Male.mp3","Master");
	end

        -- DEATH KNIGHT: BLOOD TAP
	if (GoH_DK_spellID == 45529) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Trek_Cloak_1.mp3","Master");
	end

        -- DEATH KNIGHT: DEATH COIL
	if (GoH_DK_spellID == 47541) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Death_Coil.mp3","Master");
	end

        -- DEATH KNIGHT: EMPOWER RUNE WEAPON
	if (GoH_DK_spellID == 47568) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Thats_Enough_Male.mp3","Master");
	end

        -- DEATH KNIGHT: BLOOD PRESENCE
	if (GoH_DK_spellID == 48263) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Blood_Craze_Male.mp3","Master");
	end

        -- DEATH KNIGHT: FROST PRESENCE
	if (GoH_DK_spellID == 48266) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\FreezingFog_Male.mp3","Master");
	end

        -- DEATH KNIGHT: UNHOLY PRESENCE
	if (GoH_DK_spellID == 48265) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\HolyPower_1.mp3","Master");
	end

        -- DEATH KNIGHT: ANTI-MAGIC SHELL
	if (GoH_DK_spellID == 48707) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\I_See_You_Male.mp3","Master");
	end

        -- DEATH KNIGHT: ICEBOUND FORTITUDE
	if (GoH_DK_spellID == 48792) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Camouflage.mp3","Master");
	end

        -- DEATH KNIGHT: STRANGULATE
	if (GoH_DK_spellID == 47476) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Strangulate_Male.mp3","Master");
	end

        -- DEATH KNIGHT: MIND FREEZE
	if (GoH_DK_spellID == 47528) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Earth_Shield_Ended.mp3","Master");
	end

        -- DEATH KNIGHT: SUMMON GARGOYLE
	if (GoH_DK_spellID == 49206) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\ArmyoftheDead_Male.mp3","Master");
	end

        -- DEATH KNIGHT: ARMY OF THE DEAD
	if (GoH_DK_spellID == 42650) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\ArmyoftheDead2_Male.mp3","Master");
	end

        -- DEATH KNIGHT: DEATH PACT
	if (GoH_DK_spellID == 48743) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Death_Pact_Male.mp3","Master");
	end

        -- DEATH KNIGHT: DARK TRANSFORMATION
	if (GoH_DK_spellID == 63560) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Dark_Transformation_Male.mp3","Master");
	end

        -- DEATH KNIGHT: UNHOLY FRENZY
	if (GoH_DK_spellID == 49016) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Death_Coil_Male.mp3","Master");
	end

        -- DEATH KNIGHT: BLOOD BOIL
	if (GoH_DK_spellID == 48721) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Toasty_Male.mp3","Master");
	end

         -- DEATH KNIGHT: ANTI-MAGIC ZONE
	if (GoH_DK_spellID == 51052) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Get_Under_Here_Male.mp3","Master");
	end

         -- DEATH KNIGHT: DARK COMMAND
	if (GoH_DK_spellID == 56222) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\Come_Here2_Male.mp3","Master");
	end

         -- DEATH KNIGHT: BONE SHIELD
	if (GoH_DK_spellID == 49222) and (event == "SPELL_CAST_SUCCESS") and (sourceName == GoH_DK_CharName)then
		-- PLAY YOUR SOUND
		PlaySoundFile("Interface\\AddOns\\GoH_DK\\Sounds\\BoneShield_Begins_Male.mp3","Master");
	end

end


