WTN = LibStub("AceAddon-3.0"):NewAddon("GatherNow", "AceEvent-3.0")
DEFAULT_NOTIFY_SOUND = "Sound\\Spells\\Spell_TimePortal_Teleport.ogg"

-- ACE3 Standard functions------------------------------------------------------
-- Grabbed need information on init	
function WTN:OnInitialize()	 
	Faction, x = UnitFactionGroup("player")
	isTracking = false	
	Rname = "" -- initialize empty string
    GameTooltip:SetText("")	
	skillLevel = ""
	maxSkillLevel = ""
	MsgTrack = ""
end

function WTN:OnEnable()
 	WTN:Create()  	
  	print("GatherNow loaded succesfully.")  
	
end
------------------------------------------------------------------------------

-- Registered Events -------------------------------------------------------
-- Handle skill up and update the display
WTN:RegisterEvent("CHAT_MSG_SKILL", 
	function() 
		if isTracking then
			WTN:SkillTrackCreate(MsgTrack)	
			fontstring2:SetText(skillLevel.." / "..maxSkillLevel)
			WTN:Location()	
			WTN:SkillNowCheck()
		end	
end)

WTN:RegisterEvent("SKILL_LINES_CHANGED",
	function()
		if isTracking then
			WTN:SkillTrackCreate(MsgTrack)	
			fontstring2:SetText(skillLevel.." / "..maxSkillLevel)
			WTN:Location()	
			WTN:SkillNowCheck()
		end	
end)	
-- Save the screens postion on logout
WTN:RegisterEvent("PLAYER_LOGOUT",
	function()
		point, relativeTo, relativePoint, x, y  = WTNframe:GetPoint()
end)
------------------------------------------------------------------------------

--GatherNow Functions--------------------------------------------------------
-- Create the container on login
function WTN:Create()
   	WTNframe = CreateFrame("Frame", "GatherNow", UIParent)
   	WTNframe:SetWidth(125)
    WTNframe:SetHeight(80)
   	WTNframe:SetFrameStrata("Background")     	
   	if point ~= nil then		
		WTNframe:SetPoint(point, UIParent, relativePoint, x, y)
   	end
	if point == nil then
		WTNframe:SetPoint("CENTER", 0, 0)
	end	
	WTNframe:EnableMouse(true)
   	WTNframe:SetMovable(true)
   	WTNframe:RegisterForDrag("LeftButton")

   	t = WTNframe:CreateTexture(nil,"BACKGROUND")
   	t:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")
   	t:SetAllPoints(WTNframe)
   	WTNframe.texture = t
 
    WTNframe:SetScript("OnDragStart", 
    	function(WTNframe, button)
			WTNframe:StartMoving()
	end) 

	WTNframe:SetScript("OnDragStop", 
		function(WTNframe, button)
			WTNframe:StopMovingOrSizing()
			-- get container position and save it here NYI			
	end) 	
			
	fontstring = WTNframe:CreateFontString("name", "frame", "ActionBarButtonTemplate")
	fontstring2 = WTNframe:CreateFontString("name", "frame", "ActionBarButtonTemplate")
	fontstring3 = WTNframe:CreateFontString("name", "frame", "ActionBarButtonTemplate")
	fontstring2:SetFont("Fonts\\ARIALN.ttf", 12, "") 	
	fontstring2:SetPoint("CENTER", 0, 30)
	
	fontstring3:SetFont("Fonts\\ARIALN.ttf", 12, "") 	
	fontstring3:SetPoint("CENTER", 0, 30)
	fontstring3:SetText("Welcome to \n GatherNow.")
	WTN:CheckProfs()
	
	--Create First Container button with default data and hide it
	EASTERN_KINGDOM_LOCATION1 = ""
	KALIMDOR_LOCATION1 = ""
	EASTERN_KINGDOM_LOCATION1H = ""
	KALIMDOR_LOCATION1H = ""
	BUTTON1_HORZ_OFFSET = -24
	BUTTON1_VERT_OFFSET = 10
	BUTTON1_TOOLTIP_TITLE = ""
	bR1 = CreateFrame("Button", "btn1", WTNframe)
	bR1:SetWidth(20)
	bR1:SetHeight(20)
	bR1:SetPoint("CENTER", BUTTON1_HORZ_OFFSET, BUTTON1_VERT_OFFSET)
	teR1 = bR1:CreateTexture(nil,"BACKGROUND")		
	teR1:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
	teR1:SetAllPoints(bR1)
	bR1.texture = teR1	
	bR1: SetScript("OnEnter",
		function(self, button)
			GameTooltip:SetOwner(self, "ANCHOR_CURSOR")					
			GameTooltip:SetText(BUTTON1_TOOLTIP_TITLE)  
			if Faction == "Alliance" then
				if cont == 2 then
					GameTooltip:AddLine(EASTERN_KINGDOM_LOCATION1, 1, 1, 1)
				end
				if cont == 1 then
					GameTooltip:AddLine(KALIMDOR_LOCATION1, 1, 1, 1)
				end
			end
			if Faction == "Horde" then
				if cont == 2 then
					GameTooltip:AddLine(EASTERN_KINGDOM_LOCATION1H, 1, 1, 1)
				end
				if cont == 1 then
					GameTooltip:AddLine(KALIMDOR_LOCATION1H, 1, 1, 1)
				end
			end
			GameTooltip:Show()			
		end)
		bR1: SetScript("OnLeave",
		function(self, button)					
			GameTooltip:Hide()			
		end)
		
	-- Create Second Container button
	EASTERN_KINGDOM_LOCATION2 = ""
	KALIMDOR_LOCATION2 = ""
	BUTTON2_HORZ_OFFSET = 0
	BUTTON2_VERT_OFFSET = 10
	BUTTON2_TOOLTIP_TITLE = ""
	bR2 = CreateFrame("Button", "btn2", WTNframe)
	bR2:SetWidth(20)
	bR2:SetHeight(20)
	bR2:SetPoint("CENTER", BUTTON2_HORZ_OFFSET, BUTTON2_VERT_OFFSET)
	teR2 = bR2:CreateTexture(nil,"BACKGROUND")		
	teR2:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
	teR2:SetAllPoints(bR2)
	bR2.texture = teR2
	bR2: SetScript("OnEnter",
		function(self, button)
			GameTooltip:SetOwner(self, "ANCHOR_CURSOR")					
			GameTooltip:SetText(BUTTON2_TOOLTIP_TITLE)  
			if Faction == "Alliance" then
				if cont == 2 then
					GameTooltip:AddLine(EASTERN_KINGDOM_LOCATION2, 1, 1, 1)
				end
				if cont == 1 then
					GameTooltip:AddLine(KALIMDOR_LOCATION2, 1, 1, 1)
				end
			end
			if Faction == "Horde" then
				if cont == 2 then
					GameTooltip:AddLine(EASTERN_KINGDOM_LOCATION2H, 1, 1, 1)
				end
				if cont == 1 then
					GameTooltip:AddLine(KALIMDOR_LOCATION2H, 1, 1, 1)
				end
			end
			GameTooltip:Show()			
		end)
	bR2: SetScript("OnLeave",
		function(self, button)					
			GameTooltip:Hide()					
		end)	
	-- Create Third an final container
	
	EASTERN_KINGDOM_LOCATION3 = ""
	KALIMDOR_LOCATION3 = ""
	BUTTON3_HORZ_OFFSET = 24
	BUTTON3_VERT_OFFSET = 10
	BUTTON3_TOOLTIP_TITLE = ""
	bR3 = CreateFrame("Button", "btn3", WTNframe)
	bR3:SetWidth(20)
	bR3:SetHeight(20)
	bR3:SetPoint("CENTER", BUTTON3_HORZ_OFFSET, BUTTON3_VERT_OFFSET)
	teR3 = bR3:CreateTexture(nil,"BACKGROUND")		
	teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
	teR3:SetAllPoints(bR3)
	bR3.texture = teR3
	bR3: SetScript("OnEnter",
		function(self, button)
			GameTooltip:SetOwner(self, "ANCHOR_CURSOR")					
			GameTooltip:SetText(BUTTON3_TOOLTIP_TITLE)  
			if Faction == "Alliance" then
				if cont == 2 then
					GameTooltip:AddLine(EASTERN_KINGDOM_LOCATION3, 1, 1, 1)
				end
				if cont == 1 then
					GameTooltip:AddLine(KALIMDOR_LOCATION3, 1, 1, 1)
				end
			end
			if Faction == "Horde" then
				if cont == 2 then
					GameTooltip:AddLine(EASTERN_KINGDOM_LOCATION3H, 1, 1, 1)
				end
				if cont == 1 then
					GameTooltip:AddLine(KALIMDOR_LOCATION3H, 1, 1, 1)
				end
			end
			GameTooltip:Show()			
		end)
	bR3: SetScript("OnLeave",
		function(self, button)					
			GameTooltip:Hide()					
		end)				
		
	
end

function WTN:CheckProfs()
	prof1, prof2, archaeology, fishing, cooking, firstAid = GetProfessions("player"); 	
 	-- Get Trade skill One 	
 	MsgTrack = "" -- Clear data to prevent wrong skill info from displaying
	if prof1 ~= nil then  		
		WTN:SkillTrackCreate(prof1)	
		if name == "Mining" then
			Mining = prof1
			WTN:CreateMiningButton()
		end
		if name == "Herbalism" then
			Herbalism = prof1
			WTN:CreateHerbButton()
		end		
 	end
 	if prof2 ~= nil then
 		WTN:SkillTrackCreate(prof2)		
		if name == "Mining" then
			Mining = prof2
			WTN:CreateMiningButton()
		end
		if name == "Herbalism" then
			Herbalism = prof2
			WTN:CreateHerbButton()
		end
	end 		
end


function WTN:CreateHerbButton()
	WTN:SkillTrackCreate(Herbalism)	
	b = CreateFrame("Button", "btn1", WTNframe)
	b:SetWidth(24)
	b:SetHeight(24)
	b:SetPoint("CENTER", -75, 25)
	te = b:CreateTexture(nil,"BACKGROUND")
	te:SetTexture(icon)
	te:SetAllPoints(b)
	b.texture = te
	b:RegisterForClicks("AnyUp", "AnyDown")
	b: SetScript("OnMouseUp",
		function(self, button)
			fontstring3:SetText("Herbalism")
			isTracking = true
			TrackName = "Herbalism"
			MsgTrack = Herbalism
			WTN:SkillTrackCreate(Herbalism)
			fontstring2:SetText(skillLevel.." / "..maxSkillLevel)	
			WTN:Location()	
		end)
			
end

function WTN:CreateMiningButton()
	WTN:SkillTrackCreate(Mining)
	b1 = CreateFrame("Button", "btn2", WTNframe)
	b1:SetWidth(24)
	b1:SetHeight(24)
	b1:SetPoint("CENTER", -75, 0)
	te1 = b1:CreateTexture(nil,"BACKGROUND")
	te1:SetTexture(icon)	
	te1:SetAllPoints(b1)
	b1.texture = te1
	b1: SetScript("OnMouseUp",
		function(self, button)
			fontstring3:SetText("Mining")	
			isTracking =  true
			TrackName = "Mining"
			MsgTrack = Mining
			WTN:SkillTrackCreate(Mining)
			fontstring2:SetText(skillLevel.." / "..maxSkillLevel)			
			WTN:Location()					
		end)		
end

-- Get the professions information for displaying the skill level
function WTN:SkillTrackCreate(prof)
	name, icon, skillLevel, maxSkillLevel, numAbilities, spelloffset, skillLine, skillModifier = GetProfessionInfo(prof)	
 end


-- Tell user closest and best place to mine
function WTN:Location()
    cont = GetCurrentMapContinent()  
	fontstring3:SetFont("Fonts\\ARIALN.ttf", 12, "") 	
	fontstring3:SetPoint("CENTER", 0, -13)
	
	-- Account for start zones
	if isTracking then
		if TrackName == "Mining" then
			if skillLevel < 49 then
				
				EASTERN_KINGDOM_LOCATION1 = ""
				KALIMDOR_LOCATION1 =  ""
				EASTERN_KINGDOM_LOCATION1H = ""
				KALIMDOR_LOCATION1H =  ""
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = ""
				teR1:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
				bR1:Show()	
				-- Copper
				WTN:GetResource(2770)
				EASTERN_KINGDOM_LOCATION2 = "Elwynn Forest 1-10  \n Dun Morogh 1-10"
				KALIMDOR_LOCATION2 =  "Teldrassil 1-10 \n Azuremyst Isle 1-10 \n Gilneas 5-12"
				EASTERN_KINGDOM_LOCATION2H = "Tristfal Glades 1-10 \n Eversong Woods 1-10"
				KALIMDOR_LOCATION2H =  "Durotar 1-10 \n Mulgore 1-10 \n The Lost Isles 5-12"
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON3_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")		
			end
			-- Beyond startZone
			if skillLevel > 49 and skillLevel < 99 then
				EASTERN_KINGDOM_LOCATION1 = ""
				KALIMDOR_LOCATION1 =  ""
				EASTERN_KINGDOM_LOCATION1H = ""
				KALIMDOR_LOCATION1H =  ""
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = ""
				teR1:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
				bR1:Show()	
				-- Copper
				WTN:GetResource(2771)
				EASTERN_KINGDOM_LOCATION2 = "Hillsbrad Foothills 20-25"
				KALIMDOR_LOCATION2 =  "Ashenvale 20-25"
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  KALIMDOR_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")		
			end
			if skillLevel > 99 and skillLevel < 149 then
				EASTERN_KINGDOM_LOCATION1 = ""
				KALIMDOR_LOCATION1 =  ""
				EASTERN_KINGDOM_LOCATION1H = ""
				KALIMDOR_LOCATION1H =  ""
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = ""
				teR1:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
				bR1:Show()	
				
				WTN:GetResource(2772)
				EASTERN_KINGDOM_LOCATION2 = "Western Plaguelands 35-40"
				KALIMDOR_LOCATION2 =  "Feralas 35-40"
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  KALIMDOR_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = "" 
				KALIMDOR_LOCATION2H =  ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")		
			end
			if skillLevel > 149 and skillLevel < 199 then
				EASTERN_KINGDOM_LOCATION1 = ""
				KALIMDOR_LOCATION1 =  ""
				EASTERN_KINGDOM_LOCATION1H = ""
				KALIMDOR_LOCATION1H =  ""
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = ""
				teR1:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
				bR1:Show()	
				-- Copper
				WTN:GetResource(3858)
				EASTERN_KINGDOM_LOCATION2 = "Badlands 45-48"
				KALIMDOR_LOCATION2 =  "Felwood 45-50"
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  KALIMDOR_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")		
			end
			if skillLevel > 199 and skillLevel < 274 then
				EASTERN_KINGDOM_LOCATION1 = ""
				KALIMDOR_LOCATION1 =  ""
				EASTERN_KINGDOM_LOCATION1H = ""
				KALIMDOR_LOCATION1H =  ""
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = ""
				teR1:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
				bR1:Show()	
				-- Copper
				WTN:GetResource(10620)
				EASTERN_KINGDOM_LOCATION2 = "Blasted Lands 54-60"
				KALIMDOR_LOCATION2 =  "Winterspring 50-55"
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  KALIMDOR_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")		
			end
			if skillLevel > 274 and skillLevel < 324 then
				EASTERN_KINGDOM_LOCATION1 = ""
				KALIMDOR_LOCATION1 =  ""
				EASTERN_KINGDOM_LOCATION1H = ""
				KALIMDOR_LOCATION1H =  ""
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = ""
				teR1:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
				bR1:Show()	
				-- Copper
				WTN:GetResource(23424)
				EASTERN_KINGDOM_LOCATION2 = "Hellfire Peninsula 58-63"
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION2
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")		
			end
			if skillLevel > 324 and skillLevel < 349 then
				EASTERN_KINGDOM_LOCATION1 = ""
				KALIMDOR_LOCATION1 =  ""
				EASTERN_KINGDOM_LOCATION1H = ""
				KALIMDOR_LOCATION1H =  ""
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = ""
				teR1:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
				bR1:Show()	
				-- Copper
				WTN:GetResource(23425)
				EASTERN_KINGDOM_LOCATION2 = "Nagrand 64-67"
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION2
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")		
			end
			if skillLevel > 349 and skillLevel < 399 then
				EASTERN_KINGDOM_LOCATION1 = ""
				KALIMDOR_LOCATION1 =  ""
				EASTERN_KINGDOM_LOCATION1H = ""
				KALIMDOR_LOCATION1H =  ""
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = ""
				teR1:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
				bR1:Show()	
				
				WTN:GetResource(36909)
				EASTERN_KINGDOM_LOCATION2 = "Howling Fjord 68-72 \n Borean Tundra 68-72 "
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION2
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")		
			end
			if skillLevel > 399 and skillLevel < 424 then
				EASTERN_KINGDOM_LOCATION1 = ""
				KALIMDOR_LOCATION1 =  ""
				EASTERN_KINGDOM_LOCATION1H = ""
				KALIMDOR_LOCATION1H =  ""
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = ""
				teR1:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
				bR1:Show()	
				-- Copper
				WTN:GetResource(36912)
				EASTERN_KINGDOM_LOCATION2 = "Sholzar Basin 76-78 "
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION2
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
			end
			if skillLevel > 424 and skillLevel < 474 then
				EASTERN_KINGDOM_LOCATION1 = ""
				KALIMDOR_LOCATION1 =  ""
				EASTERN_KINGDOM_LOCATION1H = ""
				KALIMDOR_LOCATION1H =  ""
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = ""
				teR1:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
				bR1:Show()	
				-- Copper
				WTN:GetResource(53038)
				EASTERN_KINGDOM_LOCATION2 = "Mount Hyjal 80-82"
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION2
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
			end
			if skillLevel > 474 and skillLevel < 525 then		
				WTN:GetResource(52185)
				EASTERN_KINGDOM_LOCATION1 = "Twilight Highlands 84-85 \n Deepholm 82-83"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				
				WTN:GetResource(53038)
				EASTERN_KINGDOM_LOCATION2 = "Deepholm 82-83 \n Mount Hyjal 80-82"
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION2
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")	
			end	
			if skillLevel == 525	then
				WTN:GetResource(52185)
				EASTERN_KINGDOM_LOCATION1 = "Twilight Highlands 84-85 \n Deepholm 82-83"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Copper
				WTN:GetResource(53038)
				EASTERN_KINGDOM_LOCATION2 = "Deepholm 82-83 \n Mount Hyjal 80-82"
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION2
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)				
				
				WTN:GetResource(52183)
				EASTERN_KINGDOM_LOCATION3 = "Twilight Highlands 84-85 \n Uldum 83-84"
				KALIMDOR_LOCATION3 =  EASTERN_KINGDOM_LOCATION3
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION3
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION3
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = Rname.." - RARE"
				teR3:SetTexture(texture)
			end	
		end
		if TrackName == "Herbalism" then
			if skillLevel < 14 then	-- Starter Zone farming		
				-- Peacebloom
				WTN:GetResource(2447)
				EASTERN_KINGDOM_LOCATION1 = "Elwynn Forest 1-10  \n Dun Morogh 1-10"
				KALIMDOR_LOCATION1 =  "Teldrassil 1-10 \n Azuremyst Isle 1-10 \n Gilneas 5-12"
				EASTERN_KINGDOM_LOCATION1H = "Tristfal Glades 1-10 \n Eversong Woods 1-10"
				KALIMDOR_LOCATION1H =  "Durotar 1-10 \n Mulgore 1-10 \n The Lost Isles 5-12"
				BUTTON1_HORZ_OFFSET = 24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Silverleaf
				WTN:GetResource(765)
				EASTERN_KINGDOM_LOCATION2 = "Elwynn Forest 1-10  \n".."Dun Morogh 1-10 \n"
				KALIMDOR_LOCATION2 =  "Teldrassil 1-10 \n Azuremyst Isle 1-10 \n Gilneas 5-12"
				EASTERN_KINGDOM_LOCATION2H = "Tristfal Glades 1-10 \n Eversong Woods 1-10"
				KALIMDOR_LOCATION2H =  "Durotar 1-10 \n Mulgore 1-10 \n The Lost Isles 5-2"
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)			
			end	
			if skillLevel > 14 and skillLevel < 49 then -- Start Zone w/ Earthroot available
				-- peacebloom
				WTN:GetResource(2447)
				EASTERN_KINGDOM_LOCATION1 = "Elwynn Forest 1-10 \n".."Dun Morogh 1-10 \n"
				KALIMDOR_LOCATION1 =  "Teldrassil 1-10 \n Azuremyst Isle 1-10 \n Gilneas 5-12"
				EASTERN_KINGDOM_LOCATION1H = "Tristfal Glades 1-10 \n Eversong Woods 1-10"
				KALIMDOR_LOCATION1H =  "Durotar 1-10 \n Mulgore 1-10 \n The Lost Isles 5-12"
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Silverleaf
				WTN:GetResource(765)
				EASTERN_KINGDOM_LOCATION2 = "Elwynn Forest 1-10  \n Dun Morogh 1-10"
				KALIMDOR_LOCATION2 =  "Teldrassil 1-10 \n Azuremyst Isle 1-10 \n Gilneas 5-12"
				EASTERN_KINGDOM_LOCATION2H = "Tristfal Glades 1-10 \n Eversong Woods 1-10"
				KALIMDOR_LOCATION2H =  "Durotar 1-10 \n Mulgore 1-10 \n The Lost Isles 5-12"
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)
				-- Earthroot
				WTN:GetResource(2449)
				EASTERN_KINGDOM_LOCATION3 = "Elwynn Forest 1-10 \n Dun Morogh 1-10 "
				KALIMDOR_LOCATION3 =  "Teldrassil 1-10 \n Azuremyst Isle 1-10 \n Gilneas 5-12"
				EASTERN_KINGDOM_LOCATION2H = "Tristfal Glades 1-10 \n Eversong Woods 1-10"
				KALIMDOR_LOCATION2H =  "Durotar 1-10 \n Mulgore 1-10 \n The Lost Isles 5-12"
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = Rname			
				teR3:SetTexture(texture)			
			end
			if skillLevel > 49 and skillLevel < 69 then
				-- Earthroot
				WTN:GetResource(2449)
				EASTERN_KINGDOM_LOCATION1 = "Westfall 10-15 \n Redridge Mountains 15-20 \n Loch Modan 10-20 \n Elwynn Forest 1-10  \n Dun Morogh 1-10"
				KALIMDOR_LOCATION1 =  "Darkshore 10-20 \n Bloodmyst Isle 11-20 \n Teldrassil 1-10 \n Azuremyst Isle 1-10 \n Gilneas 5-12"
				EASTERN_KINGDOM_LOCATION1H = "Silverpine Foest 10-20\n Ghostlands 10-20 \n Trisfal Glades 1-10 \n Eversong Woods 1-10 "
				KALIMDOR_LOCATION1H =  "Norhtern Barrens 10-20 \n Azshara 10-20 \n Durotar 1-10 \n Mulgore 1-10 \n The Lost Isles 5-12"
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Mageroyal			 
				WTN:GetResource(785)
				EASTERN_KINGDOM_LOCATION2 = "Westfall 10-15 \n Redridge Mountains 15-20 \n Loch Modan 10-20"
				KALIMDOR_LOCATION2 =  "Darkshore 10-20 \n Bloodmyst Isle 11-20 "
				EASTERN_KINGDOM_LOCATION2H = "Silverpine Foest 10-20\n Ghostlands 10-20"
				KALIMDOR_LOCATION2H =  "Norhtern Barrens 10-20 \n Azshara 10-20"
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)
			
				-- Not Needed Empty Data 
				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""			
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
			end
			if skillLevel > 69 and skillLevel < 84 then
				-- Earthroot
				WTN:GetResource(2449)
				EASTERN_KINGDOM_LOCATION1 = "Westfall 10- 15 \n Redridge Mountains 15 - 20 \n Loch Modan 10-20"
				KALIMDOR_LOCATION1 =  "Darkshore 10-20 \n Bloodmyst Isle 11-20"
				EASTERN_KINGDOM_LOCATION1H = "Silverpine Foest 10-20\n Ghostlands 10-20"
				KALIMDOR_LOCATION1H =  "Norhtern Barrens 10-20 \n Azshara 10-20"
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Mageroyal			 
				WTN:GetResource(785)
				EASTERN_KINGDOM_LOCATION2 = "Westfall 10-15 \n Redridge Mountains 15-20 \n Loch Modan 10-20"
				KALIMDOR_LOCATION2 =  "Darkshore 10-20 \n Bloodmyst Isle 11-20 "
				EASTERN_KINGDOM_LOCATION2H = "Silverpine Foest 10-20\n Ghostlands 10-20"
				KALIMDOR_LOCATION2H =  "Norhtern Barrens 10-20 \n Azshara 10-20"
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)			
				-- Briarthorn 
				WTN:GetResource(2450)
				EASTERN_KINGDOM_LOCATION3 = "Westfall 10-15 \n Redridge Mountains 15-20 \n Loch Modan 10-20"
				KALIMDOR_LOCATION3 =  "Darkshore 10-20 \n Bloodmyst Isle 11-20 "
				EASTERN_KINGDOM_LOCATION2H = "Silverpine Foest 10-20\n Ghostlands 10-20"
				KALIMDOR_LOCATION2H = "Silverpine Foest 10-20\n Ghostlands 10-20"
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = Rname			
				teR3:SetTexture(texture)			
			end	
			if skillLevel > 84 and skillLevel < 149 then
				-- Mageroyal
				WTN:GetResource(785)
				EASTERN_KINGDOM_LOCATION1 = "Hillsbrad Foothills 20-35 \n Wetlands 20-35 \n Duskwood 20-25 \n Westfall 10- 15 \n Redridge Mountains 15 - 20 \n Loch Modan 10-20"
				KALIMDOR_LOCATION1 =  "Hillsbrad Foothills 20-35 \n Darkshore 10-20 \n Bloodmyst Isle 11-20"
				EASTERN_KINGDOM_LOCATION1H = "Hillsbrad Foothills 20-35 \n Wetlands 20-35 \n Duskwood 20-25 \n Silverpine Foest 10-20\n Ghostlands 10-20"
				KALIMDOR_LOCATION1H =  "Hillsbrad Foothills 20-35 \n Norhtern Barrens 10-20 \n Azshara 10-20"
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Briarthorn			 
				WTN:GetResource(2450)
				EASTERN_KINGDOM_LOCATION2 = "Hillsbrad Foothills 20-35 \n Westfall 10-15 \n Redridge Mountains 15-20 \n Loch Modan 10-20"
				KALIMDOR_LOCATION2 =  "Hillsbrad Foothills 20-35 \n Darkshore 10-20 \n Bloodmyst Isle 11-20 "
				EASTERN_KINGDOM_LOCATION2H = "Hillsbrad Foothills 20-35 \n Silverpine Foest 10-20\n Ghostlands 10-20"
				KALIMDOR_LOCATION2H =  "Hillsbrad Foothills 20-35 \n Norhtern Barrens 10-20 \n Azshara 10-20"
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname			
				teR2:SetTexture(texture)			
				-- Bruiseweed 
				WTN:GetResource(2453)				
				EASTERN_KINGDOM_LOCATION3 = "Hillsbrad Foothills 20-35 \n Northern Stranglethorn 25-30 \n Wetlands 20-25"
				KALIMDOR_LOCATION3 = "Hillsbrad Foothills 20-35 \n Ashenvale 20-25 \n Stonetalon Mountains 25-30"
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION3
				KALIMDOR_LOCATION2H = KALIMDOR_LOCATION3 
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = Rname			
				teR3:SetTexture(texture)			
			end		
			if skillLevel > 149 and skillLevel < 159 then
				-- Liferoot
				WTN:GetResource(3357)
				EASTERN_KINGDOM_LOCATION1 = "Western Plaguelands 35-40"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- None					
				EASTERN_KINGDOM_LOCATION2 = ""
				KALIMDOR_LOCATION2 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = ""			
				teR2:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
				-- None 								
				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 = ""
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION3
				KALIMDOR_LOCATION2H = KALIMDOR_LOCATION3 
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
			end
			if skillLevel > 159 and skillLevel < 184 then
				-- Liferoot
				WTN:GetResource(3357)
				EASTERN_KINGDOM_LOCATION1 = "Western Plaguelands 35-40"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Fadeleaf	
				WTN:GetResource(3818)				
				EASTERN_KINGDOM_LOCATION2 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION1
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(texture)			
				-- None 								
				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 = ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H = "" 
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
			end
			if skillLevel > 184 and skillLevel < 229 then
				-- Liferoot
				WTN:GetResource(3357)
				EASTERN_KINGDOM_LOCATION1 = "Western Plaguelands 35-40"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Fadeleaf	
				WTN:GetResource(3818)				
				EASTERN_KINGDOM_LOCATION2 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION1
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(texture)			
				-- Khadgar's Whisker 	
				WTN:GetResource(3358)							
				EASTERN_KINGDOM_LOCATION3 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION3 = EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H = EASTERN_KINGDOM_LOCATION1 
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = Rname
				teR3:SetTexture(texture)			
			end
			if skillLevel > 229 and skillLevel < 259 then
				-- Khadgar's Whisker
				WTN:GetResource(3358)
				EASTERN_KINGDOM_LOCATION1 = "Eastern Plaguelands 40-45"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Sungrass	
				WTN:GetResource(8838)				
				EASTERN_KINGDOM_LOCATION2 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION1
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(texture)			
				-- None 											
				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 = ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H = "" 
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
			end	
			if skillLevel > 259 and skillLevel < 269 then
				-- Golden Sansam
				WTN:GetResource(13464)
				EASTERN_KINGDOM_LOCATION1 = "Blasted Lands 54-60"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- None	
							
				EASTERN_KINGDOM_LOCATION2 = ""
				KALIMDOR_LOCATION2 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = ""
				teR2:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
				-- None 	
											
				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 = ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H = "" 
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
			end
			if skillLevel > 269 and skillLevel < 279 then
				-- Golden Sansam
				WTN:GetResource(13464)
				EASTERN_KINGDOM_LOCATION1 = "Blasted Lands 54-60"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Dreamfoil	
				WTN:GetResource(13463)				
				EASTERN_KINGDOM_LOCATION2 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION1
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(texture)			
				-- None 	
												
				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 = ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H = "" 
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
			end		
			if skillLevel > 279 and skillLevel < 299 then
				-- Golden Sansam
				WTN:GetResource(13464)
				EASTERN_KINGDOM_LOCATION1 = "Blasted Lands 54-60"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Dreamfoil	
				WTN:GetResource(13463)				
				EASTERN_KINGDOM_LOCATION2 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION1
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(texture)			
				-- Mountain Silversage 	
				WTN:GetResource(13465)								
				EASTERN_KINGDOM_LOCATION3 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION3 = EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = Rname
				teR3:SetTexture(texture)			
			end	
			if skillLevel > 299 and skillLevel < 314 then
				-- Dreamfoil
				WTN:GetResource(13463)
				EASTERN_KINGDOM_LOCATION1 = "Hellfire Peninsula 58-63"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Felweed
				WTN:GetResource(22785)				
				EASTERN_KINGDOM_LOCATION2 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION1
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(texture)			
				-- Mountain Silversage 	
				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 = ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H = ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
			end			
			if skillLevel > 314 and skillLevel < 359 then
				-- Felweed
				WTN:GetResource(22785)
				EASTERN_KINGDOM_LOCATION1 = "Hellfire Peninsula 58-63"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Dreaming Glory
				WTN:GetResource(22786)				
				EASTERN_KINGDOM_LOCATION2 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION1
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(texture)			
				-- Mountain Silversage 	
				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 = ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H = ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
			end		
			if skillLevel > 359 and skillLevel < 374 then
				-- Goldclover
				WTN:GetResource(36901)
				EASTERN_KINGDOM_LOCATION1 = "Howling Fjord 68-72 \n Borean Tundra 68-72"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- None							
				EASTERN_KINGDOM_LOCATION2 = ""
				KALIMDOR_LOCATION2 =  ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H =  ""
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = ""		
				teR2:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
				-- None
				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 = ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H = ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
			end	
			if skillLevel > 374 and skillLevel < 399  then
				-- Goldclover
				WTN:GetResource(36901)
				EASTERN_KINGDOM_LOCATION1 = "Howling Fjord 68-72 \n Borean Tundra 68-72"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Tigerlilly
				WTN:GetResource(36904)							
				EASTERN_KINGDOM_LOCATION2 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION1
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(Texture)			
				-- None
				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 = ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H = ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
			end
			if skillLevel > 399 and skillLevel < 449  then
				-- Goldclover
				WTN:GetResource(36901)
				EASTERN_KINGDOM_LOCATION1 = "Sholzar Basin 76-78"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Tigerlilly
				WTN:GetResource(36904)							
				EASTERN_KINGDOM_LOCATION2 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION1
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(texture)			
				-- Adder's Tongue
				WTN:GetResource(36903)
				EASTERN_KINGDOM_LOCATION3 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION3 = EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = Rname
				teR3:SetTexture(texture)			
			end
			if skillLevel > 449 and skillLevel < 474  then
				-- Cinderbloom
				WTN:GetResource(52983)
				EASTERN_KINGDOM_LOCATION1 = "Mount Hyjal 80-82"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Azshara's Veil
				WTN:GetResource(52985)							
				EASTERN_KINGDOM_LOCATION2 = EASTERN_KINGDOM_LOCATION1.." \n Vashj'ir 80-82"
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION1.." \n Vashj'ir 80-82"
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1.." \n Vashj'ir 80-82"
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION1.." \n Vashj'ir 80-82"
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(texture)			
				-- Stormvine
				WTN:GetResource(52984)
				EASTERN_KINGDOM_LOCATION3 = EASTERN_KINGDOM_LOCATION1.." \n Vashj'ir 80-82"
				KALIMDOR_LOCATION3 = EASTERN_KINGDOM_LOCATION1.." \n Vashj'ir 80-82"
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1.." \n Vashj'ir 80-82"
				KALIMDOR_LOCATION2H = EASTERN_KINGDOM_LOCATION1.." \n Vashj'ir 80-82"
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = Rname
				teR3:SetTexture(texture)			
			end
			if skillLevel > 474 and skillLevel < 525  then
				-- Cinderbloom
				WTN:GetResource(52983)
				EASTERN_KINGDOM_LOCATION1 = "Deepholm 82-83"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Heartblossom
				WTN:GetResource(52986)							
				EASTERN_KINGDOM_LOCATION2 = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION1
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(texture)			
				-- Stormvine

				EASTERN_KINGDOM_LOCATION3 = ""
				KALIMDOR_LOCATION3 = ""
				EASTERN_KINGDOM_LOCATION2H = ""
				KALIMDOR_LOCATION2H = ""
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = ""
				teR3:SetTexture("Interface\\DialogFrame\\UI-DialogBox-Background.blp")				
			end		
			if skillLevel == 525 then
				-- Twilight Jasmine
				WTN:GetResource(52987)
				EASTERN_KINGDOM_LOCATION1 = "Twilight Highlands 84-85"
				KALIMDOR_LOCATION1 =  EASTERN_KINGDOM_LOCATION1
				EASTERN_KINGDOM_LOCATION1H = EASTERN_KINGDOM_LOCATION1
				KALIMDOR_LOCATION1H =  EASTERN_KINGDOM_LOCATION1
				BUTTON1_HORZ_OFFSET = -24
				BUTTON1_VERT_OFFSET = 10
				BUTTON1_TOOLTIP_TITLE = Rname
				teR1:SetTexture(texture)
				bR1:Show()	
				-- Heartblossom
				WTN:GetResource(52986)							
				EASTERN_KINGDOM_LOCATION2 = "Deepholm 83-83"
				KALIMDOR_LOCATION2 =  EASTERN_KINGDOM_LOCATION2
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION2
				KALIMDOR_LOCATION2H =  EASTERN_KINGDOM_LOCATION2
				BUTTON2_HORZ_OFFSET = 0
				BUTTON2_VERT_OFFSET = 10
				BUTTON2_TOOLTIP_TITLE = Rname		
				teR2:SetTexture(texture)			
				-- Whiptail
				WTN:GetResource(52988)		
				EASTERN_KINGDOM_LOCATION3 = "Uldum 83-84"
				KALIMDOR_LOCATION3 = EASTERN_KINGDOM_LOCATION3
				EASTERN_KINGDOM_LOCATION2H = EASTERN_KINGDOM_LOCATION3
				KALIMDOR_LOCATION2H = EASTERN_KINGDOM_LOCATION3
				BUTTON1_HORZ_OFFSET = 24
				BUTTON3_VERT_OFFSET = 10		
				BUTTON3_TOOLTIP_TITLE = Rname
				teR3:SetTexture(texture)			
			end																																																						
		end		
	end		
end

-- Get the details of the resource that is being gathered
function WTN:GetResource(itemID)
	Rname, link, quality, iLevel, reqLevel, class, subclass, maxStack, equipSlot, texture, vendorPrice = GetItemInfo(itemID)
end


-- check and Notify user to skill up. Used for all three professions
function WTN:SkillNowCheck()
	if skillLevel == 50 then
		PlaySoundFile(DEFAULT_NOTIFY_SOUND, "Master")
	 	print("You may now train Journeyman ")
	end
	if skillLevel == 125 then
	 	PlaySoundFile(DEFAULT_NOTIFY_SOUND, "Master")
	 	print("You may now train Artisan ")
	end
	if skillLevel == 200 then
		PlaySoundFile(DEFAULT_NOTIFY_SOUND, "Master")
	 	print("You may now train Expert ")
	end
	if skillLevel == 275 then
		PlaySoundFile(DEFAULT_NOTIFY_SOUND, "Master")
	 	print("You may now train Master ")
	end
	if skillLevel == 350 then
		PlaySoundFile(DEFAULT_NOTIFY_SOUND, "Master")
	 	print("You may now train Grand Master ")
	end
	if skillLevel == 425 then
		PlaySoundFile(DEFAULT_NOTIFY_SOUND, "Master")
	 	print("You may now train Illustrious Grand Master ")
	end
end

function WTN:OnDisable()
   	WTNframe:UnregisterEvent("CHAT_MSG_SKILL")	
   	WTNframe:UnregisterEvent("PLAYER_LOGOUT")
   	WTNframe:UnregisterEvent("MINIMAP_UPDATE_TRACKING")	
end