local DEBUGFORCEVERSION
--[===[@debug@
DEBUGFORCEVERSION="1.0.0"
--@end-debug@]===]
-- fetch locale data
local L = LibStub("AceLocale-3.0"):GetLocale("GDKPd")
-- versioning info
local VERSIONING_STRINGS = {
	VERSION_NONFUNCTIONAL = L["This version of GDKPd was never functional due to internal errors."],
	INCOMPATIBLE_AUCTIONSTART = L["This version will be unable to recognize auctions started by you."],
	INCOMPATIBLE_DISTRIBUTE = L["This version's player balance window will be unable to recognize distributions by you."],
}
local COMPATIBLE_VERSIONS = {
	["1.0.0"]=true,
	["beta-11s"]=true,
	["beta-11r"]=true,
	["beta-11q"]=true,
	["beta-11p"]=true,
	["beta-11o"]=true,
	["beta-11m"]=true,
	["beta-11l"]=true,
	["beta-11i"]=true,
	["beta-11h"]=true,
	["beta-11g"]=true,
	["beta-11f"]=true,
	["beta-11e"]=true,
	["beta-11d"]=true,
	["beta-11c"]=true,
	["beta-11b"]=true,
	["beta-11a"]=true,
	["beta-11"]=true,
}
local INCOMPATIBLE_VERSIONS = {
	["beta-11n"]={"VERSION_NONFUNCTIONAL"},
	["beta-11k"]={"INCOMPATIBLE_DISTRIBUTE"},
	["beta-11j"]={"INCOMPATIBLE_DISTRIBUTE"},
	["beta-10h"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-10g"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-10f"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-10e"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-10d"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-10c"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-10b"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-10a"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-10"]={"VERSION_NONFUNCTIONAL"},
	["beta-9a"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-9"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-8"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-7b"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-7a"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-7"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-6"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-5"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-4"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-3"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-2b"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-2a"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-2"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-1a"]={"INCOMPATIBLE_AUCTIONSTART"},
	["beta-1"]={"INCOMPATIBLE_AUCTIONSTART"},
}
-- static popup dialog definition
StaticPopupDialogs["GDKPD_RESETPOT"] = {
	text=L["Do you want to save your pot or reset without saving? You can also add a note to the pot."],
	button1=SAVE.." & "..RESET,
	button2=CANCEL,
	button3=RESET,
	hasEditBox=true,
	EditBoxOnEnterPressed=function(self) self:GetParent().button1:Click() end,
	OnAccept=function(self)
		tinsert(GDKPd_PotData.history, {size=GDKPd_PotData.potAmount, date=date(), items=GDKPd_PotData.curPotHistory, note=(strlen(self.editBox:GetText()) > 0 and self.editBox:GetText())})
		GDKPd_PotData.potAmount = 0
		GDKPd_PotData.prevDist = 0
		GDKPd_PotData.curPotHistory = {}
		GDKPd_PotData.playerBalance = setmetatable({},{__index=function() return 0 end})
		GDKPd.status:Update()
		GDKPd.balance:Update()
		if GDKPd.history:IsShown() then
			GDKPd.history:Update()
		end
	end,
	OnAlt=function(self)
		GDKPd_PotData.potAmount = 0
		GDKPd_PotData.prevDist = 0
		GDKPd_PotData.curPotHistory = {}
		GDKPd_PotData.playerBalance = setmetatable({},{__index=function() return 0 end})
		GDKPd.status:Update()
		GDKPd.balance:Update()
	end,
	timeout=0,
}
StaticPopupDialogs["GDKPD_ADDTOPOT"] = {
	text=L["Enter the amount you want to add to the pot:"],
	button1=ADD,
	button2=CANCEL,
	hasEditBox=true,
	OnShow=function(self)
		self.button1:Disable()
	end,
	EditBoxOnEnterPressed=function(self) self:GetParent().button1:Click() end,
	EditBoxOnTextChanged = function(self)
		if strlen(self:GetText()) > 0 then
			self:GetParent().button1:Enable()
		else
			self:GetParent().button1:Disable()
		end
	end,
	OnAccept=function(self)
		GDKPd_PotData.potAmount = (tonumber(self.editBox:GetText()) or 0)+GDKPd_PotData.potAmount
		tinsert(GDKPd_PotData.curPotHistory, tonumber(self.editBox:GetText()) or 0)
		GDKPd.status:Update()
	end,
	timeout=0,
	whileDead=true,
}
StaticPopupDialogs["GDKPD_REMFROMPOT"] = {
	text=L["Enter the amount you want to subtract from the pot:"],
	button1=REMOVE,
	button2=CANCEL,
	hasEditBox=true,
	OnShow=function(self)
		self.button1:Disable()
	end,
	EditBoxOnEnterPressed=function(self) self:GetParent().button1:Click() end,
	EditBoxOnTextChanged=function(self)
		if strlen(self:GetText()) > 0 then
			self:GetParent().button1:Enable()
		else
			self:GetParent().button1:Disable()
		end
	end,
	OnAccept = function(self)
		GDKPd_PotData.potAmount = math.max(0, GDKPd_PotData.potAmount-(tonumber(self.editBox:GetText()) or 0))
		tinsert(GDKPd_PotData.curPotHistory, (tonumber(self.editBox:GetText()) or 0)*(-1))
		GDKPd.status:Update()
	end,
	timeout=0,
	whileDead=true,
}
StaticPopupDialogs["GDKPD_ADDTOPLAYER"] = {
	text=L["Enter the amount you want to add to player %s:"],
	button1=ADD,
	button2=CANCEL,
	hasEditBox=true,
	OnShow=function(self)
		self.button1:Disable()
	end,
	EditBoxOnEnterPressed=function(self) self:GetParent().button1:Click() end,
	EditBoxOnTextChanged=function(self)
		if strlen(self:GetText()) > 0 then
			self:GetParent().button1:Enable()
		else
			self:GetParent().button1:Disable()
		end
	end,
	OnAccept = function(self, data)
		GDKPd_PotData.playerBalance[data] = (GDKPd_PotData.playerBalance[data]+(tonumber(self.editBox:GetText()) or 0))
		SendAddonMessage("GDKPd_ManualAdjust",tostring((tonumber(self.editBox:GetText()) or 0)*(-1)),"WHISPER",data)
		GDKPd.balance:Update()
	end,
	timeout=0,
	whileDead=true,
}
StaticPopupDialogs["GDKPD_REMFROMPLAYER"] = {
	text=L["Enter the amount you want to subtract from player %s:"],
	button1=REMOVE,
	button2=CANCEL,
	hasEditBox=true,
	OnShow=function(self)
		self.button1:Disable()
	end,
	EditBoxOnEnterPressed=function(self) self:GetParent().button1:Click() end,
	EditBoxOnTextChanged=function(self)
		if strlen(self:GetText()) > 0 then
			self:GetParent().button1:Enable()
		else
			self:GetParent().button1:Disable()
		end
	end,
	OnAccept = function(self, data)
		GDKPd_PotData.playerBalance[data] = (GDKPd_PotData.playerBalance[data]-(tonumber(self.editBox:GetText()) or 0))
		SendAddonMessage("GDKPd_ManualAdjust",tostring(tonumber(self.editBox:GetText()) or 0),"WHISPER",data)
		GDKPd.balance:Update()
	end,
	timeout=0,
	whileDead=true,
}
StaticPopupDialogs["GDKPD_WIPEHISTORY"]={
	text=L["This will completely wipe your auction history and is IRREVERSIBLE.\nAre you completely SURE you want to do this?"],
	button1=L["Wipe history"],
	button2=CANCEL,
	OnAccept=function()
		table.wipe(GDKPd_PotData.history)
		if GDKPd.history:IsShown() then
			GDKPd.history:Update()
		end
	end,
	timeout=0,
	hideOnEscape=true,
	whileDead=true,
	showAlert=true,
	cancels="GDKPD_WIPEHISTORY",
}
StaticPopupDialogs["GDKPD_AUTOBID"] = {
	text=L["Enter the maximum amount of money you want to bid on %s:"],
	button1=BID,
	button2=CANCEL,
	hasEditBox=true,
	OnShow=function(self)
		self.button1:Disable()
	end,
	EditBoxOnEnterPressed=function(self) self:GetParent().button1:Click() end,
	EditBoxOnTextChanged = function(self)
		if strlen(self:GetText()) > 0 then
			self:GetParent().button1:Enable()
		else
			self:GetParent().button1:Disable()
		end
	end,
	OnAccept=function(self, data)
		data.maxAutoBid = tonumber(self.editBox:GetText())
		if (data.curbidismine == false) and data.maxAutoBid then
			local newBid = data.curbidamount + data.bidIncrement
			if newBid <= data.maxAutoBid then
				if data.isMultiBid then
					SendChatMessage(data.itemlink.." "..newBid,"RAID")
				else
					SendChatMessage(tostring(newBid),"RAID")
				end
			end
		end
		data.autobid:Hide()
		data.stopautobid:Show()
	end,
	timeout=0,
}
StaticPopupDialogs["GDKPD_CURPOTCLICK"]={
	text=L["You have selected the current pot, size %d gold.\nWhat do you want to do with this pot?"],
	button1=L["Export"],
	button3=DELETE,
	button2=CANCEL,
	OnShow=function(self) self.button3:Disable() end,
	OnAccept=function(self)
		local output = "GDKPd pot data for Current Pot\nPot size: "..GDKPd_PotData.potAmount.." gold"
		for _, aucdata in ipairs(GDKPd_PotData.curPotHistory) do
			if type(aucdata) == "table" then
				output = output.."\n"..(aucdata.item:match("(|h.+|h)"))..": "..aucdata.name.." ("..aucdata.bid.." gold)"
			else
				output = output.."\n"..L["Manual adjustment"]..": "..(aucdata > 0 and "+" or "")..aucdata.." gold"
			end
		end
		GDKPd.exportframe:Show()
		GDKPd.exportframe.box:SetText(output)
	end,
	timeout=0,
	whileDead=true,
}
StaticPopupDialogs["GDKPD_HISTORYCLICK"] = {
	text="%s",
	button1=L["Export"],
	button3=DELETE,
	button2=CANCEL,
	OnAccept=function(self, data)
		local output = "GDKPd pot data for "..data.date.."\nPot size: "..data.size.." gold"
		if data.note then
			output = output.."\nNote: "..data.note
		end
		if data.items then
			for _, aucdata in ipairs(data.items) do
				if type(aucdata) == "table" then
					output = output.."\n"..(aucdata.item:match("(|h.+|h)"))..": "..aucdata.name.." ("..aucdata.bid.." gold)"
				else
					output = output.."\n"..L["Manual adjustment"]..": "..(aucdata > 0 and "+" or "")..aucdata.." gold"
				end
			end
		end
		GDKPd.exportframe:Show()
		GDKPd.exportframe.box:SetText(output)
	end,
	OnAlt=function(self, data)
		for num, t in ipairs(GDKPd_PotData.history) do
			if t == data then
				tremove(GDKPd_PotData.history, num)
				break
			end
		end
		GDKPd.history:Update()
	end,
	timeout=0,
	whileDead=0,
}
StaticPopupDialogs["GDKPD_CUSTOMSETTINGSID"]={
	text=L["Please enter the itemID of an item you want to drop here:"],
	button1=OKAY,
	button2=CANCEL,
	hasEditBox=true,
	OnShow=function(self)
		self.button1:Disable()
	end,
	EditBoxOnEnterPressed=function(self) self:GetParent().button1:Click() end,
	hideOnEscape=true,
	EditBoxOnTextChanged = function(self)
		if (tonumber(self:GetText())) and (tonumber(self:GetText()) >= 0) and (not GDKPd.opt.customItemSettings[tonumber(self:GetText())]) then
			self:GetParent().button1:Enable()
		else
			self:GetParent().button1:Disable()
		end
	end,
	OnAccept=function(self)
		GDKPd.opt.customItemSettings[tonumber(self.editBox:GetText())] = {}
		GDKPd.itemsettings:Update()
	end,
	timeout=0,
}
local function round(num, places)
	return tonumber(string.format("%."..(places or 0).."f",num))
end
GDKPd = CreateFrame("Frame")
local GDKPd = GDKPd
GDKPd.frames = {}
GDKPd.curAuction = {}
GDKPd.curAuctions = {}
GDKPd.auctionList = {}
GDKPd.ignoredLinks = {}
GDKPd.versions = {}
GDKPd:Hide()
GDKPd:SetScript("OnUpdate", function(self, elapsed)
	if (not self.curAuction.item) and (not next(self.curAuctions)) then self:Hide() return end
	if not self.opt.allowMultipleAuctions then
		-- old code for single auctions
		local curPot = math.floor(self.curAuction.timeRemains/5)
		self.curAuction.timeRemains = self.curAuction.timeRemains-elapsed
		if (curPot ~= math.floor(self.curAuction.timeRemains/5)) and (curPot*5 < (self.curAuction.curBid and self.opt.auctionTimerRefresh or self.opt.auctionTimer)) and (curPot > 0) then
			SendChatMessage("[GDKPd] "..(curPot*5).." seconds remaining!","RAID")
		end
		if self.curAuction.timeRemains <= 0 then
			self:Hide()
			self:FinishAuction()
		end
	else
		-- new code for multiple auctions
		local auctionsToFinish = {}
		for item,aucdata in pairs(self.curAuctions) do
			local curPot = math.floor(aucdata.timeRemains/5)
			aucdata.timeRemains = aucdata.timeRemains-elapsed
			if (curPot ~= math.floor(aucdata.timeRemains/5)) and (curPot*5 < (self.curAuction.curBid and self.opt.auctionTimerRefresh or self.opt.auctionTimer)) and (curPot > 0) then
				SendChatMessage("[GDKPd] "..(curPot*5).." seconds remaining for item "..item.."!","RAID")
			end
			if aucdata.timeRemains <= 0 then
				tinsert(auctionsToFinish, item)
			end
		end
		if #auctionsToFinish > 0 then
			for _, link in ipairs(auctionsToFinish) do
				self:FinishAuction(link)
			end
		end
		-- there are no keys
		if not next(self.curAuctions) then
			self:Hide()
		end
	end
end)
local anchor = CreateFrame("Frame", "GDKPd_Anchor", UIParent)
anchor:EnableMouse(true)
anchor:SetScript("OnMouseDown", function(self)
	self:StartMoving()
end)
anchor:SetMovable(true)
anchor:SetScript("OnMouseUp", function(self)
	self:StopMovingOrSizing()
	GDKPd.opt.point.point, _, GDKPd.opt.point.relative, GDKPd.opt.point.x, GDKPd.opt.point.y = self:GetPoint()
end)
anchor:SetSize(300,60)
anchor:SetFrameStrata("DIALOG")
anchor:Hide()
anchor.movetx = anchor:CreateTexture()
anchor.movetx:SetAllPoints()
anchor.movetx:SetTexture(0.3,0.3,0.9)
anchor.movetx:SetAlpha(0.5)
anchor.movetx.text = anchor:CreateFontString()
anchor.movetx.text:SetFontObject(GameFontHighlightLarge)
anchor.movetx.text:SetText(L["GDKPd: Drag to move"])
anchor.movetx.text:SetAllPoints()
GDKPd.status = CreateFrame("Frame", "GDKPd_Status", UIParent)
local status = GDKPd.status
status:SetSize(200, 90)
status:Hide()
status:SetBackdrop({
	bgFile="Interface\\DialogFrame\\UI-DialogBox-Background",
	edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border",
	tileSize=32,
	tile=true,
	insets={
		top=12,
		bottom=12,
		right=12,
		left=12,
	},
})
function status:UpdateVisibility(forceCombat)
	if GDKPd.opt.hide then
		self:Hide()
		return
	end
	if ((not GDKPd.opt.hideCombat.status) or (not (forceCombat ~= nil and forceCombat or InCombatLockdown()))) and GDKPd:PlayerIsML((UnitName("player")),true) then
		self:Show()
	else
		self:Hide()
	end
end
status.header = CreateFrame("Button", nil, status)
status.header:SetNormalTexture("Interface\\DialogFrame\\UI-DialogBox-Header")
status.header:SetSize(133,34)
status.header.text = status.header:CreateFontString()
status.header.text:SetPoint("TOP",0,-7)
status.header.text:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
status.header.text:SetTextColor(1,1,1)
status.header.text:SetText("GDKPd")
status.header:SetMovable(true)
status.header:SetScript("OnMouseDown", function(self)
	self:StartMoving()
end)
status.header:SetScript("OnMouseUp", function(self)
	self:StopMovingOrSizing()
	GDKPd.opt.statuspoint.point, _, GDKPd.opt.statuspoint.relative, GDKPd.opt.statuspoint.x, GDKPd.opt.statuspoint.y = self:GetPoint()
end)
status:SetPoint("TOP", status.header, "TOP", 0, -6)
status:SetScript("OnShow", function(self)
	self:UpdateSize()
end)
status.text = status:CreateFontString()
status.text:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
status.text:SetTextColor(1,1,1)
status.text:SetPoint("TOPLEFT", 15, -15)
status.text:SetJustifyH("LEFT")
status.distribute = CreateFrame("Button", nil, status, "UIPanelButtonTemplate")
status.distribute:SetSize(65, 15)
status.distribute:SetPoint("TOPLEFT", status.text, "BOTTOMLEFT", 0, -5)
status.distribute:SetText(L["Distribute"])
status.distribute:SetScript("OnClick", function(self)
	GDKPd:DistributePot()
end)
status.reset = CreateFrame("Button", nil, status, "UIPanelButtonTemplate")
status.reset:SetSize(65, 15)
status.reset:SetPoint("LEFT", status.distribute, "RIGHT")
status.reset:SetText(RESET)
status.reset:SetScript("OnClick", function(self)
	StaticPopup_Show("GDKPD_RESETPOT")
end)
status.add = CreateFrame("Button", nil, status, "UIPanelButtonTemplate")
status.add:SetSize(15,15)
status.add:SetPoint("LEFT", status.reset, "RIGHT",10,0)
status.add:SetText("+")
status.add:SetScript("OnClick", function(self)
	StaticPopup_Show("GDKPD_ADDTOPOT")
end)
status.rem = CreateFrame("Button", nil, status, "UIPanelButtonTemplate")
status.rem:SetSize(15,15)
status.rem:SetPoint("LEFT", status.add, "RIGHT")
status.rem:SetText("-")
status.rem:SetScript("OnClick", function(self)
	StaticPopup_Show("GDKPD_REMFROMPOT")
end)
status.rules = CreateFrame("Button", nil, status, "UIPanelButtonTemplate")
status.rules:SetSize(170, 15)
status.rules:SetPoint("TOPLEFT", status.distribute, "BOTTOMLEFT")
status.rules:SetText(L["Broadcast rules"])
status.rules:SetScript("OnClick",function()
	local announceStrings = {""}
	for line in string.gmatch(GDKPd.opt.rulesString,"[^\n]+") do
		for word in string.gmatch(line, "%S+") do
			if strlen(announceStrings[#announceStrings])+1+strlen(word) > 255 then
				tinsert(announceStrings, word)
			else
				if strlen(announceStrings[#announceStrings]) > 0 then
					announceStrings[#announceStrings] = announceStrings[#announceStrings].." "..word
				else
					announceStrings[#announceStrings] = word
				end
			end
		end
		tinsert(announceStrings, "")
	end
	for _, msg in ipairs(announceStrings) do
		SendChatMessage(msg, "RAID")
	end
end)
status.rules:Disable()
status.itemhistory = CreateFrame("Button", nil, status, "UIPanelButtonTemplate")
status.itemhistory:SetSize(170, 15)
status.itemhistory:SetPoint("TOPLEFT", status.rules, "BOTTOMLEFT")
status.itemhistory:SetText(L["Auction history"])
status.itemhistory:SetScript("OnEnter", function(self)
	GameTooltip:ClearAllPoints()
	GameTooltip:ClearLines()
	GameTooltip:SetOwner(self, "ANCHOR_NONE")
	GameTooltip:AddLine(L["GDKPd auction history"],1,1,1)
	for _, aucdata in ipairs(GDKPd_PotData.curPotHistory) do
		if type(aucdata) == "table" then
			GameTooltip:AddDoubleLine("|T"..GetItemIcon(aucdata.item)..":12|t "..aucdata.item, aucdata.name.." ("..aucdata.bid.."|cffffd100g|r)",1,1,1,1,1,1)
		else
			GameTooltip:AddDoubleLine("|T:12|t "..L["Manual adjustment"], (aucdata > 0 and "+" or "")..aucdata.."|cffffd100g|r",1,1,1,1,1,1)
		end
	end
	GameTooltip:SetPoint("BOTTOM", self, "TOP", 0, 5)
	GameTooltip:Show()
end)
status.itemhistory:SetScript("OnLeave", function()
	GameTooltip:Hide()
end)
status.itemhistory:SetScript("OnClick", function()
	GDKPd.history:Show()
end)
status.announcetext = status:CreateFontString()
status.announcetext:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
status.announcetext:SetTextColor(1,1,1)
status.announcetext:SetPoint("TOPLEFT", status.itemhistory, "BOTTOMLEFT", 0, -5)
status.announcetext:SetJustifyH("LEFT")
status.announcetext:SetText(L["You have looted a monster!\nDo you want GDKPd to announce loot?"])
status.announcetext:Hide()
status.announce1 = CreateFrame("Button", nil, status, "UIPanelButtonTemplate")
status.announce1:SetSize(170,15)
status.announce1:SetPoint("TOPLEFT", status.announcetext, "BOTTOMLEFT", 0, -5)
status.announce1:SetText(L["Announce & auto-auction"])
status.announce1:SetScript("OnClick", function(self)
	GDKPd:AnnounceLoot(true)
	status.announcetext:Hide()
	self:Hide()
	status.announce2:Hide()
	status.noannounce:Hide()
	status:UpdateSize()
end)
status.announce1:Hide()
status.announce2 = CreateFrame("Button", nil, status, "UIPanelButtonTemplate")
status.announce2:SetSize(170,15)
status.announce2:SetPoint("TOPLEFT", status.announce1, "BOTTOMLEFT", 0, -5)
status.announce2:SetText(L["Announce loot"])
status.announce2:SetScript("OnClick", function(self)
	GDKPd:AnnounceLoot(false)
	status.announcetext:Hide()
	status.announce1:Hide()
	self:Hide()
	status.noannounce:Hide()
	status:UpdateSize()
end)
status.announce2:Hide()
status.noannounce = CreateFrame("Button", nil, status, "UIPanelButtonTemplate")
status.noannounce:SetSize(170,15)
status.noannounce:SetPoint("TOPLEFT", status.announce2, "BOTTOMLEFT", 0, -5)
status.noannounce:SetText(L["Do not announce"])
status.noannounce:SetScript("OnClick", function(self)
	status.announcetext:Hide()
	status.announce1:Hide()
	status.announce2:Hide()
	self:Hide()
	status:UpdateSize()
end)
status.noannounce:Hide()
function status:UpdateSize()
	local height = 80
	height = height+status.text:GetHeight()
	if status.announcetext:IsShown() then
		height=height+status.announcetext:GetHeight()+5
	end
	if status.announce1:IsShown() then
		height=height+20
	end
	if status.announce2:IsShown() then
		height=height+20
	end
	if status.noannounce:IsShown() then
		height=height+20
	end
	self:SetHeight(height)
end
function status:Update()
	local potAmount = (GDKPd_PotData.potAmount or 0)
	local lastDist = (GDKPd_PotData.prevDist or 0)
	if lastDist > 0 then
		self.text:SetText(L["Pot size: %d|cffffd100g|r"]:format(potAmount)..L[" |cffaa0000(Distribute: %dg)|r"]:format(potAmount-lastDist))
	else
		self.text:SetText(L["Pot size: %d|cffffd100g|r"]:format(potAmount))
	end
	self:UpdateSize()
end
GDKPd.history = CreateFrame("Frame", "GDKPd_History", UIParent)
local history = GDKPd.history
history:SetSize(200,95)
history:Hide()
history:SetBackdrop({
	bgFile="Interface\\DialogFrame\\UI-DialogBox-Background",
	edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border",
	tileSize=32,
	tile=true,
	insets={
		top=12,
		bottom=12,
		right=12,
		left=12,
	},
})
history.header = CreateFrame("Button", nil, history)
history.header:SetNormalTexture("Interface\\DialogFrame\\UI-DialogBox-Header")
history.header:SetSize(133,34)
history.header:SetHitRectInsets(31.5,31.5,4.5,14.5)
history.header.text = history.header:CreateFontString()
history.header.text:SetPoint("TOP",0,-7)
history.header.text:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
history.header.text:SetTextColor(1,1,1)
history.header.text:SetText(L["History"])
history.header:SetMovable(true)
history.header:SetScript("OnMouseDown", function(self)
	self:StartMoving()
end)
history.header:SetScript("OnMouseUp", function(self)
	self:StopMovingOrSizing()
end)
history.header:SetPoint("CENTER",UIParent,"CENTER")
history:SetPoint("TOP", history.header, "TOP", 0, -6)
history:SetScript("OnShow", function(self)
	self:Update()
end)
history.entries = setmetatable({},{__index=function(t,v)
	local f = CreateFrame("Button", nil, history)
	if v > 1 then
		f:SetPoint("TOPLEFT", t[v-1], "BOTTOMLEFT", 0, -5)
		f:SetPoint("TOPRIGHT", t[v-1], "BOTTOMRIGHT", 0, -5)
	else
		f:SetPoint("TOPLEFT", 15, -15)
		f:SetPoint("TOPRIGHT", -15, -15)
	end
	function f:UpdateHeight()
		self:SetHeight(f.date:GetHeight())
	end
	f.date = f:CreateFontString()
	f.date:SetFont("Fonts\\FRIZQT__.TTF", 8,"")
	f.date:SetTextColor(1,1,1)
	f.date:SetPoint("TOPLEFT")
	f.date:SetWidth(55)
	f.amount = f:CreateFontString()
	f.amount:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
	f.amount:SetTextColor(1,1,1)
	f.amount:SetPoint("TOPLEFT", f.date, "TOPRIGHT", 5, 0)
	f.amount:SetPoint("BOTTOMLEFT", f.date, "BOTTOMRIGHT", 5, 0)
	f.amount:SetWidth(40)
	f.amount:SetJustifyH("RIGHT")
	f.note = f:CreateFontString()
	f.note:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
	f.note:SetTextColor(1,1,1)
	f.note:SetPoint("BOTTOMLEFT", f.amount, "BOTTOMRIGHT", 5, 0)
	f.note:SetPoint("TOPRIGHT")
	f.note:SetJustifyH("LEFT")
	function f:SetDataTable(data)
		self.date:SetText(data.date:match("%S+"))
		self.rawdate = data.date
		self.amount:SetText(data.size.."|cffffd100g|r")
		self.rawamount = data.size
		self.note:SetText(data.note)
		self.itemtable = data.items
		self.data = data
		self:UpdateHeight()
	end
	function f:SetRawData(date,amount,note,items)
		self.date:SetText(date)
		self.rawdate = date
		self.amount:SetText(amount.."|cffffd100g|r")
		self.rawamount = amount
		self.note:SetText(note)
		self.itemtable = items
		self:UpdateHeight()
	end
	f:SetScript("OnEnter", function(self)
		GameTooltip:ClearAllPoints()
		GameTooltip:ClearLines()
		GameTooltip:SetOwner(self, "ANCHOR_NONE")
		if self.itemtable then
			GameTooltip:AddLine(L["GDKPd auction history for %s"]:format(self.rawdate),1,1,1)
			if self.note:GetText() then
				GameTooltip:AddLine(L["Auction note: %s"]:format(self.note:GetText()),1,1,1)
			end
			for _, aucdata in ipairs(self.itemtable) do
				if type(aucdata) == "table" then
					GameTooltip:AddDoubleLine("|T"..GetItemIcon(aucdata.item)..":12|t "..aucdata.item, aucdata.name.." ("..aucdata.bid.."|cffffd100g|r)",1,1,1,1,1,1)
				else
					GameTooltip:AddDoubleLine("|T:12|t "..L["Manual adjustment"], (aucdata > 0 and "+" or "")..aucdata.."|cffffd100g|r",1,1,1,1,1,1)
				end
			end
		else
			GameTooltip:AddLine(L["GDKPd: No detailed data available"],1,1,1)
		end
		GameTooltip:SetPoint("TOPRIGHT", self, "LEFT", -5, 0)
		GameTooltip:Show()
	end)
	f:SetScript("OnLeave", function(self)
		GameTooltip:Hide()
	end)
	f:SetScript("OnClick", function(self)
		print(GetCursorInfo())
		ClearCursor()
		if self.data then
			StaticPopup_Show("GDKPD_HISTORYCLICK", L["You have selected the following pot:\n%s, dated %s, size %d gold.\nWhat do you want to do with this pot?"]:format(self.note:GetText(), self.date:GetText(), self.rawamount)).data = self.data
		else
			StaticPopup_Show("GDKPD_CURPOTCLICK", GDKPd_PotData.potAmount)
		end
	end)
	t[v]=f
	return f
end})
history.hide = CreateFrame("Button", nil, history, "UIPanelButtonTemplate")
history.hide:SetSize(170,15)
history.hide:SetPoint("BOTTOM", 0, 15)
history.hide:SetText(L["Hide"])
history.hide:SetScript("OnClick", function() history:Hide() end)
function history:Update()
	for _, f in ipairs(self.entries) do
		f:Hide()
	end
	local c = 1
	local size = 45
	for _, potdata in ipairs(GDKPd_PotData.history) do
		local f = self.entries[c]
		f:Show()
		f:SetDataTable(potdata)
		size=size+f:GetHeight()+5
		c=c+1
	end
	if GDKPd_PotData.potAmount > 0 then
		local f = self.entries[c]
		f:Show()
		f:SetRawData("Current pot", GDKPd_PotData.potAmount, nil, GDKPd_PotData.curPotHistory)
		size=size+f:GetHeight()+5
		c=c+1
	end
	self:SetHeight(size)
end
GDKPd.itemsettings = CreateFrame("Frame", "GDKPd_ItemSettings", UIParent)
local itemsettings = GDKPd.itemsettings
itemsettings:SetWidth(250)
itemsettings:Hide()
itemsettings:SetBackdrop({
	bgFile="Interface\\DialogFrame\\UI-DialogBox-Background",
	edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border",
	tileSize=32,
	tile=true,
	insets={
		top=12,
		bottom=12,
		right=12,
		left=12,
	},
})
itemsettings.header = CreateFrame("Button", nil, itemsettings)
itemsettings.header:SetNormalTexture("Interface\\DialogFrame\\UI-DialogBox-Header")
itemsettings.header:SetSize(133,34)
itemsettings.header:SetHitRectInsets(31.5,31.5,4.5,14.5)
itemsettings.header.text = itemsettings.header:CreateFontString()
itemsettings.header.text:SetPoint("TOP", 0, -7)
itemsettings.header.text:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
itemsettings.header.text:SetTextColor(1,1,1)
itemsettings.header.text:SetText(L["Item settings"])
itemsettings.header:SetMovable(true)
itemsettings.header:SetScript("OnMouseDown", function(self)
	self:StartMoving()
end)
itemsettings.header:SetScript("OnMouseUp", function(self)
	self:StopMovingOrSizing()
end)
itemsettings.header:SetPoint("CENTER", UIParent, "CENTER")
itemsettings:SetPoint("TOP", itemsettings.header, "TOP", 0, -6)
itemsettings:SetScript("OnShow", function(self)
	self:Update()
end)
itemsettings.thead = CreateFrame("Frame", nil, itemsettings)
itemsettings.thead:SetPoint("TOPLEFT", 15, -15)
itemsettings.thead:SetPoint("TOPRIGHT", -15, -15)
itemsettings.thead:SetHeight(15)
itemsettings.thead.item = itemsettings.thead:CreateFontString()
itemsettings.thead.item:SetFont("Fonts\\FRIZQT__.TTF", 10)
itemsettings.thead.item:SetTextColor(1,0.82,0)
--itemsettings.thead.item:SetText(L["Itm"])
itemsettings.thead.item:SetPoint("LEFT")
itemsettings.thead.item:SetWidth(15)
itemsettings.thead.startbid = itemsettings.thead:CreateFontString()
itemsettings.thead.startbid:SetFont("Fonts\\FRIZQT__.TTF", 10)
itemsettings.thead.startbid:SetTextColor(1,0.82,0)
itemsettings.thead.startbid:SetText(L["Starting bid"])
itemsettings.thead.startbid:SetPoint("LEFT", itemsettings.thead.item, "RIGHT")
itemsettings.thead.startbid:SetWidth(102.5)
itemsettings.thead.minincre = itemsettings.thead:CreateFontString()
itemsettings.thead.minincre:SetFont("Fonts\\FRIZQT__.TTF", 10)
itemsettings.thead.minincre:SetTextColor(1,0.82,0)
itemsettings.thead.minincre:SetText(L["Minimum increment"])
itemsettings.thead.minincre:SetPoint("LEFT", itemsettings.thead.startbid, "RIGHT")
itemsettings.thead.minincre:SetPoint("RIGHT")
itemsettings.entries = setmetatable({}, {__index=function(t,v)
	local f = CreateFrame("Frame", nil, itemsettings)
	if v > 1 then
		f:SetPoint("TOPLEFT", t[v-1], "BOTTOMLEFT", 0, -5)
		f:SetPoint("TOPRIGHT", t[v-1], "BOTTOMRIGHT", 0, -5)
	else
		f:SetPoint("TOPLEFT", itemsettings.thead, "BOTTOMLEFT", 0, -5)
		f:SetPoint("TOPRIGHT", itemsettings.thead, "BOTTOMRIGHT", 0, -5)
	end
	f:SetHeight(15)
	f.itemicon = CreateFrame("Button", nil, f)
	f.itemicon:SetScript("OnEnter", function()
		if not f.itemID then return end
		GameTooltip:ClearAllPoints()
		GameTooltip:ClearLines()
		GameTooltip:SetOwner(f, "ANCHOR_NONE")
		GameTooltip:SetHyperlink("item:"..f.itemID)
		GameTooltip:SetPoint("RIGHT", itemsettings, "LEFT", -5, 0)
		GameTooltip:Show()
	end)
	f.itemicon:SetScript("OnLeave", function()
		GameTooltip:Hide()
	end)
	f.itemicon:SetSize(15,15)
	f.itemicon:SetHighlightTexture("Interface\\Buttons\\ButtonHilight-Square")
	f.itemicon:SetPoint("LEFT")
	f.itemicon:SetScript("OnMouseUp", function(self)
		if (select(1,GetCursorInfo())) == "item" then
			local id = (select(2, GetCursorInfo()))
			if GDKPd.opt.customItemSettings[id] then ClearCursor() return end
			if f.itemID then
				GDKPd.opt.customItemSettings[id] = GDKPd.opt.customItemSettings[f.itemID]
				GDKPd.opt.customItemSettings[f.itemID] = nil
			else
				GDKPd.opt.customItemSettings[id] = {}
			end
			ClearCursor()
			itemsettings:Update()
		else
			if f.itemID then
				local cis = GDKPd.opt.customItemSettings[f.itemID]
				if cis.minBid or cis.minIncrement then
					PickupItem(f.itemID)
				else
					GDKPd.opt.customItemSettings[f.itemID] = nil
					itemsettings:Update()
				end
			else
				StaticPopup_Show("GDKPD_CUSTOMSETTINGSID")
			end
		end
	end)
	f.itemicon:EnableMouse(true)
	f.minBid = CreateFrame("EditBox", nil, f)
	f.minBid:SetMultiLine(nil)
	f.minBid:SetScript("OnEditFocusGained", function(self) if not f.itemID then self:ClearFocus() end end)
	f.minBid:SetScript("OnEnterPressed", function(self) GDKPd.opt.customItemSettings[f.itemID].minBid = self:GetNumber() > 0 and self:GetNumber() or nil self:ClearFocus() itemsettings:Update() end)
	f.minBid:SetScript("OnEscapePressed", function(self) self:SetNumber(GDKPd.opt.customItemSettings[f.itemID].minBid) self:ClearFocus() end)
	f.minBid:SetFont("Fonts\\FRIZQT__.TTF", 10)
	f.minBid:SetTextColor(1,1,1)
	f.minBid:SetPoint("TOPLEFT", f.itemicon, "TOPRIGHT")
	f.minBid:SetPoint("BOTTOMLEFT", f.itemicon, "BOTTOMRIGHT")
	f.minBid:SetJustifyH("RIGHT")
	f.minBid:SetAutoFocus(false)
	f.minBid:SetWidth(102.5)
	f.minBid:SetTextInsets(5,5,2,2)
	f.minBid:SetNumeric(true)
	f.minBid:SetScript("OnTextChanged", function(self, userInput)
		if strlen(self:GetText()) > 0 then
			self.g:Show()
		else
			self.g:Hide()
		end
	end)
	f.minBid.g = f:CreateFontString()
	f.minBid.g:SetFont("Fonts\\FRIZQT__.TTF", 10)
	f.minBid.g:SetTextColor(1,0.82,0)
	f.minBid.g:SetText("g")
	f.minBid.g:SetPoint("RIGHT", f.itemicon, "RIGHT", 102.5, 0)
	f.minBid:SetPoint("RIGHT", f.minBid.g, "LEFT")
	f.minIncrement = CreateFrame("EditBox", nil, f)
	f.minIncrement:SetMultiLine(nil)
	f.minIncrement:SetScript("OnEditFocusGained", function(self) if not f.itemID then self:ClearFocus() end end)
	f.minIncrement:SetScript("OnEnterPressed", function(self) GDKPd.opt.customItemSettings[f.itemID].minIncrement = self:GetNumber() > 0 and self:GetNumber() or nil self:ClearFocus() itemsettings:Update() end)
	f.minIncrement:SetScript("OnEscapePressed", function(self) if GDKPd.opt.customItemSettings[f.itemID].minIncrement then self:SetNumber(GDKPd.opt.customItemSettings[f.itemID].minIncrement) else self:SetText("") end self:ClearFocus() end)
	f.minIncrement:SetFont("Fonts\\FRIZQT__.TTF", 10)
	f.minIncrement:SetTextColor(1,1,1)
	f.minIncrement:SetPoint("TOPLEFT", f.minBid.g, "TOPRIGHT")
	f.minIncrement:SetPoint("BOTTOMLEFT", f.minBid.g, "BOTTOMRIGHT")
	f.minIncrement:SetJustifyH("RIGHT")
	f.minIncrement:SetAutoFocus(false)
	--f.minIncrement:Setp(102.5)
	f.minIncrement:SetTextInsets(5,5,2,2)
	f.minIncrement:SetScript("OnTextChanged", function(self, userInput)
		if strlen(self:GetText()) > 0 then
			self.g:Show()
		else
			self.g:Hide()
		end
	end)
	f.minIncrement.g = f:CreateFontString()
	f.minIncrement.g:SetFont("Fonts\\FRIZQT__.TTF", 10)
	f.minIncrement.g:SetTextColor(1,0.82,0)
	f.minIncrement.g:SetText("g")
	f.minIncrement.g:SetPoint("RIGHT", f.minBid.g, "RIGHT", 102.5, 0)
	f.minIncrement:SetPoint("RIGHT", f.minIncrement.g, "LEFT")
	function f:SetItemID(itemID)
		if (not itemID) or (not GDKPd.opt.customItemSettings[itemID]) then
			self.itemicon:SetNormalTexture("Interface\\Buttons\\UI-Quickslot")
			self.minBid:SetText("")
			self.minIncrement:SetText("")
			self.itemID = nil
		else
			self.itemicon:SetNormalTexture((select(10, GetItemInfo(itemID))))
			if GDKPd.opt.customItemSettings[itemID].minBid then
				self.minBid:SetText(GDKPd.opt.customItemSettings[itemID].minBid)
			else
				self.minBid:SetText("")
			end
			if GDKPd.opt.customItemSettings[itemID].minIncrement then
				self.minIncrement:SetText(GDKPd.opt.customItemSettings[itemID].minIncrement)
			else
				self.minIncrement:SetText("")
			end
			self.itemID = itemID
		end
	end
	t[v] = f
	return f
end})
function itemsettings:Update()
	for _, btn in ipairs(self.entries) do btn:Hide() end
	local f = self.entries[1]
	f:Show()
	f:SetItemID()
	local c = 2
	for iID in pairs(GDKPd.opt.customItemSettings) do
		f = self.entries[c]
		f:Show()
		f:SetItemID(iID)
		c=c+1
	end
	self:SetHeight(65+20*(c-1))
end
itemsettings.hide = CreateFrame("Button", nil, itemsettings, "UIPanelButtonTemplate")
itemsettings.hide:SetSize(220, 15)
itemsettings.hide:SetPoint("BOTTOM", 0, 15)
itemsettings.hide:SetText(L["Hide"])
itemsettings.hide:SetScript("OnClick", function() itemsettings:Hide() end)
GDKPd.version = CreateFrame("Frame", "GDKPd_Versions", UIParent)
local version = GDKPd.version
version:SetSize(200,85)
version:Hide()
version:SetBackdrop({
	bgFile="Interface\\DialogFrame\\UI-DialogBox-Background",
	edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border",
	tileSize=32,
	tile=true,
	insets={
		top=12,
		bottom=12,
		right=12,
		left=12,
	},
})
version.header = CreateFrame("Button", nil, version)
version.header:SetNormalTexture("Interface\\DialogFrame\\UI-DialogBox-Header")
version.header:SetSize(133,34)
version.header:SetHitRectInsets(31.5,31.5,4.5,14.5)
version.header.text = version.header:CreateFontString()
version.header.text:SetPoint("TOP", 0, -7)
version.header.text:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
version.header.text:SetTextColor(1,1,1)
version.header.text:SetText(L["Versions"])
version.header:SetMovable(true)
version.header:SetScript("OnMouseDown", function(self)
	self:StartMoving()
end)
version.header:SetScript("OnMouseUp", function(self)
	self:StopMovingOrSizing()
end)
version.header:SetPoint("CENTER", UIParent, "CENTER")
version:SetPoint("TOP", version.header, "TOP", 0, -6)
version:SetScript("OnShow", function(self)
	self:Update()
end)
version.entries = setmetatable({},{__index=function(t,v)
	local f = CreateFrame("Button", nil, version)
	if v > 1 then
		f:SetPoint("TOPLEFT", t[v-1], "BOTTOMLEFT", 0, -5)
		f:SetPoint("TOPRIGHT", t[v-1], "BOTTOMRIGHT", 0, -5)
	else
		f:SetPoint("TOPLEFT", 15, -15)
		f:SetPoint("TOPRIGHT", -15, -15)
	end
	function f:UpdateHeight()
		self:SetHeight(f.name:GetHeight())
	end
	f.name = f:CreateFontString()
	f.name:SetFont("Fonts\\FRIZQT__.TTF", 8, "OUTLINE")
	f.name:SetTextColor(1,1,1)
	f.name:SetPoint("TOPLEFT")
	f.name:SetWidth(110)
	f.name:SetJustifyH("LEFT")
	f.version = f:CreateFontString()
	f.version:SetFont("Fonts\\FRIZQT__.TTF", 8, "OUTLINE")
	f.version:SetPoint("BOTTOMLEFT", f.name, "BOTTOMRIGHT", 5, 0)
	f.version:SetPoint("TOPRIGHT")
	f.version:SetJustifyH("LEFT")
	function f:SetVersion(name, versionstring)
		if not versionstring then
			f.version:SetTextColor(0.8,0,0)
			f.name:SetText(name)
			f.version:SetText("n/A")
			f.status = "not_installed"
			GDKPd.version.notify:Enable()
			self:UpdateHeight()
			return
		end
		if versionstring == (DEBUGFORCEVERSION or "1.0.0") then
			f.version:SetTextColor(0,0.8,0)
			f.name:SetText(name)
			f.version:SetText(versionstring)
			f.status = "updated"
		elseif COMPATIBLE_VERSIONS[versionstring] then
			f.version:SetTextColor(0.8,0.8,0)
			f.name:SetText(name)
			f.version:SetText(versionstring)
			f.status = "outdated_compatible"
			GDKPd.version.notify:Enable()
		elseif INCOMPATIBLE_VERSIONS[versionstring] then
			f.version:SetTextColor(0.8,0,0)
			f.name:SetText(name)
			f.version:SetText(versionstring)
			f.status = "outdated_incompatible"
			GDKPd.version.notify:Enable()
		else
			f.version:SetTextColor(0.3,0.3,1)
			f.name:SetText(name)
			f.version:SetText(versionstring)
			f.status = "self_outdated"
		end
		self:UpdateHeight()
	end
	f:SetScript("OnEnter", function(self)
		GameTooltip:ClearAllPoints()
		GameTooltip:ClearLines()
		GameTooltip:SetOwner(self, "ANCHOR_NONE")
		GameTooltip:AddLine(L["Version status for player %s"]:format(self.name:GetText()))
		if self.status == "updated" then
			GameTooltip:AddLine(L["This player has the same version of GDKPd as you do. Full compability is ensured."])
		elseif self.status == "outdated_compatible" then
			GameTooltip:AddLine(L["This player's version of GDKPd is outdated. However, their version should be fully compatible with yours."])
		elseif self.status == "outdated_incompatible" then
			GameTooltip:AddLine(L["This player's version of GDKPd is outdated and one or more functionalities are not compatible:"])
			for _, incompatible_string in ipairs(INCOMPATIBLE_VERSIONS[f.version:GetText()]) do
				GameTooltip:AddLine(" - "..VERSIONING_STRINGS[incompatible_string])
			end
		elseif self.status == "self_outdated" then
			GameTooltip:AddLine(L["This player's version of GDKPd is more advanced than yours. Please consult your Curse Client for updates or manually check the curse.com page."])
		elseif self.status == "not_installed" then
			GameTooltip:AddLine(L["This player does not have GDKPd running or his version of GDKPd does not yet support version checks."])
		end
		GameTooltip:SetPoint("TOPRIGHT", self, "LEFT", -5, 0)
		GameTooltip:Show()
	end)
	f:SetScript("OnLeave", function(self)
		GameTooltip:Hide()
	end)
	t[v] = f
	return f
end})
version.hide = CreateFrame("Button", nil, version, "UIPanelButtonTemplate")
version.hide:SetSize(170,15)
version.hide:SetPoint("BOTTOM", 0, 15)
version.hide:SetText(L["Hide"])
version.hide:SetScript("OnClick", function() version:Hide() end)
version.notify = CreateFrame("Button", nil, version, "UIPanelButtonTemplate")
version.notify:SetSize(170,15)
version.notify:SetPoint("BOTTOM", version.hide, "TOP", 0, 5)
version.notify:SetText(L["Notify outdated versions"])
version.notify:SetScript("OnClick", function()
	local c = 1
	local f = rawget(version.entries,c)
	while (f and f:IsShown()) do
		if f.status == "outdated_compatible" and GDKPd.opt.notifyVersions.notifyCompatibleOutdated then
			SendChatMessage(L["[GDKPd] Your version of GDKPd is slightly outdated compared to the raid leader's. Full compability should be possible, however, you might want to take some time and update GDKPd."], "WHISPER", nil, f.name:GetText())
		elseif f.status == "outdated_incompatible"  and GDKPd.opt.notifyVersions.notifyIncompatibleOutdated then
			SendChatMessage(L["[GDKPd] Your version of GDKPd is outdated and no longer compatible with the raid leader's in one or more functionalities. In order to ensure smooth performance, please update GDKPd."], "WHISPER", nil, f.name:GetText())
		elseif f.status == "not_installed" and GDKPd.opt.notifyVersions.notifyNotInstalled then
			SendChatMessage(L["[GDKPd] This raid uses GDKPd to faciliate its GDKP bidding process. While you can bid on items without having GDKPd installed, installing it provides you with a GUI bidding panel, auto bidding functions, auction timers, chat filtering and more!"], "WHISPER", nil, f.name:GetText())
		end
		c=c+1
		f=rawget(version.entries,c)
	end
end)
version.notify:Disable()
version.request = CreateFrame("Button", nil, version, "UIPanelButtonTemplate")
version.request:SetSize(170,15)
version.request:SetPoint("BOTTOM", version.notify, "TOP", 0, 5)
version.request:SetText(L["Request version data"])
version.request:SetScript("OnClick", function() GDKPd.hasRequestedData = true SendAddonMessage("GDKPd_Version","","RAID") end)
function version:Update()
	if not GDKPd.hasRequestedData then return end
	for _, f in ipairs(self.entries) do
		f:Hide()
	end
	self.notify:Disable()
	local size = 85
	for numRaid=1, GetNumRaidMembers() do
		local pName = UnitName("raid"..numRaid)
		local f = self.entries[numRaid]
		f:Show()
		f:SetVersion(pName, GDKPd.versions[pName])
		size=size+f:GetHeight()+5
	end
	self:SetHeight(size)
end
GDKPd.balance = CreateFrame("Frame", "GDKPd_PlayerBalance", status)
local balance = GDKPd.balance
balance:SetSize(200, 95)
balance:SetBackdrop({
	bgFile="Interface\\DialogFrame\\UI-DialogBox-Background",
	edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border",
	tileSize=32,
	tile=true,
	insets={
		top=12,
		bottom=12,
		right=12,
		left=12,
	},
})
balance.header = CreateFrame("Button", nil, balance)
balance.header:SetNormalTexture("Interface\\DialogFrame\\UI-DialogBox-Header")
balance.header:SetSize(133,34)
balance.header:SetHitRectInsets(31.5,31.5,4.5,14.5)
balance.header.text = balance.header:CreateFontString()
balance.header.text:SetPoint("TOP", 0, -7)
balance.header.text:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
balance.header.text:SetTextColor(1,1,1)
balance.header.text:SetText(L["Balance"])
balance.header:SetMovable(true)
balance.header:SetScript("OnMouseDown", function(self)
	if self:IsMovable() then
		self:StartMoving()
	end
end)
balance.header:SetScript("OnMouseUp", function(self)
	if self:IsMovable() then
		self:StopMovingOrSizing()
		GDKPd.opt.balancepoint.point, _, GDKPd.opt.balancepoint.relative, GDKPd.opt.balancepoint.x, GDKPd.opt.balancepoint.y = self:GetPoint()
	end
end)
balance:SetPoint("TOP", balance.header, "TOP", 0, -6)
balance.toggle = CreateFrame("Button", nil, balance, "UIPanelButtonTemplate")
balance.toggle:SetSize(170,15)
balance.toggle:SetPoint("TOP", 0, -15)
balance.toggle:SetText(L["Toggle zero balance"])
balance.toggle:SetScript("OnClick", function() GDKPd.opt.showZeroBalance = not GDKPd.opt.showZeroBalance GDKPd.balance:Update() end)
balance:SetScript("OnShow", function(self)
	self:Update()
end)
balance.entries = setmetatable({}, {__index=function(t,v)
	local f = CreateFrame("Button", nil, balance)
	if v > 1 then
		f:SetPoint("TOPLEFT", t[v-1], "BOTTOMLEFT", 0, -5)
		f:SetPoint("TOPRIGHT", t[v-1], "BOTTOMRIGHT", 0, -5)
	else
		f:SetPoint("TOPLEFT", 15, -35)
		f:SetPoint("TOPRIGHT", -15, -35)
	end
	function f:UpdateHeight()
		self:SetHeight(math.max(self.name:GetHeight(), self.amount:GetHeight()))
	end
	f.name = f:CreateFontString()
	f.name:SetPoint("TOPLEFT")
	f.name:SetPoint("BOTTOMLEFT")
	f.name:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
	f.name:SetTextColor(1,1,1)
	f.name:SetJustifyH("LEFT")
	f.amount = f:CreateFontString()
	f.amount:SetPoint("TOPLEFT", f.name, "TOPRIGHT", 5, 0)
	f.amount:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
	f.amount:SetTextColor(1,1,1)
	f.amount:SetJustifyH("RIGHT")
	f.add = CreateFrame("Button", nil, f, "UIPanelButtonTemplate")
	f.add:SetSize(15,15)
	f.add:SetText("+")
	f.add:SetScript("OnClick", function(self)
		StaticPopup_Show("GDKPD_ADDTOPLAYER", f.name:GetText()).data=f.name:GetText()
	end)
	f.rem = CreateFrame("Button", nil, f, "UIPanelButtonTemplate")
	f.rem:SetSize(15,15)
	f.rem:SetText("-")
	f.rem:SetScript("OnClick", function(self)
		StaticPopup_Show("GDKPD_REMFROMPLAYER", f.name:GetText()).data=f.name:GetText()
	end)
	--f.rem:SetPoint("TOPRIGHT")
	f.rem:SetPoint("RIGHT")
	f.add:SetPoint("RIGHT", f.rem, "LEFT")
	--f.add:SetPoint("BOTTOMRIGHT", f.rem, "BOTTOMLEFT")
	f.amount:SetPoint("BOTTOMRIGHT", f.add, "BOTTOMLEFT")
	function f.amount:SetAmount(gAmount)
		if gAmount > 0 then
			self:SetText("|cff00ff00"..gAmount.."|r|cffffd100g|r")
		elseif gAmount < 0 then
			self:SetText("|cffff0000"..gAmount.."|r|cffffd100g|r")
		else
			self:SetText("0|cffffd100g|r")
		end
	end
	t[v] = f
	return f
end})
function balance:UpdatePosition()
	local f = self.header
	f:ClearAllPoints()
	if not GDKPd.opt.anchorBalance then
		f:SetPoint(GDKPd.opt.balancepoint.point, UIParent, GDKPd.opt.balancepoint.relative, GDKPd.opt.balancepoint.x, GDKPd.opt.balancepoint.y)
		f:SetMovable(true)
	else
		f:SetPoint("TOP", status, "BOTTOM", 0, -15)
		f:StopMovingOrSizing()
		f:SetMovable(false)
	end
end
function balance:Update()
	for _, f in ipairs(self.entries) do
		f:Hide()
	end
	local c = 1
	local size = 50
	if (GDKPd.isTrading) then
		local f = self.entries[c]
		f:Show()
		f.amount:SetAmount(GDKPd_PotData.playerBalance[(UnitName("NPC"))])
		f.name:SetText((UnitName("NPC")))
		f:UpdateHeight()
		c = c+1
		size=size+f:GetHeight()+5
	end
	for name, amount in pairs(GDKPd_PotData.playerBalance) do
		if ((not GDKPd.isTrading) or (name ~= (UnitName("NPC")))) and (amount ~= 0) and (name ~= (UnitName("player"))) then
			local f = self.entries[c]
			f:Show()
			f.name:SetText(name)
			f.amount:SetAmount(amount)
			f:UpdateHeight()
			c = c+1
			size=size+f:GetHeight()+5
		end
	end
	if GDKPd.opt.showZeroBalance then
		for raidNum=1, GetNumRaidMembers() do
			local name = UnitName("raid"..raidNum)
			if not rawget(GDKPd_PotData.playerBalance, name) then
				local f = self.entries[c]
				f:Show()
				f.name:SetText(name)
				f.amount:SetAmount(0)
				f:UpdateHeight()
				c = c+1
				size=size+f:GetHeight()+5
			end
		end
	end
	self:SetHeight(size)
end
GDKPd.playerBalance = CreateFrame("Frame", "GDKPd_PlayerBalance", UIParent)
local playerBalance = GDKPd.playerBalance
playerBalance:SetSize(200, 95)
playerBalance:SetBackdrop({
	bgFile="Interface\\DialogFrame\\UI-DialogBox-Background",
	edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border",
	tileSize=32,
	tile=true,
	insets={
		top=12,
		bottom=12,
		right=12,
		left=12,
	},
})
playerBalance.header = CreateFrame("Button", nil, playerBalance)
playerBalance.header:SetNormalTexture("Interface\\DialogFrame\\UI-DialogBox-Header")
playerBalance.header:SetSize(133,34)
playerBalance.header:SetHitRectInsets(31.5,31.5,4.5,14.5)
playerBalance.header.text = playerBalance.header:CreateFontString()
playerBalance.header.text:SetPoint("TOP", 0, -7)
playerBalance.header.text:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
playerBalance.header.text:SetTextColor(1,1,1)
playerBalance.header.text:SetText(L["Player balance"])
playerBalance.header:SetMovable(true)
playerBalance.header:SetScript("OnMouseDown", function(self)
	self:StartMoving()
end)
playerBalance.header:SetScript("OnMouseUp", function(self)
	self:StopMovingOrSizing()
	GDKPd.opt.playerbalancepoint.point, _, GDKPd.opt.playerbalancepoint.relative, GDKPd.opt.playerbalancepoint.x, GDKPd.opt.playerbalancepoint.y = self:GetPoint()
end)
playerBalance:SetPoint("TOP", playerBalance.header, "TOP", 0, -6)
playerBalance:SetScript("OnShow", function(self)
	self:Update()
end)
playerBalance.reset = CreateFrame("Button", nil, playerBalance, "UIPanelButtonTemplate")
playerBalance.reset:SetSize(170,15)
playerBalance.reset:SetPoint("BOTTOM", 0, 15)
playerBalance.reset:SetText(RESET)
playerBalance.reset:SetScript("OnClick", function() GDKPd_BalanceData = setmetatable({},{__index=function() return 0 end}) GDKPd.playerBalance:Update() end)
playerBalance.entries = setmetatable({}, {__index=function(t,v)
	local f = CreateFrame("Button", nil, playerBalance)
	if v > 1 then
		f:SetPoint("TOPLEFT", t[v-1], "BOTTOMLEFT", 0, -5)
		f:SetPoint("TOPRIGHT", t[v-1], "BOTTOMRIGHT", 0, -5)
	else
		f:SetPoint("TOPLEFT", 15, -15)
		f:SetPoint("TOPRIGHT", -15, -15)
	end
	function f:UpdateHeight()
		self:SetHeight(math.max(self.name:GetHeight(), self.amount:GetHeight()))
	end
	f.name = f:CreateFontString()
	f.name:SetPoint("TOPLEFT")
	f.name:SetPoint("BOTTOMLEFT")
	f.name:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
	f.name:SetTextColor(1,1,1)
	f.name:SetJustifyH("LEFT")
	f.amount = f:CreateFontString()
	f.amount:SetPoint("TOPLEFT", f.name, "TOPRIGHT", 5, 0)
	f.amount:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
	f.amount:SetTextColor(1,1,1)
	f.amount:SetJustifyH("RIGHT")
	f.amount:SetPoint("BOTTOMRIGHT")
	function f.amount:SetAmount(gAmount)
		if gAmount > 0 then
			self:SetText("|cff00ff00"..gAmount.."|r|cffffd100g|r")
		elseif gAmount < 0 then
			self:SetText("|cffff0000"..gAmount.."|r|cffffd100g|r")
		else
			self:SetText("0|cffffd100g|r")
		end
	end
	t[v] = f
	return f
end})
function playerBalance:UpdateVisibility(forceCombat)
	if GDKPd.opt.hide then
		self:Hide()
		return
	end
	if (self:GetHeight() > 50) and ((not GDKPd.opt.hideCombat.status) or (not (forceCombat~=nil and forceCombat or InCombatLockdown()))) then
		self:Show()
	else
		self:Hide()
	end
end
function playerBalance:Update()
	for _, f in ipairs(self.entries) do
		f:Hide()
	end
	local c = 1
	local size = 45
	if (GDKPd.isTrading) then
		local f = self.entries[c]
		f:Show()
		f.amount:SetAmount(GDKPd_BalanceData[(UnitName("NPC"))])
		f.name:SetText((UnitName("NPC")))
		f:UpdateHeight()
		c = c+1
		size=size+f:GetHeight()+5
	end
	for name, amount in pairs(GDKPd_BalanceData) do
		if ((not GDKPd.isTrading) or (name ~= (UnitName("NPC")))) and (amount ~= 0) and (name ~= (UnitName("player"))) then
			local f = self.entries[c]
			f:Show()
			f.name:SetText(name)
			f.amount:SetAmount(amount)
			f:UpdateHeight()
			c = c+1
			size=size+f:GetHeight()+5
		end
	end
	self:SetHeight(size)
	self:UpdateVisibility()
end
GDKPd.exportframe = CreateFrame("Frame", "GDKPd_Export", UIParent)
local export = GDKPd.exportframe
export:Hide()
export:SetBackdrop({
	bgFile="Interface\\DialogFrame\\UI-DialogBox-Background",
	edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border",
	tileSize=32,
	tile=true,
	insets={
		top=12,
		bottom=12,
		right=12,
		left=12,
	},
})
export.header = CreateFrame("Button", nil, export)
export.header:SetNormalTexture("Interface\\DialogFrame\\UI-DialogBox-Header")
export.header:SetSize(133,34)
export.header:SetHitRectInsets(31.5,31.5,4.5,14.5)
export.header.text = export.header:CreateFontString()
export.header.text:SetPoint("TOP", 0, -7)
export.header.text:SetFont("Fonts\\FRIZQT__.TTF", 8, "")
export.header.text:SetTextColor(1,1,1)
export.header.text:SetText(L["Pot export"])
export.header:SetMovable(true)
export.header:SetScript("OnMouseDown", function(self)
	self:StartMoving()
end)
export.header:SetScript("OnMouseUp", function(self)
	self:StopMovingOrSizing()
end)
export.header:SetPoint("TOP", history, "BOTTOM", 0, -10)
export.box = CreateFrame("EditBox", nil, export)
export.box:SetMultiLine(true)
export.box:SetAutoFocus(false)
export.box:SetFont("Fonts\\FRIZQT__.TTF", 12)
export.box:SetPoint("TOP", export.header, "TOP", 0, -21)
export.box:SetJustifyH("LEFT")
export.box:SetWidth(50)
do
	local st = export.box.SetText
	local dummy_text = UIParent:CreateFontString()
	dummy_text:SetFont("Fonts\\FRIZQT__.TTF", 12)
	function export.box:SetText(text)
		dummy_text:SetText(text)
		self:SetWidth(dummy_text:GetStringWidth())
		self.text = text
		st(self, text)
	end
end
export.box:SetScript("OnTextChanged", function(self, userInput)
	if userInput then
		self:SetText(self.text or "")
	end
	self:HighlightText()
	self:SetFocus()
end)
export.box:SetScript("OnEscapePressed", function(self)
	self:ClearFocus()
	export:Hide()
end)
export.box:SetScript("OnEnterPressed", function(self)
	self:ClearFocus()
end)
export:SetPoint("TOPLEFT", export.box, "TOPLEFT", -15, 15)
export:SetPoint("BOTTOMRIGHT", export.box, "BOTTOMRIGHT", 15, -15)
function GDKPd:SetMovable(movable)
	if movable then
		anchor:EnableMouse(true)
		anchor:Show()
	else
		anchor:EnableMouse(false)
		anchor:Hide()
	end
end
function GDKPd:FetchFrameFromLink(itemLink)
	for num, frame in ipairs(GDKPd.frames) do
		if (frame.itemlink == itemLink) and frame.isActive then
			return frame,num
		end
	end
end
function GDKPd:PlayerIsML(playerName, invert)
	for raidID = (invert and GetNumRaidMembers() or 1), (invert and 1 or GetNumRaidMembers()), (invert and -1 or 1) do
		local name, _, _, _, _,_,_,_,_,_,isML = GetRaidRosterInfo(raidID)
		if (name == playerName) then
			return isML
		end
	end
end
function GDKPd:AnnounceLoot(shouldQueueAuctions)
	if GetNumLootItems() <= 0 then return end
	local lootList = {}
	local minQuality = (self.opt.minQuality == -1 and GetLootThreshold() or self.opt.minQuality)
	local mlPosition
	if self.opt.awardToML then
		local playerName = (UnitName("player"))
		local candidateIndex = 1
		local candidateName = GetMasterLootCandidate(candidateIndex)
		while candidateName do
			if candidateName == playerName then
				mlPosition = candidateIndex
				break
			end
			candidateIndex = candidateIndex + 1
			candidateName = GetMasterLootCandidate(candidateIndex)
		end
	end
	for numLoot=1, GetNumLootItems() do
		if LootSlotIsItem(numLoot) then
			local tex, item, quantity, quality, isLocked = GetLootSlotInfo(numLoot)
			if quality >= minQuality then
				tinsert(lootList, GetLootSlotLink(numLoot))
				if mlPosition then
					GiveMasterLoot(numLoot, mlPosition)
				end
			end
		end
	end
	local lootString = L["[GDKPd] Loot dropped: "]..lootList[1]
	for lootNum, link in ipairs(lootList) do
		if lootNum > 1 then
			if strlen(lootString)+strlen(link)+2 > 255 then
				SendChatMessage(lootString,"RAID")
				lootString=link
			else
				lootString=lootString..", "..link
			end
		end
	end
	SendChatMessage(lootString, "RAID")
	for _, item in ipairs(lootList) do
		if shouldQueueAuctions then
			local itemID = tonumber(item:match("|Hitem:(%d+):"))
			local startBid = (GDKPd.opt.customItemSettings[itemID] and GDKPd.opt.customItemSettings[itemID].minBid) or self.opt.startBid
			local increment = (GDKPd.opt.customItemSettings[itemID] and GDKPd.opt.customItemSettings[itemID].minIncrement) or self.opt.increment
			GDKPd:QueueAuction(item, startBid, increment)
		else
			SendAddonMessage("GDKPd_Start", item, "RAID")
		end
	end
end
function GDKPd:QueueAuction(item, minbid, increment)
	if (not GDKPd.curAuction.item) or GDKPd.opt.allowMultipleAuctions then
		GDKPd:AuctionOffItem(item, minbid, increment)
	else
		SendAddonMessage("GDKPd_Start", item, "RAID")
		tinsert(GDKPd.auctionList,{item,minbid,increment})
	end
end
function GDKPd:AuctionOffItem(item, minbid, increment)
	if (GDKPd.curAuction.item) and (not self.opt.allowMultipleAuctions) then return end
	if (self.opt.allowMultipleAuctions) and (self.curAuctions[item]) then return end
	if (not self.opt.allowMultipleAuctions) then
		-- old code
		SendChatMessage(("[GDKPd] Bidding starts on %s. Please bid in raid chat, starting bid %d gold, minimum increment %d gold. TTL: %d/%d"):format(item,minbid,increment,self.opt.auctionTimer, self.opt.auctionTimerRefresh), (self.opt.announceRaidWarning and (IsRaidOfficer() or IsRaidLeader())) and "RAID_WARNING" or "RAID")
		GDKPd.curAuction.item = item
		GDKPd.curAuction.curBid = (minbid-increment)
		GDKPd.curAuction.increment = increment
		GDKPd.curAuction.bidders = {}
		GDKPd.curAuction.timeRemains = self.opt.auctionTimer
	else
		-- new code
		SendChatMessage(("[GDKPd] Bidding starts on %s. Bid using format '[item] 1000', starting bid %d gold, minimum increment %d gold. TTL: %d/%d"):format(item,minbid,increment,self.opt.auctionTimer, self.opt.auctionTimerRefresh), (self.opt.announceRaidWarning and (IsRaidOfficer() or IsRaidLeader())) and "RAID_WARNING" or "RAID")
		GDKPd.curAuctions[item] = {item=item,curBid=(minbid-increment),increment=increment,bidders={},timeRemains=self.opt.auctionTimer}
	end
	GDKPd:Show()
end
function GDKPd:FinishAuction(link)
	if self.opt.allowMultipleAuctions then
		-- new code
		if not link then return end
		local aucdata = self.curAuctions[link]
		table.sort(aucdata.bidders, function(a,b) return a.bidAmount > b.bidAmount end)
		if aucdata.bidders[1] then
			local totalAmount = aucdata.bidders[1].bidAmount
			local remAmount = totalAmount
			local paymentString = "%d to pot"
			if self.opt.shareSecondEnable and aucdata.bidders[2] then
				local secondShare = round(totalAmount*self.opt.shareSecondAmount)
				remAmount = remAmount-secondShare
				paymentString = paymentString..", "..secondShare.." to "..aucdata.bidders[2].bidderName
			end
			if self.opt.shareThirdEnable and aucdata.bidders[3] then
				local thirdShare = round(totalAmount*self.opt.shareThirdAmount)
				remAmount = remAmount-thirdShare
				paymentString = paymentString..", "..thirdShare.." to "..aucdata.bidders[3].bidderName
			end
			paymentString = paymentString:format(remAmount)
			SendChatMessage(("[GDKPd] Auction finished for %s. Winner: %s. %s."):format(link, aucdata.bidders[1].bidderName, paymentString),"RAID")
			GDKPd_PotData.potAmount = (GDKPd_PotData.potAmount or 0)+remAmount
			GDKPd_PotData.playerBalance[aucdata.bidders[1].bidderName] = GDKPd_PotData.playerBalance[aucdata.bidders[1].bidderName] -remAmount
			GDKPd.balance:Update()
			if self.opt.announcePotAfterAuction then
				SendChatMessage("[GDKPd] Current pot: "..GDKPd_PotData.potAmount.." gold","RAID")
			end
			tinsert(GDKPd_PotData.curPotHistory, {item=link, bid=totalAmount, name=aucdata.bidders[1].bidderName})
			self.status:Update()
			if self.opt.autoAwardLoot then
				local bestBidderName = aucdata.bidders[1].bidderName
				local candidateIndex = 1
				local candidateName = GetMasterLootCandidate(candidateIndex)
				while candidateName do
					if candidateName == bestBidderName then
						for lootSlot = 1, GetNumLootItems() do
							if GetLootSlotLink(lootSlot) == link then
								GiveMasterLoot(lootSlot,candidateIndex)
								break
							end
						end
						break
					end
					candidateIndex = candidateIndex + 1
					candidateName = GetMasterLootCandidate(candidateIndex)
				end
			end
		else
			SendChatMessage(("[GDKPd] Auction finished for %s. No bids recieved."):format(link),"RAID")
		end
		self.curAuctions[link] = nil
	else
		-- old code
		table.sort(self.curAuction.bidders, function(a,b) return a.bidAmount > b.bidAmount end)
		if self.curAuction.bidders[1] then
			local totalAmount = self.curAuction.bidders[1].bidAmount
			local remAmount = totalAmount
			local paymentString = "%d to pot"
			if self.opt.shareSecondEnable and self.curAuction.bidders[2] then
				local secondShare = round(totalAmount*self.opt.shareSecondAmount)
				remAmount = remAmount-secondShare
				paymentString = paymentString..", "..secondShare.." to "..self.curAuction.bidders[2].bidderName
			end
			if self.opt.shareThirdEnable and self.curAuction.bidders[3] then
				local thirdShare = round(totalAmount*self.opt.shareThirdAmount)
				remAmount = remAmount-thirdShare
				paymentString = paymentString..", "..thirdShare.." to "..self.curAuction.bidders[3].bidderName
			end
			paymentString = paymentString:format(remAmount)
			SendChatMessage(("[GDKPd] Auction finished. Winner: %s. %s."):format(self.curAuction.bidders[1].bidderName, paymentString),"RAID")
			GDKPd_PotData.potAmount = (GDKPd_PotData.potAmount or 0)+remAmount
			GDKPd_PotData.playerBalance[self.curAuction.bidders[1].bidderName] = GDKPd_PotData.playerBalance[self.curAuction.bidders[1].bidderName] -remAmount
			GDKPd.balance:Update()
			if self.opt.announcePotAfterAuction then
				SendChatMessage("[GDKPd] Current pot: "..GDKPd_PotData.potAmount.." gold","RAID")
			end
			tinsert(GDKPd_PotData.curPotHistory, {item=self.curAuction.item, bid=totalAmount, name=self.curAuction.bidders[1].bidderName})
			self.status:Update()
			if self.opt.autoAwardLoot then
				local bestBidderName = self.curAuction.bidders[1].bidderName
				local candidateIndex = 1
				local candidateName = GetMasterLootCandidate(candidateIndex)
				while candidateName do
					if candidateName == bestBidderName then
						for lootSlot = 1, GetNumLootItems() do
							if GetLootSlotLink(lootSlot) == self.curAuction.item then
								GiveMasterLoot(lootSlot,candidateIndex)
								break
							end
						end
						break
					end
					candidateIndex = candidateIndex + 1
					candidateName = GetMasterLootCandidate(candidateIndex)
				end
			end
		else
			SendChatMessage("[GDKPd] Auction finished. No bids recieved.","RAID")
		end
		table.wipe(self.curAuction)
		if self.auctionList[1] then
			self:AuctionOffItem(unpack(self.auctionList[1]))
			tremove(self.auctionList,1)
		end
	end
end
function GDKPd:DistributePot()
	local numraid = GetRealNumRaidMembers()
	if not (numraid > 0) then return end
	local distAmount = (GDKPd_PotData.potAmount or 0)-(GDKPd_PotData.prevDist or 0)
	if distAmount <= 0 then return end
	SendChatMessage(("[GDKPd] Distributing pot. Pot size: %d gold. Amount to distribute: %d gold. Players in raid: %d. Share per player: %d gold."):format((GDKPd_PotData.potAmount or 0), distAmount, numraid, (distAmount or 0)/numraid),"RAID")
	for numRaid=1, numraid do
		GDKPd_PotData.playerBalance[(UnitName("raid"..numRaid))] = GDKPd_PotData.playerBalance[(UnitName("raid"..numRaid))]+math.floor((distAmount or 0)/numraid)
	end
	GDKPd_PotData.prevDist = GDKPd_PotData.potAmount
	GDKPd.balance:Update()
end
function GDKPd:GetUnoccupiedFrame()
	local c = 1
	while GDKPd.frames[c] do
		if not GDKPd.frames[c]:IsShown() then
			GDKPd.frames[c].hide:Disable()
			GDKPd.frames[c].bidbox:SetNumber(0)
			GDKPd.frames[c].autobid:Disable()
			GDKPd.frames[c].bidbox:Hide()
			GDKPd.frames[c].bid:Disable()
			GDKPd.frames[c].itemlink = nil
			GDKPd.frames[c].maxAutoBid = nil
			GDKPd.frames[c].curbidamount = nil
			GDKPd.frames[c].curbidismine = nil
			GDKPd.frames[c].bidIncrement = nil
			GDKPd.frames[c].autobid:Show()
			GDKPd.frames[c].stopautobid:Hide()
			GDKPd.frames[c].curbid:Hide()
			GDKPd.frames[c].isActive = false
			return GDKPd.frames[c]
		end
		c=c+1
	end
	local f = CreateFrame("Frame", "GDKPdBidFrame"..c, UIParent)
	f:SetSize(300,60)
	f:SetBackdrop({
		bgFile="Interface\\Tooltips\\UI-Tooltip-Background",
		tileSize=16,
		edgeFile="Interface\\Tooltips\\UI-Tooltip-Border",
		tile=true,
		edgeSize=16,
		insets={top=5,bottom=5,left=5,right=5},
	})
	f:SetPoint("TOPLEFT", anchor, "TOPLEFT", 0, (-60)*(c-1))
	f:Hide()
	f:SetFrameStrata("DIALOG")
	f.icon = f:CreateTexture()
	f.icon:SetSize(40,40)
	f.icon:SetTexture(1,1,1)
	f.icon:SetPoint("TOPLEFT", 10, -10)
	f.itemstring = f:CreateFontString()
	f.itemstring:SetFont("Fonts\\FRIZQT__.TTF", 12, "OUTLINE")
	f.itemstring:SetTextColor(1,1,1)
	f.itemstring:SetPoint("TOPLEFT", f.icon, "TOPRIGHT", 5, 0)
	f.itemstring:SetWidth(160)
	f.itemstring:SetWordWrap(false)
	f.itemstring:SetJustifyH("LEFT")
	f.curbid = f:CreateFontString()
	f.curbid:SetFont("Fonts\\FRIZQT__.TTF", 10, "")
	f.curbid:SetTextColor(1,1,1)
	f.curbid:SetPoint("TOPLEFT", f.itemstring, "BOTTOMLEFT", 0, -5)
	f.curbid:Hide()
	f.highestbid = f:CreateFontString()
	f.highestbid:SetFont("Fonts\\FRIZQT__.TTF", 10, "OUTLINE")
	f.highestbid:SetTextColor(0,0.8,0)
	f.highestbid:SetPoint("TOPLEFT", f.curbid, "BOTTOMLEFT", 0, -5)
	f.highestbid:SetText("You are the top bidder!")
	f.highestbidder = f:CreateFontString()
	f.highestbidder:SetFont("Fonts\\FRIZQT__.TTF", 10, "")
	f.highestbidder:SetTextColor(1,1,1)
	f.highestbidder:SetPoint("TOPLEFT", f.curbid, "BOTTOMLEFT", 0, -5)
	f.timer = CreateFrame("Cooldown",nil,f)
	-- omnicc stuff
	f.timer.noCooldownCount = true
	f.timer:SetReverse(true)
	f.timer:SetAllPoints(f.icon)
	f.timer.update = CreateFrame("Frame")
	f.timer.update:Hide()
	f.timer.update:SetScript("OnUpdate", function(self)
		local timeRemain = self.endTime-GetTime()
		if timeRemain <= 0 then
			self:Hide()
			f.timer.text:Hide()
		end
		if timeRemain%1 > 0.5 then
			f.timer.text:SetTextColor(1,0,0)
		else
			f.timer.text:SetTextColor(1,1,0)
		end
		f.timer.text:SetText(math.ceil(timeRemain))
	end)
	f.timer.text = f.timer:CreateFontString()
	f.timer.text:SetFont("Fonts\\FRIZQT__.TTF", 32, "OUTLINE")
	f.timer.text:SetAllPoints()
	f.timer.text:Hide()
	f.autobid = CreateFrame("Button", nil, f, "UIPanelButtonTemplate")
	f.autobid:SetText(L["Auto bid"])
	f.autobid:SetSize(70, 16)
	f.autobid:SetScript("OnClick", function(self)
		StaticPopup_Show("GDKPD_AUTOBID", f.itemlink).data=f
		f.hide:Disable()
	end)
	f.autobid:SetPoint("TOPRIGHT", -10, -10)
	f.stopautobid = CreateFrame("Button", nil, f, "UIPanelButtonTemplate")
	f.stopautobid:SetText(L["Stop bid"])
	f.stopautobid:SetAllPoints(f.autobid)
	f.stopautobid:Hide()
	f.stopautobid:SetScript("OnClick", function(self)
		self:Hide()
		f.maxAutoBid = nil
		f.autobid:Show()
		f.hide:Enable()
	end)
	f.bidbox = CreateFrame("EditBox", nil, f)
	f.bidbox:SetMultiLine(nil)
	f.bidbox:SetScript("OnEditFocusGained", function(self)
		if self.disabled then
			self:ClearFocus()
		end
	end)
	function f.bidbox:Enable()
		self.disabled = false
	end
	function f.bidbox:Disable()
		self.disabled = true
	end
	f.bidbox:SetScript("OnEscapePressed", function(self) self:ClearFocus() end)
	f.bidbox:SetScript("OnEnterPressed", function(self)
		self:ClearFocus()
		local wantBid = self:GetNumber()
		if wantBid >= (f.bidIncrement+f.curbidamount) then
			SendChatMessage((f.isMultiBid and f.itemlink.." " or "")..wantBid, "RAID")
		end
		self:SetNumber(0)
	end)
	f.bidbox:SetBackdrop({bgFile="Interface\\ChatFrame\\UI-ChatInputBorder",tile=false})
	f.bidbox:SetTextInsets(5,5,2,2)
	f.bidbox:SetSize(40,16)
	f.bidbox:SetFont("Fonts\\FRIZQT__.TTF", 9)
	f.bidbox:SetAutoFocus(false)
	f.bidbox:SetPoint("LEFT", f.curbid, "RIGHT", 5, 0)
	f.bidbox:SetJustifyH("RIGHT")
	f.bidbox:SetNumeric(true)
	f.bidbox:SetNumber(0)
	f.bidbox:Hide()
	f.bid = CreateFrame("Button", nil, f, "UIPanelButtonTemplate")
	f.bid:SetText(L["Bid"])
	f.bid:SetSize(70,16)
	f.bid:SetPoint("TOP", f.autobid, "BOTTOM", 0, -8)
	f.bid:SetScript("OnClick", function(self)
		local newBid = f.curbidamount + f.bidIncrement
		if f.isMultiBid then
			SendChatMessage(f.itemlink.." "..newBid,"RAID")
		else
			SendChatMessage(tostring(newBid),"RAID")
		end
	end)
	f.bid:Disable()
	f.bid.enabledelay = CreateFrame("Frame", nil, f.bid)
	f.bid.enabledelay:Hide()
	f.bid.enabledelay:SetScript("OnUpdate", function(self)
		if not self.reenabletime then self:Hide() return end
		if GetTime() >= self.reenabletime then f.bid:Enable() self.reenabletime = nil self:Hide() end
	end)
	--f.hide = CreateFrame("Button", nil, f, "UIPanelButtonTemplate")
	f.hide = CreateFrame("Button", nil, f, "UIPanelCloseButton")
	--f.hide:SetText(L["Hide"])
	f.hide:SetSize(16,16)
	f.hide:SetPoint("TOPRIGHT")
	f.hide:SetScript("OnClick", function(self)
		GDKPd.ignoredLinks[f.itemlink] = true
		f:Hide()
	end)
	f.hide:SetScript("OnEnter", function(self)
		self:SetAlpha(1)
	end)
	f.hide:SetScript("OnLeave", function(self)
		self:SetAlpha(0)
	end)
	f.hide:SetAlpha(0)
	f.hide:SetDisabledTexture("Interface\\Buttons\\UI-Panel-MinimizeButton-Disabled")
	f.autobid:Disable()
	f.hide:Disable()
	function f:SetItem(itemlink)
		self.icon:SetTexture((select(10,GetItemInfo(itemlink))))
		self.itemstring:SetText(itemlink)
		self:EnableMouse(true)
		self.autobid:Enable()
		self.bidbox:Enable()
		self.hide:Enable()
		self.highestbid:Hide()
		self.itemlink = itemlink
	end
	function f:SetCurBid(goldAmount, bidderName, isMine, isInitial)
		self.curbid:SetText((isInitial and L["Minimum bid: "] or L["Current bid: "])..goldAmount.."|cffffd100g|r")
		if bidderName and (not isMine) then
			self.highestbidder:Show()
			self.highestbidder:SetText(L["Highest bidder: %s"]:format(bidderName))
			self.highestbid:Hide()
		elseif isMine then
			self.highestbid:Show()
			self.highestbidder:Hide()
		else
			self.highestbid:Hide()
			self.highestbidder:Hide()
		end
		self.curbidamount = goldAmount-(isInitial and self.bidIncrement or 0)
		self.curbidismine = not not isMine
		self.curbid:Show()
		self.bidbox:Show()
		self.bid:Enable()
		if not isInitial then
			self.bid:Disable()
			self.bid.enabledelay.reenabletime = GetTime()+GDKPd.opt.bidButtonReenableDelay
			self.bid.enabledelay:Show()
		end
	end
	function f:SetAuctionTimer(timerDuration, timerResetDuration)
		if (not timerDuration) then return end
		local ctime = GetTime()
		self.timer:SetCooldown(ctime, timerDuration)
		self.timer.update.endTime = ctime+timerDuration
		self.timer[GDKPd.opt.showAuctionDurationTimer and "Show" or "Hide"](self.timer)
		self.timer.text[GDKPd.opt.showAuctionDurationTimerText and "Show" or "Hide"](self.timer.text)
		self.timer.update[GDKPd.opt.showAuctionDurationTimerText and "Show" or "Hide"](self.timer.update)
		self.timerDuration = timerDuration
		self.timerResetDuration = timerResetDuration or timerDuration
	end
	function f:ResetAuctionTimer()
		if not self.timerResetDuration then return end
		if (self.timerResetDuration+GetTime()) < self.timer.update.endTime then return end
		self.timer:SetCooldown(GetTime()-(self.timerDuration-self.timerResetDuration), self.timerDuration)
		self.timer.update.endTime = GetTime()+self.timerResetDuration
	end
	f:SetScript("OnEnter", function(self)
		GameTooltip:ClearAllPoints()
		GameTooltip:ClearLines()
		GameTooltip:SetOwner(self, "ANCHOR_NONE")
		GameTooltip:SetHyperlink(self.itemlink)
		GameTooltip:SetPoint("RIGHT", self, "LEFT")
		GameTooltip:Show()
	end)
	f:SetScript("OnLeave", function() GameTooltip:Hide() end)
	f:SetScale(self.opt.appearScale)
	f:SetAlpha(self.opt.appearAlpha)
	f.isActive = false
	GDKPd.frames[c] = f
	return f
end

function GDKPd:UpdateAllVisibilities()
	status:UpdateVisibility()
	playerBalance:UpdateVisibility()
end

local defaults={profile={
	point={
		point="CENTER",
		relative="CENTER",
		x=0,
		y=0,
	},
	statuspoint={
		point="CENTER",
		relative="CENTER",
		x=0,
		y=0,
	},
	balancepoint={
		point="CENTER",
		relative="CENTER",
		x=0,
		y=-50,
	},
	playerbalancepoint={	
		point="CENTER",
		relative="CENTER",
		x=0,
		y=50,
	},
	customItemSettings={
	},
	showZeroBalance=false,
	shareSecondEnable=false,
	shareSecondAmount=0.33,
	shareThirdEnable=false,
	shareThirdAmount=0.11,
	auctionTimer=15,
	auctionTimerRefresh=15,
	movable=true,
	startBid=300,
	increment=100,
	minQuality=-1,
	autoAwardLoot=false,
	awardToML=false,
	showAuctionDurationTimer=true,
	showAuctionDurationTimerText=false,
	announceRaidWarning=true,
	allowMultipleAuctions=false,
	announcePotAfterAuction=false,
	hideChatMessages={
		auctionAnnounce=false,
		auctionAnnounceRW=false,
		newBid=true,
		bidFinished=false,
		secondsRemaining=true,
		bidChats=false,
		potValues=false,
	},
	notifyVersions={
		notifyCompatibleOutdated=true,
		notifyIncompatibleOutdated=true,
		notifyNotInstalled=false,
	},
	hideCombat={
	},
	appearAlpha=1,
	appearScale=1,
	controlScale=1,
	bidButtonReenableDelay=0.3,
}}

GDKPd.options={
	type="group",
	args={
		lock={
			type="toggle",
			name=L["Lock"],
			desc=L["Prevent dragging and hide anchor"],
			get=function() return not GDKPd.opt.movable end,
			set=function(info, value) GDKPd.opt.movable = not value GDKPd:SetMovable(not value) end,
			order=1,
			width="half",
		},
		show={
			type="toggle",
			name=L["Show"],
			desc=L["Show addon frames"],
			get=function() return not GDKPd.opt.hide end,
			set=function(info, value) GDKPd.opt.hide = not value GDKPd:UpdateAllVisibilities() end,
			order=2,
			width="half",
		},
		behaviour={
			type="group",
			name=L["Behaviour options"],
			args={
				startBid={
					type="range",
					name=L["Starting bid"],
					min=0,
					max=100000,
					softMax=1000,
					softMin=0,
					step=1,
					get=function() return GDKPd.opt.startBid end,
					set=function(info, value) GDKPd.opt.startBid = value end,
					order=1,
				},
				minIncrement={
					type="range",
					name=L["Minimum increment"],
					min=1,
					max=100000,
					softMax=1000,
					softMin=10,
					step=1,
					get=function() return GDKPd.opt.increment end,
					set=function(info, value) GDKPd.opt.increment = value end,
					order=2,
				},
				customSettings={
					type="execute",
					name=L["Configure per-item settings"],
					func=function() GDKPd.itemsettings:Show() LibStub("AceConfigDialog-3.0"):Close("GDKPd") end,
					order=2.5,
					width="full",
				},
				secondShare={
					dialogInline=true,
					name=L["Second bidder share"],
					order=3,
					type="group",
					args={
						isEnabled={
							order=1,
							type="toggle",
							name=L["Enable"],
							set=function(info,value) GDKPd.opt.shareSecondEnable = value end,
							get=function() return GDKPd.opt.shareSecondEnable end,
						},
						shareAmount={
							order=2,
							type="range",
							name=L["Amount"],
							min=0.01,
							max=0.99,
							isPercent=true,
							set=function(info, value) GDKPd.opt.shareSecondAmount = value end,
							get=function() return GDKPd.opt.shareSecondAmount end,
						},
					},
				},
				thirdShare={
					dialogInline=true,
					name=L["Third bidder share"],
					order=4,
					type="group",
					args={
						isEnabled={
							order=1,
							type="toggle",
							name=L["Enable"],
							set=function(info,value) GDKPd.opt.shareThirdEnable = value end,
							get=function() return GDKPd.opt.shareThirdEnable end,
						},
						shareAmount={
							order=2,
							type="range",
							name=L["Amount"],
							min=0.01,
							max=0.99,
							isPercent=true,
							set=function(info, value) GDKPd.opt.shareThirdAmount = value end,
							get=function() return GDKPd.opt.shareThirdAmount end,
						},
					},
				},
				minQuality={
					type="select",
					values=function()
						local vtab={}
						for key, tab in pairs(ITEM_QUALITY_COLORS) do
							if _G["ITEM_QUALITY"..key.."_DESC"] then
								vtab[key] = tab.hex.._G["ITEM_QUALITY"..key.."_DESC"].."|r"
							end
						end
						vtab[-1] = "|cffaa2222"..L["Use looting system loot threshold setting"].."|r"
						return vtab
					end,
					name=L["Minimum quality"],
					set=function(info, value) GDKPd.opt.minQuality = value end,
					get=function() return GDKPd.opt.minQuality end,
					order=5,
					width="full",
				},
				auctionTimer={
					type="range",
					softMin=5,
					softMax=30,
					order=6,
					name=L["Auction timeout"],
					desc=L["The amount of seconds that have to pass before the auction is closed without bids recieved"],
					set=function(info, value) GDKPd.opt.auctionTimer = value end,
					get=function() return GDKPd.opt.auctionTimer end,
				},
				auctionTimerRefresh={
					type="range",
					softMin=5,
					softMax=30,
					order=7,
					name=L["Auction bid timeout refresh"],
					desc=L["The amount of seconds that have to pass after a bid before the auction is closed"],
					set=function(info, value) GDKPd.opt.auctionTimerRefresh = value end,
					get=function() return GDKPd.opt.auctionTimerRefresh end,
				},
				autoAward={
					type="toggle",
					name=L["Auto-award loot to winner"],
					set=function(info, value) GDKPd.opt.autoAwardLoot = value end,
					get=function() return GDKPd.opt.autoAwardLoot end,
					width="full",
					order=8,
					disabled=function() return not not GDKPd.opt.awardToML end,
				},
				awardToML={
					type="toggle",
					name=L["Award loot to Master Looter when auto-auctioning"],
					set=function(info, value) GDKPd.opt.awardToML = value end,
					get=function() return GDKPd.opt.awardToML end,
					width="full",
					order=9,
					disabled=function() return not not GDKPd.opt.autoAwardLoot end,
				},
				announceRW={
					type="toggle",
					name=L["Announce auction start to raid warning"],
					width="full",
					set=function(info, value) GDKPd.opt.announceRaidWarning = value end,
					get=function() return GDKPd.opt.announceRaidWarning end,
					width="full",
					order=10,
				},
				allowMultiple={
					type="toggle",
					name=L["Allow multiple simultanous auctions"],
					width="full",
					set=function(info, value) GDKPd.opt.allowMultipleAuctions = value end,
					get=function() return GDKPd.opt.allowMultipleAuctions end,
					disabled=function() return ((GDKPd.curAuctions and (#GDKPd.curAuctions > 0)) or (GDKPd.curAuction.item)) end,
					order=11,
				},
				announcePotAfterAuction={
					type="toggle",
					name=L["Announce the current pot amount after each auction"],
					width="full",
					set=function(info, value) GDKPd.opt.announcePotAfterAuction = value end,
					get=function() return GDKPd.opt.announcePotAfterAuction end,
					order=12,
				},
			},
			order=1,
		},
		appearance={
			type="group",
			name=L["Appearance options"],
			args={
				showtimer={
					set=function(info, value) GDKPd.opt.showAuctionDurationTimer = value end,
					get=function() return GDKPd.opt.showAuctionDurationTimer end,
					type="toggle",
					name=L["Show auction duration spiral"],
					width="full",
					order=1,
				},
				showtimertext={
					disabled=function() return not GDKPd.opt.showAuctionDurationTimer end,
					set=function(info, value) GDKPd.opt.showAuctionDurationTimerText = value end,
					get=function() return GDKPd.opt.showAuctionDurationTimerText end,
					type="toggle",
					name=L["Show countdown text on auction duration spiral"],
					width="full",
					order=2,
				},
				hideChats={
					type="multiselect",
					name=L["Hide chat messages"],
					values={
						auctionAnnounce=L["Hide 'Bidding starts' announcements"],
						auctionAnnounceRW=L["Hide 'Bidding starts' announcements from raid warning"],
						newBid=L["Hide 'New highest bidder' announcements"],
						secondsRemaining=L["Hide 'Time remaining' announcements"],
						bidFinished=L["Hide 'Auction finished' announcements"],
						bidChats=L["Hide players' bid messages"],
						potValues=L["Hide 'Current pot:' announcements"],
					},
					set=function(info, key, value) GDKPd.opt.hideChatMessages[key]=value end,
					get=function(info, key) return GDKPd.opt.hideChatMessages[key] end,
					order=3,
					width="full",
				},
				frameAlpha={
					type="range",
					min=0,
					max=1,
					bigStep=0.1,
					name=L["Frame alpha"],
					order=4,
					set=function(info, value) GDKPd.opt.appearAlpha = value for _, f in ipairs(GDKPd.frames) do f:SetAlpha(value) end end,
					get=function() return GDKPd.opt.appearAlpha end,
				},
				frameScale={
					type="range",
					min=0.01,
					softMin=0.5,
					softMax=2,
					name=L["Frame scale"],
					order=5,
					set=function(info, value) GDKPd.opt.appearScale = value for _, f in ipairs(GDKPd.frames) do f:SetScale(value) end GDKPd_Anchor:SetScale(value) end,
					get=function() return GDKPd.opt.appearScale end,
				},
				bidButtonReenableDelay={	
					type="range",
					min=0,
					max=10,
					softMax=1,
					softMin=0,
					name=L["Bid button re-enable delay"],
					order=6,
					set=function(info, value) GDKPd.opt.bidButtonReenableDelay = value end,
					get=function() return GDKPd.opt.bidButtonReenableDelay end,
				},
				controlScale={
					type="range",
					min=0.01,
					softMin=0.5,
					softMax=2,
					name=L["Control panel scale"],
					order=7,
					set=function(info, value)
						GDKPd.opt.controlScale = value
						GDKPd.status:SetScale(value)
						GDKPd.history:SetScale(value)
						GDKPd.version:SetScale(value)
					end,
					get=function() return GDKPd.opt.controlScale end,
				},
				anchorBalance={
					type="toggle",
					set=function(info, value) GDKPd.opt.anchorBalance = value GDKPd.balance:UpdatePosition() end,
					get=function() return GDKPd.opt.anchorBalance end,
					name=L["Anchor balance window to status window"],
					width="full",
					order=8,
				},
			},
			order=2,
		},
		notification={
			type="group",
			name=L["Notification options"],
			args={
				rules={
					type="input",
					name=L["Rules"],
					order=1,
					multiline=true,
					get=function() return GDKPd.opt.rulesString or "" end,
					set=function(info, value)
						GDKPd.opt.rulesString = strlen(value) > 0 and value
						if GDKPd.opt.rulesString then
							GDKPd.status.rules:Enable()
						else
							GDKPd.status.rules:Disable()
						end
					end,
					width="full",
				},
				notifyVersions={
					type="multiselect",
					name=L["Version notifications"],
					values={
						notifyCompatibleOutdated=L["Notify outdated versions that are compatible with your version"],
						notifyIncompatibleOutdated=L["Notify outdated versions that aren't compatible with your version"],
						notifyNotInstalled=L["Notify raid members that do not have GDKPd installed"],
					},
					set=function(info, key, value) GDKPd.opt.notifyVersions[key]=value end,
					get=function(info, key) return GDKPd.opt.notifyVersions[key] end,
					order=2,
					width="full",
				},
			},
			order=3,
		},
		visibility={
			type="group",
			name=L["Visibility settings"],
			args={
				hideCombatFrames={
					type="multiselect",
					name=L["Hide frames in combat"],
					values={
						status=L["Hide status and balance windows"],
						history=L["Hide history window"],
						vercheck=L["Hide version check window"],
					},
					set=function(info, key, value)
						GDKPd.opt.hideCombat[key]=value
						GDKPd.status:UpdateVisibility()
						GDKPd.playerBalance:UpdateVisibility()
						if InCombatLockdown() then
							if key == "history" and value then
								GDKPd.history:Hide()
							end
							if key == "vercheck" and value then
								GDKPd.version:Hide()
							end
						end
					end,
					get=function(info, key) return GDKPd.opt.hideCombat[key] end,
					order=1,
					width="full",
				},
			},
			order=4,
		},
	},
}

function GDKPd:OnProfileEnable()
	self.opt = self.db.profile
	for _, f in ipairs(self.frames) do
		f:SetAlpha(self.opt.appearAlpha)
		f:SetScale(self.opt.appearScale)
	end
	GDKPd_Anchor:SetScale(self.opt.appearScale)
end

GDKPd:SetScript("OnEvent", function(self, event, ...)
	local arg = {...}
	if event == "ADDON_LOADED" and arg[1] == "GDKPd" then
		self:UnregisterEvent("ADDON_LOADED")
		GDKPd_PotData = GDKPd_PotData or {history={},potAmount=0}
		--seperate line for savedvar upgrading purposes
		GDKPd_PotData.curPotHistory = GDKPd_PotData.curPotHistory or {}
		GDKPd_PotData.playerBalance = GDKPd_PotData.playerBalance or {}
		setmetatable(GDKPd_PotData.playerBalance, {__index=function() return 0 end})
		GDKPd_BalanceData = GDKPd_BalanceData or {}
		setmetatable(GDKPd_BalanceData, {__index=function() return 0 end})
		self.status:Update()
		self.db = LibStub("AceDB-3.0"):New("GDKPd_DB", defaults or {})
		self.db.RegisterCallback(self,"OnProfileChanged","OnProfileEnable")
		self.db.RegisterCallback(self,"OnProfileCopied","OnProfileEnable")
		self.db.RegisterCallback(self,"OnProfileReset","OnProfileEnable")
		self.opt = self.db.profile
		GDKPd_Anchor:SetScale(self.opt.appearScale)
		self.status:SetScale(self.opt.controlScale)
		if self.opt.rulesString then
			self.status.rules:Enable()
		else
			self.status.rules:Disable()
		end
		self.history:SetScale(self.opt.controlScale)
		self.version:SetScale(self.opt.controlScale)
		self.options.args.profiles = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
		self.options.args.profiles.order = -1
		LibStub("AceConfig-3.0"):RegisterOptionsTable("GDKPd", self.options)
		SlashCmdList["GDKPD"] = function(input)
			local cmd, link = input:match("(%S+)%s+(|c........|Hitem:.+|r)")
			if (cmd and cmd == "auction") and link then
				if self:PlayerIsML((UnitName("player")),true) then
					for itemLink in string.gmatch(link, "|c........|Hitem:.-|r") do
						local itemID = tonumber(itemLink:match("|Hitem:(%d+):"))
						local startBid = (GDKPd.opt.customItemSettings[itemID] and GDKPd.opt.customItemSettings[itemID].minBid) or self.opt.startBid
						local increment = (GDKPd.opt.customItemSettings[itemID] and GDKPd.opt.customItemSettings[itemID].minIncrement) or self.opt.increment
						self:QueueAuction(itemLink, startBid, increment)
					end
				else
					print(L["Cannot start auction without Master Looter privileges."])
				end
			elseif input:lower() == "ver" then
				print(L["GDKPd version %s. Packaged %s."]:format(DEBUGFORCEVERSION or "1.0.0","2010-09-23T07:43:26Z"))
			elseif input:lower() == "history" then
				GDKPd.history:Show()
			elseif input:lower() == "wipe" then
				StaticPopup_Show("GDKPD_WIPEHISTORY")
			elseif input:lower() == "vercheck" then
				GDKPd.version:Show()
			else
				LibStub("AceConfigDialog-3.0"):Open("GDKPd")
			end
		end
		SLASH_GDKPD1 = "/gdkpd"
		SLASH_GDKPD2 = "/gdkp"
		anchor:SetPoint(self.opt.point.point, UIParent, self.opt.point.relative, self.opt.point.x, self.opt.point.y)
		self:SetMovable(self.opt.movable)
		self.status.header:SetPoint(self.opt.statuspoint.point, UIParent, self.opt.statuspoint.relative, self.opt.statuspoint.x, self.opt.statuspoint.y)
		--self.balance.header:SetPoint(self.opt.balancepoint.point, UIParent, self.opt.balancepoint.relative, self.opt.balancepoint.x, self.opt.balancepoint.y)
		self.balance:UpdatePosition()
		self.playerBalance.header:SetPoint(self.opt.playerbalancepoint.point, UIParent, self.opt.playerbalancepoint.relative, self.opt.playerbalancepoint.x, self.opt.playerbalancepoint.y)
		self.playerBalance:Update()
	end
	if (event == "CHAT_MSG_RAID") or (event == "CHAT_MSG_RAID_LEADER") or (event == "CHAT_MSG_RAID_WARNING") then
		local msg = arg[1]
		--this is code for single-auction mode. put into a do branch to avoid local clashes.
		do
			local itemLink, minBid, bidIncrement, auctionTimer, auctionTimerRefresh = string.match(msg, "%[GDKPd%] Bidding starts on (|c........|Hitem:.+|r). Please bid in raid chat, starting bid (%d+) gold, minimum increment (%d+) gold. TTL: (%d+)/(%d+)")
			if not itemLink then
				-- backwards comp number three
				itemLink, minBid, bidIncrement, auctionTimer, auctionTimerRefresh = string.match(msg, "%[GDKPd%] Bidding starts on (|c........|Hitem:.+|r). Please bid in raid chat, starting bid (%d+) gold, minimum increment (%d+) gold. TTL until expire: (%d+) seconds, TTL after bid: (%d+) seconds.")
			end
			if not itemLink then
				-- backwords compability strikes again
				itemLink, minBid, bidIncrement, auctionTimer = string.match(msg, "%[GDKPd%] Bidding starts on (|c........|Hitem:.+|r). Please bid in raid chat, starting bid (%d+) gold, minimum increment (%d+) gold. TTL after a bid is placed: (%d+) seconds.")
				auctionTimerRefresh=auctionTimer
			end
			if not itemLink then
				-- backwards version compability
				itemLink, minBid, bidIncrement = string.match(msg, "%[GDKPd%] Bidding starts on (|c........|Hitem:.+|r). Please bid in raid chat, starting bid (%d+) gold, minimum increment (%d+) gold.")
				auctionTimer = 0
				auctionTimerRefresh=0
			end
			if itemLink and self:PlayerIsML(arg[2], false) then
				if not self.ignoredLinks[itemLink] then
					local f = GDKPd:FetchFrameFromLink(itemLink)
					if not f then
						f = self:GetUnoccupiedFrame()
						f:SetItem(itemLink)
						f.isActive = true
						f:Show()
					end
					f.isMultiBid = false
					self.InProgressBidFrame = f
					f.bidIncrement = bidIncrement
					f:SetCurBid(minBid, false, false, true)
					f:SetAuctionTimer(auctionTimer, auctionTimerRefresh)
					if f.maxAutoBid then
						local newBid = tonumber(minBid)
						if newBid < f.maxAutoBid then
							SendChatMessage(tostring(newBid),"RAID")
						end
					end
				else
					self.ignoredLinks[itemLink] = nil
				end
			end
			if self.curAuction.item and msg:find("%d+") == 1 then
				local newBid = tonumber(msg:sub(msg:find("%d+")))
				if newBid > 241748 then return end
				if (self.curAuction.curBid + self.curAuction.increment) <= newBid then
					GDKPd.curAuction.curBid = newBid
					if GDKPd.curAuction.bidders[arg[2]] then
						GDKPd.curAuction.bidders[GDKPd.curAuction.bidders[arg[2]]].bidAmount = newBid
					else
						tinsert(GDKPd.curAuction.bidders, {bidAmount=newBid, bidderName=arg[2]})
						GDKPd.curAuction.bidders[arg[2]] = #GDKPd.curAuction.bidders
					end
					SendChatMessage(("[GDKPd] New highest bidder: %s (%d gold)"):format(arg[2], newBid),"RAID")
					self.curAuction.timeRemains = math.max(self.opt.auctionTimerRefresh, self.curAuction.timeRemains)
				end
			end
			local bidderName, newBid = string.match(msg, "%[GDKPd%] New highest bidder: (%S+) %((%d+) gold%)")
			if bidderName and self.InProgressBidFrame then
				local isSelf = bidderName == (UnitName("player"))
				self.InProgressBidFrame:SetCurBid(newBid, bidderName, isSelf)
				self.InProgressBidFrame:ResetAuctionTimer()
				if not isSelf then
					if self.InProgressBidFrame.maxAutoBid then
						local myNewBid = newBid+self.InProgressBidFrame.bidIncrement
						if myNewBid <= self.InProgressBidFrame.maxAutoBid then
							SendChatMessage(tostring(myNewBid),"RAID")
						end
					end
				end
			end
			if msg:find("%[GDKPd%] Auction finished.") and GDKPd:PlayerIsML(arg[2],false) and self.InProgressBidFrame then
				self.InProgressBidFrame:Hide()
				self.InProgressBidFrame.isActive = false
				self.InProgressBidFrame = nil
				local winnerName, paymentString = msg:match("%[GDKPd%] Auction finished. Winner: (%S+). (.+).")
				if winnerName then
					if winnerName == (UnitName("player")) then
						for targetAmount, targetName in paymentString:gmatch("(%d+) to (%S+)[%.,]") do
							if GDKPd:PlayerIsML((UnitName("player")),true) then
								GDKPd_PotData.playerBalance[targetName == "pot" and arg[2] or targetName] = GDKPd_PotData.playerBalance[targetName == "pot" and arg[2] or targetName] + targetAmount
								GDKPd.balance:Update()
							else
								GDKPd_BalanceData[targetName == "pot" and arg[2] or targetName] = GDKPd_BalanceData[targetName == "pot" and arg[2] or targetName] + targetAmount
								GDKPd.playerBalance:Update()
							end
						end
					else
						local selfAmount = paymentString:match("(%d+) to "..(UnitName("player")))
						if selfAmount then
							if GDKPd:PlayerIsML((UnitName("player")),true) then
								GDKPd_PotData.playerBalance[winnerName] = GDKPd_PotData.playerBalance[winnerName]-selfAmount
								GDKPd.balance:Update()
							else
								GDKPd_BalanceData[winnerName] = GDKPd_BalanceData[winnerName]-selfAmount
								GDKPd.playerBalance:Update()
							end
						end
					end
				end
			end
		end
		-- this is new code for multi-auction. slight variations are used rl-side to indicate this.
		do
			local itemLink, minBid, bidIncrement, auctionTimer, auctionTimerRefresh = string.match(msg, "%[GDKPd%] Bidding starts on (|c........|Hitem:.+|r). Bid using format '%[item%] 1000', starting bid (%d+) gold, minimum increment (%d+) gold. TTL: (%d+)/(%d+)")
			if not itemLink then
				-- backwards to non-shortened
				itemLink, minBid, bidIncrement, auctionTimer, auctionTimerRefresh = string.match(msg, "%[GDKPd%] Bidding starts on (|c........|Hitem:.+|r). Bid using format '%[item%] 1000', starting bid (%d+) gold, minimum increment (%d+) gold. TTL until expire: (%d+) seconds, TTL after bid: (%d+) seconds.")
			end
			if not itemLink then
				itemLink, minBid, bidIncrement, auctionTimer = string.match(msg, "%[GDKPd%] Bidding starts on (|c........|Hitem:.+|r). Please bid in raid chat, using format 'itemlink bid'. Starting bid (%d+) gold, minimum increment (%d+) gold. TTL after a bid is placed: (%d+) seconds.")
				auctionTimerRefresh = auctionTimer
			end
			if itemLink and self:PlayerIsML(arg[2],false) then
				if not self.ignoredLinks[itemLink] then
					local f = GDKPd:FetchFrameFromLink(itemLink)
					if not f then
						f = self:GetUnoccupiedFrame()
						f:SetItem(itemLink)
						f.isActive = true
						f:Show()
					end
					f.isMultiBid = true
					f.bidIncrement = bidIncrement
					f:SetCurBid(minBid, false, false, true)
					f:SetAuctionTimer(auctionTimer, auctionTimerRefresh)
					if f.maxAutoBid then
						local newBid = tonumber(minBid)
						if newBid < f.maxAutoBid then
							SendChatMessage(itemLink.." "..newBid)
						end
					end
				else
					self.ignoredLinks[itemLink] = nil
				end
			end
			local bidItemLink, bidAmount = msg:match("(|c........|Hitem:.+|r)%s*(%d+)")
			if bidItemLink then
				if self.curAuctions[bidItemLink] then
					local aucdata = self.curAuctions[bidItemLink]
					bidAmount = tonumber(bidAmount)
					if bidAmount > 214748 then return end
					if (aucdata.curBid+aucdata.increment) <= bidAmount then
						aucdata.curBid = bidAmount
						if aucdata.bidders[arg[2]] then
							aucdata.bidders[aucdata.bidders[arg[2]]].bidAmount = bidAmount
						else
							tinsert(aucdata.bidders, {bidAmount=bidAmount, bidderName=arg[2]})
							aucdata.bidders[arg[2]] = #aucdata.bidders
						end
						SendChatMessage(("[GDKPd] New highest bidder on %s: %s (%d gold)"):format(bidItemLink,arg[2],bidAmount),"RAID")
						aucdata.timeRemains = math.max(aucdata.timeRemains, self.opt.auctionTimerRefresh)
					end
				end
			end
			local bidItem, bidderName, newBid = string.match(msg, "%[GDKPd%] New highest bidder on (|c........|Hitem:.+|r): (%S+) %((%d+) gold%)")
			if bidderName and self:FetchFrameFromLink(bidItem) then
				local isSelf = bidderName == (UnitName("player"))
				local bidFrame = self:FetchFrameFromLink(bidItem)
				bidFrame:SetCurBid(newBid, bidderName, isSelf)
				bidFrame:ResetAuctionTimer()
				if not isSelf then
					if bidFrame.maxAutoBid then
						local myNewBid = newBid+bidFrame.bidIncrement
						if myNewBid <= bidFrame.maxAutoBid then
							SendChatMessage(bidItem.." "..myNewBid, "RAID")
						end
					end
				end
			end
			local auctionEndItem = msg:match("%[GDKPd%] Auction finished for (|c........|Hitem:.+|r).")
			if auctionEndItem and GDKPd:PlayerIsML(arg[2],false) and self:FetchFrameFromLink(auctionEndItem) then
				local f = self:FetchFrameFromLink(auctionEndItem)
				f.isActive = false
				f:Hide()
				local winnerName, paymentString = msg:match("%[GDKPd%] Auction finished for |c........|Hitem:.+|r%. Winner: (%S+)%. (.+)")
				if winnerName then
					if winnerName == (UnitName("player")) then
						for targetAmount, targetName in paymentString:gmatch("(%d+) to (%S+)[%.,]") do
							if GDKPd:PlayerIsML((UnitName("player")),true) then
								GDKPd_PotData.playerBalance[targetName == "pot" and arg[2] or targetName] = GDKPd_PotData.playerBalance[targetName == "pot" and arg[2] or targetName] + targetAmount
								GDKPd.balance:Update()
							else
								GDKPd_BalanceData[targetName == "pot" and arg[2] or targetName] = GDKPd_BalanceData[targetName == "pot" and arg[2] or targetName] + targetAmount
								GDKPd.playerBalance:Update()
							end
						end
					else
						local selfAmount = paymentString:match("(%d+) to "..(UnitName("player")))
						if selfAmount then
							if GDKPd:PlayerIsML((UnitName("player")),true) then
								GDKPd_PotData.playerBalance[winnerName] = GDKPd_PotData.playerBalance[winnerName]-selfAmount
								GDKPd.balance:Update()
							else
								GDKPd_BalanceData[winnerName] = GDKPd_BalanceData[winnerName]-selfAmount
								GDKPd.playerBalance:Update()
							end
						end
					end
				end
			end
		end
		-- generic code for both auction modes
		do
			local potAmount = msg:match("%[GDKPd%] Distributing pot. Pot size: %d+ gold. Amount to distribute: %d+ gold. Players in raid: %d+. Share per player: (%d+) gold.")
			if not potAmount then
				potAmount = msg:match("%[GDKPd%] Distributing pot. Pot size: %d+ gold. Players in raid: %d+. Pot share per player: (%d+) gold.")
			end
			if potAmount and self:PlayerIsML(arg[2],false) then
				GDKPd_BalanceData[arg[2]] = GDKPd_BalanceData[arg[2]]-potAmount
				GDKPd.playerBalance:Update()
			end
		end
	end
	if (event == "CHAT_MSG_ADDON") then
		if arg[1] == "GDKPd_Start" and self:PlayerIsML(arg[4],false) then
			if not self:FetchFrameFromLink(arg[2]) then
				local f = self:GetUnoccupiedFrame()
				f.isActive = true
				f:SetItem(arg[2])
				f:Show()
			end
		end
		if arg[1] == "GDKPd_Version" then
			SendAddonMessage("GDKPd_VersionData", DEBUGFORCEVERSION or "1.0.0", "WHISPER", arg[4])
		end
		if arg[1] == "GDKPd_VersionData" then
			self.versions[arg[4]] = arg[2]
			self.version:Update()
		end
		if arg[1] == "GDKPd_ManualAdjust" and self:PlayerIsML(arg[4],false) then
			GDKPd_BalanceData[arg[4]] = GDKPd_BalanceData[arg[4]]+arg[2]
		end
	end
	if (event == "LOOT_CLOSED") then
		self.status.announcetext:Hide()
		self.status.announce1:Hide()
		self.status.announce2:Hide()
		self.status.noannounce:Hide()
		self.status:UpdateSize()
	end
	if (event == "LOOT_OPENED") and self:PlayerIsML((UnitName("player")), true) then
		self.status.announcetext:Show()
		self.status.announce1:Show()
		self.status.announce2:Show()
		self.status.noannounce:Show()
		self.status:UpdateSize()
	end
	if event == "RAID_ROSTER_UPDATE" then
		self.status:UpdateVisibility()
		--[[if self:PlayerIsML((UnitName("player")),true) then
			self.status:Show()
		else
			self.status:Hide()
		end--]]
	end
	if (event == "TRADE_CLOSED") then
		self.isTrading = false
	end
	if (event == "TRADE_SHOW") then
		self.isTrading = true
		self.tradePartner = (UnitName("NPC"))
		self.tradeMoneySelf = 0
		self.tradeMoneyOther = 0
		self.balance:Update()
	end
	if (event == "TRADE_ACCEPT_UPDATE") and (arg[1] == 1) then
		self.tradeMoneySelf = GetPlayerTradeMoney()/10000
	end
	if (event == "TRADE_MONEY_CHANGED") then
		self.tradeMoneyOther = GetTargetTradeMoney()/10000
	end
	if (event == "UI_INFO_MESSAGE") then
		if arg[1] == ERR_TRADE_COMPLETE then
			--if self:PlayerIsML((UnitName("player")),true) and GDKPd_PotData.playerBalance[self.tradePartner] ~= 0 then
			if self:PlayerIsML((UnitName("player")),true) then
				if GDKPd_PotData.playerBalance[self.tradePartner] ~= 0 then
					local moneyChange = (self.tradeMoneyOther)-(self.tradeMoneySelf)
					local curBalancePot, curBalancePlayer = GDKPd_PotData.playerBalance[self.tradePartner], GDKPd_BalanceData[self.tradePartner]
					if moneyChange > 0 then
						--[[if curBalancePot+moneyChange > 0 then
							moneyChange = moneyChange-(curBalancePot*(-1))
							GDKPd_PotData.playerBalance[self.tradePartner] = 0
							if (curBalancePlayer ~= 0 or GetRealNumRaidMembers() > 0) then
								GDKPd_BalanceData[self.tradePartner] = curBalancePlayer+moneyChange
							end
						else--]]
							GDKPd_PotData.playerBalance[self.tradePartner] = curBalancePot+moneyChange
						--end
					elseif moneyChange < 0 then
						--[[if curBalancePot+moneyChange < 0 then
							moneyChange = moneyChange+(curBalancePot*(-1))
							GDKPd_PotData.playerBalance[self.tradePartner] = 0
							if (curBalancePlayer ~= 0 or GetRealNumRaidMembers() > 0) then
								GDKPd_BalanceData[self.tradePartner] = curBalancePlayer+moneyChange
							end
						else--]]
							GDKPd_PotData.playerBalance[self.tradePartner] = curBalancePot+moneyChange
						--end
					end
				end
			elseif GDKPd_BalanceData[self.tradePartner] ~= 0 then
				GDKPd_BalanceData[self.tradePartner] = GDKPd_BalanceData[self.tradePartner]-(self.tradeMoneySelf)+(self.tradeMoneyOther)
			end
			GDKPd.balance:Update()
			GDKPd.playerBalance:Update()
		end
	end
	if (event == "PLAYER_REGEN_ENABLED") then
		self.status:UpdateVisibility(false)
		self.playerBalance:UpdateVisibility(false)
	end
	if (event == "PLAYER_REGEN_DISABLED") then
		self.status:UpdateVisibility(true)
		self.playerBalance:UpdateVisibility(true)
	end
end)
GDKPd:RegisterEvent("ADDON_LOADED")
GDKPd:RegisterEvent("CHAT_MSG_RAID")
GDKPd:RegisterEvent("CHAT_MSG_RAID_LEADER")
GDKPd:RegisterEvent("CHAT_MSG_RAID_WARNING")
GDKPd:RegisterEvent("LOOT_OPENED")
GDKPd:RegisterEvent("LOOT_CLOSED")
GDKPd:RegisterEvent("RAID_ROSTER_UPDATE")
GDKPd:RegisterEvent("CHAT_MSG_ADDON")
GDKPd:RegisterEvent("TRADE_MONEY_CHANGED")
GDKPd:RegisterEvent("UI_INFO_MESSAGE")
GDKPd:RegisterEvent("TRADE_CLOSED")
GDKPd:RegisterEvent("TRADE_SHOW")
GDKPd:RegisterEvent("TRADE_ACCEPT_UPDATE")
GDKPd:RegisterEvent("PLAYER_REGEN_ENABLED")
GDKPd:RegisterEvent("PLAYER_REGEN_DISABLED")

--chat filters
local function filterChat_CHAT_MSG_RAID(chatframe,event,msg)
	--auctionAnnounce newBid bidFinished
	if GDKPd.opt.hideChatMessages.auctionAnnounce and msg:match("%[GDKPd%] Bidding starts on (|c........|Hitem:.+|r).")  then
		return true
	end
	if GDKPd.opt.hideChatMessages.newBid and msg:match("%[GDKPd%] New highest bidder(.*): (%S+) %((%d+) gold%)") then
		return true
	end
	if GDKPd.opt.hideChatMessages.bidFinished and msg:match("%[GDKPd%] Auction finished") then
		return true
	end
	if GDKPd.opt.hideChatMessages.secondsRemaining and msg:match("%[GDKPd%] (%d+) seconds remaining(.*)!") then
		return true
	end
	if GDKPd.opt.hideChatMessages.bidChats and ((msg:match("%d+") and (GDKPd.InProgressBidFrame or GDKPd.curAuction.item)) or (msg:match("(|c........|Hitem:.+|r)%s*(%d+)") and (GDKPd:FetchFrameFromLink(msg:match("(|c........|Hitem:.+|r)")) or GDKPd.curAuctions[msg:match("(|c........|Hitem:.+|r)")]))) then
		return true
	end
	if GDKPd.opt.hideChatMessages.potValues and msg:match("%[GDKPd%] Current pot: (%d+) gold") then
		return true
	end
	return false
end
--register chat filters
ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID",filterChat_CHAT_MSG_RAID)
ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_WARNING",filterChat_CHAT_MSG_RAID)
ChatFrame_AddMessageEventFilter("CHAT_MSG_RAID_LEADER",filterChat_CHAT_MSG_RAID)
ChatFrame_AddMessageEventFilter("CHAT_MSG_WHISPER_INFORM",function(chatframe,event,msg)
	if msg:find(L["[GDKPd] Your version of GDKPd is slightly outdated compared to the raid leader's. Full compability should be possible, however, you might want to take some time and update GDKPd."]:gsub("%[","%%["):gsub("%]","%%]")) then
		return true
	end
	if msg:find(L["[GDKPd] Your version of GDKPd is outdated and no longer compatible with the raid leader's in one or more functionalities. In order to ensure smooth performance, please update GDKPd."]:gsub("%[","%%["):gsub("%]","%%]")) then
		return true
	end
	if msg:find(L["[GDKPd] This raid uses GDKPd to faciliate its GDKP bidding process. While you can bid on items without having GDKPd installed, installing it provides you with a GUI bidding panel, auto bidding functions, auction timers, chat filtering and more!"]:gsub("%[","%%["):gsub("%]","%%]")) then
		return true
	end
end)
--chat filters done
--filter raid warning frame
do
	local oldmessage = RaidNotice_AddMessage
	function RaidNotice_AddMessage(frame,text,...)
		if GDKPd.opt.hideChatMessages.auctionAnnounceRW and text:match("%[GDKPd%] Bidding starts on (|c........|Hitem:.+|r).") then
			return
		end
		oldmessage(frame,text,...)
	end
end
--end raid warning frame filter
