--[[ 

classbarframe created

set up basic frame
location
texture

frame objects:
	debuff object 	-> countdown timer
	buff object 	-> countdown timer
	holy power		-> texture
*	runes 			-> countdown timer 
					-> texture
					-> rune type
	soulshard obj.	-> texture
	combo pt. obj.	-> text
	eclipse bar		-> texture 
	
--]]

-- Initialize Class Bar Object Tables and set __index tables
FusionHUDRuneObject = {};
FusionHUDCooldownObject = {};
FusionHUDThreeCountObject = {};
FusionHUDComboPointObject = {};
FusionHUDEclipseObject = {};

FusionHUDRuneObject.__index = FusionHUDRuneObject;
FusionHUDCooldownObject.__index = FusionHUDCooldownObject;
FusionHUDThreeCountObject.__index = FusionHUDThreeCountObject;
FusionHUDComboPointObject.__index = FusionHUDComboPointObject;
FusionHUDEclipseObject.__index = FusionHUDEclipseObject;

-- Death Knight Rune Objects
function FusionHUDRuneObject:New()
	local self = {};
	setmetatable(self, FusionHUDRuneObject);
	self = CreateFrame("Frame", nil, FusionHUDClassBar.frame);
	self:SetHeight(FusionHUDClassBar.height);
	self:SetWidth(FusionHUDClassBar.height);
	self.runeID = 0;
	self.onCooldown = false;
	self.cooldownFrame = FusionHUDCooldownObject:New(self);
	self.texture = self:CreateTexture(nil, "BACKGROUND");
	self.texture:SetAllPoints(self);
	return self
end
-- Cooldown Counter Text Object
function FusionHUDCooldownObject:New(parent)
	local self = {};
	setmetatable(self, FusionHUDCooldownObject);
	self = CreateFrame("Frame", nil, parent);
	self.text = self:CreateFontString(nil, "HIGH");
	self.text:SetFont("Interface\\AddOns\\FusionHUD\\Fonts\\DroidSans.ttf", math.floor(parent:GetHeight() * .6), "OUTLINE");
	self.text:SetPoint("CENTER", parent, "CENTER", 0, 0);
	self.text:SetHeight(FusionHUDClassBar.height);
	self.text:SetWidth(FusionHUDClassBar.width);
	self.text:SetJustifyH("CENTER");
	self.text:SetJustifyV("CENTER");
	self.lastUpdateClock = 0;
	return self
end
-- Object for 3-part counter bars (Paladins/Warlocks)
function FusionHUDThreeCountObject:New()
	local self = {};
	setmetatable(self, FusionHUDThreeCountObject);
	self = CreateFrame("Frame", nil, FusionHUDClassBar.frame);
	self:SetAllPoints(FusionHUDClassBar.frame);
	self.texture = self:CreateTexture(nil, "OVERLAY");
	self.texture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\Three Count Frame", true);
	self.texture:SetAllPoints(self);
	self.fillTexture = self:CreateTexture(nil, "BACKGROUND");
	self.fillTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\whitebackdropbase", true);
	self.fillTexture:SetHeight(FusionHUDClassBar.height);
	self.fillTexture:SetPoint("TOPLEFT", self, "TOPLEFT");
	self.fillTexture:SetPoint("BOTTOMLEFT", self, "BOTTOMLEFT");
	return self
end
-- Object for Combo Point counter (Rogues/Druids)
function FusionHUDComboPointObject:New()
	local self = {};
	setmetatable(self, FusionHUDComboPointObject);
	self = CreateFrame("Frame", nil, FusionHUDClassBar.frame);
	self:SetAllPoints(FusionHUDClassBar.frame);
	FusionHUDClassBar.frame:SetWidth(FusionHUDClassBar.height);
	self.texture = self:CreateTexture(nil, "OVERLAY");
	self.texture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\Combo Point Frame", true);
	self.texture:SetAllPoints(self);
	self.text = self:CreateFontString(nil, "HIGH");
	self.text:SetFont("Interface\\AddOns\\FusionHUD\\Fonts\\DroidSans.ttf", math.floor(FusionHUDClassBar.frame:GetHeight() * .8), "OUTLINE");
	self.text:SetPoint("CENTER", FusionHUDClassBar.frame, "CENTER", 0, 0);
	self.text:SetHeight(FusionHUDClassBar.height);
	self.text:SetWidth(FusionHUDClassBar.width);
	self.text:SetJustifyH("CENTER");
	self.text:SetJustifyV("CENTER");
	return self
end
-- Object for the Eclipse Bar (Moonkin)
function FusionHUDEclipseObject:New()
	local self = {};
	local eclipseLunar, eclipseSolar, name, i = false, false, "", 1;
	setmetatable(self, FusionHUDEclipseObject);
	self = CreateFrame("Frame", nil, FusionHUDClassBar.frame);
	self:SetAllPoints(FusionHUDClassBar.frame);
	self.texture = self:CreateTexture(nil, "LOW");
	self.texture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\One Count Frame", false);
	self.texture:SetAllPoints(self);
	
	self.flashFrame = CreateFrame("Frame", "flashFrame", self);
	self.flashFrame:SetAllPoints(self);
	self.flashFrame.texture = self.flashFrame:CreateTexture(nil, "MEDIUM");
	self.flashFrame.texture:SetAllPoints(self);		
	self.flashFrame.texture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\One Count Fill Druid Flash.tga", false);
	self.flashFrame.texture.animGroup = self.flashFrame.texture:CreateAnimationGroup("Flash");
	self.flashFrame.texture.animGroup:SetLooping("NONE");
	self.flashFrame.texture.animGroup.anim1 = self.flashFrame.texture.animGroup:CreateAnimation("Alpha");
	self.flashFrame.texture.animGroup.anim1:SetOrder(1);
	self.flashFrame.texture.animGroup:SetScript("OnPlay", function()
			FusionHUDClassBar.frame.eclipseFrame.flashFrame:Show();
			FusionHUDClassBar.frame.eclipseFrame.flashFrame:SetAlpha(1);
		end)
	self.flashFrame.texture.animGroup:SetScript("OnFinished", function()
			FusionHUDClassBar.frame.eclipseFrame.flashFrame:Hide();
		end)
	self.flashFrame:Hide();
	
	self.backgroundTexture = self:CreateTexture(nil, "BACKGROUND");
	while name ~= nil do
		name = UnitBuff("player", i, "PLAYER");
		if name == "Eclipse (Solar)" then
			eclipseSolar = true
			break
		elseif name == "Eclipse (Lunar)" then
			eclipseLunar = true
			break
		end
		i = i + 1;
	end
	if eclipseSolar then
		self.backgroundTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\One Count Fill Druid Solar", false);
	elseif eclipseLunar then
		self.backgroundTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\One Count Fill Druid Lunar", false);
	else
		self.backgroundTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\One Count Fill Druid", false);
	end
	self.backgroundTexture:SetAllPoints(self);
	self.arrowFrame = CreateFrame("Frame", nil, self);
	self.arrowFrame:SetHeight(FusionHUDClassBar.height * 4 / 5);
	self.arrowFrame:SetWidth(FusionHUDClassBar.height * .3);
	self.arrowFrame.texture = self:CreateTexture(nil, "OVERLAY");
	self.arrowFrame.texture:SetAllPoints(self.arrowFrame);
	self.midPoint = FusionHUDClassBar.width / 2;
	self.arrowTextureName = "Interface\\AddOns\\FusionHUD\\Graphics\\Eclipse Arrow";
	return self
end
	
