FusionHUDBarPrototype = {};
FusionHUDBarPrototype.__index = FusionHUDBarPrototype;

function FusionHUDBarPrototype:New(index)		--Build New Bar object, initializes the frames and textures
	local self = {};
    setmetatable(self, FusionHUDBarPrototype); -- Set the metatable so we used FusionHUDBarPrototype's __index
	
-- Initialize BarPrototype settings
	self.barIndex = index;
	self.lastHeight = 400;
	self.lastWidth = 15;
	self.draggable = false;
	self.parentFrame = "FusionHUDMasterFrame";
	self.myPoint = "CENTER";
	self.parentPoint = "CENTER";
	self.offsetX = 0;
	self.offsetY = 0;
	self.lastOrientation = "Left"
	self.orientation = "Left";
	self.textureName = "Interface\\AddOns\\FusionHUD\\Graphics\\Vertical Bar Glass";
	self.font = "Interface\\AddOns\\FusionHUD\\Fonts\\DroidSans.ttf";
	self.fontKey = "FrizQuadrata";
	self.fontSize = 14;
	self.height = 400;
	self.width = 15;
	self.barType = "Health";
	self.barTarget = "player";
	self.totals = true;
	self.warningColor = false;
	self.lastValue = -999999999999999;
	self.lastValueMax = -9999999999999999;
	self.lastDruidValue = -99999999999999999;
	self.numLabels = 1;
	self.textIsDocked = true;
	self.lastTarget = nil;
	self.showValueText = true;
	self.showTotalText = true;
	self.showPercentText = false;
	self.showLabelText = false;
	self.textPoint = "TOP";
	self.textParentPoint = "BOTTOM";
	self.textOffsetX = 0;
	self.textOffsetY = 0;
	self.isHorizontal = false;
	self.debug = false;
	
-- Construct the bar and frames
	self:BuildBar();
	
	return self;
end

function FusionHUDBarPrototype:BuildBar()  -- Constructs bar's frames and textures
	local left, right;
	local localClass, englishClass = UnitClass("player");
	
	-- Begin variable check - check to make sure bar attribute variables exist, and if not, initialize them
	if self.isHorizontal == nil then
		self.isHorizontal = false;
	end
	if self.showValueText == nil then
		self.showValueText = true;
		self.showTotalText = true;
		self.showPercentText = false;
		self.showLabelText = false;
	end
	if self.textIsDocked == nil then
		self.textIsDocked = true;
	end
	if self.textPoint == nil or self.textParentPoint ==  nil or self.textOffsetX == nil or self.textOffsetY == nil then
		self.textPoint = "TOP";
		self.textParentPoint = "BOTTOM";
		self.textOffsetX = 0;
		self.textOffsetY = 0;
	end
	if self.font == nil then
		self.font = "Interface\\AddOns\\FusionHUD\\Fonts\\DroidSans.ttf";
		self.fontKey = "Droid Sans";
		self.fontSize = 14;
	end
	if self.textureName == "Interface\\AddOns\\FusionHUD\\Graphics\\White Straight Bar Base" then
		self.textureName = "Interface\\AddOns\\FusionHUD\\Graphics\\Vertical Bar Glass";
	end
	if self.orientation == "Left" then
		left = 0;
		right = 1;
	else
		left = 1;
		right = 0;
	end
	if self.lastTarget == nil then
		self.lastTarget = 0;
	end
	if self.barName ==  nil or self.barName == "" then
		self.barName = self.barTarget .. " " .. self.barType;
	end
	if self.barR == nil then
		self.barR = 1;
	end
	if self.barG == nil then
		self.barG = 1;
	end
	if self.barB == nil then
		self.barB = 1;
	end
	if self.textureName == "Interface\\AddOns\\FusionHUD\\Graphics\\Straight Bar Glass" then
		self.textureName = "Interface\\AddOns\\FusionHUD\\Graphics\\Vertical Bar Glass";
	end
	if self.warningToggle == nil then
		self.warningToggle = false;
	end
	if self.yellowThreshold == nil then
		self.yellowThreshold = 50;
	end
	if self.redThreshhold == nil then
		self.redThreshold = 20;
	end
	self.warnPrinted = false;
		
	-- End variable check
	
	--Set up bar frame
	self.frame = nil;
	self.frame = CreateFrame("Frame", nil, FusionHUDMasterFrame);
	self.frame:ClearAllPoints();
--	self.frame:SetPoint(self.myPoint, FusionHUDMasterFrame, self.parentPoint);
	self.frame:SetHeight(self.height);
	self.frame:SetWidth(self.width);
	self.frame:SetClampedToScreen(true);
	self.textParent = self.frame;
	--Set Up the title region for the bar to enable dragging
	self.frame.titleRegion = self.frame:CreateTitleRegion();
	self.frame.titleRegion:ClearAllPoints();
	--Set up the bar texture
	self.frame.barTexture = self.frame:CreateTexture(nil, "ARTWORK", nil, 0);
	self.frame.barTexture:SetTexture(self.textureName, false);
	self.frame.barTexture:ClearAllPoints();
	if self.isHorizontal then
		self.frame.barTexture:SetPoint(self.orientation:upper(), self.frame, self.orientation:upper());
	else
		self.frame.barTexture:SetPoint("BOTTOM", self.frame, "BOTTOM");
	end
	self.frame.barTexture:SetHeight(self.height);
	self.frame.barTexture:SetWidth(self.width);
	--Set up the bar background/scale texture
	self.frame.containerTexture = self.frame:CreateTexture(nil, "ARTWORK", nil, 1);
	self.frame.containerTexture:SetTexture(self.textureName .. " Container", false);
	self.frame.containerTexture:ClearAllPoints();
	self.frame.containerTexture:SetPoint("BOTTOM", self.frame, "BOTTOM");
	self.frame.containerTexture:SetHeight(self.height);
	self.frame.containerTexture:SetWidth(self.width);
	self.frame.containerTexture:SetTexCoord(left,right,1,0);
	self:ArrangeTextures()
	--Set up the background texture for unlocked dragging
	self.frame.backdropTexture = self.frame:CreateTexture(nil, "BACKGROUND");
	self.frame.backdropTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\whitebackdropbase", true);
	self.frame.backdropTexture:ClearAllPoints();
	self.frame:SetPoint(self.myPoint, "FusionHUDMasterFrame", self.parentPoint, self.offsetX, self.offsetY);
	
	--Set up bar text frame
	self.frame.textFrame = CreateFrame("Frame", nil, self.frame);
	self.frame.textFrame:ClearAllPoints();
	if self.textIsDocked == true then
		self.frame.textFrame:SetPoint("TOP", self.frame, "BOTTOM");
	else
		self.frame.textFrame:SetPoint(self.textPoint, UIParent, self.textParentPoint, self.textOffsetX, self.textOffsetY);
	end
	if self.numLabels then
		self.frame.textFrame:SetHeight((self.fontSize * self.numLabels) + (self.numLabels * 2));
	else
		self.frame.textFrame:SetHeight((self.fontSize) + (2));
		self.numLabels = 1
	end
	self.frame.textFrame:SetWidth(250);
	self.frame.textFrame:SetClampedToScreen(true);
	--Set up text frame drag texture and title region for dragging
	self.frame.textFrame.titleRegion = self.frame.textFrame:CreateTitleRegion();
	self.frame.textFrame.titleRegion:ClearAllPoints();
	self.frame.textFrame.backdropTexture = self.frame:CreateTexture(nil, "BACKGROUND");
	self.frame.textFrame.backdropTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\whitebackdropbase", true);
	self.frame.textFrame.backdropTexture:ClearAllPoints();
	--Set up bar labels
	local i = 1;

	self.frame.textFrame:Show();
	
	self.frame.textFrame.label = self.frame.textFrame:CreateFontString(nil, "LOW");
	self.frame.textFrame.label:ClearAllPoints();
	self.frame.textFrame.label:SetAllPoints(self.frame.textFrame);
	self.frame.textFrame.label:SetFont(self.font, self.fontSize, "OUTLINE");
	self.frame.textFrame.label:SetJustifyH("CENTER");
	self.frame.textFrame.label:SetJustifyV("TOP");

	
	--Set up druid mana tracking bar
--	if englishClass == "DRUID" then
	self.frame.druidBar = self.frame:CreateTexture(nil, "ARTWORK", nil, -2);
	self.frame.druidBar:SetTexture(self.textureName, false);
	self.frame.druidBar:ClearAllPoints();
	self.frame.druidBar:SetPoint("BOTTOM", self.frame, "BOTTOM");
	self.frame.druidBar:SetHeight(self.height);
	self.frame.druidBar:SetWidth(self.width);
	self.frame.druidBar:SetTexCoord(left,right,1,0);
	self.frame.druidBar:SetVertexColor(0.2,0.4,1,1);
	self.frame.druidBar:Hide();
	
	self.frame.druidText = self.frame:CreateFontString(nil, "LOW");
	self.frame.druidText:ClearAllPoints();
	self.frame.druidText:SetPoint("TOP", self.frame.textFrame, "BOTTOM");
	self.frame.druidText:SetFont(self.font, self.fontSize, "OUTLINE");
	self.frame.druidText:SetJustifyH("CENTER");
	self.frame.druidText:SetJustifyV("TOP");
	self.frame.druidText:SetHeight(30);
	self.frame.druidText:SetWidth(250);
	self.frame.druidText:SetVertexColor(0.2,0.4,1,1);
	self.frame.druidText:Hide();
--	end
	
	self:Update(true);

	--Set Up the bar's options table (ACE3 Options Table)
	FusionHUDOptions.args.bars.args["bar" .. self.barIndex] = {};
	FusionHUDOptions.args.bars.args["bar" .. self.barIndex].name = self.barName;
	FusionHUDOptions.args.bars.args["bar" .. self.barIndex].type = "group";
	FusionHUDOptions.args.bars.args["bar" .. self.barIndex].order = self.barIndex;
	FusionHUDOptions.args.bars.args["bar" .. self.barIndex].args = {	
		lock = {
			name = "Unlock",
			order = 2,
			type = "execute",
			desc = "Unlocks the bar for repositioning",
			func = 	function()
						self.draggable = true;
						FusionHUDLockFrame:Show();
						InterfaceOptionsFrame:Hide();
						FusionHUDModSettings.isUnlocked = true;
						FusionHUD:LockHandler(self)
					end;
		},
		renameBar = {
			name = "Rename",
			order = 4,
			type = "input",
			desc = "Renames the bar in the menu",
			width = "full",
			get = function() return self.barName end,
			set = 	function (input1, input2)
						if input2 == nil or input2 == "" then
							return;
						else
							self.barName = input2;
							FusionHUDOptions.args.bars.args["bar" .. self.barIndex].name = self.barName;
						end
					end,
		},
		delete = {
			name = "Delete",
			order = 3,
			type = "execute",
			desc = "Delete this bar (CANNOT BE UNDONE)",
			func = 	function() 
						self:DeleteSelf();
						FusionHUD:CommitChanges();
						collectgarbage("collect");
					end,
			confirm = function() return "Are you sure? This cannot be undone" end,					
		},
		barType = {
			name = "Bar Type",
			order = 12,
			type = "select",
			desc = "The bar can track either Health, Power(Mana/Runic Power/Energy/Focus), Threat, or Alternate Power(Corruption on Cho'gall, for example).",
			style = "radio",
			values = {
				Power = "Power", 
				Alternate = "Alternate",
				Health = "Health",
				Threat = "Threat",
			},
			get = 	function() return self.barType end,
			set = 	function(key, value)
						self.barType = value
						if self.barTarget ==  "player" and self.barType == "Power" then
							local localClass, englishClass =  UnitClass("player");
							if englishClass == "DRUID" then
								self.frame.druidBar:SetTexture(self.textureName, false);
							end
						else
							self.frame.druidBar:SetTexture(nil, false);
						end
						if self.barType == FusionHUDBarType[3] or self.barType == FusionHUDBarType[4] then
							self.warningToggle = false;
						end
					end
		},
		barTarget = {
			name = "Bar Target",
			order = 11,
			type = "select",
			disabled = 	function() 
							if self.barType == FusionHUDBarType[3] or self.barType == FusionHUDBarType[4] then
								return true
							else
								return false
							end
						end,
			desc = "The unit that the bar will track (player-only for threat and alternate power bar)",
			style = "dropdown",
			values = {
				player = "Player",
				pet = "Pet",
				playertarget = "Player target",
				playertargettarget = "Target of Target",
				pettarget = "Pet Target",
				focus = "Focus"
			},
			get = 	function() return self.barTarget end,
			set = 	function(key, value) 
						if self.barType == FusionHUDBarType[3] or self.barType == FusionHUDBarType[4] then
							self.barTarget = "player";
						else
							self.barTarget = value;
						end
					end
		},
		barSkin = {
			name = "Bar Skin",
			order = 10,
			type = "select",
			desc = "Select the bar's skin",
			width = "full",
			style = "dropdown",
			values = {
				["Interface\\AddOns\\FusionHUD\\Graphics\\Curved Bar"] = "Curved",
				["Interface\\AddOns\\FusionHUD\\Graphics\\Vertical Bar Glass"] = "Vertical Glass",
				["Interface\\AddOns\\FusionHUD\\Graphics\\Curved Symmetric"] = "Curved Symmetric",
				["Interface\\AddOns\\FusionHUD\\Graphics\\Vee Bar"] = "Vee",
				["Interface\\AddOns\\FusionHUD\\Graphics\\Rectangular Horizontal"] = "Rectangular Horizontal",
				["Interface\\AddOns\\FusionHUD\\Graphics\\Rectangular Vertical"] = "Rectangular Vertical",
				["Interface\\AddOns\\FusionHUD\\Graphics\\Vee Lightning"] = "Vee Lightning",
			},
			get = 	function() return self.textureName end,
			set = 	function(k,v)
						self.textureName = tostring(v);
						self.frame.barTexture:SetTexture(self.textureName, false);
						self.frame.containerTexture:SetTexture(self.textureName .. " Container", false)
						self:ArrangeTextures();
						self.frame:ClearAllPoints()
						self.frame:SetPoint(self.myPoint, "FusionHUDMasterFrame", self.parentPoint, self.offsetX, self.offsetY);
						self.frame:SetHeight(self.height);
						self.frame:SetWidth(self.width);
						self.frame.barTexture:SetHeight(self.height);
						self.frame.barTexture:SetWidth(self.width);
						self.frame.barTexture:ClearAllPoints();
						self.frame.containerTexture:SetHeight(self.height);
						self.frame.containerTexture:SetWidth(self.width);
						self.frame.containerTexture:ClearAllPoints();
						if self.isHorizontal then
							if self.orientation == "Left" then
								self.frame.barTexture:SetPoint("LEFT", self.frame, "LEFT");
								self.frame.containerTexture:SetPoint("LEFT", self.frame, "LEFT");
							elseif self.orientation == "Right" then
								self.frame.barTexture:SetPoint("RIGHT", self.frame, "RIGHT");
								self.frame.containerTexture:SetPoint("RIGHT", self.frame, "RIGHT");
							end
						else
							self.frame.barTexture:SetPoint("BOTTOM", self.frame, "BOTTOM");
							self.frame.containerTexture:SetPoint("BOTTOM", self.frame, "BOTTOM");
						end
						if self.barTarget ==  "player" and self.barType == "Power" then
							local localClass, englishClass =  UnitClass("player");
							if englishClass == "DRUID" then
								self.frame.druidBar:SetTexture(self.textureName, false);
							end
						end
						self:Update(true)
					end,
		},	
		altPowerColor = {
			name = "Alt Power Bar Color",
			order = 12,
			hidden = 	function()
							if self.barType == FusionHUDBarType[4] then
								return false
							else
								return true
							end
						end,
			desc = "Sets the color of the Alternate Power Bar.",
			type = "color",
			get = 	function() return self.barR, self.barG, self.barB, 1; end,
			set = 	function(arg1,r,g,b,a)
						self.barR, self.barG, self.barB = r, g, b;
						self:Update(true);
					end,
		},
--[[		debugFlag = {
			name = "Debug",
			order = 12,
			hidden = 	function()
							if self.barType == FusionHUDBarType[4] then
								return false
							else
								return true
							end
						end,
			desc = "Turn on Debugging Spam",
			type = "toggle",
			get = 	function() return self.debug end,
			set = 	function()
						self.debug = not self.debug;
						FusionHUD:CommitChanges();
					end,
		},					--]]
		barFacing = {
			name = "Bar Facing",
			order = 13,
			type = "select",
			desc  = "Select which way the bar faces",
			hidden = function() return self.isHorizontal end,
			style = "radio",
			values = {
				["Left"] = "Left",
				["Right"] = "Right"
			},
			get = 	function() return self.orientation end,
			set = 	function(k,v)
						self.orientation = tostring(v);
					end
		},	
		barAnchor = {
			name = "Bar Anchor",
			order = 13,
			type = "select",
			desc  = "Select which end of the bar is the anchor (zero point)",
			hidden = function() return not self.isHorizontal end,
			style = "radio",
			values = {
				["Left"] = "Left",
				["Right"] = "Right"
			},
			get = 	function() return self.orientation end,
			set = 	function(k,v)
						self.orientation = tostring(v);
						self.frame.barTexture:ClearAllPoints();
						self.frame.barTexture:SetPoint(string.upper(self.orientation), self.frame, string.upper(self.orientation));
					end
		},	
		barHeight = {
			name = "Bar Height",
			order = 14,
			type = "range",
			min = 1,
			max = 800,
			step = 1,
			get = 	function() return self.height end,
			set = 	function(k,v) 
						self.height = v; 
						self.frame:SetHeight(self.height); 
						self.frame.containerTexture:SetHeight(self.height);
						self.frame.barTexture:SetHeight(self.height);
					end
		},
		barWidth = {
			name = "Bar Width",
			order = 15,
			type = "range",
			min = 1,
			max = 800,
			step = 1,
			get = 	function() return self.width end,
			set = 	function(k,v) 
						self.width = v; 
						self.frame:SetWidth(self.width); 
						self.frame.containerTexture:SetWidth(self.width);
						self.frame.barTexture:SetWidth(self.width);
						if self.barTarget ==  "player" and self.barType == "Power" then
							local localClass, englishClass =  UnitClass("player");
							if englishClass == "DRUID" then
								self.frame.druidBar:SetWidth(self.width);
							end
						end
					end
		},
		fontHeader = {
			name = "Bar Text Settings",
			type = "header",
			order = 20
		},
		textDocked = {
			name = "Text Docked to Bar",
			type = "toggle",
			order = 28,
			desc = "Dock the bar's label text to the bottom of the bar",
			get = 	function() return self.textIsDocked end,
			set = 	function() 
						self.textIsDocked = not self.textIsDocked;
						if self.textIsDocked then
							self.frame.textFrame:SetPoint("TOP", self.frame, "BOTTOM");
						end
					end,
		},
		font = {
			name = "Font",
			type = "select",
			order = 22,
			desc = "Choose the font this bar will use",
			style = "dropdown",
			values = {
				["Fonts\\FRIZQT__.TTF"] = "FrizQuadrata",
				["Interface\\AddOns\\FusionHUD\\Fonts\\DroidSans.ttf"] = "Droid Sans",
				["Interface\\AddOns\\FusionHUD\\Fonts\\DroidSans-Bold.ttf"] = "Droid Sans Bold",
				["Interface\\AddOns\\FusionHUD\\Fonts\\nobile.ttf"] = "Nobile" 
			},
			get = 	function() return tostring(self.font) end,
			set = 	function(k,v)
						self.font = v;
						self.fontKey = k;
						self.frame.textFrame.label:SetFont(self.font, self.fontSize, "OUTLINE");
						self:Update(true);
					end
		},
		fontSize = {
			name = "Font Size",
			type = "range",
			order = 25,
			desc = "Select font size",
			min = 6,
			max = 24,
			step = 1,
			get = 	function() return self.fontSize end;
			set = 	function(k,v)
						self.fontSize = v;
						self.frame.textFrame.label:SetFont(self.font, self.fontSize, "OUTLINE");
						self.frame.textFrame.label:SetHeight((self.fontSize * self.numLabels) + 2);
						if self.frame.druidText then
							self.frame.druidText:SetFont(self.font, self.fontSize, "OUTLINE");
						end
						self:Update(true);
					end
		},
		showValue = {
			name = "Bar Value",
			type = "toggle",
			order = 30,
			desc = "Show text for raw value of the bar in its label",
			hidden = 	function() 
							if self.barType == FusionHUDBarType[3] then
								return true
							else
								return false
							end
						end,
			get = 	function() return self.showValueText end,
			set = 	function() 
						self.showValueText = not self.showValueText;
						self:Update(true);
					end,
		},
		showTotal = {
			name = "Bar Maximum",
			type = "toggle",
			order = 31,
			desc = "Show maximum value of the bar in its label (raw value/Maximum value",
			disabled = 	function() return not self.showValueText end,
			hidden = 	function() 
							if self.barType == FusionHUDBarType[3] then
								return true
							else
								return false
							end
						end,
			get = 	function() return self.showTotalText end,
			set = 	function() 
						self.showTotalText = not self.showTotalText;
						self:Update(true);
					end,
		},
		showPercent = {
			name = "Show Percentage",
			type = "toggle",
			order = 30,
			desc = "Show percentage value of the bar in its label",
			hidden = 	function() 
							if self.barType == FusionHUDBarType[3] then
								return true
							else
								return false
							end
						end,
			get = 	function() return self.showPercentText end,
			set = 	function() 
						self.showPercentText = not self.showPercentText;
						if self.showPercentText then
							self.numLabels = self.numLabels + 1;
						else
							self.numLabels = self.numLabels - 1;
						end
						self:Update(true);
					end,
		},
		showLabel = {
			name = 	function()
						if self.barTarget == "player" then
							return "Show Bar Type";
						else
							return "Show Unit Name";
						end
					end,
			type = "toggle",
			order = 35,
			desc = 	function()
						if self.barType == FusionHUDBarType[4] then
							return "Show the alternate ability name."
						elseif self.barTarget == FusionHUDBarType[1] then
							if self.barTarget == "target" then
								return "Show the target name."
							elseif self.barTarget == "player" then
								return "Show the bar type."
							elseif self.barTarget == "pet" then
								return "Show pet's name"
							elseif self.barTarget == "focus" then
								return "Show focus target's name"
							end
						elseif self.barTarget == FusionHUDBarType[2] then
							return "Show the power name."
						end
					end,
			hidden = 	function() 
							if self.barType == FusionHUDBarType[3] then
								return true
							else
								return false
							end
						end,
			get = 	function() return self.showLabelText end,
			set = 	function() 
						self.showLabelText = not self.showLabelText;
						if self.showLabelText then
							self.numLabels = self.numLabels + 1;
						else
							self.numLabels = self.numLabels - 1;
						end
						self:Update(true);
					end,
		},
		warnHeader = {
			name = "Bar Warning Color Settings",
			type = "header",
			hidden = function() 
						if self.barType == FusionHUDBarType[3] or self.barType == FusionHUDBarType[4] then 
							return true
						else
							return false
						end
					end,
			order = 40
		},
		warnToggle = {
			name = "Enable Warning Colors",
			type = "toggle",
			hidden = function() 
						if self.barType == FusionHUDBarType[3] or self.barType == FusionHUDBarType[4] then 
							return true
						else
							return false
						end
					end,
			width = "full",
			order = 41,
			desc = "Enable yellow and red warning colors for low bar values (customizable)",
			get = 	function() return self.warningToggle end,
			set = 	function() 
						self.warningToggle = not self.warningToggle; 
						self:Update(true);
					end,
		},
		warnYellowThreshold = {
			name = "Yellow Threshold",
			type = "range",
			hidden = function() return not self.warningToggle end,						
			order = 42,
			desc = "Sets the value at which the bar turns yellow for caution",
			min = 1,
			max = 100,
			step = 1,
			get = 	function() return self.yellowThreshold end,
			set = 	function(k,v)	
						self.yellowThreshold = v;
						if self.yellowThreshold <= self.redThreshold then
							self.redThreshold = self.yellowThreshold - 1;
						end
						self:Update(true);
					end,
		},
		warnRedThreshold = {
			name = "Red Threshold",
			type = "range",
			hidden = function() return not self.warningToggle end,
			order = 43,
			desc = "Sets the value at which the bar turns red for danger (MUST BE LOWER THAN THE CAUTIONARY YELLOW VALUE)",
			min = 0,
			max = 100,
			step = 1,
			get = 	function() return self.redThreshold end,
			set = 	function(k,v)	
						if v >= self.yellowThreshold then
							if self.warnPrinted == true then
								self.warnPrinted = false;
							else
								FusionHUD:Print("Red danger value must be smaller than the yellow caution value.");
								self.warnPrinted = true;
							end
							return
						else
							self.redThreshold = v;
							self:Update(true);
						end
					end,
		},
						
	}
end

function FusionHUDBarPrototype:Update(forceUpdate)	-- The bar update function
	local top, bottom, left, right;
	local localClass, englishClass = UnitClass("player");
	if FusionHUDModSettings.isUnlocked then
		FusionHUDMasterFrame:SetAlpha(1);
		return
	end
	FusionHUD:Transparency();
	if UnitName(self.barTarget) == nil then
		self.frame:Hide();
		return
	else
		self.frame:Show();
		if self.orientation == "Left" then
			left = 0;
			right = 1;
		else
			left = 1;
			right = 0;
		end
		if self.barType == FusionHUDBarType[1] then		--check for type of bar, power or health
			-- check to see if dimension or health/power values have changed
			if self.lastValue ~= UnitHealth(self.barTarget) or 
			 self.lastValueMax ~= UnitHealthMax(self.barTarget) or 
			 self.height ~= self.lastHeight or 
			 self.width ~= self.lastWidth or
			 self.orientation ~= self.lastOrientation or 
			 forceUpdate then
				local health, percent, label, barText = "", "", "", "";
				if self.showValueText then
					if UnitHealth(self.barTarget) <= 0 then
						health = "DEAD\r";
					else
						health = UnitHealth(self.barTarget);
						if self.showTotalText then
							health = health .. "/" .. UnitHealthMax(self.barTarget) .. "\r";
						else
							health = health .. "\r";
						end
					end
				end
				if self.showPercentText then
					if UnitHealthMax(self.barTarget) == 0 then
						percent = "0%";
					else
						percent = math.floor(100 * UnitHealth(self.barTarget) / UnitHealthMax(self.barTarget));
						percent =  percent .. "%\r"
					end
				end
				if self.showLabelText then
					if self.barTarget ==  "player" then
						label = "Health"
					else
						local colorString
						local targetGUID = UnitGUID(self.barTarget);
						local B = tonumber(targetGUID:sub(5,5), 16);
						local maskedB = B % 8;  -- determines if the target is a player, pet or vehicle. Threat bar will filter these out.
						local knownTypes = {[0]="player", [3]="NPC", [4]="pet", [5]="vehicle"};
						if knownTypes[maskedB] == "player" then
							local targetLocalClass, targetEnglishClass = UnitClass(self.barTarget) 
							if targetEnglishClass == "DRUID" then
								colorString = "|cffff6600";
							elseif targetEnglishClass == "HUNTER" then
								colorString = "|cff66cc00";
							elseif targetEnglishClass == "MAGE" then
								colorString = "|cff33ffff";
							elseif targetEnglishClass == "PALADIN" then
								colorString = "|cffff66BB";
							elseif targetEnglishClass == "PRIEST" then
								colorString = "|cffffffff";
							elseif targetEnglishClass == "ROGUE" then
								colorString = "|cffffff33";
							elseif targetEnglishClass == "SHAMAN" then
								colorString = "|cff2222ff";
							elseif targetEnglishClass == "WARLOCK" then
								colorString = "|cff9966cc";
							elseif targetEnglishClass == "WARRIOR" then
								colorString = "|cff996633";
							elseif targetEnglishClass == "DEATHKNIGHT" then
								colorString = "|cff990000";
							else
								colorString = "|cffffffff";
							end
						else
							colorString = "|cffffffff";
						end
						label = colorString .. UnitName(self.barTarget) .. "|r";
					end
					label = label .. "\r";
				end
				barText = health .. percent .. label
				self.frame.textFrame:SetHeight((self.fontSize * self.numLabels) + 2);
				self.frame.textFrame.label:SetText(barText);
				self.lastHeight, self.lastWidth, self.lastValue, self.lastValueMax, self.lastOrientation = self.height, self.width, UnitHealth(self.barTarget), UnitHealthMax(self.barTarget), self.orientation;
				--set color for the health bar
				local targetGUID = UnitGUID(self.barTarget);
				if targetGUID == nil then
					targetGUID = "00001";
				end
				local B = tonumber(targetGUID:sub(5,5), 16);
				if B == nil then
					B = 1;
				end
				local maskedB = B % 8;  -- determines if the target is a player, pet or vehicle. Threat bar will filter these out.
				local knownTypes = {[0]="player", [3]="NPC", [4]="pet", [5]="vehicle"};
				if knownTypes[maskedB] ~= "player" then
					if self.barTarget == "playertarget" or self.barTarget == "playertargettarget" or self.barTarget == "focus" then
						if UnitAffectingCombat(self.barTarget) then
							if UnitIsTappedByPlayer(self.barTarget) then
								self.frame.barTexture:SetVertexColor(0,0.8,0,1);
								self.frame.textFrame.label:SetVertexColor(0,0.8,0,1);
							else
								self.frame.barTexture:SetVertexColor(0.7, 0.7, 0.7, 1);
								self.frame.textFrame.label:SetVertexColor(0.7, 0.7, 0.7, 1);
							end
						else
							self.frame.barTexture:SetVertexColor(0,0.8,0,1);
							self.frame.textFrame.label:SetVertexColor(0,0.8,0,1);
						end
					else
						self.frame.barTexture:SetVertexColor(0,0.8,0,1);
						self.frame.textFrame.label:SetVertexColor(0,0.8,0,1);
					end
				else
					if self.warningToggle and (100 * UnitHealth(self.barTarget) / UnitHealthMax(self.barTarget)) <= self.yellowThreshold then
						self:WarningColor(100 * UnitHealth(self.barTarget) / UnitHealthMax(self.barTarget));
					else
						self.frame.barTexture:SetVertexColor(0,0.8,0,1);
					end
					self.frame.textFrame.label:SetVertexColor(0,0.8,0,1);
				end
				--set bar height and text for a health bar
				self:BarHeightHandler(self, UnitHealth(self.barTarget), UnitHealthMax(self.barTarget));
			end
		elseif self.barType == FusionHUDBarType[2] then
			local powerType = UnitPowerType(self.barTarget);
			local r,g,b
			-- check to see if values have changed
			if self.lastValue ~= UnitPower(self.barTarget) or 
			 self.lastValueMax ~= UnitPowerMax(self.barTarget) or 
			 self.height ~= self.lastHeight or 
			 self.width ~= self.lastWidth or
			 self.orientation ~= self.lastOrientation or
			 self.lastDruidValue ~= UnitPower("player", 0) or 
			 forceUpdate then
				local power, percent, label, barText = "", "", "", "";
				if self.showValueText then
					power = UnitPower(self.barTarget);
					if self.showTotalText then
						power = power  .. "/" .. UnitPowerMax(self.barTarget);
					end
					power = power .. "\r";
				end
				if self.showPercentText then
					if UnitPowerMax(self.barTarget) == 0 then
						percent = "0%";
					else
						percent = math.floor(100 * UnitPower(self.barTarget) / UnitPowerMax(self.barTarget));
						percent = percent .. "%\r";
					end
				end
				if self.showLabelText and self.barTarget == "player" then
					label = FusionHUDPowerType[powerType + 1];
				else
					label = "";
				end
				barText = power .. percent .. label;
				self.frame.textFrame:SetHeight((self.fontSize * self.numLabels) + 2);
				self.frame.textFrame.label:SetText(barText);
				self.lastDruidValue, self.lastValue, self.lastValueMax, self.lastHeight, self.lastWidth, self.lastOrientation = UnitPower("player", 0), UnitPower(self.barTarget), UnitPowerMax(self.barTarget), self.height, self.width, self.orientation;
				--set color for the power bar
				if powerType == 1 then
					r,g,b = 0.8, 0, 0;
				elseif powerType == 6 then
					r,g,b = 0.25, 0.75, 1;
				elseif powerType == 0 then
					r,g,b = 0.2, 0.4, 1;
				elseif powerType == 2 then
					r,g,b = 0.8, 0.3, 0;
				else
					r,g,b = 1, 1, 0;
				end
				if self.warningToggle and (100 * UnitPower(self.barTarget) / UnitPowerMax(self.barTarget)) <= self.yellowThreshold then
					self:WarningColor(100 * UnitPower(self.barTarget) / UnitPowerMax(self.barTarget));
				else
					self.frame.barTexture:SetVertexColor(r,g,b,1);
				end					
				self.frame.textFrame.label:SetVertexColor(r,g,b,1);			
				if self.barTarget == "player" and englishClass == "DRUID" then
					if powerType ~= 0 then
						self.frame.druidBar:Show();
						self.frame.druidText:Show();
						if self.orientation == "Left" then
							self.frame.druidBar:SetPoint("BOTTOM", self.frame, "BOTTOM", -7, 0);
						else
							self.frame.druidBar:SetPoint("BOTTOM", self.frame, "BOTTOM", 7, 0);
						end
						if (self.height*UnitPower(self.barTarget, 0)/UnitPowerMax(self.barTarget, 0)) > 0 then
							self.frame.druidBar:SetHeight(self.height*UnitPower(self.barTarget, 0)/UnitPowerMax(self.barTarget, 0));
							self.frame.druidBar:SetTexCoord(left,right,UnitPower(self.barTarget, 0)/UnitPowerMax(self.barTarget, 0), 0);
						elseif (self.height*UnitPower(self.barTarget, 0)/UnitPowerMax(self.barTarget, 0)) == 0 then
							self.frame.druidBar:SetHeight(1);
							self.frame.druidBar:SetTexCoord(left,right,UnitPower(self.barTarget, 0)/UnitPowerMax(self.barTarget, 0),0);
						else
							self.frame.druidBar:SetHeight(1);
							self.frame.druidBar:SetTexCoord(left,right,0,0);
						end
						self.frame.druidText:SetText(UnitPower(self.barTarget, 0) .. "/" .. UnitPowerMax(self.barTarget,0));
					else
						self.frame.druidBar:Hide();
						self.frame.druidText:Hide();
					end
				end
				--set bar height and text for the power bar
				self:BarHeightHandler(self, UnitPower(self.barTarget), UnitPowerMax(self.barTarget));
			end 
		elseif self.barType == FusionHUDBarType[3] then
			self.frame.containerTexture:SetTexCoord(left, right, 1, 0);
			if UnitName("target") ~= nil and UnitName("target") ~= "Unknown" then
				local isTanking, status, threatPct, rawThreatPct, threatValue = UnitDetailedThreatSituation(self.barTarget, "target");
				if self.lastValue ~= threatPct or self.lastTarget ~= UnitGUID("target") or UnitAffectingCombat(self.barTarget) or forceUpdate then
					self.lastValue = threatPct;
					local r, g, b = GetThreatStatusColor(status);
					self.lastTarget = UnitGUID("target");
					local B = tonumber(self.lastTarget:sub(5,5), 16);
					local maskedB = B % 8;  -- determines if the target is a player, pet or vehicle. Threat bar will filter these out.
					local knownTypes = {[0]="player", [3]="NPC", [4]="pet", [5]="vehicle"};
					if knownTypes[maskedB] ~= "player" or knownTypes[maskedB] ~= "pet" or knownTypes[maskedB] ~= "vehicle" then
						--set bar height and text for the threat bar
						self:BarHeightHandler(self, threatPct, 100);
					end
					self.frame.barTexture:SetVertexColor(r, g, b, 1);  -- color key:  Gray: safely low threat, Yellow: Close to the tank on threat, Orange: (tanking) Losing aggro soon, Red:  Has aggro, tanking
					self.frame.textFrame.label:SetText(math.floor(threatPct or 0) .. "%");
					self.frame.textFrame:SetHeight((self.fontSize * self.numLabels) + 2);
				else
					self.frame:Hide();  
				end 
			else
				self.frame:Hide()
			end
		elseif self.barType ==  FusionHUDBarType[4] then
			if UnitPowerMax("player", 10) > 0 then
				self.frame:Show();
				self.frame.textFrame.label:SetVertexColor(self.barR, self.barG, self.barB, 1);
				self.frame.barTexture:SetVertexColor(self.barR, self.barG, self.barB, 1);
--				FusionHUD:Print(self.lastValue, UnitPower("player", 10), self.lastValueMax, UnitPowerMax("player", 10));
				if self.lastValue ~= UnitPower("player", 10) or self.lastValueMax~=UnitPowerMax("player", 10) or forceUpdate then
					local power, percent, label;
					local var1, var2, var3, var4, var5, var6, var7, var8, var9, altName = UnitAlternatePowerInfo("player");
--					FusionHUD:Print("updated");
					self.lastValue = UnitPower("player", 10);
					self.lastValueMax = UnitPowerMax("player", 10);
					if altName == nil then
						self.frame:Hide();
					else
						if self.showValueText then
							power = UnitPower("player", 10);
							if self.showTotalText then
								power = power  .. "/" .. UnitPowerMax("player", 10);
							end
							power = power .. "\r";
						else
							power = "";
						end
						if self.showPercentText then
							if UnitPowerMax("player", 10) == 0 or UnitPowerMax("player", 10) == nil then
								percent = 0;
							else
								percent = math.floor(100 * UnitPower("player", 10) / UnitPowerMax("player", 10));
								percent = percent .. "%\r";
							end
						else
							percent = "";
						end
						if self.showLabelText then
							label = altName;
						else
							label = "";
						end
						barText = power .. percent .. label;
						self.frame.textFrame:SetHeight((self.fontSize * self.numLabels) + 2);
						self.frame.textFrame.label:SetText(barText);
						self:BarHeightHandler(self, UnitPower("player", 10), UnitPowerMax("player", 10));
						if self.debug then
							FusionHUD:Print("v1=", var1,", var2=", var2,", var3=",var3,", var4=",var4,", var5=", var5,", var6=", var6,", var7=", var7,", var8=", var8,", var9=", var9,", altName=", altName);
						end
					end
				end
			else
				self.frame:Hide();
				self.lastValueMax = -99999999;
			end
		end
	end	
end

function FusionHUDBarPrototype:ArrangeTextures()
	if self.textureName == "Interface\\AddOns\\FusionHUD\\Graphics\\Vertical Bar Glass" then
		self.frame.containerTexture:SetDrawLayer("ARTWORK", 1);
		self.frame.containerTexture:SetBlendMode("BLEND");
		self.frame.barTexture:SetBlendMode("BLEND");
	elseif 	self.textureName == "Interface\\AddOns\\FusionHUD\\Graphics\\Rectangular Horizontal" 
			or self.textureName == "Interface\\AddOns\\FusionHUD\\Graphics\\Rectangular Vertical" then
		self.frame.containerTexture:SetDrawLayer("ARTWORK", -1);
		self.frame.containerTexture:SetBlendMode("BLEND");
		self.frame.barTexture:SetBlendMode("BLEND");
	elseif 	self.textureName == "Interface\\AddOns\\FusionHUD\\Graphics\\Curved Symmetric" 
			or self.textureName == "Interface\\AddOns\\FusionHUD\\Graphics\\Vee Lightning" then
		self.frame.containerTexture:SetDrawLayer("ARTWORK", -1);
		self.frame.containerTexture:SetBlendMode("BLEND");
		self.frame.barTexture:SetBlendMode("BLEND");
	elseif self.textureName == "Interface\\AddOns\\FusionHUD\\Graphics\\Curved Bar" then
		self.frame.containerTexture:SetDrawLayer("ARTWORK", 1);
		self.frame.containerTexture:SetBlendMode("BLEND");
		self.frame.barTexture:SetBlendMode("BLEND");
	elseif self.textureName == "Interface\\AddOns\\FusionHUD\\Graphics\\Vee Bar" then
		self.frame.containerTexture:SetDrawLayer("ARTWORK", 1);
		self.frame.containerTexture:SetBlendMode("BLEND");
		self.frame.barTexture:SetBlendMode("BLEND");
	else
		self.frame.containerTexture:SetDrawLayer("ARTWORK", -1);
		self.frame.containerTexture:SetBlendMode("BLEND");
		self.frame.barTexture:SetBlendMode("BLEND");
	end
	if self.isHorizontal and string.find(self.textureName, "Horizontal") == nil then
		local temp;
		temp = self.width;
		self.width = self.height;
		self.height = temp;
		self.isHorizontal = false;
	elseif self.isHorizontal == false and string.find(self.textureName, "Horizontal") ~= nil then
		local temp;
		temp = self.width;
		self.width = self.height;
		self.height = temp;
		self.isHorizontal = true;
	end
end

function FusionHUDBarPrototype:BarHeightHandler(self, barMeasure, barMeasureMax)
	local barLeft, barRight, barTop, barBottom, containerLeft, containerRight, containerTop, containerBottom, temp;
	--set bar height for the bar
	containerTop = 1;
	containerBottom = 0;
	if barMeasure == nil or barMeasureMax == nil then
		self.frame:Hide();
		return
	else
		if self.isHorizontal then
			barTop = 1;
			barBottom = 0;
			if self.orientation == "Left" then
				barLeft = 0;
				if barMeasureMax == 0 then
					barRight = 0;
				elseif barMeasure/barMeasureMax > 100 then
					barRight = 1;
				elseif barMeasure/barMeasureMax <= 0 then
					barRight = 0;
				else
					barRight = barMeasure/barMeasureMax;
				end
				containerLeft = 0;
				containerRight = 1;
			else
				if barMeasureMax == 0 then
					barLeft = 0;
				elseif barMeasure/barMeasureMax >= 100 then
					barLeft = 1;
				elseif barMeasure/barMeasureMax <= 0 then
					barLeft = 0;
				else
					barLeft = barMeasure/barMeasureMax;
				end
				barRight = 0;
				containerLeft = 1;
				containerRight = 0;
			end
		else
			if barMeasureMax == 0 then
				barTop = 0;
			elseif barMeasure/barMeasureMax >= 1 then
				barTop = 1;
			elseif barMeasure/barMeasureMax <= 0 then
				barTop = 0;
			else
				barTop = barMeasure/barMeasureMax;
			end
			barBottom = 0;
			if self.orientation == "Left" then
				barLeft = 0;
				barRight = 1;
				containerLeft = 0;
				containerRight = 1;
			else
				barLeft = 1;
				barRight = 0;
				containerLeft = 1;
				containerRight = 0;
			end
		end 
		self.frame:Show();
	end
	self.frame.containerTexture:SetTexCoord(containerLeft, containerRight, containerTop, containerBottom);
	if (self.height*barMeasure/barMeasureMax) > 0 then
		if self.isHorizontal then
			self.frame.barTexture:SetWidth(self.width*barMeasure/barMeasureMax);
		else
			self.frame.barTexture:SetHeight(self.height*barMeasure/barMeasureMax);
		end
		self.frame.barTexture:SetTexCoord(barLeft,barRight, barTop, barBottom);
		if self.barType ==  FusionHUDBarType[3] and barMeasure > 100 then
			self.frame:Show();
			if self.isHorizontal then
				self.frame.barTexture:SetWidth(self.width)
				self.frame.barTexture:SetTexCoord(barLeft,barRight, barTop, barBottom);
			else
				self.frame.barTexture:SetHeight(self.height);
			self.frame.barTexture:SetTexCoord(barLeft,barRight, barTop, barBottom);
			end

		end
	elseif (self.height*barMeasure/barMeasureMax) == 0 then
		if self.barType == FusionHUDBarType[3] then
			self.frame:Hide();
		end
		if self.isHorizontal then
			self.frame.barTexture:SetWidth(1);
		else
			self.frame.barTexture:SetHeight(1);
		end
		self.frame.barTexture:SetTexCoord(barLeft,barRight,barTop, barBottom);
	else
		if self.barType == FusionHUDBarType[3] then
			self.frame:Hide();
		end
		if self.isHorizontal then
			self.frame.barTexture:SetWidth(1);
		else
			self.frame.barTexture:SetHeight(1);
		end
		self.frame.barTexture:SetTexCoord(barLeft,barRight,barTop, barBottom);
	end	
end

function FusionHUDBarPrototype:WarningColor(value)
	local r, g, b;
	if value <= self.redThreshold then
		r, g, b = FusionHUDWarnColor.redR, FusionHUDWarnColor.redG, FusionHUDWarnColor.redB;
	elseif value <= self.yellowThreshold then
		r, g, b = FusionHUDWarnColor.yellowR, FusionHUDWarnColor.yellowG, FusionHUDWarnColor.yellowB;
	end		
	self.frame.barTexture:SetVertexColor(r,g,b,1);
end
	
function FusionHUDBarPrototype:DeleteSelf()
	self.frame:Hide()
	self.frame:SetAllPoints(nil);
	self.frame:ClearAllPoints();
	self.frame = nil;
	FusionHUDBars["bar" .. self.barIndex] = nil;
	FusionHUDOptions.args.bars.args["bar" .. self.barIndex] = nil
end