FusionHUD = LibStub("AceAddon-3.0"):NewAddon("FusionHUD", "AceConsole-3.0", "AceEvent-3.0");
local AceGUI = LibStub("AceGUI-3.0");

local _G = _G;
FusionHUDLastUpdateClock = GetTime();
FusionHUDProfileName = UnitName("player") .. " - " .. GetRealmName();
compositeName = "";
firstRunSetup = true;

 --Set up FusionHUD Options (Ace3 Config)
FusionHUDOptions = {
    name = "Fusion HUD",
	type = "header",
    handler = FusionHUD,
	childGroups = "tab",
    type = "group",
    args = {
		disclaimer = {
			name = "***NOTE:  You MUST click the [Okay] button to make your changes stick.  Otherwise the changes will revert to their previous settings. Clicking the [LOCK] button when moving frames will also make the changes stick.",
			type = "description",
			order =1,
			fontSize = "medium",
		},		
		lockedWarning = {
			name = "FusionHUD has unlocked elements.  Please use the lock panel at the top of the screen to re-lock the HUD. If you do not see the lock panel, please press the button below to show it, and then lock FusionHUD using the lock button.",
			type = "description",
			order = 1,
			hidden = function() return not FusionHUDModSettings.isUnlocked end,
			fontSize = "medium",
		},
		showLockFrame = {
			name = "Show Lock Panel",
			type = "execute",
			hidden = function() return not FusionHUDModSettings.isUnlocked end,
			order = 2,
			width = "full",
			desc = "Shows the FusionHUD Lock Panel",
			func = 	function() FusionHUDLockFrame:Show(); InterfaceOptionsFrame:Hide(); end,
		}, 
		newBar = {
			name = "New Bar",
			type = "execute",
			desc = "Creates a new HUD bar",
			hidden = function() return FusionHUDModSettings.isUnlocked end,
			order = 1,
			width = "double",
			func = 		function()
							local index = 0;
							table.foreach(FusionHUDBars, function(k,v) if index < v.barIndex then index = v.barIndex end end);
							FusionHUDBars["bar" .. index + 1] = FusionHUDBarPrototype:New(index + 1)
							FusionHUD:CommitChanges();
							collectgarbage("collect");
						end,
		},
		unlockAll = {
			name = "Unlock All Bars",
			type = "execute",
			desc = "Unlocks all HUD bars for repositioning",
			hidden = function() return FusionHUDModSettings.isUnlocked end,
			order = 4,
			width = "double",
			func = 	function() 
						table.foreach(FusionHUDBars, 	function(k,v)
															v.draggable = true;
															FusionHUD:LockHandler(v);
															FusionHUDModSettings.isUnlocked = true;
														end);
						if FusionHUDModSettings.classBarToggle then								
							FusionHUDClassBar.draggable = true;
							FusionHUD:LockHandler(FusionHUDClassBar);
						end
						FusionHUDModSettings.isUnlocked = true,
						FusionHUDLockFrame:Show();
						InterfaceOptionsFrame:Hide();
					end,
		},
		mainOptions = {
			name = "Options",
			type = "group",
			order = 20,
			hidden = function() return FusionHUDModSettings.isUnlocked end,
			args = {
				hideMinimapIcon = {
					name = "Hide minimap button",
					type = "toggle",
					desc = "Hides the FusionHUD minimap button",
					order = 14,
					width = "double",
					get = 	function() return FusionHUDModSettings.hideFusionHUDMinimapIcon end,
					set = 	function()
								FusionHUDModSettings.hideFusionHUDMinimapIcon =  not FusionHUDModSettings.hideFusionHUDMinimapIcon;
								if FusionHUDModSettings.hideFusionHUDMinimapIcon then
									FusionHUDMinimapButtonFrame:Hide();
								else
									FusionHUDMinimapButtonFrame:Show();
								end
							end,
				},
				hideBlizzPlayerFrame = {
					name = "Hide Blizzard player frame",
					type = "toggle",
					desc = "Hides the Blizzard player frame",
					order = 15,
					width = "double",
					disabled = function() 
								if PlayerFrame:IsVisible() == false and FusionHUDModSettings.hideBlizzPlayerFrame ==  false then
									return true 
								else 
									return false 
								end
							end,
					get = 	function() return FusionHUDModSettings.hideBlizzPlayerFrame end,
					set = 	function() 
								FusionHUDModSettings.hideBlizzPlayerFrame =  not FusionHUDModSettings.hideBlizzPlayerFrame;
								if FusionHUDModSettings.hideBlizzPlayerFrame then
									PlayerFrame:SetScript("OnEvent", nil);
									PlayerFrame:Hide();
								else
									PlayerFrame:SetScript("OnEvent", PlayerFrame_OnEvent);
									PlayerFrame:Show();
								end
							end,
				},	
				hideBlizzPetFrame = {
					name = "Hide Blizzard player pet frame",
					type = "toggle",
					desc = "Hides the Blizzard player pet frame",
					order = 16,
					width = "double",
					disabled = function() 
								if PetFrame:IsVisible() == false and FusionHUDModSettings.hideBlizzPetFrame ==  false then
									return true 
								else 
									return false 
								end
							end,
					get = 	function() return FusionHUDModSettings.hideBlizzPetFrame end,
					set = 	function() 
								FusionHUDModSettings.hideBlizzPetFrame =  not FusionHUDModSettings.hideBlizzPetFrame;
								if FusionHUDModSettings.hideBlizzPetFrame then
									PetFrame:SetScript("OnEvent", nil);
									PetFrame:Hide();
								else
									PetFrame:SetScript("OnEvent", PetFrame_OnEvent);
									PetFrame:Show();
								end
							end,
				},	
				hideBlizzTargetFrame = {
					name = "Hide Blizzard target frame",
					type = "toggle",
					desc = "Hides the Blizzard target frame",
					order = 17,
					width = "double",
					disabled = function() 
								if TargetFrame:IsVisible() == false and FusionHUDModSettings.hideBlizzTargetFrame ==  false then
									return true 
								else 
									return false 
								end
							end,
					get = 	function() return FusionHUDModSettings.hideBlizzTargetFrame end,
					set = 	function() 
								FusionHUDModSettings.hideBlizzTargetFrame =  not FusionHUDModSettings.hideBlizzTargetFrame;
								if FusionHUDModSettings.hideBlizzTargetFrame then
									TargetFrame:SetScript("OnEvent", nil);
									TargetFrame:Hide();
								else
									TargetFrame:SetScript("OnEvent", TargetFrame_OnEvent);
									TargetFrame:Show();
								end
							end
				},
				hideBlizzPlayerAltPowerBar = {
					name = "Hide Blizzard PlayerPowerBarAlt",
					type = "toggle",
					desc = "Hides the Blizzard Alternate Power Bar",
					order = 17,
					width = "double",
					disabled = function() 
								if PlayerPowerBarAlt:IsVisible() == false and FusionHUDModSettings.hidePlayerPowerBarAlt ==  false then
									return true 
								else 
									return false 
								end
							end,
					get = 	function() return FusionHUDModSettings.hidePlayerPowerBarAlt end,
					set = 	function() 
								FusionHUDModSettings.hidePlayerPowerBarAlt =  not FusionHUDModSettings.hidePlayerPowerBarAlt;
								if FusionHUDModSettings.hidePlayerPowerBarAlt then
									PlayerPowerBarAlt:SetScript("OnEvent", nil);
									PlayerPowerBarAlt:Hide();
								else
									PlayerPowerBarAlt:SetScript("OnEvent", PlayerPowerBarAlt_OnEvent);
									PlayerPowerBarAlt:Show();
								end
							end,				
				},	
			},
		},
		transparency = {
			name = "Transparency Settings",
			type = "group",
			order = 35,
			hidden = function() return FusionHUDModSettings.isUnlocked end,
			args = {
				contextToggle = {
					name = "Context-sensitive Visibility",
					type = "toggle",
					order = 1,
					width = "full",
					desc = "Enables changing HUD visibility based on player situation",
					descStyle = "inline",
					get = 	function() return FusionHUDModSettings.multiTransparency end,
					set =	function() 
								FusionHUDModSettings.multiTransparency = not FusionHUDModSettings.multiTransparency 
							end,
				},
				contextOffTransparency = {
					name = "Transparency",
					type = "range",
					desc = "Set the HUD's overall transparency",
					order = 5,
					width = "double",
					hidden = function() return FusionHUDModSettings.multiTransparency end,
					min = 0,
					max = 100,
					step = 1,
					get = 	function() return FusionHUDModSettings.transparency*100 end,
					set = 	function(k,v) 
								FusionHUDModSettings.transparency = v/100 
							end,
				},
				contextOnHiVis = {
					name = "Maximum visibility",
					type = "range",
					desc = "Set the HUD visibility while in combat",
					order = 10,
					width = "double",
					hidden = function() return not FusionHUDModSettings.multiTransparency end,
					min = 0,
					max = 100,
					step = 1,
					get = 	function() return FusionHUDModSettings.hiVis*100 end,
					set = 	function(k,v) 
								FusionHUDModSettings.hiVis = v/100 
							end,
				},
				contextOnMidVis = {
					name = "Maximum visibility",
					type = "range",
					desc = "Shows when in combat",
					order = 10,
					width = "double",
					hidden = function() return not FusionHUDModSettings.multiTransparency end,
					min = 0,
					max = 100,
					step = 1,
					get = 	function() return FusionHUDModSettings.midVis*100 end,
					set = 	function(k,v) 
								FusionHUDModSettings.midVis = v/100 
							end,
				},
				contextOnLoVis = {
					name = "Minimum visibility",
					type = "range",
					desc = "Shows when out of combat, not targeting, not debuffed, at full health/power",
					order = 14,
					width = "double",
					hidden = function() return not FusionHUDModSettings.multiTransparency end,
					min = 0,
					max = 100,
					step = 1,
					get = 	function() return FusionHUDModSettings.loVis*100 end,
					set = 	function(k,v) 
								FusionHUDModSettings.loVis = v/100 
							end,
				},
			},					
		},
		classBar = {
			name = "Class Bar",
			type = "group",
			order = 30,
			hidden = function() return FusionHUDModSettings.isUnlocked end,
			desc = "Settings for the class-specific bar",
			args = {
				classBarHeader = {
					name = "The class bar is currently only available to Warlocks (soul shards), Paladins (holy power), Rogues,(combo points), Druids (combo points and eclipse bar), and Death Knights (runes)",
					type = "description",
					order = 1,
					fontSize = "medium",
				},					
				classBarToggle = {
					name = "Enable Class bar",
					type = "toggle",
					order = 5,
					width = "full",
					disabled = function() 
						local localizedClass, englishClass = UnitClass("player"); 
						if englishClass ~= "DEATHKNIGHT" and englishClass ~= "PALADIN" and englishClass ~= "WARLOCK" and englishClass ~= "ROGUE" and englishClass ~= "DRUID" then 
							return true 
						else 
							return false 
						end 
					end,
					desc = "Enables/Disables Class-specific bar (Only available for Death Knights, Paladins and Warlocks)",
					get = 	function() return FusionHUDModSettings.classBarToggle end,
					set =	function() 
								FusionHUDModSettings.classBarToggle = not FusionHUDModSettings.classBarToggle;
								if FusionHUDModSettings.classBarToggle then
									FusionHUDClassBar.frame:Show()
								else
									FusionHUDClassBar.frame:Hide()
								end
							end,
				},					
				classBarSize = {
					name = "Class bar scale",
					type = "range",
					desc = "Controls the size of the class-specific bar",
					order = 10,
					width = "double",
					hidden = function() return not FusionHUDModSettings.classBarToggle end,
					min = 0,
					max = 150,
					step = 1,
					get = 	function() return FusionHUDClassBar.height end,
					set = 	function(k,v) 
								local i;
								local localizedClass, englishClass = UnitClass("player");
								FusionHUDClassBar.height = v;
								FusionHUDClassBar.width = v * 6;
								if englishClass == "ROGUE" then
									FusionHUDClassBar.width = v;
									FusionHUDClassBar.frame.comboFrame.text:SetFont("Interface\\AddOns\\FusionHUD\\Fonts\\DroidSans.ttf", math.floor(FusionHUDClassBar.frame:GetHeight() * .8), "OUTLINE");
								end
								FusionHUDClassBar.frame:SetHeight(FusionHUDClassBar.height); 
								FusionHUDClassBar.frame:SetWidth(FusionHUDClassBar.width);
								if englishClass == "DRUID" then
									local name, tex, tier, col, rank = GetTalentInfo(3, 21, false, false, nil);
									local form = GetShapeshiftForm(false);
									if form == 3 then
										FusionHUDClassBar.frame:SetHeight(FusionHUDClassBar.height);
										FusionHUDClassBar.frame:SetWidth(FusionHUDClassBar.height);
									elseif form == 5 and rank == 1 then
										FusionHUDClassBar.frame:SetHeight(FusionHUDClassBar.height);
										FusionHUDClassBar.frame:SetWidth(FusionHUDClassBar.width);
									end
									FusionHUDClassBar.frame.comboFrame.text:SetFont("Interface\\AddOns\\FusionHUD\\Fonts\\DroidSans.ttf", math.floor(FusionHUDClassBar.frame:GetHeight() * .8), "OUTLINE");
									FusionHUDClassBar.frame.eclipseFrame.arrowFrame:SetHeight(FusionHUDClassBar.height * 4 / 5);
									FusionHUDClassBar.frame.eclipseFrame.arrowFrame:SetWidth(FusionHUDClassBar.height * .3);
								end
								if englishClass == "DEATHKNIGHT" then
									for i = 1,6 do
										FusionHUDClassBar.frame.runes[i]:SetWidth(v);
									end
								elseif englishClass == "PALADIN" then
									FusionHUD:UNIT_POWER("UNIT_POWER", "player", "HOLY_POWER");
								elseif englishClass == "WARLOCK" then
									FusionHUD:UNIT_POWER("UNIT_POWER", "player", "SOUL_SHARDS");
								elseif englishClass == "ROGUE" or englishClass == "DRUID" then
									FusionHUD:UNIT_COMBO_POINTS("UNIT_COMBO_POINTS");
								end
							end,
				},
				classBarUnlock = {
					name = "Unlock Class bar",
					type = "execute",
					order = 15,
					width = "double",
					hidden = function() return not FusionHUDModSettings.classBarToggle end,
					desc = "Unlocks the class bar for dragging.  Use the Lock button at the top of the screen when done.",
					func = 	function()
								FusionHUDClassBar.draggable = true;
								FusionHUD:LockHandler(FusionHUDClassBar);
								FusionHUDLockFrame:Show();
								FusionHUDModSettings.isUnlocked = true,
								InterfaceOptionsFrame:Hide();
							end,
				},
			},
		},
		profiles = {
			name = "Profiles",
			order =  40,
			type = "group",
			hidden = function() return FusionHUDModSettings.isUnlocked end,
			args = {
				warning1 = {
					name = "Profiles let you copy the settings from another character to this one.",
					order = 1,
					type = "description",
				},
				spacer1 = {
					name = "                                               ",
					order = 2,
					type = "description",
				},
				warning2 = {
					name = "|cAAFFFF00IMPORTANT NOTE: |rThese changes are temporary and will revert when you log out unless you do one of the following:  ",
					order = 3,
					type = "description",
				},
				spacer2 = {
					name = "                                               ",
					order = 4,
					type = "description",
				},
				warning3 = {
					name = " (1) Close the options window",
					order = 5,
					type = "description",
				},
				warning4 = {
					name = " (2) Click [Okay] or [Cancel] below",
					order = 6,
					type = "description",
				},
				warning5 = {
					name = " (3) Press the big red COMMIT PROFILE button below ",
					order = 7,
					type = "description",
				},
				spacer3 = {
					name = "                                               ",
					order = 8,
					type = "description",
				},
				warning6 = {
					name = "Doing any of these three things will cause your profile selection to become irreversible.",
					order = 9,
					type = "description",
				},
				spacer4 = {
					name = "                                                            ";
					order = 10,
					type = "description",
				},
				currentProfile = {
					name = "|cffFCDA1CCurrent character: " .. "|cffffffff" .. UnitName("player") .. " - " .. GetRealmName(),
					order = 11,
					type = "description",
				},
				selectProfile = {
					name = "Select profile ",
					type = "select",
					order = 25,
					style = "dropdown",
					values = FusionHUDAvailableProfiles,
					get = 	function() return FusionHUDProfileName end,
					set = 	function(k,v) 
								local localClass, englishClass = UnitClass("player");
								local noClassBar = {"HUNTER", "WARRIOR", "MAGE", "PRIEST"};
								FusionHUDModSettings = nil;
								FusionHUDClassBar.frame:Hide();
								FusionHUDClassBar = nil;
								table.foreach(FusionHUDBars, function(k,v) 
									FusionHUDBars[k].frame:Hide();
									FusionHUDBars[k]:DeleteSelf() 
								end);
								if v == compositeName then									
									FusionHUDModSettings = FusionHUD:DeepCopy(FusionHUDCurrentProfile.modSettings);
									FusionHUDBars = FusionHUD:DeepCopy(FusionHUDCurrentProfile.bars);
									FusionHUDClassBar = FusionHUD:DeepCopy(FusionHUDDefaultSetup.classBar);									
								elseif v == "Default" then
									FusionHUDModSettings = FusionHUD:DeepCopy(FusionHUDDefaultSetup.settings);
									FusionHUDBars = FusionHUD:DeepCopy(FusionHUDDefaultSetup.bars);
									FusionHUDClassBar = FusionHUD:DeepCopy(FusionHUDDefaultSetup.classBar);
								else
									FusionHUDModSettings = FusionHUD:DeepCopy(FusionHUDDB[v].settings);
									FusionHUDBars = FusionHUD:DeepCopy(FusionHUDDB[v].bars);
									FusionHUDClassBar = FusionHUD:DeepCopy(FusionHUDDB[v].classBar);
								end
								for k,v in pairs(noClassBar) do
									if v == englishClass then						
										FusionHUDModSettings.classBarToggle = false;
										break;
									end
								end
								table.foreach(FusionHUDBars, function(k,v)
									setmetatable(FusionHUDBars[k], FusionHUDBarPrototype);
									FusionHUDBars[k].lastValue = -99999999999;
									FusionHUDBars[k].lastValueMax = -99999999999;
									FusionHUDBars[k]:BuildBar();
								end);
								FusionHUD:BuildClassBarFrame();
								FusionHUD:ClassSelector()
								FusionHUDProfileName = v;
							end						
				},
				commit = {
					name = "Commit Profile",
					desc = "Commits the current profile settings to his character.  THIS IS PERMANENT.",
					type = "execute",
					order = 50,
					func = 	function()
								FusionHUDProfileName = compositeName;
								FusionHUD:CommitChanges();
								collectgarbage("collect");
							end,
					confirm = function() return "Are you sure?  This cannot be undone" end,
				},
			},
		},		
		bars = {
			name = "Bar List",
			order = 10,
			type = "group",
			hidden = function() return FusionHUDModSettings.isUnlocked end,
			desc = "Listing of each HUD bar",
			args = {}
		},
    },
};

function FusionHUD:OnInitialize()	
	LibStub("AceConfig-3.0"):RegisterOptionsTable("FusionHUD", FusionHUDOptions);
	self.optionsFrame = LibStub("AceConfigDialog-3.0"):AddToBlizOptions("FusionHUD", "FusionHUD");
	--slash commands for opening options
	SLASH_FUSIONHUD1, SLASH_FUSIONHUD2 = '/fusionhud', '/fh';
	InterfaceOptionsFrameOkay:HookScript("OnClick", function(self) 
		FusionHUD:CommitChanges()
		collectgarbage("collect")
	end);
	InterfaceOptionsFrame:HookScript("OnHide", function(self) 
		FusionHUD:CommitChanges()
		collectgarbage("collect")
	end);
	InterfaceOptionsFrameCancel:HookScript( "OnClick", function(self) 
		FusionHUD:CommitChanges()
		collectgarbage("collect")
	end);
end
--Build the base frames for the addon, Master frame and Lock Frame
function FusionHUD:BuildBaseFrames()
	FusionHUDMasterFrame = CreateFrame("Frame", nil, UIParent);
	FusionHUDMasterFrame:SetClampedToScreen(true);
	FusionHUDMasterFrame:SetPoint("CENTER",UIParent,"CENTER");
	FusionHUDMasterFrame:SetFrameStrata("LOW");
	FusionHUDMasterFrame:SetHeight(400);
	FusionHUDMasterFrame:SetWidth(400);
	FusionHUDMasterFrame:Show();
	FusionHUDMasterFrame:SetAlpha(1);
	
	FusionHUDLockFrame = CreateFrame("Frame", nil, UIParent);
	FusionHUDLockFrame:SetClampedToScreen(true);
	FusionHUDLockFrame:ClearAllPoints();
	FusionHUDLockFrame:SetPoint("TOP", UIParent, "TOP", 0, -90);
	FusionHUDLockFrame:SetFrameStrata("FULLSCREEN");
	FusionHUDLockFrame:SetHeight(100);
	FusionHUDLockFrame:SetWidth(200);
	FusionHUDLockFrame.texture = FusionHUDLockFrame:CreateTexture(nil, "BACKGROUND");
	FusionHUDLockFrame.texture:SetAllPoints(FusionHUDLockFrame);
	FusionHUDLockFrame.texture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\whitebackdropbase", true);
	FusionHUDLockFrame.texture:SetVertexColor(0.7, 0.1, 0.1, 1);
	FusionHUDLockFrame.texture:SetTexCoord(0,1,0,1)
	FusionHUDLockFrame.text1 = FusionHUDLockFrame:CreateFontString(nil, "HIGH")
	FusionHUDLockFrame.text1:SetPoint("TOP", FusionHUDLockFrame, "TOP",0, -7);
	FusionHUDLockFrame.text1:SetFont("Fonts\\FRIZQT__.TTF", 24, "OUTLINE");
	FusionHUDLockFrame.text1:SetJustifyH("CENTER");
	FusionHUDLockFrame.text1:SetJustifyV("TOP");
	FusionHUDLockFrame.text1:SetHeight(30);
	FusionHUDLockFrame.text1:SetWidth(150);
	FusionHUDLockFrame.text1:SetText("FusionHUD");
	FusionHUDLockFrame.text2 = FusionHUDLockFrame:CreateFontString(nil, "HIGH")
	FusionHUDLockFrame.text2:SetPoint("TOP", FusionHUDLockFrame.text1, "BOTTOM",0, 0);
	FusionHUDLockFrame.text2:SetFont("Interface\\AddOns\\FusionHUD\\Fonts\\DroidSans.ttf", 14);
	FusionHUDLockFrame.text2:SetJustifyH("CENTER");
	FusionHUDLockFrame.text2:SetJustifyV("TOP");
	FusionHUDLockFrame.text2:SetHeight(30);
	FusionHUDLockFrame.text2:SetWidth(150);
	FusionHUDLockFrame.text2:SetText("Use this button to relock your bars");
	FusionHUDLockFrame:Hide();
	
	FusionHUDLockFrame.lockButton = CreateFrame("Button", "lockButton", FusionHUDLockFrame, "UIPanelButtonTemplate")
	FusionHUDLockFrame.lockButton:SetPoint("TOP", FusionHUDLockFrame.text2, "BOTTOM", 0, 0);
	FusionHUDLockFrame.lockButton:SetWidth(100);
	FusionHUDLockFrame.lockButton:SetHeight(30);
	FusionHUDLockFrame.text1:SetVertexColor(1,1,.4,1);
	FusionHUDLockFrame.text2:SetVertexColor(1, 1, 1, 1);
	FusionHUDLockFrame.lockButton:SetText("Lock");
	FusionHUDLockFrame.lockButton:SetFrameStrata("FULLSCREEN_DIALOG");
end

-- slash command Handler
function SlashCmdList.FUSIONHUD(msg, editbox)
	InterfaceOptionsFrame_OpenToCategory(FusionHUD.optionsFrame);
end

--function FusionHUD:Options_OnLoad(panel)
--	panel.okay = function() FusionHUD:Print("test") end
--end

function FusionHUD:OnEnable()
	local name, realm = UnitName("player"), GetRealmName();
	local k, v;
	compositeName = name .. " - " .. realm;
	FusionHUDBars = {};
	FusionHUD:BuildBaseFrames();
	if FusionHUDModSettings.hideFusionHUDMinimapIcon == nil then
		FusionHUDModSettings.hideFusionHUDMinimapIcon = false;
	end
	if FusionHUDModSettings.hideFusionHUDMinimapIcon then
		FusionHUDMinimapButtonFrame:Hide();
	else
		FusionHUDMinimapButtonFrame:Show();
	end
--Get saved settings and populate the bars with them, ensure variables are saved when exiting WOW
	if FusionHUDDB then
		if FusionHUDDB[name] then -- reformat old versions of saved variables to include server flag
			FusionHUDDB[compositeName] = FusionHUD:DeepCopy(FusionHUDDB[name]);
			FusionHUDDB[name] =  nil;
		end
		if FusionHUDDB[compositeName] then
			if FusionHUDDB[compositeName].settings then
				table.foreach(FusionHUDDB[compositeName].settings, function(k,v)
					FusionHUDModSettings[k] = FusionHUDDB[compositeName].settings[k]
				end);
			end
			if FusionHUDDB[compositeName].bars then
				table.foreach(FusionHUDDB[compositeName].bars, function(k,v)
					FusionHUDBars[k] = FusionHUDDB[compositeName].bars[k];
					setmetatable(FusionHUDBars[k], FusionHUDBarPrototype);
					FusionHUDBars[k].lastValue = -99999999999;
					FusionHUDBars[k].lastValueMax = -99999999999;
					FusionHUDBars[k]:BuildBar();
				end);
			end
			if FusionHUDDB[compositeName].classBar then
				table.foreach(FusionHUDDB[compositeName].classBar, function(k,v)
					FusionHUDClassBar[k] = FusionHUDDB[compositeName].classBar[k];
				end);
			end
		else
			FusionHUDDB[compositeName] = {};
		end
	else
		FusionHUDDB = {};
		FusionHUDDB[compositeName] = {};
	end
	for k, v in pairs(FusionHUDDB) do
		if string.find(tostring(k), " - ") ~= nil then
			FusionHUDAvailableProfiles[k] = tostring(k);
		end
	end
	FusionHUDAvailableProfiles["Default"] = "Default";
--Mark the HUD as 'set', profile-wise	
	FusionHUDModSettings.isSet = true;
--Save the current profile variables in a reserved table
	FusionHUDCurrentProfile.modSettings = FusionHUD:DeepCopy(FusionHUDModSettings);
	FusionHUDCurrentProfile.bars = FusionHUD:DeepCopy(FusionHUDBars);
	FusionHUDCurrentProfile.classBar = FusionHUD:DeepCopy(FusionHUDClassBar);
--Set Saved Variables to track the reserved table
	FusionHUDDB[compositeName].settings = FusionHUDCurrentProfile.modSettings;
	FusionHUDDB[compositeName].bars = FusionHUDCurrentProfile.bars;
	FusionHUDDB[compositeName].classBar = FusionHUDCurrentProfile.classBar;
--Start Class Bar setup
	FusionHUD:BuildClassBarFrame()
	FusionHUD:ClassSelector()
--Establish OnUpdate script for Master frame
	FusionHUDMasterFrame:SetScript("OnUpdate", 	function() FusionHUD:OnUpdate()	end);
--Register to receive Player Target Change events
	FusionHUD:RegisterEvent("PLAYER_TARGET_CHANGED");
--Establish Lock Button behavior	
	FusionHUDLockFrame.lockButton:SetScript('OnClick', 	function() 
		FusionHUDModSettings.isUnlocked = false;
		table.foreach(FusionHUDBars, function(k,v) 
			FusionHUDBars[k].draggable = false;
			FusionHUD:LockHandler(v);
			FusionHUDModSettings.isUnlocked = false;
		end);
		FusionHUDClassBar.draggable = false;
		FusionHUD:LockHandler(FusionHUDClassBar);
		FusionHUD:CommitChanges();
		collectgarbage("collect");
	end);
end

function FusionHUD:CommitChanges()
	FusionHUDCurrentProfile.modSettings = FusionHUD:DeepCopy(FusionHUDModSettings);
	FusionHUDCurrentProfile.bars = FusionHUD:DeepCopy(FusionHUDBars);
	FusionHUDCurrentProfile.classBar = FusionHUD:DeepCopy(FusionHUDClassBar);
	FusionHUDDB[compositeName].settings = FusionHUD:DeepCopy(FusionHUDCurrentProfile.modSettings);
	FusionHUDDB[compositeName].bars = FusionHUD:DeepCopy(FusionHUDCurrentProfile.bars);
	FusionHUDDB[compositeName].classBar = FusionHUD:DeepCopy(FusionHUDCurrentProfile.classBar);
end

function FusionHUD:DeepCopy(originalTable)
	local lookup_table = {}
    local function _copy(originalTable)
        if type(originalTable) ~= "table" then
            return originalTable
        elseif lookup_table[originalTable] then
            return lookup_table[originalTable]
        end
        local new_table = {}
        lookup_table[originalTable] = new_table
        for index, value in pairs(originalTable) do
            new_table[_copy(index)] = _copy(value)
        end
        return setmetatable(new_table, _copy(getmetatable(originalTable)))
    end
	return _copy(originalTable)
end

function FusionHUD:OnUpdate()
	local FusionHUDNextUpdateClock = GetTime()
	local localizedClass, englishClass = UnitClass("player");
--Updates frames every 1/10th of a second unless no change or forced
	if FusionHUDNextUpdateClock - FusionHUDLastUpdateClock > 0.1 then
		FusionHUDLastUpdateClock = FusionHUDNextUpdateClock;
		table.foreach(FusionHUDBars, 	function(k,v) 
											FusionHUDBars[k]:Update() 
										end);
		if englishClass == "DRUID" and FusionHUDModSettings.classBarToggle == true then
			if FusionHUDModSettings.isUnlocked then
				FusionHUDMasterFrame:SetAlpha(1);
				if form == 3 then
					FusionHUDClassBar.frame.eclipseFrame:Hide();
					FusionHUDClassBar.frame.comboFrame:Show()
					FusionHUDClassBar.frame:SetWidth(FusionHUDClassBar.height);
					FusionHUDClassBar.frame:Show();
				elseif form == 5 and treeRank == 0 and moonRank == 1 then
					FusionHUDClassBar.frame.eclipseFrame:Show();
					FusionHUDClassBar.frame.comboFrame:Hide()
					FusionHUDClassBar.frame:SetWidth(FusionHUDClassBar.width);
					FusionHUDClassBar.frame:Show();
				end
				FusionHUDClassBar.frame:Show();
				return 
			end 
			local form = GetShapeshiftForm(false)
			local treeName, treeTex, treeTier, treeCol, treeRank = GetTalentInfo(3, 21, false, false, nil);
			local moonName, moonTex, moonTier, moonCol, moonRank = GetTalentInfo(1, 8, false, false, nil);
			if form == 3 then
				FusionHUDClassBar.frame.eclipseFrame:Hide();
				FusionHUDClassBar.frame.comboFrame:Show()
				FusionHUDClassBar.frame:SetWidth(FusionHUDClassBar.height);
				if GetComboPoints("player", "target") ~= 0 then
					FusionHUDClassBar.frame:Show();
				else
					FusionHUDClassBar.frame:Hide();
				end
			elseif form == 5 and treeRank == 0 and moonRank == 1 then
				FusionHUDClassBar.frame.eclipseFrame:Show();
				FusionHUDClassBar.frame.comboFrame:Hide()
				FusionHUDClassBar.frame:SetWidth(FusionHUDClassBar.width);
				FusionHUDClassBar.frame:Show();
				if firstRunSetup then
					FusionHUD:UNIT_POWER(nil, "player", "ECLIPSE");
					firstRunSetup = false
				end
				FusionHUDClassBar.frame.eclipseFrame.arrowFrame:SetPoint("CENTER", FusionHUDClassBar.frame.eclipseFrame, "CENTER", (UnitPower("Player", 8)/100) * FusionHUDClassBar.width / 2.1, 0);
				if UnitPower("player", 8) == -100 then
					if FusionHUDClassBar.flashOnce == false then
						FusionHUD:EclipseFlash();
					end
					FusionHUDClassBar.frame.eclipseFrame.backgroundTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\One Count Fill Druid Lunar");
					FusionHUDClassBar.flashOnce = true;
				elseif UnitPower("player", 8) == 100 then
					if FusionHUDClassBar.flashOnce == false then
						FusionHUD:EclipseFlash();
					end
					FusionHUDClassBar.frame.eclipseFrame.backgroundTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\One Count Fill Druid Solar");
					FusionHUDClassBar.flashOnce = true;
				else
					FusionHUDClassBar.flashOnce = false;
				end
			else
				FusionHUDClassBar.frame:Hide()
			end
		end
	end
end

-- Minimap Button Functions (tooltips)
function FusionHUD:MinimapButtonOnEnter()
	GameTooltip:SetOwner(FusionHUDMinimapButtonFrame, "ANCHOR_TOPRIGHT");
	GameTooltip:ClearLines();
	GameTooltip:SetAlpha(1);
	if FusionHUDLockFrame:IsVisible() then
		GameTooltip:SetText("FusionHUD |cffff9933" .. GetAddOnMetadata("FusionHUD", "Version") .. "|r", 1, .9, 0,  1, 1);
		GameTooltip:AddLine("|cffff3333Please relock your bars using the FusionHUD Lock Button");
	else
		GameTooltip:SetText("FusionHUD |cffff9933" .. GetAddOnMetadata("FusionHUD", "Version") .. "|r", 1, .9, 0,  1, 1);
		GameTooltip:AddLine("|cff44ff44Click to open FusionHUD Options", 1,1,1,1,1);
	end
	GameTooltip:Show();
end

function FusionHUD:MinimapButtonOnLeave(...)
	GameTooltip:Hide();
end

--Sets global HUD transparency for context-sensitive transparency
function FusionHUD:Transparency()
	local localClass, englishClass = UnitClass("player");
	if FusionHUDModSettings.multiTransparency == false then
		FusionHUDMasterFrame:SetAlpha(FusionHUDModSettings.transparency);
	elseif UnitAffectingCombat("player") == 1 then
		FusionHUDMasterFrame:SetAlpha(FusionHUDModSettings.hiVis);
	elseif UnitDebuff("player", 1) ~= nil then
		FusionHUDMasterFrame:SetAlpha(FusionHUDModSettings.midVis);
	elseif UnitName("target") and UnitName("target") ~= "Unknown" then
		FusionHUDMasterFrame:SetAlpha(FusionHUDModSettings.midVis);
	elseif UnitHealth("player") ~= UnitHealthMax("player") then
		FusionHUDMasterFrame:SetAlpha(FusionHUDModSettings.midVis);
	elseif UnitPower("player")~= UnitPowerMax("player") then
		if englishClass == "WARRIOR" or englishClass == "DEATHKNIGHT" then
			if UnitPower("player") == 0 then
				FusionHUDMasterFrame:SetAlpha(FusionHUDModSettings.loVis);
			else
				FusionHUDMasterFrame:SetAlpha(FusionHUDModSettings.midVis);
			end
		else
			FusionHUDMasterFrame:SetAlpha(FusionHUDModSettings.midVis);
		end
	else
		FusionHUDMasterFrame:SetAlpha(FusionHUDModSettings.loVis);
	end
end
-------------------------------
-- Class Bar functions follow--
-------------------------------
function FusionHUD:BuildClassBarFrame()
	FusionHUDClassBar.barIndex = "Class";
	FusionHUDClassBar.frame = CreateFrame("Frame", nil, FusionHUDMasterFrame);
	FusionHUDClassBar.frame:SetPoint(FusionHUDClassBar.myPoint, "FusionHUDMasterFrame", FusionHUDClassBar.parentPoint, FusionHUDClassBar.offsetX, FusionHUDClassBar.offsetY);
	FusionHUDClassBar.frame:SetHeight(FusionHUDClassBar.height);
	FusionHUDClassBar.frame:SetWidth(FusionHUDClassBar.height * 6);
	FusionHUDClassBar.frame.backdropTexture = FusionHUDClassBar.frame:CreateTexture(nil, "BACKGROUND");
	FusionHUDClassBar.frame.backdropTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\whitebackdropbase", true);
	FusionHUDClassBar.frame.backdropTexture:ClearAllPoints();
	FusionHUDClassBar.frame.titleRegion = FusionHUDClassBar.frame:CreateTitleRegion();
	FusionHUDClassBar.frame.titleRegion:ClearAllPoints();
	if FusionHUDModSettings.classBarToggle then
		FusionHUDClassBar.frame:Show();
	else
		FusionHUDClassBar.frame:Hide();
	end
end

function FusionHUD:ClassSelector()
	local localizedClass, englishClass = UnitClass("player");
	local powerType, powerTypeString = UnitPowerType("player");
	if englishClass == "DEATHKNIGHT" then
		FusionHUD:BuildDKClassBar()
	elseif englishClass == "PALADIN" then
		FusionHUD:BuildPaladinClassBar()
	elseif englishClass == "WARLOCK" then
		FusionHUD:BuildWarlockClassBar()
	elseif englishClass == "ROGUE" then
		FusionHUD:BuildComboPointClassBar();
	elseif englishClass == "DRUID" then 
		FusionHUD:BuildEclipseBar();
		FusionHUDClassBar.flashOnce = true;
		FusionHUD:BuildComboPointClassBar();
		if FusionHUDModSettings.classBarToggle == true then
			if powerTypeString ~= "ENERGY" then
				FusionHUDClassBar.frame.comboFrame:Hide();
			else
				FusionHUDClassBar.frame.comboFrame:Show();
			end
			if englishClass == "DRUID" then
				local name, tex, tier, col, rank = GetTalentInfo(3, 21, false, false, nil)
				if GetShapeshiftForm(false) == 5 and rank == 0 then 
					FusionHUDClassBar.frame.eclipseFrame:Show()
				else
					FusionHUDClassBar.frame.eclipseFrame:Hide()
				end
			end
		end
	end
end

function FusionHUD:BuildComboPointClassBar()
	FusionHUDClassBar.frame.comboFrame = FusionHUDComboPointObject:New()
	FusionHUDClassBar.frame.comboFrame.text:SetText(GetComboPoints("player", "target"));
	FusionHUD:RegisterEvent("UNIT_COMBO_POINTS");
end

function FusionHUD:BuildEclipseBar()
	FusionHUDClassBar.frame.eclipseFrame = FusionHUDEclipseObject:New();
	FusionHUDClassBar.frame.eclipseFrame:Show();
	FusionHUDClassBar.frame.eclipseFrame.arrowFrame:SetPoint("CENTER", FusionHUDClassBar.frame.eclipseFrame, "CENTER", (UnitPower("Player", 8)/100) * FusionHUDClassBar.width / 1.9, 0);
	FusionHUD:RegisterEvent("UNIT_POWER");
	FusionHUD:RegisterEvent("UNIT_AURA");
	FusionHUD:RegisterEvent("UNIT_SHAPESHIFT_FORM");
	FusionHUD:UNIT_POWER(nil, "player", "ECLIPSE");
	FusionHUD:UNIT_AURA(nil, "player");
end

function FusionHUD:BuildDKClassBar()
	local i;
	FusionHUDClassBar.frame.runes = {};
	for i = 1,6 do
		FusionHUDClassBar.frame.runes[i] = FusionHUDRuneObject:New();
		FusionHUDClassBar.frame.runes[i].runeID = i;
		FusionHUDClassBar.frame.runes[i].texture:SetTexture(runeTextures[GetRuneType(i)]);
	end
	FusionHUDClassBar.frame.runes[1]:SetPoint("TOPLEFT", FusionHUDClassBar.frame, "TOPLEFT");
	FusionHUDClassBar.frame.runes[1]:SetPoint("BOTTOMLEFT", FusionHUDClassBar.frame, "BOTTOMLEFT");
	FusionHUDClassBar.frame.runes[2]:SetPoint("TOPLEFT", FusionHUDClassBar.frame.runes[1], "TOPRIGHT");
	FusionHUDClassBar.frame.runes[2]:SetPoint("BOTTOMLEFT", FusionHUDClassBar.frame.runes[1], "BOTTOMRIGHT");
	FusionHUDClassBar.frame.runes[5]:SetPoint("TOPLEFT", FusionHUDClassBar.frame.runes[2], "TOPRIGHT");
	FusionHUDClassBar.frame.runes[5]:SetPoint("BOTTOMLEFT", FusionHUDClassBar.frame.runes[2], "BOTTOMRIGHT");
	FusionHUDClassBar.frame.runes[6]:SetPoint("TOPLEFT", FusionHUDClassBar.frame.runes[5], "TOPRIGHT");
	FusionHUDClassBar.frame.runes[6]:SetPoint("BOTTOMLEFT", FusionHUDClassBar.frame.runes[5], "BOTTOMRIGHT");
	FusionHUDClassBar.frame.runes[3]:SetPoint("TOPLEFT", FusionHUDClassBar.frame.runes[6], "TOPRIGHT");
	FusionHUDClassBar.frame.runes[3]:SetPoint("BOTTOMLEFT", FusionHUDClassBar.frame.runes[6], "BOTTOMRIGHT");
	FusionHUDClassBar.frame.runes[4]:SetPoint("TOPLEFT", FusionHUDClassBar.frame.runes[3], "TOPRIGHT");
	FusionHUDClassBar.frame.runes[4]:SetPoint("BOTTOMLEFT", FusionHUDClassBar.frame.runes[3], "BOTTOMRIGHT");
	FusionHUD:RegisterEvent("RUNE_POWER_UPDATE");
	FusionHUD:RegisterEvent("RUNE_TYPE_UPDATE");
end

function FusionHUD:BuildPaladinClassBar()
	FusionHUDClassBar.frame.powerBar = FusionHUDThreeCountObject:New();
	FusionHUDClassBar.frame.powerBar.fillTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\Three Count Fill Paladin", false);
	if UnitPower("player", 9) == 0 then
		FusionHUDClassBar.frame.powerBar.fillTexture:SetWidth(1);
	else
		FusionHUDClassBar.frame.powerBar.fillTexture:SetWidth(FusionHUDClassBar.width / 3 * UnitPower("player", 9));
	end
	FusionHUDClassBar.frame.powerBar.fillTexture:SetTexCoord(0, UnitPower("player", 9)/3, 1, 0);
	FusionHUD:RegisterEvent("UNIT_POWER");
end

function FusionHUD:BuildWarlockClassBar()
	FusionHUDClassBar.frame.powerBar = FusionHUDThreeCountObject:New();
	FusionHUDClassBar.frame.powerBar.fillTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\Three Count Fill Warlock", false);
	if UnitPower("player", 7) == 0 then
		FusionHUDClassBar.frame.powerBar.fillTexture:SetWidth(1);
	else
		FusionHUDClassBar.frame.powerBar.fillTexture:SetWidth(FusionHUDClassBar.width / 3 * UnitPower("player", 7));
	end 
	FusionHUDClassBar.frame.powerBar.fillTexture:SetTexCoord(0, UnitPower("player", 7)/3, 0, 1);
	FusionHUD:RegisterEvent("UNIT_POWER");
end
--Runes
function FusionHUD:RUNE_POWER_UPDATE(event, ...)
	local runeID = ...;
	local start, duration, runeReady = GetRuneCooldown(runeID);
	if runeReady == false then
		FusionHUDClassBar.frame.runes[runeID].texture:SetVertexColor(0.1,0.1,0.1);
		FusionHUDClassBar.frame.runes[runeID].cooldownFrame:Show();
		FusionHUDClassBar.frame.runes[runeID].cooldownFrame:SetScript('OnUpdate', function() FusionHUD:RuneCooldown(runeID) end);
	else
		FusionHUDClassBar.frame.runes[runeID].texture:SetVertexColor(1,1,1);
		FusionHUDClassBar.frame.runes[runeID].cooldownFrame:SetScript('OnUpdate', nil);
		FusionHUDClassBar.frame.runes[runeID].cooldownFrame:Hide();
	end
end

function FusionHUD:RUNE_TYPE_UPDATE(event, ...)
	local runeID = ...;
	local runeType = GetRuneType(runeID);
	FusionHUDClassBar.frame.runes[runeID].texture:SetTexture(runeTextures[runeType], false);
end

--Holy Power, Soul Shards, Eclipse Energy
function FusionHUD:UNIT_POWER(event, ...)
	local unit, powerType = ...;
	local localClass, englishClass = UnitClass("player");
	if unit == "player" then
		if powerType == "HOLY_POWER" and englishClass == "PALADIN" then
			if UnitPower("player", 9) == 0 then
				FusionHUDClassBar.frame.powerBar.fillTexture:SetWidth(1);
			else
				FusionHUDClassBar.frame.powerBar.fillTexture:SetWidth(FusionHUDClassBar.width / 3 * UnitPower("player", 9));
				FusionHUDClassBar.frame.powerBar.fillTexture:SetTexCoord(0, UnitPower("player", 9)/3, 0, 1);
			end
		elseif powerType == "SOUL_SHARDS" and englishClass == "WARLOCK" then
			if UnitPower("player", 7) == 0 then
				FusionHUDClassBar.frame.powerBar.fillTexture:SetWidth(1);
			else
				FusionHUDClassBar.frame.powerBar.fillTexture:SetWidth(FusionHUDClassBar.width / 3 * UnitPower("player", 7));
				FusionHUDClassBar.frame.powerBar.fillTexture:SetTexCoord(0, UnitPower("player", 7)/3, 0, 1);
			end				
		elseif powerType == "ECLIPSE" and englishClass == "DRUID" then
--			FusionHUD:Print(UnitPower("Player", 8));
			if GetEclipseDirection() == "none" then
				FusionHUDClassBar.frame.eclipseFrame.arrowFrame.texture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\Eclipse Neutral", false);
			elseif GetEclipseDirection() == "moon" then
				FusionHUDClassBar.frame.eclipseFrame.arrowFrame.texture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\Eclipse Arrow", false);
				FusionHUDClassBar.frame.eclipseFrame.arrowFrame.texture:SetTexCoord(1,0,0,1);
			elseif GetEclipseDirection() == "sun" then
				FusionHUDClassBar.frame.eclipseFrame.arrowFrame.texture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\Eclipse Arrow", false);
				FusionHUDClassBar.frame.eclipseFrame.arrowFrame.texture:SetTexCoord(0,1,0,1);
			end
		end		
	end	
end

function FusionHUD:UNIT_AURA(event, auraTarget)
	if auraTarget == "player" then
		local eclipseLunar, eclipseSolar, name, i = false, false, "", 1;
		while name ~= nil do
			name = UnitBuff("player", i, "PLAYER");
			if name == "Eclipse (Solar)" then
				eclipseSolar = true
				break
			elseif name == "Eclipse (Lunar)" then
				eclipseLunar = true
				break
			end
			i = i + 1;
		end
		if eclipseLunar == false and eclipseSolar == false then	
			FusionHUDClassBar.frame.eclipseFrame.backgroundTexture:SetTexture("Interface\\AddOns\\FusionHUD\\Graphics\\One Count Fill Druid");
		end	 
	end
end

function FusionHUD:UNIT_SHAPESHIFT_FORM()
	FusionHUD:UNIT_AURA(nil, "player");
end

function FusionHUD:EclipseFlash()
	FusionHUDClassBar.frame.eclipseFrame.flashFrame.texture.animGroup.anim1:SetChange(-1);
	FusionHUDClassBar.frame.eclipseFrame.flashFrame.texture.animGroup.anim1:SetStartDelay(0.1)
	FusionHUDClassBar.frame.eclipseFrame.flashFrame.texture.animGroup.anim1:SetDuration(.65);
	FusionHUDClassBar.frame.eclipseFrame.flashFrame.texture.animGroup:Play();
end

function FusionHUD:RuneCooldown(runeID)
	local nextUpdateClock =  GetTime();
	local start, duration, runeReady = GetRuneCooldown(runeID);
	if nextUpdateClock - FusionHUDClassBar.frame.runes[runeID].cooldownFrame.lastUpdateClock > 0.2 then
		FusionHUDClassBar.frame.runes[runeID].cooldownFrame.lastUpdateClock = nextUpdateClock
		if runeReady == false and math.ceil(duration - (nextUpdateClock - start)) >= 0 and math.ceil(duration - (nextUpdateClock - start)) <= duration then
			FusionHUDClassBar.frame.runes[runeID].cooldownFrame.text:SetFont("Interface\\AddOns\\FusionHUD\\Fonts\\DroidSans.ttf", math.floor(FusionHUDClassBar.frame:GetHeight() * .6), "OUTLINE");
			FusionHUDClassBar.frame.runes[runeID].cooldownFrame.text:SetText(math.ceil(duration-(nextUpdateClock-start)));
			FusionHUDClassBar.frame.runes[runeID].cooldownFrame.text:SetVertexColor(1,1,1,1);
		else
			FusionHUDClassBar.frame.runes[runeID].cooldownFrame.text:SetVertexColor(1,1,1,0);
		end
	end
end

--Combo Points
function FusionHUD:UNIT_COMBO_POINTS(event, ...)
	FusionHUDClassBar.frame.comboFrame.text:SetFont("Interface\\AddOns\\FusionHUD\\Fonts\\DroidSans.ttf", math.floor(FusionHUDClassBar.frame:GetHeight() * .8), "OUTLINE");
	FusionHUDClassBar.frame.comboFrame.text:SetText(GetComboPoints("player", "target"));
end

---------------------------
--End Class Bar functions--
---------------------------

function FusionHUD:PLAYER_TARGET_CHANGED(event, ...)
	table.foreach(FusionHUDBars, 	function(k,v) 
											FusionHUDBars[k]:Update(true) 
										end);
end

--Handles bar unlocking and locking depending on HUD state
function FusionHUD:LockHandler(self)
	if self.barIndex ==  nil then
		return
	end
	if self.draggable == true then
		self.frame.titleRegion:SetAllPoints(self.frame);
		self.frame:SetBackdrop({bgFile = "Interface\\AddOns\\FusionHUD\\Graphics\\whitebackdropbase", tile = true, tilesize = self.width});
		self.frame:SetBackdropColor(0.8, 0.8, 0.8, 1);
		self.frame:Show();
		self.frame:SetAlpha(1);
		self.frame:EnableMouse(true);
		self.frame:SetMovable(true);
		if self.textIsDocked ~= nil and self.textIsDocked == false then
			self.frame.textFrame.titleRegion:SetAllPoints(self.frame.textFrame);
			self.frame.textFrame:SetBackdrop({bgFile = "Interface\\AddOns\\FusionHUD\\Graphics\\whitebackdropbase", tile = true, tilesize = 150});
			self.frame.textFrame:EnableMouse(true);
			self.frame.textFrame:SetMovable(true);
		end
		return
	else
		self.myPoint, self.parentFrame, self.parentPoint, self.offsetX, self.offsetY = self.frame:GetPoint();
		self.frame.titleRegion:ClearAllPoints();
		self.frame:SetBackdrop({nil});
		self.frame:EnableMouse(false);
		self.frame:SetMovable(false);
		FusionHUDLockFrame:Hide();
		InterfaceOptionsFrame_OpenToCategory(FusionHUD.optionsFrame);
		if self.textIsDocked ~= nil and self.textIsDocked == false then
			self.textPoint, self.textParent, self.textParentPoint, self.textOffsetX, self.textOffsetY = self.frame.textFrame:GetPoint();
			self.textParentName = tostring(self.textParent);
			self.frame.textFrame.titleRegion:ClearAllPoints();
			self.frame.textFrame:SetBackdrop({nil});
			self.frame.textFrame:EnableMouse(false);
			self.frame.textFrame:SetMovable(false);
		elseif self.textIsDocked ~= nil then
			self.frame.textFrame:SetPoint("TOP", self.frame, "BOTTOM");
			self.frame.textFrame.titleRegion:ClearAllPoints();
			self.frame.textFrame.backdropTexture:ClearAllPoints();
			self.frame.textFrame:EnableMouse(false);
			self.frame.textFrame:SetMovable(false);
		end
	end
end
