local L = LibStub("AceLocale-3.0"):GetLocale("FlightHUD", false)

-- Config options
FlightHUDConfig = { 
  type='group',
  name = L["FlightHUD"],
  desc = L["A Heads Up Display (HUD) that shows information while flying or riding"],
  icon = [[Interface\Addons\FlightHUD\icon]],
  args = {
    General = {
      order = 1,
      type = "group",
      name = L["General Options"],
      desc = L["General Options"],
      args = {
        RefreshRate = {
          order = 1,
          type = 'range',
          name = L["Refresh Interval"],
          desc = L["Refresh the HUD every X seconds. (Lower values might be CPU intensive)"],
          get = function ()
            return FlightHUD.db.profile.RefreshRate
          end,
          set = function (i, arg)
            FlightHUD.db.profile.RefreshRate = arg
          end,
          min = 0,
          max = 1,
          step = 0.01,
        },
        HUDAlpha = {
          order = 2,
          type = 'range',
          name = L["HUD Alpha"],
          desc = L["The transparency value of the HUD"],
          get = function ()
            return FlightHUD.db.profile.HUDAlpha
          end,
          set = function (i, arg)
            FlightHUD.db.profile.HUDAlpha = arg
            FlightHUD.CompassHeadingImage1:SetAlpha(arg)
            FlightHUD.CompassHeadingImage2:SetAlpha(arg)
            FlightHUD.PitchImage:SetAlpha(arg)
            FlightHUD.ArtificialHorizonImage:SetAlpha(arg)
            FlightHUD.HeadingCenterImage:SetAlpha(arg)
            FlightHUD.HeadingText:SetAlpha(arg)
            FlightHUD.PitchText:SetAlpha(arg)
            FlightHUD.CoordinatesText:SetAlpha(arg)
            FlightHUD.SpeedText:SetAlpha(arg)
          end,
          min = 0,
          max = 1,
          step = 0.05,
        },
        HUDBGAlpha = {
          order = 3,
          type = 'range',
          name = L["HUD BG Alpha"],
          desc = L["The transparency value of the HUD background"],
          get = function ()
            return FlightHUD.db.profile.HUDBGAlpha
          end,
          set = function (i, arg)
            FlightHUD.db.profile.HUDBGAlpha = arg
            FlightHUD.timage:SetAlpha(arg)
          end,
          min = 0,
          max = 1,
          step = 0.05,
        },
        spacer11 = {
          order = 4,
          type = "description",
          name = "",
        },
        LockPosition = {
          order = 5,
          type = 'toggle',
          name = L["Lock"],
          desc = L["Lock the position of the HUD"],
          get = function ()
            return FlightHUD.db.profile.LockPosition
          end,
          set = function (i, arg)
            FlightHUD.db.profile.LockPosition = arg
          end
        },
        DisableAddon = {
          order = 6,
          type = 'toggle',
          name = L["Disable"],
          desc = L["Completely disable the addon."],
          get = function ()
            return FlightHUD.db.profile.DisableAddon
          end,
          set = function (i, arg)
            FlightHUD.db.profile.DisableAddon = arg
            FlightHUD:EnableAddon ()
          end
        },
      },
    },
    ShowEvents = {
      order = 2,
      type = "group",
      name = L["Show Events"],
      desc = L["Events which dictate when the HUD and its elements are shown."],
      args = {
        spacer21 = {
          order = 1,
          type = "description",
          name = L["When to show the HUD"],
        },
        ShowWhenFlying = {
          order = 2,
          type = 'toggle',
          name = L["Flying"],
          desc = L["Show the HUD when mounted on a flying mount"],
          disabled = function ()
            return FlightHUD.db.profile.ShowAlways
          end,
          get = function ()
            return FlightHUD.db.profile.ShowWhenFlying
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowWhenFlying = arg
            FlightHUD:UNIT_AURA ()
          end
        },
        ShowWhenMounted = {
          order = 3,
          type = 'toggle',
          name = L["Mounted"],
          desc = L["Show the HUD when mounted on a ground mount"],
          disabled = function ()
            return FlightHUD.db.profile.ShowAlways
          end,
          get = function ()
            return FlightHUD.db.profile.ShowWhenMounted
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowWhenMounted = arg
            FlightHUD:UNIT_AURA ()
          end
        },
        ShowWhenSwimming = {
          order = 4,
          type = 'toggle',
          name = L["Swimming"],
          desc = L["Show the HUD when swimming"],
          disabled = function ()
            return FlightHUD.db.profile.ShowAlways
          end,
          get = function ()
            return FlightHUD.db.profile.ShowWhenSwimming
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowWhenSwimming = arg
            if arg then
              FlightHUD.DummyFrame:SetScript("OnUpdate", FlightHUD.DummyOnUpdate)
            else
              FlightHUD.DummyFrame:SetScript("OnUpdate", nil)
            end
            FlightHUD:UNIT_AURA ()
          end
        },
        ShowAlways = {
          order = 5,
          type = 'toggle',
          name = L["Always"],
          desc = L["Always show the HUD"],
          get = function ()
            return FlightHUD.db.profile.ShowAlways
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowAlways = arg
            FlightHUD:UNIT_AURA ()
          end
        },
        spacer22 = {
          order = 6,
          type = "description",
          name = L["When to show pitch"],
        },
        ShowPitchWhenFlying = {
          order = 7,
          type = 'toggle',
          name = L["Flying"],
          desc = L["Show pitch when mounted on a flying mount"],
          disabled = function ()
            return FlightHUD.db.profile.ShowPitchAlways
          end,
          get = function ()
            return FlightHUD.db.profile.ShowPitchWhenFlying
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowPitchWhenFlying = arg
            FlightHUD:UNIT_AURA ()
          end
        },
        ShowPitchWhenMounted = {
          order = 8,
          type = 'toggle',
          name = L["Mounted"],
          desc = L["Show pitch when mounted on a ground mount"],
          disabled = function ()
            return FlightHUD.db.profile.ShowPitchAlways
          end,
          get = function ()
            return FlightHUD.db.profile.ShowPitchWhenMounted
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowPitchWhenMounted = arg
            FlightHUD:UNIT_AURA ()
          end
        },
        ShowPitchWhenSwimming = {
          order = 9,
          type = 'toggle',
          name = L["Swimming"],
          desc = L["Show pitch when swimming"],
          disabled = function ()
            return FlightHUD.db.profile.ShowPitchAlways
          end,
          get = function ()
            return FlightHUD.db.profile.ShowPitchWhenSwimming
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowPitchWhenSwimming = arg
            FlightHUD:UNIT_AURA ()
          end
        },
        ShowPitchAlways = {
          order = 10,
          type = 'toggle',
          name = L["Always"],
          desc = L["Always show pitch"],
          get = function ()
            return FlightHUD.db.profile.ShowPitchAlways
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowPitchAlways = arg
            FlightHUD:UNIT_AURA ()
          end
        },
        spacer23 = {
          order = 11,
          type = "description",
          name = L["When to show compass"],
        },
        ShowCompassWhenFlying = {
          order = 12,
          type = 'toggle',
          name = L["Flying"],
          desc = L["Show compass when mounted on a flying mount"],
          disabled = function ()
            return FlightHUD.db.profile.ShowCompassAlways
          end,
          get = function ()
            return FlightHUD.db.profile.ShowCompassWhenFlying
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowCompassWhenFlying = arg
            FlightHUD:UNIT_AURA ()
          end
        },
        ShowCompassWhenMounted = {
          order = 13,
          type = 'toggle',
          name = L["Mounted"],
          desc = L["Show compass when mounted on a ground mount"],
          disabled = function ()
            return FlightHUD.db.profile.ShowCompassAlways
          end,
          get = function ()
            return FlightHUD.db.profile.ShowCompassWhenMounted
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowCompassWhenMounted = arg
            FlightHUD:UNIT_AURA ()
          end
        },
        ShowCompassWhenSwimming = {
          order = 14,
          type = 'toggle',
          name = L["Swimming"],
          desc = L["Always show compass"],
          disabled = function ()
            return FlightHUD.db.profile.ShowCompassAlways
          end,
          get = function ()
            return FlightHUD.db.profile.ShowCompassWhenSwimming
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowCompassWhenSwimming = arg
            FlightHUD:UNIT_AURA ()
          end
        },
        ShowCompassAlways = {
          order = 15,
          type = 'toggle',
          name = L["Always"],
          desc = L["Always show compass"],
          get = function ()
            return FlightHUD.db.profile.ShowCompassAlways
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowCompassAlways = arg
            FlightHUD:UNIT_AURA ()
          end
        },
      },
    },
    SpeedVars = {
      order = 3,
      type = "group",
      name = L["Speed Controls"],
      desc = L["Control how speed is displayed."],
      args = {
        SpeedType = {
          order = 1,
          type = 'select',
          name = L["Speed display"],
          desc = L["Show speed as yards per second or percentage."],
          get = function ()
            return FlightHUD.db.profile.SpeedType
          end,
          set = function (i, arg)
            FlightHUD.db.profile.SpeedType = arg
          end,
          disabled = function ()
            return not FlightHUD.db.profile.ShowSpeedText
          end,
          values = {
            BOTTOM = L["Percentage"],
            LEFT = L["Yards per second"],
            RIGHT = L["Both"],
          },
        },
        WhichSpeedType = {
          order = 2,
          type = 'select',
          name = L["Which speed"],
          desc = L["Show speed as true speed or horizontal speed."],
          get = function ()
            return FlightHUD.db.profile.WhichSpeedType
          end,
          set = function (i, arg)
            FlightHUD.db.profile.WhichSpeedType = arg
          end,
          disabled = function ()
            return not FlightHUD.db.profile.ShowSpeedText
          end,
          values = {
            BOTTOM = L["True speed"],
            LEFT = L["Horizontal speed"],
            RIGHT = L["Both"],
          },
        },
        SpeedPrecision = {
          order = 3,
          type = 'range',
          name = L["Speed Precision"],
          desc = L["The number of decimal points to display for speed."],
          get = function ()
            return FlightHUD.db.profile.SpeedPrecision
          end,
          set = function (i, arg)
            FlightHUD.db.profile.SpeedPrecision = arg
          end,
          min = 0,
          max = 2,
          step = 1,
        },
        spacer31 = {
          order = 4,
          type = "description",
          name = "",
        },
        ShowSpeedPrefix = {
          order = 5,
          type = 'toggle',
          name = L["Speed Prefix Text"],
          desc = L["Prepend a prefix to denote the speed type ([H]orizontal or [T]rue)"],
          get = function ()
            return FlightHUD.db.profile.ShowSpeedPrefix
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowSpeedPrefix = arg
          end
        },
      },
    },
    Scaling = {
      order = 4,
      type = "group",
      name = L["Scaling"],
      desc = L["Options for scaling the HUD and its elements."],
      args = {
        FrameScale = {
          order = 1,
          type = 'range',
          name = L["Frame Scale"],
          desc = L["Scale the HUD frame"],
          get = function ()
            return FlightHUD.db.profile.FrameScale
          end,
          set = function (i, arg)
            FlightHUD.db.profile.FrameScale = arg
            FlightHUD.FlightHUDFrame:SetScale(arg)
          end,
          min = 0.1,
          max = 2,
          step = 0.01,
        },
        PitchGraphicsScale = {
          order = 2,
          type = 'range',
          name = L["Pitch Graphics Scale"],
          desc = L["Scale the HUD pitch graphic"],
          get = function ()
            return FlightHUD.db.profile.PitchGraphicsScale
          end,
          set = function (i, arg)
            FlightHUD.db.profile.PitchGraphicsScale = arg
          end,
          min = 0,
          max = 20,
          step = 0.5,
        },
        FontScale = {
          order = 3,
          type = 'range',
          name = L["Font Scale"],
          desc = L["Scale the HUD text fonts"],
          get = function ()
            return FlightHUD.db.profile.FontScale
          end,
          set = function (i, arg)
            FlightHUD.db.profile.FontScale = arg
            local font = FlightHUD.PitchText:GetFont()
            FlightHUD.PitchText:SetFont(font, arg)
            FlightHUD.HeadingText:SetFont(font, arg)
            FlightHUD.CoordinatesText:SetFont(font, arg)
            FlightHUD.SpeedText:SetFont(font, arg)
          end,
          min = 6,
          max = 30,
          step = 0.5,
        },
      },
    },
    TextOptions = {
      order = 5,
      type = "group",
      name = L["Text Options"],
      desc = L["Toggle the display of certain texts on and off."],
      args = {
        ShowHeadingText = {
          order = 1,
          type = 'toggle',
          name = L["Heading text"],
          desc = L["Show the exact heading text in the HUD"],
          get = function ()
            return FlightHUD.db.profile.ShowHeadingText
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowHeadingText = arg
            if (arg) then
              FlightHUD.HeadingText:Show()
            else
              FlightHUD.HeadingText:Hide()
            end
          end
        },
        HeadingTextColor = {
          order = 2,
          type = 'color',
          name = L["Heading Text Color"],
          desc = L["The color of the heading text"],
          disabled = function ()
            return not FlightHUD.db.profile.HeadingTextColor
          end,
          get = function ()
            return unpack (FlightHUD.db.profile.HeadingTextColor)
          end,
          set = function (i, r, g, b, a)
            FlightHUD.db.profile.HeadingTextColor = {r, g, b, a}
            FlightHUD.HeadingText:SetTextColor (r, g, b, a)
          end,
          hasAlpha = true,
        },
        ShowPitchText = {
          order = 3,
          type = 'toggle',
          name = L["Pitch text"],
          desc = L["Show the exact pitch text in the HUD"],
          get = function ()
            return FlightHUD.db.profile.ShowPitchText
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowPitchText = arg
            if (arg) then
              FlightHUD.PitchText:Show()
            else
              FlightHUD.PitchText:Hide()
            end
          end
        },
        PitchTextColor = {
          order = 4,
          type = 'color',
          name = L["Pitch Text Color"],
          desc = L["The color of the pitch text"],
          disabled = function ()
            return not FlightHUD.db.profile.PitchTextColor
          end,
          get = function ()
            return unpack (FlightHUD.db.profile.PitchTextColor)
          end,
          set = function (i, r, g, b, a)
            FlightHUD.db.profile.PitchTextColor = {r, g, b, a}
            FlightHUD.PitchText:SetTextColor (r, g, b, a)
          end,
          hasAlpha = true,
        },
        ShowCoordinatesText = {
          order = 5,
          type = 'toggle',
          name = L["Map coordinates text"],
          desc = L["Show the map coordinates text in the HUD"],
          get = function ()
            return FlightHUD.db.profile.ShowCoordinatesText
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowCoordinatesText = arg
            if (arg) then
              FlightHUD.CoordinatesText:Show()
            else
              FlightHUD.CoordinatesText:Hide()
            end
          end
        },
        CoordinatesTextColor = {
          order = 6,
          type = 'color',
          name = L["Coordinates Text Color"],
          desc = L["The color of the coordinates text"],
          disabled = function ()
            return not FlightHUD.db.profile.CoordinatesTextColor
          end,
          get = function ()
            return unpack (FlightHUD.db.profile.CoordinatesTextColor)
          end,
          set = function (i, r, g, b, a)
            FlightHUD.db.profile.CoordinatesTextColor = {r, g, b, a}
            FlightHUD.CoordinatesText:SetTextColor (r, g, b, a)
          end,
          hasAlpha = true,
        },
        ShowSpeedText = {
          order = 7,
          type = 'toggle',
          name = L["Player speed text"],
          desc = L["Show the player's speed text in the HUD"],
          get = function ()
            return FlightHUD.db.profile.ShowSpeedText
          end,
          set = function (i, arg)
            FlightHUD.db.profile.ShowSpeedText = arg
            if (arg) then
              FlightHUD.SpeedText:Show()
            else
              FlightHUD.SpeedText:Hide()
            end
          end
        },
        SpeedTextColor = {
          order = 8,
          type = 'color',
          name = L["Speed Text Color"],
          desc = L["The color of the speed text"],
          disabled = function ()
            return not FlightHUD.db.profile.SpeedTextColor
          end,
          get = function ()
            return unpack (FlightHUD.db.profile.SpeedTextColor)
          end,
          set = function (i, r, g, b, a)
            FlightHUD.db.profile.SpeedTextColor = {r, g, b, a}
            FlightHUD.SpeedText:SetTextColor (r, g, b, a)
          end,
          hasAlpha = true,
        },
        ResetColors = {
          order = 9,
          type = "execute",
          confirm = true,
          confirmText = L["Really reset all text colors?"],
          name = L["Reset all text colors"],
          desc = L["Resets all text colors back to green"],
          func = function ()
            FlightHUD.db.profile.HeadingTextColor = {0, 1, 0, 1}
            FlightHUD.db.profile.PitchTextColor = {0, 1, 0, 1}
            FlightHUD.db.profile.CoordinatesTextColor = {0, 1, 0, 1}
            FlightHUD.db.profile.SpeedTextColor = {0, 1, 0, 1}
            FlightHUD.HeadingText:SetTextColor (0, 1, 0, 1)
            FlightHUD.PitchText:SetTextColor (0, 1, 0, 1)
            FlightHUD.CoordinatesText:SetTextColor (0, 1, 0, 1)
            FlightHUD.SpeedText:SetTextColor (0, 1, 0, 1)
          end
        },
      },
    },
    WaypointOptions = {
      order = 6,
      type = "group",
      name = L["Waypoints"],
      desc = L["Waypoint Options"],
      args = {
        WaypointDisplay = {
          order = 1,
          type = 'select',
          name = L["Waypoint Display"],
          desc = L["Choose to display waypoints in an ellipse or a rectangle."],
          get = function ()
            return FlightHUD.db.profile.WaypointDisplay
          end,
          set = function (i, arg)
            FlightHUD.db.profile.WaypointDisplay = "BOTTOM"
            FlightHUD:UNIT_AURA ()
          end,
          values = {
            BOTTOM = L["Ellipse"],
            LEFT = L["Rectangle"],
          },
        },
        spacer61 = {
          order = 2,
          type = "description",
          name = "",
        },
        WorldmapModifier = {
          order = 3,
          type = "select",
          name = L["Worldmap modifier"],
          desc = L["Set the modifier used when right-clicking on the world map to create a waypoint"],
          get = function ()
            return FlightHUD.db.profile.WorldmapModifier
          end,
          set = function (i, arg)
            FlightHUD.db.profile.WorldmapModifier = arg
          end,
          values = {
            ["A"] = L["Alt"],
            ["C"] = L["Ctrl"],
            ["S"] = L["Shift"],
            ["AC"] = L["Alt-Ctrl"],
            ["AS"] = L["Alt-Shift"],
            ["CS"] = L["Ctrl-Shift"],
            ["ACS"] = L["Alt-Ctrl-Shift"],
          },
        },
        WorldmapPOIModifier = {
          order = 4,
          type = "select",
          name = L["Worldmap POI modifier"],
          desc = L["Set the modifier used when right-clicking on World Map POI's to create a waypoint"],
          get = function ()
            return FlightHUD.db.profile.WorldmapPOIModifier
          end,
          set = function (i, arg)
            FlightHUD.db.profile.WorldmapPOIModifier = arg
          end,
          values = {
            ["A"] = L["Alt"],
            ["C"] = L["Ctrl"],
            ["S"] = L["Shift"],
            ["AC"] = L["Alt-Ctrl"],
            ["AS"] = L["Alt-Shift"],
            ["CS"] = L["Ctrl-Shift"],
            ["ACS"] = L["Alt-Ctrl-Shift"],
          },
        },
        RemoveWaypointDistance = {
          order = 5,
          type = 'range',
          name = L["Waypoint distance"],
          desc = L["The distance from the waypoint before it is removed if it's not sticky"],
          get = function ()
            return FlightHUD.db.profile.RemoveWaypointDistance
          end,
          set = function (i, arg)
            FlightHUD.db.profile.RemoveWaypointDistance = arg
          end,
          min = 1,
          max = 100,
          step = 1,
        },
        WaypointETAArc = {
          order = 6,
          type = 'range',
          name = L["Waypoint ETA Arc"],
          desc = L["The arc in degrees in front of the character required for a waypoint to show ETA text."],
          get = function ()
            return FlightHUD.db.profile.WaypointETAArc
          end,
          set = function (i, arg)
            FlightHUD.db.profile.WaypointETAArc = arg
            local half = arg / 2
            FlightHUD.db.profile.etaArcL = 360 - half
            FlightHUD.db.profile.etaArcR = half
          end,
          min = 1,
          max = 180,
          step = 1,
        },
        spacer62 = {
          order = 7,
          type = "description",
          name = "",
        },
        QuestHelper = {
          order = 8,
          type = 'toggle',
          name = L["QuestHelper Integration"],
          desc = L["Make the QuestHelper default quest always appear as a waypoint in the HUD"],
          get = function ()
            return FlightHUD.db.profile.QuestHelper
          end,
          set = function (i, arg)
            FlightHUD.db.profile.QuestHelper = arg
            if arg == true then
              FlightHUD.SetupQuestHelperCallback ()
            else
              FlightHUD.RemoveQuestHelperCallback ()
            end
          end,
          disabled = function ()
            if QuestHelper then
              return false
            else
              return true
            end
          end,
        },
        WorldMapPOI = {
          order = 9,
          type = 'toggle',
          name = L["Worldmap POI Integration"],
          desc = L["Allow clicking on the Blizzard quest helper to set waypoints in the HUD"],
          get = function ()
            return FlightHUD.db.profile.WorldMapPOI
          end,
          set = function (i, arg)
            FlightHUD.db.profile.WorldMapPOI = arg
          end
        },
        spacer63 = {
          order = 10,
          type = "description",
          name = "",
        },
        WaypointNotify = {
          order = 11,
          type = 'toggle',
          name = L["Waypoint Arrival Notification"],
          desc = L["Announce the arrival for a waypoint with a sound file"],
          get = function ()
            return FlightHUD.db.profile.WaypointNotify
          end,
          set = function (i, arg)
            FlightHUD.db.profile.WaypointNotify = arg
          end
        },
        spacer63 = {
          order = 12,
          type = "description",
          name = "",
        },
        WaypointNotifySound = {
          order = 13,
          type = 'select',
          name = L["Notification Sound"],
          desc = L["The sound that will play upon arrival at a waypoint."],
          get = function ()
            return FlightHUD.db.profile.WaypointNotifySound
          end,
          set = function (i, arg)
            FlightHUD.db.profile.WaypointNotifySound = arg
          end,
          disabled = function ()
            return not FlightHUD.db.profile.WaypointNotify
          end,
          values = {
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsDwarfFemale.wav"] = L["Dwarf Female Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsDwarfMale.wav"] = L["Dwarf Male Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsGnomeFemale.wav"] = L["Gnome Female Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsGnomeMale.wav"] = L["Gnome Male Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsHumanFemale.wav"] = L["Human Female Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsHumanMale.wav"] = L["Human Male Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsNightElfFemale.wav"] = L["Night Elf Female Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsNightElfMale.wav"] = L["Night Elf Male Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsOrcFemale.wav"] = L["Orc Female Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsOrcMale.wav"] = L["Orc Male Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsTaurenFemale.wav"] = L["Tauren Female Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsTaurenMale.wav"] = L["Tauren Male Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsTrollFemale.wav"] = L["Troll Female Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsTrollMale.wav"] = L["Troll Male Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsUndeadFemale.wav"] = L["Undead Female Roar"],
            ["Sound\\Character\\PlayerRoars\\CharacterRoarsUndeadMale.wav"] = L["Undead Male Roar"],
            ["Sound\\Spells\\PVPFlagTaken.wav"] = L["PVP Flag Taken"],
            ["Sound\\interface\\RaidWarning.wav"] = L["Raid Warning"],
            ["Sound\\interface\\ReadyCheck.wav"] = L["Ready Check"],
            ["Sound\\Creature\\HoodWolf\\HoodWolfTransformPlayer01.wav"] = L["Run away little girl"],
            ["Sound\\Creature\\ThrallCoT\\CAV_Thrall_Aggro01.wav"] = L["Thrall"],
          },
        },
        spacer64 = {
          order = 14,
          type = "description",
          name = "",
        },
        WaypointTextColor = {
          order = 15,
          type = 'color',
          name = L["Waypoint Text Color"],
          desc = L["The color of the waypoint text"],
          get = function ()
            return unpack (FlightHUD.db.profile.WaypointTextColor)
          end,
          set = function (i, r, g, b, a)
            FlightHUD.db.profile.WaypointTextColor = {r, g, b, a}
            for frameid, waypointframe in pairs(FlightHUD.waypointframes) do
              waypointframe.TitleText:SetTextColor (unpack (FlightHUD.db.profile.WaypointTextColor))
            end
          end,
          hasAlpha = true,
        },
        WaypointTextShadowColor = {
          order = 16,
          type = 'color',
          name = L["Waypoint Text Drop Shadow Color"],
          desc = L["The color of the waypoint text drop shadow"],
          get = function ()
            return unpack (FlightHUD.db.profile.WaypointTextShadowColor)
          end,
          set = function (i, r, g, b, a)
            FlightHUD.db.profile.WaypointTextShadowColor = {r, g, b, a}
            for frameid, waypointframe in pairs(FlightHUD.waypointframes) do
              waypointframe.TitleText:SetShadowColor (unpack (FlightHUD.db.profile.WaypointTextShadowColor))
            end
          end,
          hasAlpha = true,
        },
      },
    },
    ResetOptions = {
      order = 7,
      type = "group",
      name = L["Reset"],
      desc = L["Options for resetting all other options."],
      args = {
        RemoveTransientWaypoints = {
          order = 1,
          type = "execute",
          confirm = true,
          confirmText = L["Really remove all non-sticky waypoints?"],
          name = L["Remove Non Sticky Waypoints"],
          desc = L["Remove all non-sticky waypoints"],
          func = function ()
            FlightHUD.RemoveAllWaypoints()
          end
        },
        spacer71 = {
          order = 2,
          type = "description",
          name = "",
        },
        RemovePersistentWaypoints = {
          order = 3,
          type = "execute",
          confirm = true,
          confirmText = L["Really remove all sticky waypoints?"],
          name = L["Remove Sticky Waypoints"],
          desc = L["Remove all sticky waypoints"],
          func = function ()
            FlightHUD.RemoveAllWaypoints(1)
          end
        },
        spacer72 = {
          order = 4,
          type = "description",
          name = "",
        },
        ResetPosition = {
          order = 5,
          type = "execute",
          confirm = true,
          confirmText = L["Really reset the position of the HUD?"],
          name = L["Reset Position"],
          desc = L["Reset the position of the HUD back to the center of the screen"],
          func = function ()
            FlightHUD.ResetPosition()
          end
        },
        spacer73 = {
          order = 6,
          type = "description",
          name = "",
        },
        ResetAll = {
          order = 7,
          type = "execute",
          confirm = true,
          confirmText = L["Really reset all FlightHUD settings?"],
          name = L["Reset all settings"],
          desc = L["Resets all FlightHUD settings back to the default"],
          func = function ()
            FlightHUD.ResetAll()
          end
        },
      },
    },
    --[===[@debug@
    DebugOptions = {
      order = 8,
      type = "group",
      name = L["Debug"],
      desc = L["Options for debugging various aspects of the addon."],
      args = {
        EnableDebug = {
          order = 1,
          type = 'toggle',
          name = L["Debug"],
          desc = L["Set the debug flag"],
          get = function ()
            return FlightHUD.db.profile.EnableDebug
          end,
          set = function (i, arg)
            if BugGrabber then
              FlightHUD.db.profile.EnableDebug = arg
            else
              print ("Cannot enable debugging. BugGrabber addon not available.")
            end
          end
        },
      },
    },
    --@end-debug@]===]
  },
}

-- Config defaults
FlightHUDDefaultConfigDB = {
  global = {
    ["*"] = {},
  },
  profile = {
    waypoints = {},
    ShowWhenFlying = true,
    ShowWhenMounted = false,
    ShowWhenSwimming = false,
    ShowAlways = false,
    ShowPitchWhenFlying = true,
    ShowPitchWhenMounted = true,
    ShowPitchWhenSwimming = true,
    ShowPitchAlways = false,
    ShowCompassWhenFlying = true,
    ShowCompassWhenMounted = true,
    ShowCompassWhenSwimming = true,
    ShowCompassAlways = false,
    SpeedType = "RIGHT",
    WhichSpeedType = "RIGHT",
    WaypointDisplay = "BOTTOM",
    RefreshRate = 0.1,
    HUDAlpha = 1,
    HUDBGAlpha = 0.4,
    SpeedPrecision = 0,
    ShowPitchText = true,
    PitchTextColor = {0, 1, 0, 1},
    ShowHeadingText = true,
    HeadingTextColor = {0, 1, 0, 1},
    ShowCoordinatesText = true,
    CoordinatesTextColor = {0, 1, 0, 1},
    ShowSpeedText = true,
    SpeedTextColor = {0, 1, 0, 1},
    ShowSpeedPrefix = true,
    LockPosition = true,
    FrameScale = 0.72307443618774,
    PitchGraphicsScale = 17.448093414307,
    FontScale = 20.242206573486,
    FramePoint_point = "TOP",
    FramePoint_relativeTo = false,
    FramePoint_relativePoint = "TOP",
    FramePoint_xOfs = 14.663482434858,
    FramePoint_yOfs = -76.521231176252,
    WorldmapModifier = "S",
    WorldmapPOIModifier = "S",
    RemoveWaypointDistance = 15,
    QuestHelper = false,
    WorldMapPOI = false,
    WaypointNotify = false,
    WaypointTextColor = {0, 1, 0, 1},
    WaypointTextShadowColor = {0, 0, 0, 1},
    WaypointETAArc = 90,
    etaArcL = 315,
    etaArcR = 45,
    --[===[@debug@
    EnableDebug = true,
    --@end-debug@]===]
  }
}
