--[[
	- file and project errata -
	Project Author:		myrroddin
	Project Date:		2014-05-10T20:19:35Z
	Project Version:	Release-1.0.9
	Project Revision:	21
	
	File Author:		myrroddin
	File Date:			2014-05-10T20:19:35Z
	File Revision:		21
]]--

-- GLOBALS: sort, GetAddOnMetadata, GetFactionInfoByID, GetItemInfo, IsQuestFlaggedCompleted, GetLocale
-- GLOBALS: COMPLETE, ITEMS, YES
-- GLOBALS: LibStub
-- GLOBALS: FeedTillers_hideComplete, FeedTillers_currentSort

local ADDON, L = ...
local ADDON_TITLE = GetAddOnMetadata(ADDON, "Title")
local TILLERS
local LOCALE = GetLocale()
local event_frame = CreateFrame("frame")

-- translate the tooltips
if LOCALE == "esES" then
L["ALT_DOWN"] = "Alt-clic en la línea de un Labrador para crear un waypoint en TomTom."
L["CLICK_SORT"] = "Clic para alternar entre ordenar por nombre de PNJ o nombre de comida."
L["CONTROL_DOWN"] = "Ctrl-clic para ocultar los Labradores que ya están su Mejor Amigo."
L["SHIFT_DOWN"] = "Mayús-clic para ocultar a los Labradores que ya se alimentó hoy."
L["ToC/Description"] = "Mostrar cuál comida le gusta cada miembro de los Labradores, y si ha completado su misión diaria \"Un plato para...\""

elseif LOCALE == "esMX" then
L["ALT_DOWN"] = "Alt-clic en la línea de un Labrador para crear un waypoint en TomTom."
L["CLICK_SORT"] = "Clic para alternar entre ordenar por nombre de PNJ o nombre de comida."
L["CONTROL_DOWN"] = "Ctrl-clic para ocultar los Labradores que ya están su Mejor Amigo."
L["SHIFT_DOWN"] = "Mayús-clic para ocultar a los Labradores que ya se alimentó hoy."
L["ToC/Description"] = "Mostrar cuál comida le gusta cada miembro de los Labradores, y si ha completado su misión diaria \"Un plato para...\""

elseif LOCALE == "itIT" then
L["ALT_DOWN"] = "Hold the <Alt> key and click on a Tiller's tooltip line to add a TomTom waypoint" -- Requires localization
L["CLICK_SORT"] = "Click sul plugin per elencare i Coltivatori per il nome o per il loro oggetto"
L["CONTROL_DOWN"] = "Hold the <Control> key and click to hide Best Friend Tillers" -- Requires localization
L["SHIFT_DOWN"] = "Tieni premuto il tasto <Shift> per nascondere i Contivatori già sfamati"
L["ToC/Description"] = "Indica quale Coltivatore, che cibo gli piace, e se lo hai già sfamato oggi con la quest \"Un piatto per...\""

elseif LOCALE == "ptBR" then
L["ALT_DOWN"] = "Hold the <Alt> key and click on a Tiller's tooltip line to add a TomTom waypoint" -- Requires localization
L["CLICK_SORT"] = "Click the plugin to sort by Tiller name or item name" -- Requires localization
L["CONTROL_DOWN"] = "Hold the <Control> key and click to hide Best Friend Tillers" -- Requires localization
L["SHIFT_DOWN"] = "Hold the <Shift> key and click to hide already fed Tillers" -- Requires localization
L["ToC/Description"] = "Tells you the Tiller, what food they like, and if you have fed them today for the quests A Dish for ..." -- Requires localization

elseif LOCALE == "frFR" then
L["ALT_DOWN"] = "Maintenez la touche <Alt> et cliquez sur l'infobulle du laboureur pour ajouter un point d'interêt TomTom" -- Needs review
L["CLICK_SORT"] = "Cliquez sur le plugin pour trier par laboureur ou par objet" -- Needs review
L["CONTROL_DOWN"] = "Maintenez la touche <Control> et cliquez pour cachez vos meilleurs amis laboureurs" -- Needs review
L["SHIFT_DOWN"] = "Maintenez la touche <Shift> et cliquez pour cacher les laboureurs déjà nourris" -- Needs review
L["ToC/Description"] = "Liste les laboureurs, ce qu'ils aiment manger et si vous les avez nourris pour la quête Un plat pour..." -- Needs review

elseif LOCALE == "deDE" then
L["ALT_DOWN"] = "Hold the <Alt> key and click on a Tiller's tooltip line to add a TomTom waypoint" -- Requires localization
L["CLICK_SORT"] = "Click the plugin to sort by Tiller name or item name" -- Requires localization
L["CONTROL_DOWN"] = "Hold the <Control> key and click to hide Best Friend Tillers" -- Requires localization
L["SHIFT_DOWN"] = "Hold the <Shift> key and click to hide already fed Tillers" -- Requires localization
L["ToC/Description"] = "Tells you the Tiller, what food they like, and if you have fed them today for the quests A Dish for ..." -- Requires localization

elseif LOCALE == "ruRU" then
L["ALT_DOWN"] = "Удерживайте <Alt> и нажмите на Tiller's чтобы добавить вейпоинт в TomTom" -- Needs review
L["CLICK_SORT"] = "Click the plugin to sort by Tiller name or item name" -- Requires localization
L["CONTROL_DOWN"] = "Удерживайте  <Control> и нажмите чтобы скрыть лучшего друга Tillers" -- Needs review
L["SHIFT_DOWN"] = "Удерживайте <Shift> и нажмите чтоб скрыть Tillers" -- Needs review
L["ToC/Description"] = "Tells you the Tiller, what food they like, and if you have fed them today for the quests A Dish for ..." -- Requires localization

elseif LOCALE == "zhCN" then
L["ALT_DOWN"] = "Hold the <Alt> key and click on a Tiller's tooltip line to add a TomTom waypoint" -- Requires localization
L["CLICK_SORT"] = "Click the plugin to sort by Tiller name or item name" -- Requires localization
L["CONTROL_DOWN"] = "Hold the <Control> key and click to hide Best Friend Tillers" -- Requires localization
L["SHIFT_DOWN"] = "Hold the <Shift> key and click to hide already fed Tillers" -- Requires localization
L["ToC/Description"] = "Tells you the Tiller, what food they like, and if you have fed them today for the quests A Dish for ..." -- Requires localization

elseif LOCALE == "zhTW" then
L["ALT_DOWN"] = "Hold the <Alt> key and click on a Tiller's tooltip line to add a TomTom waypoint" -- Requires localization
L["CLICK_SORT"] = "Click the plugin to sort by Tiller name or item name" -- Requires localization
L["CONTROL_DOWN"] = "Hold the <Control> key and click to hide Best Friend Tillers" -- Requires localization
L["SHIFT_DOWN"] = "Hold the <Shift> key and click to hide already fed Tillers" -- Requires localization
L["ToC/Description"] = "Tells you the Tiller, what food they like, and if you have fed them today for the quests A Dish for ..." -- Requires localization

else
L["CLICK_SORT"] = "Click the plugin to sort by Tiller name or item name"
L["SHIFT_DOWN"] = "Hold the <Shift> key and click to hide already fed Tillers"
end

local qtip = LibStub("LibQTip-1.0")

local npcs = {
	{ factionID = 1273, itemID = 74643, questID = 30439 }, -- Jogu the Drunk
	{ factionID = 1275, itemID = 74651, questID = 30386 }, -- Ella
	{ factionID = 1276, itemID = 74649, questID = 30396 }, -- Old Hillpaw
	{ factionID = 1277, itemID = 74647, questID = 30402 }, -- Chee Chee
	{ factionID = 1278, itemID = 74645, questID = 30408 }, -- Sho
	{ factionID = 1279, itemID = 74642, questID = 30414 }, -- Haohan Mudclaw
	{ factionID = 1280, itemID = 74652, questID = 30433 }, -- Tina Mudclaw
	{ factionID = 1281, itemID = 74644, questID = 30390 }, -- Gina Mudclaw
	{ factionID = 1282, itemID = 74655, questID = 30427 }, -- Fish Fellreed
	{ factionID = 1283, itemID = 74654, questID = 30421 }, -- Farmer Fung
}

local tooltip = "NAME"
local sortByName = function(a, b)
	return a.name < b.name
end
local sortByItem = function(a, b)
	return a.item < b.item
end

local function CreateBroker()
	LibStub("LibDataBroker-1.1"):NewDataObject(ADDON, {
		type = "data source",
		text = ADDON_TITLE,
		icon = [[Interface/ICONS/Achievement_Profession_ChefHat]],
		OnClick = function(self)
			if IsShiftKeyDown() then
				FeedTillers_hideComplete = not FeedTillers_hideComplete
			else
				FeedTillers_currentSort = FeedTillers_currentSort == "NAME" and "ITEM" or "NAME"
				sort(npcs, FeedTillers_currentSort == "NAME" and sortByName or sortByItem)
			end
			self:GetScript("OnLeave")(self)
			self:GetScript("OnEnter")(self)
		end,
		OnEnter = function(self)
			if not TILLERS then
				TILLERS = GetFactionInfoByID(1272)
				for i = 1, #npcs do
					local npc = npcs[i]
					npc.name = GetFactionInfoByID(npc.factionID)
				end
				sort(npcs, sortByName)
			end
			
			tooltip = qtip:Acquire("FeedTillersTT", 3, "LEFT", "LEFT", "RIGHT")
			tooltip:AddHeader(TILLERS, ITEMS, COMPLETE)
			local line
			local hideComplete = FeedTillers_hideComplete
			for i = 1, #npcs do
				local npc = npcs[i]
				if not npc.item then
					npc.item = GetItemInfo(npc.itemID)
				end
				if not IsQuestFlaggedCompleted(npc.questID) then
					-- note "line" is no longer local to this scope!
					local count = GetItemCount(npc.itemID)
					line = tooltip:AddLine(npc.name, npc.item, format("%d/%d", count, 5))
					if count < 5 then
						tooltip:SetLineColor(line, 1, 0.1, 0.1, 0.3)
					end
				elseif not hideComplete then
					line = tooltip:AddLine(npc.name, npc.item, YES)
					tooltip:SetLineColor(line, 0.1, 1, 0.1, 0.3)
				end
			end

			if not line then
				hideComplete = nil
				self:GetScript("OnLeave")(self)
				return self:GetScript("OnEnter")(self)
			end

			line = tooltip:AddLine(" ") -- blank line

			line = tooltip:AddLine(" ")
			tooltip:SetCell(line, 1, NORMAL_FONT_COLOR_CODE .. L.CLICK_SORT, "LEFT", 3)

			line = tooltip:AddLine(" ")
			tooltip:SetCell(line, 1, NORMAL_FONT_COLOR_CODE .. L.SHIFT_DOWN, "LEFT", 3)

			tooltip:SmartAnchorTo(self)
			tooltip:Show()
		end,
		OnLeave = function(self)
			if qtip:IsAcquired("FeedTillersTT") then
				qtip:Release(tooltip)
			end
			tooltip = nil
		end
	})
end

event_frame:RegisterEvent("ADDON_LOADED")
event_frame:SetScript("OnEvent", function(self, event, ...)
	if event == "ADDON_LOADED" and ... == ADDON then	
		if not FeedTillers_hideComplete then
			FeedTillers_hideComplete = false
		end
		if not FeedTillers_currentSort then
			FeedTillers_currentSort = "NAME"
		end
	end	
	CreateBroker()
	self:UnregisterEvent("ADDON_LOADED")
end)