FASTTRACK_VERSION = "v1.11";

FastTrack_LastMoney = 0;
FastTrack_MadeProfit = false;
FastTrack_History = {};
FastTrack_HasMail = nil;
FastTrack_IsVisible = true;
FastTrack_IsAutoSell = true;
FastTrack_IsAutoLoot = true;
FastTrack_Settings = { 	MinimapPos      = 45,		-- Default minimap button position in degrees
						FastRepair      = false,	-- Enabled or disabled
						FastRepairFunds = 1,	  	-- 1 = Use Guild Funds (if in guild), 0 or nil = use your own
						FastRepairWarn  = true,		-- Warn before making repairs
						FastRepairGuildBroke = 1	-- Repair with player gold if guild broke
					 };

SLASH_FASTTRACK_CMD1 = "/ft";
SLASH_FASTTRACK_CMD2 = "/fasttrack";

SlashCmdList["FASTTRACK_CMD"] = function(cmd)
	if cmd == "toggle" then
		DEFAULT_CHAT_FRAME:AddMessage("FastTrack toggling widget visibility");
		FastTrack_ToggleVisible();
	elseif cmd == "config" then
		-- Before we show the frame, make sure the check boxes have the current valuue
		FTC_CheckCheckBoxStates();
		FastTrack_ConfigFrame:Show();
	elseif cmd == "help" then
		DEFAULT_CHAT_FRAME:AddMessage("FastTrack "..FASTTRACK_VERSION.." help: FastTrack commands all start with /ft or /fasttrack.\n/ft config: Open config options\n/ft help: This message\n/ft toggle: Toggles the widget to show or hide");
	else
		DEFAULT_CHAT_FRAME:AddMessage("FastTrack commands are: /ft toggle, /ft help, /ft config");
	end
	
end

function FastTrack_OnMouseDown()
	FastTrack_MainFrame:StartMoving()
end

function FastTrack_OnMouseUp()
	FastTrack_MainFrame:StopMovingOrSizing()
end

function FastTrack_OnLoad()
	FastTrack_ChangeSize();
	FastTrack_MainFrame_MailButton:Hide();
	FastTrack_MainFrame:RegisterEvent("PLAYER_MONEY");
	FastTrack_MainFrame:RegisterEvent("PLAYER_ENTERING_WORLD");
	FastTrack_MainFrame:RegisterEvent("MERCHANT_SHOW");
	FastTrack_MainFrame:RegisterEvent("CONFIRM_LOOT_ROLL");
	FastTrack_MainFrame:RegisterEvent("LOOT_BIND_CONFIRM");
	FastTrack_MainFrame:RegisterEvent("UPDATE_PENDING_MAIL");
	
	-- Determine if this player is in a Guild, if they are not, be sure they can't select guild repair options
	if not(IsInGuild() == 1) then
		FastTrack_Settings.FastRepairFunds = 0;
	end
end

function FastTrack_ChangeSize()
	local width = 65;
	
	if FastTrack_HasMail == 1 then
		width = 80;
	end
	
	width = width + FastTrack_MainFrame_GoldString:GetStringWidth();
	width = width + FastTrack_MainFrame_SilverString:GetStringWidth();
	width = width + FastTrack_MainFrame_CopperString:GetStringWidth();

	FastTrack_MainFrame:SetWidth(width);
end

function FastTrack_FastPartyLoot(rollID, roll)
	DEFAULT_CHAT_FRAME:AddMessage("FastTrack has not (yet) implemented FastPartyLoot ["..rollID..", "..roll.."].");
end

function FastTrack_FastSoloLoot(slotID)

	if FastTrack_IsAutoLoot == false then
		print("FastTrack Auto Loot feature is disabled");
		return;
	end

	for i = 1, STATICPOPUP_NUMDIALOGS do
		local frame = _G["StaticPopup"..i];
		if frame.which == "LOOT_BIND" and frame:IsVisible() then
			StaticPopup_OnClick(frame, 1);
		end
	end
	FastTrack_MainFrame:UnregisterEvent("LOOT_BIND_CONFIRM");
	LootSlot(slotID);
	for i = 1, STATICPOPUP_NUMDIALOGS do
	    local frame = _G["StaticPopup"..i]
	    if frame.which == "LOOT_BIND" and frame:IsVisible() then
	    	StaticPopup_OnClick(frame, 1)
	   	end
	end
	ConfirmLootSlot(slotID)
	FastTrack_MainFrame:RegisterEvent("LOOT_BIND_CONFIRM")
	
	DEFAULT_CHAT_FRAME:AddMessage("FastTrack automatically confirmed the looting of a bindable item ["..slotID.."].");
end

function FastTrack_FastRepair()

	-- This routine will be called each time a merchant is visited, so we will do some basic checks on their ability
	-- to repair us if needed.
	if not(CanMerchantRepair()) then
		return;
	end

	local repairAllCost, canRepair = GetRepairAllCost();
	if (canRepair ~= 1) then
		return;
	end
	
	-- First, determine if repairs are even possible
	if (repairAllCost > 0 and FastTrack_Settings.FastRepair) then
		-- Repairs are needed, and the user wants FastTrack to do it, determine if we should attempt to use Guild Funds
		if (FastTrack_Settings.FastRepairFunds == 1 and CanGuildBankRepair() == 1 and IsInGuild() == 1) then
			-- We are in a guild, player wants to use guild fund, and player has guild permission to repair
			if (repairAllCost <= GetGuildBankWithdrawMoney()) then
				-- Our costs are less than our Guild limits, proceed with the repair
				RepairAllItems(1); -- 1 here means guild repair, 0 would mean our wallet
				print("FastTrack and your Guild repaired all items, cost "..GetCoinTextureString(repairAllCost));
			else
				print("FastTrack found you to have insufficient Guild funds for a total repair...")
				-- So now, based on options, does the player want us to use his funds if Guild Repair failed?
				if (FastTrack_Settings.FastRepairGuildBroke == 1) then
					-- This one hits our wallet, make sure we have enough funds!
					if (repairAllCost <= GetMoney()) then
						-- We indeed have enough of our own funds to repair all items
						RepairAllItems(0);
						print("...so FastTrack repaired with your funds, cost "..GetCoinTextureString(repairAllCost));
					else
						print("...and you don't have enough funds either.  No repairs being performed.");
					end
				else
					print("...and your FastTrack settings say to not use your own funds!  No repairs performed.")
				end
			end
		else
			-- Failed all Guild Repair checks (not sure which one failed, so further checking needs to happen
			-- Either way, we only want to use player gold if they explicity set up that way
			if (FastTrack_Settings.FastRepairFunds == 0) then  -- 0 means our funds, 1 means guild funds
				if (repairAllCost <= GetMoney()) then
					-- We indeed have enough of our own funds to repair all items
					RepairAllItems(0);
					print("FastTrack repaired all items, cost "..GetCoinTextureString(repairAllCost));
				else
					print("FastTrack found you to have insufficient funds for a total repair");
				end
			end
		end
	else
		print("FastTrack could of auto repaired you!  Turn on the feature with '/ft config'!");
	end

end

function FastTrack_YouHaveMail()
	-- Show the mail icon on the widget, giving it a hover over indicating new mail has arrived
	if FastTrack_HasMail == 1 then
		FastTrack_MainFrame_MailButton:Show();
		FastTrack_MainFrame_GoldString:SetPoint("TOPLEFT", 35, -5);
	else
		FastTrack_MainFrame_MailButton:Hide();
		FastTrack_MainFrame_GoldString:SetPoint("TOPLEFT", 20, -5);
	end
	FastTrack_ChangeSize();
end

function FastTrack_FastSell(qual)

	if FastTrack_IsAutoSell == false then
		print("FastTrack Auto Sell feature is disabled");
		return;
	end

	-- We want to be able to send in the max quality we want to be able to sell fast.
	-- FastSell(0) will only sell items of poor quality or less.
	-- Quality is 0 - 5 (poor to legendary)
	
	local itemLink, myName, myQual, myLevel, myType, mySellPrice, myStack, numSlots;
	local gold, silver, copper;
	local totalSell = 0;
	local totalCount = 0;
	
	-- DEFAULT_CHAT_FRAME:AddMessage("Attempting to FastSell your poor items...");
	
	for bagid = 0, 4 do
		numSlots = GetContainerNumSlots(bagid);
		for slotid = 1, numSlots do
			-- Loops through each slot in each bag
			_,myStack,_,_,_,_,itemLink = GetContainerItemInfo(bagid,slotid);
			if ( itemLink ~= nil) then
				myName,_,myQual,myLevel,_,myType,_,_,_,_,mySellPrice = GetItemInfo(itemLink);
				if (myQual <= qual) then
					UseContainerItem(bagid,slotid);
					totalSell = totalSell + (mySellPrice * myStack);
					totalCount = totalCount + myStack;
					gold, silver, copper = FastTrack_ReturnMoney(mySellPrice * myStack);
					DEFAULT_CHAT_FRAME:AddMessage(  "FastSell vendored " ..myStack.." |cFF00FF00" .. myName ..
													"|r: for "..GetCoinTextureString(mySellPrice * myStack).."!");
				end
			end
		end			
	end

	gold, silver, copper = FastTrack_ReturnMoney(totalSell);
	if totalSell ~= 0 then
		DEFAULT_CHAT_FRAME:AddMessage(	"Your total FastSell of " .. totalCount .. 
										" items was a profit of: "..GetCoinTextureString(totalSell).."!");
	else
		-- Nothing sold this vendor trip
		DEFAULT_CHAT_FRAME:AddMessage(  "You had no poor items to sell to this vendor.")
	end
end

function FastTrack_ToggleVisible()
	if FastTrack_IsVisible == true then
		FastTrack_MainFrame:Hide();
		FastTrack_IsVisible = false;
	else
		FastTrack_MainFrame:Show();
		FastTrack_IsVisible = true;
	end
end

function FastTrack_OnEvent(self, event, ...)
	if event == "PLAYER_ENTERING_WORLD" then
		print("FastTrack "..FASTTRACK_VERSION.." loaded. '/ft config' for options or '/ft help'");
		FTC_MinimapButton_Reposition(); -- Put the minimap button back where the player left it
		FastTrack_LastMoney = GetMoney();
		FastTrack_HasMail = HasNewMail();

		if FastTrack_IsVisible == true then
			FastTrack_MainFrame:Show();
		else
			FastTrack_MainFrame:Hide();
		end
	end
	
	if event == "MERCHANT_SHOW" then
		FastTrack_FastSell(0);
		FastTrack_FastRepair();
	end

	if event == "UPDATE_PENDING_MAIL" then
		FastTrack_HasMail = HasNewMail();
		FastTrack_YouHaveMail();
	end

	if event == "CONFIRM_LOOT_ROLL" then
		local rollID = select(1, ...);
		local roll = select(2, ...);
		FastTrack_FastPartyLoot(rollID, roll);
	end
		
	if event == "LOOT_BIND_CONFIRM" then
		local slotID = select(1, ...);
		FastTrack_FastSoloLoot(slotID);
	end

	if event == "PLAYER_MONEY" then
		if not FastTrack_MadeProfit then
			table.insert(FastTrack_History, 1, 0)
			FastTrack_MadeProfit = true
		end

		local difference = GetMoney() - FastTrack_LastMoney
		FastTrack_History[1] = FastTrack_History[1] + difference
		FastTrack_LastMoney = GetMoney();

		local gold, silver, copper = FastTrack_ReturnMoney(FastTrack_History[1])
		
		FastTrack_MainFrame_GoldString:SetText(gold)
		FastTrack_MainFrame_SilverString:SetText(silver)
		FastTrack_MainFrame_CopperString:SetText(copper)

		FastTrack_ChangeSize()
		
		if FastTrack_History[1] < 0 then
			FastTrack_MainFrame_GoldString:SetTextColor(1,0,0)
			FastTrack_MainFrame_SilverString:SetTextColor(1,0,0)
			FastTrack_MainFrame_CopperString:SetTextColor(1,0,0)
		elseif FastTrack_History[1] > 0 then
			FastTrack_MainFrame_GoldString:SetTextColor(0,1,0)
			FastTrack_MainFrame_SilverString:SetTextColor(0,1,0)
			FastTrack_MainFrame_CopperString:SetTextColor(0,1,0)
		else
			FastTrack_MainFrame_GoldString:SetTextColor(1,1,0)
			FastTrack_MainFrame_SilverString:SetTextColor(1,1,0)
			FastTrack_MainFrame_CopperString:SetTextColor(1,1,0)
		end
	end
end

function FastTrack_ReturnMoney(money)
	local absMoney = abs(money)
	local gold = floor(absMoney / 10000)
	local silver = floor((absMoney - gold*10000) / 100)
	local copper = absMoney - gold*10000 - silver*100
	return gold, silver, copper
end

function FastTrack_HasMail_OnClick()
	DEFAULT_CHAT_FRAME:AddMessage("This will display something useful about your new mail.")
--	FastTrack_HasMail = HasNewMail();
	if FastTrack_HasMail == 1 then
		DEFAULT_CHAT_FRAME:AddMessage("You have new mail!");
	else
		DEFAULT_CHAT_FRAME:AddMessage("You have no new mail.");
	end
end

function FastTrack_Button_OnClick()
--	DEFAULT_CHAT_FRAME:AddMessage("Inside Sumamry Click"..FastTrack_HasMail);
--	if FastTrack_HasMail then
--		DEFAULT_CHAT_FRAME:AddMessage("You have mail!");
--		FastTrack_YouHaveMail(1);
--	else
--		DEFAULT_CHAT_FRAME:AddMessage("You do not have mail :(");
--		FastTrack_YouHaveMail(nil);
--	end
--	DEFAULT_CHAT_FRAME:AddMessage("Ending mail check."..FastTrack_HasMail);
	
	local alltime = 0;
	
	for k,v in pairs(FastTrack_History) do
		alltime = alltime + v
	end

	local gold, silver, copper = FastTrack_ReturnMoney(alltime)
	
	if alltime < 0  then
		DEFAULT_CHAT_FRAME:AddMessage("FastTrack - All Time |cFFFF0000deficit|r: ")
	else	
		DEFAULT_CHAT_FRAME:AddMessage("FastTrack - All Time |cFF00FF00profit|r: ")
	end
	
	DEFAULT_CHAT_FRAME:AddMessage(	"|cFFFFFF00" .. gold .. 
									" |cFFAAAAAA" .. silver ..
									" |cFF993300" .. copper)
end

