function FTC_OnMouseDown()
	FastTrack_ConfigFrame:StartMoving();
end

function FTC_OnMouseUp()
	FastTrack_ConfigFrame:StopMovingOrSizing();
end

function FTC_ClickClose()
	FastTrack_ConfigFrame:Hide();
end

function FTC_OnLoad()
	tinsert(UISpecialFrames, "FastTrack_ConfigFrame");
end

function FTC_CheckCheckBoxStates()
	FTC_CheckShowWidgetState();
	FTC_CheckAutoSellState();
	FTC_CheckAutoLootState();
	FTC_CheckAutoRepairState();
	FTC_CheckAutoRepairGuildState();
	FTC_CheckAutoRepairGuildBrokeState();
end

function FTC_CheckShowWidgetClick()
	if FastTrack_ConfigFrameCheckShowWidget:GetChecked() == 1 then
		print("Showing the FastTrack gold tracker");
		FastTrack_MainFrame:Show();
		FastTrack_IsVisible = true;
	else
		print("Hiding the FastTrack gold tracker");
		FastTrack_MainFrame:Hide();
		FastTrack_IsVisible = false;
	end
end

function FTC_CheckShowWidgetState()
	if FastTrack_IsVisible == true then
		FastTrack_ConfigFrameCheckShowWidget:SetChecked(true);
	else
		FastTrack_ConfigFrameCheckShowWidget:SetChecked(false);
	end
end

function FTC_CheckAutoSellClick()
	if FastTrack_ConfigFrameCheckAutoSell:GetChecked() == 1 then
		print("Enabling FastTrack Auto Sell feature");
		FastTrack_IsAutoSell = true;
	else
		print("Disabling FastTrack Auto Sell feature");
		FastTrack_IsAutoSell = false;
	end
end

function FTC_CheckAutoSellState()
	if FastTrack_IsAutoSell == true then
		FastTrack_ConfigFrameCheckAutoSell:SetChecked(true);
	else
		FastTrack_ConfigFrameCheckAutoSell:SetChecked(false);
	end
end

function FTC_CheckAutoLootClick()
	if FastTrack_ConfigFrameCheckAutoLoot:GetChecked() == 1 then
		print("Enabling FastTrack Auto Loot feature");
		FastTrack_IsAutoLoot = true;
	else
		print("Disabling FastTrack Auto Loot feature");
		FastTrack_IsAutoLoot = false;
	end
end

function FTC_CheckAutoLootState()
	if FastTrack_IsAutoLoot == true then
		FastTrack_ConfigFrameCheckAutoLoot:SetChecked(true);
	else
		FastTrack_ConfigFrameCheckAutoLoot:SetChecked(false);
	end
end

function FTC_CheckAutoRepairClick()
	if FastTrack_ConfigFrameCheckAutoRepair:GetChecked() == 1 then
		print("Enabling FastTrack Auto Repair feature");
		FastTrack_Settings.FastRepair = true;
	else
		print("Disabling FastTrack Auto Repair feature");
		FastTrack_Settings.FastRepair = false;
	end

	-- Click changes here will probably affect how the GuildRepair check should look
	FTC_CheckAutoRepairGuildState();
	FTC_CheckAutoRepairGuildBrokeState();
end

function FTC_CheckAutoRepairState()
	if FastTrack_Settings.FastRepair == true then
		FastTrack_ConfigFrameCheckAutoRepair:SetChecked(true);
	else
		FastTrack_ConfigFrameCheckAutoRepair:SetChecked(false);
	end
end

function FTC_CheckAutoRepairGuildClick()
	if FastTrack_ConfigFrameCheckAutoRepairGuild:GetChecked() == 1 then
		print("Enabling FastTrack Auto Repair with Guild Funds feature");
		FastTrack_Settings.FastRepairFunds = 1;
	else
		print("Disabling FastTrack Auto Repair with Guild Funds feature");
		FastTrack_Settings.FastRepairFunds = 0;
	end

	-- Click changes here will probably affect how the GuildBroke check should look
	FTC_CheckAutoRepairGuildBrokeState();
end

function FTC_CheckAutoRepairGuildState()
	
	if IsInGuild() ~= 1 then
		FastTrack_Settings.FastRepairFunds = 0;
		FastTrack_Settings.FastRepairGuildBroke = 1;  -- This makes sure we use player wallet
		FastTrack_ConfigFrameLine7:SetTextColor(1, 0, 0, 0.9);
		FastTrack_ConfigFrameLine7:Show();
	else
		FastTrack_ConfigFrameLine7:Hide();
	end
	
	if FastTrack_Settings.FastRepairFunds == 1 then
		FastTrack_ConfigFrameCheckAutoRepairGuild:SetChecked(true);
	else
		FastTrack_ConfigFrameCheckAutoRepairGuild:SetChecked(false);
	end
	
	-- We can set check or unchecked (above), no problem.  But if the
	-- player does NOT have FastRepair enabled, they should not be
	-- able to modify this section
	
	if FastTrack_Settings.FastRepair and IsInGuild() == 1 then
		FastTrack_ConfigFrameCheckAutoRepairGuild:Enable();
		FastTrack_ConfigFrameLine5:SetTextColor(1, .82, 0, 1);
	else
		FastTrack_ConfigFrameCheckAutoRepairGuild:Disable();
		FastTrack_ConfigFrameLine5:SetTextColor(0.69, 0.69, 0.69, 0.5);
	end
	
end

function FTC_CheckAutoRepairGuildBrokeClick()
	if FastTrack_ConfigFrameCheckAutoRepairGuildBroke:GetChecked() == 1 then
		print("Enabling FastTrack Auto Repair with Guild Broke feature");
		FastTrack_Settings.FastRepairGuildBroke = 1;
	else
		print("Disabling FastTrack Auto Repair with Guild Broke feature");
		FastTrack_Settings.FastRepairGuildBroke = 0;
	end
end

function FTC_CheckAutoRepairGuildBrokeState()
	if FastTrack_Settings.FastRepairGuildBroke == 1 then
		FastTrack_ConfigFrameCheckAutoRepairGuildBroke:SetChecked(true);
	else
		FastTrack_ConfigFrameCheckAutoRepairGuildBroke:SetChecked(false);
	end
	
	-- We can set check or unchecked (above), no problem.  But if the
	-- player does NOT have FastRepair enabled, or it is enabled,
	-- but they are not using Guild Funds, they should not be
	-- able to modify this section
	
	if FastTrack_Settings.FastRepair and FastTrack_Settings.FastRepairFunds == 1 and IsInGuild() == 1 then
		FastTrack_ConfigFrameCheckAutoRepairGuildBroke:Enable();
		FastTrack_ConfigFrameLine6:SetTextColor(1, 0.82, 0, 1);
	else
		FastTrack_ConfigFrameCheckAutoRepairGuildBroke:Disable();
		FastTrack_ConfigFrameLine6:SetTextColor(0.69, 0.69, 0.69, 0.5);
	end
	
end

function FTC_MinimapButton_DraggingFrame_OnUpdate()
	local xpos,ypos = GetCursorPosition();
	local xmin,ymin = Minimap:GetLeft(), Minimap:GetBottom();

	xpos = xmin-xpos/UIParent:GetScale()+70; -- get coordinates as differences from the center of the minimap
	ypos = ypos/UIParent:GetScale()-ymin-70;

	FastTrack_Settings.MinimapPos = math.deg(math.atan2(ypos,xpos)); -- save the degrees we are relative to the minimap center
	FTC_MinimapButton_Reposition(); -- move the button
end

function FTC_MinimapButton_Reposition()
	FastTrack_MinimapButton:SetPoint("TOPLEFT","Minimap","TOPLEFT",52-(80*cos(FastTrack_Settings.MinimapPos)),(80*sin(FastTrack_Settings.MinimapPos))-52)
end

function FTC_MinimapButton_OnClick()
	FTC_CheckCheckBoxStates();
	FastTrack_ConfigFrame:Show();
end