----Broker Manager for Farmed
local menuRow1={}
local menuRow2={}

if not LibStub then return end

local LDB = LibStub("LibDataBroker-1.1")
local tip = LibStub('LibQTip-1.0')


Farmed_Broker = LibStub("AceAddon-3.0"):NewAddon("Broker_Farmed", "AceConsole-3.0", "AceTimer-3.0", "AceEvent-3.0")

local FarmedDB_NeedsBreak=true; --Hold the next line for ading to the menu

local function FarmDBTooltip_ClickLine(line, setName, button)
	if (setName=="Open") then farmed_show(); end
	if (setName=="Configure") then FarmedOptions:Show() end
	
	Farmed_Broker.tooltip:Hide();
	
end


local function FarmedDBTooltip_Show(frame)
	FarmedDBTooltip_Init();
	Farmed_Broker.tooltip:SmartAnchorTo(frame)
	Farmed_Broker.tooltip:SetAutoHideDelay(1, frame)
	Farmed_Broker.tooltip:Show()
end

function FarmedDBTooltip_Init()
	if (Farmed_Broker==nil) then 
			return;
	end
	
	FarmedDB_NeedsBreak=true

	if tip:IsAcquired("Broker_farmed") then tip:Release(Farmed_Broker.tooltip) end
	Farmed_Broker.tooltip = tip:Acquire("Broker_farmed", 2, "LEFT", "RIGHT")
	
	--write Menu Items
		Farmed_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_Misc_Bag_11.blp:16|tOpen", "","10")
		Farmed_Broker.tooltip:SetLineScript(1, "OnMouseDown", FarmDBTooltip_ClickLine, "Open")

		Farmed_Broker.tooltip:AddLine("|TInterface\\Icons\\INV_Holiday_Christmas_Present_01.blp:16|tConfigure", "")
		Farmed_Broker.tooltip:SetLineScript(2, "OnMouseDown", FarmDBTooltip_ClickLine, "Configure")
		
		
		Farmed_Broker.tooltip:AddLine("|cff00ff00-------------------|r", "");
	
		maxr=#menuRow1;
		
		 for n = 1,maxr do 
			Farmed_Broker.tooltip:AddLine(menuRow1[n], menuRow2[n]);
		 end
	
end

function FarmedDBTooltip_Clear()
	menuRow1={}
	menuRow2={}
end

function FarmedDBTooltip_AddLine(LineText,LineCount)

	-- add Line
	 table.insert(menuRow1,""..LineText)
	 table.insert(menuRow2,""..LineCount)

end

function UpdateDBlabel(txt)
	if Farmed_Broker~=nil then
		Farmed_Broker.lDBObject.text="Farmed - " .. txt;
	end
end

function Farmed_Broker:OnInitialize()
    -- Called when the addon is loaded
    self.lDBObject = {
		type = 'data source',
		text = 'Farmed',
		icon = 'Interface\\Icons\\INV_Misc_Gem_Diamond_06.blp',
		OnEnter = FarmedDBTooltip_Show,
	}
	
	LDB:NewDataObject("Farmed", self.lDBObject)
	
	FarmedDBTooltip_Init();
end
