--  Declare Saved Variables
farmed_options = 
{
    show=true,
    slotcount=true,
    ore=true,
    herb = true,
    element=true,
    meat=true,
    gems=true,
    cloth=true,
    leather=true,
    other=true,
    uncommon=true,
    rare=true,
    enchanting=true,
    money=true,
    consumable=true,
	annouce=true,
	annoucechat=true,
  
};

--- Loot Maassges Processing strings
local LOOT_SELF_REGEX = gsub(LOOT_ITEM_SELF, "%%s", "(.+)")
local LOOT_REGEX = gsub(LOOT_ITEM, "%%s", "(.+)")

--- Debug Mode?

farmed_showdebug=false;

--- Global Item Type Arrays

farmed_ore={};
farmed_meat={};
farmed_gem={};
farmed_cloth={};
farmed_leather={};
farmed_herb={};
farmed_element={};
farmed_other={};
farmed_enchanting={};
farmed_consumable={};

--- Declare Other Variables



--- Init Code and Support Functions

function farmed_Message(msg)
    DEFAULT_CHAT_FRAME:AddMessage("|cFF2080D0[Farmed]|r "..msg);
end

function farmed_Debug(msg)
    if (farmed_showdebug) then  
        DEFAULT_CHAT_FRAME:AddMessage("|cFF2080D0[Farmed]|cFFFF0000{Debug}|r "..msg);
    end
end

function farmed_OnLoad(self)

    SLASH_FARMED1="/farmed";
    SlashCmdList["FARMED"] = farmed_SlashCommand;
    
   

    
  
   
    
    
    
    this:RegisterEvent("ADDON_LOADED");
    this:RegisterEvent("BAG_UPDATE");
   -- this:RegisterEvent("ITEM_LOCK_CHANGED");
    this:RegisterEvent("VARIABLES_LOADED");
    this:RegisterEvent("LOOT_OPENED");
	this:RegisterEvent("CHAT_MSG_LOOT");
	
    
    
    
    farmed_Message(farmed_lang_loaded);
    
    --farmed_gen();

end
-- Build inital list of items;
function farmed_buildlist()
   
     for n= 0,NUM_BAG_SLOTS do
        local slots = GetContainerNumSlots(n);
                    
        for f= 1,slots do
            local il=GetContainerItemLink(n,f);
            if (il~=nil) then
                farmed_addtolist(il);
            end
            
        end
   end
   
   ---debug array sizes
   farmed_Debug("Metals/Ore : " .. #farmed_ore);
   farmed_Debug("Meat : " .. #farmed_meat);
   farmed_Debug("Gems : " .. #farmed_gem);
   farmed_Debug("Cloth : " .. #farmed_cloth);
   farmed_Debug("Leather : " .. #farmed_leather);
   farmed_Debug("Elemental : " .. #farmed_element);
   farmed_Debug("Other : " .. #farmed_other);
   farmed_Debug("Enchanting : " .. #farmed_enchanting);
   farmed_Debug("Consumable : " .. #farmed_consumable);
   
 
   

end

-- Add item to list
function farmed_addtolist(il)
    
    local spos = string.find(il,"Hitem:",1);
    local epos = string.find(il,":",spos+7);
                         
    local nitem = tonumber(strsub(il,spos+6,epos-1));
    
    local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(il);
    
    --if (itemType~=farmed_lang_gem and itemType~=farmed_lang_othercat and itemType~=farmed_lang_consumable) then
     if (itemType==nil or string.find(farmed_lang_ItemFilter, itemType) ~= nil) then --- not aopplicable
        return
	end

    
    farmed_Debug("Considering: " .. nitem .. " : " .. itemName ..", " .. itemType .. "-" .. itemSubType);
    
    if (itemSubType==farmed_lang_ore) then
        farmed_addtolist2(farmed_ore,nitem);
    elseif (itemSubType==farmed_lang_meat) then
        farmed_addtolist2(farmed_meat,nitem);
    elseif (itemSubType==farmed_lang_cloth) then
        farmed_addtolist2(farmed_cloth,nitem);
    elseif (itemSubType==farmed_lang_leather) then
        farmed_addtolist2(farmed_leather,nitem);
    elseif (itemSubType==farmed_lang_herb) then
        farmed_addtolist2(farmed_herb,nitem);
    elseif (itemSubType==farmed_lang_element) then
        farmed_addtolist2(farmed_element,nitem);
    elseif (itemSubType==farmed_lang_enchanting) then
        farmed_addtolist2(farmed_enchanting,nitem);
    elseif (itemType==farmed_lang_gem) then
        farmed_addtolist2(farmed_gem,nitem);
    elseif (itemSubType==farmed_lang_othercat) then
        farmed_addtolist2(farmed_other,nitem);
    elseif (itemSubType==farmed_lang_othercat1) then
        farmed_addtolist2(farmed_other,nitem);
    elseif (itemSubType==farmed_lang_othercat2) then
        farmed_addtolist2(farmed_other,nitem);
    elseif (itemType==farmed_lang_consumable) then
        farmed_addtolist2(farmed_consumable,nitem);
    end
end

function farmed_addtolist2(iarray,ino)
    farmed_Debug("   Checking List: " .. ino);
    local isFound= false;
    
    for index,value in ipairs(iarray) do 
        if (value==ino) then 
            isFound=true;
        end
    end
    
    if (isFound==false) then
        farmed_Debug("Added: " .. ino);
        tinsert(iarray,1,ino);
    end

end
function farmed_isListable(ItemID)

local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(ItemID);
	if (itemType==nil or string.find(farmed_lang_ItemFilter, itemType) ~= nil) then --- not aopplicable
        return false
	end

    
    farmed_Debug("Considering: " .. ItemID .. " : " .. itemName ..", " .. itemType .. "-" .. itemSubType);
    
    if (itemSubType==farmed_lang_ore) then
        return true
    elseif (itemSubType==farmed_lang_meat) then
        return true
    elseif (itemSubType==farmed_lang_cloth) then
        return true
    elseif (itemSubType==farmed_lang_leather) then
        return true
    elseif (itemSubType==farmed_lang_herb) then
        return true
    elseif (itemSubType==farmed_lang_element) then
        return true
    elseif (itemSubType==farmed_lang_enchanting) then
        return true
    elseif (itemType==farmed_lang_gem) then
        return true
    elseif (itemSubType==farmed_lang_othercat) then
        return true
    elseif (itemSubType==farmed_lang_othercat1) then
        return true
    elseif (itemSubType==farmed_lang_othercat2) then
        return true
    elseif (itemType==farmed_lang_consumable) then
        return true
    end
	
	return false;
end
-- Command Line Manager

function farmed_SlashCommand(msg)
   
    
    msg = string.lower(msg);
   local args = {};
   for word in string.gmatch(msg, "[^%s]+") do
   	table.insert(args, word);
   end
   
   ----PROCESS COMMAND LINE
   
   if ( args[1] ) then
	  if ( args[1] == "show" ) then
	     farmed_show();
	  elseif ( args[1] == "hide" ) then
	      farmed_hide();
       elseif ( args[1] == "options" ) then
	      FarmedOptions:Show();
      else
         farmed_Message("|cffff0000Unrecognised command.");
        
      end
    else
        farmed_Message(farmed_lang_optmain);
        farmed_Message(farmed_lang_optcom1);
        farmed_Message(farmed_lang_optcom2);
        farmed_Message(farmed_lang_optcom3);
    end
end

function farmed_toggle()
    if (farmed_options.show) then
        farmed_hide();
    else
        farmed_show();
    end
end

function farmed_show()
    farmed_options.show=true;
    FarmedOptions_show:SetChecked(true);
    Farmed:Show();
end

function farmed_hide()
    Farmed:Hide();
    farmed_options.show=false;
    FarmedOptions_show:SetChecked(false);
end

function farmed_write(htmltext, rows)
    Farmed_html:SetText(htmltext);
    --resize window to take into account html size
    Farmed_html:SetHeight((rows*11));
    Farmed:SetHeight((rows*11)+15);
end
--- Core Processing Loop
function farmed_gen()
    local rowcount=2;
	
	---Reset DB Menu
	FarmedDBTooltip_Clear();
	--------------
	
    local html="<html><body>";
    
    --- Get Money
  if (farmed_options.money) then
        html = html .. "<h2>|cFF91D0F2" .. farmed_lang_money .. " |r";
        
        nmoney=GetMoney();
        ncopper = mod(nmoney,100);
        ngold = floor(nmoney/10000);
        nsilver=floor((nmoney-(ngold*10000))/100);
        
        html = html .. ngold .. "|cFFA88905g|r"..nsilver.."|cFF807979s|r"..ncopper.."|cFF966942c|r<br/><br/></h2>";
		
		--add line to data broker
		FarmedDBTooltip_AddLine("|cFF91D0F2" .. farmed_lang_money .. " |r"..
			ngold .. "|cFFA88905g|r"..nsilver.."|cFF807979s|r"..ncopper.."|cFF966942c|r","")
		--------------------------
        rowcount=rowcount+2;
  end
    
    --- Get Bag Slot Count and items 

        local totslots=0;
        local freeslots=0;
        local itemblock="";
        local itemcount=0;
        local il=nil;
        
        ----Count Up Free space
        
				
				
		for n= 0,NUM_BAG_SLOTS do
			local freeSlot, bagType = GetContainerNumFreeSlots(n);
			local bagSize = GetContainerNumSlots(n);
			
			totslots=totslots+bagSize;
			freeslots=freeslots+freeSlot;
		end
		
		
		if (farmed_options.slotcount) then
			html = html .. "<h2>|cFF91D0F2" .. farmed_lang_bags .. " |cFFFFF000";
			html = html .. freeslots .."/" .. totslots .. " |r</h2>";
			rowcount=rowcount+1;
			
			--add line to data broker
			FarmedDBTooltip_AddLine("|cFF91D0F2" .. farmed_lang_bags .. " |cFFFFF000"
					.. freeslots .."/" .. totslots .. " |r","")
					
			--------------------------
		
		end
		--Update DB Label
			UpdateDBlabel("|cFFFFF000".. freeslots .."/" .. totslots .. " |r");
		--------------------------
		
		
		--List BOE items
		 if (farmed_options.rare or farmed_options.uncommon) then
			
			html = html .. "<h3><br/>|cFF91D0F2" .. farmed_lang_items .. " " .. farmed_lang_gathered .. "|r</h3>";
			
			--add line to data broker
					FarmedDBTooltip_AddLine("|cFF91D0F2" .. farmed_lang_items .. " " .. farmed_lang_gathered .. "|r","")
						
			--------------------------
			---Check for items
					
        
	
			for n= 0,NUM_BAG_SLOTS do
				local slots = GetContainerNumSlots(n);
				totslots=totslots+slots;
				
				for f= 1,slots do
					il=GetContainerItemLink(n,f);
					if (il==nil) then
						freeslots=freeslots+1;
					else
						 FarmedScanningTooltip:ClearLines();
						FarmedScanningTooltip:SetBagItem(n,f);
						if ((FarmedScanningTooltipTextLeft2:GetText() ~= "Soulbound") and (FarmedScanningTooltipTextLeft2:GetText() 
											~= "Quest Item")) then
							local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, 
															itemEquipLoc, itemTexture = GetItemInfo(il);
							if (itemType~=nil) then 
								if (string.find(farmed_lang_ItemFilter, itemType) ~= nil) then
									if ((farmed_options.uncommon and itemRarity==2) or (farmed_options.rare and itemRarity>2)) then
										local r,g,b, colcode = GetItemQualityColor(itemRarity);
									   itemblock = itemblock .. "<P>|T"..itemTexture..":16|t<A href = 'B"..n..f.."'>" .. colcode .. itemName .. "|r</A></P>";
									   FarmedDBTooltip_AddLine("|T"..itemTexture..":16|t"..colcode .. itemName .. "|r","")
										 -- itemblock = itemblock .. "<p>"..itemLink.."</p>";
										itemcount=itemcount+1;
										if (strlen(itemName)>30) then
											itemcount=itemcount+1;
										end
									end
								end
							end
						end
					end
				end
			
			end
			
			if (itemcount>0) then
					
					html = html .. itemblock;
					rowcount=rowcount+itemcount+2;
			else
				FarmedDBTooltip_AddLine("|cffffffffNone|r","")
			end
            
        end
        
        
    --end

    --- Process List
    
    local resh, resc;
    
    if (farmed_options.ore) then
        resh, resc = farmed_checkbag(farmed_ore,farmed_lang_ore);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.meat) then
        resh, resc = farmed_checkbag(farmed_meat,farmed_lang_meat);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.herb) then
        resh, resc = farmed_checkbag(farmed_herb,farmed_lang_herb);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.element) then
        resh, resc = farmed_checkbag(farmed_element,farmed_lang_element);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.gems) then
        resh, resc = farmed_checkbag(farmed_gem,farmed_lang_gem);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.cloth) then
        resh, resc = farmed_checkbag(farmed_cloth,farmed_lang_cloth);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.leather) then
        resh, resc = farmed_checkbag(farmed_leather,farmed_lang_leather);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.other) then
        resh, resc = farmed_checkbag(farmed_other,farmed_lang_other);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
     if (farmed_options.enchanting) then
        resh, resc = farmed_checkbag(farmed_enchanting,farmed_lang_enchanting);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    
    if (farmed_options.consumable) then
        resh, resc = farmed_checkbag(farmed_consumable,farmed_lang_consumable);
        html = html ..resh;
        rowcount=rowcount+resc;
    end
    --Finish HTML
    
    html =html .."</body></html>";
    
   -- farmed_Message(html);
    
    farmed_write(html, rowcount)
end

function farmed_safehtml(str)
	str=string.gsub(str,"<","[");
	str=string.gsub(str,">","]");
	str=string.gsub(str,"/","\\");
	str=string.gsub(str,"&","+");

	
	return str;

end
function farmed_checkbag(typearray,typename)
    
    local htmlblock=""
    
    local has_title=false;
    local icount=0;
    local rc=0;
    if (typearray~=nil) then
        for index,value in ipairs(typearray) do 
            
            local icount=GetItemCount(value);
            if (icount >0) then
            
                local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(value);
            
                if (has_title==false) then
                    htmlblock = htmlblock .. "<h3><br/>|cFF91D0F2" .. farmed_safehtml(typename) .. " " .. farmed_lang_gathered .. "|r</h3>";
                    rc=rc+2;
                    has_title=true;
					
					--add line to data broker
					FarmedDBTooltip_AddLine("|cFF91D0F2" .. farmed_safehtml(typename) .. " " .. farmed_lang_gathered .. "|r","")
					--------------------------
                end
                
                 local r,g,b
                if (itemRarity==nil or itemRarity<0 or itemRarity>6) then
                    r=1;
                    g=0;
                    b=0;
                else
                    r,g,b, colcode = GetItemQualityColor(itemRarity);
                end
                
                htmlblock = htmlblock .. "<p>|T"..itemTexture..":16|t<A href='I"..value.."'>" .. colcode .. farmed_safehtml(itemName) .. "</A>: |cFFFFF000" .. icount .." |r</p>";
                rc=rc+1;
                --add line to data broker
					FarmedDBTooltip_AddLine("|T"..itemTexture..":16|t"
									..colcode .. farmed_safehtml(itemName).."|r","|cFFFFF000" .. icount .." |r")
				--------------------------
				
				
                --farmed_Message(htmlblock);
            end
        end
    end
    return htmlblock, rc;
end



--Event Management
function farmed_showitem(citem)
        GameTooltip_SetDefaultAnchor(GameTooltip, Farmed);
       --farmed_Message("link clicked:" .. citem);
        
       
        
        if (strsub(citem,1,1)=="B") then
            local nbag = tonumber(strsub(citem,2,2));
            local nslot= tonumber(strsub(citem,3));
            --farmed_Message("link clicked:B=" .. nbag..", S="..nslot);
            
            ---local il=GetContainerItemLink(nbag,nslot);
            
            GameTooltip:SetBagItem(nbag,nslot);
            GameTooltip:Show();
            --GameTooltip:SetBagItem(nbag, nslot);
        else
            nitem = tonumber(strsub(citem,2));
            local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture = GetItemInfo(nitem);
              for n= 0,NUM_BAG_SLOTS do
                local slots = GetContainerNumSlots(n);
                for f= 1,slots do
                    il=GetContainerItemLink(n,f);
                    if (il~=nil) then
                        spos = string.find(il,"Hitem:",1);
                        epos = string.find(il,":",spos+7);
                        
                        --farmed_Message(strsub(il,spos+6,epos-1) .. " -> " .. nitem);
                        
                        if (nitem == tonumber(strsub(il,spos+6,epos-1))) then
                            GameTooltip:SetBagItem(n,f);
                            GameTooltip:Show();
                        end
                        
                    end
                end
            end
                        
             --GameTooltip:SetHyperlink(itemLink);
        end
        
end

function farmed_event()
    if (event=="ADDON_LOADED") then
        
         farmed_buildlist();
		 farmed_gen();
            
        
        
        
    elseif (event=="VARIABLES_LOADED") then
            if (farmed_options.show==false) then
                farmed_hide();
            end
        
        
           
            
            ---Init Option Dlg
            FarmedOptions_show:SetChecked(farmed_options.show);
            FarmedOptions_money:SetChecked(farmed_options.money);
            FarmedOptions_bags:SetChecked(farmed_options.slotcount);
            FarmedOptions_uncommon:SetChecked(farmed_options.uncommon);
            FarmedOptions_rare:SetChecked(farmed_options.rare);
            FarmedOptions_ore:SetChecked(farmed_options.ore);
            FarmedOptions_herb:SetChecked(farmed_options.herb);
            FarmedOptions_element:SetChecked(farmed_options.element);
            FarmedOptions_meat:SetChecked(farmed_options.meat);
            FarmedOptions_gems:SetChecked(farmed_options.gems);
            FarmedOptions_cloth:SetChecked(farmed_options.cloth);
            FarmedOptions_leather:SetChecked(farmed_options.leather);
            FarmedOptions_other:SetChecked(farmed_options.other);
            FarmedOptions_enchanting:SetChecked(farmed_options.enchanting);
            FarmedOptions_consumable:SetChecked(farmed_options.consumable);
			FarmedOptions_announce:SetChecked(farmed_options.announce);
			FarmedOptions_announcechat:SetChecked(farmed_options.announcechat);
            
            FarmedOptions_Sect1:SetText(farmed_opt_general);
            FarmedOptions_Sect101:SetText(farmed_opt_show);
            FarmedOptions_Sect102:SetText(farmed_opt_money);
            FarmedOptions_Sect103:SetText(farmed_opt_bags);
            
            FarmedOptions_Sect2:SetText(farmed_opt_items);
            FarmedOptions_Sect201:SetText(farmed_opt_uncommon);
            FarmedOptions_Sect202:SetText(farmed_opt_rare);
            
            FarmedOptions_Sect3:SetText(farmed_opt_materials);
            FarmedOptions_Sect301:SetText(farmed_opt_ore);
            FarmedOptions_Sect302:SetText(farmed_opt_meat);
            FarmedOptions_Sect303:SetText(farmed_opt_herbs);
            FarmedOptions_Sect304:SetText(farmed_opt_elements);
            FarmedOptions_Sect305:SetText(farmed_opt_gems);
            FarmedOptions_Sect306:SetText(farmed_opt_cloth);
            FarmedOptions_Sect307:SetText(farmed_opt_leather);
            FarmedOptions_Sect308:SetText(farmed_opt_enchanting);
            FarmedOptions_Sect309:SetText(farmed_opt_other);
            FarmedOptions_Sect310:SetText(farmed_opt_consumable);
			FarmedOptions_Sect311:SetText(farmed_opt_announce);
			FarmedOptions_Sect312:SetText(farmed_opt_announcechat);
			
			farmed_gen();
			
    elseif (event=="BAG_UPDATE") then
        
        farmed_gen();
        
   -- elseif (event=="ITEM_LOCK_CHANGED") then
        
        
       -- if (arg2==nil or arg1==nil) then -- An errro slot
        --    return;
       -- end
       -- if (arg1<1 or arg1>NUM_BAG_SLOTS) then --not in bags
		--		return;
		--end
        
        --Add  to list?
       -- il=GetContainerItemLink(arg1,arg2);
        --farmed_addtolist(il);
        
        --farmed_gen();
    
    
    elseif (event=="CHAT_MSG_LOOT") then
		
		--farmed_Message("Looting")
		local lootmsg=arg1
		local _, _, sPlayer, itemlink = string.find(lootmsg, LOOT_REGEX)
		if not sPlayer then _, _, itemlink = string.find(lootmsg, LOOT_SELF_REGEX) end
		if not itemlink then return end
		local _, _, itemId = string.find(itemlink, "item:(%d+):")
		
		local itemName, itemLink, itemRarity, itemLevel, itemMinLevel, itemType, itemSubType, itemStackCount, itemEquipLoc, itemTexture
							= GetItemInfo(itemId);
							
		local icount=GetItemCount(itemId);
		if (icount>0 and farmed_isListable(itemId) and not sPlayer) then
		
			if farmed_options.announcechat then farmed_Message("Farmed "..icount.." "..itemLink.."!") end;
			if farmed_options.announce then UIErrorsFrame:AddMessage("Farmed "..icount.." "..itemLink.."!", 1, 1, 1, 53, 5) end;
		end
	
    elseif (event=="LOOT_OPENED") then
		for n=1,GetNumLootItems() do
			if (LootSlotIsItem(n)) then
				il=GetLootSlotLink(n);
				farmed_addtolist(il);
			end
		end
		
		farmed_gen();
		
		
		
	end

end
