EForager = LibStub("AceAddon-3.0"):NewAddon("EForager", "AceHook-3.0", "AceTimer-3.0")

local EForagerAlreadyCalled = false
local EquippedGlovesID = 1
local EForagerDisabled = true
local EForagerMining = false
local EForagerSkinning = false
local EForagerHerbalism = false
local EForagerHasGloves = false
local EForagerArchaelogy = false
local EForagerArchaelogySurveyString = ""
local DebugSkinningCombatTimerSet = false

EForagerDebugString = "Empty"

-- Changelog
-- =========
-- 1.2r - 30th June 2014 (Possibly the Finale Release)
--  Now only announces details of how to obtain the Gloves on first login per character.
--  Fixed bug on Characters without any Professions.
-- 1.1.5r - 17th April 2014
--  Minor Archive Fix and Localization Fix.
-- 1.1.4r - 6th March 2014
--  Fixed French Mining and German Herbalism problems.
-- 1.1.3r - 18th February 2014
--  Fixed bug that occurred if a character did not have a secondary profession.
-- 1.1.2r - 11th February 2014
--	Reduced the delay between re-equipping of Primary Gloves when Skinning to 3 seconds.
-- 1.1.1r - 9th February 2014
--  Removed 1 line of Debug Code that I missed when publishing last update. This was the reason you
--   would have seen 1 or 0 each time the gloves were equipped.
-- 1.1.0r - 6th February 2014
--   Equip/Un-equip Sound is now Suppressed.
--   enES Fixes for Mining and Herbalism.
-- 1.0.5r - 6th February 2014
--   Skinning Fix for ElvUI which removed the word Corpse from Skinnable Corpses Tooltip Data, breaking addon function
-- 1.0.4r - 6th February 2014
--   More tweaks to the code to improve reliability
--	 Re-equipping of Gloves bug-fixes, this should hopefully fix the issues with skinning
--   This Build Contains more Warnings than normal, in attempt to help fix any remaining bugs.
-- 1.0.3r - 6th January 2014
--   Tweaked Re-equipping of Main Gloves Logic to fix Skinning issues.
--   Addon once again only run's in Pandaria Zones.
-- 1.0.2r - 2nd January 2014
-- ~ Tweaked Archaeology Re-equip Original Gloves Timer for better responsiveness
-- ~ Fixed Rare Unforeseen Consequence of Unpopulated Local Item Database after login.
--   Thanks go to Islandic for alerting me to this issue and giving me enough information to debug it.
-- 1.0.1r - 2nd January 2014
-- ~ Happy New Year To All!!
-- ~ Added Localizations! All languages are supported for most actions. This also resolves the issues from the initial version that have been mentioned in Comments.
-- ~ Fully Supported Languages: German, English, French, Spanish, Russian and Portuguese
-- ~ I am lacking localization data for Korean and Chinese on Mining (And Sha-Touched Herb) Matching. This is not something I can resolve without someone who plays in these regions contacting me to help with localization.
-- ~ Added Archaeology Survey Auto-equip! Survey Cast time down to 0.5sec from 1sec!
-- 1.0.0r - 24th December 2013
-- ~ Initial Release

local EFframe = CreateFrame("FRAME");
EFframe:RegisterEvent("PLAYER_LOGOUT");
EFframe:RegisterEvent("ADDON_LOADED");


function EFframe:OnEvent(event, arg)
	if event == "ADDON_LOADED" and arg == "EquippedForager" then
		print("EquippedForager v1.2r Loaded")
		if EFFirstRun == nil then
			EFFirstRun = true;
		end
	elseif event == "PLAYER_LOGOUT" then
		EFFirstRun = false;
	end
end

EFframe:SetScript("OnEvent", EFframe.OnEvent);

function EForager:OnEnable()
	-- Slightly Defunct Now, migrate next version.
	-- Enable Timer Event to give WoW Time to Finish Loading
	-- Why Do I use this? A part from needing WoW's internal Item Database Populated, it also means addon text is displayed after other addon spam!
		self:ScheduleTimer("WelcomeTimer", 3)
end

-- Manual Locale Translations for Objects not available through internal-lookup's

function EForager:GetGhostIronDepositString()
	if (GetLocale() == "enUS") then
		return("Ghost Iron Deposit")
	elseif (GetLocale() == "deDE") then
		return("Geistereisenvorkommen")
	elseif (GetLocale() == "esES") then
		return("Depósito de hierro fantasma")
	elseif (GetLocale() == "esMX") then
		return("Depósito de hierro fantasma")
	elseif (GetLocale() == "frFR") then
		return("Gisement d’ectofer")
	elseif (GetLocale() == "ptBR") then
		return("Depósito de Ferro Fantasma")
	elseif (GetLocale() == "ruRU") then
		return("Залежи призрачного железа")
	else
		return("Ghost Iron Deposit")
	end
end

function EForager:GetRichGhostIronDepositString()
	if (GetLocale() == "enUS") then
		return("Rich Ghost Iron Deposit")
	elseif (GetLocale() == "deDE") then
		return("Reiches Geistereisenvorkommen")
	elseif (GetLocale() == "esES") then
		return("Depósito de hierro fantasma rico")
	elseif (GetLocale() == "esMX") then
		return("Depósito de hierro fantasma rico")
	elseif (GetLocale() == "frFR") then
		return("Riche gisement d’ectofer")
	elseif (GetLocale() == "ptBR") then
		return("Depósito Repleto de Ferro Fantasma")
	elseif (GetLocale() == "ruRU") then
		return("Богатые залежи призрачного железа")
	else
		return("Rich Ghost Iron Deposit")
	end
end

function EForager:GetTrilliumVeinString()
	if (GetLocale() == "enUS") then
		return("Trillium Vein")
	elseif (GetLocale() == "deDE") then
		return("Trilliumader")
	elseif (GetLocale() == "esES") then
		return("Filón de trillium")
	elseif (GetLocale() == "esMX") then
		return("Filón de trillium")
	elseif (GetLocale() == "frFR") then
		return("Filon de trillium")
	elseif (GetLocale() == "ptBR") then
		return("Veio de Tríllio")
	elseif (GetLocale() == "ruRU") then
		return("Триллиевая жила")
	else
		return("Trillium Vein")
	end
end

function EForager:GetRichTrilliumVeinString()
	if (GetLocale() == "enUS") then
		return("Rich Trillium Vein")
	elseif (GetLocale() == "deDE") then
		return("Reiche Trilliumader")
	elseif (GetLocale() == "esES") then
		return("Filón de trillium enriquecido")
	elseif (GetLocale() == "esMX") then
		return("Filón de trillium enriquecido")
	elseif (GetLocale() == "frFR") then
		return("Riche filon de trillium")
	elseif (GetLocale() == "ptBR") then
		return("Veio Repleto de Tríllio")
	elseif (GetLocale() == "ruRU") then
		return("Богатая триллиевая жила")
	else
		return("Rich Trillium Vein")
	end
end

function EForager:GetKypariteDepositString()
	if (GetLocale() == "enUS") then
		return("Kyparite Deposit")
	elseif (GetLocale() == "deDE") then
		return("Kyparitvorkommen")
	elseif (GetLocale() == "esES") then
		return("Depósito de kyparita")
	elseif (GetLocale() == "esMX") then
		return("Depósito de kyparita")
	elseif (GetLocale() == "frFR") then
		return("Gisement de kyparite")
	elseif (GetLocale() == "ptBR") then
		return("Depósito de Kyparita")
	elseif (GetLocale() == "ruRU") then
		return("Залежи кипарита")
	else
		return("Kyparite Deposit")
	end
end

function EForager:GetRichKypariteDepositString()
	if (GetLocale() == "enUS") then
		return("Rich Kyparite Deposit")
	elseif (GetLocale() == "deDE") then
		return("Reiches Kyparitvorkommen")
	elseif (GetLocale() == "esES") then
		return("Depósito de kyparita rico")
	elseif (GetLocale() == "esMX") then
		return("Depósito de kyparita rico")
	elseif (GetLocale() == "frFR") then
		return("Riche gisement de kyparite")
	elseif (GetLocale() == "ptBR") then
		return("Depósito Rico em Kyparita")
	elseif (GetLocale() == "ruRU") then
		return("Богатые залежи кипарита")
	else
		return("Rich Kyparite Deposit")
	end
end

function EForager:GetShaTouchedHerbString()
	if (GetLocale() == "enUS") then
		return("Sha-Touched Herb")
	elseif (GetLocale() == "deDE") then
		return("Sha-berührtes Kraut")
	elseif (GetLocale() == "esES") then
		return("Hierba influenciada por el sha")
	elseif (GetLocale() == "esMX") then
		return("Hierba influenciada por el sha")
	elseif (GetLocale() == "frFR") then
		return("Plante touchée par les sha")
	elseif (GetLocale() == "ptBR") then
		return("Planta Tocada pelo Sha")
	elseif (GetLocale() == "ruRU") then
		return("Пораженная ша трава")
	else
		return("Sha-Touched Herb")
	end
end

function EForager:GetItemName(ItemID)
	local TempGettingItemName, TempGettingItemItemLink, TempGettingItemRarity, TempGettingItemiLvl, TempGettingItemRequiredLevel, TempGettingItemType, TempGettingItemSubType, TempGettingItemMaxStack, TempGettingItemEquipLocation, TempGettingItemIcon, TempGettingItemVendorSellPrice = GetItemInfo(ItemID)
	return(TempGettingItemName)
end

function EForager:EFOnUpdate(frame)
	if GetCurrentMapContinent() == 6 then
		if GameTooltip:GetOwner() ~= Minimap then
			local ArchyMatch = false
			local SkinningMatch = false
			local Typetext = GameTooltipTextLeft2:GetText()
			if Typetext == nil then
				Typetext = ""
			end
			local text = GameTooltipTextLeft1:GetText()
			local PositiveToolTipMatch = false
			-- Warn about being unable to equip due to combat
			if InCombatLockdown() == 1 then
				if EForagerSkinning == true then
					local Skinningtext = GameTooltipTextLeft3:GetText()
					if Skinningtext == nil then
						Skinningtext = ""
					end
					if string.match(Skinningtext, getglobal("UNIT_SKINNABLE_LEATHER")) then	
						if DebugSkinningCombatTimerSet == false then
							DebugSkinningCombatTimerSet = true
							self:ScheduleTimer("SkinningWarningTimer", 1)
						end
					end
				end
			end
			if InCombatLockdown() == nil then
				if EForagerAlreadyCalled == false then
					-- Check for Archaeology
					if EForagerArchaelogy == true then
						if string.match(text, EForagerArchaelogySurveyString) then
							ArchyMatch = true
							PositiveToolTipMatch = true
						end
					end
					
					-- Run Through Mining Possible Matches
					if EForagerMining == true then
						if (GetLocale() == "esES") then
							-- Fix for Blizzard's Typo on GetGlobal
							SkinnableRock = "Requiere Minería"
						elseif (GetLocale() == "frFR") then
							-- Fix for Blizzard's Typo on GetGlobal
							SkinnableRock = "Requiert Minage"
						else
							SkinnableRock = getglobal("UNIT_SKINNABLE_ROCK")
						end						
						if string.match(Typetext, SkinnableRock) then
							if string.match(text, EForager:GetGhostIronDepositString()) then
								PositiveToolTipMatch = true
							end
							if string.match(text, EForager:GetRichGhostIronDepositString()) then
								PositiveToolTipMatch = true
							end
							if string.match(text, EForager:GetTrilliumVeinString()) then
								PositiveToolTipMatch = true
							end						
							if string.match(text, EForager:GetRichTrilliumVeinString()) then
								PositiveToolTipMatch = true
							end
							if string.match(text, EForager:GetKypariteDepositString()) then
								PositiveToolTipMatch = true
							end
							if string.match(text, EForager:GetRichKypariteDepositString()) then
								PositiveToolTipMatch = true
							end
							
						end
					end
					-- Run Through Herbalism Possible Matches
					if EForagerHerbalism == true then
						if (GetLocale() == "esES") then
							-- Fix for Blizzard's Typo on GetGlobal
							SkinnableHerb = "Requiere Herboristería"
						elseif (GetLocale() == "deDE") then
							-- Fix for Blizzard's Typo on GetGlobal
							SkinnableHerb = "Benötigt Kräuterkunde"
						else
							SkinnableHerb = getglobal("UNIT_SKINNABLE_HERB")
						end	
						if string.match(Typetext, SkinnableHerb) then
							-- Fool's Cap
							if string.match(text, EForager:GetItemName(79011)) then
								PositiveToolTipMatch = true
							end
							-- Golden Lotus
							if string.match(text, EForager:GetItemName(72238)) then
								PositiveToolTipMatch = true
							end
							-- Green Tea Leaf
							if string.match(text, EForager:GetItemName(72234)) then
								PositiveToolTipMatch = true
							end
							-- Rain Poppy
							if string.match(text, EForager:GetItemName(72237)) then
								PositiveToolTipMatch = true
							end
							-- Sha-Touched Herb
							if string.match(text, EForager:GetShaTouchedHerbString()) then
								PositiveToolTipMatch = true
							end
							-- Silkweed
							if string.match(text, EForager:GetItemName(72235)) then
								PositiveToolTipMatch = true
							end
							-- Snow Lilly
							if string.match(text, EForager:GetItemName(79010)) then
								PositiveToolTipMatch = true
							end
						end
					end
					-- Run through Skinning Possible Matches
					if EForagerSkinning == true then
						local Skinningtext = GameTooltipTextLeft3:GetText()
						if Skinningtext == nil then
							Skinningtext = ""
						end
						if string.match(Skinningtext, getglobal("UNIT_SKINNABLE_LEATHER")) then	
							PositiveToolTipMatch = true
							SkinningMatch = true
						end
					end
							
					if PositiveToolTipMatch == true then
						EForagerAlreadyCalled = true
						if GetInventoryItemID("player", 10) == 86566 then
							-- Null
						else			
							EquippedGlovesID = GetInventoryItemID("player", 10)
							if GetCVar("Sound_EnableSFX") == "1" then
								ReenableSound = true
								SetCVar("Sound_EnableSFX",0)
							end
							EquipItemByName(86566)	
							if ReenableSound == true then
								SetCVar("Sound_EnableSFX",1)
								ReenableSound = false
							end
						end
						if ArchyMatch == true then
							self:CancelAllTimers()
							self:ScheduleTimer("ResetTimer", 9)
						else
							self:CancelAllTimers()
							self:ScheduleTimer("ResetTimer", 5)
						end
					end
				else
					if EForagerArchaelogy == true then
						if string.match(text, EForagerArchaelogySurveyString) then
							ArchyMatch = true
							PositiveToolTipMatch = true
						end
					end
					
					-- Run Through Mining Possible Matches
					if EForagerMining == true then
						if (GetLocale() == "esES") then
							-- Fix for Blizzard's Typo on GetGlobal
							SkinnableRock = "Requiere Minería"
						elseif (GetLocale() == "frFR") then
							-- Fix for Blizzard's Typo on GetGlobal
							SkinnableRock = "Requiert Minage"
						else
							SkinnableRock = getglobal("UNIT_SKINNABLE_ROCK")
						end						
						if string.match(Typetext, SkinnableRock) then
							if string.match(text, EForager:GetGhostIronDepositString()) then
								PositiveToolTipMatch = true
							end
							if string.match(text, EForager:GetRichGhostIronDepositString()) then
								PositiveToolTipMatch = true
							end
							if string.match(text, EForager:GetTrilliumVeinString()) then
								PositiveToolTipMatch = true
							end						
							if string.match(text, EForager:GetRichTrilliumVeinString()) then
								PositiveToolTipMatch = true
							end
							if string.match(text, EForager:GetKypariteDepositString()) then
								PositiveToolTipMatch = true
							end
							if string.match(text, EForager:GetRichKypariteDepositString()) then
								PositiveToolTipMatch = true
							end
							
						end
					end
					-- Run Through Herbalism Possible Matches
					if EForagerHerbalism == true then
						if (GetLocale() == "esES") then
							-- Fix for Blizzard's Typo on GetGlobal
							SkinnableHerb = "Requiere Herboristería"
						elseif (GetLocale() == "deDE") then
							-- Fix for Blizzard's Typo on GetGlobal
							SkinnableHerb = "Benötigt Kräuterkunde"
						else
							SkinnableHerb = getglobal("UNIT_SKINNABLE_HERB")
						end	
						if string.match(Typetext, SkinnableHerb) then
							-- Fool's Cap
							if string.match(text, EForager:GetItemName(79011)) then
								PositiveToolTipMatch = true
							end
							-- Golden Lotus
							if string.match(text, EForager:GetItemName(72238)) then
								PositiveToolTipMatch = true
							end
							-- Green Tea Leaf
							if string.match(text, EForager:GetItemName(72234)) then
								PositiveToolTipMatch = true
							end
							-- Rain Poppy
							if string.match(text, EForager:GetItemName(72237)) then
								PositiveToolTipMatch = true
							end
							-- Sha-Touched Herb
							if string.match(text, EForager:GetShaTouchedHerbString()) then
								PositiveToolTipMatch = true
							end
							-- Silkweed
							if string.match(text, EForager:GetItemName(72235)) then
								PositiveToolTipMatch = true
							end
							-- Snow Lilly
							if string.match(text, EForager:GetItemName(79010)) then
								PositiveToolTipMatch = true
							end
						end
					end
					-- Run through Skinning Possible Matches
					if EForagerSkinning == true then
						local Skinningtext = GameTooltipTextLeft3:GetText()
						if Skinningtext == nil then
							Skinningtext = ""
						end
						if string.match(Skinningtext, getglobal("UNIT_SKINNABLE_LEATHER")) then	
							PositiveToolTipMatch = true
							SkinningMatch = true
						end
					end
							
					if PositiveToolTipMatch == true then
						if ArchyMatch == true then
							self:CancelAllTimers()
							self:ScheduleTimer("ResetTimer", 9)
						elseif SkinningMatch == true then
							self:CancelAllTimers()
							self:ScheduleTimer("ResetTimer", 3)
						else
							self:CancelAllTimers()
							self:ScheduleTimer("ResetTimer", 5)
						end
					end
				end
			end
		end
	end
end

function EForager:ResetTimer()
	if InCombatLockdown() == nil then
		EForagerAlreadyCalled = false
		if GetCVar("Sound_EnableSFX") == "1" then
			ReenableSound = true
			SetCVar("Sound_EnableSFX",0)
		end
		EquipItemByName(EquippedGlovesID)
		if ReenableSound == true then
			SetCVar("Sound_EnableSFX",1)
			ReenableSound = false
		end
	else
		self:ScheduleTimer("ResetTimer", 1)
	end
end

function EForager:SkinningWarningTimer()
	DebugSkinningCombatTimerSet = false
	print("EquippedForager: Debug Warning, Can Not Equip while In-Combat Lockdown")
end

function EForager:DebugAdd(StringToAdd)
	if EForagerDebugString == "Empty" then
		EForagerDebugString = "" .. StringToAdd
	else
		EForagerDebugString = EForagerDebugString .. StringToAdd
	end
	return
end

function EForager:WelcomeTimer()
	-- Main Initialization
	EForager:DebugAdd(GetLocale())
	
	local RerunTimer = false
	local FirstProfession, SecondProfession, Archy, Fishing, Cooking, FirstAid = GetProfessions("player")
	
	-- Grab Data for Foragers Gloves
	ForagersGlovesName, ForagersGlovesItemLink, ForagersGlovesRarity, ForagersGlovesiLvl, ForagersGlovesRequiredLevel, ForagersGlovesType, ForagersGlovesSubType, ForagersGlovesMaxStack, ForagersGlovesEquipLocation, ForagersGlovesIcon, ForagersGlovesVendorSellPrice = GetItemInfo(86566)	
	
	if ForagersGlovesName == nil then
		self:ScheduleTimer("WelcomeTimer", 3)
		EForager:DebugAdd("Delay on requesting Foragers Gloves Item Details, Rescheduled Event")
		print("Equipped Forager: Runtime Delayed due to Unpopulated Local Database, will re-init in 3 seconds")
		RerunTimer = true
		return
	end
	
	if FirstProfession ~= nil then 
		if GetProfessionInfo(FirstProfession) == nil then
			self:ScheduleTimer("WelcomeTimer", 3)
			EForager:DebugAdd("Delay on requesting Profession Details, Rescheduled Event")
			print("Equipped Forager: Runtime Delayed due to Unpopulated Local Database, will re-init in 3 seconds")
			RerunTimer = true
		else
			if FirstProfession == nil then
				EForager:DebugAdd("Nill")
			else
				local FirstProfessionName, FirstProfessionIcon, FirstProfessionSkillLevel, FirstProfessionMaxSkill, FirstProfessionAbilities, FirstProfessionOffset, FirstProfessionSkillLine, FirstProfessionSkillModifier = GetProfessionInfo(FirstProfession)
				EForager:DebugAdd(FirstProfessionName)
				EForager:DebugAdd(FirstProfessionSkillLine)
				if FirstProfessionSkillLine == 186 then
					EForagerMining = true
					EForagerDisabled = false
				elseif FirstProfessionSkillLine == 182 then
					EForagerHerbalism = true
					EForagerDisabled = false
				elseif FirstProfessionSkillLine == 393 then
					EForagerSkinning = true
					EForagerDisabled = false				
				end
			end
		end
			
			if SecondProfession == nil then
				EForager:DebugAdd("Nill")
			else
				local SecondProfessionName, SecondProfessionIcon, SecondProfessionSkillLevel, SecondProfessionMaxSkill, SecondProfessionAbilities, SecondProfessionOffset, SecondProfessionSkillLine, SecondProfessionSkillModifier = GetProfessionInfo(SecondProfession)
				EForager:DebugAdd(SecondProfessionName)
				EForager:DebugAdd(SecondProfessionSkillLine)
				if SecondProfessionSkillLine == 186 then
					EForagerMining = true
					EForagerDisabled = false
				elseif SecondProfessionSkillLine == 182 then
					EForagerHerbalism = true
					EForagerDisabled = false
				elseif SecondProfessionSkillLine == 393 then
					EForagerSkinning = true
					EForagerDisabled = false				
				end
			end
		
		if Archy == nil then
			EForagerArchaelogy = false
		else
			local ArchyName, ArchyRank, ArchyIcon, ArchyCost, ArchyFunnel, ArchyType, ArchyCastTime, ArchyMinRange, ArchyMaxRange = GetSpellInfo(80451)
			EForagerArchaelogySurveyString = ArchyName
			EForagerArchaelogy = true
			EForagerDisabled = false
		end
	else
		print("Equipped Forager: Disabled due to No Professions on Character.")
		EForagerDisabled = true
		EForager:DebugAdd("Disabled due to 0 Professions")	
	end

	if RerunTimer == false then
		if UnitLevel("player") < 85 then
			EForagerDisabled = true
			EForager:DebugAdd("Disabled as the current character is under Level 85")
			
		end
		EForager:DebugAdd(UnitName("player"))
		
		-- Check Bag's for the Gloves
		for bag = 0,4 do
			for slot = 1,GetContainerNumSlots(bag) do
				local item = GetContainerItemLink(bag,slot)
				if item and item:find(ForagersGlovesName) then
					EForagerHasGloves = true
				end
			end
		end
		
		if EForagerHasGloves == false then		
			EForager:DebugAdd("No Gloves")
			EForagerDisabled = true
			if EFFirstRun == true then
				print("Equipped Forager: " .. ForagersGlovesItemLink.. " could not be found in your bags.")
				print("Equipped Forager: If you have the Gloves stored in your Bank/Void Storage you need to withdraw them to your main bags for them to be usable by Equipped Forager.")
				print("Equipped Forager: You can get the gloves from killing Burning Berserker's on Timeless Isle or from the Kun-Lai Rare Korda Torros.")
				print("Equipped Forager: You can get more information on how to obtain the gloves at http://www.wowhead.com/item=86566")
				print("Equipped Forager: This Message will only display once per character.")				
			end
		end
		
		if EForagerDisabled == false then
			EForager:DebugAdd("All Good")
			self:HookScript(GameTooltip, "OnUpdate", "EFOnUpdate")
			print("Equipped Forager: Is now automatically equipping " .. ForagersGlovesItemLink .. " as required.")
		end
	end
end
