--Gui for EpicMusicPlayer  by yess

local playerframe;
local guitext;
local timeframe
local timeframewidth = 1
local timeframestep = 0
local exchangecount = 0
local displaysong = true;
local songlength;
local currartist 
local currsongname

local volumechanged = false
local tooltip = nil
local hasartist = false;

EpicMusicPlayerGui = LibStub("AceAddon-3.0"):NewAddon("EpicMusicPlayerGui", "AceEvent-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("EpicMusicPlayer")

local options={
			name=L["Gui"],
			order = 4,
			type="group",
			args={
				showgui = {
			           type = "toggle",
			           order = 1,
					   name = L["Show Gui"],
			           desc = L["Toggle show gui"],
			           get = function(name)
							return EpicMusicPlayer:IsPlayerGui()
					   end,
					   set = function(name)
							EpicMusicPlayer:TogglePlayerGui()
						end,
			       },
				minimap = {
			           type = "toggle",
			           order = 2,
					   name = L["Minimap Button"],
			           desc = L["Toggle show minimap button"],
			           get = function(name)
							return EpicMusicPlayer:IsMinimap()
					   end,
					   set = function(name)
							EpicMusicPlayer:ToggleMinimap()
						end,
			     },
				 scale = {
		            type = 'range',
					order = 3,
					name = L["Gui Size"],
		            desc = L["Adjust the size of the gui"],
		            step = 0.1,
					min = 0.1,
					max = 5,
					get = function() 
						return EMPGUI:GetScale()
					end,
		            set =  function(info,val) 
						EpicMusicPlayer.db.char.guiscale = val
						EMPGUI:SetScale(val)
					end,
				},
				useartiscolour = {
			           type = "toggle",
			           order = 4,
					   name = L["Use artist colour"],
			           desc = L["Use artist colour as button colour"],
			           get = function(name)
							return EpicMusicPlayer.db.profile.useartistcolour
					   end,
					   set = function(name)
							EpicMusicPlayer.db.profile.useartistcolour = not EpicMusicPlayer.db.profile.useartistcolour
							if(EpicMusicPlayer.db.profile.useartistcolour)then
								EpicMusicPlayer.db.profile.buttoncolour.r = EpicMusicPlayer.db.profile.artistcolour.r
								EpicMusicPlayer.db.profile.buttoncolour.g = EpicMusicPlayer.db.profile.artistcolour.g
								EpicMusicPlayer.db.profile.buttoncolour.b = EpicMusicPlayer.db.profile.artistcolour.b
								EpicMusicPlayer.db.profile.buttoncolour.a = EpicMusicPlayer.db.profile.artistcolour.a
								EpicMusicPlayerGui:UpdateFrame(EpicMusicPlayer)
							end
						end,
			     },
				buttoncolour = {
							type = "color",
							order = 5,
							name = L["Button color"],
							desc = L["Button color"],
							hasAlpha = true,
							get = function(info)
								local r = EpicMusicPlayer.db.profile.buttoncolour.r
								local g = EpicMusicPlayer.db.profile.buttoncolour.g
								local b = EpicMusicPlayer.db.profile.buttoncolour.b
								local a = EpicMusicPlayer.db.profile.buttoncolour.a
								return r, g, b, a
							end,
							set = function(info, r, g, b, a)
								EpicMusicPlayer.db.profile.buttoncolour.r = r
								EpicMusicPlayer.db.profile.buttoncolour.g = g
								EpicMusicPlayer.db.profile.buttoncolour.b = b
								EpicMusicPlayer.db.profile.buttoncolour.a = a
								--update gui
								EpicMusicPlayer.db.profile.useartistcolour = false
								EpicMusicPlayerGui:UpdateFrame(EpicMusicPlayer)
							end
						},
				backcolour = {
							type = "color",
							order = 6,
							name = L["Background color"],
							desc = L["Background color"],
							hasAlpha = true,
							get = function(info)
								local r = EpicMusicPlayer.db.profile.backcolour.r
								local g = EpicMusicPlayer.db.profile.backcolour.g
								local b = EpicMusicPlayer.db.profile.backcolour.b
								local a = EpicMusicPlayer.db.profile.backcolour.a
								return r, g, b, a
							end,
							set = function(info, r, g, b, a)
								EpicMusicPlayer.db.profile.backcolour.r = r
								EpicMusicPlayer.db.profile.backcolour.g = g
								EpicMusicPlayer.db.profile.backcolour.b = b
								EpicMusicPlayer.db.profile.backcolour.a = a
								--update gui
								if(EpicMusicPlayerGui)then
									EpicMusicPlayerGui:UpdateFrame(EpicMusicPlayer)
								end
							end
						},
				bordercolour = {
							type = "color",
							order = 7,
							name = L["Border color"],
							desc = L["Border color"],
							hasAlpha = true,
							get = function(info)
								local r = EpicMusicPlayer.db.profile.bordercolour.r
								local g = EpicMusicPlayer.db.profile.bordercolour.g
								local b = EpicMusicPlayer.db.profile.bordercolour.b
								local a = EpicMusicPlayer.db.profile.bordercolour.a
								return r, g, b, a
							end,
							set = function(info, r, g, b, a)
								EpicMusicPlayer.db.profile.bordercolour.r = r
								EpicMusicPlayer.db.profile.bordercolour.g = g
								EpicMusicPlayer.db.profile.bordercolour.b = b
								EpicMusicPlayer.db.profile.bordercolour.a = a
								--update gui
								if(EpicMusicPlayerGui)then
									EpicMusicPlayerGui:UpdateFrame(EpicMusicPlayer)
								end
							end
						},
				strata = {
					type = 'select',
					values = {FULLSCREEN_DIALOG="Fullscreen_Dialog",FULLSCREEN="Fullscreen", 
								DIALOG="Dialog",HIGH="High",MEDIUM="Medium",LOW="Low",BACKGROUND="Background"},
					order = 7,
					name = L["Frame strata"],
					desc = L["Frame strata"],
					get = function() 
						return EpicMusicPlayer.db.profile.guistrata
					end,
					set = function(info, value)
						EpicMusicPlayer.db.profile.guistrata = value
						playerframe:SetFrameStrata(value)
					end,
				},
			}
	}

function EpicMusicPlayerGui:OnInitialize()
	if(EMPGUI == nil)then
		self:CreateGuiFrame()
	end
	
	if(EpicMusicPlayer.db.profile.minimapbutton)then
		EpicMusicPlayerGui:CreateMinimapButton()
	end

	self:RegisterMessage("EMPUpdateStop")
	self:RegisterMessage("EMPUpdatePlay")
	self:RegisterMessage("EMPUpdateTime")
	self:RegisterMessage("EMPUpdateVolume")
	self:RegisterMessage("EMPUpdateRandom")
	EpicMusicPlayer:AddOptions("gui",options)
end

function EpicMusicPlayerGui:OnEnable(first)	
	if(EMPGUI == nil)then
		self:CreateGuiFrame()
	end
	self:RegisterMessage("EMPUpdateStop")
	self:RegisterMessage("EMPUpdatePlay")
	self:RegisterMessage("EMPUpdateTime")
	self:RegisterMessage("EMPUpdateRandom")
	
	self:SendMessage("EMPGuiLoaded")
	
end

function EpicMusicPlayerGui:OnDisable()
    playerframe:Hide();
	EMPGUI = nil
	self:UnregisterAllEvents("EpicMusicPlayerGui")
end

function EpicMusicPlayerGui:ToggleMinimap()
	if(EpicMusicPlayerMiniButton)then
		if(EpicMusicPlayerMiniButton:IsVisible())then
			EpicMusicPlayerMiniButton:Hide()
		else
			EpicMusicPlayerMiniButton:Show()
		end
	else
		self:CreateMinimapButton()
	end
end

-----------------------------------------------------------------------------------------------------------------------------
-- Update functions 
------------------------------------------------------------------------------------------------------------------------------
function EpicMusicPlayerGui:EMPUpdateTime(event)
	timeframewidth = timeframewidth + timeframestep
	exchangecount = exchangecount +1
	timeframe:SetWidth(timeframewidth)
	
	if(not volumechanged)then
		if(exchangecount > 3) then
			if(hasartist)then
				if(displaysong)then
					guitext:SetText(currsongname)
				else
					guitext:SetText(currartist)
				end
				displaysong = not displaysong
				exchangecount = 0
			end
		end
	end
end

function EpicMusicPlayerGui:EMPUpdateVolume(event, voltype, vol)	
	if(voltype == "music")then
		volumechanged = true
		guitext:SetText(L["Music volume: "]..math.floor((vol*100)).."%")
	elseif(voltype == "sound")then
		volumechanged = true
		guitext:SetText(L["Effects vol.: "]..math.floor((vol*100)).."%")
	elseif(voltype == "done")then
		volumechanged = false
		if(playing)then
			self:EMPUpdateTime()
		else
			self:EMPUpdateStop()
		end
	end
end

function EpicMusicPlayerGui:EMPUpdatePlay(event, artist, songname, length)
	songlength = length
	currsongname = songname
	if(artist=="")then
		hasartist = false
	else
		hasartist = true
	end
	currartist = "|c"..EpicMusicPlayer.db.profile.artistcolour.hex..artist
	displaysong = true
	playing = true;
		
	exchangecount = 0
	timeframewidth = 1
	timeframe:Show()
	timeframe:SetWidth(timeframewidth)
	
	timeframestep = (playerframe:GetWidth()-20) / songlength 
	guitext:SetText(songname)
	self.playbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-stop.tga")
	self.playbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-stop-p.tga")
	if(tooltip) then
		self:ShowTooltip(tooltip)
	end
end

function EpicMusicPlayerGui:EMPUpdateStop(event)
	timeframe:Hide()
	playing = false;
	guitext:SetText(L["Stopped"])
	timeframestep = 0
	self.playbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-play.tga")
	self.playbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-play-p.tga")
	if(tooltip) then
		self:ShowTooltip(tooltip)
	end
end

function EpicMusicPlayerGui:EMPUpdateRandom(event, val)
	if(val)then
		self.randombutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-randomon.tga")
		self.randombutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-randomon-p.tga")
	else
		self.randombutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-randomoff.tga")
		self.randombutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-randomoff-p.tga")
	end
	
end

function EpicMusicPlayerGui:Toggle()
	if(EMPGUI)then
		if(EMPGUI:IsShown()) then
			EMPGUI:Hide()
			if(EpicMusicDancer)then
				if(EpicMusicDancer:IsGuiToggle())then
					EpicMusicDancer:Hide()
				end
			end
	    else
	        EMPGUI:Show()
			if(EpicMusicDancer)then
				if(EpicMusicDancer:IsGuiToggle())then
					EpicMusicDancer:Show()
				end
			end
	    end
	end
end



function EpicMusicPlayerGui:UpdateFrame(emp)
	
	EpicMusicPlayerGui.lastbutton.back:SetBackdropColor(emp.db.profile.buttoncolour.r,
														emp.db.profile.buttoncolour.g,
														emp.db.profile.buttoncolour.b,
														emp.db.profile.buttoncolour.a)
	EpicMusicPlayerGui.playbutton.back:SetBackdropColor(EpicMusicPlayerGui.lastbutton.back:GetBackdropColor())
	EpicMusicPlayerGui.nextbutton.back:SetBackdropColor(EpicMusicPlayerGui.lastbutton.back:GetBackdropColor())
	EpicMusicPlayerGui.randombutton.back:SetBackdropColor(EpicMusicPlayerGui.lastbutton.back:GetBackdropColor())
	EpicMusicPlayerGui.confbutton.back:SetBackdropColor(EpicMusicPlayerGui.lastbutton.back:GetBackdropColor())
	EpicMusicPlayerGui.listbutton.back:SetBackdropColor(EpicMusicPlayerGui.lastbutton.back:GetBackdropColor())
	guitext:SetTextColor(emp.db.profile.titlecolour.r,
							emp.db.profile.titlecolour.g,
							emp.db.profile.titlecolour.b,
							emp.db.profile.titlecolour.a)
	timeframe.timebar:SetTexture(emp.db.profile.buttoncolour.r,
							emp.db.profile.buttoncolour.g,
							emp.db.profile.buttoncolour.b,
							emp.db.profile.buttoncolour.a)
	currartist = "|c"..EpicMusicPlayer.db.profile.artistcolour.hex..emp:GetCurrentArtistName()
	
	playerframe:SetBackdropColor(EpicMusicPlayer.db.profile.backcolour.r,
							EpicMusicPlayer.db.profile.backcolour.g,
							EpicMusicPlayer.db.profile.backcolour.b,
							EpicMusicPlayer.db.profile.backcolour.a);
	playerframe:SetBackdropBorderColor(EpicMusicPlayer.db.profile.bordercolour.r,
								EpicMusicPlayer.db.profile.bordercolour.g,
								EpicMusicPlayer.db.profile.bordercolour.b,
								EpicMusicPlayer.db.profile.bordercolour.a)
end

function EpicMusicPlayerGui:ShowTooltip(parent)
	local emp = EpicMusicPlayer
	GameTooltip:SetOwner(parent, "ANCHOR_BOTTOMRIGHT");
	
	if(EpicMusicPlayer.Playing)then		
		GameTooltip:SetText("|c"..emp.db.profile.artistcolour.hex..
			EpicMusicPlayer:GetCurrentArtistName().."|r  |c"..emp.db.profile.titlecolour.hex..emp:GetCurrentSongName())
		local album = EpicMusicPlayer:GetCurrentAlbumName();
		if(album=="")then
		else
			GameTooltip:AddLine("|cffffffee"..L["Album: "]..album)
		end
		
		GameTooltip:AddLine("|cffffffee"..L["List: "]..EpicMusicPlayer:GetListName())
		GameTooltip:AddLine("|cffffffee"..L["Length: "]..EpicMusicPlayer:GetTimeSTring(songlength))
		GameTooltip:Show()
	else
		GameTooltip:SetText(L["Stopped"], 1,1,1)
		GameTooltip:AddLine(L["Left Click"].." - "..emp.controlslist[emp.db.profile.controlset.left])	
		GameTooltip:AddLine(L["Middle Click"].." - "..emp.controlslist[emp.db.profile.controlset.middle])
		GameTooltip:AddLine(L["Right Click"].." - "..emp.controlslist[emp.db.profile.controlset.right])
		GameTooltip:Show()
	end
end

------------------------------------------------------------------------------------------------------------------------------
-- Create gui frame
------------------------------------------------------------------------------------------------------------------------------
function EpicMusicPlayerGui:CreateGuiFrame()
	
	playerframe = CreateFrame("PlayerModel","EMPGUI",UIParent)
	playerframe:SetWidth(150)
	playerframe:SetHeight(50)
	--frame background
	--playerframe:SetFrameLevel(2)
	playerframe:SetBackdrop({bgFile = "Interface/Tooltips/UI-Tooltip-Background", 
	                                        edgeFile = "Interface/Tooltips/UI-Tooltip-Border", 
	                                        tile = true, tileSize = 16, edgeSize = 16, 
	                                        insets = { left = 4, right = 4, top = 4, bottom = 4 }});
											--insets = { left = 1, right = 1, top = 1, bottom = 1 }});
	
	playerframe:SetPoint("CENTER",0,0)
	playerframe:Show()
	
	playerframe:EnableMouse(true); 

	playerframe:SetMovable(true) 

	playerframe:RegisterForDrag("LeftButton");
    --playerframe:RegisterForClicks("RightButtonUp")
	
	playerframe:SetFrameStrata(EpicMusicPlayer.db.profile.guistrata)
	playerframe:SetScript("OnDragStart", 
	    function()
			this:StartMoving()
			this.isMoving = true
		end
	)
	playerframe:SetScript("OnDragStop", 
	    function()
			this:StopMovingOrSizing()
			this.isMoving = false
		end
	)
	
	timeframe = CreateFrame("Frame",nil,EMPGUI)
	timeframe.timebar = timeframe:CreateTexture()
	--timeframe:SetAllPoints(playerframe)
	timeframe.timebar:SetAllPoints(timeframe)
	--timeframe.timebar:SetTexture(0.6,0.2,0.8,0.8)
	timeframe.timebar:SetTexture(EpicMusicPlayer.db.profile.artistcolour.r,
							EpicMusicPlayer.db.profile.artistcolour.g,
							EpicMusicPlayer.db.profile.artistcolour.b,
							EpicMusicPlayer.db.profile.artistcolour.a)
	timeframe:SetWidth(0)
	timeframe:SetHeight(2)
	timeframe:SetPoint("BOTTOMLEFT",8,6)
	
	
	local textframe = CreateFrame("Button",nil,EMPGUI)
	textframe:SetWidth(playerframe:GetWidth()-20)
	textframe:SetHeight(16)
	textframe:SetPoint("TOP",0,-5)
	
	textframe:RegisterForClicks("LeftButtonUp","RightButtonUp","MiddleButtonUp","Button4Up","Button5Up")
	--textframe:SetScript("OnClick",EpicMusicPlayer:GetDisplayClickHandler())
	textframe:SetScript("OnClick", 
	    function()
			--if(arg1 == "RightButton")then
			--	EpicMusicPlayer:OnDisplayRightClick(this)
			--else
				EpicMusicPlayer:OnDisplayClick(this)
			--end
		end
	)
	
	
	guitext = textframe:CreateFontString()
	local fontSize = 12
	guitext:SetFont("Interface\\AddOns\\EpicMusicPlayer\\font1.ttf", fontSize);
	guitext:SetTextColor(EpicMusicPlayer.db.profile.titlecolour.r,
							EpicMusicPlayer.db.profile.titlecolour.g,
							EpicMusicPlayer.db.profile.titlecolour.b,
							EpicMusicPlayer.db.profile.titlecolour.a)
	--s:SetJustifyH("LEFT");
	guitext:SetText(EpicMusicPlayer:GetCurrentSongName())
	guitext:SetAllPoints(textframe)

	playerframe:EnableMouseWheel(1) 
	playerframe:SetScript("OnMouseWheel", 
		function()
			EpicMusicPlayer:DisplyScrollHandler()
		end
    )
	
	-----------------------------------------------------------------------------------------------------
	self.playbutton = CreateFrame("Button","EMPPLAYBUTTON",EMPGUI)
	
	self.playbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-play.tga")
	--self.playbutton:SetHighlightTexture("Interface\\AddOns\\EpicMusicPlayer\\emp-play-h.tga")
	self.playbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-play-p.tga")

	self.playbutton:SetWidth(16) 
	self.playbutton:SetHeight(16)
	self.playbutton:SetPoint("BOTTOMLEFT",self.playbutton:GetWidth()+20,10)
	self.playbutton:EnableMouse(true); 
	self.playbutton:RegisterForClicks("LeftButtonUp")

	self.playbutton:SetScript("OnClick", 
	    function()
			EpicMusicPlayer:TogglePlay()
		end
	)
	
	self.playbutton.back = CreateFrame("Button",nil,EMPGUI)
	self.playbutton.back:SetBackdrop({bgFile = "Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-back.tga" });
	self.playbutton.back:SetAllPoints(self.playbutton)
	--self.playbutton.back:SetFrameLevel(2)
	
	
	-----------------------------------------------------------------------------------------------------
	
	
	self.lastbutton = CreateFrame("Button",nil,EMPPLAYBUTTON)
	self.lastbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-last.tga")
	--self.nextbutton:SetHighlightTexture("Interface\\AddOns\\EpicMusicPlayer\\emp-play-h.tga")
	self.lastbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-last-p.tga")

	self.lastbutton:SetWidth(16)
	self.lastbutton:SetHeight(16)
	self.lastbutton:SetPoint("BOTTOMLEFT",-self.playbutton:GetWidth(),0)
	self.lastbutton:EnableMouse(true); 
	self.lastbutton:RegisterForClicks("LeftButtonUp","RightButtonUp")		
	self.lastbutton:SetScript("OnClick", 
	    function()
			if(arg1 == "LeftButton")then
				EpicMusicPlayer:PlayLast()
			else
				if(EpicMusicDancer)then
					EpicMusicDancer:SetLastModel()
				end
			end
		end
	)
	
	self.lastbutton.back = CreateFrame("Button",nil,EMPPLAYBUTTON)
	self.lastbutton.back:SetBackdrop({bgFile = "Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-back.tga" });
	self.lastbutton.back:SetAllPoints(self.lastbutton)
	
	-----------------------------------------------------------------------------------------------------
	self.nextbutton = CreateFrame("Button",nil,EMPPLAYBUTTON)
	self.nextbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-next.tga")
	--self.nextbutton:SetHighlightTexture("Interface\\AddOns\\EpicMusicPlayer\\emp-play-h.tga")
	self.nextbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-next-p.tga")

	self.nextbutton:SetWidth(16)
	self.nextbutton:SetHeight(16)
	self.nextbutton:SetPoint("BOTTOMLEFT",(self.playbutton:GetWidth()),0)
	self.nextbutton:EnableMouse(true); 
	self.nextbutton:RegisterForClicks("LeftButtonUp","RightButtonUp")

	self.nextbutton:SetScript("OnClick", 
		function()
			if(arg1 == "LeftButton")then
				EpicMusicPlayer.db.profile.loopsong = false
				EpicMusicPlayer:PlayNext()
			else
				if(EpicMusicDancer)then
					EpicMusicDancer:SetNextModel()
				end
			end
		end
	)
	
	self.nextbutton.back = CreateFrame("Button",nil,EMPPLAYBUTTON)
	self.nextbutton.back:SetBackdrop({bgFile = "Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-back.tga" });
	self.nextbutton.back:SetAllPoints(self.nextbutton)
	
	-----------------------------------------------------------------------------------------------------
	self.listbutton = CreateFrame("Button",nil,EMPPLAYBUTTON)
	self.listbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-list.tga")
	--self.nextbutton:SetHighlightTexture("Interface\\AddOns\\EpicMusicPlayer\\emp-play-h.tga")
	self.listbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-list-p.tga")

	self.listbutton:SetWidth(16)
	self.listbutton:SetHeight(16)
	self.listbutton:SetPoint("BOTTOMLEFT",(self.playbutton:GetWidth()*5),0)
	self.listbutton:EnableMouse(true); 
	self.listbutton:RegisterForClicks("LeftButtonUp")

	self.listbutton:SetScript("OnClick", 
	    function()
			EpicMusicPlayer:ToggleList()
		end
	)
	
	self.listbutton.back = CreateFrame("Button",nil,EMPPLAYBUTTON)
	self.listbutton.back:SetBackdrop({bgFile = "Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-back.tga" });
	self.listbutton.back:SetAllPoints(self.listbutton)
	
	-----------------------------------------------------------------------------------------------------
	self.randombutton = CreateFrame("Button",nil,EMPPLAYBUTTON)
	EpicMusicPlayerGui:EMPUpdateRandom(event, EpicMusicPlayer:IsRandom()) --set texture according to random status

	self.randombutton:SetWidth(16)
	self.randombutton:SetHeight(16)
	self.randombutton:SetPoint("BOTTOMLEFT",(self.playbutton:GetWidth()*3),0)
	self.randombutton:EnableMouse(true); 
	self.randombutton:RegisterForClicks("LeftButtonUp","RightButtonUp")

	self.randombutton:SetScript("OnClick", 
	    function()
			if(arg1 == "LeftButton")then
				EpicMusicPlayer:ToggleRandom()
			else
				if(EpicMusicDancer)then
					EpicMusicDancer:ToggleShow()
				end
			end
		end
	)
	self.randombutton.back = CreateFrame("Button",nil,EMPPLAYBUTTON)
	self.randombutton.back:SetBackdrop({bgFile = "Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-back.tga" });
	self.randombutton.back:SetAllPoints(self.randombutton)
	-----------------------------------------------------------------------------------------------------
	self.confbutton = CreateFrame("Button",nil,EMPPLAYBUTTON)
	self.confbutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-conf.tga")
	self.confbutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-conf-p.tga")

	self.confbutton:SetWidth(16)
	self.confbutton:SetHeight(16)
	self.confbutton:SetPoint("BOTTOMLEFT",(self.playbutton:GetWidth()*4),0)
	self.confbutton:EnableMouse(true); 
	self.confbutton:RegisterForClicks("LeftButtonUp","RightButtonUp")

	self.confbutton:SetScript("OnClick", 
	    function()
			if(arg1 == "LeftButton")then
				EpicMusicPlayer:ToggleMute()
			else
				EpicMusicPlayer:ShowConfig()
			end
		end
	)
	self.confbutton.back = CreateFrame("Button",nil,EMPPLAYBUTTON)
	self.confbutton.back:SetBackdrop({bgFile = "Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-back.tga" });
	self.confbutton.back:SetAllPoints(self.confbutton)
	
	
	EpicMusicPlayerGui:UpdateFrame(EpicMusicPlayer)
	
	if(EpicMusicPlayer.db.char.guiscale)then
		EMPGUI:SetScale(EpicMusicPlayer.db.char.guiscale)
	end
	
end

function EpicMusicPlayerGui:CreateMinimapButton()
	
	---------------------------------------
	minibutton = CreateFrame("Button","EpicMusicPlayerMiniButton",Minimap)
	minibutton:SetWidth(32)
	minibutton:SetHeight(32)
	minibutton:SetFrameStrata("LOW")
	minibutton:SetPoint("TOP", "Minimap", "LEFT", -8, 0);
	
	minibutton:SetNormalTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\\emp-minimap.tga")
	minibutton:SetHighlightTexture("Interface\\Minimap\\UI-Minimap-ZoomButton-Highlight")
	minibutton:SetPushedTexture("Interface\\AddOns\\EpicMusicPlayer\\gui\\pics\emp-minimap-p.tga")
	
	--minibutton:RegisterForClicks("LeftButtonUp","RightButtonUp","MiddleButtonUp")
	minibutton:RegisterForClicks("AnyUp")
	
	minibutton:SetScript("OnClick", 
	    function()
			--if(arg1 == "RightButton")then
			--	EpicMusicPlayer:OnDisplayRightClick(this)
			--else
				EpicMusicPlayer:OnDisplayClick(this)
			--end
		end
	)
	
	minibutton:Show()
	minibutton:EnableMouse(true)
	minibutton:SetMovable(true) 
	minibutton:RegisterForDrag("RightButton");
	
	minibutton:SetScript("OnDragStart", 
	    function()
			this:StartMoving()
			this.isMoving = true
		end
	)
	minibutton:SetScript("OnDragStop", 
	    function()
			this:StopMovingOrSizing()
			this.isMoving = false
		end
	)
	
	minibutton:SetScript("OnEnter", 
	    function()
			tooltip = this
			EpicMusicPlayerGui:ShowTooltip(this)			
		end
	)
	
	minibutton:SetScript("OnLeave", 
	    function()
			tooltip = nil
			GameTooltip:Hide();
		end
	)
	
	minibutton:EnableMouseWheel(true) 
	minibutton:SetScript("OnMouseWheel", 
		function()
			EpicMusicPlayer:DisplyScrollHandler()
		end
    )
end