local L = AceLibrary("AceLocale-2.2"):new("EnchantingSell")
local ESUtil = AceLibrary("EnchantingSell-Util-1.0")
local ESD = AceLibrary("EnchantingSell-Debug-1.0")
local abacus = LibStub("LibAbacus-3.0")
local AuctionLib = AceLibrary("Auction-1.0")

ES_tester = {
	Locales = {},
	EnchantListData = {},
	EnchantLines = 10,
	ReagentLines = 6,
	All = "All",	--temp
	SelectedEnchant = nil,
	FilterByArmor=nil,
	SortByHaveMats=false,
	EnchanteSortOn = {"OnThis","Bonus","BonusNb","BasePrice","Quality"},	--these match up to the name in the enchant table in SV.
	EnchanteSortTypeAZ = true;
	TEXTECOLOR = {
		[-2] = {0.40, 0.40, 0.40};	-- The enchanter does not know this
		[-1] = {0.80, 0.80, 0.80};	-- Blank
		[1] = {0.30, 1, 0.30};		-- Can be crafted from bag supplies
		[2] = {0.50, 0.70, 0.30};	-- Can be crafted using supplies from bags and bank
		[3] = {0.70, 0.50, 0.30};	-- Can be crafted using supplies from bags, banks and alts
		[4] = {1, 0.30, 0.30};		-- Not enough supplies
	};
}

ES_tester.Print = function (text)
--	DEFAULT_CHAT_FRAME:AddMessage(text);
--	ESD:init()
--	ESD:showDebugFrame()
--	ESD:addLine(text)
end

ES_tester.DropDownArmorInitialise = function ()
	UIDropDownMenu_SetText(ES_tester.All, ES_tester.EFrame.DropDownArmor);

	local dropDownInfo = UIDropDownMenu_CreateInfo();

	--set the first button added to All
	dropDownInfo.text = ES_tester.All;
	dropDownInfo.value = ES_tester.All;
	dropDownInfo.checked = nil;
	dropDownInfo.func = ES_tester.DropDownArmorOnClick;
	dropDownInfo.disabled = nil;
	dropDownInfo.textR = 1;
	dropDownInfo.textG = 1;
	dropDownInfo.textB = 1;
	dropDownInfo.hasColorSwatch = nil;  --added since the color swatches were being displayed randomly. appears info is global variable, so we may need to reset other variables.
	dropDownInfo.notClickable = nil;

	UIDropDownMenu_AddButton(dropDownInfo);
	
	--then create and add all the other buttons for the other armor
	for i, armor in ipairs(L["ARMOR_TYPES"]) do
		dropDownInfo.text = armor[2];
		dropDownInfo.value = armor[2];
		dropDownInfo.checked = nil;
		dropDownInfo.hasColorSwatch = nil;  --added since the color swatches were being displayed randomly. appears info is global variable, so we may need to reset other variables.
		dropDownInfo.func = ES_tester.DropDownArmorOnClick;
		dropDownInfo.disabled = nil;
		dropDownInfo.textR = 1;
		dropDownInfo.textG = 1;
		dropDownInfo.textB = 1;
		dropDownInfo.notClickable = nil;
		
		UIDropDownMenu_AddButton(dropDownInfo);
	end
end

ES_tester.DropDownArmorOnClick = function ()
	if this.value == ES_tester.All then
		ES_tester.FilterByArmor = nil;
	else
		ES_tester.FilterByArmor = this.value;
	end
	UIDropDownMenu_SetText(this.value, ES_tester.EFrame.DropDownArmor);
	ES_tester.SortEnchants();
end

ES_tester.SortEnchants = function (nameArgSort)
	local EnchantNameSelect;

--	if ES_tester.FilterByArmor and listIdSelectedEnchante then
--		local _, onThis = ESell_Enchante_getInfoBonus(listIdSelectedEnchante);
--		if onThis ~= ES_tester.FilterByArmor then
--			listIdSelectedEnchante = nil;
--		end
--	end
--	if listIdSelectedEnchante then EnchantNameSelect = ESell_Enchante_getInfoDetail(listIdSelectedEnchante); end

	ES_tester.ESell_EnchanteSort(nameArgSort);

	if EnchantNameSelect then listIdSelectedEnchante = ESell_Enchante_getId(EnchantNameSelect); end
	ES_tester.EnchantScrollBar_Update();
	if (#ES_tester.EnchantListData>0) then
		ES_tester.SetSelection(1);
	end
end

ES_tester.ESell_EnchanteSort = function (nameColums)
	if #ES_tester.EnchantListData==0 then return end

	if nameColums then
		ES_tester.ESell_EnchanteSort_Modifier(nameColums);
	end
	table.sort(ES_tester.EnchantListData, ES_tester.ESell_EnchanteSort_Sort);
end

ES_tester.ESell_EnchanteSort_Modifier = function(nameColums)
	if nameColums == ES_tester.EnchanteSortOn[1] then
		ES_tester.EnchanteSortTypeAZ = not ES_tester.EnchanteSortTypeAZ;
		return;
	end
	for index, value in ipairs(ES_tester.EnchanteSortOn) do
		if nameColums == value then
			table.remove(ES_tester.EnchanteSortOn, index);
			if nameColums == "Bonus" then
				table.remove(ES_tester.EnchanteSortOn, (index));
				table.insert(ES_tester.EnchanteSortOn, 1, "BonusNb");
			end
			table.insert(ES_tester.EnchanteSortOn, 1, nameColums);
			break;
		end
	end
end

ES_tester.ESell_EnchanteSort_Sort = function(e1,e2)
	local sortTemp = ES_tester.EnchanteSortOn;

	--if no armor type selection is made, or the 2 items being compare are the same armor type...continue 
	if not ES_tester.FilterByArmor or (e1["OnThis"] == e2["OnThis"]) then
		if e1["IsKnow"] == e2["IsKnow"] then
			if (not ES_tester.SortByHaveMats) then
--			if ((not EnchantingSell_PlayerConfig.CheckSortByDoCraft) or (e1["Reagents"].Etat == e2["Reagents"].Etat)) then
				if (e1[sortTemp[1]] == e2[sortTemp[1]]) then
					if e1[sortTemp[2]] == e2[sortTemp[2]] then
						if e1[sortTemp[3]] == e2[sortTemp[3]] then
							if e1[sortTemp[4]] == e2[sortTemp[4]] then
								return ES_tester.ESell_EnchanteSort_SortUnderFunction(e1,e2,5);
							else
								return ES_tester.ESell_EnchanteSort_SortUnderFunction(e1,e2,4);
							end
						else
							return ES_tester.ESell_EnchanteSort_SortUnderFunction(e1,e2,3);
						end
					else
						return ES_tester.ESell_EnchanteSort_SortUnderFunction(e1,e2,2);
					end
				else
					return ES_tester.ESell_EnchanteSort_SortUnderFunction(e1,e2,1);
				end
			else
				return ES_tester.SortByHaveMaterials(e1, e2);
			end
		else
			return ES_tester.SortByKnowEnchante(e1, e2);
		end
	else
		if (e1["OnThis"] == ES_tester.FilterByArmor) then
			return true;		
		end 
		if (e1["OnThis"] == ES_tester.FilterByArmor) then
			return false;		
		end 
	end
end

ES_tester.SortByHaveMaterials = function(e1, e2)
	local feas1 = ES_runtime.feasibility[e1.EnchantName];
	local feas2 = ES_runtime.feasibility[e2.EnchantName];

	if (feas1 == -1) or (not feas1) then return false end
	if (feas2 == -1) or (not feas2) then return true end
	if (feas1 < feas2 )then
		return true;		
	else
		return false;
	end
end

ES_tester.SortByKnowEnchante = function(e1, e2)
	if not e1["IsKnow"] then return false end
	if not e2["IsKnow"] then return true end
end

ES_tester.ESell_EnchanteSort_SortUnderFunction = function(e1,e2,indexSortTemp)
	local sortTemp = ES_tester.EnchanteSortOn;	
	if (e1[sortTemp[indexSortTemp]] == nil) or (e1[sortTemp[indexSortTemp]] == "") or (e1[sortTemp[indexSortTemp]] == 0) then
		return false;		
	end 
	if (e2[sortTemp[indexSortTemp]] == nil) or (e2[sortTemp[indexSortTemp]] == "") or (e2[sortTemp[indexSortTemp]] == 0) then
		return true;		
	end 
	if ES_tester.EnchanteSortTypeAZ then
		if (e1[sortTemp[indexSortTemp]] < e2[sortTemp[indexSortTemp]] )then
			return true;		
		else
			return false;
		end
	else
		if (e1[sortTemp[indexSortTemp]] > e2[sortTemp[indexSortTemp]] )then
			return true;		
		else
			return false;
		end
	end
end

--called when the master enchanting database has changed.
--this will store a local copy of the data, resort it and update the enchanting frame.
--currently called ...
--  when the frame is shown
--  when the search text box data has changed. 
ES_tester.RefreshEnchantTable = function ()
	ES_tester.EnchantListData={};
	ES_tester.EnchantListData = ESUtil:copyTable(ES_tester.EnchantListData, ESeller.db.realm.EnchantList);
	ES_tester.SortEnchants();
	ES_tester.EnchantScrollBar_Update();
end

ES_tester.ReagentScrollBar_Update = function ()
	if (not ES_tester.SelectedEnchant) then 
		ES_tester.EFrame.CraftCreateButton:Disable();
		return; 
	end
	if (#ES_tester.EnchantListData==0) then return end

	local line;
	local lineplusoffset; -- an index into our data calculated from the scroll offset
	
	local realm = GetCVar("realmName");
	local playerName = UnitName("player"); 

	FauxScrollFrame_Update(ES_tester.EDParent.ScrollBar, #ES_tester.EnchantListData[ES_tester.SelectedEnchant].Reagents, ES_tester.ReagentLines, 12);

	for line=1,ES_tester.ReagentLines do
		lineplusoffset = line + FauxScrollFrame_GetOffset(ES_testerEDParentScrollBar);
		if lineplusoffset <= #ES_tester.EnchantListData[ES_tester.SelectedEnchant].Reagents then
			local reagents = ES_tester.EnchantListData[ES_tester.SelectedEnchant].Reagents;
			local reagentName = reagents[lineplusoffset].Name;
			local reagentCount = reagents[lineplusoffset].Count;
			local reagentId = ESUtil:GetReagentId(ESeller.db.realm.EnchantReagents, reagentName);

			local enchantReagents = ESeller.db.realm.EnchantReagents[reagentId];

			local reagentCountBag = enchantReagents.ByPlayer[playerName].NbInBag;
			local reagentCountBank = enchantReagents.ByPlayer[playerName].NbInBank;
			local reagentCountAlt = ESUtil:GetReagentAltCounts(enchantReagents.ByPlayer, playerName);

			getglobal("EDParentReagentButton"..line.."_Icone"):SetTexture(enchantReagents.Texture);
			getglobal("EDParentReagentButton"..line.."_Name"):SetText(reagentName);
			getglobal("EDParentReagentButton"..line.."_Nb"):SetText(reagentCountBag.."/"..reagents[lineplusoffset].Count);
			getglobal("EDParentReagentButton"..line.."_NbOther"):SetText(reagentCountBank.."-"..reagentCountAlt);

			local reagentLink = ESUtil:GetReagentLink(ESeller.db.realm.EnchantReagents, reagentName);

			local pricePer = 0;
			if (ESeller.db.char.UseAuctionPricing) then
				pricePer = AuctionLib:GetPrice(reagentLink);
			end
			if not pricePer then pricePer=0 end

			local money=abacus:FormatMoneyFull(pricePer, true);
			local moneyTotal=abacus:FormatMoneyFull(pricePer*reagentCount, true);
			getglobal("EDParentReagentButton"..line.."_PricePer"):SetText(money);
			getglobal("EDParentReagentButton"..line.."_PriceTotal"):SetText(moneyTotal);			
			ES_tester.EDParent.ReagentButton[line]:Show();

			local chatTextTemp = ("{ "..reagentCount.."x "..reagentLink.." }");
			getglobal("EDParentReagentButton"..line).ChatTextForAdd = chatTextTemp;

		else
			ES_tester.EDParent.ReagentButton[line]:Hide();
		end
	end
end

ES_tester.EnchantScrollBar_Update = function ()
	local line;
	local lineplusoffset; -- an index into our data calculated from the scroll offset
	local enchantCount = #ES_tester.EnchantListData;

	local nbShow = 0;
	if ES_tester.FilterByArmor then
		for i=1, #ES_tester.EnchantListData, 1 do
			local onThis = ES_tester.EnchantListData[i].OnThis;
			if (ES_tester.FilterByArmor == onThis) then nbShow = nbShow + 1; end
		end
	else
		nbShow = #ES_tester.EnchantListData;
	end

	FauxScrollFrame_Update(ES_tester.EFrame.EnchantScrollBar, nbShow, ES_tester.EnchantLines, 16);

	-- If no Crafts
	if ( nbShow == 0 ) then
		ES_tester.EDParent.EnchantIcon:Hide()
		ES_tester.EDParent.EnchantNameFont:Hide()
		ES_tester.EDParent.EnchantRequirementsFont:Hide()
		ES_tester.EDParent.EnchantCountsFont:Hide()
		ES_tester.EDParent.EnchantDescriptionFont:Hide()
		ES_tester.EDParent.HeaderName:Hide()
		ES_tester.EDParent.HeaderNameFont:Hide()
		ES_tester.EDParent.HeaderCount:Hide()
		ES_tester.EDParent.HeaderCountFont:Hide()
		ES_tester.EDParent.HeaderBank:Hide()
		ES_tester.EDParent.HeaderBankFont:Hide()
		ES_tester.EDParent.HeaderPricePer:Hide()
		ES_tester.EDParent.HeaderPricePerFont:Hide()
		ES_tester.EDParent.HeaderPrice:Hide()
		ES_tester.EDParent.HeaderPriceFont:Hide()

--		for i=1, CRAFTS_DISPLAYED, 1 do
--			getglobal("Craft"..i):Hide();
--		end
--		for i=1, MAX_CRAFT_REAGENTS, 1 do
--			getglobal("CraftReagent"..i):Hide();
--		end
--		CraftReagentLabel:Hide();
--		CraftDetailScrollFrameScrollBar:Hide();
--		CraftDetailScrollFrameTop:Hide();
--		CraftDetailScrollFrameBottom:Hide();
--		CraftListScrollFrame:Hide();
		return;
	end
	
	-- If has crafts
	ES_tester.EDParent.EnchantIcon:Show()
	ES_tester.EDParent.EnchantNameFont:Show()
	ES_tester.EDParent.EnchantRequirementsFont:Show()
	ES_tester.EDParent.EnchantCountsFont:Show()
	ES_tester.EDParent.EnchantDescriptionFont:Show()
	ES_tester.EDParent.HeaderName:Show()
	ES_tester.EDParent.HeaderNameFont:Show()
	ES_tester.EDParent.HeaderCount:Show()
	ES_tester.EDParent.HeaderCountFont:Show()
	ES_tester.EDParent.HeaderBank:Show()
	ES_tester.EDParent.HeaderBankFont:Show()
	ES_tester.EDParent.HeaderPricePer:Show()
	ES_tester.EDParent.HeaderPricePerFont:Show()
	ES_tester.EDParent.HeaderPrice:Show()
	ES_tester.EDParent.HeaderPriceFont:Show()


	
	for line=1,ES_tester.EnchantLines do
		lineplusoffset = line + FauxScrollFrame_GetOffset(ES_testerEFrameEnchantScrollBar);
		if lineplusoffset == ES_tester.SelectedEnchant then
			getglobal("ES_testerEFrameEnchantScrollBar"..line):LockHighlight();
		else
			getglobal("ES_testerEFrameEnchantScrollBar"..line):UnlockHighlight();
		end

		if lineplusoffset <= nbShow then
			local enchantName=ES_tester.EnchantListData[lineplusoffset].EnchantName;
			local feasibility=ES_runtime.feasibility[enchantName];
			local color = ES_tester.TEXTECOLOR[feasibility];
			if not color then color = {0.80, 0.80, 0.80} end

			getglobal("ES_testerEFrameEnchantScrollBar"..line.."_MakeCount"):SetText(lineplusoffset);
			getglobal("ES_testerEFrameEnchantScrollBar"..line.."_OnThis"):SetText(ES_tester.EnchantListData[lineplusoffset].OnThis);
			getglobal("ES_testerEFrameEnchantScrollBar"..line.."_Quality"):SetText(ES_tester.EnchantListData[lineplusoffset].Quality);

			local bonus=ES_tester.EnchantListData[lineplusoffset].Bonus
			local bonusNb=ES_tester.EnchantListData[lineplusoffset].BonusNb
			local completeBonus=bonus
			if bonusNb then
				completeBonus = completeBonus.." +"..bonusNb;
			end
			getglobal("ES_testerEFrameEnchantScrollBar"..line.."_Bonus"):SetText(completeBonus);

			local money=abacus:FormatMoneyFull(ES_tester.EnchantListData[lineplusoffset].BasePrice, true);
			getglobal("ES_testerEFrameEnchantScrollBar"..line.."_BasePrice"):SetText(money);

			local chatText=ES_tester.EnchantListData[lineplusoffset].Link;
--			if EnchantingSell_PlayerConfig.EnchanteChatPrice and price and price ~= 0 then
--				local money=abacus:FormatMoneyFull(price);
--				DebugMessage("Money formatted from abacus "..money);
--				chatText = ("{ "..chatText..ENCHANTINGSELL_ENCHANTE_TOOLTIP_SEPARATORFORPRICE..money.." }");
--			end

			--set the text color
			getglobal("ES_testerEFrameEnchantScrollBar"..line.."_MakeCount"):SetTextColor(color[1], color[2], color[3]);
			getglobal("ES_testerEFrameEnchantScrollBar"..line.."_OnThis"):SetTextColor(color[1], color[2], color[3]);
			getglobal("ES_testerEFrameEnchantScrollBar"..line.."_Quality"):SetTextColor(color[1], color[2], color[3]);
			getglobal("ES_testerEFrameEnchantScrollBar"..line.."_Bonus"):SetTextColor(color[1], color[2], color[3]);

			--for linking in chat
			getglobal("ES_testerEFrameEnchantScrollBar"..line).ChatTextForAdd = chatText;

			--for tooltip onenter
			ES_tester.EFrame.EnchantButton[line].tooltip=ES_tester.EnchantListData[lineplusoffset].Link;
			ES_tester.EFrame.EnchantButton[line]:Show();
		else
			ES_tester.EFrame.EnchantButton[line]:Hide();
		end
	end
end

ES_tester.repaintFrames = function()
	ES_tester.EnchantScrollBar_Update();
	ES_tester.ReagentScrollBar_Update();
	ES_tester.UpdateEnchantButton();
end

ES_tester.CreateFrames = function ()
	ES_tester.Frame = CreateFrame("Frame")
	ES_tester.EFrame = CreateFrame("Frame", "ES_tester.EFrame", UIParent)
	ES_tester.EFrame:Hide()
	ES_tester.EFrame:SetPoint("TOP", "UIParent", "TOP", 0, -100)
	ES_tester.EFrame:SetFrameStrata("DIALOG")
	ES_tester.EFrame:SetHeight(512)
	ES_tester.EFrame:SetWidth(420)
	ES_tester.EFrame:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 32, edgeSize = 32,
		insets = { left = 9, right = 9, top = 9, bottom = 9 }
	})
	ES_tester.EFrame:SetBackdropColor(0,0,0, 0.8)
	ES_tester.EFrame:SetMovable(true)
	ES_tester.EFrame:SetScript("OnShow", function() 
		ES_tester.EFrame.CraftCreateButton:Disable();
		if ( #ES_tester.EnchantListData > 0 ) then
			ES_tester.SetSelection(1);
		end
		FauxScrollFrame_SetOffset(ES_tester.EFrame.EnchantScrollBar, 0);
		ES_testerEFrameEnchantScrollBarScrollBar:SetMinMaxValues(0, 0); 
		ES_testerEFrameEnchantScrollBarScrollBar:SetValue(0);
	end)

	ES_tester.EFrame.Drag = CreateFrame("Button", "", ES_tester.EFrame)
	ES_tester.EFrame.Drag:SetPoint("TOPLEFT", ES_tester.EFrame, "TOPLEFT", 10,-5)
	ES_tester.EFrame.Drag:SetPoint("TOPRIGHT", ES_tester.EFrame, "TOPRIGHT", -10,-5)
	ES_tester.EFrame.Drag:SetHeight(20)
	ES_tester.EFrame.Drag:SetHighlightTexture("Interface\\FriendsFrame\\UI-FriendsFrame-HighlightBar")
	ES_tester.EFrame.Drag:SetScript("OnMouseDown", function() ES_tester.EFrame:StartMoving() end)
	ES_tester.EFrame.Drag:SetScript("OnMouseUp", function() ES_tester.EFrame:StopMovingOrSizing() end)

	ES_tester.EFrame.TitleText = ES_tester.EFrame:CreateFontString("ES_testerEFrameTitleText", "HIGH", GameFontHighlight)
	ES_tester.EFrame.TitleText:SetPoint("TOP", ES_tester.EFrame, "TOP",0,-10)
	ES_tester.EFrame.TitleText:SetFont("Fonts\\FRIZQT__.TTF",13)
	ES_tester.EFrame.TitleText:SetWidth(420)
	ES_tester.EFrame.TitleText:SetHeight(14)
	ES_tester.EFrame.TitleText:SetJustifyH("CENTER")
	ES_tester.EFrame.TitleText:SetText(L["Enchanting Seller"])
	ES_tester.EFrame.TitleText:Show()

	ES_tester.EFrame.CloseButton = CreateFrame("Button", "", ES_tester.EFrame, "UIPanelCloseButton")
	ES_tester.EFrame.CloseButton:SetPoint("TOPRIGHT", ES_tester.EFrame, "TOPRIGHT")
	ES_tester.EFrame.CloseButton:SetFrameLevel(ES_tester.EFrame:GetFrameLevel()+4)

	ES_tester.EFrame.EnchanterName = ES_tester.EFrame:CreateFontString("ES_testerEFrameEnchanterName", "HIGH", GameFontNormal)
	ES_tester.EFrame.EnchanterName:SetPoint("TOP", ES_tester.EFrame.TitleText, "BOTTOM")
	ES_tester.EFrame.EnchanterName:SetFont("Fonts\\FRIZQT__.TTF",13)
	ES_tester.EFrame.EnchanterName:SetWidth(200)
	ES_tester.EFrame.EnchanterName:SetHeight(14)
	ES_tester.EFrame.EnchanterName:SetText(ESUtil:GetCurrentSelectedEnchanterName())

	ES_tester.EFrame.DropDownArmor = CreateFrame("Frame", "ES_tester.EFrame.DropDownArmor", ES_tester.EFrame, "UIDropDownMenuTemplate")
	ES_tester.EFrame.DropDownArmor:SetPoint("TOPRIGHT", ES_tester.EFrame, "TOPRIGHT",0,-40)
	UIDropDownMenu_Initialize(ES_tester.EFrame.DropDownArmor, ES_tester.DropDownArmorInitialise);
	UIDropDownMenu_SetWidth(80, ES_tester.EFrame.DropDownArmor)
	UIDropDownMenu_SetButtonWidth(20, ES_tester.EFrame.DropDownArmor) 

	ES_tester.EFrame.DropDownArmorText = ES_tester.EFrame:CreateFontString("ES_testerEFrameDropDownArmorText", "HIGH", GameFontNormalSmall)
	ES_tester.EFrame.DropDownArmorText:SetPoint("BOTTOMRIGHT", ES_tester.EFrame.DropDownArmor, "TOPRIGHT",0,-5)
	ES_tester.EFrame.DropDownArmorText:SetFont("Fonts\\FRIZQT__.TTF",10)
	ES_tester.EFrame.DropDownArmorText:SetWidth(100)
	ES_tester.EFrame.DropDownArmorText:SetHeight(22)
	ES_tester.EFrame.DropDownArmorText:SetJustifyH("LEFT")
	ES_tester.EFrame.DropDownArmorText:SetText(L["Filter By Armor"])
	ES_tester.EFrame.DropDownArmorText:Show()


	ES_tester.EFrame.CraftCreateButton = CreateFrame("Button", "", ES_tester.EFrame, "UIPanelButtonTemplate")
	ES_tester.EFrame.CraftCreateButton:SetPoint("BOTTOMRIGHT", ES_tester.EFrame, "BOTTOMRIGHT",-10,10)
	ES_tester.EFrame.CraftCreateButton:SetWidth(80)
	ES_tester.EFrame.CraftCreateButton:SetHeight(22)
	ES_tester.EFrame.CraftCreateButton:SetText(L["Enchant"])
	ES_tester.EFrame.CraftCreateButton:SetScript("OnClick", function() 
		ES_tester.DoCraft()
	end)

	ES_tester.EFrame.HaveMatsCheckButton = CreateFrame("CheckButton", "", ES_tester.EFrame, "OptionsCheckButtonTemplate")
	ES_tester.EFrame.HaveMatsCheckButton:SetPoint("TOPLEFT", ES_tester.EFrame, "TOPLEFT",10,-40)
	ES_tester.EFrame.HaveMatsCheckButton:SetWidth(22)
	ES_tester.EFrame.HaveMatsCheckButton:SetHeight(22)
	ES_tester.EFrame.HaveMatsCheckButton:SetScript("OnClick", function()
		ES_tester.SortByHaveMats = this:GetChecked();
		ES_tester.SortEnchants();
	end)

	ES_tester.EFrame.HaveMatsCheckButtonText = ES_tester.EFrame:CreateFontString("ES_testerEFrameHaveMatsCheckButtonText", "HIGH", GameFontNormalSmall)
	ES_tester.EFrame.HaveMatsCheckButtonText:SetPoint("BOTTOMLEFT", ES_tester.EFrame.HaveMatsCheckButton, "BOTTOMRIGHT")
	ES_tester.EFrame.HaveMatsCheckButtonText:SetFont("Fonts\\FRIZQT__.TTF",10)
	ES_tester.EFrame.HaveMatsCheckButtonText:SetWidth(100)
	ES_tester.EFrame.HaveMatsCheckButtonText:SetHeight(22)
	ES_tester.EFrame.HaveMatsCheckButtonText:SetJustifyH("LEFT")
	ES_tester.EFrame.HaveMatsCheckButtonText:SetText(L["Have Materials"])
	ES_tester.EFrame.HaveMatsCheckButtonText:Show()

	ES_tester.EFrame.SortByHaveMatsCheckButton = CreateFrame("CheckButton", "", ES_tester.EFrame, "OptionsCheckButtonTemplate")
	ES_tester.EFrame.SortByHaveMatsCheckButton:SetPoint("TOP", ES_tester.EFrame.HaveMatsCheckButton, "BOTTOM",0,5)
	ES_tester.EFrame.SortByHaveMatsCheckButton:SetWidth(22)
	ES_tester.EFrame.SortByHaveMatsCheckButton:SetHeight(22)
	ES_tester.EFrame.SortByHaveMatsCheckButton:SetScript("OnClick", function()
		ES_tester.SortEnchants();
	end)

	ES_tester.EFrame.SortByHaveMatsCheckButtonText = ES_tester.EFrame:CreateFontString("ES_testerEFrameSortByHaveMatsCheckButtonText", "HIGH", GameFontNormalSmall)
	ES_tester.EFrame.SortByHaveMatsCheckButtonText:SetPoint("BOTTOMLEFT", ES_tester.EFrame.SortByHaveMatsCheckButton, "BOTTOMRIGHT")
	ES_tester.EFrame.SortByHaveMatsCheckButtonText:SetFont("Fonts\\FRIZQT__.TTF",10)
	ES_tester.EFrame.SortByHaveMatsCheckButtonText:SetWidth(100)
	ES_tester.EFrame.SortByHaveMatsCheckButtonText:SetHeight(22)
	ES_tester.EFrame.SortByHaveMatsCheckButtonText:SetJustifyH("LEFT")
	ES_tester.EFrame.SortByHaveMatsCheckButtonText:SetText(L["Sort by feasibility"])
	ES_tester.EFrame.SortByHaveMatsCheckButtonText:Show()

	ES_tester.EFrame.SearchEditBox = CreateFrame("EditBox", "", ES_tester.EFrame, "ES_EditBox_template")
	ES_tester.EFrame.SearchEditBox:SetPoint("TOPLEFT", ES_tester.EFrame.SortByHaveMatsCheckButton, "BOTTOMLEFT",10,0)
	ES_tester.EFrame.SearchEditBox:SetWidth(128)
	ES_tester.EFrame.SearchEditBox:SetHeight(20)
	ES_tester.EFrame.SearchEditBox:SetScript("OnShow", function ()
		this:SetText("")
		ES_tester.SearchEditBox_OnTextChanged();
	end)
	ES_tester.EFrame.SearchEditBox:SetScript("OnEnterPressed", function ()
		this:ClearFocus()
	end)
	ES_tester.EFrame.SearchEditBox:SetScript("OnEscapePressed", function ()
		this:ClearFocus()
	end)
	ES_tester.EFrame.SearchEditBox:SetScript("OnTextChanged", function ()
		ES_tester.SearchEditBox_OnTextChanged();
	end)
	ES_tester.EFrame.SearchEditBox:SetScript("OnEditFocusLost", function ()
		this:HighlightText(0, 0);	--removes the highlight when focus is lost
	end)
	ES_tester.EFrame.SearchEditBox:SetScript("OnEditFocusGained", function ()
		this:HighlightText();	--highlights the text when the field gains focus
	end)

	ES_tester.ELParent = CreateFrame("Frame", "ES_tester.ELParent", ES_tester.EFrame)
	ES_tester.ELParent:SetPoint("TOPLEFT", ES_tester.EFrame, "TOPLEFT", 5,-110)
	ES_tester.ELParent:SetWidth(380)
	ES_tester.ELParent:SetHeight(170)
	ES_tester.ELParent:SetBackdrop({
		bgFile = "Interface\\AddOns\\EnchantingSell\\Back",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 128, edgeSize = 16,
		insets = { left = 6, right = 6, top = 6, bottom = 6
	}})
	ES_tester.ELParent:Show()

	ES_tester.EFrame.EnchantScrollBar = CreateFrame("ScrollFrame", "ES_testerEFrameEnchantScrollBar", ES_tester.ELParent, "FauxScrollFrameTemplate")
	ES_tester.EFrame.EnchantScrollBar:SetPoint("TOPLEFT", ES_tester.ELParent, "TOPLEFT",0,-5)
	ES_tester.EFrame.EnchantScrollBar:SetPoint("BOTTOMRIGHT", ES_tester.ELParent, "BOTTOMRIGHT")
	ES_tester.EFrame.EnchantScrollBar:SetScript("OnVerticalScroll", function ()
		FauxScrollFrame_OnVerticalScroll(16, ES_tester.EnchantScrollBar_Update)
	end)
	ES_tester.EFrame.EnchantScrollBar:SetScript("OnShow", function() 
		ES_tester.EnchantScrollBar_Update()
	end)

	local tooltip = L["Header tooltip"];
	ES_tester.EFrame.HeaderOnThis = CreateFrame("Button", "ES_testerEFrameHeaderOnThis", ES_tester.EFrame)
	ES_tester.EFrame.HeaderOnThis:SetPoint("BOTTOMLEFT", ES_tester.EFrame.EnchantScrollBar, "TOPLEFT",28,0)
	ES_tester.EFrame.HeaderOnThis:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	ES_tester.EFrame.HeaderOnThis:SetWidth(53)
	ES_tester.EFrame.HeaderOnThis:SetHeight(16)
	ES_tester.EFrame.HeaderOnThis:Show();
	ES_tester.EFrame.HeaderOnThisFont = ES_tester.EFrame.HeaderOnThis:CreateFontString("HeaderOnThisFontText", "BORDER", "GameFontNormalSmall")
	ES_tester.EFrame.HeaderOnThisFont:SetPoint("LEFT", 0, 0)		
	ES_tester.EFrame.HeaderOnThisFont:SetText("Armor")
	ES_tester.EFrame.HeaderOnThis:SetScript("OnEnter", function()
		GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
		GameTooltip:SetText(tooltip)
		GameTooltip:Show();
	end)
	ES_tester.EFrame.HeaderOnThis:SetScript("OnLeave", function()
		GameTooltip:Hide()
	end)
	ES_tester.EFrame.HeaderOnThis:SetScript("OnClick", function()
		--GetName returns ES_testerEFrameHeaderOnThis, we need to cut ES_testerEFrameHeader off and just grab the name
		ES_tester.SortEnchants(string.sub(this:GetName(), 22));
	end)

	ES_tester.EFrame.HeaderName = CreateFrame("Button", "ES_testerEFrameHeaderQuality", ES_tester.EFrame)
	ES_tester.EFrame.HeaderName:SetPoint("BOTTOMLEFT", ES_tester.EFrame.HeaderOnThis, "BOTTOMRIGHT",0,0)
	ES_tester.EFrame.HeaderName:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	ES_tester.EFrame.HeaderName:SetWidth(53)
	ES_tester.EFrame.HeaderName:SetHeight(16)
	ES_tester.EFrame.HeaderName:Show();
	ES_tester.EFrame.HeaderNameFont = ES_tester.EFrame.HeaderName:CreateFontString("HeaderNameFontText", "BORDER", "GameFontNormalSmall")
	ES_tester.EFrame.HeaderNameFont:SetPoint("LEFT", 0, 0)		
	ES_tester.EFrame.HeaderNameFont:SetText("Name")
	ES_tester.EFrame.HeaderName:SetScript("OnEnter", function()
		GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
		GameTooltip:SetText(tooltip)
		GameTooltip:Show();
	end)
	ES_tester.EFrame.HeaderName:SetScript("OnLeave", function()
		GameTooltip:Hide()
	end)
	ES_tester.EFrame.HeaderName:SetScript("OnClick", function()
		ES_tester.SortEnchants(string.sub(this:GetName(), 22));
	end)

	ES_tester.EFrame.HeaderBonus = CreateFrame("Button", "ES_testerEFrameHeaderBonus", ES_tester.EFrame)
	ES_tester.EFrame.HeaderBonus:SetPoint("BOTTOMLEFT", ES_tester.EFrame.HeaderName, "BOTTOMRIGHT",98,0)
	ES_tester.EFrame.HeaderBonus:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	ES_tester.EFrame.HeaderBonus:SetWidth(53)
	ES_tester.EFrame.HeaderBonus:SetHeight(16)
	ES_tester.EFrame.HeaderBonus:Show();
	ES_tester.EFrame.HeaderBonusFont = ES_tester.EFrame.HeaderBonus:CreateFontString("HeaderBonusFontText", "BORDER", "GameFontNormalSmall")
	ES_tester.EFrame.HeaderBonusFont:SetPoint("LEFT", 0, 0)		
	ES_tester.EFrame.HeaderBonusFont:SetText("Bonus")
	ES_tester.EFrame.HeaderBonus:SetScript("OnEnter", function()
		GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
		GameTooltip:SetText(tooltip)
		GameTooltip:Show();
	end)
	ES_tester.EFrame.HeaderBonus:SetScript("OnLeave", function()
		GameTooltip:Hide()
	end)
	ES_tester.EFrame.HeaderBonus:SetScript("OnClick", function()
		ES_tester.SortEnchants(string.sub(this:GetName(), 22));
	end)

	ES_tester.EFrame.HeaderPrice = CreateFrame("Button", "ES_testerEFrameHeaderBasePrice", ES_tester.EFrame)
	ES_tester.EFrame.HeaderPrice:SetPoint("BOTTOMLEFT", ES_tester.EFrame.HeaderBonus, "BOTTOMRIGHT",40,0)
	ES_tester.EFrame.HeaderPrice:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	ES_tester.EFrame.HeaderPrice:SetWidth(53)
	ES_tester.EFrame.HeaderPrice:SetHeight(16)
	ES_tester.EFrame.HeaderPrice:Show();
	ES_tester.EFrame.HeaderPriceFont = ES_tester.EFrame.HeaderPrice:CreateFontString("HeaderPriceFontText", "BORDER", "GameFontNormalSmall")
	ES_tester.EFrame.HeaderPriceFont:SetPoint("LEFT", 0, 0)		
	ES_tester.EFrame.HeaderPriceFont:SetText("Price")
	ES_tester.EFrame.HeaderPrice:SetScript("OnEnter", function()
		GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
		GameTooltip:SetText(tooltip)
		GameTooltip:Show();
	end)
	ES_tester.EFrame.HeaderPrice:SetScript("OnLeave", function()
		GameTooltip:Hide()
	end)
	ES_tester.EFrame.HeaderPrice:SetScript("OnClick", function()
		ES_tester.SortEnchants(string.sub(this:GetName(), 22));
	end)

--	ES_testerEFrameEnchantButtonHeader_MakeCount:SetText("");

	ES_tester.EFrame.EnchantButton={}
	local ELtooltip = L["ENCHANT_ALT"];
	for i=1, ES_tester.EnchantLines do
		ES_tester.EFrame.EnchantButton[i] = CreateFrame("Button", "ES_testerEFrameEnchantScrollBar"..i, ES_tester.EFrame, "ES_Enchant_EnchantListTemplate")
		if (i==1) then
			ES_tester.EFrame.EnchantButton[i]:SetPoint("TOPLEFT", ES_tester.EFrame.EnchantScrollBar, "TOPLEFT", 8,0)
		else 
			ES_tester.EFrame.EnchantButton[i]:SetPoint("TOPLEFT", ES_tester.EFrame.EnchantButton[i-1], "BOTTOMLEFT")
		end
		ES_tester.EFrame.EnchantButton[i]:SetID(i);
		ES_tester.EFrame.EnchantButton[i]:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
		ES_tester.EFrame.EnchantButton[i]:GetHighlightTexture():SetBlendMode("ADD");
		ES_tester.EFrame.EnchantButton[i]:SetScript("OnClick", function ()
			ES_tester.EnchantListOnClick()
		end)
		ES_tester.EFrame.EnchantButton[i]:SetScript("OnEnter", function()
			if ( IsShiftKeyDown() ) then
				if ( this.tooltip ) then
					GameTooltip:SetOwner(this, "ANCHOR_RIGHT");
					GameTooltip:SetHyperlink(this.tooltip)
					GameTooltip:Show()
				end
			elseif ( IsControlKeyDown() ) then

			elseif ( IsAltKeyDown() ) then
				GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
				GameTooltip:SetText(ELtooltip)
				GameTooltip:Show();
			end
		end)
		ES_tester.EFrame.EnchantButton[i]:SetScript("OnLeave", function()
			GameTooltip:Hide()	
		end)
	end


	--begin the enchanting details frame
	ES_tester.EDParent = CreateFrame("Frame", "ES_tester.EDParent", ES_tester.EFrame)
	ES_tester.EDParent:SetPoint("TOPLEFT", ES_tester.ELParent, "BOTTOMLEFT", 0,-5)
	ES_tester.EDParent:SetWidth(380)
	ES_tester.EDParent:SetHeight(170)
	ES_tester.EDParent:SetBackdrop({
		bgFile = "Interface\\AddOns\\EnchantingSell\\Back",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 128, edgeSize = 16,
		insets = { left = 6, right = 6, top = 6, bottom = 6
	}})
	ES_tester.EDParent:Show()

	ES_tester.EDParent.EnchantIcon = CreateFrame("Button", "ES_testerEDParentEnchantIcon", ES_tester.EDParent)
	ES_tester.EDParent.EnchantIcon:SetPoint("TOPLEFT", ES_tester.EDParent, "TOPLEFT", 5, -5)
	ES_tester.EDParent.EnchantIcon:SetWidth(37)
	ES_tester.EDParent.EnchantIcon:SetHeight(37)
	ES_tester.EDParent.EnchantIcon:Hide();
	ES_tester.EDParent.EnchantIcon:SetScript("OnEnter", function() 
		GameTooltip:SetOwner(this, "ANCHOR_RIGHT");

		--first line is Enchant Name
		GameTooltip:AddLine("Enchanting: "..ES_tester.EnchantListData[ES_tester.SelectedEnchant].EnchantName, 1.0, 0.82, 0);

		--second line are Reagents
		GameTooltip:AddLine("Reagents:", 1.0, 1.0, 1.0);
		local reg = ES_tester.EnchantListData[ES_tester.SelectedEnchant].Reagents;
		local size = #reg;
		local rlist = "";
		for i=1, size do
			local count=reg[i].Count
			rlist=rlist..reg[i].Name.."("..count..")";
			if i~=size then 
				rlist=rlist..", ";
			end
		end

		GameTooltip:AddLine(rlist, 0.8, 0.3, 0.22, 1, 1); --comma seperated list of items

		--third line is the description
		GameTooltip:AddLine(ES_tester.EnchantListData[ES_tester.SelectedEnchant].Description, 1.0, 0.82, 0, 1, 1);
		
		GameTooltip:Show();
	end)
	ES_tester.EDParent.EnchantIcon:SetScript("OnLeave", function() 
		GameTooltip:Hide();
		ResetCursor();
	end)
	ES_tester.EDParent.EnchantIcon:SetScript("OnUpdate", function() 
		CursorOnUpdate();
	end)
	ES_tester.EDParent.EnchantIcon:SetScript("OnClick", function() 
		if ( IsShiftKeyDown() ) then
			local link = ES_tester.EnchantListData[ES_tester.SelectedEnchant].Link;

			if ( WIM_EditBoxInFocus and link) then
				WIM_EditBoxInFocus:Insert(link);
			else
				ChatEdit_InsertLink(GetCraftItemLink(GetCraftSelectionIndex()));
			end
		end
	end)

	ES_tester.EDParent.EnchantNameFont = ES_tester.EDParent.EnchantIcon:CreateFontString("EnchantNameFontText", "BACKGROUND", "GameFontNormal")
	ES_tester.EDParent.EnchantNameFont:SetPoint("TOPLEFT", ES_tester.EDParent.EnchantIcon, "TOPRIGHT", 2, -2)
--	ES_tester.EDParent.EnchantNameFont:SetWidth(295)
--	ES_tester.EDParent.EnchantNameFont:SetHeight(12)
--	ES_tester.EDParent.EnchantNameFont:SetJustifyH("LEFT")

	ES_tester.EDParent.EnchantRequirementsFont = ES_tester.EDParent.EnchantIcon:CreateFontString("EnchantRequirementsFontText", "BACKGROUND", "GameFontHighlightSmall")
	ES_tester.EDParent.EnchantRequirementsFont:SetPoint("TOPLEFT", ES_tester.EDParent.EnchantNameFont, "BOTTOMLEFT",0,0)

	ES_tester.EDParent.EnchantCountsFont = ES_tester.EDParent.EnchantIcon:CreateFontString("EnchantCountsFontText", "BACKGROUND", "GameFontNormalSmall")
	ES_tester.EDParent.EnchantCountsFont:SetPoint("TOPLEFT", ES_tester.EDParent.EnchantRequirementsFont, "BOTTOMLEFT",0,0)
--	<Color r="0.85" g="0.85" b="0.85"/>

	ES_tester.EDParent.EnchantDescriptionFont = ES_tester.EDParent.EnchantIcon:CreateFontString("EnchantDescriptionFontText", "BACKGROUND", "GameFontHighlightSmall")
	ES_tester.EDParent.EnchantDescriptionFont:SetPoint("TOPLEFT", ES_tester.EDParent.EnchantIcon, "BOTTOMLEFT",0,0)
	ES_tester.EDParent.EnchantDescriptionFont:SetWidth(365)
	ES_tester.EDParent.EnchantDescriptionFont:SetHeight(0)
	ES_tester.EDParent.EnchantDescriptionFont:SetJustifyH("LEFT")

	local rtooltip=L["Reagent Header tooltip"];
	ES_tester.EDParent.HeaderName = CreateFrame("Button", "EDHeaderName", ES_tester.EDParent)
	ES_tester.EDParent.HeaderName:SetPoint("TOPLEFT", ES_tester.EDParent.EnchantDescriptionFont, "BOTTOMLEFT",0,-5)
	ES_tester.EDParent.HeaderName:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	ES_tester.EDParent.HeaderNameFont = ES_tester.EDParent.HeaderName:CreateFontString("EDHeaderNameFontText", "BORDER", "GameFontNormalSmall")
	ES_tester.EDParent.HeaderNameFont:SetPoint("LEFT",0,0)
	ES_tester.EDParent.HeaderNameFont:SetText("Reagent Name")
	ES_tester.EDParent.HeaderName:SetWidth(ES_tester.EDParent.HeaderNameFont:GetWidth())
	ES_tester.EDParent.HeaderName:SetHeight(14)
	ES_tester.EDParent.HeaderName:Hide();
	ES_tester.EDParent.HeaderNameFont:Hide();
	ES_tester.EDParent.HeaderName:SetScript("OnEnter", function()
		GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
		GameTooltip:SetText(rtooltip)
		GameTooltip:Show();
	end)
	ES_tester.EDParent.HeaderName:SetScript("OnLeave", function()
		GameTooltip:Hide()
	end)
	ES_tester.EDParent.HeaderName:SetScript("OnClick", function()
		if ( IsShiftKeyDown() ) then
--			addText = this.ChatTextForAdd;
--			if ( WIM_EditBoxInFocus and addText) then
--				WIM_EditBoxInFocus:Insert(addText);
--
--			elseif ( ChatFrameEditBox:IsVisible() and addText ) then
--				ChatFrameEditBox:Insert(addText);
--			end
		end
	end)
	ES_tester.EDParent.HeaderCount = CreateFrame("Button", "EDHeaderCount", ES_tester.EDParent)
	ES_tester.EDParent.HeaderCount:SetPoint("TOPLEFT", ES_tester.EDParent.HeaderName, "TOPRIGHT",60,0)
	ES_tester.EDParent.HeaderCount:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	ES_tester.EDParent.HeaderCountFont = ES_tester.EDParent.HeaderCount:CreateFontString("EDHeaderCountFontText", "BORDER", "GameFontNormalSmall")
	ES_tester.EDParent.HeaderCountFont:SetPoint("LEFT",0,0)
	ES_tester.EDParent.HeaderCountFont:SetText("B/CT")
	ES_tester.EDParent.HeaderCount:SetWidth(ES_tester.EDParent.HeaderCountFont:GetWidth())
	ES_tester.EDParent.HeaderCount:SetHeight(14)
	ES_tester.EDParent.HeaderCount:Hide();
	ES_tester.EDParent.HeaderCountFont:Hide();
	ES_tester.EDParent.HeaderCount:SetScript("OnEnter", function()
		GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
		GameTooltip:SetText(rtooltip)
		GameTooltip:Show();
	end)
	ES_tester.EDParent.HeaderCount:SetScript("OnLeave", function()
		GameTooltip:Hide()
	end)
	ES_tester.EDParent.HeaderCount:SetScript("OnClick", function()
		if ( IsShiftKeyDown() ) then
--			addText = this.ChatTextForAdd;
--			if ( WIM_EditBoxInFocus and addText) then
--				WIM_EditBoxInFocus:Insert(addText);
--
--			elseif ( ChatFrameEditBox:IsVisible() and addText ) then
--				ChatFrameEditBox:Insert(addText);
--			end
		end
	end)
	ES_tester.EDParent.HeaderBank = CreateFrame("Button", "EDHeaderBank", ES_tester.EDParent)
	ES_tester.EDParent.HeaderBank:SetPoint("TOPLEFT", ES_tester.EDParent.HeaderCount, "TOPRIGHT",20,0)
	ES_tester.EDParent.HeaderBank:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	ES_tester.EDParent.HeaderBankFont = ES_tester.EDParent.HeaderBank:CreateFontString("EDHeaderBankFontText", "BORDER", "GameFontNormalSmall")
	ES_tester.EDParent.HeaderBankFont:SetPoint("LEFT",0,0)
	ES_tester.EDParent.HeaderBankFont:SetText("B-RR")
	ES_tester.EDParent.HeaderBank:SetWidth(ES_tester.EDParent.HeaderBankFont:GetWidth())
	ES_tester.EDParent.HeaderBank:SetHeight(14)
	ES_tester.EDParent.HeaderBank:Hide();
	ES_tester.EDParent.HeaderBankFont:Hide();
	ES_tester.EDParent.HeaderBank:SetScript("OnEnter", function()
		GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
		GameTooltip:SetText(rtooltip)
		GameTooltip:Show();
	end)
	ES_tester.EDParent.HeaderBank:SetScript("OnLeave", function()
		GameTooltip:Hide()
	end)
	ES_tester.EDParent.HeaderBank:SetScript("OnClick", function()
		if ( IsShiftKeyDown() ) then
--			addText = this.ChatTextForAdd;
--			if ( WIM_EditBoxInFocus and addText) then
--				WIM_EditBoxInFocus:Insert(addText);
--
--			elseif ( ChatFrameEditBox:IsVisible() and addText ) then
--				ChatFrameEditBox:Insert(addText);
--			end
		end
	end)

	ES_tester.EDParent.HeaderPricePer = CreateFrame("Button", "EDHeaderPricePer", ES_tester.EDParent)
	ES_tester.EDParent.HeaderPricePer:SetPoint("TOPLEFT", ES_tester.EDParent.HeaderBank, "TOPRIGHT",40,0)
	ES_tester.EDParent.HeaderPricePer:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	ES_tester.EDParent.HeaderPricePerFont = ES_tester.EDParent.HeaderPricePer:CreateFontString("EDHeaderPricePerFontText", "BORDER", "GameFontNormalSmall")
	ES_tester.EDParent.HeaderPricePerFont:SetPoint("LEFT",0,0)
	ES_tester.EDParent.HeaderPricePerFont:SetText("Price Per")
	ES_tester.EDParent.HeaderPricePer:SetWidth(ES_tester.EDParent.HeaderPricePerFont:GetWidth())
	ES_tester.EDParent.HeaderPricePer:SetHeight(14)
	ES_tester.EDParent.HeaderPricePer:Hide();
	ES_tester.EDParent.HeaderPricePerFont:Hide();
	ES_tester.EDParent.HeaderPricePer:SetScript("OnEnter", function()
		GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
		GameTooltip:SetText(rtooltip)
		GameTooltip:Show();
	end)
	ES_tester.EDParent.HeaderPricePer:SetScript("OnLeave", function()
		GameTooltip:Hide()
	end)
	ES_tester.EDParent.HeaderPricePer:SetScript("OnClick", function()
		if ( IsShiftKeyDown() ) then
--			addText = this.ChatTextForAdd;
--			if ( WIM_EditBoxInFocus and addText) then
--				WIM_EditBoxInFocus:Insert(addText);
--
--			elseif ( ChatFrameEditBox:IsVisible() and addText ) then
--				ChatFrameEditBox:Insert(addText);
--			end
		end
	end)

	ES_tester.EDParent.HeaderPrice = CreateFrame("Button", "EDHeaderPrice", ES_tester.EDParent)
	ES_tester.EDParent.HeaderPrice:SetPoint("TOPLEFT", ES_tester.EDParent.HeaderPricePer, "TOPRIGHT",40,0)
	ES_tester.EDParent.HeaderPrice:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
	ES_tester.EDParent.HeaderPriceFont = ES_tester.EDParent.HeaderPrice:CreateFontString("EDHeaderPriceFontText", "BORDER", "GameFontNormalSmall")
	ES_tester.EDParent.HeaderPriceFont:SetPoint("LEFT",0,0)
	ES_tester.EDParent.HeaderPriceFont:SetText("Price")
	ES_tester.EDParent.HeaderPrice:SetWidth(ES_tester.EDParent.HeaderPriceFont:GetWidth())
	ES_tester.EDParent.HeaderPrice:SetHeight(14)
	ES_tester.EDParent.HeaderPrice:Hide();
	ES_tester.EDParent.HeaderPriceFont:Hide();
	ES_tester.EDParent.HeaderPrice:SetScript("OnEnter", function()
		GameTooltip:SetOwner(this,"ANCHOR_RIGHT")
		GameTooltip:SetText(rtooltip)
		GameTooltip:Show();
	end)
	ES_tester.EDParent.HeaderPrice:SetScript("OnLeave", function()
		GameTooltip:Hide()
	end)
	ES_tester.EDParent.HeaderPrice:SetScript("OnClick", function()
		if ( IsShiftKeyDown() ) then
--			addText = this.ChatTextForAdd;
--			if ( WIM_EditBoxInFocus and addText) then
--				WIM_EditBoxInFocus:Insert(addText);
--
--			elseif ( ChatFrameEditBox:IsVisible() and addText ) then
--				ChatFrameEditBox:Insert(addText);
--			end
		end
	end)


	ES_tester.EDParent.ScrollBar = CreateFrame("ScrollFrame", "ES_testerEDParentScrollBar", ES_tester.EDParent, "FauxScrollFrameTemplate")
	ES_tester.EDParent.ScrollBar:SetPoint("TOPLEFT", ES_tester.EDParent.HeaderName, "BOTTOMLEFT",0,0)
	ES_tester.EDParent.ScrollBar:SetPoint("BOTTOMRIGHT", ES_tester.EDParent, "BOTTOMRIGHT")
	ES_tester.EDParent.ScrollBar:SetScript("OnVerticalScroll", function ()
		FauxScrollFrame_OnVerticalScroll(12, ES_tester.ReagentScrollBar_Update)
	end)
	ES_tester.EDParent.ScrollBar:SetScript("OnShow", function() 
		ES_tester.ReagentScrollBar_Update()
	end)

	ES_tester.EDParent.ReagentButton={}
	for i=1, ES_tester.ReagentLines do
		ES_tester.EDParent.ReagentButton[i] = CreateFrame("Button", "EDParentReagentButton"..i, ES_tester.EDParent, "ES_Enchant_ReagentsListTemplate")
		if (i==1) then
			ES_tester.EDParent.ReagentButton[i]:SetPoint("TOPLEFT", ES_tester.EDParent.ScrollBar, "TOPLEFT", 0,0)
			ES_tester.EDParent.ReagentButton[i]:SetPoint("TOPRIGHT", ES_tester.EDParent.ScrollBar, "TOPRIGHT", 0,0)
		else 
			ES_tester.EDParent.ReagentButton[i]:SetPoint("TOPLEFT", ES_tester.EDParent.ReagentButton[i-1], "BOTTOMLEFT")
			ES_tester.EDParent.ReagentButton[i]:SetPoint("TOPRIGHT", ES_tester.EDParent.ReagentButton[i-1], "TOPRIGHT")
		end
		ES_tester.EDParent.ReagentButton[i]:SetID(i);
		ES_tester.EDParent.ReagentButton[i]:SetHighlightTexture("Interface\\QuestFrame\\UI-QuestTitleHighlight")
		ES_tester.EDParent.ReagentButton[i]:GetHighlightTexture():SetBlendMode("ADD");
		ES_tester.EDParent.ReagentButton[i]:SetScript("OnClick", function ()
			ES_tester.ReagentListOnClick()
		end)
		ES_tester.EDParent.ReagentButton[i]:Hide();
	end

end

ES_tester.ReagentListOnClick = function ()
	if ( IsShiftKeyDown() ) then
		addText = this.ChatTextForAdd;
		if ( WIM_EditBoxInFocus and addText) then
			WIM_EditBoxInFocus:Insert(addText);

		elseif ( ChatFrameEditBox:IsVisible() and addText ) then
			ChatFrameEditBox:Insert(addText);
		end
	end
end

ES_tester.EnchantListOnClick = function ()
	if ( IsShiftKeyDown() ) then
		addText = this.ChatTextForAdd;
		if ( WIM_EditBoxInFocus and addText) then
			WIM_EditBoxInFocus:Insert(addText);

		elseif ( ChatFrameEditBox:IsVisible() and addText ) then
			ChatFrameEditBox:Insert(addText);
		end
	else
		ES_tester.EnchantListOnLeftClick();
	end
end

ES_tester.EnchantListOnLeftClick = function()
	local index=nil;
	if FauxScrollFrame_GetOffset(ES_testerEFrameEnchantScrollBar) then
		index = this:GetID() + FauxScrollFrame_GetOffset(ES_testerEFrameEnchantScrollBar);
	else
		index = this:GetID();
	end

	ES_tester.SetSelection(index);

	--updates for the selected highlight texture
	ES_tester.EnchantScrollBar_Update();

	--if the Blizzard Enchanting frame is open, then update the selected enchant
	if (CraftFrame:IsShown()) and (GetCraftSkillLine(1)  == L["Enchanting"]) then
			CraftFrame_SetSelection(ES_tester.EnchantListData[ES_tester.SelectedEnchant].IdOriginal);
			CraftFrame_Update();
	end
end

ES_tester.SetSelection = function(id)
	if ( not id ) then
		return;
	end

	--store the selected value for updating the EnchantButton later on
	ES_tester.SelectedEnchant=id;
	--update the reagent list scroll
	ES_tester.ReagentScrollBar_Update()

--keep for highlighting
--	local color = CraftTypeColor[craftType];
--	CraftHighlight:SetVertexColor(color.r, color.g, color.b);
	
	-- Set Recipe Icon
	ES_tester.EDParent.EnchantIcon:SetNormalTexture(ES_tester.EnchantListData[id].Icon);
	ES_tester.EDParent.EnchantNameFont:SetText(ES_tester.EnchantListData[id].EnchantName);
	ES_tester.EDParent.EnchantRequirementsFont:SetText(ES_tester.EnchantListData[id].Required);
	ES_tester.EDParent.EnchantDescriptionFont:SetText(ES_tester.EnchantListData[id].Description);
	--todo
	ES_tester.EDParent.EnchantCountsFont:SetText("");

--save for later
--	if ( GetCraftDescription(id) ) then
--		CraftDescription:SetText(GetCraftDescription(id));
--		CraftReagentLabel:SetPoint("TOPLEFT", "CraftDescription", "BOTTOMLEFT", 0, -10);
--	else
--		CraftDescription:SetText(" ");
--		CraftReagentLabel:SetPoint("TOPLEFT", "CraftDescription", "TOPLEFT", 0, 0);
--	end
	
--	-- Reagents
--	local creatable = 1;
--	local numReagents = GetCraftNumReagents(id);
	
--	for i=1, numReagents, 1 do
--		local reagentName, reagentTexture, reagentCount, playerReagentCount = GetCraftReagentInfo(id, i);
--		local reagent = getglobal("CraftReagent"..i)
--		local name = getglobal("CraftReagent"..i.."Name");
--		local count = getglobal("CraftReagent"..i.."Count");
--		if ( not reagentName or not reagentTexture ) then
--			reagent:Hide();
--		else
--			reagent:Show();
--			SetItemButtonTexture(reagent, reagentTexture);
--			name:SetText(reagentName);
--			-- Grayout items
--			if ( playerReagentCount < reagentCount ) then
--				SetItemButtonTextureVertexColor(reagent, GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b);
--				name:SetTextColor(GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b);
--				creatable = nil;
--			else
--				SetItemButtonTextureVertexColor(reagent, 1.0, 1.0, 1.0);
--				name:SetTextColor(HIGHLIGHT_FONT_COLOR.r, HIGHLIGHT_FONT_COLOR.g, HIGHLIGHT_FONT_COLOR.b);
--			end
--			if ( playerReagentCount >= 100 ) then
--				playerReagentCount = "*";
--			end
--			count:SetText(playerReagentCount.." /"..reagentCount);
--		end
--	end
	
--	if ( numReagents > 0 ) then
--		CraftReagentLabel:Show();
--	else
--		CraftReagentLabel:Hide();
--	end
--	for i=numReagents + 1, MAX_CRAFT_REAGENTS, 1 do
--		getglobal("CraftReagent"..i):Hide();
--	end

--	local requiredTotems = BuildColoredListString(GetCraftSpellFocus(id));
--	if ( requiredTotems ) then
--		CraftRequirements:SetText(REQUIRES_LABEL.." "..requiredTotems);
--	else
--		CraftRequirements:SetText("");
--	end

	--update the Enchant button to enable or disable
	ES_tester.UpdateEnchantButton();

--	CraftDetailScrollFrame:UpdateScrollChildRect();
--	-- Show or hide scrollbar
--	if ((CraftDetailScrollFrameScrollBarScrollUpButton:IsEnabled() == 0) and (CraftDetailScrollFrameScrollBarScrollDownButton:IsEnabled() == 0) ) then
--		CraftDetailScrollFrameScrollBar:Hide();
--		CraftDetailScrollFrameTop:Hide();
--		CraftDetailScrollFrameBottom:Hide();
--	else
--		CraftDetailScrollFrameScrollBar:Show();
--		CraftDetailScrollFrameTop:Show();
--		CraftDetailScrollFrameBottom:Show();
--	end
end

ES_tester.UpdateEnchantButton = function()
	if (ES_tester.SelectedEnchant~=nil) then
--		if (EnchantingSell_Config.EnchantePlayerName == EnchantingSell_CourantPlayerName) then
--			local etat = ESUtil:GetReagentStats(ESeller.db.realm.EnchantReagents, ES_tester.SelectedEnchant);
--				rdata, enchantIndex, reagentId, playerName)

			--Etat will be 1 if you can do the chant with items in bags
			local enchantName = ES_tester.EnchantListData[ES_tester.SelectedEnchant].EnchantName;
			if ES_runtime.feasibility[enchantName] == 1 then
--			if ES_tester.EnchantListData[ES_tester.SelectedEnchant].Reagents["Feasibility"] == 1 then
--			if (etat > 0 and etat < 4) then
				ES_tester.EFrame.CraftCreateButton:Enable();
			else
				ES_tester.EFrame.CraftCreateButton:Disable();
			end
--		end
	end
end

ES_tester.DoCraft = function()
		local craftId = ES_tester.EnchantListData[ES_tester.SelectedEnchant].IdOriginal;
		local enchantName = ES_tester.EnchantListData[ES_tester.SelectedEnchant].EnchantName;
--		local name, onThis, bonusType, bonusAdd = ESell_Enchante_getInfoBonus(listIdSelectedEnchante);

--		DEFAULT_CHAT_FRAME:AddMessage("SelectedEnchant is ".. isNullOrValue(ES_tester.SelectedEnchant));
--		DEFAULT_CHAT_FRAME:AddMessage("craftId is ".. isNullOrValue(craftId));
--		DEFAULT_CHAT_FRAME:AddMessage("enchantName is ".. isNullOrValue(enchantName));
--		DEFAULT_CHAT_FRAME:AddMessage("GetCraftInfo(craftId) is ".. isNullOrValue(GetCraftInfo(craftId)));

		--hack incase the local cache of crafting has changed.
		--this prevents DoCraft from functioning properly.
		--as a result, we need to open the default enchanting frame to load the crafts
		--that forces the trade window to close, since too many frames are open.
		--so, we close ES and open/close enchanting.  that prevents the trade frame from closing.
		--i think this is also possible for hunters/warlocks that open pet frame, that are also enchanters. since their frames are considering crafting frames also
		if not (craftId and (enchantName == GetCraftInfo(craftId))) then
--			--close ES
--			Toggle_EnchantingSell();
--			
			--open/close default enchant frame to refresh local cache
			CastSpellByName(L["Enchanting"]);CastSpellByName(L["Enchanting"]);
		end
		
		SelectCraft(craftId);
		DoCraft(craftId);
		
--		local completeBonus;
--		if bonusAdd then
--			completeBonus = bonusType.." +"..bonusAdd;
--		else
--			if bonusType then
--				completeBonus = bonusType;
--			end
--		end
--		if completeBonus then completeBonus = " ("..completeBonus..")" else completeBonus = "" end
--			DEFAULT_CHAT_FRAME:AddMessage(enchanteLongName..completeBonus.." sur ...", 0.45, 1, 0.45);
			DEFAULT_CHAT_FRAME:AddMessage("Crafting "..enchantName, 0.45, 1, 0.45);

--		else
--			DEFAULT_CHAT_FRAME:AddMessage("There was a problem performing this enchant.");
--			DEFAULT_CHAT_FRAME:AddMessage(" You may need to refresh your crafting cache.  Please open the default enchanting window and try again.");
--		end
end

function ES_tester.SearchEditBox_OnTextChanged()
	local text = this:GetText():lower();

	local temp={};
	if (text~="" or text~=nil) then
		ES_tester.RefreshEnchantTable();
		for k,v in ipairs(ES_tester.EnchantListData) do
			local name=ES_tester.EnchantListData[k].EnchantName:lower();
			if (string.find(name, text)) then
				table.insert(temp, v);
			end
		end	
		ES_tester.EnchantListData=temp;
	end

	if (#ES_tester.EnchantListData>0) then
		ES_tester.SetSelection(1);
	end
	ES_tester.EnchantScrollBar_Update()

end

ES_tester.Toggle_EnchantingSell = function(tab)
	if ( not tab ) then
		if ( ES_tester.EFrame:IsVisible() ) then
			HideUIPanel(ES_tester.EFrame);
		else
			ShowUIPanel(ES_tester.EFrame);
--			local selectedFrame = getglobal(ENCHANTINGSELL_TAB_SUBFRAMES[EnchantingSell_Frame.selectedTab]);
--			if ( not selectedFrame:IsVisible() ) then
--				selectedFrame:Show()
--			end
		end
	else
--		local subFrame = getglobal(tab);
--		if ( subFrame ) then
--			PanelTemplates_SetTab(EnchantingSell_Frame, subFrame:GetID());
--			if ( EnchantingSell_Frame:IsVisible() ) then
--				if ( subFrame:IsVisible() ) then
--					HideUIPanel(EnchantingSell_Frame);
--				else
--					PlaySound("igCharacterInfoTab");
--					EnchantingSell_Frame_ShowSubFrame(tab);
--				end
--			else
--				ShowUIPanel(EnchantingSell_Frame);
--				EnchantingSell_Frame_ShowSubFrame(tab);
--			end
--		end
	end
--	ESell_ChangeEnchantePrice_Reset();
end
