ESeller = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceEvent-2.0", "AceDB-2.0", "AceDebug-2.0", "AceHook-2.1");

--local abacus = LibStub("LibAbacus-3.0")
local L = AceLibrary("AceLocale-2.2"):new("EnchantingSell");
local ESUtil = AceLibrary("EnchantingSell-Util-1.0");
local AuctionLib = AceLibrary("Auction-1.0");
local waterfall = AceLibrary("Waterfall-1.0");

ESeller:RegisterDB("EnchantingSellerDB", "EnchantingSellerDBPerChar", "char");
ESeller:RegisterDefaults("char", {
    UseTooltips = true,
    UseAuctionPricing = false,
    UseAuctionAddon = nil,
    DisableDefaultCraftFrame = true,
    DisableScanning = false,
})
ESeller:RegisterDefaults("realm", {
    DBVersion = 0,
    EnchantList={
	['*'] = {},
    },
    EnchantReagents={
	['*'] = {
		ByPlayer = {
			['*'] = {
				NbInMail=0,
				NbInBank=0,
				NbInBag=0,
			},
		},
	},
    },
    Enchanters={},
    DefaultDB={
	Reagents={},
	Enchants={},
    },
})

--constants
ESellerConstants={};
ESellerConstants.DBVersion = 30008;

--runtime variables
local ES_CurrentPlayer={};
ES_runtime={
	craftFrameOpened=false,
	shouldCloseCraftFrame=false,
	bankFrameOpened=false;
	feasibility={};
}

function ESeller:OnInitialize()
	local name = L["Enchanting Seller"];
	self.options = {
		type = "group",
		order = 1,
		name = name,
		desc = name,
		args = {
			useauctionprice = {
				order=1,
				type = 'toggle',
				name = "useauctionprice",
				guiName = "Use Auction Pricing",
				desc = "Toggle to use pricing from auction addons",
				get = function()
					return self.db.char.UseAuctionPricing;
				end,
				set = function(v)
					self.db.char.UseAuctionPricing=v;
					if (self.db.char.UseAuctionPricing) then
						AuctionLib:SetAuctionAddon(self.db.char.UseAuctionAddon);
					end
				end,
				map = { [false] = "Disabled", [true] = "Enabled" },
			},
			setauctionaddon = {
				order=2,
				type = 'text',
				name = "setauctionaddon",
				guiName = "Set Auction Addon",
				desc = "Set which Auction Addon to use. Defaults to any loaded auction addon",
				get = function()
					return self.db.char.UseAuctionAddon;
				end,
				set = function(name)
					if (AuctionLib:SetAuctionAddon(name)) then
						self.db.char.UseAuctionAddon = name;
					end
				end,
				validate = AuctionLib:GetSupportedAuctionAddons(),
			},
			ImportDefaultDB = {
				order=3,
				type = "execute",
				name = "ImportDefaultDB",
				guiName = "Import Default Data",
				desc = "Imports the default listing of enchants and components.",
				func = function() self:ImportDefaultDB(); end,
			},
			disablecraftframe = {
				order=4,
				type = 'toggle',
				name = "disablecraftframe",
				guiName = "Disable WoW Enchanting Frame",
				desc = "Toggle to allow the default craft frame to appear.",
				get = function()
					return self:isDisableCraftFrame();
				end,
				set = function(v)
					self.db.char.DisableDefaultCraftFrame=v;
				end,
				map = { [false] = "Disabled", [true] = "Enabled" },
			},
			tooltips = {
				order=5,
				type = 'toggle',
				name = "tooltips",
				guiName = "Enable Tooltips",
				desc = "Toggle material counts in tooltips",
				get = function()
					return self.db.char.UseTooltips;
				end,
				set = function(v)
					self:SetUseTooltips(v);
					self:UseTooltips_Update();
				end,
				map = { [false] = "Disabled", [true] = "Enabled" },
			},
			CreateDefaultDB = {
				order=6,
				type = "execute",
				name = "CreateDefaultDB",
				guiName = "Create Enchant Database",
				desc = "Stores a snapshot of your known enchants and materials. (Used for localization updates)",
				func = function() self:CreateDefaultDB(); end,
			},
			show = {
				order=7,
				wfHidden=true,
				type = "execute",
				name = "show",
				desc = "Launch EnchantingSeller",
				func = function() self:Launch(); end,
			},
			disablescanning = {
				order=8,
				type = 'toggle',
				name = "disablescanning",
				guiName = "Disable Enchant Scanning",
				desc = "Toggle to disable the scanning of known Enchants and Reagents.  Typically use this if you have imported the default database, or know a large percentage of Enchants already.",
				get = function()
					return self:isDisableScanning();
				end,
				set = function(v)
					self.db.char.DisableScanning=v;
				end,
				map = { [false] = "Disabled", [true] = "Enabled" },
			},
			ResetData = {
				order=9,
				type = "execute",
				name = "ResetData",
				guiName = "Reset Data",
				desc = "Reset the EnchantingSeller database.",
				func = function() self:ResetDatabase(); end,
			},
		}
	}


	--Setup our chat command interface
	self:RegisterChatCommand({ "/enchantingsell", "/enchantingseller", "/es" }, self.options, "ENCHANTINGSELL");

	-- Hook in new tooltip code
	if (IsAddOnLoaded("EnhTooltip") and IsAddOnLoaded("Stubby")) then
		Stubby.RegisterFunctionHook("EnhTooltip.AddTooltip", 500, ES_HookTooltip)
	end

	self:SecureHook("CraftFrameFilterDropDown_OnClick")
	self:SecureHook("CraftFrame_Update")

	ES_CurrentPlayer = {UnitName("player"), GetCVar("realmName")};

	waterfall:Register("EnchantingSell",
		"aceOptions", self.options,
		"title", L["Enchanting Seller"],
		"treeLevels", 5,
		"colorR", 0.8, "colorG", 0.4, "colorB", 0.8,
		"hideTreeRoot");

end

function ESeller:OpenOptions()
--	self:CreateOptions()
	waterfall:Refresh("EnchantingSell")
	waterfall:Open("EnchantingSell")
end

function ESeller:OnEnable(first)
	self:SetDebugging(false);

	-- events
	self:RegisterOurEvents();

	--self:CreateFrames();
	--for now
	ES_tester.CreateFrames();
	
	--register Escape to close our frame
	tinsert(UISpecialFrames,"ES_tester.EFrame");

	local isEnchanter = ESUtil:IsEnchanter();
	if (isEnchanter and not self.db.realm.Enchanters[ES_CurrentPlayer[1]]) then
		self.db.realm.Enchanters[ES_CurrentPlayer[1]]=true
	end

	--set auction pricing options
	local supportedTab = AuctionLib:GetSupportedAuctionAddons();
	local auctionAddon = AuctionLib:GetAuctionAddon();
	
	if (self.db.char.UseAuctionPricing) then
		local useAddon=self.db.char.UseAuctionAddon;
		if (useAddon and IsAddOnLoaded(useAddon)) then
			AuctionLib:SetAuctionAddon(useAddon);
		elseif (auctionAddon) then
			self.db.char.UseAuctionAddon=auctionAddon;
			self:Print("EnchantingSeller is now using '%q' for auction pricing data.", auctionAddon)
		end
	end

end

function ESeller:RegisterOurEvents()
	self:RegisterEvent("BAG_UPDATE", "BAG_UPDATE");
--	self:RegisterEvent("CRAFT_UPDATE", "TempEventHandler");
	self:RegisterEvent("BANKFRAME_OPENED", "BANKFRAME_OPENED");
	self:RegisterEvent("BANKFRAME_CLOSED", "BANKFRAME_CLOSED");
--	self:RegisterEvent("SKILL_LINES_CHANGED", "TempEventHandler");
	self:RegisterEvent("CRAFT_SHOW", "CRAFT_SHOW");
	self:RegisterEvent("CRAFT_CLOSE", "CRAFT_CLOSE");
end

function ESeller:CRAFT_SHOW()
	if(CraftFrame and CraftFrame:IsVisible() and self.db.char.DisableDefaultCraftFrame and CraftIsEnchanting()) then
		CloseCraft();
	else
		ES_runtime.craftFrameOpened=true;
		self:setShouldCloseCraftFrame(true)
	end
end
function ESeller:CRAFT_CLOSE()
	self:setShouldCloseCraftFrame(false)
	ES_runtime.craftFrameOpened=false;
end
function ESeller:isCraftFrameOpen()
	return ES_runtime.craftFrameOpened;
end
function ESeller:shouldCloseCraftFrame()
	return ES_runtime.shouldCloseCraftFrame;
end
function ESeller:setShouldCloseCraftFrame(value)
	ES_runtime.shouldCloseCraftFrame=value;
end

function ESeller:BANKFRAME_OPENED()
	ES_runtime.bankFrameOpened=true;
	ESUtil:UpdateReagentNumberInBank(self.db.realm.EnchantList, self.db.realm.EnchantReagents, ES_CurrentPlayer[1])
	ESUtil:UpdateFeasibility(self.db.realm.EnchantList, self.db.realm.EnchantReagents, ES_CurrentPlayer[1], ES_runtime.feasibility);

	ES_tester.repaintFrames();
end
function ESeller:BANKFRAME_CLOSED()
	ES_runtime.bankFrameOpened=false;
end
function ESeller:isBankFrameOpen()
	return ES_runtime.bankFrameOpened;
end

function ESeller:TempEventHandler()
end

function ESeller:BAG_UPDATE()
	if (not UnitAffectingCombat("player")) then
		ESUtil:UpdateReagentNumberInBag(self.db.realm.EnchantList, self.db.realm.EnchantReagents, ES_CurrentPlayer[1])
		ESUtil:UpdateFeasibility(self.db.realm.EnchantList, self.db.realm.EnchantReagents, ES_CurrentPlayer[1], ES_runtime.feasibility);

		ES_tester.repaintFrames();
	end
end

function ESeller:CraftFrame_Update()
	CraftFrameAvailableFilterCheckButton:Hide();
	CraftFrameEditBox:Hide();
	CraftFrameFilterDropDown:Hide();
end

function ESeller:CraftFrameFilterDropDown_OnClick()
	self:Print(L["EnchantingSeller has prevented you from changing this filter.  Changing this filter can have an unexpected result while using EnchantingSeller."]);
end


function ESeller:Launch()
	if (ES_tester.EFrame:IsVisible()) then
		HideUIPanel(ES_tester.EFrame);
		return;
	end

	self:CheckDatabaseVersion();

	if (not self:isDisableScanning()) then
		self:PerformScan();
	end

	--updatge pricing
	--TODO: pending pricing library
	self:UpdateEnchantPrice()

	ES_tester.RefreshEnchantTable();

	ShowUIPanel(ES_tester.EFrame);
end

function ESeller:isDisableCraftFrame()
	return self.db.char.DisableDefaultCraftFrame;
end

function ESeller:isDisableScanning()
	return self.db.char.DisableScanning;
end

function ESeller:PerformScan()
	--opens the default crafting frame and loads the enchants and reagents into temp tables
	local enchantList = {};
	local reagentList = {};
	ESUtil:RetrieveCraftList(enchantList,reagentList);

	--since the database stores all enchants for all toons, and even supports unknown chants
	--we first update them all to unknown for this character, 
	-- and then when the merge occurs
	-- we update them to true for this character.
	-- that allows the UI to show the unknown ones in grey
	ESUtil:UpdateKnownEnchants(self.db.realm.EnchantList, false);

	--merge the newly retrieved data with the stored data.
	ESUtil:MergeEnchantTables(self.db.realm.EnchantList, enchantList);
	ESUtil:MergeReagentTables(self.db.realm.EnchantReagents, reagentList);

	--build extra data.
	ESUtil:AddBonusInfo(self.db.realm.EnchantList);
end

function ESeller:CreateDefaultDB()
	-- in order to create a default database that is stored in the saved variables file.
	self.db.realm.DefaultDB ={};
	self.db.realm.DefaultDB.Reagents = self.db.realm.EnchantReagents;
	self.db.realm.DefaultDB.Enchants = self.db.realm.EnchantList;

	for j, enchanteTable in ipairs(self.db.realm.DefaultDB.Enchants) do
		enchanteTable["IdOriginal"] = nil;
		enchanteTable["IsKnow"] = nil;
		enchanteTable["BasePrice"] = nil;
		enchanteTable["PriceNoBenef"] = nil;
		enchanteTable["TypePrice"] = nil;
		enchanteTable["Reagents"]["Feasibility"] = -2;
	end
	for i, reagent in ipairs(self.db.realm.DefaultDB.Reagents) do
		reagent["ByPlayer"] = nil;
		reagent["IsUse"] = nil;
	end

	self:Print(L["A copy of your enchants and reagents has been created.  Logoff and exit the game and follow the rest of the instructions"]);
	return;
end

function ESeller:ImportDefaultDB()
	if (not L["DEFAULT_DATABASE"]) then
		self:Print(L["Default database not yet supported for your client locale"]);
		return;
	end

	self:LoadDefaultReagents()
	self:LoadDefaultEnchants()

	--build extra data.
	ESUtil:AddBonusInfo(self.db.realm.EnchantList);

	self.db.realm.DBVersion=ESellerConstants.DBVersion;

	self:BAG_UPDATE();
	self:UpdateEnchantPrice()
	ES_tester.repaintFrames();


	self:Print(L["Import complete"]);

end


function ES_HookTooltip(funcVars, retVal, frame, name, link, quality, count)
	if (ESeller:UseTooltips()) then
--		local idReagent = ESell_Reagent_getId(name);

--		if idReagent then
--			local nbInBag, nbInBank, nbInReroll = ESell_Reagent_getCount(idReagent);
--			local money=abacus:FormatMoneyFull(ESell_Reagent_getPrice(idReagent), true);
--
--			EnhTooltip.AddSeparator()
--			EnhTooltip.AddLine(ENCHANTINGSELL_TOOLTIPADD_TITLE..":", nil, false);
--			EnhTooltip.LineColor(0,1,1);
--			EnhTooltip.AddLine(ENCHANTINGSELL_TOOLTIPADD_ONME..": "..nbInBag, nil, false);
--			EnhTooltip.LineColor(1,0.3,1);
--			EnhTooltip.AddLine(ENCHANTINGSELL_TOOLTIPADD_INBANK..": "..nbInBank, nil, false);
--			EnhTooltip.LineColor(1,0.3,1);
--			EnhTooltip.AddLine(ENCHANTINGSELL_TOOLTIPADD_OTHERPLAYER..": "..nbInReroll, nil, false);
--			EnhTooltip.LineColor(1,0.3,1);
--			EnhTooltip.AddLine(ENCHANTINGSELL_TOOLTIPADD_PRICEUNITE..": "..money, nil, false);
--			EnhTooltip.LineColor(1,0.3,1);
--		end
	end

end

function ESeller:UseTooltips_Update()
	--need to hook tooltip
	if (self:UseTooltips()) then
		if (IsAddOnLoaded("EnhTooltip") and IsAddOnLoaded("Stubby")) then
			Stubby.RegisterFunctionHook("EnhTooltip.AddTooltip", 500, ES_HookTooltip)
		end
	else
		if (IsAddOnLoaded("EnhTooltip") and IsAddOnLoaded("Stubby")) then
			Stubby.UnregisterFunctionHook("EnhTooltip.AddTooltip", ES_HookTooltip)
		end
	end
end

function ESeller:UseTooltips()
	return self.db.char.UseTooltips;
end

function ESeller:SetUseTooltips(value)
	self.db.char.UseTooltips=value;
end

-- this function will compare the current DB version, and the users DB version and see if it needs to be updated.
-- this will only be used when key data has changed, like the occurence in wow patch 2.0.1, when itemlinks were changed.
function ESeller:CheckDatabaseVersion()

	local needsCleaning=false;
	
	if (self.db.realm.DBVersion<ESellerConstants.DBVersion) then
		self:Print(L["EnchantingSeller has detected that your database is outdated.  It will be reset now."]);
		self:ResetDatabase();
	end
	
end

function ESeller:ResetDatabase()
	self:ResetDB("realm");
	self.db.realm.DBVersion=ESellerConstants.DBVersion;
end

function ESeller:UpdateEnchantPrice()
	local enchantTable = self.db.realm.EnchantList;
	local reagentTable = self.db.realm.EnchantReagents;
	local temp=1;
	for k,enchant in pairs(enchantTable) do
		local price = 0;
		local isGoodPrice = 1;
		for numComponant=1, #enchant.Reagents,1 do
			local reagents = enchant.Reagents;
			local reagentName = reagents[numComponant].Name;
			local reagentCount = reagents[numComponant].Count;
--			local reagentId = ESUtil:GetReagentId(reagentTable, reagentName);
			local reagentLink = ESUtil:GetReagentLink(reagentTable, reagentName);
			local pricePer = 0;
			
			if (self.db.char.UseAuctionPricing) then
				pricePer = AuctionLib:GetPrice(reagentLink);
			end

--			if not pricePer or pricePer == 0 then isGoodPrice = -1;  priceUnite = 0 end
			if not pricePer then pricePer=0 end

			price = price + (pricePer*reagentCount);

--			if (temp==1) then
--				self:Print("reagentName is "..reagentName)
--				self:Print("reagentCount is "..reagentCount)
--				self:Print("reagentLink is "..reagentLink)
--				self:Print("pricePer is "..pricePer)
--			end
		end

		enchantTable[k].BasePrice = price;
		
--		if EnchantingSell_ListEnchante[idEnchante]["TypePrice"] ~= 2 then
--			price = floor(price * EnchantingSell_PlayerConfig.PourcentageBenefice);
--
--			if not EnchantingSell_Config.EnchantePriceTypeCalculate then EnchantingSell_Config.EnchantePriceTypeCalculate = 1 end
--			local priceType = EnchantingSell_Config.EnchantePriceTypeCalculate;
--			local pricerounded = 0;
--			local goldprice = ESell_Money_getMoney("Gold", price);
--			local silverprice = ESell_Money_getMoney("Silver", price);
--			local copperprice = ESell_Money_getMoney("Copper", price);
--			if priceType == 1 then pricerounded = price end
--			if priceType == 2 then
--				if goldprice ~= 0 then
--					pricerounded = floor(goldprice*10000 + silverprice*100);
--					if copperprice ~= 0 then pricerounded = pricerounded+100 end
--				else
--					pricerounded = price;
--				end
--			end
--			if priceType == 3 then
--				if goldprice ~= 0 then
--					pricerounded = floor(goldprice*10000);
--					if silverprice ~= 0 then pricerounded = pricerounded+10000 end
--				else
--					if silverprice ~= 0 then
--						pricerounded = floor(silverprice*100);
--						if copperprice ~= 0 then pricerounded = pricerounded+100 end
--					else
--						pricerounded = price;
--					end
--				end
--			end
--			
--			EnchantingSell_ListEnchante[idEnchante]["Price"] = pricerounded;
--			EnchantingSell_ListEnchante[idEnchante]["TypePrice"] = isGoodPrice;
--		end
		temp=temp+1;
	end
end


function ESeller:LoadDefaultReagents()
	local reagents = L["DEFAULT_DATABASE"].Reagents;
	ESUtil:MergeReagentTables(self.db.realm.EnchantReagents, reagents)
end

function ESeller:LoadDefaultEnchants()
	local enchants = L["DEFAULT_DATABASE"].Enchants;
	ESUtil:MergeEnchantTables(self.db.realm.EnchantList, enchants)
end



function ESeller:TestPrices()
--	["Link"] = "|cff0070dd|Hitem:22449:0:0:0:0:0:0:0|h[Large Prismatic Shard]|h|r",

	AuctionLib:SetAuctionAddon("Auctioneer");
	local price = AuctionLib:GetPrice("|cff0070dd|Hitem:22449:0:0:0:0:0:0:0|h[Large Prismatic Shard]|h|r");

	if (price) then
		self:Print("Price for Large Prismatic Shard is "..price );
	else 
		self:Print("price was nil");
	end
end

function ESeller:TestPrices1()
--	["Link"] = "|cff0070dd|Hitem:22449:0:0:0:0:0:0:0|h[Large Prismatic Shard]|h|r",

	local price = AuctionLib:GetPrice("|cff0070dd|Hitem:22449:0:0:0:0:0:0:0|h[Large Prismatic Shard]|h|r");

	if (price) then
		self:Print("Price for Large Prismatic Shard is "..price );
	else 
		self:Print("price was nil");
	end
end
