--[[
Name: EnchantingSell-Debug-1.0
Author(s): Shamino
Website: 
Documentation: 
SVN: 
Description: A debug utility library for Enchanting
Dependencies: AceLibrary
]]

local MAJOR_VERSION = "EnchantingSell-Debug-1.0"
local MINOR_VERSION = 1000

if not AceLibrary then error(MAJOR_VERSION .. " requires AceLibrary") end
if not AceLibrary:HasInstance("AceLocale-2.2") then error(MAJOR_VERSION .. " requires AceLocale-2.2") end
if not AceLibrary:IsNewVersion(MAJOR_VERSION, MINOR_VERSION) then return end

local EnchantingSellDebug = {}
local ESD={
	Data={},
	LogLines=20,
};

function EnchantingSellDebug:init()
	self:createDebugFrame()
	self:showDebugFrame()
end

function EnchantingSellDebug:showDebugFrame() 
	ESD.Frame:Show() 
end
function EnchantingSellDebug:hideDebugFrame() 
	ESD.Frame:Hide() 
end

function EnchantingSellDebug:addLine(value)
	table.insert(ESD.Data, 1, value);
	if (not ESD.Frame) then 
		self:init()
	end
	ESD.Debug.Update()
end

--create the debug frame
function EnchantingSellDebug:createDebugFrame()
	if (ESD.Frame) then return end
	ESD.Frame = CreateFrame("Frame", "ESD.Frame", UIParent)
	ESD.Frame:Hide()
	ESD.Frame:SetPoint("TOP", "UIParent", "TOP", 0, -100)
	ESD.Frame:SetFrameStrata("DIALOG")
	ESD.Frame:SetWidth(400)
	ESD.Frame:SetHeight(200)
	ESD.Frame:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 32, edgeSize = 32,
		insets = { left = 9, right = 9, top = 9, bottom = 9 }
	})
	ESD.Frame:SetBackdropColor(0,0,0, 0.8)
	ESD.Frame:SetMovable(true)

	ESD.Frame.Drag = CreateFrame("Button", "", ESD.Frame)
	ESD.Frame.Drag:SetPoint("TOPLEFT", ESD.Frame, "TOPLEFT", 10,-5)
	ESD.Frame.Drag:SetPoint("TOPRIGHT", ESD.Frame, "TOPRIGHT", -10,-5)
	ESD.Frame.Drag:SetHeight(6)
	ESD.Frame.Drag:SetHighlightTexture("Interface\\FriendsFrame\\UI-FriendsFrame-HighlightBar")
	ESD.Frame.Drag:SetScript("OnMouseDown", function() ESD.Frame:StartMoving() end)
	ESD.Frame.Drag:SetScript("OnMouseUp", function() ESD.Frame:StopMovingOrSizing() end)

	ESD.Frame.CloseButton = CreateFrame("Button", "", ESD.Frame, "UIPanelCloseButton")
	ESD.Frame.CloseButton:SetPoint("TOPRIGHT", ESD.Frame, "TOPRIGHT")
	ESD.Frame.CloseButton:SetFrameLevel(ESD.Frame:GetFrameLevel()+4)

	ESD.Debug = CreateFrame("Frame", "ESD.Debug", ESD.Frame)
	ESD.Debug:SetPoint("TOPLEFT", ESD.Frame, "TOPLEFT", 5,-5)
	ESD.Debug:SetWidth(375)
	ESD.Debug:SetHeight(190)
	ESD.Debug:SetBackdrop({
		bgFile = "Interface\\AddOns\\BtmScan\\Textures\\Back",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = true, tileSize = 128, edgeSize = 16,
		insets = { left = 6, right = 6, top = 6, bottom = 6
	}})
	ESD.Debug:Show()

	ESD.Debug.ScrollBar = CreateFrame("ScrollFrame", "ESD.Debug.ScrollBar", ESD.Debug, "FauxScrollFrameTemplate")
	ESD.Debug.ScrollBar:SetPoint("TOPLEFT", ESD.Debug, "TOPLEFT",0,-5)
	ESD.Debug.ScrollBar:SetPoint("BOTTOMRIGHT", ESD.Debug, "BOTTOMRIGHT")

	ESD.Debug.Update = function()
		if (not ESD.Data) then return end
		local rows = table.getn(ESD.Data)
		local scrollrows = rows
		if (scrollrows > 0 and scrollrows < ESD.LogLines+1) then scrollrows = ESD.LogLines+1 end
		FauxScrollFrame_Update(ESD.Debug.ScrollBar, scrollrows, ESD.LogLines, ESD.LogLines*2)
		local line
		for i=1, ESD.LogLines do
			line = rows - (FauxScrollFrame_GetOffset(ESD.Debug.ScrollBar) + i) + 1
			if (rows > 0 and line <= rows and line > 0) then
--				getglobal("ESDDebug"..i):SetText(ESD.Data[line])
				ESD.Debug.Lines[i]:SetText(ESD.Data[line])
			else
--				getglobal("ESDDebug"..i):SetText("")
				ESD.Debug.Lines[i]:SetText("")
			end
		end
	end

	ESD.Debug.ScrollBar:SetScript("OnVerticalScroll", function ()
		FauxScrollFrame_OnVerticalScroll(16, ESD.Debug.Update)
	end)
	ESD.Debug.ScrollBar:SetScript("OnShow", function() 
		ESD.Debug.Update()
	end)

	ESD.Debug.LineFrames = {}
	ESD.Debug.Lines = {}
	for i=1, ESD.LogLines do
		ESD.Debug.LineFrames[i] = CreateFrame("Frame", "ESDDebug"..i, ESD.Debug)
		if (i == 1) then
			ESD.Debug.LineFrames[i]:SetPoint("TOPLEFT", ESD.Debug, "TOPLEFT", 10, -10)
			ESD.Debug.LineFrames[i]:SetPoint("RIGHT", ESD.Debug, "RIGHT", -20, 0)
		else
			ESD.Debug.LineFrames[i]:SetPoint("TOPLEFT", ESD.Debug.LineFrames[i-1], "BOTTOMLEFT")
			ESD.Debug.LineFrames[i]:SetPoint("RIGHT", ESD.Debug.LineFrames[i-1], "RIGHT")
		end
		ESD.Debug.LineFrames[i]:SetHeight(10)
		ESD.Debug.LineFrames[i].lineID = i
		ESD.Debug.LineFrames[i]:EnableMouse(true)
--		ESD.Debug.LineFrames[i]:SetScript("OnEnter", BtmScan.DoTooltip)
--		ESD.Debug.LineFrames[i]:SetScript("OnLeave", BtmScan.UndoTooltip)

		ESD.Debug.Lines[i] = ESD.Debug.LineFrames[i]:CreateFontString("ESDDebugLogLine"..i, "HIGH")
		ESD.Debug.Lines[i]:SetPoint("TOPLEFT", ESD.Debug.LineFrames[i], "TOPLEFT")
		ESD.Debug.Lines[i]:SetWidth(375)
		ESD.Debug.Lines[i]:SetFont("Fonts\\FRIZQT__.TTF",11)
		ESD.Debug.Lines[i]:SetJustifyH("LEFT")
		ESD.Debug.Lines[i]:SetText("Text"..i)
		ESD.Debug.Lines[i]:Show()
	end
end

AceLibrary:Register(EnchantingSellDebug, MAJOR_VERSION, MINOR_VERSION)
EnchantingSellDebug=nil;
