ECVars = {};

local EasyCopy_Original_ChatFrame_OnEvent;
local EasyCopy_Original_SetItemRef;
local EasyCopy_ShortMsgButtons = { "[2. Trade][Someguy]: ...", "[Trade][Someguy]: ...", "[2][Someguy]: ...", "[Someguy]: ..." };

EasyCopy_RecentAFK = {};
EasyCopy_RecentAFK_Time = {};
EasyCopy_RecentDND = {};
EasyCopy_RecentDND_Time = {};

function EasyCopy_OnLoad()
	if (not EasyCopy_Original_ChatFrame_OnEvent) then
		EasyCopy_Original_ChatFrame_OnEvent = ChatFrame_OnEvent;
	end
	if (strsub(GetBuildInfo(), 1, 1) == 2) then
		ChatFrame_OnEvent = EasyCopy_ChatFrame_v2_OnEvent;
	else
		ChatFrame_OnEvent = EasyCopy_ChatFrame_v2_OnEvent;
	end
	
	if (not EasyCopy_Original_SetItemRef) then
		EasyCopy_Original_SetItemRef = SetItemRef;
	end
	SetItemRef = EasyCopy_SetItemRef;
	
	EasyCopyTitle:SetText("EasyCopy");
	
	if(ECVars.msgPrefix == nil) then
		ECVars.msgPrefix = "";
		DEFAULT_CHAT_FRAME:AddMessage("This is the first time you are running EasyCopy. Type /ec to bring up the options frame.");
	end
	
	if(ECVars.buttons == nil) then
		ECVars.buttons = 0;
	end
	EasyCopy_UpdateButtons();
	
	if(ECVars.mWheelScroll == nil) then
		ECVars.mWheelScroll = 1;
	end
	EasyCopy_MWheelOverlay_Update();
	
	if(ECVars.tabFlashing == nil) then
		ECVars.tabFlashing = 1;
	end
	
	if(ECVars.shortMSG == nil) then
		ECVars.shortMSG = 0;
	end
	
	if(ECVars.stickyChannels == nil) then
		ECVars.stickyChannels = 0;
	end
	
	if(ECVars.stickyChannels == 1) then
		ChatTypeInfo["CHANNEL"].sticky = 1;
	end
	
	ChatFrame1UpButton:SetScript("OnShow", EasyCopy_UpdateButtons);
	ChatFrame2UpButton:SetScript("OnShow", EasyCopy_UpdateButtons);
	ChatFrame3UpButton:SetScript("OnShow", EasyCopy_UpdateButtons);
	ChatFrame4UpButton:SetScript("OnShow", EasyCopy_UpdateButtons);
	ChatFrame5UpButton:SetScript("OnShow", EasyCopy_UpdateButtons);
	ChatFrame6UpButton:SetScript("OnShow", EasyCopy_UpdateButtons);
	ChatFrame7UpButton:SetScript("OnShow", EasyCopy_UpdateButtons);
	
	ChatFrame1TabFlash:SetScript("OnShow", EasyCopy_RemoveFlash);
	ChatFrame2TabFlash:SetScript("OnShow", EasyCopy_RemoveFlash);
	ChatFrame3TabFlash:SetScript("OnShow", EasyCopy_RemoveFlash);
	ChatFrame4TabFlash:SetScript("OnShow", EasyCopy_RemoveFlash);
	ChatFrame5TabFlash:SetScript("OnShow", EasyCopy_RemoveFlash);
	ChatFrame6TabFlash:SetScript("OnShow", EasyCopy_RemoveFlash);
	ChatFrame7TabFlash:SetScript("OnShow", EasyCopy_RemoveFlash);
	
	SlashCmdList["EasyCopy"] = EasyCopyCMD;
	SLASH_EasyCopy1 = "/easycopy";
	SLASH_EasyCopy2 = "/ec";
	
	EasyCopy_core:RegisterForDrag("LeftButton");
	EasyCopyOptions_core:RegisterForDrag("LeftButton");
	
	-- EasyCopyOptions_ShortMessages:
	UIDropDownMenu_SetWidth(162, EasyCopyOptions_ShortMessages);
	UIDropDownMenu_SetButtonWidth(20, EasyCopyOptions_ShortMessages);
	UIDropDownMenu_Initialize(EasyCopyOptions_ShortMessages, EasyCopyOptions_ShortMessages_Initialise);
	UIDropDownMenu_JustifyText("LEFT", EasyCopyOptions_ShortMessages)
	
	-- DEFAULT_CHAT_FRAME:AddMessage("EasyCopy loaded");
	-- UIErrorsFrame:AddMessage("EasyCopy loaded", 1.0, 1.0, 1.0, 1.0, UIERRORS_HOLD_TIME);
end

function EasyCopyOptions_ShortMessages_Initialise()
	level = level or 1;
	local info = UIDropDownMenu_CreateInfo();
	
	info.text = EasyCopy_ShortMsgButtons[1];
	info.value = 0;
	info.func = function() EasyCopyOptions_ShortMessages_OnClick() end;
	info.owner = this:GetParent(); --binds the drop down menu as the parent of the menu item. This is very important for dynamic drop down menues.
	info.checked = nil;
	info.icon = nil;
	UIDropDownMenu_AddButton(info, level);
	
	info.text = EasyCopy_ShortMsgButtons[2];
	info.value = 1;
	info.func = function() EasyCopyOptions_ShortMessages_OnClick() end;
	info.owner = this:GetParent();
	info.checked = nil;
	info.icon = nil;
	UIDropDownMenu_AddButton(info, level);
	
	info.text = EasyCopy_ShortMsgButtons[3];
	info.value = 2;
	info.func = function() EasyCopyOptions_ShortMessages_OnClick() end;
	info.owner = this:GetParent();
	info.checked = nil;
	info.icon = nil;
	UIDropDownMenu_AddButton(info, level);
	
	info.text = EasyCopy_ShortMsgButtons[4];
	info.value = 3;
	info.func = function() EasyCopyOptions_ShortMessages_OnClick() end;
	info.owner = this:GetParent();
	info.checked = nil;
	info.icon = nil;
	UIDropDownMenu_AddButton(info, level);
end

function EasyCopyOptions_ShortMessages_OnClick()
	UIDropDownMenu_SetSelectedValue(this.owner, this.value);
	ECVars.shortMSG = this.value;
end

function EasyCopy_OnEvent(event, arg1)
	if (event == "VARIABLES_LOADED") then
		EasyCopy_OnLoad();
	elseif (event == "PLAYER_ENTERING_WORLD") then
		EasyCopy_UpdateButtons();
	end
end

function EasyCopyCMD(msg)
	local args = "";
	cmd = strtrim(strlower(msg));
	if (strfind(cmd, " ") ~= nil) then
		args = strsub(cmd, strfind(cmd, " ") + 1);
		cmd = strsub(cmd, 0, strfind(cmd, " ") - 1);
	end
	
	if (cmd == "") then
		EasyCopyOptions_core:Show();
	elseif (cmd == "buttons") then
		if ((args == "" and ECVars.buttons == 0) or args == "off" or args == "1" or args == "hide") then
			ECVars.buttons = 1;
			EasyCopy_UpdateButtons();
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Scroll Buttons are now hidden");
		else
			ECVars.buttons = 0;
			EasyCopy_UpdateButtons();
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Scroll Buttons are now shown");
		end
	elseif (cmd == "mwheel") then
		if ((args == "" and ECVars.mWheelScroll == 0) or args == "on" or args == "1" or args == "enable") then
			ECVars.mWheelScroll = 1;
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Mouse wheel scrolling enabled");
		else
			ECVars.mWheelScroll = 0;
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Mouse wheel scrolling disabled");
		end
		EasyCopy_MWheelOverlay_Update();
	elseif (cmd == "flash") then
		if ((args == "" and ECVars.tabFlashing == 0) or args == "off" or args == "1" or args == "disable" or args == "hide") then
			ECVars.tabFlashing = 1;
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Tab-flashing disabled");
		else
			ECVars.tabFlashing = 0;
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Tab-flashing enabled");
		end
	elseif (cmd == "short") then
		if ((args == "" and ECVars.shortMSG == 0) or args == "on" or args == "1") then
			ECVars.shortMSG = 1;
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Displaying short messages");
		elseif (ECVars.shortMSG == 1) then
			ECVars.shortMSG = 0;
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Displaying original messages (long)");
		end
	elseif (cmd == "sticky") then
		if ((args == "" and ECVars.stickyChannels == 0) or args == "on" or args == "1" or args == "enable") then
			ECVars.stickyChannels = 1;
			ChatTypeInfo["CHANNEL"].sticky = 1;
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Sticky channels enabled");
		elseif (ECVars.stickyChannels == 1) then
			ECVars.stickyChannels = 0;
			ChatTypeInfo["CHANNEL"].sticky = 0;
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Sticky channels disabled");
		end
	elseif (cmd == "style") then
		ECVars.msgPrefix = tostring(args);
		if (args == "") then
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Message style: [13:37:00] [...");
		else
			DEFAULT_CHAT_FRAME:AddMessage("EasyCopy - Message style: "..ECVars.msgPrefix.." [...");
		end
	elseif (cmd == "memory" or cmd == "usage") then
		DEFAULT_CHAT_FRAME:AddMessage("EasyCopy uses "..floor(GetAddOnMemoryUsage("EasyCopy")).."kb memory.");
	end
end

function EasyCopy_UpdateButtons()
	if (ECVars.buttons == 1) then
		ChatFrameMenuButton:Hide();
		ChatFrame1UpButton:Hide();
		ChatFrame1DownButton:Hide();
		ChatFrame1BottomButton:Hide();
		ChatFrame2UpButton:Hide();
		ChatFrame2DownButton:Hide();
		ChatFrame2BottomButton:Hide();
		ChatFrame3UpButton:Hide();
		ChatFrame3DownButton:Hide();
		ChatFrame3BottomButton:Hide();
		ChatFrame4UpButton:Hide();
		ChatFrame4DownButton:Hide();
		ChatFrame4BottomButton:Hide();
		ChatFrame5UpButton:Hide();
		ChatFrame5DownButton:Hide();
		ChatFrame5BottomButton:Hide();
		ChatFrame6UpButton:Hide();
		ChatFrame6DownButton:Hide();
		ChatFrame6BottomButton:Hide();
		ChatFrame7UpButton:Hide();
		ChatFrame7DownButton:Hide();
		ChatFrame7BottomButton:Hide();
	else
		ChatFrameMenuButton:Show();
	end
end

function EasyCopy_RemoveFlash()
	if (ECVars.tabFlashing == 1) then
		UIFrameFlashRemoveFrame(this);
		this:Hide();
	end
end

function EasyCopy_ChatFrame_v2_OnEvent(event)
	EasyCopy_Original_ChatFrame_OnEvent(event);
	if(not this.EasyCopy_Original_AddMessage) then
		this.EasyCopy_Original_AddMessage = this.AddMessage;
		this.AddMessage = EasyCopy_AddMessage;
	end
end

function EasyCopy_ChatFrame_v3_OnEvent(self, event, ...)
	EasyCopy_Original_ChatFrame_OnEvent(self, event, ...);
	if(not this.EasyCopy_Original_AddMessage) then
		this.EasyCopy_Original_AddMessage = this.AddMessage;
		this.AddMessage = EasyCopy_AddMessage;
	end
end

function EasyCopy_AddMessage(this, msg, r, g, b, id)
	local timestamp = "";
	--this:EasyCopy_Original_AddMessage(gsub(msg, "|", "||"), 0.8, 0.8, 0.8);
	if (GetLocale() ~= "deDE") then
		msg = gsub(msg, "{stern}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_1:0|t");
		msg = gsub(msg, "{kreis}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_2:0|t");
		msg = gsub(msg, "{diamant}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_3:0|t");
		msg = gsub(msg, "{dreieck}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_4:0|t");
		msg = gsub(msg, "{mond}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_5:0|t");
		msg = gsub(msg, "{quadrat}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_6:0|t");
		msg = gsub(msg, "{kreuz}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_7:0|t");
		msg = gsub(msg, "{totensch\195\164del}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_8:0|t");
	elseif ((GetLocale() ~= "enGB") and (GetLocale() ~= "enUS")) then
		msg = gsub(msg, "{star}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_1:0|t");
		msg = gsub(msg, "{circle}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_2:0|t");
		msg = gsub(msg, "{diamond}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_3:0|t");
		msg = gsub(msg, "{triangle}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_4:0|t");
		msg = gsub(msg, "{moon}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_5:0|t");
		msg = gsub(msg, "{square}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_6:0|t");
		msg = gsub(msg, "{cross}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_7:0|t");
		msg = gsub(msg, "{skull}", "|TInterface\\TargetingFrame\\UI-RaidTargetingIcon_8:0|t");
	end
	msg = gsub(msg, "{heart}", "|TInterface\\AddOns\\EasyCopy\\heart:0|t");
	msg = gsub(msg, "{herz}", "|TInterface\\AddOns\\EasyCopy\\heart:0|t");
	if ((strsub(msg, 1, 1) == "[") and (strsub(msg, 3, 4) == ". ")) then
		local msgpart = strsub(msg, 2, strfind(msg, "]") - 1);
		if (ECVars.shortMSG == 1) then
			msgpart = strsub(msgpart, 4);
		elseif (ECVars.shortMSG == 2) then
			msgpart = strsub(msgpart, 1, 1);
		end
		if (ECVars.shortMSG < 3) then
			msgpart = "|Hezcc:"..strsub(msg, 2, 3).."|h["..msgpart.."]|h ";
		else
			msgpart = "";
		end
		msg = msgpart..strsub(msg, strfind(msg, "]")+2);
	end
	if (ECVars.shortMSG == 0) then
		if (strsub(msg, 1, 8) == "[Guild] ") then
			msg = "|Hezcc:g|h[Guild]|h"..strsub(msg, 8);
		elseif (strsub(msg, 1, 8) == "[Gilde] ") then
			msg = "|Hezcc:g|h[Gilde]|h"..strsub(msg, 8);
		elseif (strsub(msg, 1, 10) == "[Officer] ") then
			msg = "|Hezcc:o|h[Officer]|h"..strsub(msg, 10);
		elseif (strsub(msg, 1, 11) == "[Offizier] ") then
			msg = "|Hezcc:o|h[Offizier]|h"..strsub(msg, 11);
		elseif (strsub(msg, 1, 8) == "[Party] ") then
			msg = "|Hezcc:p|h[Party]|h"..strsub(msg, 8);
		elseif (strsub(msg, 1, 9) == "[Gruppe] ") then
			msg = "|Hezcc:p|h[Gruppe]|h"..strsub(msg, 9);
		elseif (strsub(msg, 1, 7) == "[Raid] ") then
			msg = "|Hezcc:r|h[Raid]|h"..strsub(msg, 7);
		elseif (strsub(msg, 1, 14) == "[Schlachtzug] ") then
			msg = "|Hezcc:r|h[Schlachtzug]|h"..strsub(msg, 14);
		elseif (strsub(msg, 1, 14) == "[Raid Leader] ") then
			msg = "|Hezcc:r|h[Raid Leader]|h"..strsub(msg, 14);
		elseif (strsub(msg, 1, 21) == "[Schlachtzugsleiter] ") then
			msg = "|Hezcc:r|h[Schlachtzugsleiter]|h"..strsub(msg, 21);
		elseif (strsub(msg, 1, 15) == "[Raid Warning] ") then
			msg = "|Hezcc:w|h[Raid Warning]|h"..strsub(msg, 15);
		elseif (strsub(msg, 1, 22) == "[Schlachtzugswarnung] ") then
			msg = "|Hezcc:w|h[Schlachtzugswarnung]|h"..strsub(msg, 22);
		elseif (strsub(msg, 1, 15) == "[Battleground] ") then
			msg = "|Hezcc:b|h[Battleground]|h"..strsub(msg, 15);
		elseif (strsub(msg, 1, 15) == "[Schlachtfeld] ") then
			msg = "|Hezcc:b|h[Schlachtfeld]|h"..strsub(msg, 15);
		elseif (strsub(msg, 1, 22) == "[Battleground Leader] ") then
			msg = "|Hezcc:b|h[Battleground Leader]|h"..strsub(msg, 22);
		elseif (strsub(msg, 1, 21) == "[Schlachtfeldleiter] ") then
			msg = "|Hezcc:b|h[Schlachtfeldleiter]|h"..strsub(msg, 21);
		end
	else
		msg = gsub(msg, "]|h whispers:", "]|h:");
		msg = gsub(msg, "]|h fl\195\188stert:", "]|h:");
		msg = gsub(msg, "<AFK>|H", "|H");
		msg = gsub(msg, "<DND>|H", "|H");
		msg = gsub(msg, "|h is Away From Keyboard:", "|h AFK:");
		msg = gsub(msg, "|h ist nicht an der Tastatur:", "|h AFK:");
		msg = gsub(msg, "|h does not wish to be disturbed:", "|h DND:");
		msg = gsub(msg, "|h m\195\182chte nicht gest\195\182rt werden:", "|h DND:");
		if (strfind(msg, "|h AFK:") ~= nil) then
			local _, _, cplayer = strfind(msg, "|h(.+)|h");
			cplayer = strsub(cplayer, 2, strlen(cplayer)-1);
			local AFKmsg = strsub(msg, strfind(msg, "AFK:") + 5);
			if (EasyCopy_RecentAFK_Time[cplayer] == nil) then
				EasyCopy_RecentAFK[cplayer] = AFKmsg;
			else
				if (EasyCopy_RecentAFK_Time[cplayer] > (time() - 5)) then
					if (EasyCopy_RecentAFK[cplayer] == AFKmsg) then
						EasyCopy_RecentAFK_Time[cplayer] = time();
						return;
					else
						EasyCopy_RecentAFK[cplayer] = AFKmsg;
					end
				end
			end
			EasyCopy_RecentAFK_Time[cplayer] = time();
		elseif (strfind(msg, "|h DND:") ~= nil) then
			local _, _, cplayer = strfind(msg, "|h(.+)|h");
			cplayer = strsub(cplayer, 2, strlen(cplayer)-1);
			local DNDmsg = strsub(msg, strfind(msg, "DND:") + 5);
			EasyCopy_RecentDND_Time[cplayer] = time();
			if (EasyCopy_RecentDND_Time[cplayer] == nil) then
				EasyCopy_RecentDND[cplayer] = DNDmsg;
			else
				if (EasyCopy_RecentDND_Time[cplayer] < (time() + 90)) then
					if (EasyCopy_RecentDND[cplayer] == DNDmsg) then
						return;
					else
						EasyCopy_RecentDND[cplayer] = DNDmsg;
					end
				end
			end
		end
		if (ECVars.shortMSG == 3) then
			if (strsub(msg, 1, 8) == "[Guild] ") then
				msg = strsub(msg, 9);
			elseif (strsub(msg, 1, 8) == "[Gilde] ") then
				msg = strsub(msg, 9);
			elseif (strsub(msg, 1, 10) == "[Officer] ") then
				msg = strsub(msg, 11);
			elseif (strsub(msg, 1, 11) == "[Offizier] ") then
				msg = strsub(msg, 12);
			elseif (strsub(msg, 1, 8) == "[Party] ") then
				msg = strsub(msg, 9);
			elseif (strsub(msg, 1, 9) == "[Gruppe] ") then
				msg = strsub(msg, 10);
			elseif (strsub(msg, 1, 7) == "[Raid] ") then
				msg = strsub(msg, 8);
			elseif (strsub(msg, 1, 14) == "[Schlachtzug] ") then
				msg = strsub(msg, 15);
			elseif (strsub(msg, 1, 14) == "[Raid Leader] ") then
				msg = strsub(msg, 15);
			elseif (strsub(msg, 1, 21) == "[Schlachtzugsleiter] ") then
				msg = strsub(msg, 22);
			elseif (strsub(msg, 1, 15) == "[Raid Warning] ") then
				msg = strsub(msg, 16);
			elseif (strsub(msg, 1, 22) == "[Schlachtzugswarnung] ") then
				msg = strsub(msg, 23);
			elseif (strsub(msg, 1, 15) == "[Battleground] ") then
				msg = strsub(msg, 16);
			elseif (strsub(msg, 1, 15) == "[Schlachtfeld] ") then
				msg = strsub(msg, 16);
			elseif (strsub(msg, 1, 22) == "[Battleground Leader] ") then
				msg = strsub(msg, 23);
			elseif (strsub(msg, 1, 21) == "[Schlachtfeldleiter] ") then
				msg = strsub(msg, 22);
			end
		else
			if (strsub(msg, 1, 8) == "[Guild] ") then
				msg = "|Hezcc:g|h[G]|h"..strsub(msg, 8);
			elseif (strsub(msg, 1, 8) == "[Gilde] ") then
				msg = "|Hezcc:g|h[G]|h"..strsub(msg, 8);
			elseif (strsub(msg, 1, 10) == "[Officer] ") then
				msg = "|Hezcc:o|h[O]|h"..strsub(msg, 10);
			elseif (strsub(msg, 1, 11) == "[Offizier] ") then
				msg = "|Hezcc:o|h[O]|h"..strsub(msg, 11);
			elseif (strsub(msg, 1, 8) == "[Party] ") then
				msg = "|Hezcc:p|h[P]|h"..strsub(msg, 8);
			elseif (strsub(msg, 1, 9) == "[Gruppe] ") then
				msg = "|Hezcc:p|h[P]|h"..strsub(msg, 9);
			elseif (strsub(msg, 1, 7) == "[Raid] ") then
				msg = "|Hezcc:r|h[R]|h"..strsub(msg, 7);
			elseif (strsub(msg, 1, 14) == "[Schlachtzug] ") then
				msg = "|Hezcc:r|h[R]|h"..strsub(msg, 14);
			elseif (strsub(msg, 1, 14) == "[Raid Leader] ") then
				msg = "|Hezcc:r|h[R]|h"..strsub(msg, 14);
			elseif (strsub(msg, 1, 21) == "[Schlachtzugsleiter] ") then
				msg = "|Hezcc:r|h[R]|h"..strsub(msg, 21);
			elseif (strsub(msg, 1, 15) == "[Raid Warning] ") then
				msg = "|Hezcc:w|h[RW]|h"..strsub(msg, 15);
			elseif (strsub(msg, 1, 22) == "[Schlachtzugswarnung] ") then
				msg = "|Hezcc:w|h[RW]|h"..strsub(msg, 22);
			elseif (strsub(msg, 1, 15) == "[Battleground] ") then
				msg = "|Hezcc:b|h[BG]|h"..strsub(msg, 15);
			elseif (strsub(msg, 1, 15) == "[Schlachtfeld] ") then
				msg = "|Hezcc:b|h[BG]|h"..strsub(msg, 15);
			elseif (strsub(msg, 1, 22) == "[Battleground Leader] ") then
				msg = "|Hezcc:b|h[BG]|h"..strsub(msg, 22);
			elseif (strsub(msg, 1, 21) == "[Schlachtfeldleiter] ") then
				msg = "|Hezcc:b|h[BG]|h"..strsub(msg, 21);
			end
		end
	end
	if (ECVars.msgPrefix ~= "") then
		timestamp = ECVars.msgPrefix;
	else
		local ctime = date("*t");
		local hours = ctime["hour"];
		local minutes = ctime["min"];
		local seconds = ctime["sec"];
		timestamp = "["..format("%02d:%02d:%02d", hours, minutes, seconds).."]";
	end
	if (strfind(msg, "%d:%d%d:%d%d>") ~= nil and strfind(msg, "%d:%d%d:%d%d>") < 3) then
		timestamp = "|Hezc:"..UnlinkMessage(msg).."|h["..strsub(msg, 1, strfind(msg, ">")-1).."]|h"..strsub(msg, strfind(msg,">")+1);
	else
		timestamp = "|Hezc:"..UnlinkMessage(msg).."|h"..timestamp.."|h "..msg;
	end
	local newmsg = timestamp;
	this:EasyCopy_Original_AddMessage(newmsg, r, g, b, id);
end

function UnlinkMessage(linkedmessage)
	local message = gsub(linkedmessage, "||", "||x");
	local part1 = "";
	local part2 = "";
	local part3 = "";
	local pos   = 0;
	local lenbef= strlen(message);
	if (strfind(message,"|c")~=nil) then
		local done = false;
		message = gsub(message,"|r","");
		repeat
			part1 = message;
			pos   = strfind(message,"|c");
			part2 = strsub (part1,pos+10);
			part1 = strsub (part1,1,pos-1);
			message=part1..part2;
			if (strfind(message,"|c") == nil) then
				done = true;
			end
		until (done == true);
	end
	if (strfind(message,"|H")~=nil) then
		local done = false;
		repeat
			part1 = message;
			pos   = strfind(part1,"|H");
			part2 = strsub (part1,pos+2);
			part1 = strsub (part1,1,pos-1);
			pos   = strfind(part2,"|h");
			if (pos == nil) then
				message = gsub(message,"|","||");
				
			else
				part2 = strsub (part2,pos+2);
				pos   = strfind(part2,"|h");
				part3 = strsub (part2,pos+2);
				part2 = strsub (part2,1,pos-1);
				message = part1..part2..part3;
			end
			if (strfind(message,"|H") == nil) then
				done = true;
			end
		until (done == true);
	end
	message=gsub(message,"||x","||");
	message=gsub(message,"/","/1");
	message=gsub(message,"|","/2");
	return message;
end

function EasyCopy_SetItemRef(link, text, button)
	if ( strsub(link, 1, 4) == "ezc:" ) then
		local chatmsg = gsub(gsub(strsub(link,5),"/2","|"),"/1","/");
		if (ChatFrameEditBox:IsShown() == nil) then
			if (IsShiftKeyDown()) then
				if (ChatFrameEditBox:GetAttribute("chatType") == "CHANNEL") then
					SendChatMessage(chatmsg, "CHANNEL", nil, ChatFrameEditBox:GetAttribute("channelTarget"));
				elseif (ChatFrameEditBox:GetAttribute("chatType") == "WHISPER") then
					SendChatMessage(chatmsg, "WHISPER", nil, ChatFrameEditBox:GetAttribute("tellTarget"));
				else
					SendChatMessage(chatmsg, ChatFrameEditBox:GetAttribute("chatType"), nil);
				end
			else
				EasyCopy_core:Show();
				EasyCopy_core:SetBackdropColor(0, 0, 0, 0.9);
				-- EasyCopy_core:SetBackdropBorderColor(0.8, 0.8, 0.8, 1);
				EasyCopy_Edit:SetText(chatmsg);
				-- EasyCopy_Edit:HighlightText();
				EasyCopy_Edit:SetFont(DEFAULT_CHAT_FRAME:GetFont());
				EasyCopy_Edit:SetFocus();
			end
		else
			if (IsShiftKeyDown()) then
				if (ChatFrameEditBox:GetAttribute("chatType") == "CHANNEL") then
					SendChatMessage(chatmsg, "CHANNEL", nil, ChatFrameEditBox:GetAttribute("channelTarget"));
				elseif (ChatFrameEditBox:GetAttribute("chatType") == "WHISPER") then
					SendChatMessage(chatmsg, "WHISPER", nil, ChatFrameEditBox:GetAttribute("tellTarget"));
				else
					SendChatMessage(chatmsg, ChatFrameEditBox:GetAttribute("chatType"), nil);
				end
			else
				ChatFrameEditBox:Insert(chatmsg);
			end
		end
		return;
	elseif ( strsub(link, 1, 5) == "ezcc:" ) then
		if (ChatFrameEditBox:IsShown() == nil) then
			ChatFrameEditBox:Show();
		end
		local chanID = strsub(link, 6, 6);
		if (chanID == "g") then
			ChatFrameEditBox:SetAttribute("chatType", "GUILD");
			ChatEdit_UpdateHeader(ChatFrameEditBox);
		elseif (chanID == "o") then
			ChatFrameEditBox:SetAttribute("chatType", "OFFICER");
			ChatEdit_UpdateHeader(ChatFrameEditBox);
		elseif (chanID == "p") then
			ChatFrameEditBox:SetAttribute("chatType", "PARTY");
			ChatEdit_UpdateHeader(ChatFrameEditBox);
		elseif (chanID == "r") then
			ChatFrameEditBox:SetAttribute("chatType", "RAID");
			ChatEdit_UpdateHeader(ChatFrameEditBox);
		elseif (chanID == "w") then
			ChatFrameEditBox:SetAttribute("chatType", "RAID_WARNING");
			ChatEdit_UpdateHeader(ChatFrameEditBox);
		elseif (chanID == "b") then
			ChatFrameEditBox:SetAttribute("chatType", "BATTLEGROUND");
			ChatEdit_UpdateHeader(ChatFrameEditBox);
		else
			ChatFrameEditBox:SetAttribute("chatType", "CHANNEL");
			ChatFrameEditBox:SetAttribute("channelTarget", strsub(link, 6, 6));
			ChatEdit_UpdateHeader(ChatFrameEditBox);
		end
		return;
	end
	EasyCopy_Original_SetItemRef(link, text, button);
end

function EasyCopy_MWheelOverlay_OnShow()
	EasyCopy_UpdateButtons();
	if (this:GetParent():GetFrameLevel() > 1) then
		this:SetFrameLevel(this:GetParent():GetFrameLevel() + 1);
	end
end

function EasyCopy_MWheelOverlay_OnMWheel(value)
	if (value < 0) then
		if IsShiftKeyDown() then
			this:GetParent():ScrollToBottom();
		else
			this:GetParent():ScrollDown();
			this:GetParent():ScrollDown();
		end
	else
		this:GetParent():ScrollUp();
		this:GetParent():ScrollUp();
	end
end

function EasyCopy_MWheelOverlay_Update()
	if (ECVars.mWheelScroll == 0) then
		ChatFrame1MWheelOverlay:Hide();
		ChatFrame2MWheelOverlay:Hide();
		ChatFrame3MWheelOverlay:Hide();
		ChatFrame4MWheelOverlay:Hide();
		ChatFrame5MWheelOverlay:Hide();
		ChatFrame6MWheelOverlay:Hide();
		ChatFrame7MWheelOverlay:Hide();
	else
		ChatFrame1MWheelOverlay:Show();
		ChatFrame2MWheelOverlay:Show();
		ChatFrame3MWheelOverlay:Show();
		ChatFrame4MWheelOverlay:Show();
		ChatFrame5MWheelOverlay:Show();
		ChatFrame6MWheelOverlay:Show();
		ChatFrame7MWheelOverlay:Show();
	end
end

function EasyCopyOptions_CheckButtonClick(button)
	local buttonID = strlower(strsub(button:GetName(), strfind(button:GetName(), "_") + 1));
	if (buttonID == "buttons") then
		if (button:GetChecked()) then
			ECVars.buttons = 1;
		else
			ECVars.buttons = 0;
		end
		EasyCopy_UpdateButtons();
	elseif (buttonID == "mwheelscroll") then
		if (button:GetChecked()) then
			ECVars.mWheelScroll = 1;
		else
			ECVars.mWheelScroll = 0;
		end
		EasyCopy_MWheelOverlay_Update();
	elseif (buttonID == "tabflashing") then
		if (button:GetChecked()) then
			ECVars.tabFlashing = 1;
		else
			ECVars.tabFlashing = 0;
		end
	elseif (buttonID == "stickychannels") then
		if (button:GetChecked()) then
			ECVars.stickyChannels = 1;
		else
			ECVars.stickyChannels = 0;
		end
		ChatTypeInfo["CHANNEL"].sticky = ECVars.stickyChannels;
	end
end

function EasyCopyOptions_LoadVars()
	EasyCopyOptions_Buttons:SetChecked(ECVars.buttons);
	EasyCopyOptions_MWheelScroll:SetChecked(ECVars.mWheelScroll);
	EasyCopyOptions_TabFlashing:SetChecked(ECVars.tabFlashing);
	EasyCopyOptions_StickyChannels:SetChecked(ECVars.stickyChannels);
	EasyCopyOptions_MsgPrefix:SetText(tostring(ECVars.msgPrefix));
	UIDropDownMenu_SetSelectedValue(EasyCopyOptions_ShortMessages, ECVars.shortMSG);
	UIDropDownMenu_SetText(EasyCopy_ShortMsgButtons[ECVars.shortMSG + 1], EasyCopyOptions_ShortMessages);
end



function ECmytest(start)
	-- local kids = { ChatFrame1BottomButton:GetParent():GetParent():GetChildren() };
	local kids = { UIParent:GetChildren() };
	local counters = 0;
	if (start == nil) then
		start = 1;
	end
	local numb = 15;
	for _,child in ipairs(kids) do
		if (counters == 0) then
			DEFAULT_CHAT_FRAME:AddMessage("# Children of: "..tostring(child:GetParent():GetName()), 1, 1, 0);
		end
		counters = counters + 1;
		if (counters >= start) then
			DEFAULT_CHAT_FRAME:AddMessage("#"..counters..": "..tostring(child:GetName()), 1, 1, 0);
		end
		if (counters > (start+numb-2)) then
			return;
		end
	end
end