﻿-- Author      : Linty


dungstat={frame=CreateFrame("Frame"), core={}, utils={}, event={},vars={}};




dungstat.frame:SetScript("OnEvent", function(self, event, ...)
 dungstat.event:handler(self,event, ...); -- call event handler
end);

dungstat.vars.debug=1; -- set debug level to critical only
dungstat.vars.tankWait=0;
dungstat.vars.healWait=0;
dungstat.vars.dpsWait=0;
dungstat.vars.avgWait=0;
dungstat.vars.myWait=0;
---------------------------Refresh Set-up setup--------
dungstat.vars.updatetime=2; --- Update Every x aseconds.
dungstat.vars.starttime=0; --when did last search start?


---------------------------Register Events--------
dungstat.frame:RegisterEvent("VARIABLES_LOADED");
dungstat.frame:RegisterEvent("ADDON_LOADED");


dungstat.frame:RegisterEvent("LFG_PROPOSAL_UPDATE");
dungstat.frame:RegisterEvent("LFG_PROPOSAL_SHOW");
dungstat.frame:RegisterEvent("LFG_PROPOSAL_FAILED");
dungstat.frame:RegisterEvent("LFG_PROPOSAL_SUCCEEDED");
dungstat.frame:RegisterEvent("LFG_UPDATE");
dungstat.frame:RegisterEvent("PLAYER_ENTERING_WORLD");
dungstat.frame:RegisterEvent("LFG_ROLE_CHECK_SHOW");
dungstat.frame:RegisterEvent("LFG_ROLE_CHECK_HIDE");
dungstat.frame:RegisterEvent("LFG_BOOT_PROPOSAL_UPDATE");
dungstat.frame:RegisterEvent("LFG_ROLE_UPDATE");
dungstat.frame:RegisterEvent("LFG_UPDATE_RANDOM_INFO");
dungstat.frame:RegisterEvent("LFG_QUEUE_STATUS_UPDATE");


------------------------refresh Timer---------------------
 function dungstat:TimerUpdate()
	if (dungstat.vars.starttime==0) then return  end; --- LFG Not Active


	DungStatusFrame_txtStatus1:SetText(format("|cFF00FF00Waiting for %s",dungstat.utils:TimeString(time()-dungstat.vars.starttime)));
	
 
 end
 
------------------------Send Mesage to chat---------------------
function dungstat.utils:Chat(chatmsg)

	if (chatmsg==nil) then 
		chatmsg="";
	end
	
	DEFAULT_CHAT_FRAME:AddMessage("|cFFFFF000Dungeon Status: |r"..chatmsg);
end

------------------------Send Debug to chat---------------------
function dungstat.utils:Debug(level, debugStr) --- level == 0-Critical, 1- Important, 2-Information, 3-trace only
		
		if (debugStr==nil or level == nil) then 
			return;
		end
		if (dungstat.vars.debug+1<level) then 
				return;
		end
		
		DEFAULT_CHAT_FRAME:AddMessage("|cFFFFF000Dungeon Status: |cffff0000[Debug] |r"..debugStr);
end

---------------------------------Helper Functions---------------------------------
function dungstat.utils:SafeNil(StringVar)
		if (StringVar== nil) then
			return "";
		end

		return StringVar;
end 

function dungstat.utils:TimeString(secs)

	if (secs==nil) then
		return "-";
	end
	
	if (secs<60) then
		return secs.." s";
	end
		
	
	
	local mins=math.floor(secs/60);
	local hours=0;
	local days=0;

	hours,mins=math.modf(mins/60);
	mins=math.floor(mins*60);

	days,hours=math.modf(hours/24);

	hours=math.floor(hours*24);

	sret=""
	if (days>0) then
		sret=days.."d ";
	end

	if (hours>0 or days>0) then
		sret=sret..hours.."h ";
	end

	sret=sret..mins.."m ";

return sret;
end

--------------------------Event Handler---------------------------------
function dungstat.event:handler(self, event, ...)
	
	local lmode, lsubmode=GetLFGMode();
	DungStatusFrame_imgTank:SetAlpha(0.25);
	DungStatusFrame_imgHeal:SetAlpha(0.25);
	DungStatusFrame_imgDPS1:SetAlpha(0.25);
	DungStatusFrame_imgDPS2:SetAlpha(0.25);
	DungStatusFrame_imgDPS3:SetAlpha(0.25);
	
	if (lmode=="queued") then
		
		if (dungstat.vars.starttime==0) then 
			DungStatusFrame_txtStatus1:SetText("");
			dungstat.vars.starttime=time(); --- Start time
			Chronos.scheduleRepeating("DungStatus_Update", dungstat.vars.updatetime,dungstat.TimerUpdate );
		end
		
		
		
		local hasData,  leaderNeeds, tankNeeds, healerNeeds, dpsNeeds, instanceType, instanceName
					, averageWait, tankWait, healerWait, damageWait, myWait = GetLFGQueueStats();
					
		if (not hasData) then
			return;
		end
		
		
		------ Store Times for Tooltip
		dungstat.vars.tankWait=tankWait;
		dungstat.vars.healWait=healerWait;
		dungstat.vars.dpsWait=damageWait;
		dungstat.vars.avgWait=averageWait;
		dungstat.vars.myWait=myWait;
		
		if (tankNeeds==0) then
			DungStatusFrame_imgTank:SetAlpha(0.8);
		end
		
		if (healerNeeds==0) then
			DungStatusFrame_imgHeal:SetAlpha(0.8);
		end
		
		if (dpsNeeds<3) then
			DungStatusFrame_imgDPS1:SetAlpha(0.8);
		end
		
		if (dpsNeeds<2) then
			DungStatusFrame_imgDPS2:SetAlpha(0.8);
		end
	
		if (dpsNeeds==0) then
			DungStatusFrame_imgDPS3:SetAlpha(0.8);
		end
		
		
		if (myWait<0) then
			DungStatusFrame_txtStatus:SetText("|CFFFF0000Wait Time Unknown");
		else
			DungStatusFrame_txtStatus:SetText(format("%s Wait",dungstat.utils:TimeString(myWait)));
		end
		
	
		local youLeader, youTank, youHealer, youDamage = GetLFGRoles();
		if (youTank) then
			DungStatusFrame_imgTank:SetAlpha(1);
		elseif (youHealer) then
			DungStatusFrame_imgHeal:SetAlpha(1);
		else
			DungStatusFrame_imgDPS1:SetAlpha(1);
		end
			
		DungStatusFrame:Show();
	else
		Chronos.unscheduleByName("DungStatus_Update")
		dungstat.vars.starttime=0; -- Reset start Time
		if (DungStatusFrame.IsVisible) then
				DungStatusFrame:Hide();
		end
		
		
	
	
	end
	
	
end

