----------------------------------------------------------------------------------------------------
-- Drood Focus 2.6.5: Options
----------------------------------------------------------------------------------------------------
DroodFocusOptions = { };

local _G = getfenv(0);

----------------------------------------------------------------------------------------------------
-- Widgets Handlers
----------------------------------------------------------------------------------------------------
function DroodFocusOptions:Handler()
	if(DroodFocusOptionsFrame:IsVisible()) then
		_G["DebuffContener"].texture:SetTexture(0,0,0,0);
		DroodFocus:setFakeCC(false);
		HideUIPanel(DroodFocusOptionsFrame);
	else

		DroodFocus:setFakeCC(true);
		ShowUIPanel(DroodFocusOptionsFrame);
	end
end

----------------------------------------------------------------------------------------------------
-- Scaling
----------------------------------------------------------------------------------------------------

local function DroodFocusOptionsScaleSlider_Init()
	if(not DroodFocusOptions.scaleSliderLoaded) then
		local Text, Low, Full;
		Text = _G[this:GetName().."Text"];
		Low = _G[this:GetName().."Low"];
		High = _G[this:GetName().."High"];
		
		Text:SetText(DROODFOCUS_SCALE);
		Low:SetText(DROODFOCUS_LOW);
		High:SetText(DROODFOCUS_HIGH);
		
		this:SetMinMaxValues(0.25, 2.0);
		this:SetValueStep(0.05);
		
		DroodFocusOptions.scaleSliderLoaded = true;
	end
	local value = format("%.2f", DroodFocusConfig.Scale);
	_G[this:GetName().."Value"]:SetText(value);
	_G["uiDroodFocusFrame"]:SetScale(DroodFocusConfig.Scale);
end

local function DroodFocusOptionsContenerScaleSlider_Init()
	if(not DroodFocusOptions.ContenerScaleSliderLoaded) then
		local Text, Low, Full;
		Text = _G[this:GetName().."Text"];
		Low = _G[this:GetName().."Low"];
		High = _G[this:GetName().."High"];
		
		Text:SetText(DROODFOCUS_SCALE);
		Low:SetText(DROODFOCUS_LOW);
		High:SetText(DROODFOCUS_HIGH);
		
		this:SetMinMaxValues(0.25, 2.0);
		this:SetValueStep(0.05);
				
		DroodFocusOptions.ContenerScaleSliderLoaded = true;
	end
	local value = format("%.2f", DroodFocusConfig.contenerScale);
	_G[this:GetName().."Value"]:SetText(value);
	_G["DebuffContener"]:SetScale(DroodFocusConfig.contenerScale);
end

local function DroodFocusOptionsBloodAlphaSlider_Init()
	if(not DroodFocusOptions.BloodAlphaSliderLoaded) then
		local Text, Low, Full;
		Text = _G[this:GetName().."Text"];
		Low = _G[this:GetName().."Low"];
		High = _G[this:GetName().."High"];
		
		Text:SetText(DROODFOCUS_ALPHA);
		Low:SetText(DROODFOCUS_LOW);
		High:SetText(DROODFOCUS_HIGH);
		
		this:SetMinMaxValues(0, 1.0);
		this:SetValueStep(.1);
				
		DroodFocusOptions.BloodAlphaSliderLoaded = true;
	end
	local value = format("%.1f", DroodFocusConfig.BloodAlpha);
	_G[this:GetName().."Value"]:SetText(value);
	
	DroodFocus:newClaw();DroodFocus:newClaw();
	DroodFocus:newBlood();DroodFocus:newBlood();DroodFocus:newBlood();
	
end

local function DroodFocusOptionsBloodScaleSlider_Init()
	if(not DroodFocusOptions.BloodScaleSliderLoaded) then
		local Text, Low, Full;
		Text = _G[this:GetName().."Text"];
		Low = _G[this:GetName().."Low"];
		High = _G[this:GetName().."High"];
		
		Text:SetText(DROODFOCUS_SCALE);
		Low:SetText(DROODFOCUS_LOW);
		High:SetText(DROODFOCUS_HIGH);
		
		this:SetMinMaxValues(0.25, 2.0);
		this:SetValueStep(.1);
				
		DroodFocusOptions.BloodScaleSliderLoaded = true;
	end
	local value = format("%.1f", DroodFocusConfig.BloodScale);
	_G[this:GetName().."Value"]:SetText(value);
	
	DroodFocus:newClaw();DroodFocus:newClaw();
	DroodFocus:newBlood();DroodFocus:newBlood();DroodFocus:newBlood();
	
end

-- slider
function DroodFocusOptions:ScaleSlider_OnShow()
	DroodFocusOptionsScaleSlider_Init();
	this:SetValue(DroodFocusConfig.Scale);
end

function DroodFocusOptions:ScaleSlider_OnValueChanged()
	DroodFocusConfig.Scale = this:GetValue();
	DroodFocusOptionsScaleSlider_Init();
end

function DroodFocusOptions:ContenerScaleSlider_OnShow()
	DroodFocusOptionsContenerScaleSlider_Init();
	this:SetValue(DroodFocusConfig.contenerScale);
end

function DroodFocusOptions:ContenerScaleSlider_OnValueChanged()
	DroodFocusConfig.contenerScale = this:GetValue();
	DroodFocusOptionsContenerScaleSlider_Init();
end

function DroodFocusOptions:BloodAlphaSlider_OnShow()
	DroodFocusOptionsBloodAlphaSlider_Init();
	this:SetValue(DroodFocusConfig.BloodAlpha);
end

function DroodFocusOptions:BloodAlphaSlider_OnValueChanged()
	DroodFocusConfig.BloodAlpha = this:GetValue();
	DroodFocusOptionsBloodAlphaSlider_Init();
end

function DroodFocusOptions:BloodScaleSlider_OnShow()
	DroodFocusOptionsBloodScaleSlider_Init();
	this:SetValue(DroodFocusConfig.BloodScale);
end

function DroodFocusOptions:BloodScaleSlider_OnValueChanged()
	DroodFocusConfig.BloodScale = this:GetValue();
	DroodFocusOptionsBloodScaleSlider_Init();
end

--enable
function DroodFocusOptions:EnableCheckButton_OnShow()
	this:SetChecked(DroodFocusConfig.Enable);
end

function DroodFocusOptions:EnableCheckButton_OnClick()
	if(1 == this:GetChecked()) then
		DroodFocusConfig.Enable = true;
	else
		DroodFocusConfig.Enable = false;
	end
	DroodFocus:Toggle();
end

--claws
function DroodFocusOptions:ClawCheckButton_OnShow()
	this:SetChecked(DroodFocusConfig.Claws);
end

function DroodFocusOptions:ClawCheckButton_OnClick()
	if(1 == this:GetChecked()) then
		DroodFocusConfig.Claws = true;
	else
		DroodFocusConfig.Claws = false;
	end
	DroodFocus:Toggle();
end

--tracker
function DroodFocusOptions:TrackerCheckButton_OnShow()
	this:SetChecked(DroodFocusConfig.Tracker);
	if (DroodFocusConfig.Tracker) then
		_G["DebuffContener"].texture:SetTexture(0,0,0,0.5);
	else
		_G["DebuffContener"].texture:SetTexture(0,0,0,0);
	end
	DroodFocus:Toggle();
end

function DroodFocusOptions:TrackerCheckButton_OnClick()
	if(1 == this:GetChecked()) then
		DroodFocusConfig.Tracker = true;
		_G["DebuffContener"].texture:SetTexture(0,0,0,0.5);
	else
		DroodFocusConfig.Tracker = false;
		_G["DebuffContener"].texture:SetTexture(0,0,0,0);
	end
	DroodFocus:Toggle();
end


function DroodFocusOptions:MainFrameX_Init()
	_G["MainFrameXText"]:SetText(DROODFOCUS_CONTX);
	_G["MainFrameX"]:SetText(DroodFocusConfig.mainx);
end
function DroodFocusOptions:MainFrameX_OnValueChanged()
	DroodFocusConfig.mainx = _G["MainFrameX"]:GetText();
	_G["uiDroodFocusFrame"]:SetPoint("CENTER", UIparent, "CENTER", DroodFocusConfig.mainx, DroodFocusConfig.mainy);
end

function DroodFocusOptions:MainFrameY_Init()
	_G["MainFrameYText"]:SetText(DROODFOCUS_CONTY);
	_G["MainFrameY"]:SetText(DroodFocusConfig.mainy);
end
function DroodFocusOptions:MainFrameY_OnValueChanged()
	DroodFocusConfig.mainy = _G["MainFrameY"]:GetText();
	_G["uiDroodFocusFrame"]:SetPoint("CENTER", UIparent, "CENTER", DroodFocusConfig.mainx, DroodFocusConfig.mainy);
end



function DroodFocusOptions:conteneurX_Init()
	_G["conteneurXText"]:SetText(DROODFOCUS_CONTX);
	_G["conteneurX"]:SetText(DroodFocusConfig.contenerX);
end
function DroodFocusOptions:conteneurX_OnValueChanged()
	DroodFocusConfig.contenerX = _G["conteneurX"]:GetText();
	_G["DebuffContener"]:SetPoint("CENTER", UIparent, "CENTER", DroodFocusConfig.contenerX, DroodFocusConfig.contenerY);
end

function DroodFocusOptions:conteneurY_Init()
	_G["conteneurYText"]:SetText(DROODFOCUS_CONTY);
	_G["conteneurY"]:SetText(DroodFocusConfig.contenerY);
end
function DroodFocusOptions:conteneurY_OnValueChanged()
	DroodFocusConfig.contenerY = _G["conteneurY"]:GetText();
	_G["DebuffContener"]:SetPoint("CENTER", UIparent, "CENTER", DroodFocusConfig.contenerX, DroodFocusConfig.contenerY);
end