----------------------------------------------------------------------------------------------------
-- DroodFocus 2.6.5 - Core
-- Author : Meranannon - Discordia - Vol'jin (EU)
----------------------------------------------------------------------------------------------------

local _, class = UnitClass("player")
if (class ~= "DRUID" and class ~= "ROGUE")  then
	-- don't load for non-druids
	return
end

DroodFocus = {
	Version = "2.6.5";
	Lock = 1;
	Class = "",
	Registered = false,
};

local DroodFocusMainFrame;
local contener;
local fakeCC = false;

local _G = getfenv(0);

local DroodFocus_Energy = {
	Length = 2,
	Alpha = 0.2,
	Start = 0,
	End = 0,
	Mana = nil,
};

local DroodFocusConfig_Default = {
	Enable = true,
	Scale = 1.0,
	Claws = true,
	BloodAlpha = 1.0,
	BloodScale =1.0,
	Locked = true,
	Tracker = true,
	contenerScale = 1.0,
	contenerX = 0,
	contenerY = 0,
	mainx = 1,
	mainy = 1
}

df_Frames = {};
df_Texts = {};
df_Textures = {};

combo_Frames = {};
combo_Textures = {};

portrait_Frames ={};
portrait_Textures ={};

griffe_Frames = {};
griffe_Textures = {};

local spell_clearcast = GetSpellInfo(12536); -- id ides claires

local targetId;
local playerId; -- ID du joueur

local clearcastState = 0;
local clearcastScale = 1;
local clearcastScaleAdd = 0.0075;

local nbDebuffs=0;

-- tableau stockant les sorts tracks
local nbSpellsTracker = 60;
SpellsTracker = {};
for i = 1,nbSpellsTracker do
	SpellsTracker[i] = {
		trkTime = -1, -- new
		trkTimer = 0,
		trkSpell = "",
		trkSource = -1,
		trkTarget = -1,
		trkPulse = 0,
		trkAmount = 0
	};
end

claws = {};
for i = 1,5 do
	claws[i] = {
		clawX = -96, -- new
		clawY = 100,
		posX = 0,
		posY = 0,
		clawScale = 1,
		clawAlpha = -1,
		clawState=0
	    };
end

claws[1].clawX = -200;
claws[2].clawX = 200;

claws[3].clawX = -250;
claws[3].clawY = 0;

claws[4].clawX = 250;
claws[4].clawY = 0;

claws[5].clawX = 0;
claws[5].clawY = 250;

local clawsOrder = 1;
local bloodOrder = 3;

local comboOffset = 0;
local comboPts = 0;

local contener;

local trackerPt = 1;

-- gestion de la mana
local currentMana=-1, maxiMana; -- mana
local nbTransfo=0;
local regenBase, regenCasting -- regen
local oldTime = -1;
local fiveSeconds=0;
local fiveSecondsRules=0;
local bearForm, _, _, _, _, _, _, _, _ = GetSpellInfo(9634);
local catForm, _, _, _, _, _, _, _, _ = GetSpellInfo(768);

---------------------------------------------------------------------------------
-- DroodFocus - Command Line Handler
---------------------------------------------------------------------------------
function DroodFocusSL_SlashCmd(arg)
	if (arg==nil) then
		arg="";
	end
	
	arg = string.lower(arg);
	
	if (arg == "config") then -- config
		DroodFocusOptions:Handler();
	elseif (arg == "reset") then -- reset
		DroodFocus:resetConfig();
	else
		DEFAULT_CHAT_FRAME:AddMessage(DROODFOCUS_CMD);
	end
end

----------------------------------------------------------------------------------------------------
-- Widgets Handlers
----------------------------------------------------------------------------------------------------
function DroodFocus:OnLoad()

	localizedClass, DroodFocus.Class = UnitClass("player");
	
	DroodFocus.Registered = DroodFocus:RegisterEvents();

	if((not DroodFocusConfig) or (not DroodFocusConfig.Version) or (DroodFocusConfig.Version ~= DroodFocus.Version)) then
		DroodFocusConfig = DroodFocusConfig_Default;
	end

	DroodFocus:creerFrames();
	DroodFocus:Toggle();
	
	-- It seems that all has gone well till now. Hi there!
	DEFAULT_CHAT_FRAME:AddMessage(DROODFOCUS_WELCOME);
	
end

----------------------------------------------------------------------------------------------------
-- events Handlers
----------------------------------------------------------------------------------------------------
function DroodFocus:OnEvent(eventArg)
	if(not DroodFocus.Registered) then return; end
	
	if(eventArg == "VARIABLES_LOADED") then
		
		if(DroodFocus.Registered) then

			for key,value in pairs(DroodFocusConfig_Default) do
				cvalue = DroodFocusConfig[key];
				--DEFAULT_CHAT_FRAME:AddMessage("DEFAULT -> "..tostring(key).." : "..tostring(value));
				--DEFAULT_CHAT_FRAME:AddMessage("CURRENT -> "..tostring(cvalue));
				if (cvalue == nil) then
					DroodFocusConfig[key] = DroodFocusConfig_Default[key];
				end
			end

			-- Scaling
			uiDroodFocusFrame:SetScale(DroodFocusConfig.Scale);
			contener:SetScale(DroodFocusConfig.contenerScale);
			contener:SetPoint("CENTER", UIparent, "CENTER", DroodFocusConfig.contenerX, DroodFocusConfig.contenerY);
			uiDroodFocusFrame:SetPoint("CENTER", UIparent, "CENTER", DroodFocusConfig.mainx, DroodFocusConfig.mainy);
			
			-- Energy ticks
			DroodFocus_Energy.Mana = UnitMana("player");
			
			-- Energy ticks text
			uiDroodFocusTickText:SetText("");
			
			--droods
			portrait_Frames[1]:Hide();
						
			-- Create slash events
			SLASH_DroodFocusSL1 = "/df";
			SLASH_DroodFocusSL2 = "/droodfocus";
			SlashCmdList["DroodFocusSL"] = DroodFocusSL_SlashCmd;

		end
		
	elseif(eventArg == "PLAYER_REGEN_ENABLE" and DroodFocusConfig.Enable) then
		comboPts=0;
		DroodFocus:UpdateComboBar();
		DroodFocus:noBlood();

	elseif (eventArg == "PLAYER_AURAS_CHANGED" and DroodFocusConfig.Enable) then
		DroodFocus:checkBuffsDrood();

		if (arg1==nil and arg2==nil and arg3==nil and arg4==nil and arg5==nil and arg6==nil and arg7==nil and arg8==nil and arg9==nil) then
			DroodFocus:Toggle();
		end
	
	elseif (eventArg == "PLAYER_COMBO_POINTS" and DroodFocusConfig.Enable) then
		DroodFocus:UpdateComboBar();
		
	elseif(eventArg == "PLAYER_ENTERING_WORLD" and DroodFocusConfig.Enable) then 
		comboPts = 0;
		DroodFocus:hideAbilities();
		DroodFocus:noBlood();
		DroodFocus:Toggle();
		
	elseif(eventArg == "PLAYER_DEAD" and DroodFocusConfig.Enable) then
		comboPts=0;
		DroodFocus:UpdateComboBar();
		DroodFocus:hideAbilities();
		DroodFocus:UpdateEnergyBar();
		DroodFocus:noBlood();
		DroodFocus:Toggle();
	
	elseif(eventArg == "PLAYER_TARGET_CHANGED" and DroodFocusConfig.Enable) then
		comboPts =0;
		DroodFocus:UpdateComboBar();
		
	elseif(eventArg == "COMBAT_LOG_EVENT_UNFILTERED" and DroodFocusConfig.Enable) then

	       	if (arg2=="SPELL_DAMAGE" or arg2=="SPELL_PERIODIC_DAMAGE" or (arg2=="SPELL_MISSED" and arg12=="ABSORB")) then
	       		DroodFocus:combatLogTracker(arg2,arg3,arg6,arg10,arg12);
			-- une kikoo griffe?
			if (DroodFocusConfig.Claws and arg3==playerId and arg17) then
				-- le joueur a fait un critique sur coup jaunes, on lance une tache de sang
				DroodFocus:newClaw();
				DroodFocus:newBlood();
			end

		elseif (DroodFocusConfig.Claws and arg2=="SWING_DAMAGE" and arg3==playerId and arg14) then
			-- le joueur a fait un critique sur coup blanc, on lance une kikoo griffes  
			DroodFocus:newClaw();
			DroodFocus:newBlood();	
					
		elseif (arg2=="PARTY_KILL" and arg3==playerId) then
			-- coup de grace du joueur, plein de sang :)
			DroodFocus:newBlood();
			DroodFocus:newBlood();
			DroodFocus:newBlood();

		elseif(arg2 == "SPELL_CAST_SUCCESS" and DroodFocusConfig.Enable and arg3==playerId and (arg10==bearForm or arg10==catForm)) then
			nbTransfo = nbTransfo + 1;
			fiveSecondsRules = 0;
		end
	end
end

---------------------------------------------------------------------------------
-- DroodFocus - reset configuration
---------------------------------------------------------------------------------
function DroodFocus:resetConfig()
	for key,value in pairs(DroodFocusConfig_Default) do
		DroodFocusConfig[key] = DroodFocusConfig_Default[key];
	end
	uiDroodFocusFrame:SetPoint("CENTER", "UIParent", "CENTER", DroodFocusConfig.mainx, DroodFocusConfig.mainy );
	uiDroodFocusFrame:SetScale(DroodFocusConfig.Scale);
	_G["DebuffContener"]:SetPoint("CENTER", UIparent, "CENTER", DroodFocusConfig.contenerX, DroodFocusConfig.contenerY);
	_G["DebuffContener"]:SetScale(DroodFocusConfig.contenerScale);
end

----------------------------------------------------------------------------------------------------
-- DroodFocus - gestion de la mana
----------------------------------------------------------------------------------------------------
function DroodFocus:handleMana()
	if(not DroodFocus.Registered) then return; end
	
	if (DroodFocus.Class == "DRUID") then

		local currentTime = GetTime();
		local _, _, _, ShiftCost, _, _, _, _, _ = GetSpellInfo(9634);
		local powertype = UnitPowerType("player");
		
		regenBase,regenCasting = GetManaRegen();		
		
		-- de la mana?
		if (powertype==0) then	
			
			-- oui, rcupre variables		
			maxiMana = UnitManaMax("player");
			currentMana = UnitMana("player");
	
		else

			-- non , on es en forme de chat ou d'ours
			-- on a une valeur pour la mana? (cas possible: aucune valeur mana si login en forme de char/ours, un passage en forme d'elfe remet tous en place)

			-- calcule temps coul depuis dernier appel handleMana
			elapse = (currentTime - oldTime);
			fiveSeconds = fiveSeconds + elapse;
			fiveSecondsRules = fiveSecondsRules + elapse;

			if (currentMana~=-1 and oldTime~=-1) then

				-- on connait notre mana
				-- une transfo a t faite?
				if (nbTransfo>0) then
					-- oui , enlve le cout de la transfo
					nbTransfo = nbTransfo -1;
					currentMana = currentMana - ShiftCost;
				end
					

				
				-- est on dans la rgle des 5 sec?
				if (fiveSecondsRules<4) then
					-- oui applique rgen adequat
					currentMana = currentMana + (elapse * regenCasting);
				else
					-- non applique rgen adequat
					currentMana = currentMana + (elapse * regenBase);
				end
				
				-- si on depasse la valeur max
				if (currentMana>maxiMana) then
					currentMana=maxiMana;
				end

				-- maj de la barre? (toute les 2 secondes)
				if (fiveSeconds>0.25) then
					fiveSeconds=0;
					-- voir mana bar
					uiDroodFocusManaText:SetText(string.format("%u", currentMana).." / "..string.format("%u", maxiMana));
					uiDroodFocusMana:SetMinMaxValues(0, maxiMana);
					uiDroodFocusMana:SetValue(currentMana);

				end
		
			end	
			
		end
		
		oldTime = currentTime;
		
	else
		-- cacher mana bar
		uiDroodFocusMana:Hide();
	end
end

----------------------------------------------------------------------------------------------------
-- DroodFocus - trackeur de debuffs
----------------------------------------------------------------------------------------------------
function DroodFocus:combatLogTracker(event,source,cible,spell,degat)
	
	-- timer
	local currentTime = GetTime();
	
	local nouveau = true;
	local newposition = -1;
	
	if (degat=="ABSORB") then
		degat=nil;
	end
	
	-- parcours liste abilits
	for i = 1,nbAbilities do
		
		-- si abilits track
		if (abilities[i].abiName == spell or abilities[i].abiNameAlt == spell) then
			
			-- oui
			-- abilit track et si pas deja enregistrs, on sauvergarde ou mj
			for it = 1,nbSpellsTracker do
				
				-- un debuff existe a cette ligne?
				if (SpellsTracker[it].trkTime~=-1) then

					-- verifification si temps expir
					testTimer = SpellsTracker[it].trkTimer - (currentTime - SpellsTracker[it].trkTime);
					
					if (testTimer>0) then
					
						-- temps non expir, meme sort?
						if (SpellsTracker[it].trkSpell==abilities[i].abiName or SpellsTracker[it].trkSpell==abilities[i].abiNameAlt) then
							
							SpellsTracker[it].trkTime = currentTime;
							
							--oui, maj
							nouveau = false; -- le debuff ne sera pas ajout
							
							-- si on a une plage de dgat
							if (degat~=nil) then
								SpellsTracker[it].trkAmount = degat;
								SpellsTracker[it].trkPulse = true;
							else
								SpellsTracker[it].trkAmount = nil;
								SpellsTracker[it].trkPulse = false;	
							end
							
							
						end
					else
						-- temps expir
						SpellsTracker[it].trkTime=-1;
					end
				
				else	
					-- non, sauvegarde position vide
					
					if (newposition == -1) then
						newposition = it;
					end
					
				end
			end
			
			-- nouveau debuff et une position valide?
			if (nouveau and newposition~=-1) then

				-- oui, ajout a la liste
				SpellsTracker[newposition].trkTime = currentTime;
				SpellsTracker[newposition].trkTimer = abilities[i].abiTimer;
				SpellsTracker[newposition].trkSpell = spell;
				SpellsTracker[newposition].trkSource = source;
				SpellsTracker[newposition].trkTarget = cible;
				SpellsTracker[newposition].trkAmount = degat;
				
				
			end
			
		end
	end

end

----------------------------------------------------------------------------------------------------
-- DroodFocus - Cration des icones
----------------------------------------------------------------------------------------------------
function DroodFocus:creerFrames()

	local borderTexture = "";
	local borderSize = 0;

	DroodFocusMainFrame = _G["DroodFocusFrame"];

	-- main frame
	uiDroodFocusFrame = CreateFrame("FRAME","uiDroodFocusFrame",UIparent);
	uiDroodFocusFrame:SetWidth(DFSkin.SKIN_uiWidth);
	uiDroodFocusFrame:SetHeight(DFSkin.SKIN_uiHeight);
	uiDroodFocusFrame:SetPoint("CENTER", UIparent, "CENTER", DroodFocusConfig.mainx, DroodFocusConfig.mainy);
	if (DFSkin.SKIN_uiTexture) then
		uiDroodFocusFrameTextures = uiDroodFocusFrame:CreateTexture(nil,"BACKGROUND");
		uiDroodFocusFrameTextures:SetAllPoints(uiDroodFocusFrame); -- attache la texture a la frame
		uiDroodFocusFrameTextures:SetTexture(DFSkin.SKIN_uiTexture);
		uiDroodFocusFrameTextures:SetBlendMode(DFSkin.SKIN_uiTextureMode);
		uiDroodFocusFrame.texture = uiDroodFocusFrameTextures;
	end
	uiDroodFocusFrame:SetFrameLevel(3);
	
	-- fond energy barre
	borderTexture = "Interface\\Tooltips\\UI-Tooltip-Border";
	if (not DFSkin.SKIN_uiDroodFocusEnergyBorder) then
		borderTexture ="nil";
	end
	uiDroodFocusEnergyBg = CreateFrame("FRAME","uiDroodFocusEnergyBg",uiDroodFocusFrame);
	uiDroodFocusEnergyBg:SetWidth(DFSkin.SKIN_uiDroodFocusEnergyWidth+5);
	uiDroodFocusEnergyBg:SetHeight(DFSkin.SKIN_uiDroodFocusEnergyHeight+5);
	uiDroodFocusEnergyBg:SetPoint("TOPLEFT", uiDroodFocusFrame, "TOPLEFT", DFSkin.SKIN_uiDroodFocusEnergyX-2.5, DFSkin.SKIN_uiDroodFocusEnergyY-2.5);
	uiDroodFocusEnergyBg:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", 
                                    edgeFile = borderTexture, 
                                    tile = true, tileSize = 8, edgeSize =8, 
                                    insets = { left = 2, right =2, top =2, bottom = 2}});
	uiDroodFocusEnergyBg:SetBackdropColor(0,0,0,1);
	uiDroodFocusEnergyBg:SetBackdropBorderColor(0,0,0,1);
	uiDroodFocusEnergyBg:SetFrameLevel(1);

	-- energy barre
	uiDroodFocusEnergy = CreateFrame("StatusBar","uiDroodFocusEnergy",uiDroodFocusFrame);
	uiDroodFocusEnergy:SetWidth(DFSkin.SKIN_uiDroodFocusEnergyWidth);
	uiDroodFocusEnergy:SetHeight(DFSkin.SKIN_uiDroodFocusEnergyHeight);
	uiDroodFocusEnergy:SetPoint("TOPLEFT", uiDroodFocusEnergyBg, "TOPLEFT", 2.5, -2.5);
	uiDroodFocusEnergy:SetStatusBarTexture(DFSkin.SKIN_uiDroodFocusEnergyTexture);
	uiDroodFocusEnergy:SetStatusBarColor(DFSkin.SKIN_uiDroodFocusEnergyColor.r, DFSkin.SKIN_uiDroodFocusEnergyColor.g, DFSkin.SKIN_uiDroodFocusEnergyColor.b, DFSkin.SKIN_uiDroodFocusEnergyColor.a);
	uiDroodFocusEnergy:SetOrientation(DFSkin.SKIN_uiDroodFocusEnergyOrientation);
	uiDroodFocusEnergy:SetFrameLevel(2);

	-- energy barre text
	uiDroodFocusEnergyText = uiDroodFocusFrame:CreateFontString("uiDroodFocusEnergyText","ARTWORK");
	uiDroodFocusEnergyText:SetFont("Interface\\AddOns\\DroodFocus\\arts\\font_energy.ttf",DFSkin.SKIN_uiDroodFocusEnergyTextSize);
	uiDroodFocusEnergyText:SetPoint(DFSkin.SKIN_uiDroodFocusEnergyTextAlign, uiDroodFocusEnergy, DFSkin.SKIN_uiDroodFocusEnergyTextAlign, DFSkin.SKIN_uiDroodFocusEnergyTextX, DFSkin.SKIN_uiDroodFocusEnergyTextY );
	uiDroodFocusEnergyText:SetJustifyH('CENTER')
	uiDroodFocusEnergyText:SetShadowColor(0, 0, 0,0.75);
	uiDroodFocusEnergyText:SetShadowOffset(0.5, -0.5);	
	uiDroodFocusEnergyText:SetTextColor(DFSkin.SKIN_uiDroodFocusEnergyTextColor.r, DFSkin.SKIN_uiDroodFocusEnergyTextColor.g, DFSkin.SKIN_uiDroodFocusEnergyTextColor.b, DFSkin.SKIN_uiDroodFocusEnergyTextColor.a);
	uiDroodFocusEnergyText:SetText("TEST");
	if (not DFSkin.SKIN_uiDroodFocusEnergyTextVisible) then uiDroodFocusEnergyText:Hide() end
	
	-- fond ticks barre
	borderTexture = "Interface\\Tooltips\\UI-Tooltip-Border";
	if (not DFSkin.SKIN_uiDroodFocusTickBorder) then
		borderTexture ="nil";
	end
	uiDroodFocusTickBg = CreateFrame("FRAME","uiDroodFocusTickBg",uiDroodFocusFrame);
	uiDroodFocusTickBg:SetWidth(DFSkin.SKIN_uiDroodFocusTickWidth+5);
	uiDroodFocusTickBg:SetHeight(DFSkin.SKIN_uiDroodFocusTickHeight+5);
	uiDroodFocusTickBg:SetPoint("TOPLEFT", uiDroodFocusFrame, "TOPLEFT", DFSkin.SKIN_uiDroodFocusTickX-2.5, DFSkin.SKIN_uiDroodFocusTickY-2.5);
	uiDroodFocusTickBg:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", 
                                            edgeFile = borderTexture, 
                                            tile = true, tileSize = 8, edgeSize = 8, 
                                            insets = { left = 2, right =2, top = 2, bottom = 2}});
	uiDroodFocusTickBg:SetBackdropColor(DFSkin.SKIN_uiDroodFocusTickBackColor.r, DFSkin.SKIN_uiDroodFocusTickBackColor.g, DFSkin.SKIN_uiDroodFocusTickBackColor.b, DFSkin.SKIN_uiDroodFocusTickBackColor.a);
	uiDroodFocusTickBg:SetBackdropBorderColor(0,0,0,1);
	uiDroodFocusTickBg:SetFrameLevel(1);

	-- ticks barre
	uiDroodFocusTick = CreateFrame("StatusBar","uiDroodFocusTick",uiDroodFocusFrame);
	uiDroodFocusTick:SetWidth(DFSkin.SKIN_uiDroodFocusTickWidth);
	uiDroodFocusTick:SetHeight(DFSkin.SKIN_uiDroodFocusTickHeight);
	uiDroodFocusTick:SetPoint("TOPLEFT", uiDroodFocusTickBg, "TOPLEFT", 2.5, -2.5);
	uiDroodFocusTick:SetStatusBarTexture(DFSkin.SKIN_uiDroodFocusTickTexture);
	uiDroodFocusTick:SetStatusBarColor(DFSkin.SKIN_uiDroodFocusTickColor.r, DFSkin.SKIN_uiDroodFocusTickColor.g, DFSkin.SKIN_uiDroodFocusTickColor.b, DFSkin.SKIN_uiDroodFocusTickColor.a);
	uiDroodFocusTick:SetOrientation(DFSkin.SKIN_uiDroodFocusTickOrientation);
	uiDroodFocusTick:SetFrameLevel(2);

	-- ticks barre text
	uiDroodFocusTickText = uiDroodFocusFrame:CreateFontString("uiDroodFocusTickText","ARTWORK");
	uiDroodFocusTickText:SetFont("Interface\\AddOns\\DroodFocus\\arts\\font_infos.ttf",DFSkin.SKIN_uiDroodFocusTickTextSize);
	uiDroodFocusTickText:SetPoint(DFSkin.SKIN_uiDroodFocusTickTextAlign, uiDroodFocusTick, DFSkin.SKIN_uiDroodFocusTickTextAlign, DFSkin.SKIN_uiDroodFocusTickTextX, DFSkin.SKIN_uiDroodFocusTickTextY );
	uiDroodFocusTickText:SetJustifyH('CENTER')
	uiDroodFocusTickText:SetShadowColor(0, 0, 0, 0.75);
	uiDroodFocusTickText:SetShadowOffset(0.5, -0.5);	
	uiDroodFocusTickText:SetTextColor(DFSkin.SKIN_uiDroodFocusTickTextColor.r, DFSkin.SKIN_uiDroodFocusTickTextColor.g, DFSkin.SKIN_uiDroodFocusTickTextColor.b, DFSkin.SKIN_uiDroodFocusTickTextColor.a);
	uiDroodFocusTickText:SetText("TEST");
	if (not DFSkin.SKIN_uiDroodFocusTickTextVisible) then uiDroodFocusTickText:Hide() end
	
	-- fond mana barre
	borderTexture = "Interface\\Tooltips\\UI-Tooltip-Border";
	if (not DFSkin.SKIN_uiDroodFocusManaBorder) then
		borderTexture ="nil";
	end
	uiDroodFocusManaBg = CreateFrame("FRAME","uiDroodFocusManaBg",uiDroodFocusFrame);
	uiDroodFocusManaBg:SetWidth(DFSkin.SKIN_uiDroodFocusManaWidth+5);
	uiDroodFocusManaBg:SetHeight(DFSkin.SKIN_uiDroodFocusManaHeight+5);
	uiDroodFocusManaBg:SetPoint("TOPLEFT", uiDroodFocusFrame, "TOPLEFT", DFSkin.SKIN_uiDroodFocusManaX-2.5, DFSkin.SKIN_uiDroodFocusManaY-2.5);
	uiDroodFocusManaBg:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", 
                                            edgeFile = borderTexture, 
                                            tile = true, tileSize = 8, edgeSize = 8, 
                                            insets = { left = 2, right =2, top = 2, bottom = 2}});
	uiDroodFocusManaBg:SetBackdropColor(DFSkin.SKIN_uiDroodFocusManaBackColor.r, DFSkin.SKIN_uiDroodFocusManaBackColor.g, DFSkin.SKIN_uiDroodFocusManaBackColor.b, DFSkin.SKIN_uiDroodFocusManaBackColor.a);
	uiDroodFocusManaBg:SetBackdropBorderColor(0,0,0,1);
	uiDroodFocusManaBg:SetFrameLevel(1);

	-- mana barre
	uiDroodFocusMana = CreateFrame("StatusBar","uiDroodFocusMana",uiDroodFocusFrame);
	uiDroodFocusMana:SetWidth(DFSkin.SKIN_uiDroodFocusManaWidth);
	uiDroodFocusMana:SetHeight(DFSkin.SKIN_uiDroodFocusManaHeight);
	uiDroodFocusMana:SetPoint("TOPLEFT", uiDroodFocusManaBg, "TOPLEFT", 2.5, -2.5);
	uiDroodFocusMana:SetStatusBarTexture(DFSkin.SKIN_uiDroodFocusManaTexture);
	uiDroodFocusMana:SetStatusBarColor(DFSkin.SKIN_uiDroodFocusManaColor.r, DFSkin.SKIN_uiDroodFocusManaColor.g, DFSkin.SKIN_uiDroodFocusManaColor.b, DFSkin.SKIN_uiDroodFocusManaColor.a);
	uiDroodFocusMana:SetOrientation(DFSkin.SKIN_uiDroodFocusManaOrientation);
	uiDroodFocusMana:SetFrameLevel(2);

	-- mana barre text
	uiDroodFocusManaText = uiDroodFocusFrame:CreateFontString("uiDroodFocusTickText","ARTWORK");
	uiDroodFocusManaText:SetFont("Interface\\AddOns\\DroodFocus\\arts\\font_infos.ttf",DFSkin.SKIN_uiDroodFocusManaTextSize);
	uiDroodFocusManaText:SetPoint(DFSkin.SKIN_uiDroodFocusManaTextAlign, uiDroodFocusMana, DFSkin.SKIN_uiDroodFocusManaTextAlign, DFSkin.SKIN_uiDroodFocusManaTextX, DFSkin.SKIN_uiDroodFocusManaTextY );
	uiDroodFocusManaText:SetJustifyH('CENTER')
	uiDroodFocusManaText:SetShadowColor(0, 0, 0, 0.75);
	uiDroodFocusManaText:SetShadowOffset(0.5, -0.5);	
	uiDroodFocusManaText:SetTextColor(DFSkin.SKIN_uiDroodFocusManaTextColor.r, DFSkin.SKIN_uiDroodFocusManaTextColor.g, DFSkin.SKIN_uiDroodFocusManaTextColor.b, DFSkin.SKIN_uiDroodFocusManaTextColor.a);
	uiDroodFocusManaText:SetText("?");
	if (not DFSkin.SKIN_uiDroodFocusManaTextVisible) then uiDroodFocusManaText:Hide() end
	
	-- combo bar
	uiDroodFocusComboBar = CreateFrame("FRAME","uiDroodFocusFrame",uiDroodFocusFrame);
	uiDroodFocusComboBar:SetWidth(DFSkin.SKIN_comboBarWidth);
	uiDroodFocusComboBar:SetHeight(DFSkin.SKIN_comboBarHeight);
	uiDroodFocusComboBar:SetPoint("TOPLEFT", uiDroodFocusFrame, "TOPLEFT", DFSkin.SKIN_comboBarX, DFSkin.SKIN_comboBarY);
	uiDroodFocusComboBarTextures = uiDroodFocusComboBar:CreateTexture(nil,"BACKGROUND");
	uiDroodFocusComboBarTextures:SetAllPoints(uiDroodFocusComboBar); -- attache la texture a la frame
	uiDroodFocusComboBarTextures:SetTexture(DFSkin.SKIN_comboBarTexture);
	uiDroodFocusComboBarTextures:SetBlendMode(DFSkin.SKIN_comboBarTextureMode);
	uiDroodFocusComboBar.texture = uiDroodFocusComboBarTextures;
	uiDroodFocusComboBar:SetFrameLevel(DFSkin.SKIN_comboBarLevel);
	if (not DFSkin.SKIN_comboBarVisible) then uiDroodFocusComboBar:Hide() end

	contener = CreateFrame("FRAME","DebuffContener",UIparent);
	contener:SetWidth(nbAbilities*22);
	contener:SetHeight(32);
	contener.texture = contener:CreateTexture()
	contener.texture:SetAllPoints(contener)
	contener.texture:SetTexture(0,0,0,0)

	-- abilits icones
	for i = 1,nbAbilities do

		abiUseobj = abilities[i].abiUseobj;
		abiObj = abilities[i].abiObj;
		abiImg = abilities[i].abiImg;
		abiX = abilities[i].abiX;
		abiY = abilities[i].abiY;
		abiW = abilities[i].abiW;
		abiH = abilities[i].abiH;
		abiMode = abilities[i].abiMode;

		abilities[i].abiName = GetSpellInfo(abilities[i].abiId);
	
		-- Creation de l'icone

		df_Frames[i] = CreateFrame("FRAME",abiObj,contener);
		df_Frames[i]:SetWidth(abiW);
		df_Frames[i]:SetHeight(abiH);
		df_Frames[i]:SetPoint("BOTTOM", contener, "CENTER", abiX, abiY);

		df_Textures[i] = df_Frames[i]:CreateTexture(nil,"BACKGROUND");
		df_Textures[i]:SetAllPoints(df_Frames[i]); -- attache la texture a la frame
		df_Textures[i]:SetTexture(abiImg);
		df_Textures[i]:SetBlendMode(abiMode);
		df_Frames[i].texture = df_Textures[i];

		df_Texts[i] = df_Frames[i]:CreateFontString("$parentText","ARTWORK");
		df_Texts[i]:SetFont("Interface\\AddOns\\DroodFocus\\arts\\font_infos.ttf",9);
		df_Texts[i]:SetPoint("TOP", abiObj, "BOTTOM", 0, 0 );
		df_Texts[i]:SetJustifyH('CENTER')
		df_Texts[i]:SetShadowColor(0, 0, 0, 0.75);
		df_Texts[i]:SetShadowOffset(0.5, -0.5);		
	
		df_Frames[i]:Hide();
		df_Texts[i]:SetText("");

		abilities[i].abiUseobj = i;


	end

	-- points de combo
	for i = 1,5 do

		combo_Frames[i] = CreateFrame("FRAME","combo"..i,uiDroodFocusFrame);
		combo_Frames[i]:SetWidth(DFSkin.SKIN_comboPtWidth);
		combo_Frames[i]:SetHeight(DFSkin.SKIN_comboPtHeight);
		
		combo_Frames[i]:SetPoint("TOPLEFT", uiDroodFocusFrame, "TOPLEFT", DFSkin.SKIN_comboPtX+((i-1)*DFSkin.SKIN_comboPtOffsetX), DFSkin.SKIN_comboPtY+((i-1)*DFSkin.SKIN_comboPtOffsetY));
		combo_Frames[i]:SetFrameLevel(DFSkin.SKIN_comboPtLevel);
		combo_Textures[i] = combo_Frames[i]:CreateTexture(nil,"BACKGROUND");
		
		combo_Textures[i]:SetTexCoord(0, 1, 0, .25);
		combo_Textures[i]:SetWidth(64);
		combo_Textures[i]:SetHeight(64);
		
		combo_Textures[i]:SetAllPoints(combo_Frames[i]); -- attache la texture a la frame
		combo_Textures[i]:SetTexture(DFSkin.SKIN_comboPtTexture);
		combo_Textures[i]:SetBlendMode(DFSkin.SKIN_comboPtTextureMode);
		combo_Frames[i].texture = combo_Textures[i];

		if (DFSkin.SKIN_comboPtVisible) then
			combo_Frames[i]:Show();
		else
			combo_Frames[i]:Hide();
		end

	end

	-- griffes
	for i = 1,5 do
		griffe_Frames[i] = CreateFrame("FRAME","griffe"..i,UIParent);
		
		griffe_Frames[i]:SetWidth(256);
		griffe_Frames[i]:SetHeight(256);
		griffe_Frames[i]:SetPoint("CENTER", UIParent, "CENTER", 0, 0);

		griffe_Textures[i] = griffe_Frames[i]:CreateTexture(nil,"BACKGROUND");
		griffe_Textures[i]:SetTexCoord(0, 1, 0, 1);
		griffe_Textures[i]:SetWidth(256);
		griffe_Textures[i]:SetHeight(256);
		griffe_Textures[i]:SetAllPoints(griffe_Frames[i]); -- attache la texture a la frame
		
		if (i==1 or i==2) then
			griffe_Textures[i]:SetTexture("Interface\\AddOns\\DroodFocus\\arts\\scratch");
			griffe_Textures[i]:SetBlendMode("BLEND");
		elseif (i==3) then
			griffe_Textures[i]:SetTexture("Interface\\AddOns\\DroodFocus\\arts\\blood");
			griffe_Textures[i]:SetBlendMode("ADD");
		elseif (i==4) then
			griffe_Textures[i]:SetTexture("Interface\\AddOns\\DroodFocus\\arts\\blood");			
			griffe_Textures[i]:SetBlendMode("ADD");
		elseif (i==5) then
			griffe_Textures[i]:SetTexture("Interface\\AddOns\\DroodFocus\\arts\\blood");			
			griffe_Textures[i]:SetBlendMode("ADD");
		end
		
		
		griffe_Frames[i].texture = griffe_Textures[i];
	
		griffe_Frames[i]:SetPoint("CENTER", UIParent, "CENTER", claws[i].posX, claws[i].posY);
	
		griffe_Frames[i]:Hide();	
	end
	
	griffe_Textures[1]:SetTexCoord(0, 1, 0, 1);
	griffe_Textures[2]:SetTexCoord(1, 0, 0, 1);

	-- clearcast
	portrait_Frames[1] = CreateFrame("FRAME","portrait3",uiDroodFocusFrame);
	portrait_Frames[1]:SetWidth(DFSkin.SKIN_clearCastWidth);
	portrait_Frames[1]:SetHeight(DFSkin.SKIN_clearCastheight);
	portrait_Frames[1]:SetPoint("CENTER", uiDroodFocusFrame, "TOPLEFT", DFSkin.SKIN_clearCastX,DFSkin.SKIN_clearCastY);
	portrait_Frames[1]:SetFrameLevel(DFSkin.SKIN_clearCastLevel);
	
	portrait_Textures[1] = portrait_Frames[1]:CreateTexture(nil,"BACKGROUND");
	
	portrait_Textures[1]:SetTexCoord(1, 0, 0, 1);
	portrait_Textures[1]:SetWidth(DFSkin.SKIN_clearCastWidth);
	portrait_Textures[1]:SetHeight(DFSkin.SKIN_clearCastheight);
	portrait_Textures[1]:SetBlendMode(DFSkin.SKIN_clearCastTextureMode);
	
	portrait_Textures[1]:SetAllPoints(portrait_Frames[1]); -- attache la texture a la frame
	portrait_Textures[1]:SetTexture(DFSkin.SKIN_clearCastTexture);
	portrait_Frames[1].texture = portrait_Textures[1];

	portrait_Frames[1]:SetAlpha(DFSkin.SKIN_clearCastAlpha);

	portrait_Frames[1]:Hide();

	-- cat form
	portrait_Frames[2] = CreateFrame("FRAME","portrait1",uiDroodFocusFrame);
	portrait_Frames[2]:SetWidth(DFSkin.SKIN_portraitWidth);
	portrait_Frames[2]:SetHeight(DFSkin.SKIN_portraitHeight);
	portrait_Frames[2]:SetPoint("CENTER", uiDroodFocusFrame, "TOPLEFT", DFSkin.SKIN_portraitX, DFSkin.SKIN_portraitY);

	portrait_Textures[2] = portrait_Frames[2]:CreateTexture(nil,"BACKGROUND");
	
	portrait_Textures[2]:SetTexCoord(0, 1, 0, 1);
	portrait_Textures[2]:SetWidth(DFSkin.SKIN_portraitWidth);
	portrait_Textures[2]:SetHeight(DFSkin.SKIN_portraitHeight);
	portrait_Textures[2]:SetBlendMode(DFSkin.SKIN_portraitTextureMode);
	portrait_Textures[2]:SetAllPoints(portrait_Frames[2]); -- attache la texture a la frame
	portrait_Textures[2]:SetTexture(DFSkin.SKIN_portraitTextureCat);
	portrait_Frames[2].texture = portrait_Textures[2];

	portrait_Frames[2]:Hide();
	
	-- bear form
	portrait_Frames[3] = CreateFrame("FRAME","portrait2",uiDroodFocusFrame);
	portrait_Frames[3]:SetWidth(DFSkin.SKIN_portraitWidth);
	portrait_Frames[3]:SetHeight(DFSkin.SKIN_portraitHeight);
	portrait_Frames[3]:SetPoint("CENTER", uiDroodFocusFrame, "TOPLEFT", DFSkin.SKIN_portraitX, DFSkin.SKIN_portraitY);

	portrait_Textures[3] = portrait_Frames[3]:CreateTexture(nil,"BACKGROUND");
	portrait_Textures[3]:SetBlendMode(DFSkin.SKIN_portraitTextureMode);
	portrait_Textures[3]:SetTexCoord(0, 1, 0, 1);
	portrait_Textures[3]:SetWidth(DFSkin.SKIN_portraitWidth);
	portrait_Textures[3]:SetHeight(DFSkin.SKIN_portraitHeight);
	
	portrait_Textures[3]:SetAllPoints(portrait_Frames[3]); -- attache la texture a la frame
	portrait_Textures[3]:SetTexture(DFSkin.SKIN_portraitTexturebear);
	portrait_Frames[3].texture = portrait_Textures[3];

	portrait_Frames[3]:Hide();

	-- rogue form
	portrait_Frames[4] = CreateFrame("FRAME","portrait3",uiDroodFocusFrame);
	portrait_Frames[4]:SetWidth(DFSkin.SKIN_portraitWidth);
	portrait_Frames[4]:SetHeight(DFSkin.SKIN_portraitHeight);
	portrait_Frames[4]:SetPoint("CENTER", uiDroodFocusFrame, "TOPLEFT", DFSkin.SKIN_portraitX, DFSkin.SKIN_portraitY);

	portrait_Textures[4] = portrait_Frames[4]:CreateTexture(nil,"BACKGROUND");
	portrait_Textures[4]:SetBlendMode(DFSkin.SKIN_portraitTextureMode);
	portrait_Textures[4]:SetTexCoord(0, 1, 0, 1);
	portrait_Textures[4]:SetWidth(DFSkin.SKIN_portraitWidth);
	portrait_Textures[4]:SetHeight(DFSkin.SKIN_portraitHeight);
	
	portrait_Textures[4]:SetAllPoints(portrait_Frames[4]); -- attache la texture a la frame
	portrait_Textures[4]:SetTexture(DFSkin.SKIN_portraitTextureRogue);
	portrait_Frames[4].texture = portrait_Textures[4];

	portrait_Frames[4]:Hide();

	portrait_Frames[5] = CreateFrame("FRAME","ccc",uiDroodFocusFrame);
	portrait_Frames[5]:SetWidth(16);
	portrait_Frames[5]:SetHeight(16);
	portrait_Frames[5]:SetPoint("CENTER", uiDroodFocusFrame, "TOPLEFT", DFSkin.SKIN_clearCastX, DFSkin.SKIN_clearCastY);
	portrait_Frames[5]:SetFrameLevel(DFSkin.SKIN_clearCastLevel);
	--
	portrait_Frames[1]:SetPoint("CENTER", portrait_Frames[5], "CENTER", 0, 0);
	
	portrait_Frames[1]:SetFrameLevel(DFSkin.SKIN_clearCastLevel);
	portrait_Frames[2]:SetFrameLevel(DFSkin.SKIN_portraitLevel);
	portrait_Frames[3]:SetFrameLevel(DFSkin.SKIN_portraitLevel);
	portrait_Frames[4]:SetFrameLevel(DFSkin.SKIN_portraitLevel);
	
end

----------------------------------------------------------------------------------------------------
-- DroodFocus - ecrire dans la frame debug
----------------------------------------------------------------------------------------------------
function DroodFocus:debugMsg(msg)
	DEFAULT_CHAT_FRAME:AddMessage(msg);
end

----------------------------------------------------------------------------------------------------
-- DroodFocus - tracking des debuffs 
----------------------------------------------------------------------------------------------------
function DroodFocus:debuffsTracker(numero)

	local targetId = UnitGUID("playertarget"); -- ID de la cible actuelle
	local currentTime = GetTime();
	local name,count,timeLeft;
	local texte1="";
	local texte2="";
	-- si enable
	if (DroodFocusConfig.Tracker and DroodFocusConfig.Enable) then

		-- si target valide
		if (targetId ~= nil) then
			
			-- infos du sort
			local aName = abilities[numero].abiName; 
			local aNameAlt = abilities[numero].abiNameAlt; 
			local aPersonnal = abilities[numero].abiPersonnal; 
			local aCombo = abilities[numero].abiCombo; 
			
			local debuffExist = false;
			local pulse = false;

			if (aCombo) then
				comboPts = 0;
			end		
			
			nbDebuffs=0;
				
			-- parcours liste des debuffs de la cible
			for deb=1,41 do
				
				-- le debuff
				name, _, _, count, _, _, timeLeft  =  UnitDebuff("playertarget",deb);
				
				if (not name) then
					break;
				end
				
				nbDebuffs=nbDebuffs+1;
				
				-- concordance?
				if (name==aName or name==aNameAlt) then
					
					if (not aPersonnal or (aPersonnal and timeLeft)) then
						
						-- debuff perso ou non perso
					
						-- le texte qui sera affich
						texte1="";
						texte2="";
						
						--si temps on affiche
						if (timeLeft and aPersonnal) then
							texte1 = string.format("%.1f", timeLeft);
						end
							
						-- abilits a combo?
						if (aCombo and count~=nil) then
							comboPts = count;
						end
						
						-- liste trackeur
						for trk=1,nbSpellsTracker do	
							
							-- debuff existant?
							if (SpellsTracker[trk].trkTime~=-1) then
								
								-- oui, meme type?
								if (SpellsTracker[trk].trkSpell == aName or SpellsTracker[trk].trkSpell == aNameAlt) then
									
									-- oui, personnel?
									if (not aPersonnal) then
										-- non, verifie temps
										timeLeft = SpellsTracker[trk].trkTimer - (currentTime - SpellsTracker[trk].trkTime);
										if (timeLeft>0) then
											texte1 = string.format("%.1f", timeLeft);
										end
									else
										-- oui, verifie dot
										if (SpellsTracker[trk].trkAmount~=nil) then
											texte2 = tostring(SpellsTracker[trk].trkAmount);
										end
										
									end
									
									-- l'icone doit pulser?
									if (SpellsTracker[trk].trkPulse) then
										
										-- oui
										pulse=true;
										SpellsTracker[trk].trkPulse = false;
										
									end
									
								end
							end
						end
						
						df_Texts[numero]:SetText(texte1.."|n|cFFFFFF00"..texte2);	
						
						abilities[numero].abiTimeLeft = timeLeft; 
						
						-- active icone
						if (not DroodFocus:getAbilitieActive(numero) or pulse) then
							DroodFocus:setAbilitieMode(numero,1);
						end						
						
						debuffExist = true;
						--break;
					end
				end
			end			
			
			if (not debuffExist) then
				DroodFocus:setAbilitieMode(numero,2);
			end
			
			if (aCombo) then
				DroodFocus:UpdateComboBar();
			end	
			
		else
			DroodFocus:hideAbilities();	
		end

	end
end

----------------------------------------------------------------------------------------------------
-- DroodFocus - desactivation de toutes les abilites
----------------------------------------------------------------------------------------------------
function DroodFocus:hideAbilities()

	for i = 1, nbAbilities do
		-- si abilits actives on passe au mode desactivation 2
		if (DroodFocus:getAbilitieActive(i)~=0) then
			DroodFocus:setAbilitieMode(i,2);
		end	
				
	end

end

----------------------------------------------------------------------------------------------------
-- DroodFocus - changement du mode d'animation
----------------------------------------------------------------------------------------------------
function DroodFocus:setAbilitieMode(num,state)
	
	-- attribue les bonnes valeurs au coef de grossiement de l'icone
	if (abilities[num].abiState == 0 and state == 1) then
		abilities[num].abiScaleAdd = 0.2;
		abilities[num].abiAlpha = 1;
		
	elseif (abilities[num].abiState == 1 and state ==2) then
		abilities[num].abiScaleAdd = -0.075;

	elseif (abilities[num].abiState == 0 and state ==2) then
		abilities[num].abiScaleAdd = -0.075;

	elseif (abilities[num].abiState == 1 and state ==1) then
		abilities[num].abiScaleAdd = 0.2;
	
	elseif (abilities[num].abiState == 2 and state ==1) then
		abilities[num].abiScaleAdd = 0.2;				
	end

	abilities[num].abiState = state;
	
end

----------------------------------------------------------------------------------------------------
-- DroodFocus - return vrai si abilit active
----------------------------------------------------------------------------------------------------
function DroodFocus:getAbilitieActive(num)
	if (abilities[num].abiState==1) then
		return true;
	else
		return false;
	end
end

----------------------------------------------------------------------------------------------------
-- DroodFocus - verification du buff ides claires du joueur
----------------------------------------------------------------------------------------------------
function DroodFocus:checkBuffsDrood()

	local showClearcast = false;

	for i=1,16 do
		local n,_,_,_,_,t=UnitBuff("player",i);
		if (not n) then
			break;
		end
		
		if (n==spell_clearcast) then
			showClearcast=true;
			break;
		end
		
	end 	

	if (showClearcast or fakeCC) then
	    clearcastScale = 0.15;
	    clearcastScaleAdd = 0.1;
	    clearcastState = 1;
	else
		if (clearcastState>0) then
	    		clearcastScaleAdd = -0.1;
	    		clearcastState = 2;
		end
	end
	
end

----------------------------------------------------------------------------------------------------
-- DroodFocus - animation des debuffs
----------------------------------------------------------------------------------------------------
function DroodFocus:animateDroodsThings()

	if (DroodFocusConfig.Enable) then
		if (DroodFocus.Class == "DRUID") then
			
			local valmin = 1.2 * DFSkin.SKIN_clearCastSize;
			local valmax = 2 * DFSkin.SKIN_clearCastSize;
			
			-- anim clearcast
			if (clearcastState>0) then
			
				clearcastScale = clearcastScale + clearcastScaleAdd;
		
				if (clearcastState == 1) then
					if	(clearcastScale>valmax) then
						clearcastScale=valmax;
						clearcastScaleAdd=-0.03;
				end
					if	(clearcastScale<valmin and clearcastScaleAdd<0) then
						clearcastScale=valmin;
						clearcastScaleAdd=0.03;
					end
				elseif (clearcastState == 2) then
					if	(clearcastScale<=0.1) then
						clearcastState = 0;
						portrait_Frames[1]:Hide();
					end
				end
				
				portrait_Frames[1]:SetScale(clearcastScale);
		
				if (clearcastState>0) then
					portrait_Frames[1]:Show();
				end
				
			end
		
			-- parcours liste abilites
			for i = 1,nbAbilities do
				
				-- donnees de l'abilite
				abiUseobj = abilities[i].abiUseobj;
				
				if (abiUseobj == i) then
					
					-- ok obj a afficher
					-- sinon c'est une abilit qui utilise une autre icone
					abiScale = abilities[i].abiScale;
					abiScaleAdd = abilities[i].abiScaleAdd;
					abiState = abilities[i].abiState;
					abiX = abilities[i].abiX;
					abiY = abilities[i].abiY;
					
					-- si abilit active
					if (abiState ==1 ) then
			
						abiScale = abiScale + abiScaleAdd;
			
						-- gerer animation etat 1
						if (abiScaleAdd>=0.2) then
							
							-- le debuff pop
							if (abiScale>1.25) then
								abiScale = 1.25;
								abiScaleAdd = -0.03;
							end
						else
							-- le debuff etat normal
							if (abiScale<1 and abiScaleAdd<0) then
								abiScale = 1;
							end									
										
						end
						
					elseif (abiState == 2) then
						
						abiScale = abiScale + abiScaleAdd;
						
						-- gerer animation etat 2, le debuff disparait au fond
						if (abiScale<0.10) then
							-- anim termine
							abiScale = 0.10;
							abiScaleAdd = 0;
							abiState = 0;
			
						end				
					end
					
					abilities[i].abiScale = abiScale;
					abilities[i].abiScaleAdd = abiScaleAdd;
					abilities[i].abiState = abiState;
					
					df_Frames[i]:SetScale(abiScale);
					
					-- fait clignoter le debuff si temps restant < 3 sec
					if (abiState==1 or abiState==2) then
						
						if (abilities[i].abiTimeLeft) then
							if (abilities[i].abiTimeLeft>0 and abilities[i].abiTimeLeft<3) then
								abilities[i].abiAlpha = abilities[i].abiAlpha - ((6 - abilities[i].abiTimeLeft)/100);
								if (abilities[i].abiAlpha<0.25) then
									abilities[i].abiAlpha = 1;
								end
							elseif (abilities[i].abiTimeLeft>3) then
								abilities[i].abiAlpha = 1;
							end
							df_Textures[i]:SetAlpha(abilities[i].abiAlpha);
						end
						df_Frames[i]:Show();
					else
						df_Frames[i]:Hide();
					end
					
				end
				
			end
		end
		
		-- les kikoo griffes :)
		for i = 1,5 do	
			if (claws[i].clawState==1) then
	
				if (i==1 or i==2) then
					claws[i].clawScale = claws[i].clawScale - 0.0005;
					claws[i].clawAlpha = claws[i].clawAlpha - 0.02;
				else
					claws[i].clawAlpha = claws[i].clawAlpha - 0.0035;
				end
				
				
				if (claws[i].clawAlpha<0.01) then
					claws[i].clawAlpha=0.01;
					claws[i].clawState=0;	
					
				end			
				if (claws[i].clawScale<0.01) then
					claws[i].clawScale=0.01;
				end
				
				griffe_Frames[i]:SetScale(claws[i].clawScale);
				griffe_Frames[i]:SetAlpha(claws[i].clawAlpha);
				
				griffe_Frames[i]:Show();
			else
				griffe_Frames[i]:Hide();	
			end
		end
	end
end

----------------------------------------------------------------------------------------------------
-- DroodFocus - desactive griffes et sang
----------------------------------------------------------------------------------------------------
function DroodFocus:noBlood()

	for i = 1,5 do
		claws[i].clawAlpha=0.01;
		claws[i].clawState=0;
		griffe_Frames[i]:Hide();
	end

end

----------------------------------------------------------------------------------------------------
-- DroodFocus - change l'tat d'une griffe
----------------------------------------------------------------------------------------------------
function DroodFocus:newClaw()
	-- changement etat griffe
	claws[clawsOrder].posX = claws[clawsOrder].clawX + (math.random(100)-50);
	claws[clawsOrder].posY = claws[clawsOrder].clawY - math.random(100);
	
	claws[clawsOrder].clawScale = 0.8;
	claws[clawsOrder].clawAlpha = 1;

	griffe_Frames[clawsOrder]:SetPoint("CENTER", UIparent, "CENTER", claws[clawsOrder].posX, claws[clawsOrder].posY);
	claws[clawsOrder].clawState = 1;	

	clawsOrder =  clawsOrder +1;
	if (clawsOrder>2) then
		clawsOrder = 1;
	end 

end

----------------------------------------------------------------------------------------------------
-- DroodFocus - change l'tat d'une griffe
----------------------------------------------------------------------------------------------------
function DroodFocus:newBlood()
	-- changement etat sang
	
	local rotation = math.random(4);
	
	claws[bloodOrder].posX = claws[bloodOrder].clawX + (math.random(120)-60);
	claws[bloodOrder].posY = claws[bloodOrder].clawY + (math.random(120)-60);
	
	if (rotation==1) then
		griffe_Textures[bloodOrder]:SetTexCoord(1, 0, 1, 0);
	elseif (rotation==2) then
		griffe_Textures[bloodOrder]:SetTexCoord(0, 1, 1, 0);
	elseif (rotation==3) then
		griffe_Textures[bloodOrder]:SetTexCoord(1, 0, 0, 1);
	elseif (rotation==4) then
		griffe_Textures[bloodOrder]:SetTexCoord(0, 1, 0, 1);
	end			
	
	claws[bloodOrder].clawScale = DroodFocusConfig.BloodScale + (math.random()/2);
	claws[bloodOrder].clawAlpha = DroodFocusConfig.BloodAlpha;

	griffe_Frames[bloodOrder]:SetPoint("CENTER", UIparent, "CENTER", claws[bloodOrder].posX, claws[bloodOrder].posY);
	claws[bloodOrder].clawState = 1;	

	bloodOrder =  bloodOrder +1;
	if (bloodOrder>5) then
		bloodOrder = 3;
	end 

end

----------------------------------------------------------------------------------------------------
-- DroodFocus - Retourne la forme du joueur 0: caster, 1: chat, 2: ours 
----------------------------------------------------------------------------------------------------
function DroodFocus:currentForm()
	local powertype = UnitPowerType("player");
 	if ( powertype == 0 ) then
   		return 0;
	elseif ( powertype == 1 ) then 
		return 2;
	elseif ( powertype == 3 ) then 
		return 1;		
	end
end


----------------------------------------------------------------------------------------------------
-- DroodFocus - OnUpdate handler
----------------------------------------------------------------------------------------------------
function DroodFocus:OnUpdate()
	if(DroodFocus.Registered and DroodFocusConfig.Enable) then

		local currentForm = DroodFocus:currentForm();
		local energy = UnitMana("player")
		local currentTime = GetTime();
		local sparkPosition = 1;
		
		local base, posBuff, negBuff = UnitAttackPower("player");
		local effective = base + posBuff + negBuff;

		if (currentForm==1) then
			local critChance =  string.format("%.2f", GetCritChance());
			local mainSpeed, offSpeed = UnitAttackSpeed("player");
			local vitesse1 =  string.format("%.2f", mainSpeed);
			local puissanceText = effective.." AP | "..critChance.."% | "..vitesse1.." s.";			
			uiDroodFocusTickText:SetText(puissanceText);
			
			-- animation tick energy communs druides et voleurs
			if(energy > DroodFocus_Energy.Mana or currentTime >= DroodFocus_Energy.End) then
				DroodFocus_Energy.Mana = energy;
				DroodFocus_Energy.Start = currentTime;
				DroodFocus_Energy.End = currentTime + DroodFocus_Energy.Length;
			else
				if(DroodFocus_Energy.Mana ~= energy) then
					DroodFocus_Energy.Mana = energy;
				end
			end
			uiDroodFocusTick:SetMinMaxValues(DroodFocus_Energy.Start, DroodFocus_Energy.End);
			uiDroodFocusTick:SetValue(currentTime);
		elseif (currentForm==2) then
			--ours	

			local dodgeChance =  string.format("%.2f", GetDodgeChance());
			local armor =  tostring(GetCritChance());
			local basearmor, effectiveArmor, armor, posBuff, negBuff = UnitArmor("player");
			local puissanceText = effective.." AP | "..dodgeChance.."% | "..effectiveArmor .." AC.";			
			uiDroodFocusTickText:SetText(puissanceText);
			
			uiDroodFocusTick:SetMinMaxValues(0, 2);
			uiDroodFocusTick:SetValue(2);
			
		end
		
		DroodFocus:UpdateEnergyBar();
		
		-------------------------------------------
		-- appel functions spcifiques aux druides
		-------------------------------------------
		
		DroodFocus:debuffsTracker(trackerPt);
		DroodFocus:animateDroodsThings();

		trackerPt = trackerPt + 1;
		
		if (trackerPt>nbAbilities) then
			trackerPt = 1;
		end
			
	end
end

----------------------------------------------------------------------------------------------------
-- Events Handlers
----------------------------------------------------------------------------------------------------
function DroodFocus:UpdateComboBar()
	
	local currentForm = DroodFocus:currentForm();
	local c = GetComboPoints();
	
	if (currentForm~=1) then
		c = comboPts;
	end
	
	for i = 1, 5 do
		if(i<=c) then
			combo_Textures[i]:SetTexCoord(0, 1, comboOffset+0.25, comboOffset+0.5);
		else
			combo_Textures[i]:SetTexCoord(0, 1, comboOffset+0, comboOffset+0.25);
		end
	end
end

function DroodFocus:UpdateEnergyBar()
	
	local currentForm = DroodFocus:currentForm();
	
	local value, max = UnitMana("player"), UnitManaMax("player");
	local text = value.." / "..max;

	uiDroodFocusEnergy:SetMinMaxValues(0, max);
	uiDroodFocusEnergy:SetValue(value);
	uiDroodFocusEnergyText:SetText(text);	
	
end

function DroodFocus:setFakeCC(valeurcc)
	fakeCC = valeurcc;
	DroodFocus:checkBuffsDrood();
end

function DroodFocus:Toggle()
	-- vrification de la forme
	local currentForm = DroodFocus:currentForm();
	playerId = UnitGUID("player"); -- ID du joueur
	
	if (currentForm==1) then
		-- chat
		uiDroodFocusEnergy:SetStatusBarColor(DFSkin.SKIN_uiDroodFocusEnergyColor.r, DFSkin.SKIN_uiDroodFocusEnergyColor.g, DFSkin.SKIN_uiDroodFocusEnergyColor.b,DFSkin.SKIN_uiDroodFocusEnergyColor.a);
		uiDroodFocusEnergyBg:SetBackdropColor(DFSkin.SKIN_uiDroodFocusEnergyBackColor.r, DFSkin.SKIN_uiDroodFocusEnergyBackColor.g, DFSkin.SKIN_uiDroodFocusEnergyBackColor.b, DFSkin.SKIN_uiDroodFocusEnergyBackColor.a);

		comboOffset = 0;
		DroodFocus:UpdateComboBar();
		if DroodFocusConfig.Enable then
			uiDroodFocusFrame:Show();
			DroodFocusMainFrame:Show();
			if(DroodFocus.Class == "DRUID") then
				portrait_Frames[2]:Show();
				portrait_Frames[3]:Hide();
				portrait_Frames[4]:Hide();
				contener:Show();
			else
				portrait_Frames[4]:Show();
				portrait_Frames[3]:Hide();
				portrait_Frames[2]:Hide();
				contener:Hide();				
			end
		else
			uiDroodFocusFrame:Hide();
			DroodFocusMainFrame:Hide();
			portrait_Frames[2]:Hide();
			portrait_Frames[3]:Hide();
			portrait_Frames[4]:Hide();
			contener:Hide();
		end
		
	elseif (currentForm==2) then
		-- ours
		uiDroodFocusEnergy:SetStatusBarColor(DFSkin.SKIN_uiDroodFocusRageColor.r, DFSkin.SKIN_uiDroodFocusRageColor.g, DFSkin.SKIN_uiDroodFocusRageColor.b,DFSkin.SKIN_uiDroodFocusRageColor.a);
		uiDroodFocusEnergyBg:SetBackdropColor(DFSkin.SKIN_uiDroodFocusRageBackColor.r, DFSkin.SKIN_uiDroodFocusRageBackColor.g, DFSkin.SKIN_uiDroodFocusRageBackColor.b, DFSkin.SKIN_uiDroodFocusRageBackColor.a);
		comboOffset = 0.5;
		if DroodFocusConfig.Enable then
			uiDroodFocusFrame:Show();
			DroodFocusMainFrame:Show();
			contener:Show();
			portrait_Frames[3]:Show();
			portrait_Frames[2]:Hide();
			portrait_Frames[4]:Hide();
		else
			uiDroodFocusFrame:Hide();
			DroodFocusMainFrame:Hide();
			portrait_Frames[2]:Hide();
			portrait_Frames[3]:Hide();
			portrait_Frames[4]:Hide();
		end
	else
		-- aucune
		uiDroodFocusFrame:Hide();
		DroodFocusMainFrame:Hide();
		DroodFocus:noBlood();
		contener:Hide();
		portrait_Frames[2]:Hide();
		portrait_Frames[3]:Hide();
		portrait_Frames[4]:Hide();
	end

	if (not DFSkin.SKIN_portraitVisible) then
		portrait_Frames[2]:Hide();
		portrait_Frames[3]:Hide();
		portrait_Frames[4]:Hide();
	end
	
	-- maj barre combo
	DroodFocus:UpdateComboBar();

end

----------------------------------------------------------------------------------------------------
-- Main
----------------------------------------------------------------------------------------------------
function DroodFocus:RegisterEvents()
	if(DroodFocus.Class ~= "ROGUE" and DroodFocus.Class ~= "DRUID") then
		this:UnregisterEvent("PLAYER_COMBO_POINTS");
		this:UnregisterEvent("PLAYER_AURAS_CHANGED");
		this:UnregisterEvent("UNIT_ENERGY");
		this:UnregisterEvent("UNIT_MAXENERGY");
		this:UnregisterEvent("UNIT_AURA");
		this:UnregisterEvent("PLAYER_REGEN_DISABLED");
		this:UnregisterEvent("PLAYER_REGEN_ENABLED");
		this:UnregisterEvent("PLAYER_ENTERING_WORLD");
		this:UnregisterEvent("PLAYER_DEAD");
		this:UnregisterEvent("VARIABLES_LOADED");
		this:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		this:UnregisterEvent("PLAYER_TARGET_CHANGED");
		return false;
	else
		this:RegisterEvent("PLAYER_COMBO_POINTS");
		this:RegisterEvent("PLAYER_AURAS_CHANGED");
		this:RegisterEvent("UNIT_ENERGY");
		this:RegisterEvent("UNIT_MAXENERGY");
		this:RegisterEvent("UNIT_AURA");
		this:RegisterEvent("PLAYER_REGEN_DISABLED");
		this:RegisterEvent("PLAYER_REGEN_ENABLED");
		this:RegisterEvent("PLAYER_ENTERING_WORLD");
		this:RegisterEvent("PLAYER_DEAD");
		this:RegisterEvent("VARIABLES_LOADED");
		this:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED");
		this:RegisterEvent("PLAYER_TARGET_CHANGED");
		return true;
	end
end
