-- GLOBALS

dgp_Frame_IsMoving = false -- Is the frame currently moving

dgp_Filtered_Guild_Members = {} -- Variable to hold the filtered guild members
dgp_Selected_Guild_Members = {} -- Variable to hold selected guild members

dgp_List_Position = 1 -- Position of the filter list

dgp_Point_Multiplier = 1 -- The multiplier for guild points

dgp_SideMenu_Visible = 0 -- Keeps track of the side menu visibility (IsVisible() will not function for me)

dgpUpdating = "closed" -- Indicates if the addon is updating and who updates are being received from
dgpTempUpdateTime = "0" -- Temporary holder for previous update details while the update is being performed
dgpTempUpdateOriginator = "default" -- Temporary holder for previous update details while the update is being performed

dgpHonoraryRemoveType = "none" -- Indicates what removal type to use

-- Button toggles
dgp_Button1_Toggle = 0
dgp_Button2_Toggle = 0
dgp_Button3_Toggle = 0
dgp_Button4_Toggle = 0
dgp_Button5_Toggle = 0
dgp_Button6_Toggle = 0
dgp_Button7_Toggle = 0
dgp_Button8_Toggle = 0
dgp_Button9_Toggle = 0
dgp_Button10_Toggle = 0

dgp_Points_Text = "" -- The text in the custom points editbox
dgp_Side_Frame_Value1 = "" -- The value in the #1 side frame value box
dgp_Side_Frame_Value2 = "" -- The value in the #2 side frame value box
dgp_Side_Frame_Value3 = "" -- The value in the #3 side frame value box
dgp_Side_Frame_Value4 = "" -- The value in the #4 side frame value box
dgp_Side_Frame_Value5 = "" -- The value in the #5 side frame value box
dgp_Side_Frame_Value6 = "" -- The value in the #6 side frame value box
dgp_Side_Frame_Value7 = "" -- The value in the #7 side frame value box
dgp_Side_Frame_Value8 = "" -- The value in the #8 side frame value box
dgp_Side_Frame_Value9 = "" -- The value in the #9 side frame value box
dgp_Side_Frame_Value10 = "" -- The value in the #10 side frame value box

dgpPlayerName = UnitName("player") -- Store the user's name

-- For the wait function (http://www.wowwiki.com/Wait)
local waitTable = {};
local waitFrame = nil;

-- Register
RegisterAddonMessagePrefix("dgpCheck")
RegisterAddonMessagePrefix("dgpReply")
RegisterAddonMessagePrefix("dgpRequest")
RegisterAddonMessagePrefix("dgpUpdateReply")


-- Init variable/function for the dropbox menu
local dgpFilterDropboxInit = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "All Members"
	info.value = "All"
	info.func = function(self)
			dgpFilterDropboxChangeValue("All") -- Call this function when clicked
			dgpFilterPlayers() -- Update the filtered guild members
			dgpUpdateList() -- Show the new filtered list
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "Online Guild Members (No Honorary Members)"
	info.value = "Online"
	info.func = function(self)
			dgpFilterDropboxChangeValue("Online") -- Call this function when clicked
			dgpFilterPlayers() -- Update the filtered guild members
			dgpUpdateList() -- Show the new filtered list
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "Party/Raid Members"
	info.value = "Party"
	info.func = function(self)
			dgpFilterDropboxChangeValue("Party") -- Call this function when clicked
			dgpFilterPlayers() -- Update the filtered guild members
			dgpUpdateList() -- Show the new filtered list
		end
	UIDropDownMenu_AddButton(info)	
	
	-- Button 4
	info = {}
	info.text = "Honorary Members"
	info.value = "Honorary"
	info.func = function(self)
			dgpFilterDropboxChangeValue("Honorary") -- Call this function when clicked
			dgpFilterPlayers() -- Update the filtered guild members
			dgpUpdateList() -- Show the new filtered list
		end
	UIDropDownMenu_AddButton(info)	
	
	-- Button 5
	info = {}
	info.text = "Selected Members"
	info.value = "Selected"
	info.func = function(self)
			dgpFilterDropboxChangeValue("Selected") -- Call this function when clicked
			dgpFilterPlayers() -- Update the filtered guild members
			dgpUpdateList() -- Show the new filtered list
		end
	UIDropDownMenu_AddButton(info)	
end -- dgpFilterDropboxInit

-- Init variable/functions for the side frame drop down boxes
local dgpSideMenuDropbox1Init = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Title"
	info.value = "Title"
	info.func = function(self)
			dgpSideMenuDropbox1ChangeValue("Title") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "Modifier"
	info.value = "Modifier"
	info.func = function(self)
			dgpSideMenuDropbox1ChangeValue("Modifier") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "Adder"
	info.value = "Adder"
	info.func = function(self)
			dgpSideMenuDropbox1ChangeValue("Adder") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
end
local dgpSideMenuDropbox2Init = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Title"
	info.value = "Title"
	info.func = function(self)
			dgpSideMenuDropbox2ChangeValue("Title") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "Modifier"
	info.value = "Modifier"
	info.func = function(self)
			dgpSideMenuDropbox2ChangeValue("Modifier") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "Adder"
	info.value = "Adder"
	info.func = function(self)
			dgpSideMenuDropbox2ChangeValue("Adder") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
end
local dgpSideMenuDropbox3Init = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Title"
	info.value = "Title"
	info.func = function(self)
			dgpSideMenuDropbox3ChangeValue("Title") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "Modifier"
	info.value = "Modifier"
	info.func = function(self)
			dgpSideMenuDropbox3ChangeValue("Modifier") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "Adder"
	info.value = "Adder"
	info.func = function(self)
			dgpSideMenuDropbox3ChangeValue("Adder") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
end
local dgpSideMenuDropbox4Init = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Title"
	info.value = "Title"
	info.func = function(self)
			dgpSideMenuDropbox4ChangeValue("Title") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "Modifier"
	info.value = "Modifier"
	info.func = function(self)
			dgpSideMenuDropbox4ChangeValue("Modifier") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "Adder"
	info.value = "Adder"
	info.func = function(self)
			dgpSideMenuDropbox4ChangeValue("Adder") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
end
local dgpSideMenuDropbox5Init = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Title"
	info.value = "Title"
	info.func = function(self)
			dgpSideMenuDropbox5ChangeValue("Title") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "Modifier"
	info.value = "Modifier"
	info.func = function(self)
			dgpSideMenuDropbox5ChangeValue("Modifier") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "Adder"
	info.value = "Adder"
	info.func = function(self)
			dgpSideMenuDropbox5ChangeValue("Adder") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
end
local dgpSideMenuDropbox6Init = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Title"
	info.value = "Title"
	info.func = function(self)
			dgpSideMenuDropbox6ChangeValue("Title") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "Modifier"
	info.value = "Modifier"
	info.func = function(self)
			dgpSideMenuDropbox6ChangeValue("Modifier") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "Adder"
	info.value = "Adder"
	info.func = function(self)
			dgpSideMenuDropbox6ChangeValue("Adder") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
end
local dgpSideMenuDropbox7Init = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Title"
	info.value = "Title"
	info.func = function(self)
			dgpSideMenuDropbox7ChangeValue("Title") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "Modifier"
	info.value = "Modifier"
	info.func = function(self)
			dgpSideMenuDropbox7ChangeValue("Modifier") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "Adder"
	info.value = "Adder"
	info.func = function(self)
			dgpSideMenuDropbox7ChangeValue("Adder") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
end
local dgpSideMenuDropbox8Init = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Title"
	info.value = "Title"
	info.func = function(self)
			dgpSideMenuDropbox8ChangeValue("Title") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "Modifier"
	info.value = "Modifier"
	info.func = function(self)
			dgpSideMenuDropbox8ChangeValue("Modifier") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "Adder"
	info.value = "Adder"
	info.func = function(self)
			dgpSideMenuDropbox8ChangeValue("Adder") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
end
local dgpSideMenuDropbox9Init = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Title"
	info.value = "Title"
	info.func = function(self)
			dgpSideMenuDropbox9ChangeValue("Title") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "Modifier"
	info.value = "Modifier"
	info.func = function(self)
			dgpSideMenuDropbox9ChangeValue("Modifier") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "Adder"
	info.value = "Adder"
	info.func = function(self)
			dgpSideMenuDropbox9ChangeValue("Adder") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
end
local dgpSideMenuDropbox10Init = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "Title"
	info.value = "Title"
	info.func = function(self)
			dgpSideMenuDropbox10ChangeValue("Title") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "Modifier"
	info.value = "Modifier"
	info.func = function(self)
			dgpSideMenuDropbox10ChangeValue("Modifier") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "Adder"
	info.value = "Adder"
	info.func = function(self)
			dgpSideMenuDropbox10ChangeValue("Adder") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
end

-- Init variable/functions for the side menu backup selection box
local dgpSideMenuBackupDropboxInit = function()
	
	-- Add the menu buttons
	local info = UIDropDownMenu_CreateInfo()
	info.text = "1"
	info.value = "1"
	info.func = function(self)
			dgpSideMenuBackupDropboxChangeValue("1") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 2
	info = {}
	info.text = "2"
	info.value = "2"
	info.func = function(self)
			dgpSideMenuBackupDropboxChangeValue("2") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)
	
	-- Button 3
	info = {}
	info.text = "3"
	info.value = "3"
	info.func = function(self)
			dgpSideMenuBackupDropboxChangeValue("3") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
	
	-- Button 4
	info = {}
	info.text = "4"
	info.value = "4"
	info.func = function(self)
			dgpSideMenuBackupDropboxChangeValue("4") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
	
	-- Button 5
	info = {}
	info.text = "5"
	info.value = "5"
	info.func = function(self)
			dgpSideMenuBackupDropboxChangeValue("5") -- Call this function when clicked
		end
	UIDropDownMenu_AddButton(info)	
end -- dgpSideMenuBackupDropboxInit


-- END GLOBALS

-- FRAMES

-- ** Main frame **
local dgp_Frame = CreateFrame("Frame", nil, UIParent) -- Create the Draqisfang Guild Points (dgp) parent frame
	
	-- Register events with the frame
	dgp_Frame:RegisterEvent("ADDON_LOADED") -- Triggered when saved variables are loaded
	dgp_Frame:RegisterEvent("PLAYER_LOGOUT") -- Triggered when the game is about to log out

	-- Set the frame attributes
	dgp_Frame:SetFrameStrata("HIGH") -- Set the frame above most of the UI
	dgp_Frame:SetFrameLevel(11) -- Set the display layer
		-- Size and position are calculated by dgp_Resize_Frames() after the addon loads

	-- Set the texture of the parent frame	
	dgp_Frame:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Background",
		edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
		tile = false, tileSize = 0, edgeSize = 16,
		insets = { left = 4, right = 4, top = 4, bottom = 4} })

	-- Allow the frame to move
	dgp_Frame:SetMovable(true)

	-- Allow mouse interaction
	dgp_Frame:EnableMouse(true)
	
	-- Start with the parent window hidden
	dgp_Frame:Hide()
	
	-- ** Fade out frame **
	local dgp_Fade_Frame = CreateFrame("Button", nil, dgp_Frame) -- Create a frame for fading the addon
	
		-- Set the frame attributes
		dgp_Fade_Frame:SetFrameStrata("HIGH") -- Set the frame above most of the UI
		dgp_Fade_Frame:SetFrameLevel(1) -- Hide the frame behind the rest of the addon by default
			-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
		
		-- Set the frame texture
		dgp_Fade_Frame.texture = dgp_Fade_Frame:CreateTexture()
		dgp_Fade_Frame.texture:SetAllPoints(dgp_Fade_Frame)
		dgp_Fade_Frame.texture:SetTexture(0.0, 0.0, 0.0, 0.8)
		
	-- ** End Fade Frame**
	
	-- ** Title frame (Top left of main frame) **
	local dgp_Title_Frame = CreateFrame("Button", nil, dgp_Frame) -- Create the Title frame and attach it to the main frame
	-- This has been changed from a frame to a button to enable click and drag.
	
		-- Set the frame attributes
		dgp_Title_Frame:SetFrameStrata("HIGH") -- Set the frame above most of the UI
		dgp_Title_Frame:SetFrameLevel(12) -- Set the display layer
			-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
		
		-- Add a title to the addon window
		dgp_Title_Frame.text = dgp_Title_Frame:CreateFontString(nil, "MEDIUM", "GameFontNormal")
		dgp_Title_Frame.text:SetAllPoints()
		dgp_Title_Frame.text:SetText("Draqisfang Guild Points")
		
		-- Set the texture of the filter frame
		dgp_Title_Frame:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Title-Frame-Background",
			edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
			tile = false, tileSize = 0, edgeSize = 16,
			insets = { left = 4, right = 4, top = 4, bottom = 4} })
		
		-- Register the frame for mouse clicks and define the action
		dgp_Title_Frame:RegisterForClicks("LeftButtonDown", "LeftButtonUp") -- Left button up and down are considered clicks
		dgp_Title_Frame:SetScript("OnClick", function(self)  dgp_Toggle_Move() end) -- Toggle UI movement when the frame is clicked
		
	-- ** End Title frame **
	
	
	-- ** Expand Side Frame button **
	local dgp_Expand_SideMenu_Button = CreateFrame("Button", nil, dgp_Frame) -- Create the Expand Button frame
		
		-- Set the button attributes
		dgp_Expand_SideMenu_Button:SetFrameStrata("HIGH") -- Set the frame above most of the UI
		dgp_Expand_SideMenu_Button:SetFrameLevel(12) -- Set the display layer
			-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
			
		-- Set the texture of the close button
		-- Border
		dgp_Expand_SideMenu_Button:SetBackdrop({ bgFile = nil,
			edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
			tile = false, tileSize = 0, edgeSize = 16,
			insets = { left = 0, right = 0, top = 0, bottom = 0} })
		dgp_Expand_SideMenu_Button:SetNormalTexture("Interface\\Addons\\GuildPoints\\Images\\Expand-Button-Background")
		dgp_Expand_SideMenu_Button:SetPushedTexture("Interface\\Addons\\GuildPoints\\Images\\Expand-Button-Pressed")
		dgp_Expand_SideMenu_Button:SetHighlightTexture("Interface\\Addons\\GuildPoints\\Images\\Expand-Button-Highlight")
	
		-- Register the action for clicks
		dgp_Expand_SideMenu_Button:SetScript("OnClick", function(self)
				if dgp_SideMenu_Visible == 1 then
					dgpHideSideMenu()
				else
					dgpShowSideMenu()
				end -- end if
			end)
	
	-- ** End Expand Side Frame button **
	
	
	-- ** Close button (Top right of main frame) **
	local dgp_Close_Button = CreateFrame("Button", nil, dgp_Frame) -- Create the Close Button frame and attach it to the main frame
		
		-- Set the button attributes
		dgp_Close_Button:SetFrameStrata("HIGH") -- Set the frame above most of the UI
		dgp_Close_Button:SetFrameLevel(12) -- Set the display layer
			-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
			
		-- Set the texture of the close button
		-- Border
		dgp_Close_Button:SetBackdrop({ bgFile = nil,
			edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
			tile = false, tileSize = 0, edgeSize = 16,
			insets = { left = 0, right = 0, top = 0, bottom = 0} })
		dgp_Close_Button:SetNormalTexture("Interface\\Addons\\GuildPoints\\Images\\Close-Button-Background")
		dgp_Close_Button:SetPushedTexture("Interface\\Addons\\GuildPoints\\Images\\Close-Button-Pressed")
		dgp_Close_Button:SetHighlightTexture("Interface\\Addons\\GuildPoints\\Images\\Close-Button-Highlight")
	
		-- Register the action for clicks
		dgp_Close_Button:SetScript("OnClick", function(self) dgpHide() end)
	
	-- ** End Close button **
	
	
	-- ** Bottom Frame (Everything below the title in the main frame) **
	local dgp_Bottom_Frame = CreateFrame("Button", nil, dgp_Frame) -- Create the bottom segment and attach it to the main frame
	-- This is made as a button to enable dragging, same as the title frame
		
		-- Set the frame attributes
		dgp_Bottom_Frame:SetFrameStrata("HIGH") -- Set the frame above most of the UI
		dgp_Bottom_Frame:SetFrameLevel(12) -- Set the display layer
			-- Size and poistion are calculated by dgp_Resize_Frames() after the addon loads
			
		-- Set the texture of the bottom frame
		dgp_Bottom_Frame:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Title-Frame-Background",
			edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
			tile = false, tileSize = 0, edgeSize = 16,
			insets = { left = 4, right = 4, top = 4, bottom = 4} })
		
		-- ** Filter Editbox (Top Right of the 'Bottom Frame')
		local dgp_Filter_Editbox = CreateFrame("EditBox", nil, dgp_Bottom_Frame)
			-- Set the font for the editbox
			dgp_Filter_Editbox:SetFontObject("GameFontHighlight")
			
			-- Turn off autofocus to stop the box keeping focus
			dgp_Filter_Editbox:SetAutoFocus(false)
			
			-- Set the editbox attributes
			dgp_Filter_Editbox:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_Filter_Editbox:SetFrameLevel(13) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			-- Set the texture of the filter editbox
			dgp_Filter_Editbox:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Title-Frame-Background",
				edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
				tile = false, tileSize = 0, edgeSize = 16,
				insets = { left = 4, right = 4, top = 4, bottom = 4} })
			
			dgp_Filter_Editbox:SetMaxLetters(30)
			dgp_Filter_Editbox:SetTextInsets( 5, 5, 2, 2)
			
			-- Register an action for enter
			dgp_Filter_Editbox:SetScript("OnEnterPressed", function(self) dgpClearFilterFocus() end)
			-- Register an action for the text changing
			dgp_Filter_Editbox:SetScript("OnTextChanged", function(self) dgpFilterPlayers()
				dgpUpdateList()
				end)
			
		-- ** End Filter editbox **
		
		-- ** Filter Edibox Label ( Left of the  Filter Editbox)
		local dgp_Filter_Editbox_Label = CreateFrame("Frame", nil, dgp_Bottom_Frame)
			
			-- Set the frame attributes
			dgp_Filter_Editbox_Label:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_Filter_Editbox_Label:SetFrameLevel(13) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
		
			-- Add a title to the addon window
			dgp_Filter_Editbox_Label.text = dgp_Filter_Editbox_Label:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_Filter_Editbox_Label.text:SetAllPoints()
			dgp_Filter_Editbox_Label.text:SetText("Filter by name:")
		
		-- ** End Filter Editbox Label
		
		-- ** Filter DropBox (Beneath the Filter Editbox)
		local dgp_Filter_Dropbox = CreateFrame("Button", "Filter_Dropbox", dgp_Bottom_Frame, "UIDropDownMenuTemplate")
			
			-- Set the dropbox attributes
			dgp_Filter_Dropbox:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_Filter_Dropbox:SetFrameLevel(13) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
			
			UIDropDownMenu_Initialize(dgp_Filter_Dropbox, dgpFilterDropboxInit) -- Initialise the dropbox
		
			UIDropDownMenu_SetSelectedID(dgp_Filter_Dropbox, 1) -- Set the default menu selection
			
			UIDropDownMenu_JustifyText(dgp_Filter_Dropbox, "LEFT") -- Set the text justification
			
		-- ** End Filter dropbox
		
		-- ** Filter Dropbox Label ( Left of the  Filter Dropbox)
		local dgp_Filter_Dropbox_Label = CreateFrame("Frame", nil, dgp_Bottom_Frame)
			
			-- Set the frame attributes
			dgp_Filter_Dropbox_Label:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_Filter_Dropbox_Label:SetFrameLevel(13) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
		
			-- Add a title to the addon window
			dgp_Filter_Dropbox_Label.text = dgp_Filter_Dropbox_Label:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_Filter_Dropbox_Label.text:SetAllPoints()
			dgp_Filter_Dropbox_Label.text:SetText("Filter by type:")
		
		-- ** End Filter Dropbox Label
		
		-- ** Player Listbox (Beneath the Filter Dropbox, to the left side of the frame)
		local dgp_Player_Listbox = CreateFrame("Frame", nil, dgp_Bottom_Frame)
			
			-- Set the listbox attributes
			dgp_Player_Listbox:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_Player_Listbox:SetFrameLevel(13) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			-- Set the texture of the player listbox
			dgp_Player_Listbox:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Title-Frame-Background",
				edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
				tile = false, tileSize = 0, edgeSize = 16,
				insets = { left = 4, right = 4, top = 4, bottom = 4} })
			
			-- ** Player Listbox Buttons
			-- Skipping the explainations for mass buttons
			local dgp_Player_Listbox_Button1_1 = CreateFrame("Button", "dgpButton1_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button1_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button1_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button1_1.texture = dgp_Player_Listbox_Button1_1:CreateTexture()
				dgp_Player_Listbox_Button1_1.texture:SetAllPoints(dgp_Player_Listbox_Button1_1)
				dgp_Player_Listbox_Button1_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button1_1.text = dgp_Player_Listbox_Button1_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button1_1.text:SetAllPoints()
				dgp_Player_Listbox_Button1_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(1) end)
			local dgp_Player_Listbox_Button1_2 = CreateFrame("Button", "dgpButton1_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button1_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button1_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button1_2.texture = dgp_Player_Listbox_Button1_2:CreateTexture()
				dgp_Player_Listbox_Button1_2.texture:SetAllPoints(dgp_Player_Listbox_Button1_2)
				dgp_Player_Listbox_Button1_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button1_2.text = dgp_Player_Listbox_Button1_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button1_2.text:SetAllPoints()
				dgp_Player_Listbox_Button1_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(1) end)
				
			local dgp_Player_Listbox_Button2_1 = CreateFrame("Button", "dgpButton2_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button2_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button2_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button2_1.texture = dgp_Player_Listbox_Button2_1:CreateTexture()
				dgp_Player_Listbox_Button2_1.texture:SetAllPoints(dgp_Player_Listbox_Button2_1)
				dgp_Player_Listbox_Button2_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button2_1.text = dgp_Player_Listbox_Button2_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button2_1.text:SetAllPoints()
				dgp_Player_Listbox_Button2_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(2) end)
			local dgp_Player_Listbox_Button2_2 = CreateFrame("Button", "dgpButton2_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button2_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button2_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button2_2.texture = dgp_Player_Listbox_Button2_2:CreateTexture()
				dgp_Player_Listbox_Button2_2.texture:SetAllPoints(dgp_Player_Listbox_Button2_2)
				dgp_Player_Listbox_Button2_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button2_2.text = dgp_Player_Listbox_Button2_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button2_2.text:SetAllPoints()
				dgp_Player_Listbox_Button2_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(2) end)
				
			local dgp_Player_Listbox_Button3_1 = CreateFrame("Button", "dgpButton3_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button3_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button3_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button3_1.texture = dgp_Player_Listbox_Button3_1:CreateTexture()
				dgp_Player_Listbox_Button3_1.texture:SetAllPoints(dgp_Player_Listbox_Button3_1)
				dgp_Player_Listbox_Button3_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button3_1.text = dgp_Player_Listbox_Button3_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button3_1.text:SetAllPoints()
				dgp_Player_Listbox_Button3_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(3) end)
			local dgp_Player_Listbox_Button3_2 = CreateFrame("Button", "dgpButton3_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button3_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button3_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button3_2.texture = dgp_Player_Listbox_Button3_2:CreateTexture()
				dgp_Player_Listbox_Button3_2.texture:SetAllPoints(dgp_Player_Listbox_Button3_2)
				dgp_Player_Listbox_Button3_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button3_2.text = dgp_Player_Listbox_Button3_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button3_2.text:SetAllPoints()
				dgp_Player_Listbox_Button3_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(3) end)
				
			local dgp_Player_Listbox_Button4_1 = CreateFrame("Button", "dgpButton4_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button4_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button4_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button4_1.texture = dgp_Player_Listbox_Button4_1:CreateTexture()
				dgp_Player_Listbox_Button4_1.texture:SetAllPoints(dgp_Player_Listbox_Button4_1)
				dgp_Player_Listbox_Button4_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button4_1.text = dgp_Player_Listbox_Button4_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button4_1.text:SetAllPoints()
				dgp_Player_Listbox_Button4_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(4) end)
			local dgp_Player_Listbox_Button4_2 = CreateFrame("Button", "dgpButton4_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button4_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button4_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button4_2.texture = dgp_Player_Listbox_Button4_2:CreateTexture()
				dgp_Player_Listbox_Button4_2.texture:SetAllPoints(dgp_Player_Listbox_Button4_2)
				dgp_Player_Listbox_Button4_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button4_2.text = dgp_Player_Listbox_Button4_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button4_2.text:SetAllPoints()
				dgp_Player_Listbox_Button4_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(4) end)
				
			local dgp_Player_Listbox_Button5_1 = CreateFrame("Button", "dgpButton5_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button5_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button5_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button5_1.texture = dgp_Player_Listbox_Button5_1:CreateTexture()
				dgp_Player_Listbox_Button5_1.texture:SetAllPoints(dgp_Player_Listbox_Button5_1)
				dgp_Player_Listbox_Button5_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button5_1.text = dgp_Player_Listbox_Button5_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button5_1.text:SetAllPoints()
				dgp_Player_Listbox_Button5_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(5) end)
			local dgp_Player_Listbox_Button5_2 = CreateFrame("Button", "dgpButton5_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button5_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button5_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button5_2.texture = dgp_Player_Listbox_Button5_2:CreateTexture()
				dgp_Player_Listbox_Button5_2.texture:SetAllPoints(dgp_Player_Listbox_Button5_2)
				dgp_Player_Listbox_Button5_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button5_2.text = dgp_Player_Listbox_Button5_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button5_2.text:SetAllPoints()
				dgp_Player_Listbox_Button5_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(5) end)
				
			local dgp_Player_Listbox_Button6_1 = CreateFrame("Button", "dgpButton6_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button6_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button6_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button6_1.texture = dgp_Player_Listbox_Button6_1:CreateTexture()
				dgp_Player_Listbox_Button6_1.texture:SetAllPoints(dgp_Player_Listbox_Button6_1)
				dgp_Player_Listbox_Button6_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button6_1.text = dgp_Player_Listbox_Button6_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button6_1.text:SetAllPoints()
				dgp_Player_Listbox_Button6_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(6) end)
			local dgp_Player_Listbox_Button6_2 = CreateFrame("Button", "dgpButton6_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button6_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button6_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button6_2.texture = dgp_Player_Listbox_Button6_1:CreateTexture()
				dgp_Player_Listbox_Button6_2.texture = dgp_Player_Listbox_Button6_2:CreateTexture()
				dgp_Player_Listbox_Button6_2.texture:SetAllPoints(dgp_Player_Listbox_Button6_2)
				dgp_Player_Listbox_Button6_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button6_2.text = dgp_Player_Listbox_Button6_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button6_2.text:SetAllPoints()
				dgp_Player_Listbox_Button6_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(6) end)
				
			local dgp_Player_Listbox_Button7_1 = CreateFrame("Button", "dgpButton7_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button7_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button7_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button7_1.texture = dgp_Player_Listbox_Button7_1:CreateTexture()
				dgp_Player_Listbox_Button7_1.texture:SetAllPoints(dgp_Player_Listbox_Button7_1)
				dgp_Player_Listbox_Button7_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button7_1.text = dgp_Player_Listbox_Button7_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button7_1.text:SetAllPoints()
				dgp_Player_Listbox_Button7_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(7) end)
			local dgp_Player_Listbox_Button7_2 = CreateFrame("Button", "dgpButton7_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button7_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button7_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button7_2.texture = dgp_Player_Listbox_Button7_2:CreateTexture()
				dgp_Player_Listbox_Button7_2.texture:SetAllPoints(dgp_Player_Listbox_Button7_2)
				dgp_Player_Listbox_Button7_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button7_2.text = dgp_Player_Listbox_Button7_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button7_2.text:SetAllPoints()
				dgp_Player_Listbox_Button7_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(7) end)
				
			local dgp_Player_Listbox_Button8_1 = CreateFrame("Button", "dgpButton8_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button8_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button8_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button8_1.texture = dgp_Player_Listbox_Button8_1:CreateTexture()
				dgp_Player_Listbox_Button8_1.texture:SetAllPoints(dgp_Player_Listbox_Button8_1)
				dgp_Player_Listbox_Button8_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button8_1.text = dgp_Player_Listbox_Button8_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button8_1.text:SetAllPoints()
				dgp_Player_Listbox_Button8_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(8) end)
			local dgp_Player_Listbox_Button8_2 = CreateFrame("Button", "dgpButton8_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button8_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button8_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button8_2.texture = dgp_Player_Listbox_Button8_2:CreateTexture()
				dgp_Player_Listbox_Button8_2.texture:SetAllPoints(dgp_Player_Listbox_Button8_2)
				dgp_Player_Listbox_Button8_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button8_2.text = dgp_Player_Listbox_Button8_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button8_2.text:SetAllPoints()
				dgp_Player_Listbox_Button8_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(8) end)
				
			local dgp_Player_Listbox_Button9_1 = CreateFrame("Button", "dgpButton9_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button9_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button9_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button9_1.texture = dgp_Player_Listbox_Button9_1:CreateTexture()
				dgp_Player_Listbox_Button9_1.texture:SetAllPoints(dgp_Player_Listbox_Button9_1)
				dgp_Player_Listbox_Button9_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button9_1.text = dgp_Player_Listbox_Button9_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button9_1.text:SetAllPoints()
				dgp_Player_Listbox_Button9_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(9) end)
			local dgp_Player_Listbox_Button9_2 = CreateFrame("Button", "dgpButton9_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button9_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button9_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button9_2.texture = dgp_Player_Listbox_Button9_2:CreateTexture()
				dgp_Player_Listbox_Button9_2.texture:SetAllPoints(dgp_Player_Listbox_Button9_2)
				dgp_Player_Listbox_Button9_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button9_2.text = dgp_Player_Listbox_Button9_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button9_2.text:SetAllPoints()
				dgp_Player_Listbox_Button9_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(9) end)
				
			local dgp_Player_Listbox_Button10_1 = CreateFrame("Button", "dgpButton10_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button10_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button10_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button10_1.texture = dgp_Player_Listbox_Button10_1:CreateTexture()
				dgp_Player_Listbox_Button10_1.texture:SetAllPoints(dgp_Player_Listbox_Button10_1)
				dgp_Player_Listbox_Button10_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button10_1.text = dgp_Player_Listbox_Button10_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button10_1.text:SetAllPoints()
				dgp_Player_Listbox_Button10_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(10) end)
			local dgp_Player_Listbox_Button10_2 = CreateFrame("Button", "dgpButton10_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button10_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button10_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button10_2.texture = dgp_Player_Listbox_Button10_2:CreateTexture()
				dgp_Player_Listbox_Button10_2.texture:SetAllPoints(dgp_Player_Listbox_Button10_2)
				dgp_Player_Listbox_Button10_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button10_2.text = dgp_Player_Listbox_Button10_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button10_2.text:SetAllPoints()
				dgp_Player_Listbox_Button10_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(10) end)
				
			local dgp_Player_Listbox_Button11_1 = CreateFrame("Button", "dgpButton11_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button11_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button11_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button11_1.texture = dgp_Player_Listbox_Button11_1:CreateTexture()
				dgp_Player_Listbox_Button11_1.texture:SetAllPoints(dgp_Player_Listbox_Button11_1)
				dgp_Player_Listbox_Button11_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button11_1.text = dgp_Player_Listbox_Button11_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button11_1.text:SetAllPoints()
				dgp_Player_Listbox_Button11_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(11) end)
			local dgp_Player_Listbox_Button11_2 = CreateFrame("Button", "dgpButton11_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button11_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button11_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button11_2.texture = dgp_Player_Listbox_Button11_2:CreateTexture()
				dgp_Player_Listbox_Button11_2.texture:SetAllPoints(dgp_Player_Listbox_Button11_2)
				dgp_Player_Listbox_Button11_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button11_2.text = dgp_Player_Listbox_Button11_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button11_2.text:SetAllPoints()
				dgp_Player_Listbox_Button11_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(11) end)
				
			local dgp_Player_Listbox_Button12_1 = CreateFrame("Button", "dgpButton12_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button12_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button12_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button12_1.texture = dgp_Player_Listbox_Button12_1:CreateTexture()
				dgp_Player_Listbox_Button12_1.texture:SetAllPoints(dgp_Player_Listbox_Button12_1)
				dgp_Player_Listbox_Button12_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button12_1.text = dgp_Player_Listbox_Button12_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button12_1.text:SetAllPoints()
				dgp_Player_Listbox_Button12_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(12) end)
			local dgp_Player_Listbox_Button12_2 = CreateFrame("Button", "dgpButton12_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button12_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button12_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button12_2.texture = dgp_Player_Listbox_Button12_2:CreateTexture()
				dgp_Player_Listbox_Button12_2.texture:SetAllPoints(dgp_Player_Listbox_Button12_2)
				dgp_Player_Listbox_Button12_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button12_2.text = dgp_Player_Listbox_Button12_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button12_2.text:SetAllPoints()
				dgp_Player_Listbox_Button12_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(12) end)
				
			local dgp_Player_Listbox_Button13_1 = CreateFrame("Button", "dgpButton13_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button13_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button13_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button13_1.texture = dgp_Player_Listbox_Button13_1:CreateTexture()
				dgp_Player_Listbox_Button13_1.texture:SetAllPoints(dgp_Player_Listbox_Button13_1)
				dgp_Player_Listbox_Button13_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button13_1.text = dgp_Player_Listbox_Button13_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button13_1.text:SetAllPoints()
				dgp_Player_Listbox_Button13_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(13) end)
			local dgp_Player_Listbox_Button13_2 = CreateFrame("Button", "dgpButton13_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button13_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button13_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button13_2.texture = dgp_Player_Listbox_Button13_2:CreateTexture()
				dgp_Player_Listbox_Button13_2.texture:SetAllPoints(dgp_Player_Listbox_Button13_2)
				dgp_Player_Listbox_Button13_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button13_2.text = dgp_Player_Listbox_Button13_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button13_2.text:SetAllPoints()
				dgp_Player_Listbox_Button13_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(13) end)
				
			local dgp_Player_Listbox_Button14_1 = CreateFrame("Button", "dgpButton14_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button14_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button14_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button14_1.texture = dgp_Player_Listbox_Button14_1:CreateTexture()
				dgp_Player_Listbox_Button14_1.texture:SetAllPoints(dgp_Player_Listbox_Button14_1)
				dgp_Player_Listbox_Button14_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button14_1.text = dgp_Player_Listbox_Button14_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button14_1.text:SetAllPoints()
				dgp_Player_Listbox_Button14_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(14) end)
			local dgp_Player_Listbox_Button14_2 = CreateFrame("Button", "dgpButton14_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button14_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button14_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button14_2.texture = dgp_Player_Listbox_Button14_2:CreateTexture()
				dgp_Player_Listbox_Button14_2.texture:SetAllPoints(dgp_Player_Listbox_Button14_2)
				dgp_Player_Listbox_Button14_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button14_2.text = dgp_Player_Listbox_Button14_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button14_2.text:SetAllPoints()
				dgp_Player_Listbox_Button14_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(14) end)
				
			local dgp_Player_Listbox_Button15_1 = CreateFrame("Button", "dgpButton15_1", dgp_Player_Listbox)
				dgp_Player_Listbox_Button15_1:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button15_1:SetFrameLevel(14)
				dgp_Player_Listbox_Button15_1.texture = dgp_Player_Listbox_Button15_1:CreateTexture()
				dgp_Player_Listbox_Button15_1.texture:SetAllPoints(dgp_Player_Listbox_Button15_1)
				dgp_Player_Listbox_Button15_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button15_1.text = dgp_Player_Listbox_Button15_1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button15_1.text:SetAllPoints()
				dgp_Player_Listbox_Button15_1:SetScript("OnClick", function(self) dgpToggleSelectPlayer(15) end)
			local dgp_Player_Listbox_Button15_2 = CreateFrame("Button", "dgpButton15_2", dgp_Player_Listbox)
				dgp_Player_Listbox_Button15_2:SetFrameStrata("HIGH")
				dgp_Player_Listbox_Button15_2:SetFrameLevel(14)
				dgp_Player_Listbox_Button15_2.texture = dgp_Player_Listbox_Button15_2:CreateTexture()
				dgp_Player_Listbox_Button15_2.texture:SetAllPoints(dgp_Player_Listbox_Button15_2)
				dgp_Player_Listbox_Button15_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Player_Listbox_Button15_2.text = dgp_Player_Listbox_Button15_2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Player_Listbox_Button15_2.text:SetAllPoints()
				dgp_Player_Listbox_Button15_2:SetScript("OnClick", function(self) dgpToggleSelectPlayer(15) end)
						
			-- ** End Player Listbox Buttons
			
		-- ** End Player Listbox **
		
		-- ** Player Listbox Scrollbar
		local dgp_Player_Listbox_Slider = CreateFrame("Slider", "PlayerListboxSlider", dgp_Bottom_Frame, "OptionsSliderTemplate")
			
			-- Set the listbox scrollbar attributes
			dgp_Player_Listbox_Slider:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_Player_Listbox_Slider:SetFrameLevel(13) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			getglobal("PlayerListboxSliderLow"):SetText("") -- Remove the Low label
			getglobal("PlayerListboxSliderHigh"):SetText("") -- Remove the High label

			dgp_Player_Listbox_Slider:SetOrientation("VERTICAL") -- Change to a vertical orientation
			dgp_Player_Listbox_Slider:SetMinMaxValues(1, 1) -- Set default min/max value
			dgp_Player_Listbox_Slider:SetValue(1) -- Set the slider value to the top
			dgp_Player_Listbox_Slider:SetValueStep(1) -- Set the minimum step value
			
			dgp_Player_Listbox_Slider:SetScript("OnValueChanged", function(self)
					dgp_List_Position = math.floor(dgp_Player_Listbox_Slider:GetValue())
					dgpUpdateList()
				end)
				
		-- ** End Player Listbox Scrollbar **
		
		-- ** Button Frame
		local dgp_Button_Frame = CreateFrame("Frame", nil, dgp_Bottom_Frame)
		
			-- Set the button frame attributes
			dgp_Button_Frame:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_Button_Frame:SetFrameLevel(13) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			-- Set the texture of the  button frame
				dgp_Button_Frame:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Title-Frame-Background",
					edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
					tile = false, tileSize = 0, edgeSize = 16,
					insets = { left = 4, right = 4, top = 4, bottom = 4} })
			
			-- ** Button Frame Buttons
			-- Skipping the explainations for mass buttons
			local dgp_Side_Button1 = CreateFrame("Button", "sideButton1", dgp_Button_Frame)
				dgp_Side_Button1_Pushed = dgp_Side_Button1:CreateTexture()
				dgp_Side_Button1_Pushed:SetAllPoints(dgp_Side_Button1)				
				dgp_Side_Button1:SetFrameStrata("HIGH")
				dgp_Side_Button1:SetFrameLevel(14) 
				dgp_Side_Button1.texture = dgp_Side_Button1:CreateTexture()
				dgp_Side_Button1.texture:SetAllPoints(dgp_Side_Button1)
				dgp_Side_Button1:SetPushedTexture(dgp_Side_Button1_Pushed)
				dgp_Side_Button1.text = dgp_Side_Button1:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Side_Button1.text:SetAllPoints()
				
			local dgp_Side_Button2 = CreateFrame("Button", "sideButton2", dgp_Button_Frame)
				dgp_Side_Button2_Pushed = dgp_Side_Button2:CreateTexture()
				dgp_Side_Button2_Pushed:SetAllPoints(dgp_Side_Button2)
				dgp_Side_Button2:SetFrameStrata("HIGH")
				dgp_Side_Button2:SetFrameLevel(14) 
				dgp_Side_Button2.texture = dgp_Side_Button2:CreateTexture()
				dgp_Side_Button2.texture:SetAllPoints(dgp_Side_Button2)
				dgp_Side_Button2:SetPushedTexture(dgp_Side_Button2_Pushed)
				dgp_Side_Button2.text = dgp_Side_Button2:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Side_Button2.text:SetAllPoints()
				
			local dgp_Side_Button3 = CreateFrame("Button", "sideButton3", dgp_Button_Frame)
				dgp_Side_Button3_Pushed = dgp_Side_Button3:CreateTexture()
				dgp_Side_Button3_Pushed:SetAllPoints(dgp_Side_Button3)
				dgp_Side_Button3:SetFrameStrata("HIGH")
				dgp_Side_Button3:SetFrameLevel(14) 
				dgp_Side_Button3.texture = dgp_Side_Button3:CreateTexture()
				dgp_Side_Button3.texture:SetAllPoints(dgp_Side_Button3)
				dgp_Side_Button3:SetPushedTexture(dgp_Side_Button3_Pushed)
				dgp_Side_Button3.text = dgp_Side_Button3:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Side_Button3.text:SetAllPoints()
				
			local dgp_Side_Button4 = CreateFrame("Button", "sideButton4", dgp_Button_Frame)
				dgp_Side_Button4_Pushed = dgp_Side_Button4:CreateTexture()
				dgp_Side_Button4_Pushed:SetAllPoints(dgp_Side_Button4)
				dgp_Side_Button4:SetFrameStrata("HIGH")
				dgp_Side_Button4:SetFrameLevel(14) 
				dgp_Side_Button4.texture = dgp_Side_Button4:CreateTexture()
				dgp_Side_Button4.texture:SetAllPoints(dgp_Side_Button4)
				dgp_Side_Button4:SetPushedTexture(dgp_Side_Button4_Pushed)
				dgp_Side_Button4.text = dgp_Side_Button4:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Side_Button4.text:SetAllPoints()
			
			local dgp_Side_Button5 = CreateFrame("Button", "sideButton5", dgp_Button_Frame)
				dgp_Side_Button5_Pushed = dgp_Side_Button5:CreateTexture()
				dgp_Side_Button5_Pushed:SetAllPoints(dgp_Side_Button5)
				dgp_Side_Button5:SetFrameStrata("HIGH")
				dgp_Side_Button5:SetFrameLevel(14) 
				dgp_Side_Button5.texture = dgp_Side_Button5:CreateTexture()
				dgp_Side_Button5.texture:SetAllPoints(dgp_Side_Button5)
				dgp_Side_Button5:SetPushedTexture(dgp_Side_Button5_Pushed)
				dgp_Side_Button5.text = dgp_Side_Button5:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Side_Button5.text:SetAllPoints()
			
			local dgp_Side_Button6 = CreateFrame("Button", "sideButton6", dgp_Button_Frame)
				dgp_Side_Button6_Pushed = dgp_Side_Button6:CreateTexture()
				dgp_Side_Button6_Pushed:SetAllPoints(dgp_Side_Button6)
				dgp_Side_Button6:SetFrameStrata("HIGH")
				dgp_Side_Button6:SetFrameLevel(14) 
				dgp_Side_Button6.texture = dgp_Side_Button6:CreateTexture()
				dgp_Side_Button6.texture:SetAllPoints(dgp_Side_Button6)
				dgp_Side_Button6:SetPushedTexture(dgp_Side_Button6_Pushed)
				dgp_Side_Button6.text = dgp_Side_Button6:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Side_Button6.text:SetAllPoints()

			local dgp_Side_Button7 = CreateFrame("Button", "sideButton7", dgp_Button_Frame)
				dgp_Side_Button7_Pushed = dgp_Side_Button7:CreateTexture()
				dgp_Side_Button7_Pushed:SetAllPoints(dgp_Side_Button7)
				dgp_Side_Button7:SetFrameStrata("HIGH")
				dgp_Side_Button7:SetFrameLevel(14) 
				dgp_Side_Button7.texture = dgp_Side_Button7:CreateTexture()
				dgp_Side_Button7.texture:SetAllPoints(dgp_Side_Button7)
				dgp_Side_Button7:SetPushedTexture(dgp_Side_Button7_Pushed)
				dgp_Side_Button7.text = dgp_Side_Button7:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Side_Button7.text:SetAllPoints()
				
			local dgp_Side_Button8 = CreateFrame("Button", "sideButton8", dgp_Button_Frame)
				dgp_Side_Button8_Pushed = dgp_Side_Button8:CreateTexture()
				dgp_Side_Button8_Pushed:SetAllPoints(dgp_Side_Button8)
				dgp_Side_Button8:SetFrameStrata("HIGH")
				dgp_Side_Button8:SetFrameLevel(14) 
				dgp_Side_Button8.texture = dgp_Side_Button8:CreateTexture()
				dgp_Side_Button8.texture:SetAllPoints(dgp_Side_Button8)
				dgp_Side_Button8:SetPushedTexture(dgp_Side_Button8_Pushed)
				dgp_Side_Button8.text = dgp_Side_Button8:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Side_Button8.text:SetAllPoints()
			
			local dgp_Side_Button9 = CreateFrame("Button", "sideButton9", dgp_Button_Frame)
				dgp_Side_Button9_Pushed = dgp_Side_Button9:CreateTexture()
				dgp_Side_Button9_Pushed:SetAllPoints(dgp_Side_Button9)
				dgp_Side_Button9:SetFrameStrata("HIGH")
				dgp_Side_Button9:SetFrameLevel(14) 
				dgp_Side_Button9.texture = dgp_Side_Button9:CreateTexture()
				dgp_Side_Button9.texture:SetAllPoints(dgp_Side_Button9)
				dgp_Side_Button9:SetPushedTexture(dgp_Side_Button9_Pushed)
				dgp_Side_Button9.text = dgp_Side_Button9:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Side_Button9.text:SetAllPoints()
				
			local dgp_Side_Button10 = CreateFrame("Button", "sideButton10", dgp_Button_Frame)
				dgp_Side_Button10_Pushed = dgp_Side_Button10:CreateTexture()
				dgp_Side_Button10_Pushed:SetAllPoints(dgp_Side_Button10)
				dgp_Side_Button10:SetFrameStrata("HIGH")
				dgp_Side_Button10:SetFrameLevel(14) 
				dgp_Side_Button10.texture = dgp_Side_Button10:CreateTexture()
				dgp_Side_Button10.texture:SetAllPoints(dgp_Side_Button10)
				dgp_Side_Button10:SetPushedTexture(dgp_Side_Button10_Pushed)
				dgp_Side_Button10.text = dgp_Side_Button10:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Side_Button10.text:SetAllPoints()
				
			local dgp_Button_Standard_Title = CreateFrame("Button", "standardTitleButton", dgp_Button_Frame)
				dgp_Button_Standard_Title:SetFrameStrata("HIGH")
				dgp_Button_Standard_Title:SetFrameLevel(14) 
				dgp_Button_Standard_Title.text = dgp_Button_Standard_Title:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Button_Standard_Title.text:SetAllPoints()
				dgp_Button_Standard_Title.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
				dgp_Button_Standard_Title.text:SetText("Standard")
				
			-- ** Confirm Backup **
			local dgp_Confirm_Backup = CreateFrame("Frame", nil, dgp_Frame)
				-- Set the frame attributes
				dgp_Confirm_Backup:SetFrameStrata("HIGH") -- Set the frame above most of the UI
				dgp_Confirm_Backup:SetFrameLevel(41) -- Set the display layer
					-- Size and position are calculated by dgp_Resize_Frames() after the addon loads

				-- Set the texture of the parent frame	
				dgp_Confirm_Backup:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Title-Frame-Background",
					edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
					tile = false, tileSize = 0, edgeSize = 16,
					insets = { left = 4, right = 4, top = 4, bottom = 4} })
					
				dgp_Confirm_Backup:Hide()
			
				-- ** Confirm Backup Title **
				local dgp_Confirm_Backup_Title = CreateFrame("Frame", nil, dgp_Confirm_Backup)
					dgp_Confirm_Backup_Title:SetFrameStrata("HIGH")
					dgp_Confirm_Backup_Title:SetFrameLevel(42)
					dgp_Confirm_Backup_Title.text = dgp_Confirm_Backup_Title:CreateFontString(nil, "MEDIUM", "GameFontNormal")
					dgp_Confirm_Backup_Title.text:SetAllPoints()
					dgp_Confirm_Backup_Title.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
					dgp_Confirm_Backup_Title.text:SetText("Backup will overwrite non-compliant public notes!\n\nContinue backup?")
			
				-- ** End Confirm Backup Title **
			
				-- ** Confirm Backup Accept **
				local dgp_Confirm_Backup_Accept = CreateFrame("Button", nil, dgp_Confirm_Backup)
					dgp_Confirm_Backup_Accept:SetFrameStrata("HIGH") -- Set the frame above most of the UI
					dgp_Confirm_Backup_Accept:SetFrameLevel(42) -- Set the display layer
						-- Size and position are calculated by dgp_Resize_Frame()
				
					-- Create and define the button texture
					dgp_Confirm_Backup_Accept.texture = dgp_Confirm_Backup_Accept:CreateTexture()
					dgp_Confirm_Backup_Accept.texture:SetAllPoints(dgp_Confirm_Backup_Accept)
					dgp_Confirm_Backup_Accept.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
					-- Create and define the pushed texture
					dgp_Confirm_Backup_Accept_Pushed = dgp_Confirm_Backup_Accept:CreateTexture()
					dgp_Confirm_Backup_Accept_Pushed:SetAllPoints(dgp_Confirm_Backup_Accept)
					dgp_Confirm_Backup_Accept_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
					dgp_Confirm_Backup_Accept:SetPushedTexture(dgp_Confirm_Backup_Accept_Pushed)
			
					-- Define the text
					dgp_Confirm_Backup_Accept.text = dgp_Confirm_Backup_Accept:CreateFontString(nil, "MEDIUM", "GameFontNormal")
					dgp_Confirm_Backup_Accept.text:SetAllPoints()
					dgp_Confirm_Backup_Accept.text:SetText("Accept")
			
					-- Set the click action to invoke a comparrison to previous backups
					dgp_Confirm_Backup_Accept:SetScript("OnClick", function(self)
						dgpResetMultipliers()
						dgpBackup()
						dgpFadeIn()
						dgp_Confirm_Backup:Hide()
						end)
					
				-- ** End Confirm Backup Accept **
			
				-- ** Confirm Backup Decline **
				local dgp_Confirm_Backup_Cancel = CreateFrame("Button", nil, dgp_Confirm_Backup)
					dgp_Confirm_Backup_Cancel:SetFrameStrata("HIGH") -- Set the frame above most of the UI
					dgp_Confirm_Backup_Cancel:SetFrameLevel(42) -- Set the display layer
						-- Size and position are calculated by dgp_Resize_Frame()
				
					-- Create and define the button texture
					dgp_Confirm_Backup_Cancel.texture = dgp_Confirm_Backup_Cancel:CreateTexture()
					dgp_Confirm_Backup_Cancel.texture:SetAllPoints(dgp_Confirm_Backup_Cancel)
					dgp_Confirm_Backup_Cancel.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
					-- Create and define the pushed texture
					dgp_Confirm_Backup_Cancel_Pushed = dgp_Confirm_Backup_Cancel:CreateTexture()
					dgp_Confirm_Backup_Cancel_Pushed:SetAllPoints(dgp_Confirm_Backup_Cancel)
					dgp_Confirm_Backup_Cancel_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
					dgp_Confirm_Backup_Cancel:SetPushedTexture(dgp_Confirm_Backup_Cancel_Pushed)
			
					-- Define the text
					dgp_Confirm_Backup_Cancel.text = dgp_Confirm_Backup_Cancel:CreateFontString(nil, "MEDIUM", "GameFontNormal")
					dgp_Confirm_Backup_Cancel.text:SetAllPoints()
					dgp_Confirm_Backup_Cancel.text:SetText("Cancel")
			
					-- Set the click action to invoke a comparison to previous backups
					dgp_Confirm_Backup_Cancel:SetScript("OnClick", function(self)
						dgpFadeIn()
						dgp_Confirm_Backup:Hide()
						end)
			
				-- ** End Confirm Backup Decline **
			
			-- ** End Confirm Backup **
			
			local dgp_Button_Backup = CreateFrame("Button", "backupButton", dgp_Button_Frame)
			
				backup_Pushed_Texture = dgp_Button_Backup:CreateTexture()
				backup_Pushed_Texture:SetAllPoints(dgp_Button_Backup)
				backup_Pushed_Texture:SetTexture(0.1, 0.2, 1.0, 0.25)
				
				dgp_Button_Backup:SetFrameStrata("HIGH")
				dgp_Button_Backup:SetFrameLevel(14) 
				dgp_Button_Backup.texture = dgp_Button_Backup:CreateTexture()
				dgp_Button_Backup.texture:SetAllPoints(dgp_Button_Backup)
				dgp_Button_Backup.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Button_Backup:SetPushedTexture(backup_Pushed_Texture)
				dgp_Button_Backup.text = dgp_Button_Backup:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Button_Backup.text:SetAllPoints()
				dgp_Button_Backup.text:SetText("Backup")
				dgp_Button_Backup:SetScript("OnClick", function(self)
						dgpFadeOut()
						dgp_Confirm_Backup:Show()
					end)
		
			local dgp_Editbox_GP = CreateFrame("EditBox", nil, dgp_Button_Frame)
				dgp_Editbox_GP:SetFontObject("GameFontHighlight")
				dgp_Editbox_GP:SetAutoFocus(false)
				dgp_Editbox_GP:SetFrameStrata("HIGH")
				dgp_Editbox_GP:SetFrameLevel(14) 
				dgp_Editbox_GP:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Title-Frame-Background",
					edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
					tile = false, tileSize = 0, edgeSize = 16,
					insets = { left = 4, right = 4, top = 4, bottom = 4} })
				dgp_Editbox_GP:SetMaxLetters(10)
				dgp_Editbox_GP:SetTextInsets( 5, 5, 2, 2)
				dgp_Editbox_GP:SetScript("OnEnterPressed", function(self) dgpClearGPFocus() end)
				dgp_Editbox_GP:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						if tonumber(dgp_Editbox_GP:GetText()) == nil then
							if dgp_Editbox_GP:GetText() == "" then
								dgp_Points_Text = dgp_Editbox_GP:GetText()
							else
								dgp_Editbox_GP:SetText(dgp_Points_Text)
							end
						else
							dgp_Points_Text = dgp_Editbox_GP:GetText()
						end
					end)
				
			local dgp_Button_Add = CreateFrame("Button", "addButton", dgp_Button_Frame)
			
				add_Pushed_Texture = dgp_Button_Add:CreateTexture()
				add_Pushed_Texture:SetAllPoints(dgp_Button_Add)
				add_Pushed_Texture:SetTexture(0.1, 0.2, 1.0, 0.25)
				
				dgp_Button_Add:SetFrameStrata("HIGH")
				dgp_Button_Add:SetFrameLevel(14) 
				dgp_Button_Add.texture = dgp_Button_Add:CreateTexture()
				dgp_Button_Add.texture:SetAllPoints(dgp_Button_Add)
				dgp_Button_Add.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Button_Add:SetPushedTexture(add_Pushed_Texture)
				dgp_Button_Add.text = dgp_Button_Add:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Button_Add.text:SetAllPoints()
				dgp_Button_Add.text:SetText("Add")
				dgp_Button_Add:SetScript("OnClick", function(self)
						dgpResetMultipliers()
						dgpAddPoints( floor( tonumber(dgp_Editbox_GP:GetText()) ) )
					end)
				
			local dgp_Button_Subtract = CreateFrame("Button", "subtractButton", dgp_Button_Frame)
			
				subtract_Pushed_Texture = dgp_Button_Subtract:CreateTexture()
				subtract_Pushed_Texture:SetAllPoints(dgp_Button_Subtract)
				subtract_Pushed_Texture:SetTexture(0.1, 0.2, 1.0, 0.25)
				
				dgp_Button_Subtract:SetFrameStrata("HIGH")
				dgp_Button_Subtract:SetFrameLevel(14) 
				dgp_Button_Subtract.texture = dgp_Button_Subtract:CreateTexture()
				dgp_Button_Subtract.texture:SetAllPoints(dgp_Button_Subtract)
				dgp_Button_Subtract.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
				dgp_Button_Subtract:SetPushedTexture(subtract_Pushed_Texture)
				dgp_Button_Subtract.text = dgp_Button_Subtract:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_Button_Subtract.text:SetAllPoints()
				dgp_Button_Subtract.text:SetText("Subtract")
				dgp_Button_Subtract:SetScript("OnClick", function(self)
						dgpResetMultipliers()
						dgpSubtractPoints( floor( tonumber(dgp_Editbox_GP:GetText()) ) )
					end)
				
			-- ** End Button Frame Buttons **
			
		-- ** End Button Frame **
		
	-- ** End Bottom frame **
	
	-- Add an extra frame for the Guild Leader to adjust values
	-- ** Side Frame **
	local dgp_Side_Frame = CreateFrame("Frame", nil, dgp_Frame) -- Create the Side frame and attach it to the main frame
		
		dgp_Side_Frame:RegisterEvent("CHAT_MSG_ADDON") -- Triggered when a addon chat message is received
	
		-- Set the frame attributes
		dgp_Side_Frame:SetFrameStrata("HIGH") -- Set the frame above most of the UI
		dgp_Side_Frame:SetFrameLevel(11) -- Set the display layer
			-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
	
		-- Set the texture of the filter frame
		dgp_Side_Frame:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Title-Frame-Background",
			edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
			tile = false, tileSize = 0, edgeSize = 16,
			insets = { left = 4, right = 4, top = 4, bottom = 4} })
			
		dgp_Side_Frame:Hide()
		
		-- ** Side Frame Fade out frame **
		local dgp_SideMenu_Fade_Frame = CreateFrame("Button", nil, dgp_Side_Frame) -- Create a frame for fading the side menu
	
			-- Set the frame attributes
			dgp_SideMenu_Fade_Frame:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Fade_Frame:SetFrameLevel(1) -- Hide the frame behind the rest of the addon by default
				-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
		
			-- Set the frame texture
			dgp_SideMenu_Fade_Frame.texture = dgp_SideMenu_Fade_Frame:CreateTexture()
			dgp_SideMenu_Fade_Frame.texture:SetAllPoints(dgp_SideMenu_Fade_Frame)
			dgp_SideMenu_Fade_Frame.texture:SetTexture(0.0, 0.0, 0.0, 0.8)
		
		-- ** End Side Frame Fade Frame**
	
		-- ** Side Frame Title Frame **
		local dgp_SideMenu_Title_Frame = CreateFrame("Button", nil, dgp_Side_Frame) -- Create a title frame and attach it to the side frame
	
			-- Set the frame attributes
			dgp_SideMenu_Title_Frame:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Title_Frame:SetFrameLevel(12) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
		
			-- Add a title to the frame
			dgp_SideMenu_Title_Frame.text = dgp_SideMenu_Title_Frame:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Title_Frame.text:SetAllPoints()
			dgp_SideMenu_Title_Frame.text:SetText("Guild Master Configuration")
		
			-- Set the texture of the filter frame
			dgp_SideMenu_Title_Frame:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Title-Frame-Background",
				edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
				tile = false, tileSize = 0, edgeSize = 16,
				insets = { left = 4, right = 4, top = 4, bottom = 4} })
		
			-- Register the frame for mouse clicks and define the action
			dgp_SideMenu_Title_Frame:RegisterForClicks("LeftButtonDown", "LeftButtonUp") -- Left button up and down are considered clicks
			dgp_SideMenu_Title_Frame:SetScript("OnClick", function(self)  dgp_Toggle_Move() end) -- Toggle UI movement when the frame is clicked
	
		-- ** End Side Frame Title Frame **
		
		-- ** Side Frame Minimize button **
		local dgp_SideMenu_Minimize_Button = CreateFrame("Button", nil, dgp_Side_Frame) -- Create the minimize Button frame
		
			-- Set the button attributes
			dgp_SideMenu_Minimize_Button:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Minimize_Button:SetFrameLevel(12) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
			
			-- Set the texture of the close button
			-- Border
			dgp_SideMenu_Minimize_Button:SetBackdrop({ bgFile = nil,
				edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
				tile = false, tileSize = 0, edgeSize = 16,
				insets = { left = 0, right = 0, top = 0, bottom = 0} })
			dgp_SideMenu_Minimize_Button:SetNormalTexture("Interface\\Addons\\GuildPoints\\Images\\Hide-Button-Background")
			dgp_SideMenu_Minimize_Button:SetPushedTexture("Interface\\Addons\\GuildPoints\\Images\\Hide-Button-Pressed")
			dgp_SideMenu_Minimize_Button:SetHighlightTexture("Interface\\Addons\\GuildPoints\\Images\\Hide-Button-Highlight")
	
			-- Register the action for clicks
			dgp_SideMenu_Minimize_Button:SetScript("OnClick", function(self) dgpHideSideMenu() end)
	
		-- ** End Side Frame Minimize button **
		
		-- ** Side Frame Honorary Title **
		local dgp_SideMenu_Honorary_Title = CreateFrame("Button", "sideMenuHonoraryTitle", dgp_Side_Frame)
			dgp_SideMenu_Honorary_Title:SetFrameStrata("HIGH")
			dgp_SideMenu_Honorary_Title:SetFrameLevel(12) 
			dgp_SideMenu_Honorary_Title.text = dgp_SideMenu_Honorary_Title:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Honorary_Title.text:SetAllPoints()
			dgp_SideMenu_Honorary_Title.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
			dgp_SideMenu_Honorary_Title.text:SetText("Honorary Members")
		
		-- ** End Side Frame Honorary Title **
			
		-- ** Side Frame Honorary Label **
		local dgp_Side_Frame_Honorary_Label = CreateFrame("Button", "sideMenuHonoraryLabel", dgp_Side_Frame)
			dgp_Side_Frame_Honorary_Label:SetFrameStrata("HIGH")
			dgp_Side_Frame_Honorary_Label:SetFrameLevel(12) 
			dgp_Side_Frame_Honorary_Label.text = dgp_Side_Frame_Honorary_Label:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_Side_Frame_Honorary_Label.text:SetAllPoints()
			dgp_Side_Frame_Honorary_Label.text:SetText("Name (Blank=Selected)")
			
		-- ** End Side Frame Honorary Label **
		
		-- ** Side Frame Honorary Editbox **
		local dgp_Side_Frame_Honorary_Editbox = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Honorary_Editbox:SetFontObject("GameFontHighlight")
			dgp_Side_Frame_Honorary_Editbox:SetAutoFocus(false)
			dgp_Side_Frame_Honorary_Editbox:SetFrameStrata("HIGH")
			dgp_Side_Frame_Honorary_Editbox:SetFrameLevel(12) 
			dgp_Side_Frame_Honorary_Editbox.texture = dgp_Side_Frame_Honorary_Editbox:CreateTexture()
			dgp_Side_Frame_Honorary_Editbox.texture:SetAllPoints(dgp_Side_Frame_Honorary_Editbox)
			dgp_Side_Frame_Honorary_Editbox.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Honorary_Editbox:SetMaxLetters(20)
			dgp_Side_Frame_Honorary_Editbox:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Honorary_Editbox:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Honorary_Editbox:ClearFocus() end)
			dgp_Side_Frame_Honorary_Editbox:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						local dgpName = dgp_Side_Frame_Honorary_Editbox:GetText()
						dgp_Side_Frame_Honorary_Editbox:SetText(dgpName:sub(1,1):upper()..dgpName:sub(2):lower())
					end)
		-- ** End Side Frame Honorary Editbox **
		
		-- ** Side Frame Add Honorary Button ** --
		local dgp_SideMenu_Add_Honorary_Button = CreateFrame("Button", "sideAddHonoraryButton", dgp_Side_Frame)
			dgp_SideMenu_Add_Honorary_Button:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Add_Honorary_Button:SetFrameLevel(12) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			-- Create and define the button texture
			dgp_SideMenu_Add_Honorary_Button.texture = dgp_SideMenu_Add_Honorary_Button:CreateTexture()
			dgp_SideMenu_Add_Honorary_Button.texture:SetAllPoints(dgp_SideMenu_Add_Honorary_Button)
			dgp_SideMenu_Add_Honorary_Button.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
			-- Create and define the pushed texture
			dgp_SideMenu_Add_Honorary_Button_Pushed = dgp_SideMenu_Add_Honorary_Button:CreateTexture()
			dgp_SideMenu_Add_Honorary_Button_Pushed:SetAllPoints(dgp_SideMenu_Add_Honorary_Button)
			dgp_SideMenu_Add_Honorary_Button_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_SideMenu_Add_Honorary_Button:SetPushedTexture(dgp_SideMenu_Add_Honorary_Button_Pushed)
			
			-- Define the text
			dgp_SideMenu_Add_Honorary_Button.text = dgp_SideMenu_Add_Honorary_Button:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Add_Honorary_Button.text:SetAllPoints()
			dgp_SideMenu_Add_Honorary_Button.text:SetText("Add Member")
			
			-- Set the click action to apply the changes
			dgp_SideMenu_Add_Honorary_Button:SetScript("OnClick", function(self)
					-- Check if a name is in the editbox
					if dgp_Side_Frame_Honorary_Editbox:GetText() == "" then
						-- If not then check if there is a target
						if UnitName("target") then
							-- Check that the unit is also a player
							if UnitIsPlayer("target") == 1 then
								-- Check that the unit is on the same realm
								if UnitIsSameServer("target", "player") == 1 then
									-- Check the player is the same faction
									if UnitFactionGroup("player") == UnitFactionGroup("target") then
										-- Lastly check that the player isn't already in the guild
										if not UnitIsInMyGuild("target") then
											dgpAddHonoraryMember(UnitName("target")) -- Add the target as an honorary member								
										end -- end if
									end -- end if
								end -- end if
							end -- end if
						end -- end if
					else -- If a name was specified then...
						dgpAddHonoraryMember(dgp_Side_Frame_Honorary_Editbox:GetText()) -- Add the specified player as an honorary member
					end -- end if
					dgp_Side_Frame_Honorary_Editbox:SetText("") -- Clear the box
					dgp_Side_Frame_Honorary_Editbox:ClearFocus() -- Clear the editbox focus
				end)
			
		-- ** End Side Frame Add Honorary Button ** --
		
		-- ** Side Frame Remove Honorary Button ** --
		local dgp_SideMenu_Remove_Honorary_Button = CreateFrame("Button", "sideRemoveHonoraryButton", dgp_Side_Frame)
			dgp_SideMenu_Remove_Honorary_Button:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Remove_Honorary_Button:SetFrameLevel(12) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			-- Create and define the button texture
			dgp_SideMenu_Remove_Honorary_Button.texture = dgp_SideMenu_Remove_Honorary_Button:CreateTexture()
			dgp_SideMenu_Remove_Honorary_Button.texture:SetAllPoints(dgp_SideMenu_Remove_Honorary_Button)
			dgp_SideMenu_Remove_Honorary_Button.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
			-- Create and define the pushed texture
			dgp_SideMenu_Remove_Honorary_Button_Pushed = dgp_SideMenu_Remove_Honorary_Button:CreateTexture()
			dgp_SideMenu_Remove_Honorary_Button_Pushed:SetAllPoints(dgp_SideMenu_Remove_Honorary_Button)
			dgp_SideMenu_Remove_Honorary_Button_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_SideMenu_Remove_Honorary_Button:SetPushedTexture(dgp_SideMenu_Remove_Honorary_Button_Pushed)
			
			-- Define the text
			dgp_SideMenu_Remove_Honorary_Button.text = dgp_SideMenu_Remove_Honorary_Button:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Remove_Honorary_Button.text:SetAllPoints()
			dgp_SideMenu_Remove_Honorary_Button.text:SetText("Remove Member(s)")
			
			-- Set the click action to apply the changes
			dgp_SideMenu_Remove_Honorary_Button:SetScript("OnClick", function(self)
					dgpConfirmRemoveHonorary()
					dgp_Side_Frame_Honorary_Editbox:ClearFocus() -- Clear the editbox focus
				end)
			
		-- ** End Side Frame Remove Honorary Button ** --
		
		-- ** Side Frame Confirm Remove Honorary **
		local dgp_SideMenu_Confirm_Remove_Honorary = CreateFrame("Frame", nil, dgp_Side_Frame)
			-- Set the frame attributes
			dgp_SideMenu_Confirm_Remove_Honorary:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Confirm_Remove_Honorary:SetFrameLevel(31) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frames() after the addon loads

			-- Set the texture of the parent frame	
			dgp_SideMenu_Confirm_Remove_Honorary:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Title-Frame-Background",
			edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
				tile = false, tileSize = 0, edgeSize = 16,
				insets = { left = 4, right = 4, top = 4, bottom = 4} })
			
			dgp_SideMenu_Confirm_Remove_Honorary:Hide()
			
			-- ** Side Frame Confirm Remove Honorary Title **
			local dgp_SideMenu_Confirm_Remove_Honorary_Title = CreateFrame("Frame", nil, dgp_SideMenu_Confirm_Remove_Honorary)
				dgp_SideMenu_Confirm_Remove_Honorary_Title:SetFrameStrata("HIGH")
				dgp_SideMenu_Confirm_Remove_Honorary_Title:SetFrameLevel(32)
				dgp_SideMenu_Confirm_Remove_Honorary_Title.text = dgp_SideMenu_Confirm_Remove_Honorary_Title:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_SideMenu_Confirm_Remove_Honorary_Title.text:SetAllPoints()
				dgp_SideMenu_Confirm_Remove_Honorary_Title.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
				dgp_SideMenu_Confirm_Remove_Honorary_Title.text:SetText("Remove Honorary Members?")
			
			-- ** EndSide Frame Confirm Remove Honorary Title **
			
			-- ** Side Frame Confirm Remove Honorary Accept **
			local dgp_SideMenu_Confirm_Remove_Honorary_Accept = CreateFrame("Button", nil, dgp_SideMenu_Confirm_Remove_Honorary)
				dgp_SideMenu_Confirm_Remove_Honorary_Accept:SetFrameStrata("HIGH") -- Set the frame above most of the UI
				dgp_SideMenu_Confirm_Remove_Honorary_Accept:SetFrameLevel(32) -- Set the display layer
					-- Size and position are calculated by dgp_Resize_Frame()
				
				-- Create and define the button texture
				dgp_SideMenu_Confirm_Remove_Honorary_Accept.texture = dgp_SideMenu_Confirm_Remove_Honorary_Accept:CreateTexture()
				dgp_SideMenu_Confirm_Remove_Honorary_Accept.texture:SetAllPoints(dgp_SideMenu_Confirm_Remove_Honorary_Accept)
				dgp_SideMenu_Confirm_Remove_Honorary_Accept.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
				-- Create and define the pushed texture
				dgp_SideMenu_Confirm_Remove_Honorary_Accept_Pushed = dgp_SideMenu_Confirm_Remove_Honorary_Accept:CreateTexture()
				dgp_SideMenu_Confirm_Remove_Honorary_Accept_Pushed:SetAllPoints(dgp_SideMenu_Confirm_Remove_Honorary_Accept)
				dgp_SideMenu_Confirm_Remove_Honorary_Accept_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
				dgp_SideMenu_Confirm_Remove_Honorary_Accept:SetPushedTexture(dgp_SideMenu_Confirm_Remove_Honorary_Accept_Pushed)
			
				-- Define the text
				dgp_SideMenu_Confirm_Remove_Honorary_Accept.text = dgp_SideMenu_Confirm_Remove_Honorary_Accept:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_SideMenu_Confirm_Remove_Honorary_Accept.text:SetAllPoints()
				dgp_SideMenu_Confirm_Remove_Honorary_Accept.text:SetText("Accept")
			
				-- Set the click action to invoke a comparrison to previous backups
				dgp_SideMenu_Confirm_Remove_Honorary_Accept:SetScript("OnClick", function(self)
						-- If if the removal type is dgpselected
						if dgpHonoraryRemoveType == "dgpselected" then
							foreach(dgp_Selected_Guild_Members, function(name, marker)
								if DGPHonoraryGuildMembers[name] then -- If the player is an honorary members
									dgpRemoveHonoraryMember(name)	
								end -- end if
							end)
						else
							dgpRemoveHonoraryMember(dgpHonoraryRemoveType)	
						end -- end if
						
						dgpSideMenuFadeIn()
						dgp_SideMenu_Confirm_Remove_Honorary:Hide()
						dgp_Side_Frame_Honorary_Editbox:SetText("") -- Clear the box
					end)
					
			-- ** End Side Frame Confirm Remove Honorary Accept **
			
			-- ** Side Frame Confirm Restore Decline **
			local dgp_SideMenu_Confirm_Remove_Honorary_Cancel = CreateFrame("Button", nil, dgp_SideMenu_Confirm_Remove_Honorary)
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel:SetFrameStrata("HIGH") -- Set the frame above most of the UI
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel:SetFrameLevel(32) -- Set the display layer
					-- Size and position are calculated by dgp_Resize_Frame()
				
				-- Create and define the button texture
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel.texture = dgp_SideMenu_Confirm_Remove_Honorary_Cancel:CreateTexture()
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel.texture:SetAllPoints(dgp_SideMenu_Confirm_Remove_Honorary_Cancel)
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
				-- Create and define the pushed texture
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel_Pushed = dgp_SideMenu_Confirm_Remove_Honorary_Cancel:CreateTexture()
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel_Pushed:SetAllPoints(dgp_SideMenu_Confirm_Remove_Honorary_Cancel)
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel:SetPushedTexture(dgp_SideMenu_Confirm_Remove_Honorary_Cancel_Pushed)
			
				-- Define the text
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel.text = dgp_SideMenu_Confirm_Remove_Honorary_Cancel:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel.text:SetAllPoints()
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel.text:SetText("Cancel")
			
				-- Set the click action to invoke a comparrison to previous backups
				dgp_SideMenu_Confirm_Remove_Honorary_Cancel:SetScript("OnClick", function(self)
					dgpSideMenuFadeIn()
					dgp_SideMenu_Confirm_Remove_Honorary:Hide()
					end)
			
			-- ** End Side Frame Confirm Restore Decline **
			
		-- ** End Side Frame Confirm Remove Honorary **
		
		-- ** Side Frame Seperater **
		local dgp_SideMenu_Buttons_Seperater = CreateFrame("Frame", nil, dgp_Side_Frame)
			
			-- Set the frame attributes
			dgp_SideMenu_Buttons_Seperater:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Buttons_Seperater:SetFrameLevel(12) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
			
			-- Create and define the button texture
			dgp_SideMenu_Buttons_Seperater.texture = dgp_SideMenu_Buttons_Seperater:CreateTexture()
			dgp_SideMenu_Buttons_Seperater.texture:SetAllPoints(dgp_SideMenu_Buttons_Seperater)
			dgp_SideMenu_Buttons_Seperater.texture:SetTexture(1.0, 1.0, 1.0, 0.3)	
			
		-- ** End Side Frame Backup Drop Box Label **
		
		-- ** Side Frame Column Headings **
		local dgp_SideMenu_Type_Title = CreateFrame("Button", "sideMenuTypeTitle", dgp_Side_Frame)
			dgp_SideMenu_Type_Title:SetFrameStrata("HIGH")
			dgp_SideMenu_Type_Title:SetFrameLevel(12) 
			dgp_SideMenu_Type_Title.text = dgp_SideMenu_Type_Title:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Type_Title.text:SetAllPoints()
			dgp_SideMenu_Type_Title.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
			dgp_SideMenu_Type_Title.text:SetText("Type")
			
		local dgp_SideMenu_Name_Title = CreateFrame("Button", "sideMenuNameTitle", dgp_Side_Frame)
			dgp_SideMenu_Name_Title:SetFrameStrata("HIGH")
			dgp_SideMenu_Name_Title:SetFrameLevel(12) 
			dgp_SideMenu_Name_Title.text = dgp_SideMenu_Name_Title:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Name_Title.text:SetAllPoints()
			dgp_SideMenu_Name_Title.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
			dgp_SideMenu_Name_Title.text:SetText("Name")
			
		local dgp_SideMenu_Value_Title = CreateFrame("Button", "sideMenuValueTitle", dgp_Side_Frame)
			dgp_SideMenu_Value_Title:SetFrameStrata("HIGH")
			dgp_SideMenu_Value_Title:SetFrameLevel(12) 
			dgp_SideMenu_Value_Title.text = dgp_SideMenu_Value_Title:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Value_Title.text:SetAllPoints()
			dgp_SideMenu_Value_Title.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
			dgp_SideMenu_Value_Title.text:SetText("Value")
		
		-- ** End Side Frame Column Headings **
		
		-- ** Side Frame Dropboxes **
		local dgp_SideMenu_Dropbox1 = CreateFrame("Frame", "SideMenu_Dropbox1", dgp_Side_Frame, "UIDropDownMenuTemplate")
			dgp_SideMenu_Dropbox1:SetFrameStrata("HIGH")
			dgp_SideMenu_Dropbox1:SetFrameLevel(12)
			UIDropDownMenu_Initialize(dgp_SideMenu_Dropbox1, dgpSideMenuDropbox1Init)
			UIDropDownMenu_SetSelectedID(dgp_SideMenu_Dropbox1, 1)
			UIDropDownMenu_JustifyText(dgp_SideMenu_Dropbox1, "LEFT")
		local dgp_SideMenu_Dropbox2 = CreateFrame("Frame", "SideMenu_Dropbox2", dgp_Side_Frame, "UIDropDownMenuTemplate")
			dgp_SideMenu_Dropbox2:SetFrameStrata("HIGH")
			dgp_SideMenu_Dropbox2:SetFrameLevel(12)
			UIDropDownMenu_Initialize(dgp_SideMenu_Dropbox2, dgpSideMenuDropbox2Init)
			UIDropDownMenu_SetSelectedID(dgp_SideMenu_Dropbox2, 1)
			UIDropDownMenu_JustifyText(dgp_SideMenu_Dropbox2, "LEFT")
		local dgp_SideMenu_Dropbox3 = CreateFrame("Frame", "SideMenu_Dropbox3", dgp_Side_Frame, "UIDropDownMenuTemplate")
			dgp_SideMenu_Dropbox3:SetFrameStrata("HIGH")
			dgp_SideMenu_Dropbox3:SetFrameLevel(12)
			UIDropDownMenu_Initialize(dgp_SideMenu_Dropbox3, dgpSideMenuDropbox3Init)
			UIDropDownMenu_SetSelectedID(dgp_SideMenu_Dropbox3, 1)
			UIDropDownMenu_JustifyText(dgp_SideMenu_Dropbox3, "LEFT")
		local dgp_SideMenu_Dropbox4 = CreateFrame("Frame", "SideMenu_Dropbox4", dgp_Side_Frame, "UIDropDownMenuTemplate")
			dgp_SideMenu_Dropbox4:SetFrameStrata("HIGH")
			dgp_SideMenu_Dropbox4:SetFrameLevel(12)
			UIDropDownMenu_Initialize(dgp_SideMenu_Dropbox4, dgpSideMenuDropbox4Init)
			UIDropDownMenu_SetSelectedID(dgp_SideMenu_Dropbox4, 1)
			UIDropDownMenu_JustifyText(dgp_SideMenu_Dropbox4, "LEFT")
		local dgp_SideMenu_Dropbox5 = CreateFrame("Frame", "SideMenu_Dropbox5", dgp_Side_Frame, "UIDropDownMenuTemplate")
			dgp_SideMenu_Dropbox5:SetFrameStrata("HIGH")
			dgp_SideMenu_Dropbox5:SetFrameLevel(12)
			UIDropDownMenu_Initialize(dgp_SideMenu_Dropbox5, dgpSideMenuDropbox5Init)
			UIDropDownMenu_SetSelectedID(dgp_SideMenu_Dropbox5, 1)
			UIDropDownMenu_JustifyText(dgp_SideMenu_Dropbox5, "LEFT")
		local dgp_SideMenu_Dropbox6 = CreateFrame("Frame", "SideMenu_Dropbox6", dgp_Side_Frame, "UIDropDownMenuTemplate")
			dgp_SideMenu_Dropbox6:SetFrameStrata("HIGH")
			dgp_SideMenu_Dropbox6:SetFrameLevel(12)
			UIDropDownMenu_Initialize(dgp_SideMenu_Dropbox6, dgpSideMenuDropbox6Init)
			UIDropDownMenu_SetSelectedID(dgp_SideMenu_Dropbox6, 1)
			UIDropDownMenu_JustifyText(dgp_SideMenu_Dropbox6, "LEFT")
		local dgp_SideMenu_Dropbox7 = CreateFrame("Frame", "SideMenu_Dropbox7", dgp_Side_Frame, "UIDropDownMenuTemplate")
			dgp_SideMenu_Dropbox7:SetFrameStrata("HIGH")
			dgp_SideMenu_Dropbox7:SetFrameLevel(12)
			UIDropDownMenu_Initialize(dgp_SideMenu_Dropbox7, dgpSideMenuDropbox7Init)
			UIDropDownMenu_SetSelectedID(dgp_SideMenu_Dropbox7, 1)
			UIDropDownMenu_JustifyText(dgp_SideMenu_Dropbox7, "LEFT")
		local dgp_SideMenu_Dropbox8 = CreateFrame("Frame", "SideMenu_Dropbox8", dgp_Side_Frame, "UIDropDownMenuTemplate")
			dgp_SideMenu_Dropbox8:SetFrameStrata("HIGH")
			dgp_SideMenu_Dropbox8:SetFrameLevel(12)
			UIDropDownMenu_Initialize(dgp_SideMenu_Dropbox8, dgpSideMenuDropbox8Init)
			UIDropDownMenu_SetSelectedID(dgp_SideMenu_Dropbox8, 1)
			UIDropDownMenu_JustifyText(dgp_SideMenu_Dropbox8, "LEFT")
		local dgp_SideMenu_Dropbox9 = CreateFrame("Frame", "SideMenu_Dropbox9", dgp_Side_Frame, "UIDropDownMenuTemplate")
			dgp_SideMenu_Dropbox9:SetFrameStrata("HIGH")
			dgp_SideMenu_Dropbox9:SetFrameLevel(12)
			UIDropDownMenu_Initialize(dgp_SideMenu_Dropbox9, dgpSideMenuDropbox9Init)
			UIDropDownMenu_SetSelectedID(dgp_SideMenu_Dropbox9, 1)
			UIDropDownMenu_JustifyText(dgp_SideMenu_Dropbox9, "LEFT")
		local dgp_SideMenu_Dropbox10 = CreateFrame("Frame", "SideMenu_Dropbox10", dgp_Side_Frame, "UIDropDownMenuTemplate")
			dgp_SideMenu_Dropbox10:SetFrameStrata("HIGH")
			dgp_SideMenu_Dropbox10:SetFrameLevel(12)
			UIDropDownMenu_Initialize(dgp_SideMenu_Dropbox10, dgpSideMenuDropbox10Init)
			UIDropDownMenu_SetSelectedID(dgp_SideMenu_Dropbox10, 1)
			UIDropDownMenu_JustifyText(dgp_SideMenu_Dropbox10, "LEFT")
			
		-- ** End Side Frame Dropboxes **		
		
		-- ** Side Frame Editboxes **
		local dgp_Side_Frame_Editbox1_1 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox1_1:SetFontObject("GameFontNormal")
			dgp_Side_Frame_Editbox1_1:SetAutoFocus(false)
			dgp_Side_Frame_Editbox1_1:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox1_1:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox1_1.texture = dgp_Side_Frame_Editbox1_1:CreateTexture()
			dgp_Side_Frame_Editbox1_1.texture:SetAllPoints(dgp_Side_Frame_Editbox1_1)
			dgp_Side_Frame_Editbox1_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox1_1:SetMaxLetters(10)
			dgp_Side_Frame_Editbox1_1:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox1_1:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox1_1:ClearFocus() end)
		local dgp_Side_Frame_Editbox1_2 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox1_2:SetFontObject("GameFontHighlight")
			dgp_Side_Frame_Editbox1_2:SetAutoFocus(false)
			dgp_Side_Frame_Editbox1_2:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox1_2:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox1_2.texture = dgp_Side_Frame_Editbox1_2:CreateTexture()
			dgp_Side_Frame_Editbox1_2.texture:SetAllPoints(dgp_Side_Frame_Editbox1_2)
			dgp_Side_Frame_Editbox1_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox1_2:SetMaxLetters(4)
			dgp_Side_Frame_Editbox1_2:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox1_2:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox1_2:ClearFocus() end)
			dgp_Side_Frame_Editbox1_2:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						if tonumber(dgp_Side_Frame_Editbox1_2:GetText()) == nil then
							if dgp_Side_Frame_Editbox1_2:GetText() == "" then
								dgp_Side_Frame_Value1 = dgp_Side_Frame_Editbox1_2:GetText()
							else
								dgp_Side_Frame_Editbox1_2:SetText(dgp_Side_Frame_Value1)
							end
						else
							dgp_Side_Frame_Value1 = dgp_Side_Frame_Editbox1_2:GetText()
						end
					end)
					
		local dgp_Side_Frame_Editbox2_1 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox2_1:SetFontObject("GameFontNormal")
			dgp_Side_Frame_Editbox2_1:SetAutoFocus(false)
			dgp_Side_Frame_Editbox2_1:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox2_1:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox2_1.texture = dgp_Side_Frame_Editbox2_1:CreateTexture()
			dgp_Side_Frame_Editbox2_1.texture:SetAllPoints(dgp_Side_Frame_Editbox2_1)
			dgp_Side_Frame_Editbox2_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox2_1:SetMaxLetters(10)
			dgp_Side_Frame_Editbox2_1:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox2_1:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox2_1:ClearFocus() end)
		local dgp_Side_Frame_Editbox2_2 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox2_2:SetFontObject("GameFontHighlight")
			dgp_Side_Frame_Editbox2_2:SetAutoFocus(false)
			dgp_Side_Frame_Editbox2_2:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox2_2:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox2_2.texture = dgp_Side_Frame_Editbox2_2:CreateTexture()
			dgp_Side_Frame_Editbox2_2.texture:SetAllPoints(dgp_Side_Frame_Editbox2_2)
			dgp_Side_Frame_Editbox2_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox2_2:SetMaxLetters(4)
			dgp_Side_Frame_Editbox2_2:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox2_2:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox2_2:ClearFocus() end)
			dgp_Side_Frame_Editbox2_2:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						if tonumber(dgp_Side_Frame_Editbox2_2:GetText()) == nil then
							if dgp_Side_Frame_Editbox2_2:GetText() == "" then
								dgp_Side_Frame_Value2 = dgp_Side_Frame_Editbox2_2:GetText()
							else
								dgp_Side_Frame_Editbox2_2:SetText(dgp_Side_Frame_Value2)
							end
						else
							dgp_Side_Frame_Value2 = dgp_Side_Frame_Editbox2_2:GetText()
						end
					end)
		
		local dgp_Side_Frame_Editbox3_1 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox3_1:SetFontObject("GameFontNormal")
			dgp_Side_Frame_Editbox3_1:SetAutoFocus(false)
			dgp_Side_Frame_Editbox3_1:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox3_1:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox3_1.texture = dgp_Side_Frame_Editbox3_1:CreateTexture()
			dgp_Side_Frame_Editbox3_1.texture:SetAllPoints(dgp_Side_Frame_Editbox3_1)
			dgp_Side_Frame_Editbox3_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox3_1:SetMaxLetters(10)
			dgp_Side_Frame_Editbox3_1:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox3_1:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox3_1:ClearFocus() end)
		local dgp_Side_Frame_Editbox3_2 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox3_2:SetFontObject("GameFontHighlight")
			dgp_Side_Frame_Editbox3_2:SetAutoFocus(false)
			dgp_Side_Frame_Editbox3_2:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox3_2:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox3_2.texture = dgp_Side_Frame_Editbox3_2:CreateTexture()
			dgp_Side_Frame_Editbox3_2.texture:SetAllPoints(dgp_Side_Frame_Editbox3_2)
			dgp_Side_Frame_Editbox3_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox3_2:SetMaxLetters(4)
			dgp_Side_Frame_Editbox3_2:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox3_2:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox3_2:ClearFocus() end)
			dgp_Side_Frame_Editbox3_2:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						if tonumber(dgp_Side_Frame_Editbox3_2:GetText()) == nil then
							if dgp_Side_Frame_Editbox3_2:GetText() == "" then
								dgp_Side_Frame_Value3 = dgp_Side_Frame_Editbox3_2:GetText()
							else
								dgp_Side_Frame_Editbox3_2:SetText(dgp_Side_Frame_Value3)
							end
						else
							dgp_Side_Frame_Value3 = dgp_Side_Frame_Editbox3_2:GetText()
						end
					end)
		
		local dgp_Side_Frame_Editbox4_1 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox4_1:SetFontObject("GameFontNormal")
			dgp_Side_Frame_Editbox4_1:SetAutoFocus(false)
			dgp_Side_Frame_Editbox4_1:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox4_1:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox4_1.texture = dgp_Side_Frame_Editbox4_1:CreateTexture()
			dgp_Side_Frame_Editbox4_1.texture:SetAllPoints(dgp_Side_Frame_Editbox4_1)
			dgp_Side_Frame_Editbox4_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox4_1:SetMaxLetters(10)
			dgp_Side_Frame_Editbox4_1:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox4_1:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox4_1:ClearFocus() end)
		local dgp_Side_Frame_Editbox4_2 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox4_2:SetFontObject("GameFontHighlight")
			dgp_Side_Frame_Editbox4_2:SetAutoFocus(false)
			dgp_Side_Frame_Editbox4_2:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox4_2:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox4_2.texture = dgp_Side_Frame_Editbox4_2:CreateTexture()
			dgp_Side_Frame_Editbox4_2.texture:SetAllPoints(dgp_Side_Frame_Editbox4_2)
			dgp_Side_Frame_Editbox4_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox4_2:SetMaxLetters(4)
			dgp_Side_Frame_Editbox4_2:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox4_2:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox4_2:ClearFocus() end)
			dgp_Side_Frame_Editbox4_2:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						if tonumber(dgp_Side_Frame_Editbox4_2:GetText()) == nil then
							if dgp_Side_Frame_Editbox4_2:GetText() == "" then
								dgp_Side_Frame_Value4 = dgp_Side_Frame_Editbox4_2:GetText()
							else
								dgp_Side_Frame_Editbox4_2:SetText(dgp_Side_Frame_Value4)
							end
						else
							dgp_Side_Frame_Value4 = dgp_Side_Frame_Editbox4_2:GetText()
						end
					end)
		
		local dgp_Side_Frame_Editbox5_1 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox5_1:SetFontObject("GameFontNormal")
			dgp_Side_Frame_Editbox5_1:SetAutoFocus(false)
			dgp_Side_Frame_Editbox5_1:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox5_1:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox5_1.texture = dgp_Side_Frame_Editbox5_1:CreateTexture()
			dgp_Side_Frame_Editbox5_1.texture:SetAllPoints(dgp_Side_Frame_Editbox5_1)
			dgp_Side_Frame_Editbox5_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox5_1:SetMaxLetters(10)
			dgp_Side_Frame_Editbox5_1:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox5_1:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox5_1:ClearFocus() end)
		local dgp_Side_Frame_Editbox5_2 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox5_2:SetFontObject("GameFontHighlight")
			dgp_Side_Frame_Editbox5_2:SetAutoFocus(false)
			dgp_Side_Frame_Editbox5_2:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox5_2:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox5_2.texture = dgp_Side_Frame_Editbox5_2:CreateTexture()
			dgp_Side_Frame_Editbox5_2.texture:SetAllPoints(dgp_Side_Frame_Editbox5_2)
			dgp_Side_Frame_Editbox5_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox5_2:SetMaxLetters(4)
			dgp_Side_Frame_Editbox5_2:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox5_2:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox5_2:ClearFocus() end)
			dgp_Side_Frame_Editbox5_2:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						if tonumber(dgp_Side_Frame_Editbox5_2:GetText()) == nil then
							if dgp_Side_Frame_Editbox5_2:GetText() == "" then
								dgp_Side_Frame_Value5 = dgp_Side_Frame_Editbox5_2:GetText()
							else
								dgp_Side_Frame_Editbox5_2:SetText(dgp_Side_Frame_Value5)
							end
						else
							dgp_Side_Frame_Value5 = dgp_Side_Frame_Editbox5_2:GetText()
						end
					end)
		
		local dgp_Side_Frame_Editbox6_1 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox6_1:SetFontObject("GameFontNormal")
			dgp_Side_Frame_Editbox6_1:SetAutoFocus(false)
			dgp_Side_Frame_Editbox6_1:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox6_1:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox6_1.texture = dgp_Side_Frame_Editbox6_1:CreateTexture()
			dgp_Side_Frame_Editbox6_1.texture:SetAllPoints(dgp_Side_Frame_Editbox6_1)
			dgp_Side_Frame_Editbox6_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox6_1:SetMaxLetters(10)
			dgp_Side_Frame_Editbox6_1:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox6_1:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox6_1:ClearFocus() end)
		local dgp_Side_Frame_Editbox6_2 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox6_2:SetFontObject("GameFontHighlight")
			dgp_Side_Frame_Editbox6_2:SetAutoFocus(false)
			dgp_Side_Frame_Editbox6_2:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox6_2:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox6_2.texture = dgp_Side_Frame_Editbox6_2:CreateTexture()
			dgp_Side_Frame_Editbox6_2.texture:SetAllPoints(dgp_Side_Frame_Editbox6_2)
			dgp_Side_Frame_Editbox6_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox6_2:SetMaxLetters(4)
			dgp_Side_Frame_Editbox6_2:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox6_2:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox6_2:ClearFocus() end)
			dgp_Side_Frame_Editbox6_2:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						if tonumber(dgp_Side_Frame_Editbox6_2:GetText()) == nil then
							if dgp_Side_Frame_Editbox6_2:GetText() == "" then
								dgp_Side_Frame_Value6 = dgp_Side_Frame_Editbox6_2:GetText()
							else
								dgp_Side_Frame_Editbox6_2:SetText(dgp_Side_Frame_Value6)
							end
						else
							dgp_Side_Frame_Value6 = dgp_Side_Frame_Editbox6_2:GetText()
						end
					end)
		
		local dgp_Side_Frame_Editbox7_1 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox7_1:SetFontObject("GameFontNormal")
			dgp_Side_Frame_Editbox7_1:SetAutoFocus(false)
			dgp_Side_Frame_Editbox7_1:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox7_1:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox7_1.texture = dgp_Side_Frame_Editbox7_1:CreateTexture()
			dgp_Side_Frame_Editbox7_1.texture:SetAllPoints(dgp_Side_Frame_Editbox7_1)
			dgp_Side_Frame_Editbox7_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox7_1:SetMaxLetters(10)
			dgp_Side_Frame_Editbox7_1:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox7_1:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox7_1:ClearFocus() end)
		local dgp_Side_Frame_Editbox7_2 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox7_2:SetFontObject("GameFontHighlight")
			dgp_Side_Frame_Editbox7_2:SetAutoFocus(false)
			dgp_Side_Frame_Editbox7_2:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox7_2:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox7_2.texture = dgp_Side_Frame_Editbox7_2:CreateTexture()
			dgp_Side_Frame_Editbox7_2.texture:SetAllPoints(dgp_Side_Frame_Editbox7_2)
			dgp_Side_Frame_Editbox7_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox7_2:SetMaxLetters(4)
			dgp_Side_Frame_Editbox7_2:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox7_2:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox7_2:ClearFocus() end)
			dgp_Side_Frame_Editbox7_2:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						if tonumber(dgp_Side_Frame_Editbox7_2:GetText()) == nil then
							if dgp_Side_Frame_Editbox7_2:GetText() == "" then
								dgp_Side_Frame_Value7 = dgp_Side_Frame_Editbox7_2:GetText()
							else
								dgp_Side_Frame_Editbox7_2:SetText(dgp_Side_Frame_Value7)
							end
						else
							dgp_Side_Frame_Value7 = dgp_Side_Frame_Editbox7_2:GetText()
						end
					end)
		
		local dgp_Side_Frame_Editbox8_1 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox8_1:SetFontObject("GameFontNormal")
			dgp_Side_Frame_Editbox8_1:SetAutoFocus(false)
			dgp_Side_Frame_Editbox8_1:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox8_1:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox8_1.texture = dgp_Side_Frame_Editbox8_1:CreateTexture()
			dgp_Side_Frame_Editbox8_1.texture:SetAllPoints(dgp_Side_Frame_Editbox8_1)
			dgp_Side_Frame_Editbox8_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox8_1:SetMaxLetters(10)
			dgp_Side_Frame_Editbox8_1:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox8_1:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox8_1:ClearFocus() end)
		local dgp_Side_Frame_Editbox8_2 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox8_2:SetFontObject("GameFontHighlight")
			dgp_Side_Frame_Editbox8_2:SetAutoFocus(false)
			dgp_Side_Frame_Editbox8_2:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox8_2:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox8_2.texture = dgp_Side_Frame_Editbox8_2:CreateTexture()
			dgp_Side_Frame_Editbox8_2.texture:SetAllPoints(dgp_Side_Frame_Editbox8_2)
			dgp_Side_Frame_Editbox8_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox8_2:SetMaxLetters(4)
			dgp_Side_Frame_Editbox8_2:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox8_2:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox8_2:ClearFocus() end)
			dgp_Side_Frame_Editbox8_2:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						if tonumber(dgp_Side_Frame_Editbox8_2:GetText()) == nil then
							if dgp_Side_Frame_Editbox8_2:GetText() == "" then
								dgp_Side_Frame_Value8 = dgp_Side_Frame_Editbox8_2:GetText()
							else
								dgp_Side_Frame_Editbox8_2:SetText(dgp_Side_Frame_Value8)
							end
						else
							dgp_Side_Frame_Value8 = dgp_Side_Frame_Editbox8_2:GetText()
						end
					end)
		
		local dgp_Side_Frame_Editbox9_1 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox9_1:SetFontObject("GameFontNormal")
			dgp_Side_Frame_Editbox9_1:SetAutoFocus(false)
			dgp_Side_Frame_Editbox9_1:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox9_1:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox9_1.texture = dgp_Side_Frame_Editbox9_1:CreateTexture()
			dgp_Side_Frame_Editbox9_1.texture:SetAllPoints(dgp_Side_Frame_Editbox9_1)
			dgp_Side_Frame_Editbox9_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox9_1:SetMaxLetters(10)
			dgp_Side_Frame_Editbox9_1:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox9_1:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox9_1:ClearFocus() end)
		local dgp_Side_Frame_Editbox9_2 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox9_2:SetFontObject("GameFontHighlight")
			dgp_Side_Frame_Editbox9_2:SetAutoFocus(false)
			dgp_Side_Frame_Editbox9_2:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox9_2:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox9_2.texture = dgp_Side_Frame_Editbox9_2:CreateTexture()
			dgp_Side_Frame_Editbox9_2.texture:SetAllPoints(dgp_Side_Frame_Editbox9_2)
			dgp_Side_Frame_Editbox9_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox9_2:SetMaxLetters(4)
			dgp_Side_Frame_Editbox9_2:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox9_2:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox9_2:ClearFocus() end)
			dgp_Side_Frame_Editbox9_2:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						if tonumber(dgp_Side_Frame_Editbox9_2:GetText()) == nil then
							if dgp_Side_Frame_Editbox9_2:GetText() == "" then
								dgp_Side_Frame_Value9 = dgp_Side_Frame_Editbox9_2:GetText()
							else
								dgp_Side_Frame_Editbox9_2:SetText(dgp_Side_Frame_Value9)
							end
						else
							dgp_Side_Frame_Value9 = dgp_Side_Frame_Editbox9_2:GetText()
						end
					end)
		
		local dgp_Side_Frame_Editbox10_1 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox10_1:SetFontObject("GameFontNormal")
			dgp_Side_Frame_Editbox10_1:SetAutoFocus(false)
			dgp_Side_Frame_Editbox10_1:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox10_1:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox10_1.texture = dgp_Side_Frame_Editbox10_1:CreateTexture()
			dgp_Side_Frame_Editbox10_1.texture:SetAllPoints(dgp_Side_Frame_Editbox10_1)
			dgp_Side_Frame_Editbox10_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox10_1:SetMaxLetters(10)
			dgp_Side_Frame_Editbox10_1:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox10_1:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox10_1:ClearFocus() end)
		local dgp_Side_Frame_Editbox10_2 = CreateFrame("EditBox", nil, dgp_Side_Frame)
			dgp_Side_Frame_Editbox10_2:SetFontObject("GameFontHighlight")
			dgp_Side_Frame_Editbox10_2:SetAutoFocus(false)
			dgp_Side_Frame_Editbox10_2:SetFrameStrata("HIGH")
			dgp_Side_Frame_Editbox10_2:SetFrameLevel(12) 
			dgp_Side_Frame_Editbox10_2.texture = dgp_Side_Frame_Editbox10_2:CreateTexture()
			dgp_Side_Frame_Editbox10_2.texture:SetAllPoints(dgp_Side_Frame_Editbox10_2)
			dgp_Side_Frame_Editbox10_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Side_Frame_Editbox10_2:SetMaxLetters(4)
			dgp_Side_Frame_Editbox10_2:SetTextInsets( 5, 5, 2, 2)
			dgp_Side_Frame_Editbox10_2:SetScript("OnEnterPressed", function(self) dgp_Side_Frame_Editbox10_2:ClearFocus() end)
			dgp_Side_Frame_Editbox10_2:SetScript("OnTextChanged", function(self) -- Check for acceptable entries
						if tonumber(dgp_Side_Frame_Editbox10_2:GetText()) == nil then
							if dgp_Side_Frame_Editbox10_2:GetText() == "" then
								dgp_Side_Frame_Value103 = dgp_Side_Frame_Editbox10_2:GetText()
							else
								dgp_Side_Frame_Editbox10_2:SetText(dgp_Side_Frame_Value10)
							end
						else
							dgp_Side_Frame_Value10 = dgp_Side_Frame_Editbox10_2:GetText()
						end
					end)
		-- ** End Side Frame Edit Boxes **
		
		-- ** Side Frame Apply Button ** --
		local dgp_SideMenu_Apply_Button = CreateFrame("Button", "sideApplyButton", dgp_Side_Frame)
			dgp_SideMenu_Apply_Button:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Apply_Button:SetFrameLevel(12) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			-- Create and define the button texture
			dgp_SideMenu_Apply_Button.texture = dgp_SideMenu_Apply_Button:CreateTexture()
			dgp_SideMenu_Apply_Button.texture:SetAllPoints(dgp_SideMenu_Apply_Button)
			dgp_SideMenu_Apply_Button.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
			-- Create and define the pushed texture
			dgp_SideMenu_Apply_Button_Pushed = dgp_SideMenu_Apply_Button:CreateTexture()
			dgp_SideMenu_Apply_Button_Pushed:SetAllPoints(dgp_SideMenu_Apply_Button)
			dgp_SideMenu_Apply_Button_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_SideMenu_Apply_Button:SetPushedTexture(dgp_SideMenu_Apply_Button_Pushed)
			
			-- Define the text
			dgp_SideMenu_Apply_Button.text = dgp_SideMenu_Apply_Button:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Apply_Button.text:SetAllPoints()
			dgp_SideMenu_Apply_Button.text:SetText("Apply")
			
			-- Set the click action to apply the changes
			dgp_SideMenu_Apply_Button:SetScript("OnClick", function(self)
					dgpApplyChanges()
					-- Change the update details for this configuration
					DGPLastUpdateTime = date("20%y%m%d%H%M")
					DGPUpdateOriginator = dgpPlayerName
				end)
			
		-- ** End Side Frame Apply Button ** --
		
		-- ** Side Frame Cancel Button ** --
		local dgp_SideMenu_Cancel_Button = CreateFrame("Button", "sideCancelButton", dgp_Side_Frame)
			dgp_SideMenu_Cancel_Button:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Cancel_Button:SetFrameLevel(12) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			-- Create and define the button texture
			dgp_SideMenu_Cancel_Button.texture = dgp_SideMenu_Cancel_Button:CreateTexture()
			dgp_SideMenu_Cancel_Button.texture:SetAllPoints(dgp_SideMenu_Cancel_Button)
			dgp_SideMenu_Cancel_Button.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
			-- Create and define the pushed texture
			dgp_SideMenu_Cancel_Button_Pushed = dgp_SideMenu_Cancel_Button:CreateTexture()
			dgp_SideMenu_Cancel_Button_Pushed:SetAllPoints(dgp_SideMenu_Cancel_Button)
			dgp_SideMenu_Cancel_Button_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_SideMenu_Cancel_Button:SetPushedTexture(dgp_SideMenu_Cancel_Button_Pushed)
			
			-- Define the text
			dgp_SideMenu_Cancel_Button.text = dgp_SideMenu_Cancel_Button:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Cancel_Button.text:SetAllPoints()
			dgp_SideMenu_Cancel_Button.text:SetText("Cancel")
			
			-- Set the click action to cancel any changes
			dgp_SideMenu_Cancel_Button:SetScript("OnClick", function(self) dgpCancelChanges() end)
			
		-- ** End Side Frame Cancel Button ** --
		
		-- ** Side Frame Default Button ** --
		local dgp_SideMenu_Default_Button = CreateFrame("Button", "sideDefaultButton", dgp_Side_Frame)
			dgp_SideMenu_Default_Button:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Default_Button:SetFrameLevel(12) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			-- Create and define the button texture
			dgp_SideMenu_Default_Button.texture = dgp_SideMenu_Default_Button:CreateTexture()
			dgp_SideMenu_Default_Button.texture:SetAllPoints(dgp_SideMenu_Default_Button)
			dgp_SideMenu_Default_Button.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
			-- Create and define the pushed texture
			dgp_SideMenu_Default_Button_Pushed = dgp_SideMenu_Default_Button:CreateTexture()
			dgp_SideMenu_Default_Button_Pushed:SetAllPoints(dgp_SideMenu_Default_Button)
			dgp_SideMenu_Default_Button_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_SideMenu_Default_Button:SetPushedTexture(dgp_SideMenu_Default_Button_Pushed)
			
			-- Define the text
			dgp_SideMenu_Default_Button.text = dgp_SideMenu_Default_Button:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Default_Button.text:SetAllPoints()
			dgp_SideMenu_Default_Button.text:SetText("Default")
			
			-- Set the click action to Set everything to default settings
			dgp_SideMenu_Default_Button:SetScript("OnClick", function(self)
				dgpDefaultSettings()
				-- Change the update details for this configuration
				DGPLastUpdateTime = date("20%y%m%d%H%M")
				DGPUpdateOriginator = dgpPlayerName
				end)
			
		-- ** End Side Frame Default Button ** --
		
		-- ** Side Frame Seperater **
		local dgp_SideMenu_Backup_Seperater = CreateFrame("Frame", nil, dgp_Side_Frame)
			
			-- Set the frame attributes
			dgp_SideMenu_Backup_Seperater:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Backup_Seperater:SetFrameLevel(22) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
			
			-- Create and define the button texture
			dgp_SideMenu_Backup_Seperater.texture = dgp_SideMenu_Backup_Seperater:CreateTexture()
			dgp_SideMenu_Backup_Seperater.texture:SetAllPoints(dgp_SideMenu_Backup_Seperater)
			dgp_SideMenu_Backup_Seperater.texture:SetTexture(1.0, 1.0, 1.0, 0.3)	
			
		-- ** End Side Frame Backup Drop Box Label **
		
		-- ** Side Frame Backup Drop Box Label **
		local dgp_SideMenu_Backup_Dropbox_Label = CreateFrame("Frame", nil, dgp_Side_Frame)
			
			-- Set the frame attributes
			dgp_SideMenu_Backup_Dropbox_Label:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Backup_Dropbox_Label:SetFrameLevel(22) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frames() after the addon loads
		
			-- Add a title to the addon window
			dgp_SideMenu_Backup_Dropbox_Label.text = dgp_SideMenu_Backup_Dropbox_Label:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Backup_Dropbox_Label.text:SetAllPoints()
			dgp_SideMenu_Backup_Dropbox_Label.text:SetText("Select a Backup:")
		
		-- ** End Side Frame Backup Drop Box Label **
		
		-- ** Side Frame Backup Drop Box **
		local dgp_SideMenu_Backup_Dropbox = CreateFrame("Frame", "SideMenu_Backup_Dropbox", dgp_Side_Frame, "UIDropDownMenuTemplate")
		
			dgp_SideMenu_Backup_Dropbox:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Backup_Dropbox:SetFrameLevel(22) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			UIDropDownMenu_Initialize(dgp_SideMenu_Backup_Dropbox, dgpSideMenuBackupDropboxInit) -- Initialize the dropbox menu
			UIDropDownMenu_SetSelectedID(dgp_SideMenu_Backup_Dropbox, 1) -- Set the initial dropbox setting to 1
			UIDropDownMenu_JustifyText(dgp_SideMenu_Backup_Dropbox, "CENTER") -- Center the text in the dropbox
			
		-- ** End Side Frame Backup Dropbox **
		
		-- ** Side Frame Compare Button **
		local dgp_SideMenu_Compare_Button = CreateFrame("Button", "sideCompareButton", dgp_Side_Frame)
			dgp_SideMenu_Compare_Button:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Compare_Button:SetFrameLevel(22) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			-- Create and define the button texture
			dgp_SideMenu_Compare_Button.texture = dgp_SideMenu_Compare_Button:CreateTexture()
			dgp_SideMenu_Compare_Button.texture:SetAllPoints(dgp_SideMenu_Compare_Button)
			dgp_SideMenu_Compare_Button.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
			-- Create and define the pushed texture
			dgp_SideMenu_Compare_Button_Pushed = dgp_SideMenu_Compare_Button:CreateTexture()
			dgp_SideMenu_Compare_Button_Pushed:SetAllPoints(dgp_SideMenu_Compare_Button)
			dgp_SideMenu_Compare_Button_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_SideMenu_Compare_Button:SetPushedTexture(dgp_SideMenu_Compare_Button_Pushed)
			
			-- Define the text
			dgp_SideMenu_Compare_Button.text = dgp_SideMenu_Compare_Button:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Compare_Button.text:SetAllPoints()
			dgp_SideMenu_Compare_Button.text:SetText("Compare")
			
			-- Set the click action to invoke a comparrison to previous backups
			dgp_SideMenu_Compare_Button:SetScript("OnClick", function(self)
				dgpCompare(UIDropDownMenu_GetSelectedID(dgp_SideMenu_Backup_Dropbox))
				end)
			
		-- ** End Side Frame Compare Button **
		
		-- ** Side Frame Restore Button **
		local dgp_SideMenu_Restore_Button = CreateFrame("Button", "sideRestoreButton", dgp_Side_Frame)
			dgp_SideMenu_Restore_Button:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Restore_Button:SetFrameLevel(12) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frame()
				
			-- Create and define the button texture
			dgp_SideMenu_Restore_Button.texture = dgp_SideMenu_Restore_Button:CreateTexture()
			dgp_SideMenu_Restore_Button.texture:SetAllPoints(dgp_SideMenu_Restore_Button)
			dgp_SideMenu_Restore_Button.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
			-- Create and define the pushed texture
			dgp_SideMenu_Restore_Button_Pushed = dgp_SideMenu_Restore_Button:CreateTexture()
			dgp_SideMenu_Restore_Button_Pushed:SetAllPoints(dgp_SideMenu_Restore_Button)
			dgp_SideMenu_Restore_Button_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_SideMenu_Restore_Button:SetPushedTexture(dgp_SideMenu_Restore_Button_Pushed)
			
			-- Define the text
			dgp_SideMenu_Restore_Button.text = dgp_SideMenu_Restore_Button:CreateFontString(nil, "MEDIUM", "GameFontNormal")
			dgp_SideMenu_Restore_Button.text:SetAllPoints()
			dgp_SideMenu_Restore_Button.text:SetText("Restore")
			
			-- Set the click action to invoke a comparrison to previous backups
			dgp_SideMenu_Restore_Button:SetScript("OnClick", function(self)
				dgpConfirmRestore()
				end)
			
		-- ** End Side Frame Restore Button **
		
		-- ** Side Frame Confirm Restore **
		local dgp_SideMenu_Confirm_Restore = CreateFrame("Frame", nil, dgp_Side_Frame)
			-- Set the frame attributes
			dgp_SideMenu_Confirm_Restore:SetFrameStrata("HIGH") -- Set the frame above most of the UI
			dgp_SideMenu_Confirm_Restore:SetFrameLevel(31) -- Set the display layer
				-- Size and position are calculated by dgp_Resize_Frames() after the addon loads

			-- Set the texture of the parent frame	
			dgp_SideMenu_Confirm_Restore:SetBackdrop({ bgFile = "Interface\\AddOns\\GuildPoints\\Images\\Title-Frame-Background",
			edgeFile = "Interface\\AddOns\\GuildPoints\\Images\\Main-Frame-Border",
				tile = false, tileSize = 0, edgeSize = 16,
				insets = { left = 4, right = 4, top = 4, bottom = 4} })
					dgp_SideMenu_Confirm_Restore:Hide()
			
			-- ** Side Frame Confirm Restore Title **
			local dgp_SideMenu_Confirm_Restore_Title = CreateFrame("Frame", nil, dgp_SideMenu_Confirm_Restore)
				dgp_SideMenu_Confirm_Restore_Title:SetFrameStrata("HIGH")
				dgp_SideMenu_Confirm_Restore_Title:SetFrameLevel(32)
				dgp_SideMenu_Confirm_Restore_Title.text = dgp_SideMenu_Confirm_Restore_Title:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_SideMenu_Confirm_Restore_Title.text:SetAllPoints()
				dgp_SideMenu_Confirm_Restore_Title.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
				dgp_SideMenu_Confirm_Restore_Title.text:SetText("Restore Backup ##?")
			
			-- ** EndSide Frame Confirm Restore Title **
			
			-- ** Side Frame Confirm Restore Accept **
			local dgp_SideMenu_Confirm_Restore_Accept = CreateFrame("Button", nil, dgp_SideMenu_Confirm_Restore)
				dgp_SideMenu_Confirm_Restore_Accept:SetFrameStrata("HIGH") -- Set the frame above most of the UI
				dgp_SideMenu_Confirm_Restore_Accept:SetFrameLevel(32) -- Set the display layer
					-- Size and position are calculated by dgp_Resize_Frame()
				
				-- Create and define the button texture
				dgp_SideMenu_Confirm_Restore_Accept.texture = dgp_SideMenu_Confirm_Restore_Accept:CreateTexture()
				dgp_SideMenu_Confirm_Restore_Accept.texture:SetAllPoints(dgp_SideMenu_Confirm_Restore_Accept)
				dgp_SideMenu_Confirm_Restore_Accept.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
				-- Create and define the pushed texture
				dgp_SideMenu_Confirm_Restore_Accept_Pushed = dgp_SideMenu_Confirm_Restore_Accept:CreateTexture()
				dgp_SideMenu_Confirm_Restore_Accept_Pushed:SetAllPoints(dgp_SideMenu_Confirm_Restore_Accept)
				dgp_SideMenu_Confirm_Restore_Accept_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
				dgp_SideMenu_Confirm_Restore_Accept:SetPushedTexture(dgp_SideMenu_Confirm_Restore_Accept_Pushed)
			
				-- Define the text
				dgp_SideMenu_Confirm_Restore_Accept.text = dgp_SideMenu_Confirm_Restore_Accept:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_SideMenu_Confirm_Restore_Accept.text:SetAllPoints()
				dgp_SideMenu_Confirm_Restore_Accept.text:SetText("Accept")
			
				-- Set the click action to invoke a comparrison to previous backups
				dgp_SideMenu_Confirm_Restore_Accept:SetScript("OnClick", function(self)
					dgpRestore(UIDropDownMenu_GetSelectedID(dgp_SideMenu_Backup_Dropbox))
					dgpSideMenuFadeIn()
					dgp_SideMenu_Confirm_Restore:Hide()
					end)
					
			-- ** End Side Frame Confirm Restore Accept **
			
			-- ** Side Frame Confirm Restore Decline **
			local dgp_SideMenu_Confirm_Restore_Cancel = CreateFrame("Button", nil, dgp_SideMenu_Confirm_Restore)
				dgp_SideMenu_Confirm_Restore_Cancel:SetFrameStrata("HIGH") -- Set the frame above most of the UI
				dgp_SideMenu_Confirm_Restore_Cancel:SetFrameLevel(32) -- Set the display layer
					-- Size and position are calculated by dgp_Resize_Frame()
				
				-- Create and define the button texture
				dgp_SideMenu_Confirm_Restore_Cancel.texture = dgp_SideMenu_Confirm_Restore_Cancel:CreateTexture()
				dgp_SideMenu_Confirm_Restore_Cancel.texture:SetAllPoints(dgp_SideMenu_Confirm_Restore_Cancel)
				dgp_SideMenu_Confirm_Restore_Cancel.texture:SetTexture(1.0, 1.0, 1.0, 0.1)	
			
				-- Create and define the pushed texture
				dgp_SideMenu_Confirm_Restore_Cancel_Pushed = dgp_SideMenu_Confirm_Restore_Cancel:CreateTexture()
				dgp_SideMenu_Confirm_Restore_Cancel_Pushed:SetAllPoints(dgp_SideMenu_Confirm_Restore_Cancel)
				dgp_SideMenu_Confirm_Restore_Cancel_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)
				dgp_SideMenu_Confirm_Restore_Cancel:SetPushedTexture(dgp_SideMenu_Confirm_Restore_Cancel_Pushed)
			
				-- Define the text
				dgp_SideMenu_Confirm_Restore_Cancel.text = dgp_SideMenu_Confirm_Restore_Cancel:CreateFontString(nil, "MEDIUM", "GameFontNormal")
				dgp_SideMenu_Confirm_Restore_Cancel.text:SetAllPoints()
				dgp_SideMenu_Confirm_Restore_Cancel.text:SetText("Cancel")
			
				-- Set the click action to invoke a comparrison to previous backups
				dgp_SideMenu_Confirm_Restore_Cancel:SetScript("OnClick", function(self)
					dgpSideMenuFadeIn()
					dgp_SideMenu_Confirm_Restore:Hide()
					end)
			
			-- ** End Side Frame Confirm Restore Decline **
			
		-- ** End Side Frame Confirm Restore **
		
	-- ** End Side Frame **
	
-- ** End Main frame **

-- END FRAMES

		
-- EVENT RECIEVE FUNCTIONS

-- Main frame
function dgp_Frame:OnEvent(event, arg1, arg2)
	-- When a addon loaded event is sent, then check if it's for this addon
	if event == "ADDON_LOADED" and arg1 == "GuildPoints" then
		-- Checks for the presence of the 5 backups and initialises them if they do not exist
		if DGPBackupNum1 == nil then
			DGPBackupNum1 = {}
			DGPBackupNum1.date = date("%d/%m/%y %H:%M:%S")
		end
		if DGPBackupNum2 == nil then
			DGPBackupNum2 = {}
			DGPBackupNum2.date = date("%d/%m/%y %H:%M:%S")
		end
		if DGPBackupNum3 == nil then
			DGPBackupNum3 = {}
			DGPBackupNum3.date = date("%d/%m/%y %H:%M:%S")
		end
		if DGPBackupNum4 == nil then
			DGPBackupNum4 = {}
			DGPBackupNum4.date = date("%d/%m/%y %H:%M:%S")
		end
		if DGPBackupNum5 == nil then
			DGPBackupNum5 = {}
			DGPBackupNum5.date = date("%d/%m/%y %H:%M:%S")
		end
		
		-- Also checks the saved frame sizes and position
		if DGPWidth == nil then
			DGPWidth = 400
		end
		if DGPHeight == nil then
			DGPHeight = 400
		end
		if DGPBottomOffset == nil then
			DGPBottomOffset = 100
		end
		if DGPLeftOffset == nil then
			DGPLeftOffset = 50
		end
		
		-- Checks for the saved button details
		if DGPButton1Text == nil then
			DGPButton1Text = "Modifiers"
		end
		if DGPButton1Type == nil then
			DGPButton1Type = "Title"
		end
		if DGPButton1Value == nil then
			DGPButton1Value = 0
		end
		if DGPButton2Text == nil then
			DGPButton2Text = "Full Guild"
		end
		if DGPButton2Type == nil then
			DGPButton2Type = "Modifier"
		end
		if DGPButton2Value == nil then
			DGPButton2Value = 2
		end
		if DGPButton3Text == nil then
			DGPButton3Text = "Groups"
		end
		if DGPButton3Type == nil then
			DGPButton3Type = "Title"
		end
		if DGPButton3Value == nil then
			DGPButton3Value = 0
		end
		if DGPButton4Text == nil then
			DGPButton4Text = "Scenario"
		end
		if DGPButton4Type == nil then
			DGPButton4Type = "Adder"
		end
		if DGPButton4Value == nil then
			DGPButton4Value = 5
		end
		if DGPButton5Text == nil then
			DGPButton5Text = "Dungeon"
		end
		if DGPButton5Type == nil then
			DGPButton5Type = "Adder"
		end
		if DGPButton5Value == nil then
			DGPButton5Value = 10
		end
		if DGPButton6Text == nil then
			DGPButton6Text = "Old Raid"
		end
		if DGPButton6Type == nil then
			DGPButton6Type = "Adder"
		end
		if DGPButton6Value == nil then
			DGPButton6Value = 25
		end
		if DGPButton7Text == nil then
			DGPButton7Text = "LFR Boss"
		end
		if DGPButton7Type == nil then
			DGPButton7Type= "Adder"
		end
		if DGPButton7Value == nil then
			DGPButton7Value = 25
		end
		if DGPButton8Text == nil then
			DGPButton8Text = "Raid Boss"
		end
		if DGPButton8Type == nil then
			DGPButton8Type = "Adder"
		end
		if DGPButton8Value == nil then
			DGPButton8Value = 50
		end
		if DGPButton9Text == nil then
			DGPButton9Text = "Other"
		end
		if DGPButton9Type == nil then
			DGPButton9Type = "Title"
		end
		if DGPButton9Value == nil then
			DGPButton9Value = 0
		end
		if DGPButton10Text == nil then
			DGPButton10Text = "Invites"
		end
		if DGPButton10Type == nil then
			DGPButton10Type = "Adder"
		end
		if DGPButton10Value == nil then
			DGPButton10Value = 10
		end
		
		-- Check for saved update related variables
		if DGPLastUpdateTime == nil then
			DGPLastUpdateTime = "0"
		end
		if DGPUpdateOriginator == nil then
			DGPUpdateOriginator = dgpPlayerName
		end
		
		-- Check for the honorary guild members array
		if DGPHonoraryGuildMembers == nil then
			DGPHonoraryGuildMembers = {}
		end
		
		-- Now that the frame size and position exists we can set it
		dgp_Resize_Frames()

		-- Create the player list
		dgp_wait(1, dgpResetPlayerTypeFilter)  -- Set the list to show all guld members
		dgp_wait(2, dgpFilterPlayers) -- Update the filtered guild members
		dgp_wait(2, dgpUpdateList) -- Show the new filtered list
		
		-- Now update the side button details
		dgp_wait(1, dgpUpdateButtons)		
		
		-- Send an update check message
		dgp_wait(5, dgpUpdateCheck)
		
	end -- ADDON LOADED Guild Points
	
end -- dgp_Frame:OnEvent	

dgp_Frame:SetScript("OnEvent", dgp_Frame.OnEvent) -- Call the previous function when an event is triggered for the main frame

-- Side frame (receive updates)
function dgp_Side_Frame:OnEvent(event, prefix, msg, channel, sender)
	-- Confirm the event is an addon message
	if event == "CHAT_MSG_ADDON" then
		
		-- Check it's not from yourself
		if sender == dgpPlayerName then
			-- Do nothing
		--	print("Ignoring message from sself")
		else
		
			-- If it is a check message
			if prefix == "dgpCheck" then
				-- Then send a reply with this addon's last update time and the originator
				SendAddonMessage("dgpReply", DGPLastUpdateTime .. ":" .. DGPUpdateOriginator, "GUILD")
			end -- end if (dgpCheck)
			
			
			-- If it is a reply message
			if prefix == "dgpReply" then
				-- Split the time and originator in the message
				updateTime, updateOriginator = strsplit(":", msg, 2)
				
				-- First check the addon isn't already in the middle of an update
				if dgpUpdating == "closed" then
					-- Second check the update time is greater then the current update
					if updateTime > DGPLastUpdateTime then
						-- Last check if the originator is the GM for the same guild
						SetGuildRosterShowOffline(true) -- Make sure offline members are shown
						
						-- Cycle through all players in the guild
						local numMembers = GetNumGuildMembers() -- Retrieve the number of guild members (online number not required)
						local counter = 1 -- Start at the top of the list
						
						while counter <= numMembers do
	
							-- Retrieve the players guild details up to rankIndex
							local name, rank, rankIndex = GetGuildRosterInfo(counter)
						
							-- If the player is found in the guild roster
							if name == updateOriginator then
								-- And the are in fact the guild master
								if rankIndex == 0 then
									-- Start the update
									dgpTempUpdateTime = DGPLastUpdateTime  -- Store the old time while updating
									dgpTempOriginator = DGPUpdateOriginator -- Store the old originator while updating
									
									DGPLastUpdateTime = updateTime -- Update the time
									DGPUpdateOriginator = updateOriginator -- Update the originator
									dgpUpdating = sender -- Indicate who we are receiving updates from
									
									-- Send the first update request
									SendAddonMessage("dgpRequest", dgpUpdating .. ":Button1Type", "GUILD" )
								end -- end if
								
								counter = numMembers -- Stop looking
							end -- endif

							counter = counter + 1
						end -- While loop
					-- If the updateTime is less then the update time
					elseif updateTime < DGPLastUpdateTime then
						-- Then send another reply back
						SendAddonMessage("dgpReply", DGPLastUpdateTime .. ":" .. DGPUpdateOriginator, "GUILD")
					end -- end if
				end -- end if				
			end -- end if (dgpReply)
			
			
			-- If it is a request message
			if prefix == "dgpRequest" then
				-- Split the player name and item request
				requestedFrom, requestedItem = strsplit(":", msg, 2)
				
				-- If the request if for this player
				if requestedFrom == dgpPlayerName then
					-- Send the requested item
					if requestedItem == "Button1Type" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button1Type:" .. DGPButton1Type, "GUILD")
					elseif requestedItem == "Button1Text" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button1Text:" .. DGPButton1Text, "GUILD")
					elseif requestedItem == "Button1Value" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button1Value:" .. DGPButton1Value, "GUILD")
					elseif requestedItem == "Button2Type" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button2Type:" .. DGPButton2Type, "GUILD")
					elseif requestedItem == "Button2Text" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button2Text:" .. DGPButton2Text, "GUILD")
					elseif requestedItem == "Button2Value" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button2Value:" .. DGPButton2Value, "GUILD")
					elseif requestedItem == "Button3Type" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button3Type:" .. DGPButton3Type, "GUILD")
					elseif requestedItem == "Button3Text" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button3Text:" .. DGPButton3Text, "GUILD")
					elseif requestedItem == "Button3Value" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button3Value:" .. DGPButton3Value, "GUILD")
					elseif requestedItem == "Button4Type" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button4Type:" .. DGPButton4Type, "GUILD")
					elseif requestedItem == "Button4Text" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button4Text:" .. DGPButton4Text, "GUILD")
					elseif requestedItem == "Button4Value" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button4Value:" .. DGPButton4Value, "GUILD")
					elseif requestedItem == "Button5Type" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button5Type:" .. DGPButton5Type, "GUILD")
					elseif requestedItem == "Button5Text" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button5Text:" .. DGPButton5Text, "GUILD")
					elseif requestedItem == "Button5Value" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button5Value:" .. DGPButton5Value, "GUILD")
					elseif requestedItem == "Button6Type" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button6Type:" .. DGPButton6Type, "GUILD")
					elseif requestedItem == "Button6Text" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button6Text:" .. DGPButton6Text, "GUILD")
					elseif requestedItem == "Button6Value" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button6Value:" .. DGPButton6Value, "GUILD")
					elseif requestedItem == "Button7Type" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button7Type:" .. DGPButton7Type, "GUILD")
					elseif requestedItem == "Button7Text" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button7Text:" .. DGPButton7Text, "GUILD")
					elseif requestedItem == "Button7Value" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button7Value:" .. DGPButton7Value, "GUILD")
					elseif requestedItem == "Button8Type" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button8Type:" .. DGPButton8Type, "GUILD")
					elseif requestedItem == "Button8Text" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button8Text:" .. DGPButton8Text, "GUILD")
					elseif requestedItem == "Button8Value" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button8Value:" .. DGPButton8Value, "GUILD")
					elseif requestedItem == "Button9Type" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button9Type:" .. DGPButton9Type, "GUILD")
					elseif requestedItem == "Button9Text" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button9Text:" .. DGPButton9Text, "GUILD")
					elseif requestedItem == "Button9Value" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button9Value:" .. DGPButton9Value, "GUILD")
					elseif requestedItem == "Button10Type" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button10Type:" .. DGPButton10Type, "GUILD")
					elseif requestedItem == "Button10Text" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button10Text:" .. DGPButton10Text, "GUILD")
					elseif requestedItem == "Button10Value" then
						SendAddonMessage("dgpUpdateReply", sender .. ":Button10Value:" .. DGPButton10Value, "GUILD")
					end -- end if (Switch)
				end -- end if
				
			end -- end if (dgpRequest)
			
			
			-- If it is an update reply message
			if prefix == "dgpUpdateReply" then
				
				-- Split the receiver item being updated and item value
				requestedFrom, requestedItem, itemValue = strsplit(":", msg, 3)
				
				-- Check this update is for this player
				if requestedFrom == dgpPlayerName then
				
					-- Check the update is from the approved updater
					if sender == dgpUpdating then
				
						-- Stop the awaiting update cancel (0 delay = cancel)
						dgp_wait(0, dgpCancelUpdate)
						
						-- Update the item and send the next request
						if requestedItem == "Button1Type" then
							dgpSideMenuDropbox1ChangeValue(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button1Text", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button1Text" then
							dgp_Side_Frame_Editbox1_1:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button1Value", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button1Value" then
							dgp_Side_Frame_Editbox1_2:SetText(itemValue)		
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button2Type", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button2Type" then
							dgpSideMenuDropbox2ChangeValue(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button2Text", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button2Text" then
							dgp_Side_Frame_Editbox2_1:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button2Value", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button2Value" then
							dgp_Side_Frame_Editbox2_2:SetText(itemValue)		
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button3Type", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button3Type" then
							dgpSideMenuDropbox3ChangeValue(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button3Text", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button3Text" then
							dgp_Side_Frame_Editbox3_1:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button3Value", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button3Value" then
							dgp_Side_Frame_Editbox3_2:SetText(itemValue)		
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button4Type", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button4Type" then
							dgpSideMenuDropbox4ChangeValue(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button4Text", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button4Text" then
							dgp_Side_Frame_Editbox4_1:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button4Value", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button4Value" then
							dgp_Side_Frame_Editbox4_2:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button5Type", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button5Type" then
							dgpSideMenuDropbox5ChangeValue(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button5Text", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button5Text" then
							dgp_Side_Frame_Editbox5_1:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button5Value", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button5Value" then
							dgp_Side_Frame_Editbox5_2:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button6Type", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button6Type" then
							dgpSideMenuDropbox6ChangeValue(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button6Text", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button6Text" then
							dgp_Side_Frame_Editbox6_1:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button6Value", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button6Value" then
							dgp_Side_Frame_Editbox6_2:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button7Type", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button7Type" then
							dgpSideMenuDropbox7ChangeValue(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button7Text", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button7Text" then
							dgp_Side_Frame_Editbox7_1:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button7Value", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button7Value" then
							dgp_Side_Frame_Editbox7_2:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button8Type", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button8Type" then
							dgpSideMenuDropbox8ChangeValue(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button8Text", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button8Text" then
							dgp_Side_Frame_Editbox8_1:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button8Value", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button8Value" then
							dgp_Side_Frame_Editbox8_2:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button9Type", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button9Type" then
							dgpSideMenuDropbox9ChangeValue(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button9Text", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button9Text" then
							dgp_Side_Frame_Editbox9_1:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button9Value", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button9Value" then
							dgp_Side_Frame_Editbox9_2:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button10Type", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button10Type" then
							dgpSideMenuDropbox10ChangeValue(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button10Text", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button10Text" then
							dgp_Side_Frame_Editbox10_1:SetText(itemValue)
							SendAddonMessage("dgpRequest", dgpUpdating .. ":Button10Value", "GUILD")
							dgp_wait(30, dgpCancelUpdate) -- Cancel the update if there is no reply in 30s
						elseif requestedItem == "Button10Value" then
							dgp_Side_Frame_Editbox10_2:SetText(itemValue)
							
							-- Stop updating
							dgpUpdating = "closed"
							dgpTempUpdateTime = "0"
							dgpTempUpdateOriginator = "default"
							
							-- Now update the side button details
							dgp_wait(1, dgpApplyChanges)
							
						end -- end if (Switch)
						
					end -- end if
				end -- end if
				
			end -- end if (dgpUpdateReply)
			
		end -- end if
	end -- end if
	
end -- dgp_Side_Frame:OnEvent

dgp_Side_Frame:SetScript("OnEvent", dgp_Side_Frame.OnEvent) -- Call the previous function when an event is triggered for the side frame
	
-- SLASH COMMANDS

-- Create and register slash commands
SLASH_GUILDPOINTS1 = "/dgp" -- Define a slash command to be used in game

-- Define what the slash command does (Not sure how it links to the slash command yet)
function SlashCmdList.GUILDPOINTS(msg)
	dgp_Frame:Show() -- Show the addon window
end -- SlashCmdList.GUILDPOINTS


-- FUNCTIONS

-- This function updates the frame sizes and positions
function dgp_Resize_Frames()
	-- Size and position the  main frame
	dgp_Frame:SetWidth(DGPWidth) -- Parent frame width
	dgp_Frame:SetHeight(DGPHeight) -- Parent frame height
	dgp_Frame:SetPoint("BOTTOM", 0, DGPBottomOffset) -- Offset the parent frame from the top of the screen
	dgp_Frame:SetPoint("LEFT", DGPLeftOffset, 0) -- Offset the parent frame from the left of the screen
		
		-- Size and position the fade frame (Covers the bottom frame)
		dgp_Parent = dgp_Fade_Frame:GetParent() -- Hold a pointer to the parent frame
		dgp_Fade_Frame:SetWidth(dgp_Parent:GetWidth() - 10) -- Fade frame width
		dgp_Fade_Frame:SetHeight(dgp_Parent:GetHeight() - 30) -- Fade frame height
		dgp_Fade_Frame:SetPoint("TOP", 0, -25) -- Position to exclude the title frame
		dgp_Fade_Frame:SetPoint("LEFT", 5, 0) -- Position to exclude the side borders
		
		-- Size and position the title frame (Top-left of the main frame)
		dgp_Parent = dgp_Title_Frame:GetParent() -- Hold a pointer to the parent frame
		dgp_Title_Frame:SetWidth(dgp_Parent:GetWidth() - 42) -- Title frame width 10 pixels less than the parent frame
		dgp_Title_Frame:SetHeight(25) -- Title frame height 1/10 of the parent frame
		dgp_Title_Frame:SetPoint("TOP", 0, 0) -- Position flush with the top of the parent frame
		dgp_Title_Frame:SetPoint("LEFT", 0, 0) -- Position flush with the left side
		
		-- Size and Position the expand side frame button
		dgp_Parent = dgp_Expand_SideMenu_Button:GetParent()
		dgp_Expand_SideMenu_Button:SetWidth(25) -- Close button width is 25
		dgp_Expand_SideMenu_Button:SetHeight(25) -- Close button height is 25
		dgp_Expand_SideMenu_Button:SetPoint("TOPRIGHT", -22, 0) -- Position a button away from the top right corner
		
		-- Size and position the close button (Top-Right of the main frame)
		dgp_Parent = dgp_Close_Button:GetParent() -- Hold a pointer to the parent frame
		dgp_Close_Button:SetWidth(25) -- Close button width is 25
		dgp_Close_Button:SetHeight(25) -- Close button height is 25
		dgp_Close_Button:SetPoint("TOPRIGHT", 0, 0) -- Position flush with the top right of the parent frame
		
		-- Size and position the bottom frame (Everything below the title frame on the main frame
		dgp_Parent = dgp_Bottom_Frame:GetParent() -- Hold a pointer to the parent frame
		dgp_Bottom_Frame:SetWidth(dgp_Parent:GetWidth()) -- Bottom frame is the same width as the parent frame
		dgp_Bottom_Frame:SetHeight(dgp_Parent:GetHeight() - dgp_Title_Frame:GetHeight() + 5) -- Height is the same as the parent frame minus the title height
		dgp_Bottom_Frame:SetPoint("BOTTOM", 0, 0) -- Position flush with the bottom of the parent frame
		dgp_Bottom_Frame:SetPoint("LEFT", 0, 0) -- Postion flush with the left of the parent frame
		
			-- Size and position the filter editbox (Top right of the bottom frame)
			dgp_Parent = dgp_Filter_Editbox:GetParent() -- Hold a pointer to the parent frame
			dgp_Filter_Editbox:SetWidth(dgp_Parent:GetWidth() - 110) -- Filter editbox is 110 pixels less across than the parent frame
			dgp_Filter_Editbox:SetHeight(25) -- Filter editbox height is 25 pixels
			dgp_Filter_Editbox:SetPoint("TOP", 0, -5) -- Position 5 pixels from the top of the bottom frame
			dgp_Filter_Editbox:SetPoint("RIGHT", -5, 0) -- Position 5 pixels from the right of the bottom frame
			
			-- Size and position the filter editbox label (Left of the filter editbox)
			dgp_Parent = dgp_Filter_Editbox_Label:GetParent() -- Hold a pointer to the parent frame
			dgp_Filter_Editbox_Label:SetWidth(100) -- Filter editbox label width is 100 pixels
			dgp_Filter_Editbox_Label:SetHeight(25) -- Filter editbox label height is 25 pixels
			dgp_Filter_Editbox_Label:SetPoint("TOP", 0, -5) -- Position 5 pixels from the top of the bottom frame
			dgp_Filter_Editbox_Label:SetPoint("LEFT", 5, 0) -- Position 5 pixels from the left of the bottom frame
			
			-- Size and position the filter dropbox (Beneath the filter editbox)
			dgp_Parent = dgp_Filter_Dropbox:GetParent() -- Hold a pointer to the parent frame
			UIDropDownMenu_SetWidth(dgp_Filter_Dropbox, dgp_Parent:GetWidth() - 128) -- Set the dropbox width
			UIDropDownMenu_SetButtonWidth(dgp_Filter_Dropbox, dgp_Parent:GetWidth() - 113) -- Set the dropbox button width
			dgp_Filter_Dropbox:SetWidth(dgp_Parent:GetWidth() - 110) -- Filter dropbox is the same size as the editbox
			dgp_Filter_Dropbox:SetHeight(25) -- Filter dropbox height is 25 pixels
			dgp_Filter_Dropbox:SetPoint("TOP", 0, -30 ) -- Position 5 pixels below the editbox
			dgp_Filter_Dropbox:SetPoint("RIGHT", -22, 0) -- Position 5 pixels from the right of the bottom frame
			
			-- Size and position the filter dropbox label (Left of the filter editbox)
			dgp_Parent = dgp_Filter_Dropbox_Label:GetParent() -- Hold a pointer to the parent frame
			dgp_Filter_Dropbox_Label:SetWidth(100) -- Filter dropbox label width is 100 pixels
			dgp_Filter_Dropbox_Label:SetHeight(25) -- Filter dropbox label height is 25 pixels
			dgp_Filter_Dropbox_Label:SetPoint("TOP", 0, -30) -- Position 5 pixels from the top of the bottom frame
			dgp_Filter_Dropbox_Label:SetPoint("LEFT", 5, 0) -- Position 5 pixels from the left of the bottom frame
			
			-- Size and position the player listbox (Beneath the filter dropbox to the left side of the frame)
			dgp_Parent = dgp_Player_Listbox:GetParent() -- Hold a pointer to the parent frame
			dgp_Player_Listbox:SetWidth(dgp_Parent:GetWidth() * 2/3) -- Player listbox is 2/3 the width of the bottom frame
			dgp_Player_Listbox:SetHeight(dgp_Parent:GetHeight() - 65) -- Player listboxtakes up the remaining height of the bottom frame
			dgp_Player_Listbox:SetPoint("TOP", 0, -60) -- Position 5 pixels below the filter dropbox
			dgp_Player_Listbox:SetPoint("LEFT", 5, 0) -- Position 5 pixels from the left of the bottom frame
			
				-- Size and postion the player listbox buttons
				dgp_Parent = dgp_Player_Listbox_Button1_1:GetParent()
				
				dgp_Player_Listbox_Button1_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button1_1:SetHeight(16)
				dgp_Player_Listbox_Button1_1:SetPoint("TOPLEFT", 4, -8)
				dgp_Player_Listbox_Button1_1:Hide()
				dgp_Player_Listbox_Button1_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button1_2:SetHeight(16)
				dgp_Player_Listbox_Button1_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button1_1:GetWidth() + 4, -8)
				dgp_Player_Listbox_Button1_2:Hide()
				
				dgp_Player_Listbox_Button2_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button2_1:SetHeight(16)
				dgp_Player_Listbox_Button2_1:SetPoint("TOPLEFT", 4, -28)
				dgp_Player_Listbox_Button2_1:Hide()
				dgp_Player_Listbox_Button2_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button2_2:SetHeight(16)
				dgp_Player_Listbox_Button2_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button2_1:GetWidth() + 4, -28)
				dgp_Player_Listbox_Button2_2:Hide()
				
				dgp_Player_Listbox_Button3_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button3_1:SetHeight(16)
				dgp_Player_Listbox_Button3_1:SetPoint("TOPLEFT", 4, -48)
				dgp_Player_Listbox_Button3_1:Hide()
				dgp_Player_Listbox_Button3_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button3_2:SetHeight(16)
				dgp_Player_Listbox_Button3_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button3_1:GetWidth() + 4, -48)
				dgp_Player_Listbox_Button3_2:Hide()
				
				dgp_Player_Listbox_Button4_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button4_1:SetHeight(16)
				dgp_Player_Listbox_Button4_1:SetPoint("TOPLEFT", 4, -68)
				dgp_Player_Listbox_Button4_1:Hide()
				dgp_Player_Listbox_Button4_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button4_2:SetHeight(16)
				dgp_Player_Listbox_Button4_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button4_1:GetWidth() + 4, -68)
				dgp_Player_Listbox_Button4_2:Hide()
				
				dgp_Player_Listbox_Button5_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button5_1:SetHeight(16)
				dgp_Player_Listbox_Button5_1:SetPoint("TOPLEFT", 4, -88)
				dgp_Player_Listbox_Button5_1:Hide()
				dgp_Player_Listbox_Button5_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button5_2:SetHeight(16)
				dgp_Player_Listbox_Button5_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button5_1:GetWidth() + 4, -88)
				dgp_Player_Listbox_Button5_2:Hide()
				
				dgp_Player_Listbox_Button6_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button6_1:SetHeight(16)
				dgp_Player_Listbox_Button6_1:SetPoint("TOPLEFT", 4, -108)
				dgp_Player_Listbox_Button6_1:Hide()
				dgp_Player_Listbox_Button6_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button6_2:SetHeight(16)
				dgp_Player_Listbox_Button6_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button6_1:GetWidth() + 4, -108)
				dgp_Player_Listbox_Button6_2:Hide()
				
				dgp_Player_Listbox_Button7_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button7_1:SetHeight(16)
				dgp_Player_Listbox_Button7_1:SetPoint("TOPLEFT", 4, -128)
				dgp_Player_Listbox_Button7_1:Hide()
				dgp_Player_Listbox_Button7_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button7_2:SetHeight(16)
				dgp_Player_Listbox_Button7_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button7_1:GetWidth() + 4, -128)
				dgp_Player_Listbox_Button7_2:Hide()
				
				dgp_Player_Listbox_Button8_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button8_1:SetHeight(16)
				dgp_Player_Listbox_Button8_1:SetPoint("TOPLEFT", 4, -148)
				dgp_Player_Listbox_Button8_1:Hide()
				dgp_Player_Listbox_Button8_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button8_2:SetHeight(16)
				dgp_Player_Listbox_Button8_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button8_1:GetWidth() + 4, -148)
				dgp_Player_Listbox_Button8_2:Hide()
				
				dgp_Player_Listbox_Button9_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button9_1:SetHeight(16)
				dgp_Player_Listbox_Button9_1:SetPoint("TOPLEFT", 4, -168)
				dgp_Player_Listbox_Button9_1:Hide()
				dgp_Player_Listbox_Button9_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button9_2:SetHeight(16)
				dgp_Player_Listbox_Button9_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button9_1:GetWidth() + 4, -168)
				dgp_Player_Listbox_Button9_2:Hide()
				
				dgp_Player_Listbox_Button10_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button10_1:SetHeight(16)
				dgp_Player_Listbox_Button10_1:SetPoint("TOPLEFT", 4, -188)
				dgp_Player_Listbox_Button10_1:Hide()
				dgp_Player_Listbox_Button10_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button10_2:SetHeight(16)
				dgp_Player_Listbox_Button10_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button10_1:GetWidth() + 4, -188)
				dgp_Player_Listbox_Button10_2:Hide()
				
				dgp_Player_Listbox_Button11_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button11_1:SetHeight(16)
				dgp_Player_Listbox_Button11_1:SetPoint("TOPLEFT", 4, -208)
				dgp_Player_Listbox_Button11_1:Hide()
				dgp_Player_Listbox_Button11_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button11_2:SetHeight(16)
				dgp_Player_Listbox_Button11_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button11_1:GetWidth() + 4, -208)
				dgp_Player_Listbox_Button11_2:Hide()
				
				dgp_Player_Listbox_Button12_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button12_1:SetHeight(16)
				dgp_Player_Listbox_Button12_1:SetPoint("TOPLEFT", 4, -228)
				dgp_Player_Listbox_Button12_1:Hide()
				dgp_Player_Listbox_Button12_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button12_2:SetHeight(16)
				dgp_Player_Listbox_Button12_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button12_1:GetWidth() + 4, -228)
				dgp_Player_Listbox_Button12_2:Hide()
				
				dgp_Player_Listbox_Button13_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button13_1:SetHeight(16)
				dgp_Player_Listbox_Button13_1:SetPoint("TOPLEFT", 4, -248)
				dgp_Player_Listbox_Button13_1:Hide()
				dgp_Player_Listbox_Button13_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button13_2:SetHeight(16)
				dgp_Player_Listbox_Button13_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button13_1:GetWidth() + 4, -248)
				dgp_Player_Listbox_Button13_2:Hide()
				
				dgp_Player_Listbox_Button14_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button14_1:SetHeight(16)
				dgp_Player_Listbox_Button14_1:SetPoint("TOPLEFT", 4, -268)
				dgp_Player_Listbox_Button14_1:Hide()
				dgp_Player_Listbox_Button14_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button14_2:SetHeight(16)
				dgp_Player_Listbox_Button14_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button14_1:GetWidth() + 4, -268)
				dgp_Player_Listbox_Button14_2:Hide()
				
				dgp_Player_Listbox_Button15_1:SetWidth((dgp_Parent:GetWidth() - 8)*2/3)
				dgp_Player_Listbox_Button15_1:SetHeight(16)
				dgp_Player_Listbox_Button15_1:SetPoint("TOPLEFT", 4, -288)
				dgp_Player_Listbox_Button15_1:Hide()
				dgp_Player_Listbox_Button15_2:SetWidth((dgp_Parent:GetWidth() - 8)/3)
				dgp_Player_Listbox_Button15_2:SetHeight(16)
				dgp_Player_Listbox_Button15_2:SetPoint("TOPLEFT", dgp_Player_Listbox_Button15_1:GetWidth() + 4, -288)
				dgp_Player_Listbox_Button15_2:Hide()
			
			-- Size and position the Listbox Scrollbar to the right of the listbox
			dgp_Parent = dgp_Player_Listbox_Slider:GetParent() -- Hold a pointer to the parent frame
			dgp_Player_Listbox_Slider:SetWidth(16) -- Set the width to 16 pixels
			dgp_Player_Listbox_Slider:SetHeight(dgp_Player_Listbox:GetHeight() + 4) -- Set the height to the same as the listbox (visually)
			dgp_Player_Listbox_Slider:SetPoint("TOP", 0, -58) -- Position 5 pixels below the filter dropbox
			dgp_Player_Listbox_Slider:SetPoint("LEFT", dgp_Player_Listbox:GetWidth() + 3, 0) -- Position 5 pixels from the left of the bottom frame
			
			-- Size and position the Button Frame to the bottom left of the Bottom Frame
			dgp_Parent = dgp_Button_Frame:GetParent() -- Hold a pointer to the parent frame
			dgp_Button_Frame:SetWidth(dgp_Parent:GetWidth() - dgp_Player_Listbox:GetWidth() - dgp_Player_Listbox_Slider:GetWidth() - 8) -- The remaining width of the bottom frame
			dgp_Button_Frame:SetHeight(dgp_Player_Listbox:GetHeight()) -- Same height as the listbox
			dgp_Button_Frame:SetPoint("TOP", 0, -60) -- Same as the listbox
			dgp_Button_Frame:SetPoint("RIGHT", -5, 0) -- 5 Pixels from the right
			
				-- Size and postion the button frame buttons
				dgp_Parent = dgp_Side_Button1:GetParent()
				
				dgp_Side_Button1:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Side_Button1:SetHeight(16)
				dgp_Side_Button1:SetPoint("TOPLEFT", 7, -5)
				
				dgp_Side_Button2:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Side_Button2:SetHeight(16)
				dgp_Side_Button2:SetPoint("TOPLEFT", 7, -25)
				
				dgp_Side_Button3:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Side_Button3:SetHeight(16)
				dgp_Side_Button3:SetPoint("TOPLEFT", 7, -45)
				
				dgp_Side_Button4:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Side_Button4:SetHeight(16)
				dgp_Side_Button4:SetPoint("TOPLEFT", 7, -65)
				
				dgp_Side_Button5:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Side_Button5:SetHeight(16)
				dgp_Side_Button5:SetPoint("TOPLEFT", 7, -85)
				
				dgp_Side_Button6:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Side_Button6:SetHeight(16)
				dgp_Side_Button6:SetPoint("TOPLEFT", 7, -105)
				
				dgp_Side_Button7:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Side_Button7:SetHeight(16)
				dgp_Side_Button7:SetPoint("TOPLEFT", 7, -125)
				
				dgp_Side_Button8:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Side_Button8:SetHeight(16)
				dgp_Side_Button8:SetPoint("TOPLEFT", 7, -145)
				
				dgp_Side_Button9:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Side_Button9:SetHeight(16)
				dgp_Side_Button9:SetPoint("TOPLEFT", 7, -165)
				
				dgp_Side_Button10:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Side_Button10:SetHeight(16)
				dgp_Side_Button10:SetPoint("TOPLEFT", 7, -185)
				
				dgp_Button_Standard_Title:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Button_Standard_Title:SetHeight(16)
				dgp_Button_Standard_Title:SetPoint("TOPLEFT", 7, -205)
				
				dgp_Button_Backup:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Button_Backup:SetHeight(16)
				dgp_Button_Backup:SetPoint("TOPLEFT", 7, -225)
			
				dgp_Editbox_GP:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Editbox_GP:SetHeight(21)
				dgp_Editbox_GP:SetPoint("TOPLEFT", 7, -245)
				
				dgp_Button_Add:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Button_Add:SetHeight(16)
				dgp_Button_Add:SetPoint("TOPLEFT", 7, -270)
				
				dgp_Button_Subtract:SetWidth(dgp_Parent:GetWidth() - 14)
				dgp_Button_Subtract:SetHeight(16)
				dgp_Button_Subtract:SetPoint("TOPLEFT", 7, -290)
				
	dgpResizeBackupConfirm()
	
	dgpResizeSideMenu()	
	
end -- dgp_Resize_Frames


function dgpResizeBackupConfirm()
	-- Size and position the Backup Confirmation box
	dgp_Parent = dgp_Confirm_Backup:GetParent()
	dgp_Confirm_Backup:SetWidth(dgp_Parent:GetWidth() - 50)
	dgp_Confirm_Backup:SetHeight(90)
	dgp_Confirm_Backup:SetPoint("BOTTOMLEFT",  dgp_Parent:GetWidth()/2 - dgp_Confirm_Backup:GetWidth()/2,
		dgp_Parent:GetHeight()/2 - dgp_Confirm_Backup:GetHeight()/2)
			
		-- Size and position the Backup Confirmation box
		dgp_Parent = dgp_Confirm_Backup_Title:GetParent()
		dgp_Confirm_Backup_Title:SetWidth(dgp_Parent:GetWidth() - 10)
		dgp_Confirm_Backup_Title:SetHeight(dgp_Parent:GetHeight() - 40)
		dgp_Confirm_Backup_Title:SetPoint("TOPLEFT",  5, -5)
				
		-- Size and position the Backup Confirmation Accept button
		dgp_Parent = dgp_Confirm_Backup_Accept:GetParent()
		dgp_Confirm_Backup_Accept:SetWidth(100)
		dgp_Confirm_Backup_Accept:SetHeight(16)
		dgp_Confirm_Backup_Accept:SetPoint("TOPLEFT",  dgp_Parent:GetWidth()/2 - 125, -60)
			
		-- Size and position the Backup Confirmation Accept button
		dgp_Parent = dgp_Confirm_Backup_Cancel:GetParent()
		dgp_Confirm_Backup_Cancel:SetWidth(100)
		dgp_Confirm_Backup_Cancel:SetHeight(16)
		dgp_Confirm_Backup_Cancel:SetPoint("TOPLEFT",  dgp_Parent:GetWidth()/2 + 25, -60)
		
end -- dgpResizeBackupConfirm


function dgpResizeSideMenu()
	-- Size and position the title frames
	dgpResizeSideMenuTitle()
		
	-- Size and position the honorary frames
	dgpResizeSideMenuHonorary()
		
	-- Size and position the button editing frames
	dgpResizeSideMenuButtons()
		
	-- Size and position the backup frames
	dgpResizeSideMenuBackup()

end -- dgpResizeSideMenu


-- Size and position the title frames of the side menu
function dgpResizeSideMenuTitle()
	-- Size and position the Guild Leader side frame
	dgp_Parent = dgp_Side_Frame:GetParent()
	dgp_Side_Frame:SetWidth(257) -- Static width of 257 pixels
	dgp_Side_Frame:SetHeight(dgp_Parent:GetHeight()) -- Same Height as the base frame
	dgp_Side_Frame:SetPoint("TOP", 0, 0) -- Flush with the top of the base
	dgp_Side_Frame:SetPoint("RIGHT", dgp_Side_Frame:GetWidth()-3, 0) -- Positioned to the right of the main frame
	
		-- Size and position the fade frame (Covers the bottom frame)
		dgp_Parent = dgp_SideMenu_Fade_Frame:GetParent() -- Hold a pointer to the parent frame
		dgp_SideMenu_Fade_Frame:SetWidth(dgp_Parent:GetWidth() - 10) -- Fade frame width
		dgp_SideMenu_Fade_Frame:SetHeight(dgp_Parent:GetHeight() - 30) -- Fade frame height
		dgp_SideMenu_Fade_Frame:SetPoint("TOP", 0, -25) -- Position to exclude the title frame
		dgp_SideMenu_Fade_Frame:SetPoint("LEFT", 5, 0) -- Positionto exclude the side borders
		
		-- Size and position the side frame title frame		
		dgp_Parent = dgp_SideMenu_Title_Frame:GetParent() -- Hold a pointer to the parent frame
		dgp_SideMenu_Title_Frame:SetWidth(dgp_Parent:GetWidth() - 20) -- Title frame width 10 pixels less than the parent frame
		dgp_SideMenu_Title_Frame:SetHeight(25) -- Title frame height 1/10 of the parent frame
		dgp_SideMenu_Title_Frame:SetPoint("TOPLEFT", 0, 0) -- Position flush with the top left of the parent frame
		
		-- Size and position the minimize button
		dgp_Parent = dgp_SideMenu_Minimize_Button:GetParent() -- Hold a pointer to the parent frame
		dgp_SideMenu_Minimize_Button:SetWidth(25) -- Close button width is 25
		dgp_SideMenu_Minimize_Button:SetHeight(25) -- Close button height is 25
		dgp_SideMenu_Minimize_Button:SetPoint("TOPRIGHT", 0, 0) -- Position flush with the topright of the parent frame
		
end -- dgpResizeSideMenuTitle


-- Size and position the honorary frames in the side menu
function dgpResizeSideMenuHonorary()
	-- Size and position the side frame honorary title
	dgp_Parent = dgp_SideMenu_Honorary_Title:GetParent()
	dgp_SideMenu_Honorary_Title:SetWidth(dgp_Parent:GetWidth()-14)
	dgp_SideMenu_Honorary_Title:SetHeight(16)
	dgp_SideMenu_Honorary_Title:SetPoint("TOPLEFT", 7, -25)
	
	-- Size and position the side frame honorary label		
	dgp_Parent = dgp_Side_Frame_Honorary_Label:GetParent() -- Hold a pointer to the parent frame
	dgp_Side_Frame_Honorary_Label:SetWidth(dgp_Parent:GetWidth() - 100) -- Title frame width 10 pixels less than the parent frame
	dgp_Side_Frame_Honorary_Label:SetHeight(25) -- Title frame height 1/10 of the parent frame
	dgp_Side_Frame_Honorary_Label:SetPoint("TOPLEFT", 7, -40) -- Position flush with the top left of the parent frame
		
	-- Size and position the side frame honorary editbox
	dgp_Parent = dgp_Side_Frame_Honorary_Editbox:GetParent()
	dgp_Side_Frame_Honorary_Editbox:SetWidth(88)
	dgp_Side_Frame_Honorary_Editbox:SetHeight(16)
	dgp_Side_Frame_Honorary_Editbox:SetPoint("TOPRIGHT", -7, -45)
	
	-- Size and position the side frame honorary buttons
	dgp_Parent = dgp_SideMenu_Add_Honorary_Button:GetParent()
	dgp_SideMenu_Add_Honorary_Button:SetWidth(dgp_Parent:GetWidth()/2 - 20)
	dgp_SideMenu_Add_Honorary_Button:SetHeight(16)
	dgp_SideMenu_Add_Honorary_Button:SetPoint("TOPLEFT", 7, -65)
	
	dgp_Parent = dgp_SideMenu_Remove_Honorary_Button:GetParent()
	dgp_SideMenu_Remove_Honorary_Button:SetWidth(dgp_Parent:GetWidth()/2 + 2)
	dgp_SideMenu_Remove_Honorary_Button:SetHeight(16)
	dgp_SideMenu_Remove_Honorary_Button:SetPoint("TOPLEFT", dgp_SideMenu_Add_Honorary_Button:GetWidth() + 10, -65)
	
	-- Size and position the side frame honorary confirm frame
	dgp_Parent = dgp_SideMenu_Confirm_Remove_Honorary:GetParent()
	dgp_SideMenu_Confirm_Remove_Honorary:SetWidth(dgp_Parent:GetWidth() - 50)
	dgp_SideMenu_Confirm_Remove_Honorary:SetHeight(100)
	dgp_SideMenu_Confirm_Remove_Honorary:SetPoint("BOTTOMLEFT",  dgp_Parent:GetWidth()/2 - dgp_SideMenu_Confirm_Remove_Honorary:GetWidth()/2,
		dgp_Parent:GetHeight()/2 - dgp_SideMenu_Confirm_Remove_Honorary:GetHeight()/2)
			
		-- Size and position the Restore Confirmation box
		dgp_Parent = dgp_SideMenu_Confirm_Remove_Honorary_Title:GetParent()
		dgp_SideMenu_Confirm_Remove_Honorary_Title:SetWidth(dgp_Parent:GetWidth() - 50)
		dgp_SideMenu_Confirm_Remove_Honorary_Title:SetHeight(dgp_Parent:GetHeight() - 50)
		dgp_SideMenu_Confirm_Remove_Honorary_Title:SetPoint("TOPLEFT",  25, 0)
		
		-- Size and position the Restore Confirmation Accept button
		dgp_Parent = dgp_SideMenu_Confirm_Remove_Honorary_Accept:GetParent()
		dgp_SideMenu_Confirm_Remove_Honorary_Accept:SetWidth(100)
		dgp_SideMenu_Confirm_Remove_Honorary_Accept:SetHeight(16)
		dgp_SideMenu_Confirm_Remove_Honorary_Accept:SetPoint("TOPLEFT",  dgp_Parent:GetWidth()/2 - 50, -45)
		
		-- Size and position the Restore Confirmation Accept button
		dgp_Parent = dgp_SideMenu_Confirm_Remove_Honorary_Cancel:GetParent()
		dgp_SideMenu_Confirm_Remove_Honorary_Cancel:SetWidth(100)
		dgp_SideMenu_Confirm_Remove_Honorary_Cancel:SetHeight(16)
		dgp_SideMenu_Confirm_Remove_Honorary_Cancel:SetPoint("TOPLEFT",  dgp_Parent:GetWidth()/2 - 50, -65)
end -- dgpResizeSideMenuHonorary()


-- Size and position the button editingframes in the side menu
function dgpResizeSideMenuButtons()
	-- Size and position the seperater
	dgp_Parent = dgp_SideMenu_Buttons_Seperater:GetParent()
	dgp_SideMenu_Buttons_Seperater:SetWidth(dgp_Parent:GetWidth() - 14)
	dgp_SideMenu_Buttons_Seperater:SetHeight(2)
	dgp_SideMenu_Buttons_Seperater:SetPoint("TOPLEFT", 7, -87)
	
	-- Size and position the side frame column headings
	dgp_Parent = dgp_SideMenu_Type_Title:GetParent()
	
	dgp_SideMenu_Type_Title:SetWidth(dgp_Side_Button1:GetWidth())
	dgp_SideMenu_Type_Title:SetHeight(16)
	dgp_SideMenu_Type_Title:SetPoint("TOPLEFT", 7, -90)
		
	dgp_SideMenu_Name_Title:SetWidth(dgp_Side_Button1:GetWidth())
	dgp_SideMenu_Name_Title:SetHeight(16)
	dgp_SideMenu_Name_Title:SetPoint("TOPLEFT", 7 + dgp_SideMenu_Type_Title:GetWidth(), -90)
		
	dgp_SideMenu_Value_Title:SetWidth(dgp_Side_Button1:GetWidth()/2)
	dgp_SideMenu_Value_Title:SetHeight(16)
	dgp_SideMenu_Value_Title:SetPoint("TOPLEFT", 7 + dgp_SideMenu_Type_Title:GetWidth() + dgp_SideMenu_Name_Title:GetWidth(), -90)
		
	-- Size and position the side frame dropboxes
	dgp_Parent = dgp_SideMenu_Dropbox1:GetParent()
		
	UIDropDownMenu_SetWidth(dgp_SideMenu_Dropbox1, 75)
	UIDropDownMenu_SetButtonWidth(dgp_SideMenu_Dropbox1, 75)
	dgp_SideMenu_Dropbox1:SetWidth(dgp_Side_Button1:GetWidth())
	dgp_SideMenu_Dropbox1:SetHeight(25)
	dgp_SideMenu_Dropbox1:SetPoint("TOPLEFT", -10, -105)
		
	UIDropDownMenu_SetWidth(dgp_SideMenu_Dropbox2, 75)
	UIDropDownMenu_SetButtonWidth(dgp_SideMenu_Dropbox2, 75)
	dgp_SideMenu_Dropbox2:SetWidth(dgp_Side_Button2:GetWidth())
	dgp_SideMenu_Dropbox2:SetHeight(25)
	dgp_SideMenu_Dropbox2:SetPoint("TOPLEFT", -10, -125)
		
	UIDropDownMenu_SetWidth(dgp_SideMenu_Dropbox3, 75)
	UIDropDownMenu_SetButtonWidth(dgp_SideMenu_Dropbox3, 75)
	dgp_SideMenu_Dropbox3:SetWidth(dgp_Side_Button3:GetWidth())
	dgp_SideMenu_Dropbox3:SetHeight(25)
	dgp_SideMenu_Dropbox3:SetPoint("TOPLEFT", -10, -145)
		
	UIDropDownMenu_SetWidth(dgp_SideMenu_Dropbox4, 75)
	UIDropDownMenu_SetButtonWidth(dgp_SideMenu_Dropbox4, 75)
	dgp_SideMenu_Dropbox4:SetWidth(dgp_Side_Button4:GetWidth())
	dgp_SideMenu_Dropbox4:SetHeight(25)
	dgp_SideMenu_Dropbox4:SetPoint("TOPLEFT", -10, -165)
		
	UIDropDownMenu_SetWidth(dgp_SideMenu_Dropbox5, 75)
	UIDropDownMenu_SetButtonWidth(dgp_SideMenu_Dropbox5, 75)
	dgp_SideMenu_Dropbox5:SetWidth(dgp_Side_Button5:GetWidth())
	dgp_SideMenu_Dropbox5:SetHeight(25)
	dgp_SideMenu_Dropbox5:SetPoint("TOPLEFT", -10, -185)
		
	UIDropDownMenu_SetWidth(dgp_SideMenu_Dropbox6, 75)
	UIDropDownMenu_SetButtonWidth(dgp_SideMenu_Dropbox6, 75)
	dgp_SideMenu_Dropbox6:SetWidth(dgp_Side_Button6:GetWidth())
	dgp_SideMenu_Dropbox6:SetHeight(25)
	dgp_SideMenu_Dropbox6:SetPoint("TOPLEFT", -10, -205)
		
	UIDropDownMenu_SetWidth(dgp_SideMenu_Dropbox7, 75)
	UIDropDownMenu_SetButtonWidth(dgp_SideMenu_Dropbox7, 75)
	dgp_SideMenu_Dropbox7:SetWidth(dgp_Side_Button7:GetWidth())
	dgp_SideMenu_Dropbox7:SetHeight(25)
	dgp_SideMenu_Dropbox7:SetPoint("TOPLEFT", -10, -225)
		
	UIDropDownMenu_SetWidth(dgp_SideMenu_Dropbox8, 75)
	UIDropDownMenu_SetButtonWidth(dgp_SideMenu_Dropbox8, 75)
	dgp_SideMenu_Dropbox8:SetWidth(dgp_Side_Button8:GetWidth())
	dgp_SideMenu_Dropbox8:SetHeight(25)
	dgp_SideMenu_Dropbox8:SetPoint("TOPLEFT", -10, -245)
		
	UIDropDownMenu_SetWidth(dgp_SideMenu_Dropbox9, 75)
	UIDropDownMenu_SetButtonWidth(dgp_SideMenu_Dropbox9, 75)
	dgp_SideMenu_Dropbox9:SetWidth(dgp_Side_Button9:GetWidth())
	dgp_SideMenu_Dropbox9:SetHeight(25)
	dgp_SideMenu_Dropbox9:SetPoint("TOPLEFT", -10, -265)
		
	UIDropDownMenu_SetWidth(dgp_SideMenu_Dropbox10, 75)
	UIDropDownMenu_SetButtonWidth(dgp_SideMenu_Dropbox10, 75)
	dgp_SideMenu_Dropbox10:SetWidth(dgp_Side_Button10:GetWidth())
	dgp_SideMenu_Dropbox10:SetHeight(25)
	dgp_SideMenu_Dropbox10:SetPoint("TOPLEFT", -10, -285)
		
	-- Size and position the side frame editboxes
	dgp_Parent = dgp_Side_Frame_Editbox1_1:GetParent()
	
	dgp_Side_Frame_Editbox1_1:SetWidth(dgp_Side_Button1:GetWidth())
	dgp_Side_Frame_Editbox1_1:SetHeight(16)
	dgp_Side_Frame_Editbox1_1:SetPoint("TOPLEFT", 102, -110)
	dgp_Side_Frame_Editbox1_2:SetWidth(dgp_Side_Button1:GetWidth()/2)
	dgp_Side_Frame_Editbox1_2:SetHeight(16)
	dgp_Side_Frame_Editbox1_2:SetPoint("TOPLEFT", 106 + dgp_Side_Frame_Editbox1_1:GetWidth(), -110)
	
	dgp_Side_Frame_Editbox2_1:SetWidth(dgp_Side_Button2:GetWidth())
	dgp_Side_Frame_Editbox2_1:SetHeight(16)
	dgp_Side_Frame_Editbox2_1:SetPoint("TOPLEFT",102, -130)
	dgp_Side_Frame_Editbox2_2:SetWidth(dgp_Side_Button2:GetWidth()/2)
	dgp_Side_Frame_Editbox2_2:SetHeight(16)
	dgp_Side_Frame_Editbox2_2:SetPoint("TOPLEFT", 106 + dgp_Side_Frame_Editbox2_1:GetWidth(), -130)
		
	dgp_Side_Frame_Editbox3_1:SetWidth(dgp_Side_Button3:GetWidth())
	dgp_Side_Frame_Editbox3_1:SetHeight(16)
	dgp_Side_Frame_Editbox3_1:SetPoint("TOPLEFT",102, -150)
	dgp_Side_Frame_Editbox3_2:SetWidth(dgp_Side_Button3:GetWidth()/2)
	dgp_Side_Frame_Editbox3_2:SetHeight(16)
	dgp_Side_Frame_Editbox3_2:SetPoint("TOPLEFT", 106 + dgp_Side_Frame_Editbox3_1:GetWidth(), -150)
		
	dgp_Side_Frame_Editbox4_1:SetWidth(dgp_Side_Button4:GetWidth())
	dgp_Side_Frame_Editbox4_1:SetHeight(16)
	dgp_Side_Frame_Editbox4_1:SetPoint("TOPLEFT",102, -170)
	dgp_Side_Frame_Editbox4_2:SetWidth(dgp_Side_Button4:GetWidth()/2)
	dgp_Side_Frame_Editbox4_2:SetHeight(16)
	dgp_Side_Frame_Editbox4_2:SetPoint("TOPLEFT", 106 + dgp_Side_Frame_Editbox4_1:GetWidth(), -170)
		
	dgp_Side_Frame_Editbox5_1:SetWidth(dgp_Side_Button5:GetWidth())
	dgp_Side_Frame_Editbox5_1:SetHeight(16)
	dgp_Side_Frame_Editbox5_1:SetPoint("TOPLEFT", 102, -190)
	dgp_Side_Frame_Editbox5_2:SetWidth(dgp_Side_Button5:GetWidth()/2)
	dgp_Side_Frame_Editbox5_2:SetHeight(16)
	dgp_Side_Frame_Editbox5_2:SetPoint("TOPLEFT", 106 + dgp_Side_Frame_Editbox5_1:GetWidth(), -190)
	
	dgp_Side_Frame_Editbox6_1:SetWidth(dgp_Side_Button6:GetWidth())
	dgp_Side_Frame_Editbox6_1:SetHeight(16)
	dgp_Side_Frame_Editbox6_1:SetPoint("TOPLEFT", 102, -210)
	dgp_Side_Frame_Editbox6_2:SetWidth(dgp_Side_Button6:GetWidth()/2)
	dgp_Side_Frame_Editbox6_2:SetHeight(16)
	dgp_Side_Frame_Editbox6_2:SetPoint("TOPLEFT", 106 + dgp_Side_Frame_Editbox6_1:GetWidth(), -210)
		
	dgp_Side_Frame_Editbox7_1:SetWidth(dgp_Side_Button7:GetWidth())
	dgp_Side_Frame_Editbox7_1:SetHeight(16)
	dgp_Side_Frame_Editbox7_1:SetPoint("TOPLEFT", 102, -230)
	dgp_Side_Frame_Editbox7_2:SetWidth(dgp_Side_Button7:GetWidth()/2)
	dgp_Side_Frame_Editbox7_2:SetHeight(16)
	dgp_Side_Frame_Editbox7_2:SetPoint("TOPLEFT", 106 + dgp_Side_Frame_Editbox7_1:GetWidth(), -230)
		
	dgp_Side_Frame_Editbox8_1:SetWidth(dgp_Side_Button8:GetWidth())
	dgp_Side_Frame_Editbox8_1:SetHeight(16)
	dgp_Side_Frame_Editbox8_1:SetPoint("TOPLEFT", 102, -250)
	dgp_Side_Frame_Editbox8_2:SetWidth(dgp_Side_Button8:GetWidth()/2)
	dgp_Side_Frame_Editbox8_2:SetHeight(16)
	dgp_Side_Frame_Editbox8_2:SetPoint("TOPLEFT", 106 + dgp_Side_Frame_Editbox8_1:GetWidth(), -250)
	
	dgp_Side_Frame_Editbox9_1:SetWidth(dgp_Side_Button9:GetWidth())
	dgp_Side_Frame_Editbox9_1:SetHeight(16)
	dgp_Side_Frame_Editbox9_1:SetPoint("TOPLEFT", 102, -270)
	dgp_Side_Frame_Editbox9_2:SetWidth(dgp_Side_Button9:GetWidth()/2)
	dgp_Side_Frame_Editbox9_2:SetHeight(16)
	dgp_Side_Frame_Editbox9_2:SetPoint("TOPLEFT", 106 + dgp_Side_Frame_Editbox9_1:GetWidth(), -270)
		
	dgp_Side_Frame_Editbox10_1:SetWidth(dgp_Side_Button10:GetWidth())
	dgp_Side_Frame_Editbox10_1:SetHeight(16)
	dgp_Side_Frame_Editbox10_1:SetPoint("TOPLEFT", 102, -290)
	dgp_Side_Frame_Editbox10_2:SetWidth(dgp_Side_Button10:GetWidth()/2)
	dgp_Side_Frame_Editbox10_2:SetHeight(16)
	dgp_Side_Frame_Editbox10_2:SetPoint("TOPLEFT", 106 + dgp_Side_Frame_Editbox10_1:GetWidth(), -290)
		
	-- Size and position the side frame apply button
	dgp_Parent = dgp_SideMenu_Apply_Button:GetParent()
	dgp_SideMenu_Apply_Button:SetWidth(dgp_Parent:GetWidth()/3-10)
	dgp_SideMenu_Apply_Button:SetHeight(16)
	dgp_SideMenu_Apply_Button:SetPoint("TOPLEFT", 9, -320)
	
	-- Size and position the side frame cancel button
	dgp_Parent = dgp_SideMenu_Cancel_Button:GetParent()
	dgp_SideMenu_Cancel_Button:SetWidth(dgp_Parent:GetWidth()/3-10)
	dgp_SideMenu_Cancel_Button:SetHeight(16)
	dgp_SideMenu_Cancel_Button:SetPoint("TOPLEFT", 15 + dgp_SideMenu_Apply_Button:GetWidth(), -320)
	
	-- Size and position the side frame default button
	dgp_Parent = dgp_SideMenu_Default_Button:GetParent()
	dgp_SideMenu_Default_Button:SetWidth(dgp_Parent:GetWidth()/3-10)
	dgp_SideMenu_Default_Button:SetHeight(16)
	dgp_SideMenu_Default_Button:SetPoint("TOPLEFT", 21 + dgp_SideMenu_Apply_Button:GetWidth() + dgp_SideMenu_Cancel_Button:GetWidth(), -320)
		
end -- dgpResizeSideMenuButtons


-- Size and position the backup frames of the side menu
function dgpResizeSideMenuBackup()
	-- Size and position the seperater
	dgp_Parent = dgp_SideMenu_Backup_Seperater:GetParent()
	dgp_SideMenu_Backup_Seperater:SetWidth(dgp_Parent:GetWidth() - 14)
	dgp_SideMenu_Backup_Seperater:SetHeight(2)
	dgp_SideMenu_Backup_Seperater:SetPoint("TOPLEFT", 7, -340)

	-- Size and position the filter editbox label (Left of the filter editbox)
	dgp_Parent = dgp_SideMenu_Backup_Dropbox_Label:GetParent()
	dgp_SideMenu_Backup_Dropbox_Label:SetWidth(150)
	dgp_SideMenu_Backup_Dropbox_Label:SetHeight(25)
	dgp_SideMenu_Backup_Dropbox_Label:SetPoint("TOPLEFT", 0, -345)
			
	-- Size and position the side frame backup dropbox
	dgp_Parent = dgp_SideMenu_Backup_Dropbox:GetParent()
	UIDropDownMenu_SetWidth(dgp_SideMenu_Backup_Dropbox, 50)
	UIDropDownMenu_SetButtonWidth(dgp_SideMenu_Backup_Dropbox, 50)
	dgp_SideMenu_Backup_Dropbox:SetWidth(dgp_Button_Backup:GetWidth())
	dgp_SideMenu_Backup_Dropbox:SetHeight(25)
	dgp_SideMenu_Backup_Dropbox:SetPoint("TOPLEFT", 135, -345)
		
	-- Size and position the side frame compare button
	dgp_Parent = dgp_SideMenu_Compare_Button:GetParent()
	dgp_SideMenu_Compare_Button:SetWidth(dgp_Button_Backup:GetWidth())
	dgp_SideMenu_Compare_Button:SetHeight(16)
	dgp_SideMenu_Compare_Button:SetPoint("TOPLEFT", 25, -375)
		
	-- Size and position the side frame restore button
	dgp_Parent = dgp_SideMenu_Restore_Button:GetParent()
	dgp_SideMenu_Restore_Button:SetWidth(dgp_Button_Backup:GetWidth())
	dgp_SideMenu_Restore_Button:SetHeight(16)
	dgp_SideMenu_Restore_Button:SetPoint("TOPLEFT", dgp_Parent:GetWidth() - dgp_SideMenu_Restore_Button:GetWidth() - 25, -375)
		
	-- Size and position the Restore Confirmation box
	dgp_Parent = dgp_SideMenu_Confirm_Restore:GetParent()
	dgp_SideMenu_Confirm_Restore:SetWidth(dgp_Parent:GetWidth() - 50)
	dgp_SideMenu_Confirm_Restore:SetHeight(100)
	dgp_SideMenu_Confirm_Restore:SetPoint("BOTTOMLEFT",  dgp_Parent:GetWidth()/2 - dgp_SideMenu_Confirm_Restore:GetWidth()/2,
	dgp_Parent:GetHeight()/2 - dgp_SideMenu_Confirm_Restore:GetHeight()/2)
			
		-- Size and position the Restore Confirmation box
		dgp_Parent = dgp_SideMenu_Confirm_Restore_Title:GetParent()
		dgp_SideMenu_Confirm_Restore_Title:SetWidth(dgp_Parent:GetWidth() - 50)
		dgp_SideMenu_Confirm_Restore_Title:SetHeight(dgp_Parent:GetHeight() - 50)
		dgp_SideMenu_Confirm_Restore_Title:SetPoint("TOPLEFT",  25, 0)
		
		-- Size and position the Restore Confirmation Accept button
		dgp_Parent = dgp_SideMenu_Confirm_Restore_Accept:GetParent()
		dgp_SideMenu_Confirm_Restore_Accept:SetWidth(100)
		dgp_SideMenu_Confirm_Restore_Accept:SetHeight(16)
		dgp_SideMenu_Confirm_Restore_Accept:SetPoint("TOPLEFT",  dgp_Parent:GetWidth()/2 - 50, -40)
		
		-- Size and position the Restore Confirmation Accept button
		dgp_Parent = dgp_SideMenu_Confirm_Restore_Cancel:GetParent()
		dgp_SideMenu_Confirm_Restore_Cancel:SetWidth(100)
		dgp_SideMenu_Confirm_Restore_Cancel:SetHeight(16)
		dgp_SideMenu_Confirm_Restore_Cancel:SetPoint("TOPLEFT",  dgp_Parent:GetWidth()/2 - 50, -60)
		
end -- dgpResizeSideMenuBackup


-- Delayed function call (http://www.wowwiki.com/Wait - Modified to add a cancel option, notes and more descriptive variables)
function dgp_wait(delay, func, ...) -- Args are Delay in seconds, function to call and any additional arguments
	-- If the delay isn't a number or the func isn't a functions then do nothing
	if(type(delay)~="number" or type(func)~="function") then
		return false;
	end
	
	-- If there is no wait frame
	if(waitFrame == nil) then
		-- Then create a new wait frame
		waitFrame = CreateFrame("Frame","WaitFrame", UIParent);
		-- Attached a function to the frame that is triggered on frame updates
		waitFrame:SetScript("onUpdate",function (self,elapse)
			local count = #waitTable; -- Retrieve the number of items in the table
			local i = 1; -- Generic counter
			while(i<=count) do -- Cycle through the items in the table
				local waitRecord = tremove(waitTable,i); -- Pull out the current record
				local dgpDelay = tremove(waitRecord,1); -- Retrieve the remaining delay time from the record
				local dgpFunction = tremove(waitRecord,1); -- Retrieve the function name from the record
				local dgpArguments = tremove(waitRecord,1); -- Retreve the args from the record
				if(dgpDelay>elapse) then -- If the delay hasn't elapsed yet
					tinsert(waitTable,i,{dgpDelay-elapse,dgpFunction,dgpArguments}); -- Insert the item back into the wait table with a lowered delay time
					i = i + 1;
				else -- If the delay has elapsed
					count = count - 1; -- One less item in the wait table
					dgpFunction(unpack(dgpArguments)); -- Call the function with the provided arguments
				end -- end if
			end -- end while
		end); -- end function
	end -- end if
	
	-- Check if the delay is 0 (cancel function(s))
	if(delay == 0) then
		count = #waitTable; -- Retrieve the number of items in the table
		i = 1; -- Generic counter
		while(i<=count) do -- Cycle through the items in the table
			waitRecord = tremove(waitTable,i); -- Pull out the current record
			dgpDelay = tremove(waitRecord,1); -- Retrieve the remaining delay time from the record
			dgpFunction = tremove(waitRecord,1); -- Retrieve the function name from the record
			dgpArguments = tremove(waitRecord,1); -- Retreve the args from the record
			if(func == dgpFunction) then -- If the function matches the item
				count = count - 1; -- One less item in the wait table
			else -- If the function does not match
				tinsert(waitTable,i,{dgpDelay,dgpFunction,dgpArguments}); -- Insert the item back into the wait table
				i = i + 1;
			end -- end if
		end -- end while
	else
		tinsert(waitTable,{delay,func,{...}}); -- Insert the provided details into the wait table
	end -- end if
	
	return true;
end -- dgp_wait


-- This is to show the addon windows
function dgpShow()
	dgpFadeIn() -- Remove the main fade frame
	dgp_Confirm_Backup:Hide() -- Make sure the backup confirmation window is not active
	dgpSideMenuFadeIn() -- Remove the side fade frame
	dgp_SideMenu_Confirm_Restore:Hide() -- Make sure the restore confirmation window is not active	
	dgp_SideMenu_Confirm_Remove_Honorary:Hide() -- Make sure the remove honorary confirmation window is not active	
	dgpHideSideMenu() -- Make sure the side frame is hidden
	
	GuildRoster() -- Refresh the guild roster
	dgpFilterPlayers() -- Update the filters
	dgpUpdateList() -- Update the filter list
	dgp_Frame:Show() -- Show the addon window
end -- dgpShow


-- This is to hide the addon window
function dgpHide()
	dgpFadeIn() -- Remove the main fade frame
	dgp_Confirm_Backup:Hide() -- Make sure the backup confirmation window is not active
	dgpSideMenuFadeIn() -- Remove the side fade frame
	dgp_SideMenu_Confirm_Restore:Hide() -- Make sure the restore confirmation window is not active	
	dgp_SideMenu_Confirm_Remove_Honorary:Hide() -- Make sure the remove honorary confirmation window is not active	
	dgpHideSideMenu() -- Make sure the side frame is hidden
	
	GuildRoster() -- Refresh the guild roster
	dgp_Frame:Hide() -- Hide the addon window
end -- dgpHide


-- This show the side menu
function dgpShowSideMenu()
	dgp_SideMenu_Confirm_Restore:Hide() -- Make sure the restore confirmation window is not active
	dgp_SideMenu_Confirm_Remove_Honorary:Hide() -- Make sure the remove honorary confirmation window is not active	
	dgp_Side_Frame:Show() -- Show the frame
	dgpCancelChanges() -- Reset the buttons
	
	dgp_SideMenu_Visible = 1 -- Indicate the menu is showing
	
	-- If you are the guild leader
	if (IsGuildLeader() == 1) then
		dgpSideMenuFadeIn() -- Remove the fade frame
	else
		dgpSideMenuFadeOut() -- Fade out the side frame
	end -- end if
end --dgpShowSideMenu


-- This hides the side menu
function dgpHideSideMenu()
	dgpSideMenuFadeIn() -- Remove the side fade frame
	dgp_SideMenu_Confirm_Restore:Hide() -- Make sure the restoreconfirmation window is not active
	dgp_SideMenu_Confirm_Remove_Honorary:Hide() -- Make sure the remove honorary confirmation window is not active	
	dgpCancelChanges() -- Reset the buttons
	dgp_Side_Frame:Hide() -- Hide the frame
	
	dgp_SideMenu_Visible = 0 -- Indicate the menu is hidden
end --dgpHideSideMenu


-- This toggles the movement of the parent frame
function dgp_Toggle_Move()
	if dgp_Frame_IsMoving then -- If the frame is flagged as  moving
		dgp_Frame:StopMovingOrSizing() -- Stop moving the main frame
		dgp_Frame_IsMoving = false -- Flag the frame is no longer moving	
		DGPLeftOffset = dgp_Frame:GetLeft() -- Set the new horizontal position
		DGPBottomOffset = dgp_Frame:GetBottom() -- Set the new vertical position
	else -- If the frame is flagged as not moving
		dgp_Frame:StartMoving() -- Start moving the main frame
		dgp_Frame_IsMoving = true -- Flag the frame is now moving	
	end -- If dgp_Frame_IsMoving
end -- dgp_Toggle_Move


 -- Backup the guild public notes (used for storing Guild Points)
function dgpBackup()
	local counter = 1 -- Variable for counting
	
	GuildRoster() -- Refresh the guild roster
	
	-- Clear the last backup and store it in a temporary variable (To avoid a memory loss as tables aren't deleted till the game quits)
	wipe(DGPBackupNum5)
	local tempBackup = DGPBackupNum5
	-- Move all previous backups along the chain and delete the oldest
	DGPBackupNum5 = DGPBackupNum4
	DGPBackupNum4 = DGPBackupNum3
	DGPBackupNum3 = DGPBackupNum2
	DGPBackupNum2 = DGPBackupNum1
	
	SetGuildRosterShowOffline(true) -- Make sure offline members are shown
	
	local numMembers = GetNumGuildMembers() -- Retrieve the number of guild members (online number not required)
	
	-- Create a new backup in the first loctation
	
	DGPBackupNum1 = tempBackup -- Reuse the discarded table
	
	-- Cycle through all players in the guild
	while counter <= numMembers do
	
		-- Retrieve the players guild details up to officer note
		local name, rank, rankIndex, level, class, zone, note, officernote = GetGuildRosterInfo(counter)
		
		-- Make sure there is a note already
		if note == "" then -- If not...
			note = "GP: 0"
			if CanEditPublicNote() then
				GuildRosterSetPublicNote(counter, note) -- Then set one
			end -- endif
		end -- endif
		
		
		local currentPoints = tonumber( strsub(note, 5) ) -- Issolate the points form the player's note
		if not currentPoints then -- If the current note was invalid.
			note = "GP: 0"
			if CanEditPublicNote() then
				GuildRosterSetPublicNote(counter, note) -- Set the note to 0
			end -- endif
		end -- end if
			
		DGPBackupNum1[name] = note -- Store the GP in the table by name
		
		counter = counter + 1
	end -- While loop
	
	DGPBackupNum1.date = date("%d/%m/20%y at %H:%M:%S") -- Add a date to the table
	
	-- Notify the user that the backup was successful and of the backups that are present
	print("Backup successful")
	print("Current backups:")
	print(DGPBackupNum1.date)
	print(DGPBackupNum2.date)
	print(DGPBackupNum3.date)
	print(DGPBackupNum4.date)
	print(DGPBackupNum5.date)	
	
	-- Refresh the addon incase there were changes
	dgp_wait(1, dgpShow)
end -- dgpBackup


-- Confirm before restoring
function dgpConfirmRestore()
	dgpSideMenuFadeOut() -- Fade out the side frame

	dgp_SideMenu_Confirm_Restore_Title.text:SetText("Restore Backup #" .. UIDropDownMenu_GetSelectedID(dgp_SideMenu_Backup_Dropbox) .. "?" ) -- Adjust the question
	
	dgp_SideMenu_Confirm_Restore:Show() -- Show the confirmation box
	
end -- End dgpConfirmRestore

-- Restore one of the 5 backups, determined by the argument passed to the function
function dgpRestore(num)
	local backupTable = {} -- variable to hold the data being restored
	local counter = 1 -- Variable for counting
	
	GuildRoster() -- Refresh the guild roster
	
	-- Make sure the player can edit public notes
	if CanEditPublicNote() then
	else
		-- Inform user that they cannot edit GP and stop the restore
		print("Unable to edit GP notes")
		return
	end -- endif
	
	-- Determine which backup to restore
	if	num == 1 then
		backupTable = DGPBackupNum1
	elseif	num == 2 then
		backupTable = DGPBackupNum2
	elseif	num == 3 then
		backupTable = DGPBackupNum3
	elseif	num == 4 then
		backupTable = DGPBackupNum4
	elseif num == 5 then
		backupTable = DGPBackupNum5
	else -- no valid backup number given
		print("Restore NOT successful")
		return
	end -- endif
	
	-- If there was a valid backup chosen then brgin the restore
	if backupTable == {} then
	else
		print("Restoring backup " .. backupTable.date) -- Inform the user which backup date has been chosen
		
		SetGuildRosterShowOffline(true) -- Make sure offline members are shown
	
		local numMembers = GetNumGuildMembers() -- Retrieve the number of guild members (online number not required)
		
		-- Cycle through all players in the guild
		while counter <= numMembers do
	
			-- Retrieve the players guild details up to officer note
			local name, rank, rankIndex, level, class, zone, note, officernote = GetGuildRosterInfo(counter)
			
			-- Check that the name is in the backup
			if backupTable[name] == nil then -- If it isn't...
				GuildRosterSetPublicNote(counter, "GP: 0") -- Set the Guild Points to 0
			else -- If it is...
				-- Check if there is any difference between the bacjup and the current GP
				if note == backupTable[name] then 
				else -- If there is...
					print(name .. ": " .. note .. " replaced with " .. backupTable[name]) -- Inform the user of the change that is to be made
					GuildRosterSetPublicNote(counter, backupTable[name]) -- Restore the GP
				end -- endif
			end -- endif
			
			counter = counter + 1
		end -- While loop
		print("Restore successful to " .. backupTable.date) -- Report which backup was successfully restored
	end -- endif
end -- dgpRestore


-- Compare the current GP with the requested backup
function dgpCompare(num)
	local backupTable = {} -- variable to hold the data being compared
	local currentTable = {} -- variable to hold all current guild members
	local counter = 1 -- Variable for counting
	
	GuildRoster() -- Refresh the guild roster
	
	-- Determine which backup to compare
	if	num == 1 then
		backupTable = DGPBackupNum1
	elseif	num == 2 then
		backupTable = DGPBackupNum2
	elseif	num == 3 then
		backupTable = DGPBackupNum3
	elseif	num == 4 then
		backupTable = DGPBackupNum4
	elseif num == 5 then
		backupTable = DGPBackupNum5
	else -- no valid backup number given
		print("No comparison available")
		return
	end -- endif
	
	-- If there was a valid backup chosen then begin the comparison
	if backupTable == {} then
	else
		print("Comparing with backup " .. backupTable.date) -- Inform the user which backup date has been chosen
		
		SetGuildRosterShowOffline(true) -- Make sure offline members are shown
	
		local numMembers = GetNumGuildMembers() -- Retrieve the number of guild members (online number not required)
		
		-- Cycle through all players in the guild
		while counter <= numMembers do
	
			-- Retrieve the players guild details up to officer note
			local name, rank, rankIndex, level, class, zone, note, officernote = GetGuildRosterInfo(counter)
			
			-- Mark the player as a current guild member
			currentTable[name] = 1
			
			-- Check that the name is in the backup
			if backupTable[name] == nil then -- If it isn't...
				print(name .. " is new to the guild")
			else -- If it is...
				-- Check if there is any difference between the backup and the current GP
				if note == backupTable[name] then 
				else -- If there is...
					print(name .. ": " .. backupTable[name] .. " -> " .. note) -- Inform the user of the change since the backup
				end -- endif
			end -- endif
			
			counter = counter + 1
		end -- While loop
		
		-- Add selected honorary guild members also
		foreach(backupTable, function(dgp_name, dgp_note)
			if ( not (dgp_name == "date")) then
				-- Check if the backup entry is an honorary guild member or guild member
				if ( not (DGPHonoraryGuildMembers[dgp_name] or currentTable[dgp_name]) ) then
					-- If not then report they have left the guild
					print(dgp_name .. " is no longer in the guild")
				end -- end if
			end -- end if
		end) -- End foreach
		
		print("Comparison with backup " .. backupTable.date .. " completed")
	end -- endif
end -- dgpCompare


-- Clear the focus on the filter editbox
function dgpClearFilterFocus()
	dgp_Filter_Editbox:ClearFocus()
end --dgpClearFilterFocus


-- Clear the focus on the filter editbox
function dgpClearGPFocus()
	dgp_Editbox_GP:ClearFocus()
end --dgpClearFilterFocus


-- Change the selected menu item in the dropbox menu
function dgpFilterDropboxChangeValue(dgpFilterDropboxValue)
	UIDropDownMenu_SetSelectedValue(dgp_Filter_Dropbox, dgpFilterDropboxValue) 
end --dgpFilterDropboxChangeValue

-- Change the selected menu items in the side frame dropboxes
function dgpSideMenuDropbox1ChangeValue(dgpSideMenuDropbox1Value)
	UIDropDownMenu_SetSelectedValue(dgp_SideMenu_Dropbox1, dgpSideMenuDropbox1Value) 
end
function dgpSideMenuDropbox2ChangeValue(dgpSideMenuDropbox2Value)
	UIDropDownMenu_SetSelectedValue(dgp_SideMenu_Dropbox2, dgpSideMenuDropbox2Value) 
end
function dgpSideMenuDropbox3ChangeValue(dgpSideMenuDropbox3Value)
	UIDropDownMenu_SetSelectedValue(dgp_SideMenu_Dropbox3, dgpSideMenuDropbox3Value) 
end
function dgpSideMenuDropbox4ChangeValue(dgpSideMenuDropbox4Value)
	UIDropDownMenu_SetSelectedValue(dgp_SideMenu_Dropbox4, dgpSideMenuDropbox4Value) 
end
function dgpSideMenuDropbox5ChangeValue(dgpSideMenuDropbox5Value)
	UIDropDownMenu_SetSelectedValue(dgp_SideMenu_Dropbox5, dgpSideMenuDropbox5Value) 
end
function dgpSideMenuDropbox6ChangeValue(dgpSideMenuDropbox6Value)
	UIDropDownMenu_SetSelectedValue(dgp_SideMenu_Dropbox6, dgpSideMenuDropbox6Value) 
end
function dgpSideMenuDropbox7ChangeValue(dgpSideMenuDropbox7Value)
	UIDropDownMenu_SetSelectedValue(dgp_SideMenu_Dropbox7, dgpSideMenuDropbox7Value) 
end
function dgpSideMenuDropbox8ChangeValue(dgpSideMenuDropbox8Value)
	UIDropDownMenu_SetSelectedValue(dgp_SideMenu_Dropbox8, dgpSideMenuDropbox8Value) 
end
function dgpSideMenuDropbox9ChangeValue(dgpSideMenuDropbox9Value)
	UIDropDownMenu_SetSelectedValue(dgp_SideMenu_Dropbox9, dgpSideMenuDropbox9Value) 
end
function dgpSideMenuDropbox10ChangeValue(dgpSideMenuDropbox10Value)
	UIDropDownMenu_SetSelectedValue(dgp_SideMenu_Dropbox10, dgpSideMenuDropbox10Value) 
end

-- Change the selected menu item in the backup selection dropbox
function dgpSideMenuBackupDropboxChangeValue(dgpBackupDropboxValue)
	UIDropDownMenu_SetSelectedValue(dgp_SideMenu_Backup_Dropbox, dgpBackupDropboxValue) 
end -- dgpSideMenuBackupDropboxChangeValue


-- Reset player type filter
function dgpResetPlayerTypeFilter()

	-- Toggle the player type filter menu on and off to allow value changes (incase a menu hasn't been clicked)
	ToggleDropDownMenu(1, nil, dgp_Filter_Dropbox, self, 0, 0);
	ToggleDropDownMenu(1, nil, dgp_Filter_Dropbox, self, 0, 0);
	
	-- Set the filter to all guild members
	UIDropDownMenu_SetSelectedValue(dgp_Filter_Dropbox, "All")
	
end -- dgpResetPlayerTypeFilter


-- Filter the selection list
function dgpFilterPlayers()
	dgp_Filtered_Guild_Members = {} -- Clear the database
	local counter = 1 -- Varible for counting
	local index = 1 -- Variable used for database indexing
	local dgpFilter = UIDropDownMenu_GetSelectedValue(dgp_Filter_Dropbox) -- Store the filter type
	local dgpFilterString = dgp_Filter_Editbox:GetText() -- Store the filter string
	
	GuildRoster() -- Refresh the guild roster
	
	SortGuildRoster("level") -- Sort the guild roster by level (to make sure the alphabetical sort isn't backwards)
	SetGuildRosterShowOffline(true) -- Make sure offline members are shown
	SortGuildRoster("name") -- Sort the guild roster by name
	
	local numMembers = GetNumGuildMembers() -- Retrieve the number of guild members (online number not required)
	
	-- Add selected players to the top of every list
	counter = 1
	index = 1
	-- Cycle through all players in the guild
	while counter <= numMembers do
	
		-- Retrieve the players guild details up to online status
		local dgp_name, dgp_rank, rankIndex, level, class, zone, dgp_note, dgp_onote = GetGuildRosterInfo(counter)
		
		-- Check if the player is also in the honorary member list
		if DGPHonoraryGuildMembers[dgp_name] then
			-- If so then merge the honorary points
			local honoraryPoints = tonumber( strsub(DGPHonoraryGuildMembers[dgp_name], 5) ) -- Issolate the points for the player
			
			if not honoraryPoints then -- If the current points are invalid.
				honoraryPoints = 0
			end -- end if
			
			local currentPoints = tonumber( strsub(dgp_note, 5) ) -- Issolate the points from the player's note
			
			if not currentPoints then -- If the current note was invalid.
				currentPoints = 0
			end -- end if
			
			local newPoints = "GP: " .. currentPoints + honoraryPoints -- Add the new points and convert it to a note
			
			GuildRosterSetPublicNote(counter, newPoints) -- Set the new points	

			dgpRemoveHonoraryMember(dgp_name)
		end -- end if
		
		if (dgp_Selected_Guild_Members[dgp_name]) then
			dgp_Filtered_Guild_Members[index] = { name = dgp_name, rank = dgp_rank, note = dgp_note, onote = dgp_onote } -- Store the current player details
			index = index + 1
		end -- endif
	
		counter = counter + 1
	end -- While loop
	
	-- Add selected honorary guild members also
	foreach(DGPHonoraryGuildMembers, function(dgp_name, dgp_note)
			if (dgp_Selected_Guild_Members[dgp_name]) then
				dgp_Filtered_Guild_Members[index] = { name = dgp_name, note = dgp_note } -- Store the current player details
				
				-- Sort the new entry alphabetically
				counter = index -- Generic counter
				while counter > 1 do
					-- Swap the entry with the previous entry until it is in alphabetical order
					if strlower(dgp_Filtered_Guild_Members[counter].name) < strlower(dgp_Filtered_Guild_Members[counter-1].name) then
						local tempMember = dgp_Filtered_Guild_Members[counter-1]
						dgp_Filtered_Guild_Members[counter-1] = dgp_Filtered_Guild_Members[counter]
						dgp_Filtered_Guild_Members[counter] = tempMember
					else
						counter = 1
					end -- end if
					counter = counter -1
				end -- end while
				
				index = index + 1
			end -- end if
		end) -- End foreach
	
	if dgpFilter == "All" then
		counter = 1
		-- Cycle through all players in the guild
		while counter <= numMembers do
	
			-- Retrieve the players guild details up to officer note
			local dgp_name, dgp_rank, rankIndex, level, class, zone, dgp_note, dgp_onote = GetGuildRosterInfo(counter)
			
			if (not dgp_Selected_Guild_Members[dgp_name]) then -- Selected players have already been added
				if dgpFilterString then -- If there is a filter string present
					if strfind(strlower(dgp_name), strlower(dgpFilterString)) then -- If the name contains the filter
						dgp_Filtered_Guild_Members[index] = { name = dgp_name, rank = dgp_rank, note = dgp_note, onote = dgp_onote } -- Then store the current player details
						index = index + 1
					end -- endif
				else -- If there is no filter string
					dgp_Filtered_Guild_Members[index] = { name = dgp_name, rank = dgp_rank, note = dgp_note, onote = dgp_onote } -- Store the current player details
					index = index + 1
				end -- endif
			end -- endif
		
			counter = counter + 1
		end -- While loop
		
		-- Cycle through all honorary members too
		foreach(DGPHonoraryGuildMembers, function(dgp_name, dgp_note)
			if (not dgp_Selected_Guild_Members[dgp_name]) then -- Selected players have already been added
				if dgpFilterString then -- If there is a filter string present
					if strfind(strlower(dgp_name), strlower(dgpFilterString)) then -- If the name contains the filter
						dgp_Filtered_Guild_Members[index] = { name = dgp_name, note = dgp_note } -- Store the current player details
						-- Sort the new entry alphabetically
						counter = index -- Generic counter
						while counter > 1 do
							-- Stop if you reach the selected members section
							if dgp_Selected_Guild_Members[dgp_Filtered_Guild_Members[counter-1].name] then
								counter = 1
							else
								-- Swap the entry with the previous entry until it is in alphabetical order
								if strlower(dgp_Filtered_Guild_Members[counter].name) < strlower(dgp_Filtered_Guild_Members[counter-1].name) then
									local tempMember = dgp_Filtered_Guild_Members[counter-1]
									dgp_Filtered_Guild_Members[counter-1] = dgp_Filtered_Guild_Members[counter]
									dgp_Filtered_Guild_Members[counter] = tempMember
								else
									counter = 1
								end -- end if
								counter = counter -1
							end -- end if
						end -- end while
				
						index = index + 1
					end -- endif
				else
					dgp_Filtered_Guild_Members[index] = { name = dgp_name, note = dgp_note } -- Store the current player details
					-- Sort the new entry alphabetically
					counter = index -- Generic counter
					while counter > 1 do
						-- Stop if you reach the selected members section
						if dgp_Selected_Guild_Members[dgp_Filtered_Guild_Members[counter-1].name] then
							counter = 1
						else
							-- Swap the entry with the previous entry until it is in alphabetical order
							if strlower(dgp_Filtered_Guild_Members[counter].name) < strlower(dgp_Filtered_Guild_Members[counter-1].name) then
								local tempMember = dgp_Filtered_Guild_Members[counter-1]
								dgp_Filtered_Guild_Members[counter-1] = dgp_Filtered_Guild_Members[counter]
								dgp_Filtered_Guild_Members[counter] = tempMember
							else
								counter = 1
							end -- end if
							counter = counter -1
						end -- end if
					end -- end while
				
					index = index + 1
				end -- end if
			end -- end if
		end) -- End foreach
	elseif dgpFilter == "Online" then
		counter = 1
		-- Cycle through all players in the guild
		while counter <= numMembers do
	
			-- Retrieve the players guild details up to online status
			local dgp_name, dgp_rank, rankIndex, level, class, zone, dgp_note, dgp_onote, dgp_online = GetGuildRosterInfo(counter)
			
			if (not dgp_Selected_Guild_Members[dgp_name]) then -- Selected players have already been added
				if (dgp_online == 1) then -- If the player is online
					if dgpFilterString then -- If there is a filter string present
						if strfind(strlower(dgp_name), strlower(dgpFilterString)) then -- If the name contains the filter
							dgp_Filtered_Guild_Members[index] = { name = dgp_name, rank = dgp_rank, note = dgp_note, onote = dgp_onote } -- Then store the current player details
							index = index + 1
						end -- endif
					else -- If there is no filter string
						dgp_Filtered_Guild_Members[index] = { name = dgp_name, rank = dgp_rank, note = dgp_note, onote = dgp_onote } -- Store the current player details
						index = index + 1
					end -- endif
				end -- endif
			end -- endif
		
			counter = counter + 1
		end -- While loop
	elseif dgpFilter == "Party" then
		counter = 1
		-- Cycle through all players in the guild
		while counter <= numMembers do
	
			-- Retrieve the players guild details up to online status
			local dgp_name, dgp_rank, rankIndex, level, class, zone, dgp_note, dgp_onote = GetGuildRosterInfo(counter)
			
			if (not dgp_Selected_Guild_Members[dgp_name]) then -- Selected players have already been added
				if (UnitInParty(dgp_name) == 1) then -- If the player is in your party/raid group
					if dgpFilterString then -- If there is a filter string present
						if strfind(strlower(dgp_name), strlower(dgpFilterString)) then -- If the name contains the filter
							dgp_Filtered_Guild_Members[index] = { name = dgp_name, rank = dgp_rank, note = dgp_note, onote = dgp_onote } -- Then store the current player details
							index = index + 1
						end -- endif
					else -- If there is no filter string
						dgp_Filtered_Guild_Members[index] = { name = dgp_name, rank = dgp_rank, note = dgp_note, onote = dgp_onote } -- Store the current player details
						index = index + 1
					end -- endif
				end -- endif
			end -- endif
		
			counter = counter + 1
		end -- While loop
		
		-- Cycle through all honorary members too
		foreach(DGPHonoraryGuildMembers, function(dgp_name, dgp_note)
			if (not dgp_Selected_Guild_Members[dgp_name]) then -- Selected players have already been added
				if dgpFilterString then -- If there is a filter string present
					if (UnitInParty(dgp_name) == 1) then -- If the player is in your party/raid group
						if strfind(strlower(dgp_name), strlower(dgpFilterString)) then -- If the name contains the filter
							dgp_Filtered_Guild_Members[index] = { name = dgp_name, note = dgp_note } -- Store the current player details
							-- Sort the new entry alphabetically
							counter = index -- Generic counter
							while counter > 1 do
								-- Stop if you reach the selected members section
								if dgp_Selected_Guild_Members[dgp_Filtered_Guild_Members[counter-1].name] then
									counter = 1
								else
									-- Swap the entry with the previous entry until it is in alphabetical order
									if strlower(dgp_Filtered_Guild_Members[counter].name) < strlower(dgp_Filtered_Guild_Members[counter-1].name) then
										local tempMember = dgp_Filtered_Guild_Members[counter-1]
										dgp_Filtered_Guild_Members[counter-1] = dgp_Filtered_Guild_Members[counter]
										dgp_Filtered_Guild_Members[counter] = tempMember
									else
										counter = 1
									end -- end if
									counter = counter -1
								end -- end if
							end -- end while
					
							index = index + 1
						end -- end if
					end -- end if
				else
					if (UnitInParty(dgp_name) == 1) then -- If the player is in your party/raid group
						dgp_Filtered_Guild_Members[index] = { name = dgp_name, note = dgp_note } -- Store the current player details
						-- Sort the new entry alphabetically
						counter = index -- Generic counter
						while counter > 1 do
							-- Stop if you reach the selected members section
							if dgp_Selected_Guild_Members[dgp_Filtered_Guild_Members[counter-1].name] then
								counter = 1
							else
								-- Swap the entry with the previous entry until it is in alphabetical order
								if strlower(dgp_Filtered_Guild_Members[counter].name) < strlower(dgp_Filtered_Guild_Members[counter-1].name) then
									local tempMember = dgp_Filtered_Guild_Members[counter-1]
									dgp_Filtered_Guild_Members[counter-1] = dgp_Filtered_Guild_Members[counter]
									dgp_Filtered_Guild_Members[counter] = tempMember
								else
									counter = 1
								end -- end if
								counter = counter -1
							end -- end if
						end -- end while
				
						index = index + 1
					end -- end if
				end -- end if
			end -- end if
		end) -- End foreach
	elseif dgpFilter == "Honorary" then
		foreach(DGPHonoraryGuildMembers, function(dgp_name, dgp_note)
			if (not dgp_Selected_Guild_Members[dgp_name]) then -- Selected players have already been added
				if dgpFilterString then -- If there is a filter string present
					if strfind(strlower(dgp_name), strlower(dgpFilterString)) then -- If the name contains the filter
						dgp_Filtered_Guild_Members[index] = { name = dgp_name, note = dgp_note } -- Store the current player details
						-- Sort the new entry alphabetically
						counter = index -- Generic counter
						while counter > 1 do
							-- Stop if you reach the selected members section
							if dgp_Selected_Guild_Members[dgp_Filtered_Guild_Members[counter-1].name] then
								counter = 1
							else
								-- Swap the entry with the previous entry until it is in alphabetical order
								if strlower(dgp_Filtered_Guild_Members[counter].name) < strlower(dgp_Filtered_Guild_Members[counter-1].name) then
									local tempMember = dgp_Filtered_Guild_Members[counter-1]
									dgp_Filtered_Guild_Members[counter-1] = dgp_Filtered_Guild_Members[counter]
									dgp_Filtered_Guild_Members[counter] = tempMember
								else
									counter = 1
								end -- end if
								counter = counter -1
							end -- end if
						end -- end while
				
						index = index + 1
					end -- endif
				else
					dgp_Filtered_Guild_Members[index] = { name = dgp_name, note = dgp_note } -- Store the current player details
					-- Sort the new entry alphabetically
					counter = index -- Generic counter
					while counter > 1 do
						-- Stop if you reach the selected members section
						if dgp_Selected_Guild_Members[dgp_Filtered_Guild_Members[counter-1].name] then
							counter = 1
						else
							-- Swap the entry with the previous entry until it is in alphabetical order
							if strlower(dgp_Filtered_Guild_Members[counter].name) < strlower(dgp_Filtered_Guild_Members[counter-1].name) then
								local tempMember = dgp_Filtered_Guild_Members[counter-1]
								dgp_Filtered_Guild_Members[counter-1] = dgp_Filtered_Guild_Members[counter]
								dgp_Filtered_Guild_Members[counter] = tempMember
							else
								counter = 1
							end -- end if
							counter = counter -1
						end -- end if
					end -- end while
				
					index = index + 1
				end -- end if
			end -- end if
		end) -- End foreach
	elseif dgpFilter == "Selected" then
		counter = 1
		-- No futher filtering required
	end -- endif	
	
	dgpUpdateSlider() -- Update the slider to match the new list size
	
end -- dgpFilterPlayers


-- Update the position of the list
function dgpUpdateList()
	local counter = 0 -- Variable for counting
	
	GuildRoster() -- Refresh the guild roster
	
	if(not dgp_Filtered_Guild_Members[dgp_List_Position]) then -- If the current position does not exist
		dgp_List_Position = 1 -- Then go to the start poisition of the list
	end -- endif
	
	while counter < 15 do -- Cycle through up to 15 players
		if(dgp_Filtered_Guild_Members[dgp_List_Position + counter]) then -- If there as a player to show	
			local playerName = dgp_Filtered_Guild_Members[dgp_List_Position + counter].name -- Store the player name
			local playerNote = dgp_Filtered_Guild_Members[dgp_List_Position + counter].note -- Store the player note
			-- Then show the appropriate button
			if counter == 0 then 
				dgp_Player_Listbox_Button1_1:Show()
				dgp_Player_Listbox_Button1_2:Show()
				dgp_Player_Listbox_Button1_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button1_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button1_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button1_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button1_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button1_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 1 then
				dgp_Player_Listbox_Button2_1:Show()
				dgp_Player_Listbox_Button2_2:Show()
				dgp_Player_Listbox_Button2_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button2_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button2_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button2_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button2_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button2_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 2 then 
				dgp_Player_Listbox_Button3_1:Show()
				dgp_Player_Listbox_Button3_2:Show()
				dgp_Player_Listbox_Button3_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button3_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button3_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button3_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button3_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button3_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 3 then 
				dgp_Player_Listbox_Button4_1:Show()
				dgp_Player_Listbox_Button4_2:Show()
				dgp_Player_Listbox_Button4_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button4_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button4_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button4_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button4_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button4_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 4 then 
				dgp_Player_Listbox_Button5_1:Show()
				dgp_Player_Listbox_Button5_2:Show()
				dgp_Player_Listbox_Button5_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button5_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button5_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button5_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button5_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button5_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 5 then  
				dgp_Player_Listbox_Button6_1:Show()
				dgp_Player_Listbox_Button6_2:Show()
				dgp_Player_Listbox_Button6_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button6_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button6_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button6_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button6_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button6_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 6 then 
				dgp_Player_Listbox_Button7_1:Show()
				dgp_Player_Listbox_Button7_2:Show()
				dgp_Player_Listbox_Button7_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button7_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button7_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button7_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button7_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button7_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 7 then 
				dgp_Player_Listbox_Button8_1:Show()
				dgp_Player_Listbox_Button8_2:Show()
				dgp_Player_Listbox_Button8_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button8_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button8_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button8_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button8_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button8_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 8 then 
				dgp_Player_Listbox_Button9_1:Show()
				dgp_Player_Listbox_Button9_2:Show()
				dgp_Player_Listbox_Button9_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button9_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button9_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button9_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button9_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button9_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 9 then 
				dgp_Player_Listbox_Button10_1:Show()
				dgp_Player_Listbox_Button10_2:Show()
				dgp_Player_Listbox_Button10_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button10_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button10_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button10_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button10_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button10_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 10 then 
				dgp_Player_Listbox_Button11_1:Show()
				dgp_Player_Listbox_Button11_2:Show()
				dgp_Player_Listbox_Button11_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button11_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button11_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button11_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button11_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button11_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 11 then 
				dgp_Player_Listbox_Button12_1:Show()
				dgp_Player_Listbox_Button12_2:Show()
				dgp_Player_Listbox_Button12_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button12_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button12_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button12_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button12_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button12_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 12 then 
				dgp_Player_Listbox_Button13_1:Show()
				dgp_Player_Listbox_Button13_2:Show()
				dgp_Player_Listbox_Button13_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button13_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button13_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button13_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button13_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button13_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 13 then 
				dgp_Player_Listbox_Button14_1:Show()
				dgp_Player_Listbox_Button14_2:Show()
				dgp_Player_Listbox_Button14_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button14_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button14_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button14_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button14_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button14_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			elseif counter == 14 then 
				dgp_Player_Listbox_Button15_1:Show()
				dgp_Player_Listbox_Button15_2:Show()
				dgp_Player_Listbox_Button15_1.text:SetText(playerName) -- Add the player name to the left button
				dgp_Player_Listbox_Button15_2.text:SetText(playerNote) -- Add the player note to the right button
				if (dgp_Selected_Guild_Members[playerName]) then -- If the player is a selected player
					dgp_Player_Listbox_Button15_1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
					dgp_Player_Listbox_Button15_2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)-- Change the button background
				else -- If the player isn't selected
					dgp_Player_Listbox_Button15_1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
					dgp_Player_Listbox_Button15_2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)-- Change the button background back
				end -- endif
			end -- endif (switch)
		else -- If there is no player to show
			-- Then hide the appropriate button
			if counter == 0 then		dgp_Player_Listbox_Button1_1:Hide()
								dgp_Player_Listbox_Button1_2:Hide()
			elseif counter == 1 then 	dgp_Player_Listbox_Button2_1:Hide()
								dgp_Player_Listbox_Button2_2:Hide()
			elseif counter == 2 then 	dgp_Player_Listbox_Button3_1:Hide()
								dgp_Player_Listbox_Button3_2:Hide()
			elseif counter == 3 then 	dgp_Player_Listbox_Button4_1:Hide()
								dgp_Player_Listbox_Button4_2:Hide()
			elseif counter == 4 then 	dgp_Player_Listbox_Button5_1:Hide()
								dgp_Player_Listbox_Button5_2:Hide()
			elseif counter == 5 then 	dgp_Player_Listbox_Button6_1:Hide()
								dgp_Player_Listbox_Button6_2:Hide()
			elseif counter == 6 then 	dgp_Player_Listbox_Button7_1:Hide()
								dgp_Player_Listbox_Button7_2:Hide()
			elseif counter == 7 then 	dgp_Player_Listbox_Button8_1:Hide()
								dgp_Player_Listbox_Button8_2:Hide()
			elseif counter == 8 then 	dgp_Player_Listbox_Button9_1:Hide()
								dgp_Player_Listbox_Button9_2:Hide()
			elseif counter == 9 then 	dgp_Player_Listbox_Button10_1:Hide()
								dgp_Player_Listbox_Button10_2:Hide()
			elseif counter == 10 then 	dgp_Player_Listbox_Button11_1:Hide()
								dgp_Player_Listbox_Button11_2:Hide()
			elseif counter == 11 then 	dgp_Player_Listbox_Button12_1:Hide()
								dgp_Player_Listbox_Button12_2:Hide()
			elseif counter == 12 then 	dgp_Player_Listbox_Button13_1:Hide()
								dgp_Player_Listbox_Button13_2:Hide()
			elseif counter == 13 then 	dgp_Player_Listbox_Button14_1:Hide()
								dgp_Player_Listbox_Button14_2:Hide()
			elseif counter == 14 then 	dgp_Player_Listbox_Button15_1:Hide()
								dgp_Player_Listbox_Button15_2:Hide()
			end -- endif (switch)
		end -- endif
		
		counter = counter + 1
	end -- While loop
	
end -- dgpUpdateList


-- Select/Deslect player for the associated button
function dgpToggleSelectPlayer(num)
	if dgp_Filtered_Guild_Members[dgp_List_Position + num -1] then -- If the button has an associated player
		local playerName = dgp_Filtered_Guild_Members[dgp_List_Position + num -1].name -- Store the associated player's name
		
		if dgp_Selected_Guild_Members[playerName] then -- If the player is already selected
			dgp_Selected_Guild_Members[playerName] = nil -- Then deselect them
			
			-- Check if the deselecting the player will create an empty space.
			-- If so then move the slider back one (if possible)
			if UIDropDownMenu_GetSelectedValue(dgp_Filter_Dropbox) == "Selected" then
				if(dgp_Player_Listbox_Slider:GetValue() > 1) then
					if(dgp_Player_Listbox_Slider:GetValue() > #(dgp_Filtered_Guild_Members) - 15) then
						dgp_Player_Listbox_Slider:SetValue(dgp_Player_Listbox_Slider:GetValue()-1)
					end --endif
				end --endif
			end -- endif
			
		else -- If the player isn't selected
			dgp_Selected_Guild_Members[playerName] = 1 -- Then select them
		end -- endif
		
		dgpFilterPlayers()
		dgpUpdateList()
	end -- endif
end -- dgpToggleSelectPlayer


-- Update the slider based on the filterbox contents
function dgpUpdateSlider()
	if(dgp_Player_Listbox_Slider:GetValue() > #(dgp_Filtered_Guild_Members) - 14) then -- If the value of the slider is too high
		dgp_Player_Listbox_Slider:SetValue(1) -- Then reset the slider to position 1
		dgp_List_Position = 1 -- Go to the start poisition of the list
	end -- endif
	
	if(#(dgp_Filtered_Guild_Members) > 15) then
		dgp_Player_Listbox_Slider:SetMinMaxValues(1, #(dgp_Filtered_Guild_Members) - 14) -- Adjust the scale to the number of players on the list
		dgp_Player_Listbox_Slider:SetValue(dgp_List_Position) -- make sure the value doesn't get changed
	else
		dgp_Player_Listbox_Slider:SetMinMaxValues(1, 1)
		dgp_List_Position = 1 -- Go to the start poisition of the list
	end -- endif
	
end -- dgpUpdateSlider

-- Toggle the selection of a modifier button
function dgpToggleSideButton(num)
	-- Check which button is to be toggled
	if num == 1 then
		-- Toggle button 1 selection, texture and adjust the multiplier
		if dgp_Button1_Toggle == 0 then
			dgp_Button1_Toggle = 1
			dgp_Side_Button1.texture:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_Point_Multiplier = dgp_Point_Multiplier * DGPButton1Value
		else
			dgp_Button1_Toggle = 0
			dgp_Side_Button1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Point_Multiplier = dgp_Point_Multiplier / DGPButton1Value
		end -- endif
	elseif num == 2 then
		-- Toggle button 2 selection, texture and adjust the multiplier
		if dgp_Button2_Toggle == 0 then
			dgp_Button2_Toggle = 1
			dgp_Side_Button2.texture:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_Point_Multiplier = dgp_Point_Multiplier * DGPButton2Value
		else
			dgp_Button2_Toggle = 0
			dgp_Side_Button2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Point_Multiplier = dgp_Point_Multiplier / DGPButton2Value
		end -- endif
	elseif num == 3 then
		-- Toggle button 3 selection, texture and adjust the multiplier
		if dgp_Button3_Toggle == 0 then
			dgp_Button3_Toggle = 1
			dgp_Side_Button3.texture:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_Point_Multiplier = dgp_Point_Multiplier * DGPButton3Value
		else
			dgp_Button3_Toggle = 0
			dgp_Side_Button3.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Point_Multiplier = dgp_Point_Multiplier / DGPButton3Value
		end -- endif
	elseif num == 4 then
		-- Toggle button 4 selection, texture and adjust the multiplier
		if dgp_Button4_Toggle == 0 then
			dgp_Button4_Toggle = 1
			dgp_Side_Button4.texture:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_Point_Multiplier = dgp_Point_Multiplier * DGPButton4Value
		else
			dgp_Button4_Toggle = 0
			dgp_Side_Button4.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Point_Multiplier = dgp_Point_Multiplier / DGPButton4Value
		end -- endif
	elseif num == 5 then
		-- Toggle button 5 selection, texture and adjust the multiplier
		if dgp_Button5_Toggle == 0 then
			dgp_Button5_Toggle = 1
			dgp_Side_Button5.texture:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_Point_Multiplier = dgp_Point_Multiplier * DGPButton5Value
		else
			dgp_Button5_Toggle = 0
			dgp_Side_Button5.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Point_Multiplier = dgp_Point_Multiplier / DGPButton5Value
		end -- endif
	elseif num == 6 then
		-- Toggle button 6 selection, texture and adjust the multiplier
		if dgp_Button6_Toggle == 0 then
			dgp_Button6_Toggle = 1
			dgp_Side_Button6.texture:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_Point_Multiplier = dgp_Point_Multiplier * DGPButton6Value
		else
			dgp_Button6_Toggle = 0
			dgp_Side_Button6.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Point_Multiplier = dgp_Point_Multiplier / DGPButton6Value
		end -- endif
	elseif num == 7 then
		-- Toggle button 7 selection, texture and adjust the multiplier
		if dgp_Button7_Toggle == 0 then
			dgp_Button7_Toggle = 1
			dgp_Side_Button7.texture:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_Point_Multiplier = dgp_Point_Multiplier * DGPButton7Value
		else
			dgp_Button7_Toggle = 0
			dgp_Side_Button7.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Point_Multiplier = dgp_Point_Multiplier / DGPButton7Value
		end -- endif
	elseif num == 8 then
		-- Toggle button 8 selection, texture and adjust the multiplier
		if dgp_Button8_Toggle == 0 then
			dgp_Button8_Toggle = 1
			dgp_Side_Button8.texture:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_Point_Multiplier = dgp_Point_Multiplier * DGPButton8Value
		else
			dgp_Button8_Toggle = 0
			dgp_Side_Button8.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Point_Multiplier = dgp_Point_Multiplier / DGPButton8Value
		end -- endif
	elseif num == 9 then
		-- Toggle button 9 selection, texture and adjust the multiplier
		if dgp_Button9_Toggle == 0 then
			dgp_Button9_Toggle = 1
			dgp_Side_Button9.texture:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_Point_Multiplier = dgp_Point_Multiplier * DGPButton9Value
		else
			dgp_Button9_Toggle = 0
			dgp_Side_Button9.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Point_Multiplier = dgp_Point_Multiplier / DGPButton9Value
		end -- endif
	elseif num == 10 then
		-- Toggle button 10 selection, texture and adjust the multiplier
		if dgp_Button10_Toggle == 0 then
			dgp_Button10_Toggle = 1
			dgp_Side_Button10.texture:SetTexture(0.1, 0.2, 1.0, 0.25)
			dgp_Point_Multiplier = dgp_Point_Multiplier * DGPButton10Value
		else
			dgp_Button10_Toggle = 0
			dgp_Side_Button10.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
			dgp_Point_Multiplier = dgp_Point_Multiplier / DGPButton10Value
		end -- endif
	end -- endif
end -- dgpToggleSideButton

-- Reset the Multiplier and untoggle the modifier buttons
function dgpResetMultipliers()
	-- Toggle off any active buttons
	if dgp_Button1_Toggle == 1 then dgpToggleSideButton(1) end
	if dgp_Button2_Toggle == 1 then dgpToggleSideButton(2) end
	if dgp_Button3_Toggle == 1 then dgpToggleSideButton(3) end
	if dgp_Button4_Toggle == 1 then dgpToggleSideButton(4) end
	if dgp_Button5_Toggle == 1 then dgpToggleSideButton(5) end
	if dgp_Button6_Toggle == 1 then dgpToggleSideButton(6) end
	if dgp_Button7_Toggle == 1 then dgpToggleSideButton(7) end
	if dgp_Button8_Toggle == 1 then dgpToggleSideButton(8) end
	if dgp_Button9_Toggle == 1 then dgpToggleSideButton(9) end
	if dgp_Button10_Toggle == 1 then dgpToggleSideButton(10) end
	
	-- Set the multiplier to 1 to make sure it reset correctly
	dgp_Point_Multiplier = 1
end -- dgpResetMultipliers

-- Add guild points to the select player(s)
function dgpAddPoints(num)
	local counter = 1 -- Variable for counting
	local numMembers = GetNumGuildMembers() -- Retrieve the number of guild members (online number not required)
	
	GuildRoster() -- Refresh the guild roster
	
	dgpFadeOut() -- Fade out the addon
	dgp_List_Position = 1 -- Scroll back to the top
	
	num = floor(num * dgp_Point_Multiplier) -- Apply the multiplier
	
	SetGuildRosterShowOffline(true) -- Make sure offline members are shown
	
	-- Cycle through all players in the guild
	while counter <= numMembers do
	
		-- Retrieve the players guild details up to note
		local dgp_name, dgp_rank, rankIndex, level, class, zone, dgp_note = GetGuildRosterInfo(counter)
		
		if dgp_Selected_Guild_Members[dgp_name] then -- If the current player is selected
			local currentPoints = tonumber( strsub(dgp_note, 5) ) -- Issolate the points form the player's note
			if not currentPoints then -- If the current note was invalid.
				currentPoints = 0
			end -- end if
			local newPoints = "GP: " .. currentPoints + num -- Add the new points and convert it back to a note
			
			GuildRosterSetPublicNote(counter, newPoints) -- Set the new points
		end --endif
	
		counter = counter + 1
	end -- While loop	
	
	-- Cycle through the selected players and check if they are honorary members
	foreach(dgp_Selected_Guild_Members, function(name, marker)
		if DGPHonoraryGuildMembers[name] then -- If the player is an honorary members
			local currentPoints = tonumber( strsub(DGPHonoraryGuildMembers[name], 5) ) -- Issolate the points for the player
			
			if not currentPoints then -- If the current note was invalid.
				currentPoints = 0
			end -- end if
			
			DGPHonoraryGuildMembers[name] = "GP: " .. currentPoints + num -- Add the new points and update the player
		end -- end if
	end)
	
	-- Update the filter list after 1 second
	dgp_wait(1, dgpFilterPlayers)
	dgp_wait(1, dgpUpdateList)
	dgp_wait(2, dgpFadeIn)
end -- dgpAddPoints


-- Remove guild points fromt he selected player(s)
function dgpSubtractPoints(num)
	local counter = 1 -- Variable for counting
	local numMembers = GetNumGuildMembers() -- Retrieve the number of guild members (online number not required)
	
	GuildRoster() -- Refresh the guild roster
	
	dgpFadeOut() -- Fade out the addon
	dgp_List_Position = 1 -- Scroll back to the top
	
	SetGuildRosterShowOffline(true) -- Make sure offline members are shown
	
	-- Cycle through all players in the guild
	while counter <= numMembers do
	
		-- Retrieve the players guild details up to note
		local dgp_name, dgp_rank, rankIndex, level, class, zone, dgp_note = GetGuildRosterInfo(counter)
		
		if dgp_Selected_Guild_Members[dgp_name] then -- If the current player is selected
			local currentPoints = tonumber( strsub(dgp_note, 5) ) -- Issolate the points form the player's note
			
			if currentPoints - num < 0 then -- Change num to stop points going below 0
				num = currentPoints
			end --endif
			
			local newPoints = "GP: " .. currentPoints - num -- Subtract the new points and convert it back to a note
			
			GuildRosterSetPublicNote(counter, newPoints) -- Set the new points
		end --endif
	
		counter = counter + 1
	end -- While loop
	
	-- Cycle through the selected players and check if they are honorary members
	foreach(dgp_Selected_Guild_Members, function(name, marker)
		if DGPHonoraryGuildMembers[name] then -- If the player is an honorary members
			local currentPoints = tonumber( strsub(DGPHonoraryGuildMembers[name], 5) ) -- Issolate the points for the player
			
			if currentPoints - num < 0 then -- Change num to stop points going below 0
				num = currentPoints
			end --endif
			
			DGPHonoraryGuildMembers[name] = "GP: " .. currentPoints - num -- Subtract the new points and update the player
		end -- end if
	end)
	
	-- Update the filter list after 1 second
	dgp_wait(1, dgpFilterPlayers)
	dgp_wait(1, dgpUpdateList)
	dgp_wait(2, dgpFadeIn)	
end -- dgpSubtractPoints

-- Hide the fading frame
function dgpFadeIn()
	GuildRoster() -- Refresh the guild roster
	dgp_Fade_Frame:SetFrameLevel(1) -- Hide the fade frame behind the rest of the addon
end -- dgpFadeIn


-- Show the fading frame, disabling all buttons beneath it
function dgpFadeOut()
	dgp_Fade_Frame:SetFrameLevel(20) -- Bring the fade frame to the front
end -- dgpFadeOut


-- Hide the side frame fading frame
function dgpSideMenuFadeIn()
	GuildRoster() -- Refresh the guild roster
	dgp_SideMenu_Fade_Frame:SetFrameLevel(1) -- Hide the fade frame behind the rest of the addon
end -- dgpFadeIn


-- Show the side frame fading frame, disabling all buttons beneath it
function dgpSideMenuFadeOut()
	dgp_SideMenu_Fade_Frame:SetFrameLevel(20) -- Bring the fade frame to the front
end -- dgpFadeOut


-- Update the button names, type and function
function dgpUpdateButtons()
	-- Button 1
	dgp_Side_Button1.text:SetText(DGPButton1Text)
	if DGPButton1Type == "Title" then -- Change the text styles, textures and functions based on button type
		dgp_Side_Button1.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
		dgp_Side_Button1.texture:SetTexture(1.0, 1.0, 1.0, 0.0)
		dgp_Side_Button1_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)		
		dgp_Side_Button1:SetScript("OnClick", function(self) end)
	elseif DGPButton1Type == "Modifier" then
		dgp_Side_Button1.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button1_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)	
		dgp_Side_Button1:SetScript("OnClick", function(self) dgpToggleSideButton(1) end)
	elseif DGPButton1Type == "Adder" then
		dgp_Side_Button1.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button1.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button1_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)	
		dgp_Side_Button1:SetScript("OnClick", function(self) dgpAddPoints(DGPButton1Value) end)
	end -- end if
	
	-- Button 2
	dgp_Side_Button2.text:SetText(DGPButton2Text) -- Set the button's text
	if DGPButton2Type == "Title" then -- Change the text styles, textures and functions based on button type
		dgp_Side_Button2.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
		dgp_Side_Button2.texture:SetTexture(1.0, 1.0, 1.0, 0.0)	
		dgp_Side_Button2_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)		
		dgp_Side_Button2:SetScript("OnClick", function(self) end)
	elseif DGPButton2Type == "Modifier" then
		dgp_Side_Button2.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button2_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)	
		dgp_Side_Button2:SetScript("OnClick", function(self) dgpToggleSideButton(2) end)
	elseif DGPButton2Type == "Adder" then
		dgp_Side_Button2.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button2.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button2_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)	
		dgp_Side_Button2:SetScript("OnClick", function(self) dgpAddPoints(DGPButton2Value) end)
	end -- end if
	
	-- Button 3
	dgp_Side_Button3.text:SetText(DGPButton3Text) -- Set the button's text
	if DGPButton3Type == "Title" then -- Change the text styles, textures and functions based on button type
		dgp_Side_Button3.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
		dgp_Side_Button3.texture:SetTexture(1.0, 1.0, 1.0, 0.0)	
		dgp_Side_Button3_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)		
		dgp_Side_Button3:SetScript("OnClick", function(self) end)
	elseif DGPButton3Type == "Modifier" then
		dgp_Side_Button3.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button3.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button3_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)	
		dgp_Side_Button3:SetScript("OnClick", function(self) dgpToggleSideButton(3) end)
	elseif DGPButton3Type == "Adder" then
		dgp_Side_Button3.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button3.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button3_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)	
		dgp_Side_Button3:SetScript("OnClick", function(self) dgpAddPoints(DGPButton3Value) end)
	end -- end if
	
	-- Button 4
	dgp_Side_Button4.text:SetText(DGPButton4Text) -- Set the button's text
	if DGPButton4Type == "Title" then -- Change the text styles, textures and functions based on button type
		dgp_Side_Button4.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
		dgp_Side_Button4.texture:SetTexture(1.0, 1.0, 1.0, 0.0)	
		dgp_Side_Button4_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)		
		dgp_Side_Button4:SetScript("OnClick", function(self) end)
	elseif DGPButton4Type == "Modifier" then
		dgp_Side_Button4.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button4.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button4_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)	
		dgp_Side_Button4:SetScript("OnClick", function(self) dgpToggleSideButton(4) end)
	elseif DGPButton4Type == "Adder" then
		dgp_Side_Button4.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button4.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button4_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)	
		dgp_Side_Button4:SetScript("OnClick", function(self) dgpAddPoints(DGPButton4Value) end)
	end -- end if
	
	-- Button 5
	dgp_Side_Button5.text:SetText(DGPButton5Text) -- Set the button's text
	if DGPButton5Type == "Title" then -- Change the text styles, textures and functions based on button type
		dgp_Side_Button5.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
		dgp_Side_Button5.texture:SetTexture(1.0, 1.0, 1.0, 0.0)	
		dgp_Side_Button5_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)		
		dgp_Side_Button5:SetScript("OnClick", function(self) end)
	elseif DGPButton5Type == "Modifier" then
		dgp_Side_Button5.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button5.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button5_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)	
		dgp_Side_Button5:SetScript("OnClick", function(self) dgpToggleSideButton(5) end)
	elseif DGPButton5Type == "Adder" then
		dgp_Side_Button5.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button5.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button5_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)	
		dgp_Side_Button5:SetScript("OnClick", function(self) dgpAddPoints(DGPButton5Value) end)
	end -- end if
	
	-- Button 6
	dgp_Side_Button6.text:SetText(DGPButton6Text) -- Set the button's text
	if DGPButton6Type == "Title" then -- Change the text styles, textures and functions based on button type
		dgp_Side_Button6.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
		dgp_Side_Button6.texture:SetTexture(1.0, 1.0, 1.0, 0.0)	
		dgp_Side_Button6_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)		
		dgp_Side_Button6:SetScript("OnClick", function(self) end)
	elseif DGPButton6Type == "Modifier" then
		dgp_Side_Button6.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button6.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button6_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)	
		dgp_Side_Button6:SetScript("OnClick", function(self) dgpToggleSideButton(6) end)
	elseif DGPButton6Type == "Adder" then
		dgp_Side_Button6.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button6.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button6_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)	
		dgp_Side_Button6:SetScript("OnClick", function(self) dgpAddPoints(DGPButton6Value) end)
	end -- end if
	
	-- Button 7
	dgp_Side_Button7.text:SetText(DGPButton7Text) -- Set the button's text
	if DGPButton7Type == "Title" then -- Change the text styles, textures and functions based on button type
		dgp_Side_Button7.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
		dgp_Side_Button7.texture:SetTexture(1.0, 1.0, 1.0, 0.0)	
		dgp_Side_Button7_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)		
		dgp_Side_Button7:SetScript("OnClick", function(self) end)
	elseif DGPButton7Type == "Modifier" then
		dgp_Side_Button7.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button7.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button7_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)
		dgp_Side_Button7:SetScript("OnClick", function(self) dgpToggleSideButton(7) end)
	elseif DGPButton7Type == "Adder" then
		dgp_Side_Button7.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button7.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button7_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)	
		dgp_Side_Button7:SetScript("OnClick", function(self) dgpAddPoints(DGPButton7Value) end)
	end -- end if
	
	-- Button 8
	dgp_Side_Button8.text:SetText(DGPButton8Text) -- Set the button's text
	if DGPButton8Type == "Title" then -- Change the text styles, textures and functions based on button type
		dgp_Side_Button8.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
		dgp_Side_Button8.texture:SetTexture(1.0, 1.0, 1.0, 0.0)	
		dgp_Side_Button8_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)		
		dgp_Side_Button8:SetScript("OnClick", function(self) end)
	elseif DGPButton8Type == "Modifier" then
		dgp_Side_Button8.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button8.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button8_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)	
		dgp_Side_Button8:SetScript("OnClick", function(self) dgpToggleSideButton(8) end)
	elseif DGPButton8Type == "Adder" then
		dgp_Side_Button8.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button8.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button8_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)	
		dgp_Side_Button8:SetScript("OnClick", function(self) dgpAddPoints(DGPButton8Value) end)
	end -- end if
	
	-- Button 9
	dgp_Side_Button9.text:SetText(DGPButton9Text) -- Set the button's text
	if DGPButton9Type == "Title" then -- Change the text styles, textures and functions based on button type
		dgp_Side_Button9.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
		dgp_Side_Button9.texture:SetTexture(1.0, 1.0, 1.0, 0.0)	
		dgp_Side_Button9_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)		
		dgp_Side_Button9:SetScript("OnClick", function(self) end)
	elseif DGPButton9Type == "Modifier" then
		dgp_Side_Button9.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button9.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button9_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)	
		dgp_Side_Button9:SetScript("OnClick", function(self) dgpToggleSideButton(9) end)
	elseif DGPButton9Type == "Adder" then
		dgp_Side_Button9.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button9.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button9_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)	
		dgp_Side_Button9:SetScript("OnClick", function(self) dgpAddPoints(DGPButton9Value) end)
	end -- end if
	
	-- Button 10
	dgp_Side_Button10.text:SetText(DGPButton10Text) -- Set the button's text
	if DGPButton10Type == "Title" then -- Change the text styles, textures and functions based on button type
		dgp_Side_Button10.text:SetTextColor(0.41, 0.80, 0.94, 1.0)
		dgp_Side_Button10.texture:SetTexture(1.0, 1.0, 1.0, 0.0)	
		dgp_Side_Button10_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)		
		dgp_Side_Button10:SetScript("OnClick", function(self) end)
	elseif DGPButton10Type == "Modifier" then
		dgp_Side_Button10.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button10.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button10_Pushed:SetTexture(0.1, 0.2, 1.0, 0.0)	
		dgp_Side_Button10:SetScript("OnClick", function(self) dgpToggleSideButton(10) end)
	elseif DGPButton10Type == "Adder" then
		dgp_Side_Button10.text:SetTextColor(1.0, 0.82, 0, 1.0)
		dgp_Side_Button10.texture:SetTexture(1.0, 1.0, 1.0, 0.1)
		dgp_Side_Button10_Pushed:SetTexture(0.1, 0.2, 1.0, 0.25)	
		dgp_Side_Button10:SetScript("OnClick", function(self) dgpAddPoints(DGPButton10Value) end)
	end -- end if
end -- dgpUpdateButtons

-- Set the buttons back to default settings
function dgpDefaultSettings()
	-- Set all buttons back to default settings
	DGPButton1Text = "Modifiers"
	DGPButton1Type = "Title"
	DGPButton1Value = 0
	
	DGPButton2Text = "Full Guild"
	DGPButton2Type = "Modifier"
	DGPButton2Value = 2
	
	DGPButton3Text = "Groups"
	DGPButton3Type = "Title"
	DGPButton3Value = 0
	
	DGPButton4Text = "Scenario"
	DGPButton4Type = "Adder"
	DGPButton4Value = 5
	
	DGPButton5Text = "Dungeon"
	DGPButton5Type = "Adder"
	DGPButton5Value = 10
	
	DGPButton6Text = "Old Raid"
	DGPButton6Type = "Adder"
	DGPButton6Value = 25
	
	DGPButton7Text = "LFR Boss"
	DGPButton7Type= "Adder"
	DGPButton7Value = 25
	
	DGPButton8Text = "Raid Boss"
	DGPButton8Type = "Adder"
	DGPButton8Value = 50
	
	DGPButton9Text = "Other"
	DGPButton9Type = "Title"
	DGPButton9Value = 0
	
	DGPButton10Text = "Invites"
	DGPButton10Type = "Adder"
	DGPButton10Value = 10
	
	DGPLastUpdateTime = "0"
	DGPUpdateOriginator = dgpPlayerName
	
	-- Update the Guild Master frame
	dgpUpdateButtons()
	dgpCancelChanges()
	
	-- Reset the multipliers
	dgpResetMultipliers()
	
	-- Send an update check message
	dgpUpdateCheck()
end -- dgpDefaultSettings

-- Cancel changes to buttons
function dgpCancelChanges()
	-- Toggle the first menu on and off to allow value changes (incase a menu hasn't been clicked)
	ToggleDropDownMenu(1, nil, dgp_SideMenu_Dropbox1, self, 0, 0);
	ToggleDropDownMenu(1, nil, dgp_SideMenu_Dropbox1, self, 0, 0);
	
	-- Set the dropboxes to the current settings
	dgpSideMenuDropbox1ChangeValue(DGPButton1Type)
	dgpSideMenuDropbox2ChangeValue(DGPButton2Type)
	dgpSideMenuDropbox3ChangeValue(DGPButton3Type)
	dgpSideMenuDropbox4ChangeValue(DGPButton4Type)
	dgpSideMenuDropbox5ChangeValue(DGPButton5Type)
	dgpSideMenuDropbox6ChangeValue(DGPButton6Type)
	dgpSideMenuDropbox7ChangeValue(DGPButton7Type)
	dgpSideMenuDropbox8ChangeValue(DGPButton8Type)
	dgpSideMenuDropbox9ChangeValue(DGPButton9Type)
	dgpSideMenuDropbox10ChangeValue(DGPButton10Type)
	
	-- Set the editbox content to the current settings
	dgp_Side_Frame_Editbox1_1:SetText(DGPButton1Text)
	dgp_Side_Frame_Editbox1_2:SetText(DGPButton1Value)
	dgp_Side_Frame_Editbox2_1:SetText(DGPButton2Text)
	dgp_Side_Frame_Editbox2_2:SetText(DGPButton2Value)
	dgp_Side_Frame_Editbox3_1:SetText(DGPButton3Text)
	dgp_Side_Frame_Editbox3_2:SetText(DGPButton3Value)
	dgp_Side_Frame_Editbox4_1:SetText(DGPButton4Text)
	dgp_Side_Frame_Editbox4_2:SetText(DGPButton4Value)
	dgp_Side_Frame_Editbox5_1:SetText(DGPButton5Text)
	dgp_Side_Frame_Editbox5_2:SetText(DGPButton5Value)
	dgp_Side_Frame_Editbox6_1:SetText(DGPButton6Text)
	dgp_Side_Frame_Editbox6_2:SetText(DGPButton6Value)
	dgp_Side_Frame_Editbox7_1:SetText(DGPButton7Text)
	dgp_Side_Frame_Editbox7_2:SetText(DGPButton7Value)
	dgp_Side_Frame_Editbox8_1:SetText(DGPButton8Text)
	dgp_Side_Frame_Editbox8_2:SetText(DGPButton8Value)
	dgp_Side_Frame_Editbox9_1:SetText(DGPButton9Text)
	dgp_Side_Frame_Editbox9_2:SetText(DGPButton9Value)
	dgp_Side_Frame_Editbox10_1:SetText(DGPButton10Text)
	dgp_Side_Frame_Editbox10_2:SetText(DGPButton10Value)
	
end -- dgpCancelChanges

-- Apply the button changes
function dgpApplyChanges()
	
	-- Apply all the button changes
	DGPButton1Type = UIDropDownMenu_GetSelectedValue(dgp_SideMenu_Dropbox1)
	DGPButton1Text = dgp_Side_Frame_Editbox1_1:GetText()
	if DGPButton1Type == "Title" then
		DGPButton1Value = 0
	elseif dgp_Side_Frame_Editbox1_2:GetText() == "" then
		DGPButton1Value = 0	
	else
		DGPButton1Value = dgp_Side_Frame_Editbox1_2:GetText()
	end
	
	DGPButton2Type = UIDropDownMenu_GetSelectedValue(dgp_SideMenu_Dropbox2)
	DGPButton2Text = dgp_Side_Frame_Editbox2_1:GetText()
	if DGPButton2Type == "Title" then
		DGPButton2Value = 0
	elseif dgp_Side_Frame_Editbox2_2:GetText() == "" then
		DGPButton2Value = 0	
	else
		DGPButton2Value = dgp_Side_Frame_Editbox2_2:GetText()
	end
	
	DGPButton3Type = UIDropDownMenu_GetSelectedValue(dgp_SideMenu_Dropbox3)
	DGPButton3Text = dgp_Side_Frame_Editbox3_1:GetText()
	if DGPButton3Type == "Title" then
		DGPButton3Value = 0
	elseif dgp_Side_Frame_Editbox3_2:GetText() == "" then
		DGPButton3Value = 0	
	else
		DGPButton3Value = dgp_Side_Frame_Editbox3_2:GetText()
	end
	
	DGPButton4Type = UIDropDownMenu_GetSelectedValue(dgp_SideMenu_Dropbox4)
	DGPButton4Text = dgp_Side_Frame_Editbox4_1:GetText()
	if DGPButton4Type == "Title" then
		DGPButton4Value = 0
	elseif dgp_Side_Frame_Editbox4_2:GetText() == "" then
		DGPButton4Value = 0	
	else
		DGPButton4Value = dgp_Side_Frame_Editbox4_2:GetText()
	end
	
	DGPButton5Type = UIDropDownMenu_GetSelectedValue(dgp_SideMenu_Dropbox5)
	DGPButton5Text = dgp_Side_Frame_Editbox5_1:GetText()
	if DGPButton5Type == "Title" then
		DGPButton5Value = 0
	elseif dgp_Side_Frame_Editbox5_2:GetText() == "" then
		DGPButton5Value = 0	
	else
		DGPButton5Value = dgp_Side_Frame_Editbox5_2:GetText()
	end
	
	DGPButton6Type = UIDropDownMenu_GetSelectedValue(dgp_SideMenu_Dropbox6)
	DGPButton6Text = dgp_Side_Frame_Editbox6_1:GetText()
	if DGPButton6Type == "Title" then
		DGPButton6Value = 0
	elseif dgp_Side_Frame_Editbox6_2:GetText() == "" then
		DGPButton6Value = 0	
	else
		DGPButton6Value = dgp_Side_Frame_Editbox6_2:GetText()
	end
	
	DGPButton7Type = UIDropDownMenu_GetSelectedValue(dgp_SideMenu_Dropbox7)
	DGPButton7Text = dgp_Side_Frame_Editbox7_1:GetText()
	if DGPButton7Type == "Title" then
		DGPButton7Value = 0
	elseif dgp_Side_Frame_Editbox7_2:GetText() == "" then
		DGPButton7Value = 0	
	else
		DGPButton7Value = dgp_Side_Frame_Editbox7_2:GetText()
	end
	
	DGPButton8Type = UIDropDownMenu_GetSelectedValue(dgp_SideMenu_Dropbox8)
	DGPButton8Text = dgp_Side_Frame_Editbox8_1:GetText()
	if DGPButton8Type == "Title" then
		DGPButton8Value = 0
	elseif dgp_Side_Frame_Editbox8_2:GetText() == "" then
		DGPButton8Value = 0	
	else
		DGPButton8Value = dgp_Side_Frame_Editbox8_2:GetText()
	end
	
	DGPButton9Type = UIDropDownMenu_GetSelectedValue(dgp_SideMenu_Dropbox9)
	DGPButton9Text = dgp_Side_Frame_Editbox9_1:GetText()
	if DGPButton9Type == "Title" then
		DGPButton9Value = 0
	elseif dgp_Side_Frame_Editbox9_2:GetText() == "" then
		DGPButton9Value = 0	
	else
		DGPButton9Value = dgp_Side_Frame_Editbox9_2:GetText()
	end
	
	DGPButton10Type = UIDropDownMenu_GetSelectedValue(dgp_SideMenu_Dropbox10)
	DGPButton10Text = dgp_Side_Frame_Editbox10_1:GetText()
	if DGPButton10Type == "Title" then
		DGPButton10Value = 0
	elseif dgp_Side_Frame_Editbox10_2:GetText() == "" then
		DGPButton10Value = 0	
	else
		DGPButton10Value = dgp_Side_Frame_Editbox10_2:GetText()
	end
	
	-- Reset the multipliers
	dgpResetMultipliers()
	
	-- Update the buttons and update the side panel content
	dgpUpdateButtons()
	dgpCancelChanges()
	
	-- Send an update check message
	dgpUpdateCheck()
	
end -- dgpApplyChanges


-- Send an update check
function dgpUpdateCheck()
	-- Send an update check message
	SendAddonMessage("dgpCheck", "Check", "GUILD")
end -- dgpUpdateCheck


-- Cancel updates
function dgpCancelUpdate()
	-- Check the addon is being updated
	if(dgpUpdating ~= "closed") then
		dgpUpdating = "closed" -- Indicates if the addon is updating and who updates are being received from
		DGPLastUpdateTime = dgpTempUpdateTime -- Change the update time back
		dgpTempUpdateTime = "0" -- Reset the temporary update time
		DGPUpdateOriginator = dgpTempUpdateOriginator -- Change the update originator back
		dgpTempUpdateOriginator = "default" -- Reset the temporary update oroginator
	
		dgpCancelChanges() -- Cancel the button changes
		
		dgp_wait(30, dgpUpdateCheck) -- Send out a new update check
	end -- end if
end -- dgpCancelUpdate

-- Add an honorary guild member
function dgpAddHonoraryMember(newName)
	-- Add the player if they're not already an honorary member
	if not DGPHonoraryGuildMembers[newName] then
		DGPHonoraryGuildMembers[newName] = "GP: 0"
	end -- end if
	
	-- Update the filter list
	dgpFilterPlayers()
	dgpUpdateList()
end -- dgpAddHonoraryMember

-- Confirm before removing honorary members
function dgpConfirmRemoveHonorary()
	
	local dgpName = dgp_Side_Frame_Honorary_Editbox:GetText() -- Retrieve the editbox text
	local dgpTarget = UnitName("target") -- Retrieve the target's name also
	
	-- Check if a player was specified
	if not (dgpName == "") then
		-- If so also check that the player specified is a honorary member
		if DGPHonoraryGuildMembers[dgpName] then
			dgpSideMenuFadeOut() -- Fade out the side frame
			dgp_SideMenu_Confirm_Remove_Honorary_Title.text:SetText("Remove "..dgpName.."?") -- Adjust the question
			dgp_SideMenu_Confirm_Remove_Honorary:Show() -- Show the confirmation box
			dgpHonoraryRemoveType = dgpName
		end -- end if
	-- Otherwise check if a player is selected
	elseif dgpTarget then
		-- Check that the target is an honorary member
		if DGPHonoraryGuildMembers[dgpTarget] then
			dgpSideMenuFadeOut() -- Fade out the side frame
			dgp_SideMenu_Confirm_Remove_Honorary_Title.text:SetText("Remove "..dgpTarget.."?") -- Adjust the question
			dgp_SideMenu_Confirm_Remove_Honorary:Show() -- Show the confirmation box
			dgpHonoraryRemoveType = dgpTarget			
		end -- end if
	-- Otherwise check if any honorary players are selected from the list
	else
		foreach(dgp_Selected_Guild_Members, function(name, marker)
			if DGPHonoraryGuildMembers[name] then -- If the player is an honorary members
				dgpSideMenuFadeOut() -- Fade out the side frame
				dgp_SideMenu_Confirm_Remove_Honorary_Title.text:SetText("Remove Selected Members?") -- Adjust the question
				dgp_SideMenu_Confirm_Remove_Honorary:Show() -- Show the confirmation box
				dgpHonoraryRemoveType = "dgpselected"			
			end -- end if
		end)
	end -- end if
	
	
end -- End dgpConfirmRemoveHonorary

-- Remove an honorary guild member
function dgpRemoveHonoraryMember(removeName)
	if DGPHonoraryGuildMembers[removeName] then
		DGPHonoraryGuildMembers[removeName] = nil
		
		if dgp_Selected_Guild_Members[removeName] then -- If the player is selected
			dgp_Selected_Guild_Members[removeName] = nil -- Then deselect them
		end -- end if
	end -- end if
	
	-- Update the filter list
	dgpFilterPlayers()
	dgpUpdateList()
end -- dgpRemoveHonoraryMember
